<?php
namespace boru\boruai\OCR\Agents;

use boru\boruai\Models\Response;
use boru\output\Output;

class CompareAgent {
    public static $maxRetries = 3;
    public static $retryDelay = 5;

    private $retries = 0;

    private $firstPass = null;
    private $tesseract = null;

    private $reference = null;

    private static $instructions = "You will be provided two sets of OCR data. One is generated from another AI agent, and the second one is Tesseract generated OCR data.. both from the same exact file. Your job is to compare the two sets of data and provide use it to build a more complete, singular set of OCR data.
The output should be in the same format as the document data is provided to you... meaning this framed structure:

[BEGIN DOCUMENT OCR OUTPUT]

[page 1]
content here...
[end of page 1]

[page 2]
content here...
[end of page 2]

[END DOCUMENT OCR OUTPUT]

";

    private $chat;

    public function __construct($firstPass, $tesseract) {
        $this->firstPass = $firstPass;
        $this->tesseract = $tesseract;
    }

    public function init() {
        $this->chat = new Response();
        $this->chat->model("gpt-4.1");
        $this->chat->instructions(self::$instructions);
        if($this->reference) {
            $this->chat->reference($this->reference);
        }
    }

    public function run($reference=null) {
        if($reference !== null) {
            $this->reference = $reference;
        }
        $this->init();
        $result = null;
        try {
            $result = $this->runExecute();
        } catch (\Exception $e) {
            Output::outLine("[OCR] process failed for compare - exception: ".$e->getMessage());
            return $this->reTryOrReturn("[OCR FAILED - EXCEPTION: ".$e->getMessage()."]");
        }
        if($result) {
            return $result;
        } else {
            Output::outLine("[OCR] process failed for compare - no result");
            return $this->reTryOrReturn("[OCR FAILED - NO RESULT]");
        }
    }

    private function runExecute() {
        $this->init();
        $this->chat->addMessage("AI Generated OCR data :\n\n\n" . $this->firstPass);
        $this->chat->addMessage("Tesseract Generated OCR data :\n\n\n" . $this->tesseract);
        $this->chat->addMessage("Provide a combined, complete final output");
        $result =  $this->chat->create();
        if($result) {
            return $result->getResult();
        } else {
            Output::outLine("[OCR] No result returned from compare process");
            return $this->reTryOrReturn("[OCR FAILED - NO RESULT]");
        }
    }

    private function reTryOrReturn($result) {
        if($this->retries < static::$maxRetries) {
            $this->retries++;
            Output::outLine("[OCR] Retrying OCR process for compare process (Attempt ".$this->retries.")");
            sleep(static::$retryDelay);
            return $this->run();
        } else {
            Output::outLine("[OCR] Max retries reached for compare process");
            return $result;
        }
    }
}