<?php
namespace boru\boruai\Openai\Response\Parts;

use boru\boruai\Openai\Models\BaseModel;
use boru\boruai\Openai\Response\Parts\Content\Content;
use boru\boruai\Openai\Response\Parts\Content\InputFile;
use boru\boruai\Openai\Response\Parts\Content\InputImage;
use boru\boruai\Openai\Response\Parts\Content\InputText;
use boru\output\Output;

class InputMessage extends BaseModel {
    private $id;
    private $type = "message";
    private $role = "user";
    private $content;
    private $status;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function type($type=null) {
        if ($type) {
            $this->type = $type;
        }
        return $this->type;
    }
    public function role($role=null) {
        if ($role) {
            $this->role = $role;
        }
        return $this->role;
    }
    public function content($content=null) {
        if ($content) {
            $this->addMessage($content);
            //$this->content = $content;
        }
        return $this->content;
    }
    public function status($status=null) {
        if ($status) {
            $this->status = $status;
        }
        return $this->status;
    }

    public function __toString() {
        return $this->content()->output();
    }
    public function json($array=true) {
        $text = $this->content()->json($array);
        if($text) {
            return $text;
        }
        return false;
    }
    public function output() {
        $text = $this->content()->output();
        if($text) {
            return $text;
        }
        return false;
    }
    public function asJson($array=true) {
        return $this->json($array);
    }
    public function asString() {
        return $this->__toString();
    }
    public function toJson($array=true) {
        return $this->json($array);
    }
    public function toString() {
        return $this->__toString();
    }

    public function toArray() {
        $array = [
            "id" => $this->id(),
            "type" => $this->type(),
            "role" => $this->role(),
            "status" => $this->status(),
        ];
        $content = $this->content();
        if(is_array($content)) {
            $array["content"] = [];
            foreach($content as $item) {
                if($item instanceof BaseModel) {
                    $array["content"][] = $item->toArray();
                } else {
                    $array["content"][] = $item;
                }
            }
        }
        return array_filter($array, function($value) {
            return !is_null($value);
        });
    }
    public function addText($text) {
        if($text) {
            $object = new InputText(["text"=>$text]);
            $this->content[] = $object;
            return true;
        }
        return false;
    }
    public function addFile($file) {
        if($file) {
            $object = new InputFile($file);
            $this->content[] = $object;
            return true;
        }
        return false;
    }
    public function addImage($image,$detail=null) {
        if($image) {
            $object = new InputImage($image);
            if($detail) {
                $object->detail($detail);
            }
            $this->content[] = $object;
            return true;
        }
        return false;
    }
    public function addMessage($inputText,$prepend=false) {
        if(!is_array($inputText) && !is_object($inputText)) {
            $jsonTry = json_decode($inputText,true);
            if($jsonTry) {
                $inputText = $jsonTry;
            } else {
                $inputText = ["text"=>$inputText];
            }
        }
        if(!is_array($this->content)) {
            if(empty($this->content)) {
                $this->content = [];
            } else {
                $this->content = [$this->content];
            }
        }
        if(is_object($inputText)) {
            if($prepend) {
                array_unshift($this->content,$inputText);
            } else {
                $this->content[] = $inputText;
            }
            return true;
        }
        if(is_array($inputText)) {
            $isAssociative = array_keys($inputText) !== range(0, count($inputText) - 1);
            if(!$isAssociative) {
                foreach($inputText as $item) {
                    $this->addMessage($item,$prepend);
                }
                return true;
            }
            $object = Content::fromArray($inputText);
            if($object) {
                if($prepend) {
                    array_unshift($this->content,$object);
                } else {
                    $this->content[] = $object;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static function inputFromArray($input) {
        try {
            $object = Content::fromArray($input);
        }
        catch (\Exception $e) {
            return false;
        }
        if($object) {
            return $object;
        }
        return false;
    }
}