<?php
namespace boru\boruai\Cli\Defs;

use boru\boruai\BoruAI;
use boru\boruai\Models\ChatSession;
use boru\boruai\Models\Document;
use boru\boruai\Models\Queue;
use boru\cli\CLI;
use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\output\Output;
use boru\boruai\Openai\Api\Endpoints\AssistantsAPI;
use boru\boruai\Openai\OpenAIAssistant;
use boru\boruai\Openai\OpenAIChat;

trait QueueCLI {
    public static function def_queue() {
        return [
            "description"=> "Queue Actions",
            "params" => [
            ]
        ];
    }

    public static function def_queue_list() {
        return [
            "description"=> "List Queued actions",
            "params" => [
                Option::create("l|limit|The number of sessions to list",["default"=>25]),
                Option::create("o|offset|The offset to start listing from",["default"=>0]),
            ]
        ];
    }

    public function cmd_queue_list($cmd) {
        $limit = $cmd->get("limit",25);
        $offset = $cmd->get("offset",0);
        $queued = Queue::listQueue($limit,$offset);
        foreach($queued as $queueItem) {
            Output::outLine($queueItem->id()."\t".$queueItem->get("action")."\t".$queueItem->get("entity")."\t".$queueItem->get("entityid"));
        }
    }

    public static function def_queue_run() {
        return [
            "description"=> "Run queued actions",
            "params" => [
                Positional::create("action|The action to run"),
                Option::create("l|limit|The number of actions to run",["default"=>0]),
                Option::create("t|threaded|Run actions in separate threads"),
                Flag::create("v|visual|Show visual output (only if threaded)"),
            ]
        ];
    }

    public function cmd_queue_run($cmd) {
        $action = $cmd->get("action",null);
        $limit = $cmd->get("limit",0);
        $threaded = $cmd->get("threaded",false);
        $visual = $cmd->get("visual",true);
        Queue::process($action,$limit,$threaded,$visual);
    }

    public static function def_queue_clean() {
        return [
            "description"=> "Clean queued actions",
            "params" => [
                Positional::create("status|The status to clean",["options"=>["complete","success","failed","queued","processing"],"default"=>"complete"]),
            ]
        ];
    }
    public function cmd_queue_clean($cmd) {
        $status = $cmd->get("status","all");
        if($status === "complete") {
            $statusInt = null;
        } elseif($status === "success") {
            $statusInt = 2;
        } elseif($status === "failed") {
            $statusInt = 3;
        } elseif($status === "queued") {
            $statusInt = 0;
        } elseif($status === "processing") {
            $statusInt = 1;
        }
        $cleaned = Queue::clean($statusInt);
        if($cleaned) {
            Output::outLine("Cleaned",$cleaned,"actions with status",$status);
        } else {
            Output::outLine("No queued actions to clean");
        }
    }
}