<?php
namespace boru\boruai\Models;

use boru\boruai\BoruAI;
use boru\query\Query;
use boru\query\Entity;
use boru\query\models\EntityDefinition;

class PromptHistory extends Entity {
    public static function entityDefinition() {
        $tableName = BoruAI::table('templateHistory');
        return new EntityDefinition([
            "className" => static::class,
            "name" => "TemplateHistory",
            "queryBase" => Query::create()->select('*')->from($tableName),
            "createdField" => 'created_at',
        ]);
    }

    public function __construct($idOrData=null) {
        parent::__construct($idOrData);
    }

    public function createdAt($createdAt=null) {
        if($createdAt !== null) {
            $this->set("created_at",$createdAt);
        }
        return $this->get("created_at");
    }
    public function promptId($promptId=null) {
        if($promptId !== null) {
            $this->set("prompt_id",$promptId);
        }
        return $this->get("prompt_id");
    }
    public function version($version=null) {
        if($version !== null) {
            $this->set("version",$version);
        }
        return $this->get("version",0);
    }
    public function referenceType($referenceType=null) {
        if($referenceType !== null) {
            $this->set("reference_type",$referenceType);
        }
        return $this->get("reference_type");
    }
    public function referenceId($referenceId=null) {
        if($referenceId !== null) {
            $this->set("reference_id",$referenceId);
        }
        return $this->get("reference_id");
    }
    public function referenceStringId($referenceStringId=null) {
        if($referenceStringId !== null) {
            $this->set("reference_stringid",$referenceStringId);
        }
        return $this->get("reference_stringid");
    }
    public function response($response=null) {
        if($response !== null) {
            $this->set("response",$response);
        }
        return $this->get("response");
    }
    public function prompt($prompt=null) {
        if($prompt !== null) {
            $this->set("prompt",$prompt);
        }
        return $this->get("prompt");
    }
}

/*
`id` bigint(19) NOT NULL AUTO_INCREMENT,
            `created_at` datetime DEFAULT NULL,
            `prompt_id` bigint(19) DEFAULT NULL,
            `version` int(11) NOT NULL DEFAULT '0',
            `reference_type` varchar(100) DEFAULT NULL,
            `reference_id` bigint(11) NOT NULL DEFAULT '0',
            `reference_stringid` varchar(255) NOT NULL DEFAULT '',
            `response` longtext,
            `prompt` longtext,
            */