<?php
namespace boru\boruai\Openai\Api\Endpoints;

use boru\boruai\Openai\OpenAI;
use boru\dhttp\core\Response;

class BatchAPI {
    /**
     * @return ApiBaseResponse
     */
    public static function createBatch($data) {
        return OpenAI::request("post","batches",$data);
    }

    /**
     * @return ApiBaseResponse
     */
    public static function cancelBatch($batch_id) {
        return OpenAI::request("post","batches/" . $batch_id . "/cancel");
    }

    /**
     * @return ApiBaseResponse
     */
    public static function listBatch() {
        return OpenAI::requestList("get","batches");
    }

    /**
     * @return ApiBaseResponse
     */
    public static function getBatch($batch_id) {
        return OpenAI::request("get","batches/" . $batch_id);
    }
}