<?php
namespace boru\boruai\Api\Session;

use boru\boruai\Api\BaseAPI;
use boru\boruai\Models\ChatSession;
use boru\dhapi\core\Dispatcher;

class SessionDeleteAPI extends BaseAPI {

    /**
     * Deletes a chat session.
     * 
     * @param Dispatcher $api 
     * @return mixed
     */
    public function execute($api) {
        $sessionIdOrName = $api->body("session", "");
        $session = ChatSession::fromId($sessionIdOrName) ?: ChatSession::fromName($sessionIdOrName);

        if ($session) {
            $session->delete();
            return $this->success("Session deleted.");
        } else {
            return $this->error("Session not found.");
        }
    }
}
