<?php
namespace boru\boruai\Models;

use boru\boruai\Config;
use boru\dot\Dot;

class Configuration {
    private $config = [];
    private $filename = "config.json";

    public function __construct($filename=null,$config=[]) {
        $this->config = Config::defaultConfig();
        $this->filename = $filename;
        if($filename !== null) {
            $this->load($filename);
        }
        if(!empty($config)) {
            $this->merge($config);
            $this->save();
        }
    }

    public function filename($filename=null) {
        if($filename) {
            $this->filename = $filename;
        }
        return $this->filename;
    }

    public function merge($configArray=[]) {
        if(!empty($configArray)) {
            $this->config = array_replace_recursive($this->config,$configArray);
        }
        return $this->config;
    }

    public function load($filename) {
        $this->filename = $filename;
        $newConfig = [];
        if(!file_exists($filename)) {
            $this->save();
        }
        if(file_exists($filename)) {
            $newConfig = json_decode(file_get_contents($filename),true);
        }
        if(!is_array($newConfig)) {
            $newConfig = [];
        }
        $this->config = array_replace_recursive($this->config,$newConfig);
    }

    public function get($key=null,$default=null) {
        if($key === null) {
            return $this->config;
        }
        return Dot::get($this->config,$key,$default);
    }

    public function set($key, $value) {
        return Dot::set($this->config,$key,$value);
    }

    public function delete($key) {
        $before = $this->config;
        Dot::delete($this->config,$key);
        if($before !== $this->config) {
            return true;
        }
        return false;
    }

    public function save() {
        if($this->filename === null) {
            return;
        }
        file_put_contents($this->filename, json_encode($this->config, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
    }
}