<?php
namespace boru\boruai\Api\Session;

use boru\boruai\Api\BaseAPI;
use boru\boruai\Models\ChatSession;
use boru\dhapi\core\Dispatcher;

class SessionListAPI extends BaseAPI {


    public function execute() {
        $limit = $this->get("limit", 25);
        $offset = $this->get("offset", 0);

        $sessions = ChatSession::listSessions($limit, $offset);
        $sessionData = [];

        foreach ($sessions as $session) {
            $sessionData[] = [
                'id' => $session->id(),
                'name' => $session->name()
            ];
        }

        return $this->success(['sessions' => $sessionData]);
    }
}
