<?php
namespace boru\boruai\Models;

class WebSearchTool extends ToolDefinition {
    private $type = "web_search_preview";
    private $search_context_size = "medium";
    private $user_location = [];
    private $name = "WebSearchTool";

    public function __construct($type="web_search_preview", $search_context_size="medium", $user_location=[]) {
        $this->type = $type;
        $this->search_context_size = $search_context_size;
        $this->user_location = $user_location;
    }

    public function name($name=null) {
        if($name !== null) {
            $this->name = $name;
            return $this;
        }
        return $this->name;
    }

    public function type($type=null) {
        if($type !== null) {
            $this->type = $type;
            return $this;
        }
        return $this->type;
    }
    public function searchContextSize($search_context_size=null) {
        if($search_context_size !== null) {
            $this->search_context_size = $search_context_size;
            return $this;
        }
        return $this->search_context_size;
    }
    public function userLocation($user_location=null) {
        if($user_location !== null) {
            $this->user_location = $user_location;
            return $this;
        }
        return $this->user_location;
    }
    public function setCity($city) {
        if(!is_array($this->user_location)) {
            $this->user_location = [];
        }
        $this->user_location["city"] = $city;
        return $this;
    }
    public function setCountry($country) {
        if(!is_array($this->user_location)) {
            $this->user_location = [];
        }
        $this->user_location["country"] = $country;
        return $this;
    }
    public function setRegion($region) {
        if(!is_array($this->user_location)) {
            $this->user_location = [];
        }
        $this->user_location["region"] = $region;
        return $this;
    }
    public function setTimezone($timezone) {
        if(!is_array($this->user_location)) {
            $this->user_location = [];
        }
        $this->user_location["timezone"] = $timezone;
        return $this;
    }

    public function forResponse() {
        $array = [];
        $array["type"] = $this->type;
        $array["search_context_size"] = $this->search_context_size;
        if(!empty($this->user_location)) {
            $this->user_location["type"] = "approximate";
            $array["user_location"] = $this->user_location;
        }
        return $array;
    }
}