<?php
namespace boru\boruai\UI;

use boru\boruai\BoruAI;
use boru\query\Query;
use Exception;

class User {
    private static $isLoggedIn = false;
    private static $loggedUser;
    /** @var User[] */
    private static $userCache = [];
    /** @var int */
    private $userId;
    /** @var string */
    private $userName;
    /** @var \boru\dhdb\core\Row */
    private $userRow;

    public function __construct($userIdNameOrRow=null) {
        if($userIdNameOrRow) {
            if(is_array($userIdNameOrRow)) {
                $this->setFromRow($userIdNameOrRow);
                return;
            }
            if($userIdNameOrRow instanceof User) {
                $this->setFromRow($userIdNameOrRow->getUserRow());
                return;
            }
            $query = false;
            if(is_numeric($userIdNameOrRow)) {
                $query = Query::create()->select("id")->from("vtiger_users")->where("id", "=", $userIdNameOrRow);
            } elseif(is_string($userIdNameOrRow)) {
                $query = Query::create()->select("id")->from("vtiger_users")->where("user_name", "=", $userIdNameOrRow);
            }
            if(!$query) {
                throw new Exception("User: invalid userIdorRole");
            }
            foreach($query->toRows() as $row) {
                $this->setFromRow($row);
                break;
            }
        }
    }
    public function setFromRow($row) {
        if($row) {
            $this->userId = $row["id"];
            if(isset($row["user_name"])) {
                $this->userName = $row["user_name"];
            } elseif(isset($row["username"])) {
                $this->userName = $row["username"];
            } elseif(isset($row["name"])) {
                $this->userName = $row["name"];
            } else {
                $this->userName = $row["id"];
            }
            $this->userRow = $row;
            static::$userCache[$this->userId] = $this;
        }
    }
    public function get($field) {
        if($this->userRow && isset($this->userRow[$field])) {
            return $this->userRow[$field];
        }
        return false;
    }
    public function id() {
        return $this->userId;
    }
    public function name() {
        return $this->userName;
    }
    public function getUserRow() {
        return $this->userRow;
    }

    public static function login() {
        if(!self::$isLoggedIn) {
            if(WebUI::authCallback()) {
                $callback = WebUI::authCallback();
                if(is_callable($callback)) {
                    return $callback();
                } else {
                    throw new Exception("User: authCallback is not callable");
                }
                
            }
            $userid = isset($_SESSION['AUThUSERID']) ? $_SESSION['AUThUSERID'] : false;
            if(!$userid) {
                $userid = isset($_SESSION['authenticated_user_id']) ? $_SESSION['authenticated_user_id'] : false;
                if(!$userid) {
                    return false;
                }
            }
            self::$loggedUser = new User($userid);
            self::$isLoggedIn = true;
        }
        return self::$loggedUser;
    }
}