<?php
namespace boru\boruai\Openai\Api\Endpoints;

use boru\boruai\Openai\OpenAIAssistant;
use boru\boruai\Openai\OpenAI;
use Exception;

class AssistantsAPI {
    public static function create($parameters=[]) {
        //print_r($parameters);
        //exit();
        return new OpenAIAssistant(OpenAI::request("post","assistants",$parameters));
    }
    public static function listAssistants() {
        return OpenAI::requestList("get","assistants",[],OpenAIAssistant::class);
    }
    public static function getAssistant($id) {
        return new OpenAIAssistant(OpenAI::request("get","assistants/".$id));
    }
    public static function update($id,$parameters=[]) {
        return new OpenAIAssistant(OpenAI::request("post","assistants/".$id,$parameters));
    }
    public static function delete($id) {
        return OpenAI::request("delete","assistants/".$id);
    }

    /**
     * 
     * @param mixed $assistantName 
     * @return OpenAIAssistant|false 
     * @throws Exception 
     */
    public static function byName($assistantName) {
        $assistants = static::listAssistants();
        foreach($assistants as $assistant) {
            if(strtolower($assistant->name()) == strtolower($assistantName)) {
                return $assistant;
            }
        }
        return false;
    }
}