<?php
namespace boru\boruai\Openai\Api\Endpoints;

use boru\boruai\Openai\Api\Responses\ApiBaseResponse;
use boru\boruai\Openai\OpenAIThread;
use boru\boruai\Openai\Models\Run;
use boru\boruai\Openai\OpenAI;
use Exception;

class ThreadsAPI {
    public static function create($parameters=[]) {
        return new OpenAIThread(OpenAI::request("post","threads",$parameters));
    }
    public static function getThread($id) {
        return new OpenAIThread(OpenAI::request("get","threads/".$id));
    }
    public static function update($id,$parameters=[]) {
        return new OpenAIThread(OpenAI::request("post","threads/".$id,$parameters));
    }
    /**
     * 
     * @param mixed $parameters 
     * @return Run|false
     * @throws Exception 
     */
    public static function run($parameters) {
        $obj = OpenAI::request("post","threads/runs",$parameters);
        if($obj) {
            $run = new Run($obj->asArray());
            return $run;
        } else {
            return false;
        }
    }
}