<?php
namespace boru\boruai\UI\Actions;

class Ajax {
    /** @var \boru\boruai\UI\WebUI */
    private $webUI;
    /** @var \boru\boruai\UI\User */
    private $user;
    /** @var \boru\boruai\UI\Reference */
    private $reference;

    public function __construct($webUI) {
        $this->webUI = $webUI;
        $this->user = $webUI->getUser();
        $this->reference = $webUI->getReference();
    }
    public function getWebUI() {
        return $this->webUI;
    }
    public function setWebUI($webUI) {
        $this->webUI = $webUI;
    }
    public function getUser() {
        return $this->user;
    }
    public function setUser($user) {
        $this->user = $user;
    }
    public function getReference() {
        return $this->reference;
    }
    public function setReference($reference) {
        $this->reference = $reference;
    }
    public function getConfig($key=null,$default=false) {
        return $this->webUI->config($key,$default);
    }
    public function user($user=null) {
        if($user !== null) {
            $this->user = $user;
        }
        return $this->user;
    }
    public function reference($reference=null) {
        if($reference !== null) {
            $this->reference = $reference;
        }
        return $this->reference;
    }
    public function request($key=null,$default=false) {
        return $this->webUI->request($key,$default);
    }
    public function body($key=null,$default=false) {
        return $this->webUI->body($key,$default);
    }

    public static function init($sse=false) {
        
        if(!$sse) {
            header('Content-Type: application/json');
            
        } else {
            set_time_limit(0);
            if (function_exists('apache_setenv')) {
                apache_setenv('no-gzip', '1');
            }
            header('Content-Type: text/event-stream');
            
        }
        header('Cache-Control: no-cache');
        header('X-Accel-Buffering: no'); // for nginx
        header('Access-Control-Allow-Origin: *');
    }

    public static function handleRequest() {
        $webUI = \boru\boruai\UI\WebUI::getInstance();
        $action = $webUI->request("action");
        if($action) {
            //overrides first
            $actions = $webUI->getActions();
            $action = strtolower($action);
            if(isset($actions[$action]) && class_exists($actions[$action]) && method_exists($actions[$action], "handle")) {
                $instance = new $actions[$action]($webUI);
                return $instance->handle();
            }
            //default actions 
            $class = __NAMESPACE__ . "\\" . ucfirst($action)."Action";
            if(class_exists($class) && method_exists($class, "handle")) {
                $instance = new $class($webUI);
                return $instance->handle();
            }
            
        }
        static::init();
        $result = [
            "error" => "Invalid action"
        ];
        static::response($result);
        return false;
    }

    public static function response($data) {
        echo json_encode($data,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
        exit();
    }
    public static function sse($data) {
        echo "data: ".json_encode($data,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE)."\n\n";
        flush();
    }
    public static function success($data) {
        $response = [
            "success" => true,
            "data" => $data
        ];
        static::response($response);
    }
    public static function error($data,$message="") {
        $response = [];
        $response["success"] = false;
        if($message) {
            $response["error"] = $message;
        }
        $response["data"] = $data;
        static::response($response);
    }
}