<?php
namespace boru\boruai;

use boru\boruai\Models\Services\ServiceInterface;

class AICall {

    private static $modelToServiceMap = [
        "gpt-4.1" => Models\Services\OpenAIResponseService::class,
        "gpt-3.5" => Models\Services\OpenAIResponseService::class,
    ];
    public static function addService($model, $serviceClass) {
        self::$modelToServiceMap[$model] = $serviceClass;
    }
    public static function create($model="gpt-4.1") {
        $instance = new self(new Models\Services\OpenAIResponseService());
        $instance->model($model);
        return $instance;
    }

    /** @var ServiceInterface */
    private $service;

    /**
     * @param ServiceInterface|string|null $serviceOrModel
     */
    public function __construct($serviceOrModel=null) {
        if(is_string($serviceOrModel)) {
            $model = $serviceOrModel;
            if(isset(self::$modelToServiceMap[$model])) {
                $serviceClass = self::$modelToServiceMap[$model];
                $serviceOrModel = new $serviceClass();
            } else {
                throw new \Exception("No service found for model: ".$model);
            }
        }
        $this->service = $serviceOrModel;
        if(!$this->service) {
            $this->service = new Models\Services\OpenAIResponseService();
        }
    }

    public function service($service=null) {
        if($service) {
            $this->service = $service;
        }
        return $this->service;
    }

    public function call($options=[]) {
        return $this->service->call($options);
    }
    public function callback($callback = null) {
        return $this->service->callback($callback);
    }
    public function model($model=null) {
        return $this->service->model($model);
    }
    public function set($k,$value=null) {
        return $this->service->set($k,$value);
    }
    public function get($k=null,$default=null) {
        return $this->service->get($k,$default);
    }
    public function addTool($tool=[]) {
        return $this->service->addTool($tool);
    }
    public function addTools($tools=[]) {
        return $this->service->addTools($tools);
    }
    public function getTools() {
        return $this->service->getTools();
    }
    public function addMessage($message,$options=[]) {
        return $this->service->addMessage($message,$options);
    }
    public function addImage($image,$options=[]) {
        return $this->service->addImage($image,$options);
    }
    public function addFile($file,$options=[]) {
        return $this->service->addFile($file,$options);
    }

    public function addToolMcp($jsonStringOrArray) {
        $toolData = is_string($jsonStringOrArray) ? json_decode($jsonStringOrArray,true) : $jsonStringOrArray;
        if(is_array($toolData)) {
            $this->service->addTool(Models\Tool\McpTool::fromJson($toolData));
        }
    }
}