<?php
namespace boru\boruai\Openai\Models;

use boru\boruai\Models\File;

class Content extends BaseModel {

    private $body;

    public function __construct($contentBody=[]) {
        if(!is_array($contentBody)) {
            $this->body = [];
            if(is_string($contentBody)) {
                $this->addText($contentBody);
            } else {
                throw new \Exception("Options must be an array or string");
            }
        }
        $this->body = $contentBody;
    }

    public function addText($text) {
        $this->body[] = [
            "type"=> "text",
            "text"=>$text,
        ];
        return $this;
    }
    public function addFile($fileIdOrPath,$type="file",$mimeType=null) {
        if(!is_array($this->body)) {
            $this->body = [];
        }
        if(is_null($type)) {
            $type = "file";
        }
        if(is_string($fileIdOrPath) && substr($fileIdOrPath,0,5) == "file-") {
            $this->body[] = [
                "type" => $type,
                "file" => [
                    "file_id" => $fileIdOrPath,
                ],
            ];
            return $this;
        }
        if(is_string($fileIdOrPath) && file_exists($fileIdOrPath)) {
            $fileId = $this->makeBase64url($fileIdOrPath,$mimeType);
            $fileName = basename($fileIdOrPath);
            $this->body[] = [
                "type" => $type,
                "file" => [
                    "filename" => $fileName,
                    "file_data" => $fileId,
                ],
            ];
            return $this;
        }
        if(is_string($fileIdOrPath) && is_numeric($fileIdOrPath)) {
            $file = File::fromId($fileIdOrPath);
            if(!$file instanceof File) {
                throw new \Exception("File not found");
            }
            if($file->fileid()) {
                $this->body[] = [
                    "type" => $type,
                    "file" => [
                        "file_id" => $file->fileid(),
                    ],
                ];
                return $this;
            }
        }
        throw new \Exception("File not found");
        return $this;
    }
    public function addImageFile($fileId,$detail="high") {
        if(!is_array($this->body)) {
            $this->body = [];
        }
        $this->body[] = [
            "type"=> "image_file",
            "image_file"=>["file_id"=>$fileId,"detail"=>$detail],
        ];
        return $this;
    }
    public function addAudioFile($fileId) {
        if(!is_array($this->body)) {
            $this->body = [];
        }
        $this->body[] = [
            "type"=> "audio_file",
            "audio_file"=>["file_id"=>$fileId],
        ];
        return $this;
    }
    public function addImageUrl($url) {
        if(!is_array($this->body)) {
            $this->body = [];
        }
        $this->body[] = [
            "type"=> "image_url",
            "image_url"=>["url"=>$url],
        ];
        return $this;
    }
    public function addBase64Image($pathToFile,$mimeType=null) {
        $base64String = $this->makeBase64url($pathToFile,$mimeType);
        return $this->addImageUrl($base64String);
    }

    public function makeBase64url($pathToFile,$mimeType=null) {
        if($mimeType && !file_exists($pathToFile)) {
            $base64 = base64_encode($pathToFile);
        } else {
            if(!file_exists($pathToFile)) {
                throw new \Exception("File not found");
            }
            if(!$mimeType) {
                $mimeType = mime_content_type($pathToFile);
            }
            $fileContent = file_get_contents($pathToFile);
            $base64 = base64_encode($fileContent);
        }
        $base64String = "data:".$mimeType.";base64,".$base64;
        return $base64String;
    }

    public function toArray() {
        return $this->body;
    }

}