<?php
namespace boru\boruai\OCR;

use boru\boruai\OCR\Contract\OCRCallbackInterface;

class OCRCallback implements OCRCallbackInterface {
    private $successCallback;
    private $errorCallback;

    public function __construct($successCallback=null, $errorCallback=null) {
        $this->successCallback = $successCallback;
        $this->errorCallback = $errorCallback;
    }
    public function onSuccess($callback) {
        $this->successCallback = $callback;
    }
    public function onError($callback) {
        $this->errorCallback = $callback;
    }
    public function handleSuccess($data, $object=null) {
        if(is_callable($this->successCallback)) {
            call_user_func($this->successCallback, $data, $object);
        }
    }
    public function handleError($error, $object=null) {
        if(is_callable($this->errorCallback)) {
            call_user_func($this->errorCallback, $error, $object);
        }
    }
}