<?php
namespace boru\boruai\Cli\Defs;

use boru\boruai\Config;
use boru\cli\CLI;
use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\output\Output;
use boru\boruai\Openai\Api\Endpoints\FilesAPI;
use boru\boruai\Openai\OpenAIFile;

trait ConfigCLI {
    public static function def_config() {
        return [
            "description"=> "Configure the BoruAI tool",
        ];
    }

    public static function def_config_check() {
        return [
            "description"=> "Check Configuration",
            "params" => [
                Flag::create("r|readonly|Do not create a configuration file if it does not exist"),
            ]
        ];
    }
    public function cmd_config_check() {
        $configuration = Config::Configuration();
        if($configuration->filename() === null) {
            if($this->get("readonly")) {
                Output::outLine("No configuration file loaded");
            } else {
                $configuration->load("config.json");
                Output::outLine("Configuration file did not exist. Created:",$configuration->filename());
            }
        } else {
            Output::outLine("Configuration file loaded:",$configuration->filename());
        }
    }

    public static function def_config_get() {
        return [
            "description"=> "Get Configuration",
            "params" => [
                Positional::create("configKey|The configuration key to get"),
            ]
        ];
    }
    public function cmd_config_get() {
        $configuration = Config::Configuration();
        if($configuration->filename() === null) {
            $configuration->load("config.json");
        }
        
        $key = $this->get("configKey");
        $value = $configuration->get($key);
        if($value === null) {
            Output::outLine("configKey",$key,"not found");
        } else {
            Output::outLine($key.":",$value);
        }
    }

    public static function def_config_set() {
        return [
            "description"=> "Set Configuration",
            "params" => [
                Positional::create("*configKey|The configuration key to set"),
                Positional::create("*configValue|The configuration value to set"),
            ]
        ];
    }
    public function cmd_config_set() {
        $configuration = Config::Configuration();
        if($configuration->filename() === null) {
            $configuration->load("config.json");
        }
        
        $key = $this->get("configKey");
        $value = $this->get("configValue");
        $configuration->set($key,$value);
        $configuration->save();
        Output::outLine($key.":",$value);
    }

    public static function def_config_delete() {
        return [
            "description"=> "Delete Configuration",
            "params" => [
                Positional::create("*configKey|The configuration key to delete"),
            ]
        ];
    }

    public function cmd_config_delete() {
        $configuration = Config::Configuration();
        if($configuration->filename() === null) {
            $configuration->load("config.json");
        }
        
        $key = $this->get("configKey");
        $value = $configuration->delete($key);
        if($value) {
            $configuration->save();
            Output::outLine("Deleted configKey",$key);
        } else {
            Output::outLine("configKey",$key,"not found");
        }
    }
}