<?php
namespace boru\boruai\Models;

class ToolParameters {
    private $type = "object";
    private $properties = [];
    private $additionalProperties = false;

    private $rawJson = null;

    public function __construct($input=[],$isRaw=false) {
        if($isRaw) {
            if(is_array($input)) {
                $this->rawJson = json_encode($input,JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
            } else {
                $this->rawJson = $input;
            }
            return;
        }
        if(!is_array($input)) {
            return;
        }
        $nameArr = false;
        if(isset($input["type"])) {
            $nameArr = true;
            $this->type = $input["type"];
        }
        if(isset($input["properties"])) {
            $nameArr = true;
            foreach($input["properties"] as $name => $property) {
                if($property instanceof ToolProperty) {
                    $this->properties[$property->name()] = $property;
                } else {
                    $this->properties[$name] = new ToolProperty($property);
                    if($this->properties[$name]->name() != $name) {
                        $this->properties[$name]->name($name);
                    }
                }
            }
        }
        if(!$nameArr) {
            foreach($input as $name => $property) {
                if($property instanceof ToolProperty) {
                    $this->properties[$property->name()] = $property;
                } else {
                    $this->properties[$name] = new ToolProperty($property);
                    if($this->properties[$name]->name() != $name) {
                        $this->properties[$name]->name($name);
                    }
                }
            }
        }
    }

    public function type($type=null) {
        if($type !== null) {
            $this->type = $type;
            return $this;
        }
        return $this->type;
    }

    public function properties($properties=null) {
        if($properties !== null) {
            $this->properties = $properties;
            return $this;
        }
        return $this->properties;
    }

    public function compile($strict=true) {
        if($this->rawJson) {
            return json_decode($this->rawJson, true);
        }
        $compiled = [
            "type" => $this->type,
            "properties" => [],
            "additionalProperties" => $this->additionalProperties
        ];
        $required = [];
        foreach($this->properties as $property) {
            $compiled["properties"][$property->name()] = $property->compile();
            if($property->required() || $strict) {
                $required[] = $property->name();
            }
        }
        if(count($required) > 0) {
            $compiled["required"] = $required;
        }
        if($strict) {
            $compiled["additionalProperties"] = false;
        }
        return $compiled;
    }

    public function addProperty($property) {
        $this->properties[] = $property;
        return $this;
    }
}