<?php
namespace boru\boruai\Openai\Api\Endpoints;

use boru\boruai\Openai\Models\Run;
use boru\boruai\Openai\OpenAI;

class RunsAPI {
    public static function create($threadId,$parameters=[]) {
        return new Run(OpenAI::request("post","threads/".$threadId."/runs",$parameters));
    }
    public static function listRuns($threadId) {
        return OpenAI::requestList("get","threads/".$threadId."/runs",[],Run::class);
    }
    public static function getRun($threadId,$runId) {
        return new Run(OpenAI::request("get","threads/".$threadId."/runs/".$runId,[],[
            'timeout' => 5, // Response timeout
            'connect_timeout' => 5, // Connection timeout
        ]));
    }
    public static function update($threadId,$runId,$parameters=[]) {
        return new Run(OpenAI::request("post","threads/".$threadId."/runs/".$runId,$parameters));
    }
    public static function submitToolOutput($threadId,$runId,$parameters=[]) {
        return new Run(OpenAI::request("post","threads/".$threadId."/runs/".$runId."/submit_tool_outputs",$parameters));
    }
}