<?php
namespace boru\boruai\Openai\Response\Parts\Content;

use boru\boruai\Openai\Models\BaseModel;

class Reasoning extends BaseModel {
    private $type = "reasoning";
    private $id;
    private $summary = [];
    private $content = [];
    private $encrypted_content;
    private $status;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }

    public function type($type=null) {
        if ($type) {
            $this->type = $type;
        }
        return $this->type;
    }
    public function summary($summary=null) {
        if ($summary) {
            $this->summary = $summary;
        }
        return $this->summary;
    }
    public function content($content=null) {
        if ($content) {
            $this->content = $content;
        }
        return $this->content;
    }
    public function encryptedContent($encrypted_content=null) {
        if ($encrypted_content) {
            $this->encrypted_content = $encrypted_content;
        }
        return $this->encrypted_content;
    }
    public function status($status=null) {
        if ($status) {
            $this->status = $status;
        }
        return $this->status;
    }
    public function toArray() {
        $array = [
            "id" => $this->id(),
            "type" => $this->type(),
            "summary" => $this->summary(),
            "content" => $this->content(),
            "encrypted_content" => $this->encryptedContent(),
            "status" => $this->status(),
        ];

        return array_filter($array, function($value) {
            return !is_null($value);
        });
    }
    public function __toString() {
        return json_encode($this->toArray());
    }
}