<?php
namespace boru\boruai\Openai\Response\Parts;

use boru\boruai\Openai\Models\BaseModel;
use boru\boruai\Openai\Response\Parts\Content\Content;

class OutputMessage extends BaseModel {
    private $id;
    private $type = "message";
    private $role;
    private $content;
    private $status;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function type($type=null) {
        if ($type) {
            $this->type = $type;
        }
        return $this->type;
    }
    public function role($role=null) {
        if ($role) {
            $this->role = $role;
        }
        return $this->role;
    }
    public function content($content=null) {
        if ($content) {
            $content = new Content($content);
            $this->content = $content;
        }
        if(!$this->content instanceof Content) {
            $this->content = new Content($this->content);
        }
        return $this->content;
    }
    public function status($status=null) {
        if ($status) {
            $this->status = $status;
        }
        return $this->status;
    }

    public function __toString() {
        return $this->content()->output();
    }
    public function json($array=true) {
        $text = $this->content()->asJson($array);
        if($text) {
            return $text;
        }
        return false;
    }
    public function output() {
        $text = $this->content()->output();
        if($text) {
            return $text;
        }
        return false;
    }
    public function asJson($array=true) {
        return $this->json($array);
    }
    public function asString() {
        return $this->__toString();
    }
    public function toJson($array=true) {
        return $this->json($array);
    }
    public function toString() {
        return $this->__toString();
    }

    public function toArray() {
        $array = [
            "id" => $this->id(),
            "type" => $this->type(),
            "role" => $this->role(),
            "content" => $this->content(),
            "status" => $this->status(),
        ];
        return array_filter($array, function($value) {
            return !is_null($value);
        });
    }
}