<?php
namespace boru\boruai\Cli\Defs\Openai;

use boru\boruai\Openai\Api\Endpoints\ModelsAPI;
use boru\cli\params\Positional;
use boru\output\Output;

trait ModelCLI {
    public static function def_openai_model() {
        return [
            "description"=> "Model Operations",
            "params" => []
        ];
    }

    public static function def_openai_model_list() {
        return [
            "description"=> "List Models",
            "params"=> []
        ];
    }
    public function cmd_openai_model_list($cmd) {
        $models = ModelsAPI::listModels();
        foreach($models as $model) {
            Output::outLine($model->id());
        }
    }

    public static function def_openai_model_get() {
        return [
            "description"=> "Get Model",
            "params" => [
                Positional::create("model|Model ID"),
            ]
        ];
    }
    public function cmd_openai_model_get($cmd) {
        $model_id = $this->get("model");
        $model = ModelsAPI::getModel($model_id);
        if($model) {
            $data=json_encode($model->asArray(),JSON_PRETTY_PRINT);
            Output::outLine($data);
        }
    }
}