<?php
namespace boru\boruai\Openai;

use boru\boruai\Openai\Api\Endpoints\ImagesAPI;
use boru\boruai\Openai\Models\BaseModel;

class OpenAIImage extends BaseModel {

    private $prompt = "";
    private $model = "dall-e-3";
    private $n = 1;
    private $quality = "hd";
    private $response_format = "b64_json";
    private $size = "1024x1024";
    private $style = "vivid";
    private $user;

    private $url;
    private $b64_json;
    private $revised_prompt;

    public function prompt($prompt=null) {
        if ($prompt) {
            $this->prompt = $prompt;
        }
        return $this->prompt;
    }
    public function model($model=null) {
        if ($model) {
            $this->model = $model;
        }
        return $this->model;
    }
    public function n($n=null) {
        if ($n) {
            $this->n = $n;
        }
        return $this->n;
    }
    public function quality($quality=null) {
        if ($quality) {
            $this->quality = $quality;
        }
        return $this->quality;
    }
    public function responseFormat($response_format=null) {
        if ($response_format) {
            $this->response_format = $response_format;
        }
        return $this->response_format;
    }
    public function size($size=null) {
        if ($size) {
            $this->size = $size;
        }
        return $this->size;
    }
    public function style($style=null) {
        if ($style) {
            $this->style = $style;
        }
        return $this->style;
    }
    public function user($user=null) {
        if ($user) {
            $this->user = $user;
        }
        return $this->user;
    }
    public function url($url=null) {
        if ($url) {
            $this->url = $url;
        }
        return $this->url;
    }
    public function b64Json($b64_json=null) {
        if ($b64_json) {
            $this->b64_json = $b64_json;
        }
        return $this->b64_json;
    }
    public function revisedPrompt($revised_prompt=null) {
        if ($revised_prompt) {
            $this->revised_prompt = $revised_prompt;
        }
        return $this->revised_prompt;
    }

    public function toArray() {
        $return = [
            "prompt" => $this->prompt,
            "model" => $this->model,
            "n" => $this->n,
            "quality" => $this->quality,
            "response_format" => $this->response_format,
            "size" => $this->size,
            "style" => $this->style,
            "user" => $this->user,
        ];
        if($this->url) {
            $return["url"] = $this->url;
        }
        if($this->b64_json) {
            $return["b64_json"] = $this->b64_json;
        }
        if($this->revised_prompt) {
            $return["revised_prompt"] = $this->revised_prompt;
        }
        return $return;
    }

    public function create() {
        $packet = [
            "model" => $this->model,
            "prompt" => $this->prompt,
            "n" => $this->n,
            "quality" => $this->quality,
            "size" => $this->size,
            "style" => $this->style,
            "response_format" => $this->response_format,
        ];
        $response = ImagesAPI::create($packet);
        if(isset($response["url"]) || isset($response["b64_json"])) {
            if(isset($response["url"])) {
                $this->url = $response["url"];
            }
            if(isset($response["b64_json"])) {
                $this->b64_json = $response["b64_json"];
            }
            if(isset($response["revised_prompt"])) {
                $this->revised_prompt = $response["revised_prompt"];
            }
            return $this;
        }
        return $response;
    }

    public function save($fileName) { 
        if($this->b64_json) {
            $data = base64_decode($this->b64_json);
            file_put_contents($fileName, $data);
            return true;
        }
        return false;
    }
}