<?php
namespace boru\boruai\Openai\Response\Parts;

use boru\boruai\Models\Tool;
use boru\boruai\Openai\Models\BaseModel;

class FunctionCall extends OutputMessage {
    private $id;
    private $type = "function_call";
    private $name;
    private $arguments;
    private $status;
    private $callId;
    private $reasoning;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function type($type=null) {
        if ($type) {
            $this->type = $type;
        }
        return $this->type;
    }
    public function name($name=null) {
        if ($name) {
            $this->name = $name;
        }
        return $this->name;
    }
    public function arguments($arguments=null) {
        if ($arguments) {
            $this->arguments = $arguments;
        }
        return $this->arguments;
    }
    public function status($status=null) {
        if ($status) {
            $this->status = $status;
        }
        return $this->status;
    }
    public function callId($callId=null) {
        if ($callId) {
            $this->callId = $callId;
        }
        return $this->callId;
    }
    public function reasoning($reasoning=null) {
        if ($reasoning) {
            $this->reasoning = $reasoning;
        }
        return $this->reasoning;
    }

    public function toArray(){
        $array = [];
        if($this->id) {
            $array["id"] = $this->id;
        }
        if($this->type) {
            $array["type"] = $this->type;
        }
        if($this->name) {
            $array["name"] = $this->name;
        }
        if($this->arguments) {
            $array["arguments"] = $this->arguments;
        }
        if($this->status) {
            $array["status"] = $this->status;
        }
        if($this->callId) {
            $array["call_id"] = $this->callId;
        }
        if($this->reasoning) {
            $array["reasoning"] = $this->reasoning;
        }
        return $array;
    }

    public function __toString() {
        return $this->json(false);
    }
    public function toString() {
        return $this->__toString();
    }
    public function asString() {
        return $this->__toString();
    }
    public function json($array=true) {
        $text = $this->toArray();
        if($text) {
            return $text;
        }
        return false;
    }
    public function toJson($array=true) {
        return $this->json($array);
    }
    public function asJson($array=true) {
        $text = $this->json($array);
        if($text) {
            return $text;
        }
        return false;
    }

    public function run(\boru\boruai\Models\Tool\ToolContext $context = null) {
        $toolOutputs = [];
        $tool = new Tool($this->toArray());
        if ($context !== null) {
            // Attach shared context so tools can access it via $tool->context()
            if (method_exists($tool, 'setContext')) {
                $tool->setContext($context);
            }
        }
        if(($toolOutput = $tool->run()) !== false) {
            $toolOutputs[] = $toolOutput;
        } else {
            throw new \Exception("Tool call not found ".json_encode($this->toArray()));
        }
        return $toolOutputs;
    }
}