<?php
namespace boru\boruai\Openai\Stream;

use boru\boruai\Openai\Stream\StreamEvent;

class Error extends StreamEvent {
    const TYPE = 'response.error';
    private $id;
    private $error;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function error($error=null) {
        if ($error) {
            $this->error = $error;
        }
        return $this->error;
    }

    public function toArray() {
        $result = [
            'type' => $this->type(),
            'id' => $this->id(),
            'error' => null
        ];
        if(is_object($this->error)) {
            $result['error'] = $this->error->toArray();
        } elseif(is_array($this->error)) {
            $result['error'] = $this->error;
        } else {
            $result['error'] = $this->error;
        }
        return $result;
    }
}