<?php
namespace boru\boruai\UI\Actions;

use boru\boruai\Models\Response;
use boru\boruai\Models\ResponseHistory;

class HistoryAction extends Ajax {
    public function handle() {
        static::init(true);
        $before = $this->request("before",false);
        $limit = $this->request("limit",10);

        header('Content-Type: application/json');
        header('Cache-Control: no-cache');
        header('X-Accel-Buffering: no'); // for nginx
        header('Access-Control-Allow-Origin: *');
        if($this->getWebUI()->config("per_user_reference")) {
            $historyUser = $this->user()->id();
        } else {
            $historyUser = null;
        }
        $result = ResponseHistory::getPlayback($historyUser, $this->reference(), $limit, $before);
        if(is_array($result) && isset($result["output"])) {
            Ajax::success($result);
        } else {
            Ajax::error($result, "No history found");
        }
    }
}