<?php
namespace boru\boruai\Api\Model;

use boru\boruai\Api\BaseAPI;
use boru\boruai\Openai\Api\Endpoints\ModelsAPI;

class ModelGetAPI extends BaseAPI {


    public function execute() {
        try {
            $model_id = $this->get("model",false);
            if(!$model_id) {
                return $this->error("Model ID is required");
            }
            $model = ModelsAPI::getModel($model_id);
            if($model) {
                $output=$model->asArray();
            }
            return $this->success($output);
        } catch (\Exception $e) {
            return $this->error($e->getMessage());
        }
    }
}
