<?php
namespace boru\boruai\Openai\Api\Endpoints;

use boru\boruai\Openai\Response\ResponseObject;
use boru\boruai\Openai\OpenAI;

class ResponsesAPI {
    public static function create($parameters=[],$stream=false) {
        $extraOpts = [];
        //echo "Stream is set: " . ($stream ? "true" : "false") . "\n";
        //exit();
        if($stream) {
            $parameters["stream"] = true;
            return OpenAI::requestStream("post","responses",$parameters);
        }
        $parameters["stream"] =false;
        $request = OpenAI::request("post","responses",$parameters);
        return new ResponseObject($request);
    }
    public static function get($id) {
        $request = OpenAI::request("get","responses/$id");
        return new ResponseObject($request);
    }
    public static function delete($id) {
        $request = OpenAI::request("delete","responses/$id");
        return new ResponseObject($request);
    }
    public static function inputItems($parameters=[]) {
        return OpenAI::requestList("get","responses/",$parameters,ResponseObject::class);
    }
}