<?php
namespace boru\boruai\Openai\Api\Responses\Parts;

class Message {
    /**
     * @var string "text" or "image_file"
     */
    private $type;
    private $text_value;
    private $annotations;
    private $image_file;

    public function __construct($data) {
        $this->type = $data["type"];
        if($this->type == "text") {
            $this->text_value = $data["text"]["value"];
            $this->annotations = $data["text"]["annotations"];
        }
        else if($this->type == "image_file") {
            $this->image_file = $data["image_file"];
        }
    }

    public function type() {
        return $this->type;
    }
    public function value() {
        if($this->type == "text") {
            return $this->text_value;
        }
        else if($this->type == "image_file") {
            return $this->image_file;
        }
    }
    public function annotations() {
        return $this->annotations;
    }
}