<?php
namespace boru\boruai\Openai;

use boru\boruai\BoruAI;
use boru\boruai\Openai\Api\Endpoints\EmbeddingsAPI;
use boru\boruai\Openai\embeddings\Document;
use boru\boruai\Openai\Models\BaseModel;
use boru\boruai\Openai\OpenAI;

class OpenAIBatch extends BaseModel {

    private $id;
    private $object = "batch";
    private $endpoint;
    private $errors;
    private $input_file_id;
    private $completion_window = "24h";
    private $status;
    private $output_file_id;
    private $error_file_id;
    private $created_at;
    private $in_progress_at;
    private $expires_at;
    private $finalizing_at;
    private $completed_at;
    private $failed_at;
    private $expired_at;
    private $cancelling_at;
    private $cancelled_at;
    private $request_counts = [
        "total" => 0,
        "completed" => 0,
        "failed" => 0
    ];
    private $metadata = [];


    private $inputRequests = [];

    public function id($id=null) {
        if($id !== null) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if($object !== null) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function endpoint($endpoint=null) {
        if($endpoint !== null) {
            $this->endpoint = $endpoint;
        }
        return $this->endpoint;
    }
    public function errors($errors=null) {
        if($errors !== null) {
            $this->errors = $errors;
        }
        return $this->errors;
    }
    public function inputFileId($input_file_id=null) {
        if($input_file_id !== null) {
            $this->input_file_id = $input_file_id;
        }
        return $this->input_file_id;
    }
    public function completionWindow($completion_window=null) {
        if($completion_window !== null) {
            $this->completion_window = $completion_window;
        }
        return $this->completion_window;
    }
    public function status($status=null) {
        if($status !== null) {
            $this->status = $status;
        }
        return $this->status;
    }
    public function outputFileId($output_file_id=null) {
        if($output_file_id !== null) {
            $this->output_file_id = $output_file_id;
        }
        return $this->output_file_id;
    }
    public function errorFileId($error_file_id=null) {
        if($error_file_id !== null) {
            $this->error_file_id = $error_file_id;
        }
        return $this->error_file_id;
    }
    public function createdAt($created_at=null) {
        if($created_at !== null) {
            $this->created_at = $created_at;
        }
        return $this->created_at;
    }
    public function inProgressAt($in_progress_at=null) {
        if($in_progress_at !== null) {
            $this->in_progress_at = $in_progress_at;
        }
        return $this->in_progress_at;
    }
    public function expiresAt($expires_at=null) {
        if($expires_at !== null) {
            $this->expires_at = $expires_at;
        }
        return $this->expires_at;
    }
    public function finalizingAt($finalizing_at=null) {
        if($finalizing_at !== null) {
            $this->finalizing_at = $finalizing_at;
        }
        return $this->finalizing_at;
    }
    public function completedAt($completed_at=null) {
        if($completed_at !== null) {
            $this->completed_at = $completed_at;
        }
        return $this->completed_at;
    }
    public function failedAt($failed_at=null) {
        if($failed_at !== null) {
            $this->failed_at = $failed_at;
        }
        return $this->failed_at;
    }
    public function expiredAt($expired_at=null) {
        if($expired_at !== null) {
            $this->expired_at = $expired_at;
        }
        return $this->expired_at;
    }
    public function cancellingAt($cancelling_at=null) {
        if($cancelling_at !== null) {
            $this->cancelling_at = $cancelling_at;
        }
        return $this->cancelling_at;
    }
    public function cancelledAt($cancelled_at=null) {
        if($cancelled_at !== null) {
            $this->cancelled_at = $cancelled_at;
        }
        return $this->cancelled_at;
    }
    public function requestCounts($request_counts=null) {
        if($request_counts !== null) {
            $this->request_counts = $request_counts;
        }
        return $this->request_counts;
    }
    public function metadata($metadata=null) {
        if($metadata !== null) {
            $this->metadata = $metadata;
        }
        return $this->metadata;
    }

    public function toArray() {
        return [
            "id" => $this->id(),
            "object" => $this->object(),
            "endpoint" => $this->endpoint(),
            "errors" => $this->errors(),
            "input_file_id" => $this->inputFileId(),
            "completion_window" => $this->completionWindow(),
            "status" => $this->status(),
            "output_file_id" => $this->outputFileId(),
            "error_file_id" => $this->errorFileId(),
            "created_at" => $this->createdAt(),
            "in_progress_at" => $this->inProgressAt(),
            "expires_at" => $this->expiresAt(),
            "finalizing_at" => $this->finalizingAt(),
            "completed_at" => $this->completedAt(),
            "failed_at" => $this->failedAt(),
            "expired_at" => $this->expiredAt(),
            "cancelling_at" => $this->cancellingAt(),
            "cancelled_at" => $this->cancelledAt(),
            "request_counts" => $this->requestCounts(),
            "metadata" => $this->metadata()
        ];
    }

    public function add() {
        
    }
    
}