<?php

namespace boru\boruai\Openai\Stream\Contract;

use boru\boruai\Openai\Stream\StreamEvent;

interface StreamEventDispatcherInterface
{
    /**
     * Attach a listener for this dispatcher.
     *
     * @param StreamEventListenerInterface $listener
     * @return void
     */
    public function addListener(StreamEventListenerInterface $listener);

    /**
     * Dispatch a single event to registered listeners.
     *
     * @param StreamEvent $event
     * @return void
     */
    public function dispatch(StreamEvent $event);
}
