<?php
namespace boru\boruai\UI;

use boru\boruai\Vtiger\Vtiger;
use boru\dot\Dot;

class WebConfig {
    public $title = "BoruAI Web Interface";
    public $logo = null;
    public $welcome_message = "Welcome to BoruAI Web Interface";
    public $webPathPrefix = "/boruai/web/";
    public $force_user_reference = false; //all users to see/use all references, not just theirs
    public $footer_message = "Powered by BoruAI";
    public $authCallback = null;
    public $tools = [];
    public $connectors = [];
    public $templateDir = null;
    public $vtigerUrl = null;
    private $vtigerVariables;


    public function __construct($configArray = null) {
        if(is_array($configArray)) {
            $this->setFromArray($configArray);
        }
        if(is_null($this->vtigerUrl)) {
            $this->vtigerUrl = $this->vtiger("site_URL");
        }
    }

    public function setFromArray($configArray) {
        foreach($configArray as $key => $value) {
            if(property_exists($this,$key)) {
                $this->$key = $value;
            }
        }
    }

    public function vtiger($key=null,$default=false) {
        if(is_null($this->vtigerVariables)) {
            $this->vtigerVariables = Vtiger::getVtigerConfigVariables();
        }
        if($key) {
            return Dot::get($this->vtigerVariables, $key, $default);
        }
        return $this->vtigerVariables;
    }
}