<?php
namespace boru\boruai\Agent;

class SimpleAgent extends BaseAgent {

    protected $referencePrefix = "SimpleAgent_";
    protected $instructions;
    protected $prompt;

    public function generateReference()
    {
        return $this->referencePrefix . uniqid();
    }

    public function getInstructions()
    {
        if(!$this->instructions) {
            return "";
        }
        if(is_callable($this->instructions)) {
            $func = $this->instructions;
            return $func($this);
        }
        return $this->instructions;
    }

    public function setInstructions($instructions)
    {
        $this->instructions = $instructions;
    }

    public function getPrompt()
    {
        if(!$this->prompt) {
            return "";
        }
        if(is_callable($this->prompt)) {
            $func = $this->prompt;
            return $func($this);
        }
        return $this->prompt;
    }
    
    public function setPrompt($prompt)
    {
        $this->prompt = $prompt;
    }
}