<?php
namespace boru\boruai\Vtiger;

use boru\query\Query;

class VtigerRelatedLists {
    private static $moduleRelatedListCache = [];

    /**
     * Get fields for a module
     * @param int|string $tabIdOrModuleName The tabid or module name
     * @return array array of fields with fieldname as key, [fieldlabel, uitype, typeofdata, presence, columnname] as value
     */
    public static function getRelatedLists($tabIdOrModuleName) {
        if(!is_numeric($tabIdOrModuleName)) {
            $tabIdOrModuleName = VtigerModule::getModuleByName($tabIdOrModuleName);
            $tabId = $tabIdOrModuleName['tabid'];
        } else {
            $tabId = $tabIdOrModuleName;
        }
        if(isset(static::$moduleFieldsCache[$tabId])) {
            return static::$moduleRelatedListCache[$tabId];
        }
        $lists = Query::create()
            ->select("relation_id, related_tabid, label, name")
            ->from("vtiger_relatedlists")
            ->where("tabid","=", $tabId)
            ->toRows();
        foreach($lists as $list) {
            static::$moduleRelatedListCache[$tabId][$list->get('relation_id')] = $list->asArray();
            $module = VtigerModule::getModuleById($list->get('related_tabid'));
            //static::$moduleRelatedListCache[$tabId][$list->get('relation_id')]['relatedModule'] = $module["name"];
        }
        return static::$moduleRelatedListCache[$tabId];
    }
}