<?php

use PHPUnit\Framework\TestCase;
use boru\boruai\Agent\SimpleAgent;

class SimpleAgentTest extends TestCase
{
    public function testGenerateReferenceUsesPrefixAndIsStableOnceGenerated()
    {
        $agent = new SimpleAgent();

        $ref1 = $agent->getReference();   // triggers generateReference()
        $ref2 = $agent->getReference();   // should reuse same reference

        $this->assertIsString($ref1);
        $this->assertStringStartsWith('SimpleAgent_', $ref1);
        $this->assertSame($ref1, $ref2, 'Reference should be cached once generated');
    }

    public function testGetInstructionsDefaultsToEmptyString()
    {
        $agent = new SimpleAgent();

        $this->assertSame('', $agent->getInstructions());
    }

    public function testGetInstructionsReturnsStringWhenSet()
    {
        $agent = new class extends SimpleAgent {
            public function setInstructions($value)
            {
                $this->instructions = $value;
                return $this;
            }
        };

        $agent->setInstructions('You are a helpful test agent.');

        $this->assertSame('You are a helpful test agent.', $agent->getInstructions());
    }

    public function testGetInstructionsInvokesCallable()
    {
        $agent = new class extends SimpleAgent {
            public function setInstructions($value)
            {
                $this->instructions = $value;
                return $this;
            }
        };

        $agent->setInstructions(function (SimpleAgent $a) {
            // We can inspect the agent if needed; for now just return a string
            return 'Computed instructions';
        });

        $this->assertSame('Computed instructions', $agent->getInstructions());
    }

    public function testGetPromptDefaultsToEmptyString()
    {
        $agent = new SimpleAgent();

        $this->assertSame('', $agent->getPrompt());
    }

    public function testGetPromptReturnsStringWhenSet()
    {
        $agent = new class extends SimpleAgent {
            public function setPrompt($value)
            {
                $this->prompt = $value;
                return $this;
            }
        };

        $agent->setPrompt('Say hello to the world.');

        $this->assertSame('Say hello to the world.', $agent->getPrompt());
    }

    public function testGetPromptInvokesCallable()
    {
        $agent = new class extends SimpleAgent {
            public function setPrompt($value)
            {
                $this->prompt = $value;
                return $this;
            }
        };

        $agent->setPrompt(function (SimpleAgent $a) {
            return 'Dynamic prompt';
        });

        $this->assertSame('Dynamic prompt', $agent->getPrompt());
    }
}
