<?php

use PHPUnit\Framework\TestCase;
use boru\boruai\BoruAI;
use boru\borumcp\Authenticators\JWTAuthenticator;

class JwtSettingsTest extends TestCase
{
    protected function setUp(): void
    {
        // Force fresh settings per test by resetting via jwtSettings
        BoruAI::jwtSettings([
            'algo' => 'HS256',
            'secret' => 'boruAI-secret-here',
            'iss' => 'boruAI-issuer',
            'aud' => 'boruAI-audience',
            'kid' => null,
            'ttl' => 300,
        ]);
    }

    public function testDefaultJwtSettings()
    {
        $settings = BoruAI::jwtSettings();

        $this->assertSame('HS256', $settings['algo']);
        $this->assertSame('boruAI-secret-here', $settings['secret']);
        $this->assertSame('boruAI-issuer', $settings['iss']);
        $this->assertSame('boruAI-audience', $settings['aud']);
        $this->assertArrayHasKey('ttl', $settings);
    }

    public function testJwtSettingsAreMerged()
    {
        BoruAI::jwtSettings([
            'secret' => 'new-secret',
            'ttl'    => 600,
        ]);

        $settings = BoruAI::jwtSettings();

        $this->assertSame('new-secret', $settings['secret']);
        $this->assertSame(600, $settings['ttl']);
        // unchanged fields remain
        $this->assertSame('HS256', $settings['algo']);
    }

    public function testJwtAuthenticatorUsesCurrentSettings()
    {
        BoruAI::jwtSettings([
            'secret' => 'another-secret',
        ]);

        $authenticator = BoruAI::jwtAuthenticator();

        $this->assertInstanceOf(JWTAuthenticator::class, $authenticator);
        $minter = BoruAI::jwtMinter();
        $this->assertNotNull($minter);
    }

    public function testJwtMintProducesTokenString()
    {
        $token = BoruAI::jwtMint(['sub' => 'test-user']);

        $this->assertIsString($token);
        $this->assertNotEmpty($token);
    }
}
