/*!
 * Font Awesome Pro 6.4.0 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2023 Fonticons, Inc.
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      enumerableOnly && (symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      })), keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = null != arguments[i] ? arguments[i] : {};
      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  var _familyProxy, _familyProxy2, _familyProxy3, _familyProxy4, _familyProxy5;

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();
  var FAMILY_CLASSIC = 'classic';
  var FAMILY_SHARP = 'sharp';
  var FAMILIES = [FAMILY_CLASSIC, FAMILY_SHARP];

  function familyProxy(obj) {
    // Defaults to the classic family if family is not available
    return new Proxy(obj, {
      get: function get(target, prop) {
        return prop in target ? target[prop] : target[FAMILY_CLASSIC];
      }
    });
  }
  var PREFIX_TO_STYLE = familyProxy((_familyProxy = {}, _defineProperty(_familyProxy, FAMILY_CLASSIC, {
    'fa': 'solid',
    'fas': 'solid',
    'fa-solid': 'solid',
    'far': 'regular',
    'fa-regular': 'regular',
    'fal': 'light',
    'fa-light': 'light',
    'fat': 'thin',
    'fa-thin': 'thin',
    'fad': 'duotone',
    'fa-duotone': 'duotone',
    'fab': 'brands',
    'fa-brands': 'brands',
    'fak': 'kit',
    'fa-kit': 'kit'
  }), _defineProperty(_familyProxy, FAMILY_SHARP, {
    'fa': 'solid',
    'fass': 'solid',
    'fa-solid': 'solid',
    'fasr': 'regular',
    'fa-regular': 'regular',
    'fasl': 'light',
    'fa-light': 'light'
  }), _familyProxy));
  var STYLE_TO_PREFIX = familyProxy((_familyProxy2 = {}, _defineProperty(_familyProxy2, FAMILY_CLASSIC, {
    'solid': 'fas',
    'regular': 'far',
    'light': 'fal',
    'thin': 'fat',
    'duotone': 'fad',
    'brands': 'fab',
    'kit': 'fak'
  }), _defineProperty(_familyProxy2, FAMILY_SHARP, {
    'solid': 'fass',
    'regular': 'fasr',
    'light': 'fasl'
  }), _familyProxy2));
  var PREFIX_TO_LONG_STYLE = familyProxy((_familyProxy3 = {}, _defineProperty(_familyProxy3, FAMILY_CLASSIC, {
    'fab': 'fa-brands',
    'fad': 'fa-duotone',
    'fak': 'fa-kit',
    'fal': 'fa-light',
    'far': 'fa-regular',
    'fas': 'fa-solid',
    'fat': 'fa-thin'
  }), _defineProperty(_familyProxy3, FAMILY_SHARP, {
    'fass': 'fa-solid',
    'fasr': 'fa-regular',
    'fasl': 'fa-light'
  }), _familyProxy3));
  var LONG_STYLE_TO_PREFIX = familyProxy((_familyProxy4 = {}, _defineProperty(_familyProxy4, FAMILY_CLASSIC, {
    'fa-brands': 'fab',
    'fa-duotone': 'fad',
    'fa-kit': 'fak',
    'fa-light': 'fal',
    'fa-regular': 'far',
    'fa-solid': 'fas',
    'fa-thin': 'fat'
  }), _defineProperty(_familyProxy4, FAMILY_SHARP, {
    'fa-solid': 'fass',
    'fa-regular': 'fasr',
    'fa-light': 'fasl'
  }), _familyProxy4));
  var FONT_WEIGHT_TO_PREFIX = familyProxy((_familyProxy5 = {}, _defineProperty(_familyProxy5, FAMILY_CLASSIC, {
    '900': 'fas',
    '400': 'far',
    'normal': 'far',
    '300': 'fal',
    '100': 'fat'
  }), _defineProperty(_familyProxy5, FAMILY_SHARP, {
    '900': 'fass',
    '400': 'fasr',
    '300': 'fasl'
  }), _familyProxy5));
  var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
  var DUOTONE_CLASSES = {
    GROUP: 'duotone-group',
    SWAP_OPACITY: 'swap-opacity',
    PRIMARY: 'primary',
    SECONDARY: 'secondary'
  };
  var prefixes = new Set();
  Object.keys(STYLE_TO_PREFIX[FAMILY_CLASSIC]).map(prefixes.add.bind(prefixes));
  Object.keys(STYLE_TO_PREFIX[FAMILY_SHARP]).map(prefixes.add.bind(prefixes));
  var RESERVED_CLASSES = [].concat(FAMILIES, _toConsumableArray(prefixes), ['2xs', 'xs', 'sm', 'lg', 'xl', '2xl', 'beat', 'border', 'fade', 'beat-fade', 'bounce', 'flip-both', 'flip-horizontal', 'flip-vertical', 'flip', 'fw', 'inverse', 'layers-counter', 'layers-text', 'layers', 'li', 'pull-left', 'pull-right', 'pulse', 'rotate-180', 'rotate-270', 'rotate-90', 'rotate-by', 'shake', 'spin-pulse', 'spin-reverse', 'spin', 'stack-1x', 'stack-2x', 'stack', 'ul', DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY]).concat(oneToTen.map(function (n) {
    return "".concat(n, "x");
  })).concat(oneToTwenty.map(function (n) {
    return "w-".concat(n);
  }));

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});
  }

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll ease the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "0": [320, 512, [], "30", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160V320c0 88.4-71.6 160-160 160S0 408.4 0 320V192zM160 96c-53 0-96 43-96 96V320c0 53 43 96 96 96s96-43 96-96V192c0-53-43-96-96-96z"],
    "1": [256, 512, [], "31", "M104 32h8 16 32V64 416h64 32v64H224 128 32 0V416H32 96V108.8L7.1 156.2 0 160V87.5L96.9 35.8 104 32z"],
    "2": [320, 512, [], "32", "M142.9 32C104.4 32 67.5 47.3 40.2 74.5L25.4 89.4 2.7 112 48 157.3l22.6-22.6 14.9-14.9C100.7 104.5 121.3 96 142.9 96c44.8 0 81.1 36.3 81.1 81.1c0 21.5-8.5 42.2-23.8 57.4L9.4 425.4 0 434.7V480H32 288h32V416H288 109.3L245.5 279.8c27.2-27.2 42.5-64.1 42.5-102.6C288 97 223 32 142.9 32z"],
    "3": [320, 512, [], "33", "M304 32V78.1l-10.4 9.5L162.3 208H184c75.1 0 136 60.9 136 136s-60.9 136-136 136H111.4C64.8 480 23 451 6.6 407.3L2 395.2 62 372.8l4.5 12.1c7 18.7 24.9 31.1 44.9 31.1H184c39.8 0 72-32.2 72-72s-32.2-72-72-72H80 48V225.9l10.4-9.5L189.7 96H32 0V32H32 272h32z"],
    "4": [384, 512, [], "34", "M209.9 32H140.5L18.5 323.7-.1 368H48 256v80 32h64V448 368h32 32V304H352 320V160 128H256v32V304H96.1L205.5 42.3 209.9 32z"],
    "5": [320, 512, [], "35", "M36.4 32H64 256h32V96H256 91.6L74.9 208H184c75.1 0 136 60.9 136 136s-60.9 136-136 136H105.9c-43.4 0-82.2-26.9-97.4-67.5L2 395.2 62 372.8 68.4 390c5.9 15.6 20.8 26 37.5 26H184c39.8 0 72-32.2 72-72s-32.2-72-72-72H37.8 .6l5.5-36.7 26.2-176L36.4 32z"],
    "6": [320, 512, [], "36", "M160 416a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM253 32L156.5 160c1.2 0 2.3 0 3.5 0c88.4 0 160 71.6 160 160s-71.6 160-160 160S0 408.4 0 320c0-38.1 12.4-75.2 35.3-105.6L172.8 32H253z"],
    "7": [320, 512, [], "37", "M320 32V71.9l-3.7 7L104.6 480H32.3L234.9 96H32 0V32H32 288h32z"],
    "8": [320, 512, [], "38", "M304 160c0-70.7-57.3-128-128-128H144C73.3 32 16 89.3 16 160c0 34.6 13.7 66 36 89C20.5 272.3 0 309.8 0 352c0 70.7 57.3 128 128 128h64c70.7 0 128-57.3 128-128c0-42.2-20.5-79.7-52-103c22.3-23 36-54.4 36-89zM176.1 288H192c35.3 0 64 28.7 64 64s-28.7 64-64 64H128c-35.3 0-64-28.7-64-64s28.7-64 64-64h15.9c0 0 .1 0 .1 0h32c0 0 .1 0 .1 0zm0-64c0 0 0 0 0 0H144c0 0 0 0 0 0c-35.3 0-64-28.7-64-64c0-35.3 28.7-64 64-64h32c35.3 0 64 28.7 64 64c0 35.3-28.6 64-64 64z"],
    "9": [320, 512, [], "39", "M160 96a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM67 480l96.5-128c-1.2 0-2.3 0-3.5 0C71.6 352 0 280.4 0 192S71.6 32 160 32s160 71.6 160 160c0 38.1-12.4 75.2-35.3 105.6L147.2 480H67z"],
    "fill-drip": [576, 512, [], "f576", "M0 272l45.3 45.3L194.7 466.7 240 512l45.3-45.3L466.7 285.3 512 240l-45.3-45.3L317.3 45.3 272 0 226.7 45.3l-60.1 60.1-80-80L64 2.7 18.7 48 41.4 70.6l80 80L45.3 226.7 0 272zm185.4-57.4L208 237.3 253.3 192l-22.6-22.6-18.7-18.7L272 90.5 421.5 240l-48 48h-267l-16-16 76.1-76.1 18.7 18.7zM512 320l-55.7 97.4c-5.5 9.6-8.3 20.4-8.3 31.4c0 34.9 28.3 63.2 63.2 63.2h1.6c34.9 0 63.2-28.3 63.2-63.2c0-11-2.9-21.8-8.3-31.4L512 320z"],
    "arrows-to-circle": [640, 512, [], "e4bd", "M48 2.7L70.6 25.4 160 114.7V96 64h64V96v96 32H192 96 64V160H96h18.7L25.4 70.6 2.7 48 48 2.7zM256 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM96 288h96 32v32 96 32H160V416 397.3L70.6 486.6 48 509.3 2.7 464l22.6-22.6L114.7 352H96 64V288H96zM637.3 48L614.6 70.6 525.3 160H544h32v64H544 448 416V192 96 64h64V96v18.7l89.4-89.4L592 2.7 637.3 48zM448 288h96 32v64H544 525.3l89.4 89.4L637.3 464 592 509.3l-22.6-22.6L480 397.3V416v32H416V416 320 288h32z"],
    "circle-chevron-right": [512, 512, ["chevron-circle-right"], "f138", "M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm345 17L241 377l-17 17L190.1 360l17-17 87-87-87-87-17-17L224 118.1l17 17L345 239l17 17-17 17z"],
    "wagon-covered": [640, 512, [], "f8ee", "M0 0L224 16V224H64L0 0zM384 16V224H256V16H384zM64 256H576v64H542.4c20.7 20.3 33.6 48.7 33.6 80c0 61.9-50.1 112-112 112c-56.4 0-103.1-41.7-110.9-96H286.9c-7.8 54.3-54.4 96-110.9 96c-61.9 0-112-50.1-112-112c0-31.3 12.9-59.7 33.6-80H64V256zm96 160H114c5.8 22.5 23.5 40.2 46 46V416zm0-32V338c-22.5 5.8-40.2 23.5-46 46h46zm32 78c22.5-5.8 40.2-23.5 46-46H192v46zm0-124v46h46c-5.8-22.5-23.5-40.2-46-46zM448 462V416H402c5.8 22.5 23.5 40.2 46 46zm-46-78h46V338c-22.5 5.8-40.2 23.5-46 46zm124 32H480v46c22.5-5.8 40.2-23.5 46-46zm0-32c-5.8-22.5-23.5-40.2-46-46v46h46zM416 16L640 0 576 224H416V16z"],
    "line-height": [576, 512, [], "f871", "M96 32L0 128v32H64V352H0v32l96 96 96-96V352H128V160h64V128L96 32zM576 64H256v64H576V64zm0 160H256v64H576V224zM256 384v64H576V384H256z"],
    "bagel": [640, 512, [129391], "e3d7", "M640 208c0 114.9-93.1 208-208 208c-3.9 0-7.7-.1-11.5-.3c5.7-10.8 10.6-22.1 14.6-33.8L478.8 352l56.7-1.6 19-53.4 44.9-34.6-16-54.4 16-54.4L554.5 119l-19-53.4L478.8 64 432 32 385.2 64l-56.7 1.6-9.2 25.7c-14.4-7.6-29.7-13.7-45.7-18.3C311.8 28.4 368.6 0 432 0C546.9 0 640 93.1 640 208zM396.1 155c10.2-6.9 22.6-11 35.9-11c35.3 0 64 28.7 64 64c0 30.6-21.5 56.3-50.3 62.5c-6-43.3-23.6-82.9-49.5-115.6zM0 304a208 208 0 1 1 416 0A208 208 0 1 1 0 304zm256 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM120 208l24 24 24-24-24-24-24 24zM80 296l24-24L80 248 56 272l24 24zm32 128l24-24-24-24L88 400l24 24zM304 264l24-24-24-24-24 24 24 24zM216 432l24 24 24-24-24-24-24 24zm88-8l24-24-24-24-24 24 24 24z"],
    "transporter-7": [512, 512, [], "e2a8", "M464 32L448 64 416 80l32 16 16 32 16-32 32-16L480 64 464 32zM64 288L48 256 32 288 0 304l32 16 16 32 16-32 32-16L64 288zM296 512H416V448H96v64H216h80z"],
    "at": [512, 512, [61946], "40", "M256 64C150 64 64 150 64 256s86 192 192 192h32v64H256C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256v96 32H480 440c-36 0-68.2-15.8-90.2-40.9C326.4 368.3 293 384 256 384c-70.7 0-128-57.3-128-128s57.3-128 128-128c32.5 0 62.1 12.1 84.7 32H384v32 64 8c0 30.9 25.1 56 56 56h8V256c0-106-86-192-192-192zm64 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "rectangles-mixed": [576, 512, [], "e323", "M0 32H320V256H0V32zm384 0H576V384H384V32zM336 304V480H64V304H336z"],
    "phone-arrow-up-right": [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", "M144 0L0 32 0 64C0 311.4 200.6 512 448 512h32l32-144L368 288l-67 83.8C232.5 335.7 176.3 279.5 140.2 211L224 144 144 0zM303 175l-17 17L320 225.9l17-17 127-127V128v24h48V128 24 0H488 384 360V48h24 46.1L303 175z"],
    "trash-can": [448, 512, [61460, "trash-alt"], "f2ed", "M144 0H304l16 32H448V96H0V32H128L144 0zM32 128H416V512H32V128zm112 64H112v16V432v16h32V432 208 192zm96 0H208v16V432v16h32V432 208 192zm96 0H304v16V432v16h32V432 208 192z"],
    "circle-l": [512, 512, [], "e114", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 152V336H328h24v48H328 184 160V360 152 128h48v24z"],
    "head-side-goggles": [512, 512, ["head-vr"], "f6ea", "M45.9 128C75.3 53.1 148.3 0 233.7 0H256c39.3 0 75.8 11.8 106.2 32H304c-61.9 0-112 50.1-112 112c0 17.2 3.9 33.5 10.8 48H32.2 32 0V128H32 45.9zM304 256H508.2l3.8 4.8V272v16 32H480 448v96 32H416 320v32 32H288 128 96V480 349.3l-4.9-4.9c-32.5-32.5-52.8-75-57.8-120.3H225.6c20.2 19.8 47.9 32 78.4 32zm0-192H416V224H304c-44.2 0-80-35.8-80-80s35.8-80 80-80zM512 224H448V64h64V224z"],
    "text-height": [576, 512, [], "f034", "M32 32H0V64v64 32H64V128 96h64l0 320H96 64v64H96 224h32V416H224 192l0-320h64v32 32h64V128 64 32H288 192 128 32zm448 0l-96 96v32h64V352H384v32l96 96 96-96V352H512V160h64V128L480 32z"],
    "user-xmark": [640, 512, ["user-times"], "f235", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM384 304l64 208H0L64 304H384zM633.9 160l-17 17-47 47 47 47 17 17L600 321.9l-17-17-47-47-47 47-17 17L438.1 288l17-17 47-47-47-47-17-17L472 126.1l17 17 47 47 47-47 17-17L633.9 160z"],
    "face-hand-yawn": [512, 512, [], "e379", "M336.9 498.9C438.7 465.1 512 369.1 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256c0 94.5 51.2 177 127.3 221.4c-9.8-18-15.3-38.6-15.3-60.5V334.4v-32h32 17.6C169.9 257.8 209 224 256 224c25.5 0 48.7 10 65.9 26.2l6.1-6.1 22.6 22.6 22.6 22.6L395.9 312l-16 16 9.4 9.4L411.9 360l-22.6 22.6-9.4 9.4 9.4 9.4L411.9 424l-22.6 22.6-52.3 52.3zM214.5 114.5l-12.5 10-80 64-12.5 10-20-25 12.5-10 80-64 12.5-10 20 25zm95.5 10l-12.5-10 20-25 12.5 10 80 64 12.5 10-20 25-12.5-10-80-64zM302.6 296L280 273.4l-11.3 11.3L184 369.4v-15-20H144v20V384v20 12.8c0 52.6 42.6 95.2 95.2 95.2c25.2 0 49.5-10 67.3-27.9l48.8-48.8L366.6 424 344 401.4l-11.3 11.3-24 24-9.4-9.4 56-56L366.6 360 344 337.4l-11.3 11.3-56 56-9.4-9.4 72-72L350.6 312 328 289.4l-11.3 11.3-72 72-9.4-9.4 56-56L302.6 296z"],
    "gauge-simple-min": [512, 512, ["tachometer-slowest"], "f62d", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-35.3-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6 80.2 215 55 255.8l20.4 12.6 117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "stethoscope": [576, 512, [129658], "f0f1", "M119.3 1.2l15.5 62.1-31 7.8L96 73V192c0 53 43 96 96 96s96-43 96-96V73L280.2 71l-31-7.8L264.7 1.2l31 7.8 32 8L352 23V48 192c0 77.2-54.6 141.6-127.3 156.7C231 404.6 278.4 448 336 448c61.9 0 112-50.1 112-112V265.3c-28.3-12.3-48-40.5-48-73.3c0-44.2 35.8-80 80-80s80 35.8 80 80c0 32.8-19.7 61-48 73.3V336c0 97.2-78.8 176-176 176c-92.9 0-168.9-71.9-175.5-163.1C87.2 334.2 32 269.6 32 192V48 23L56.2 17l32-8 31-7.8zM480 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "coffin": [384, 512, [9904], "f6c6", "M0 144L104 512H280L384 144 272 0H112L0 144z"],
    "message": [512, 512, ["comment-alt"], "f27a", "M512 0H0V416H160v96l144-96H512V0z"],
    "salad": [512, 512, [129367, "bowl-salad"], "f81e", "M416 96c2.6 0 5.2 .1 7.8 .2C406.2 76.5 380.5 64 352 64c-8.7 0-17.2 1.2-25.3 3.4C309.5 27.7 270 0 224 0s-85.5 27.7-102.7 67.4c-8-2.2-16.5-3.4-25.3-3.4C43 64 0 107 0 160s43 96 96 96h73.4L84.7 171.3 73.4 160 96 137.4l11.3 11.3L208 249.4V112 96h32v16V256h52c-2.6-10.2-4-21-4-32c0-70.7 57.3-128 128-128zm96 192H0v24c0 67 39.2 124.9 96 151.8V512H416V463.8c56.8-27 96-84.8 96-151.8V288zm0-64c0-53-43-96-96-96s-96 43-96 96c0 11.2 1.9 22 5.5 32H506.5c3.5-10 5.5-20.8 5.5-32z"],
    "info": [192, 512, [], "f129", "M128 32v80H48V32h80zM0 192H32 96h32v32V448h32 32v64H160 128 64 32 0V448H32 64V256H32 0V192z"],
    "robot-astromech": [512, 512, [], "e2d2", "M128 128v32H384V128C384 57.3 326.7 0 256 0S128 57.3 128 128zm96-64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 48a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM0 512H128V384l64 64H320l64-64V512H512V480l-48-64V192H48V416L0 480v32zM208 256h96 16v32H304 208 192V256h16zm0 64h96 16v32H304 208 192V320h16z"],
    "ring-diamond": [384, 512, [], "e5ab", "M128 0L96 72l35.8 65.6C55.2 162.9 0 235 0 320C0 426 86 512 192 512s192-86 192-192c0-85-55.2-157.1-131.8-182.4L288 72 256 0H128zM320 320A128 128 0 1 1 64 320a128 128 0 1 1 256 0z"],
    "fondue-pot": [512, 512, [129749], "e40d", "M392.9 172.4l-13.3-8.9-19 28.5H322.1l30.8-46.2-13.3-8.9L430.9 0l53.3 35.5L392.9 172.4zM231.5 192l9.2-36.8-15.5-3.9L263 0l62.1 15.5L287.3 166.8l-15.5-3.9L264.5 192h-33zM0 224H64v16 64 16H96V304 256h32v16 16h32V272 240 224H352h32 64 32 32v64H480 448v32c0 52.3-25.1 98.8-64 128v32 32H320V480v-3.2c-10.3 2.1-21 3.2-32 3.2H160c-11 0-21.7-1.1-32-3.2V480v32H64V480 448C25.1 418.8 0 372.3 0 320V224z"],
    "theta": [384, 512, [], "f69e", "M64 256c0-51 15.9-96 40.2-127.6C128.5 96.9 159.8 80 192 80s63.5 16.9 87.8 48.4C304.1 160 320 205 320 256s-15.9 96-40.2 127.6C255.5 415.1 224.2 432 192 432s-63.5-16.9-87.8-48.4C79.9 352 64 307 64 256zM192 16C135.8 16 87.1 45.7 53.5 89.4C19.9 133.1 0 192.1 0 256s19.9 122.9 53.5 166.6C87.1 466.3 135.8 496 192 496s104.9-29.7 138.5-73.4C364.1 378.9 384 319.9 384 256s-19.9-122.9-53.5-166.6C296.9 45.7 248.2 16 192 16zM128 224H96v64h32H256h32V224H256 128z"],
    "face-hand-peeking": [640, 512, [129763], "e481", "M552.4 363.5c-10.1 3.5-20.7 5.4-31.6 5.4H512 488h-8H456h-8v-32h8 24V328H456h-8l-8 0-16 0-16 0V296h34.6H448h32v-8H452.4 408V256l58.6 0 7.4 0 6 0h2.7l8.7 0V243.8l-12.1-8.7-4.9-3.5L414.7 189l18.6-26 40.1 27.5 24 16.4 19.5 13.4 17 11.6 11.6 8V220.4l-8.2-8.2-22.6-22.6 5.6-5.6 0 0 17-17 5.7-5.7 22.6 22.6 .1 .1 22.4 22.4 .8 .8c36.4 37.2 36.1 96.9-.8 133.8c-10.2 10.2-22.4 17.8-35.7 22.5zm-31.6 37.4c3.5 0 7.1-.1 10.6-.4C485.3 467.8 407.8 512 320 512c-105.9 0-196.8-64.3-235.7-156c11.3 3.2 23 4.9 34.9 4.9H192h32v-32V320h16 32V288v-8V256v-8-8V224v-8-8V184v-8V144H240 176.1l10.4-10.4L163.9 111 135.6 82.7l-2.1-2.1C180.2 31 246.5 0 320 0c92 0 172.6 48.5 217.7 121.3l-17.4 17.4-26.9 26.8-42.1-28.9-25.9-17.8-13.8 19.4c-6.3-1.4-12.9-2.2-19.7-2.2c-48.6 0-88 39.4-88 88c0 43.1 31 79 72 86.5V328v32h32 16v8.9 32h32 64.8zm-401.6-72c-17.1 0-33.7-4.6-48.2-13.1c-6.9-4.1-13.4-9-19.1-14.8c-36.9-36.9-37.2-96.6-.8-133.8l.8-.8L113 105.3l0 0 5.6 5.6 17 17 5.7 5.7L130.8 144l-12.2 12.2-6.1 6.1L98.8 176h19.3H128h16.1H160h48 32 0v32h0H208 192 160v8l32 0h16 32 0v8 16 8h0H208l-16 0H160v8l32 0h16 32v0l.3 32H240l-16 0-16 0H192l0 0-32 0v8.9h32V320v8.9H160h0l-32 0-8.8 0zM384 400c0-26.5-28.7-48-64-48s-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48zm32.4-176c0 6.1-2.3 11.8-6.1 16H374.5c-3.8-4.2-6.1-9.9-6.1-16c0-13.3 10.7-24 24-24s24 10.7 24 24z"],
    "square-user": [448, 512, [], "e283", "M368 416l-32-96H112L80 416H368zM0 32H64 384h64V96 416v64H384 64 0V416 96 32zM224 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144z"],
    "down-left-and-up-right-to-center": [512, 512, ["compress-alt"], "f422", "M272 80l32-32 52 52L456 0l56 56L412 156l52 52-32 32H272V80zM240 432l-32 32-52-52L56 512 0 456 100 356 48 304l32-32H240V432z"],
    "explosion": [576, 512, [], "e4e9", "M144 368L0 320l82.3 96H197.5c13.2-37.3 48.7-64 90.5-64s77.4 26.7 90.5 64H493.7L576 320 432 368 544 0 336 296 312 128H264L240 304 96 192l48 176zM312 0H264V24 72 96h48V72 24 0zM32 448H0v64H32 544h32V448H544 32z"],
    "file-lines": [384, 512, [128441, 128462, 61686, "file-alt", "file-text"], "f15c", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM112 256H272h16v32H272 112 96V256h16zm0 64H272h16v32H272 112 96V320h16zm0 64H272h16v32H272 112 96V384h16z"],
    "wave-square": [640, 512, [], "f83e", "M128 32h32H320h32V64 416h96V256 224h32H608h32v64H608 512V448v32H480 320 288V448 96H192V256v32H160 32 0V224H32h96V64 32z"],
    "ring": [512, 512, [], "f70b", "M64 184.3v51C106.8 212.1 170 192 256 192s149.2 20.1 192 43.3v-51c-23.1-20-82.6-56.3-192-56.3s-168.9 36.3-192 56.3zM512 192v88.1V288v16 32 16c-21.3 32-102.4 96-256 96S21.3 384 0 352V336 304 288v-7.9V192 160c21.3-32 102.4-96 256-96s234.7 64 256 96v32zM400.1 265.6C365.8 251.5 318.4 240 256 240s-109.8 11.5-144.1 25.6C150 278.8 197.8 288 256 288s106-9.2 144.1-22.4z"],
    "building-un": [384, 512, [], "e4d9", "M384 0H0V512H144V384h96V512H384V0zM64 224h64v64H64V224zm160 0v64H160V224h64zm32 64V224h64v64H256zM112 80v64c0 8.8 7.2 16 16 16s16-7.2 16-16V80 64h32V80v64c0 26.5-21.5 48-48 48s-48-21.5-48-48V80 64h32V80zM224 64h8 9.9l4.4 8.8L272 124.2V80 64h32V80v96 16H288h-8-9.9l-4.4-8.8L240 131.8V176v16H208V176 80 64h16z"],
    "dice-three": [448, 512, [9858], "f527", "M448 32H0V480H448V32zM128 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "tire-pressure-warning": [512, 512, [], "f633", "M384 32V0h64V32 54.5c0 24.1 3.9 48 11.5 70.8l2.5 7.4c4.8 14.4 11.5 28.6 19.3 44.4c17.5 35.6 33.4 82.6 27.5 136.2c-5.3 48.6-28.1 99-76.8 148.7v50H368V488H336v24H272V488H240v24H176V488H144v24H80V462C31.3 412.3 8.6 361.9 3.2 313.3c-5.9-53.6 9.9-100.6 27.5-136.2c7.8-15.8 14.5-30 19.3-44.4l2.5-7.4C60.1 102.5 64 78.5 64 54.5V32 0h64V32 54.5c0 31-5 61.7-14.8 91.1l-2.5 7.4c-6.3 19-14.8 36.6-22.6 52.5c-14.7 29.7-25.3 64-21.3 100.9c3.7 34 20.4 74.1 65.7 117.7H379.4c45.3-43.6 62-83.7 65.7-117.7c4.1-36.9-6.6-71.1-21.3-100.9c-7.8-15.8-16.3-33.5-22.6-52.5l-2.5-7.4C389 116.2 384 85.4 384 54.5V32zM280 120V232v24H232V232 120 96h48v24zm0 168v48H232V288h48z"],
    "wifi-fair": [640, 512, ["wifi-2"], "f6ab", "M171.8 312c39.5-34.9 91.3-56 148.2-56s108.7 21.1 148.2 56l42.4-48C459.8 219.2 393 192 320 192s-139.8 27.2-190.5 72l42.4 48zM320 480a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M160 0V64H288V0h64V64h96v96H0V64H96V0h64zM0 192H448V512H0V192zM64 320h64V256H64v64zm128-64v64h64V256H192zm192 64V256H320v64h64zM64 448h64V384H64v64zm192-64H192v64h64V384zm64 64h64V384H320v64z"],
    "mp3-player": [384, 512, [], "f8ce", "M0 0H384V512H0V0zM192 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 128a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM320 64H64V192H320V64z"],
    "anchor-circle-check": [640, 512, [], "e4aa", "M320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm21.1 80C367 158.8 384 129.4 384 96c0-53-43-96-96-96s-96 43-96 96c0 33.4 17 62.8 42.9 80H224 192v64h32 32V448H128V352h64L96 256 0 352H64V480v32H96 288 394.8c-23.3-16.4-42.5-38.4-55.6-64H320V368.5l0-.5 0-.5V240h32 23.2c2.8-2.7 5.8-5.3 8.8-7.8V176H352 341.1zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-65.4-32l-11.3 11.3-72 72L480 430.6l-11.3-11.3-40-40L417.4 368 440 345.4l11.3 11.3L480 385.4l60.7-60.7L552 313.4 574.6 336z"],
    "tally-4": [640, 512, [], "e297", "M160 64V32H96V64 448v32h64V448 64zm128 0V32H224V64 448v32h64V448 64zM416 32H352V64 448v32h64V448 64 32zM544 64V32H480V64 448v32h64V448 64z"],
    "rectangle-history": [512, 512, [], "e4a2", "M512 512l0-352L0 160 0 512l512 0zM464 80L48 80l0 48 416 0 0-48zM416 0L96 0l0 48 320 0 0-48z"],
    "building-circle-arrow-right": [640, 512, [], "e4d1", "M0 0H384V232.2c-39.1 32.3-64 81.1-64 135.8s24.9 103.5 64 135.8V512H240V384H144V512H0V0zM128 224H64v64h64V224zm32 0v64h64V224H160zm160 0H256v64h64V224zM64 96v64h64V96H64zm160 0H160v64h64V96zm32 0v64h64V96H256zm96 272a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm152-78.6L481.4 312l11.3 11.3L521.4 352H432 416v32h16 89.4l-28.7 28.7L481.4 424 504 446.6l11.3-11.3 56-56L582.6 368l-11.3-11.3-56-56L504 289.4z"],
    "volleyball": [512, 512, [127952, "volleyball-ball"], "f45f", "M0 256c0 49.6 14.1 96 38.6 135.2L55.8 286l.6-4 2.4-3.2L175.1 126.7 87 63.7C33.7 110.6 0 179.4 0 256zM143 485.8l11.2-114.6 .4-4.4 2.6-3.5L237.6 254l-43.5-99.4L86.7 295.1 65.2 426.7C87 451 113.4 471.2 143 485.8zm30.9 12.8c25.8 8.7 53.4 13.4 82.1 13.4c97.7 0 182.7-54.8 225.8-135.3l-99.7 37.7-3.7 1.4-4-.5L184.5 390.7 173.9 498.6zM499.3 335.9c8.2-25.1 12.7-52 12.7-79.9c0-5.7-.2-11.4-.6-17L406.6 286.6l-4 1.8-4.4-.5-134.8-15-64.3 87.4L374.5 383l124.8-47.2zM374.8 253.1l-68-163.3L203.5 5.4c-32.7 6.8-63.2 19.9-90 37.9l93.7 67 3.6 2.6 1.8 4 54.4 124.2 107.8 12zm132.3-47.3C483.7 88.4 380.2 0 256 0c-2.8 0-5.6 0-8.3 .1l82.5 67.5 3.1 2.5 1.5 3.7 73.6 176.8 98.7-44.8z"],
    "sun-haze": [640, 512, [], "f765", "M320 73.1L214 0 190.7 126.7 64 150l73.1 106 0 0H192v0c0-70.7 57.3-128 128-128s128 57.3 128 128v0h54.9l0 0L576 150 449.3 126.7 426 0 320 73.1zM224 256v0H416v0c0-53-43-96-96-96s-96 43-96 96zm392 32H504 480v48h24H616h24V288H616zm-208 0H88 64v48H88 408h24V288H408zm144 88H24 0v48H24 552h24V376H552zM64 464v48H88 200h24V464H200 88 64zm208 0v48h24H616h24V464H616 296 272z"],
    "text-size": [640, 512, [], "f894", "M32 32H0V64v64 32H64V128 96h96l0 320H128 96v64h32H256h32V416H256 224l0-320h96v32 32h64V128 64 32H352 224 160 32zM352 224H320v32 32 32h64V288h64l0 128H432 400v64h32 96 32V416H528 512l0-128h64v32h64V288 256 224H608 352z"],
    "ufo": [640, 512, [128760], "e047", "M320 112c59.2 0 109.6 37.9 128.3 90.7c5 14.2 7.7 29.4 7.7 45.3c0 0-40 40-136 40s-136-40-136-40c0-15.9 2.7-31.1 7.7-45.3c18.7-52.8 69-90.7 128.3-90.7zm0-48c-90.1 0-165.2 64.8-180.9 150.4C55.1 237.5 0 276.2 0 320c0 70.7 143.3 128 320 128s320-57.3 320-128c0-43.8-55.1-82.5-139.1-105.6C485.2 128.8 410.2 64 320 64zm0 280l32 32-32 32-32-32 32-32zM96 328l32-32 32 32-32 32L96 328zm416-32l32 32-32 32-32-32 32-32z"],
    "fork": [512, 512, ["utensil-fork"], "f2e3", "M408 8l16 16L320 128l16 16L448 48l16 16L368 176l16 16L488 88l16 16L433.5 227.4C417.7 255 388.4 272 356.6 272c-19.4 0-38.1-6.4-53.4-18L70.6 486.6 48 509.3 2.7 464l22.6-22.6L258 208.8c-11.6-15.3-18-34-18-53.4c0-31.8 17-61.1 44.6-76.8L408 8z"],
    "arrows-up-to-line": [576, 512, [], "e4c2", "M32 96l512 0 32 0 0-64-32 0L32 32 0 32 0 96l32 0zM48 285.3l22.6-22.6L96 237.3 96 448l0 32 64 0 0-32 0-210.7 25.4 25.4L208 285.3 253.3 240l-22.6-22.6-80-80L128 114.7l-22.6 22.6-80 80L2.7 240 48 285.3zm320 0l22.6-22.6L416 237.3 416 448l0 32 64 0 0-32 0-210.7 25.4 25.4L528 285.3 573.3 240l-22.6-22.6-80-80L448 114.7l-22.6 22.6-80 80L322.7 240 368 285.3z"],
    "mobile-signal": [512, 512, [], "e1ef", "M64 64H288V306.5c18.8-20.4 40.3-38.3 64-53V64 0H288 64 0V64 448v64H64 208c0-22 2.3-43.4 6.7-64H64V64zM224 384H208 144 128v32h16 64 15.5l.5-1.6V384zm288-80V256c-141.4 0-256 114.6-256 256h48c0-114.9 93.1-208 208-208zM480 512a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-80 0c0-61.9 50.1-112 112-112V352c-88.4 0-160 71.6-160 160h48z"],
    "barcode-scan": [640, 512, [], "f465", "M128 32H64V192h64V32zM64 480h64V320H64V480zm96 0h32V320H160V480zm64 0h64V320H224V480zm0-288h64V32H224V192zm96 288h64V320H320V480zm0-288h64V32H320V192zM448 480h32V320H448V480zm0-288h32V32H448V192zm64 288h64V320H512V480zm0-288h64V32H512V192zm-352 0h32V32H160V192zM0 232v48H640V232H0z"],
    "sort-down": [320, 512, ["sort-desc"], "f0dd", "M0 336L160 480 320 336V288H0v48z"],
    "folder-arrow-down": [512, 512, ["folder-download"], "e053", "M512 96V480H0V32H224l48 64H512zM280 200V176H232v24V302.1l-31-31-17-17L150.1 288l17 17 72 72 17 17 17-17 72-72 17-17L328 254.1l-17 17-31 31V200z"],
    "circle-minus": [512, 512, ["minus-circle"], "f056", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 232H328h24v48H328 184 160V232h24z"],
    "face-icicles": [512, 512, [], "e37c", "M512 256c0 10.7-.7 21.3-1.9 31.6L495.9 450.8 490.6 512H437.4l-5.3-61.2-.7-8.3c-7.5 7-15.4 13.6-23.7 19.8l-6.4 14.6L385.9 512H358.1l-7.8-17.9c-29.2 11.6-61 17.9-94.2 17.9c-66.4 0-126.9-25.3-172.4-66.8l-.5 2.8H28.9l-4.5-26.7L6.5 313.4C2.2 294.9 0 275.7 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256zM56 415.8l0 .2 0-.2L80 272H32L56 415.8zM344 400l28 64 28-64V360l-56 0v40zm56-56V304H344v40l56 0zm-72 0V304H264v40h64zm0 56V360H264v40l32 48 32-48zm-80-96H184v40l64 0V304zm0 56l-64 0v40h64V360zm-80-16V304H112v40h56zm0 56V360H112v40h56zm40.4-192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM488 224H440l24 224 24-224z"],
    "shovel": [512, 512, [], "f713", "M338.7 45.3L384 0l45.3 45.3 37.5 37.5L512 128l-45.3 45.3-24.2 24.2c-17 17-40 26.5-64 26.5c-13.3 0-25.9-2.9-37.3-8L238.6 318.6 304 384 176 512H0V336L128 208l65.4 65.4L296 170.7c-5.1-11.4-8-24-8-37.3c0-24 9.5-47 26.5-64l24.2-24.2zM421.5 128L384 90.5l-24.2 24.2c-5 5-7.8 11.7-7.8 18.7c0 14.6 11.9 26.5 26.5 26.5c7 0 13.8-2.8 18.7-7.8L421.5 128z"],
    "door-open": [576, 512, [], "f52b", "M320 0L64 64V448H32 0v64H32 64 320V0zM256 256c0 17.7-10.7 32-24 32s-24-14.3-24-32s10.7-32 24-32s24 14.3 24 32zm96-128h96V480v32h32 64 32V448H544 512V96 64H480 352v64z"],
    "films": [576, 512, [], "e17a", "M576 32H96V384H576V32zM200 80v48H152V80h48zm272 0h48v48H472V80zM200 184v48H152V184h48zm272 0h48v48H472V184zM200 288v48H152V288h48zm272 0h48v48H472V288zM416 80V192H256V80H416zM256 224H416V336H256V224zM48 120V96H0v24V456v24H24 456h24V432H456 48V120z"],
    "right-from-bracket": [512, 512, ["sign-out-alt"], "f2f5", "M352 96L512 256 352 416l-32 0 0-96-160 0 0-128 160 0 0-96 32 0zM160 96L64 96l0 320 96 0 32 0 0 64-32 0L32 480 0 480l0-32L0 64 0 32l32 0 128 0 32 0 0 64-32 0z"],
    "face-glasses": [512, 512, [], "e377", "M512 256c0 141.4-114.6 256-256 256S0 397.4 0 256c0-22.1 2.8-43.5 8.1-64H48v96 16H64 224h16V288 192h32v96 16h16H448h16V288 192h39.9c5.3 20.5 8.1 41.9 8.1 64zM256 0C363.4 0 455.4 66.2 493.4 160H464V144 128H448 288 272v16 16H240V144 128H224 64 48v16 16H18.6C56.6 66.2 148.6 0 256 0zM80 272V192 160H208V272H80zM256 416c71.6 0 113.7-47.7 126.3-72.8l-28.6-14.3C344.9 346.3 312.4 384 256 384s-88.9-37.7-97.7-55.2l-28.6 14.3C142.3 368.3 184.4 416 256 416zm48-144V160H432v32 80H304zM184.4 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm168 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "nfc": [448, 512, [], "e1f7", "M0 32H448V480H0V32zM64 96v16V400v16H80 368h16V400 112 96H368 224 208v16 98.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V128H352V384H96V128h48 16V96H144 80 64z"],
    "atom": [512, 512, [9883], "f5d2", "M256 328c9.4-4.8 19-10.2 28.8-16c12.1-7.3 23.6-14.8 34.2-22.4c.7-10.8 1-22 1-33.6s-.4-22.7-1-33.6c-10.6-7.6-22.1-15.1-34.2-22.4c-9.7-5.8-19.3-11.2-28.8-16c-9.4 4.8-19 10.2-28.8 16c-12.1 7.3-23.6 14.8-34.2 22.4c-.7 10.8-1 22-1 33.6s.4 22.7 1 33.6c10.6 7.6 22.1 15.1 34.2 22.4c9.7 5.8 19.3 11.2 28.8 16zm190-72c33 45.2 44.3 90.9 23.6 128c-20.2 36.3-62.5 49.3-115.2 43.2c-22 52.1-55.6 84.8-98.4 84.8s-76.4-32.7-98.4-84.8c-52.7 6.1-95-6.8-115.2-43.2C21.7 346.9 33 301.2 66 256c-33-45.2-44.3-90.9-23.6-128c20.2-36.3 62.5-49.3 115.2-43.2C179.6 32.7 213.2 0 256 0s76.4 32.7 98.4 84.8c52.7-6.1 95 6.8 115.2 43.2c20.7 37.1 9.4 82.8-23.6 128zm-65.8 67.4c-1.7 14.2-3.9 28-6.7 41.2c31.8 1.4 38.6-8.7 40.2-11.7c2.3-4.2 7-17.9-11.9-48.1c-6.8 6.3-14 12.5-21.6 18.6zM256 398.8c-11.8 5.1-23.4 9.7-34.9 13.5c16.7 33.8 31 35.7 34.9 35.7s18.1-1.9 34.9-35.7c-11.4-3.9-23.1-8.4-34.9-13.5zM373.5 147.5c2.8 13.1 5 26.9 6.7 41.2c7.6 6.1 14.8 12.3 21.6 18.6c18.9-30.2 14.2-44 11.9-48.1c-1.6-2.9-8.4-13-40.2-11.7zM290.9 99.7C274.1 65.9 259.9 64 256 64s-18.1 1.9-34.9 35.7c11.4 3.9 23.1 8.4 34.9 13.5c11.8-5.1 23.4-9.7 34.9-13.5zm-159 88.9c1.7-14.3 3.9-28 6.7-41.2c-31.8-1.4-38.6 8.7-40.2 11.7c-2.3 4.2-7 17.9 11.9 48.1c6.8-6.3 14-12.5 21.6-18.6zM110.2 304.8C91.4 335 96 348.7 98.3 352.9c1.6 2.9 8.4 13 40.2 11.7c-2.8-13.1-5-26.9-6.7-41.2c-7.6-6.1-14.8-12.3-21.6-18.6zM256 296l-40-40 40-40 40 40-40 40z"],
    "soap": [512, 512, [129532], "e06e", "M208 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM320 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM416 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 160c0 24.6-9.2 47-24.4 64H416h32v32V416v32H416 96 64V416 288 256H96 248.4c-15.2-17-24.4-39.4-24.4-64H0V512H512V192H416zM96 416H416V288H320 96V416z"],
    "icons": [512, 512, ["heart-music-camera-bolt"], "f86d", "M128 224L236.1 115.9c12.7-12.7 19.9-30 19.9-48C256 30.4 225.6 0 188.1 0c-18 0-35.3 7.2-48 19.9L128 32 115.9 19.9C103.2 7.2 85.9 0 67.9 0C30.4 0 0 30.4 0 67.9c0 18 7.2 35.3 19.9 48L128 224zm329.1 32L320 400l72.2 10.5L374.9 512 512 368l-72.2-10.5L457.1 256zM96 272L74.7 304H0V512H288V304H213.3L192 272H96zm48 88a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM512 40V1L473.7 8.6l-160 32L288 45.8V72v88c-35.3 0-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48V98.2L448 79v49c-35.3 0-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48V40z"],
    "microphone-lines-slash": [640, 512, ["microphone-alt-slash"], "f539", "M416 0H224V151.1L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L472.4 344c15-25.9 23.6-56 23.6-88V216 192H448v24 8 32c0 21-5 40.7-14 58.2l-18-14V256H359.1L320 225.7V224h16 80V192H336 320V160h16 80V128H336 320V96h16 80V0zM401.3 412.2l-43.1-33.9C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128v-8.7l-48-37.8V216v40c0 89.1 66.2 162.7 152 174.4V464H248 224v48h24 72 72 24V464H392 344V430.4c20.4-2.8 39.7-9.1 57.3-18.2z"],
    "closed-captioning-slash": [640, 512, [], "e135", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7-12.9-10V32H70.5L48.4 14.8zM235.5 160.1c32.7 1.2 61.2 18.7 77.6 44.6L302 211.7l-66.5-51.6zm95.1 73.8c10-42.3 48-73.9 93.4-73.9c34.2 0 64.1 17.8 81.1 44.6l-40.5 25.7C456 216.9 441 208 424 208c-26.5 0-48 21.5-48 48c0 5.2 .8 10.3 2.4 15l-47.8-37.1zm90.2 70c1.1 .1 2.2 .1 3.2 .1c17 0 32-8.9 40.6-22.3l40.5 25.7c-9 14.1-21.6 25.8-36.5 33.6l-47.8-37.1zM32 480H487.4L295 328.4c-16.8 14.7-38.9 23.6-63 23.6c-53 0-96-43-96-96c0-16 3.9-31.1 10.8-44.3L32 121.2V480zM184 256c0 26.5 21.5 48 48 48c8.7 0 16.9-2.3 23.9-6.4l-70-55.1c-1.3 4.3-1.9 8.8-1.9 13.5z"],
    "calculator-simple": [512, 512, ["calculator-alt"], "f64c", "M0 0H224V224H0V0zM288 0H512V224H288V0zM512 288V512H288V288H512zM0 288H224V512H0V288zM416 64V48H384V64 96H352 336v32h16 32v32 16h32V160 128h32 16V96H448 416V64zM64 96H48v32H64h96 16V96H160 64zM83.3 348.7L72 337.4 49.4 360l11.3 11.3L89.4 400 60.7 428.7 49.4 440 72 462.6l11.3-11.3L112 422.6l28.7 28.7L152 462.6 174.6 440l-11.3-11.3L134.6 400l28.7-28.7L174.6 360 152 337.4l-11.3 11.3L112 377.4 83.3 348.7zM352 352H336v32h16 96 16V352H448 352zm0 64H336v32h16 96 16V416H448 352z"],
    "bridge-circle-check": [640, 512, [], "e4c9", "M64 32H32V96H64h40v64H32V288c53 0 96 43 96 96v96h96V384c0-53 43-96 96-96c6.3 0 12.4 .6 18.3 1.7C367.1 231.8 426.9 192 496 192c42.5 0 81.6 15.1 112 40.2V160H536V96h40 32V32H576 64zM488 96v64H408V96h80zM360 96v64H280V96h80zM232 96v64H152V96h80zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-65.4-32l-11.3 11.3-72 72L480 430.6l-11.3-11.3-40-40L417.4 368 440 345.4l11.3 11.3L480 385.4l60.7-60.7L552 313.4 574.6 336z"],
    "sliders-up": [512, 512, ["sliders-v"], "f3f1", "M128 0V32 64h48v48 64 48H128V480v32H64V480 224H16V176 112 64H64V32 0h64zM288 0V32 288h48v48 64 48H288v32 32H224V480 448H176V400 336 288h48V32 0h64zM448 32V96h48v48 64 48H448V480v32H384V480 256H336V208 144 96h48V32 0h64V32zM64 112v64h64V112H64zM288 336H224v64h64V336zm96-192v64h64V144H384z"],
    "location-minus": [384, 512, ["map-marker-minus"], "f609", "M192 512s192-208 192-320C384 86 298 0 192 0S0 86 0 192C0 304 192 512 192 512zM120 168H264h24v48H264 120 96V168h24z"],
    "pump-medical": [448, 512, [], "e06a", "M128 0V128H256V96h82.7l38.6 38.6L400 157.3 445.3 112 422.6 89.4l-48-48L365.3 32H352 256V0H128zM56 160L32 512H352L328 160H56zm160 96v24 32h32 24v48H248 216v32 24H168V392 360H136 112V312h24 32V280 256h48z"],
    "fingerprint": [512, 512, [], "f577", "M48 256C48 141.1 141.1 48 256 48c63.1 0 119.6 28.1 157.8 72.5l15.6 18.2 36.4-31.3L450.2 89.2C403.3 34.6 333.7 0 256 0C114.6 0 0 114.6 0 256v40 24H48V296 256zm458.5-52.9l-4.9-23.5-47 9.9 4.9 23.5c2.9 13.9 4.5 28.3 4.5 43.1v40 24h48V296 256c0-18.1-1.9-35.8-5.5-52.9zM256 80c-34.2 0-66 9.7-93 26.6l31.7 37c18.2-9.9 39.1-15.6 61.3-15.6c70.7 0 128 57.3 128 128v24.9c0 34.6-2.8 69.1-8.4 103.1h48.6c5.2-34 7.8-68.5 7.8-103.1V256c0-97.2-78.8-176-176-176zM126.1 137.3C97.5 168.6 80 210.3 80 256v24.9c0 35-5.5 69.8-16.2 103.1h50.1c9.3-33.5 14.1-68.2 14.1-103.1V256c0-31.1 11.1-59.7 29.6-81.9l-31.6-36.8zM256 160c-53 0-96 43-96 96v24.9c0 46-7.6 91.6-22.5 135.1h46.3c13.4-43.7 20.3-89.2 20.3-135.1V256c0-28.7 23.3-52 52-52s52 23.3 52 52v24.9c0 45.6-5.5 91-16.4 135.1h45.2c10.1-44.2 15.2-89.5 15.2-135.1V256c0-53-43-96-96-96zm24 96H232v24.9c0 59.9-11 119.3-32.5 175.2l-5.9 15.3-3.3 8.6h51.4l2.6-6.7C267.9 411.9 280 346.7 280 280.9V256z"],
    "ski-boot": [512, 512, [], "e3cc", "M48 272H159.7l48-240H96L48 272zm-6.4 32L0 512H512V448H480V352L326.4 288H272 256V256h16 60.8l12.8-64H288 272V160h16 64L384 0H320l-6.4 32H240c0 1-.1 2.1-.3 3.1l-51.2 256L185.9 304H172.8 41.6z"],
    "standard-definition": [576, 512, ["rectangle-sd"], "e28a", "M0 32H576V480H0V32zM304 160v24V328v24h24 56c53 0 96-43 96-96s-43-96-96-96H328 304zm48 48h32c26.5 0 48 21.5 48 48s-21.5 48-48 48H352V208zm-184.9 .1c7.4-2.4 19.5-2.9 36.2-.7l3-22.2-3 22.2c5.1 .7 21.1 3.4 25.7 4.4l21.8 5 10-43.7-21.8-5c-6.5-1.5-23.9-4.4-29.7-5.1c-18.9-2.5-38.9-3.1-56 2.5c-18.8 6.1-33.9 19.7-38.5 42.3c-.1 .4-.1 .8-.2 1.2c-1.7 11.4-.2 22.4 5 32.3c5.1 9.6 12.9 16.1 20.5 20.7c13.7 8.2 31.5 12.3 45.1 15.5l0 0 1.7 .4c16 3.7 27.1 6.5 34.1 10.7c3 1.8 3.8 3 3.9 3.3l0 0c.1 .1 .7 1.2 .2 4.7c-.4 2.7-1.2 3.8-1.7 4.3c-.7 .7-2.3 2-5.8 3.1c-7.7 2.4-20.1 2.9-36.9 .6c-7.4-1-20.3-4.8-31.4-8c-2.5-.7-5-1.4-7.2-2.1l-21.5-6.1-12.3 43.1 21.5 6.1c1.5 .4 3.3 .9 5.3 1.5l0 0c10.8 3.2 28.4 8.3 39.4 9.9l.1 0c18.9 2.5 39.2 3.1 56.4-2.3c8.9-2.8 17.8-7.5 24.9-15.2c7.3-7.8 11.8-17.6 13.4-28.5c1.7-11.4 .2-22.4-5-32.3c-5.1-9.6-12.9-16.1-20.5-20.7c-13.7-8.2-31.5-12.3-45.1-15.5l0 0-1.7-.4c-16-3.7-27.1-6.5-34.1-10.7c-3-1.8-3.8-3-3.9-3.3l0 0c-.1-.1-.6-1.1-.3-4.1c.9-4 2.8-6.2 8.3-8z"],
    "h1": [576, 512, [], "f313", "M64 96V64H0V96 256 416v32H64V416 288H256V416v32h64V416 256 96 64H256V96 224H64V96zm341 61.2l43-19.1V384H416 384v64h32 64 64 32V384H544 512V96 64H480 464h-6.8L451 66.8 384 96.5v70l21-9.3z"],
    "hand-point-right": [512, 512, [], "f0a4", "M512 96l0 64-240 0 0-64 240 0zM352 288l0 64-128 0 0-64 128 0zm32-32l-112 0 0-64 112 0 0 64zM320 384l0 64-128 0 0-64 128 0zM149 64l91 0 0 192-48 0-32 0 0-96 0-16-32 0 0 16 0 112 0 16 16 0 48 0 0 64-32 0 0 96C71.6 448 0 376.4 0 288l0-61.7c0-42.4 16.9-83.1 46.9-113.1l11.6-11.6C82.5 77.5 115.1 64 149 64z"],
    "magnifying-glass-location": [512, 512, ["search-location"], "f689", "M416 208c0 45.9-14.9 88.3-40 122.7L486.6 441.4 509.3 464 464 509.3l-22.6-22.6L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM288 176c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 64 80 144 80 144s80-80 80-144zm-112 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "message-bot": [640, 512, [], "e3b8", "M544 0H96V176H64V160H0v64H64V208H96V416H224v96l144-96H544V208h32v16h64V160H576v16H544V0zM160 96H480V288H160V96zm64 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "forward-step": [320, 512, ["step-forward"], "f051", "M256 96V64h64V96 416v32H256V416 256L0 448V64L256 256V96z"],
    "face-smile-beam": [512, 512, [128522, "smile-beam"], "f5b8", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM129.7 327.2l28.6-14.3c8.7 17.5 41.3 55.2 97.7 55.2s88.9-37.7 97.7-55.2l28.6 14.3C369.7 352.3 327.6 400 256 400s-113.7-47.7-126.3-72.8zM176 152c28 0 56 40 56 80c0 0-28-32-56-32s-56 32-56 32c0-40 28-80 56-80zm104 80c0-40 28-80 56-80s56 40 56 80c0 0-28-32-56-32s-56 32-56 32z"],
    "light-ceiling": [512, 512, [], "e016", "M224 162V0h64V162c126.3 15.7 224 123.5 224 254H0C0 285.5 97.7 177.7 224 162zm32 350c-35.3 0-64-28.7-64-64H320c0 35.3-28.7 64-64 64z"],
    "message-exclamation": [512, 512, ["comment-alt-exclamation"], "f4a5", "M0 0H512V416H304L160 512V416H0V0zM280 80H232v24V216v24h48V216 104 80zM232 272v48h48V272H232z"],
    "bowl-scoop": [448, 512, [127847, "bowl-shaved-ice"], "e3de", "M32 224C32 118 118 32 224 32s192 86 192 192H32zM4.5 300.7L0 256H448l-4.5 44.7C437 366.2 381.9 416 316.2 416H256l80 72v24H112V488l80-72H131.8C66.1 416 11 366.2 4.5 300.7z"],
    "square-x": [448, 512, [], "e286", "M448 32H0V480H448V32zm-98.9 96L253.9 256l95.2 128H289.3L224 296.2 158.7 384H98.9l95.2-128L98.9 128h59.8L224 215.8 289.3 128h59.8z"],
    "utility-pole-double": [512, 512, [], "e2c4", "M288 0V32 64h96V56 32h48V56v8h32V56 32h48V56v8V96v24 8H480 428.8L288 221.9V256h96v-8V224h48v24 8h32v-8V224h48v24 8 32 24 8H480 428.8L288 413.9V480v32H224V480 413.9L83.2 320H32 0v-8V288 256v-8V224H48v24 8H80v-8V224h48v24 8h96V221.9L83.2 128H32 0v-8V96 64 56 32H48V56v8H80V56 32h48V56v8h96V32 0h64zM140.8 128L224 183.4V128H140.8zM288 183.4L371.2 128H288v55.4zM140.8 320L224 375.4V320H140.8zM288 375.4L371.2 320H288v55.4z"],
    "flag-checkered": [448, 512, [127937], "f11e", "M64 0V32 48l69-17.2c38.1-9.5 78.3-5.1 113.5 12.5c43.2 21.6 93.4 23 137.6 4.4c3.2-1.4 6.4-2.8 9.6-4.4L448 16V87.6 368l-55.5 20.8c-46.2 17.3-97.6 14.6-141.7-7.4c-37.9-19-81.3-23.7-122.5-13.4L64 384v96 32H0V480 400 334 64 32 0H64zm0 187.1l64-13.9v65.5L64 252.6V318l48.8-12.2c5.1-1.3 10.1-2.4 15.2-3.3V238.7l38.9-8.4c8.3-1.8 16.7-2.5 25.1-2.1l0-64c13.6 .4 27.2 2.6 40.4 6.4l23.6 6.9v66.7l-41.7-12.3c-7.3-2.1-14.8-3.4-22.3-3.8v71.4c21.8 1.9 43.3 6.7 64 14.4V244.2l22.7 6.7c13.5 4 27.3 6.4 41.3 7.4V194c-7.8-.8-15.6-2.3-23.2-4.5l-40.8-12v-62c-13-3.8-25.8-8.8-38.2-15c-8.2-4.1-16.9-7-25.8-8.8v72.4c-13-.4-26 .8-38.7 3.6L128 173.2V98L64 114v73.1zM320 335.7c16.8 1.5 33.9-.7 50-6.8l14-5.2V251.9l-7.9 1.8c-18.4 4.3-37.3 5.7-56.1 4.5v77.4zm64-149.4V115.4c-20.9 6.1-42.4 9.1-64 9.1V194c13.9 1.4 28 .5 41.7-2.6l22.3-5.2z"],
    "chevrons-up": [512, 512, ["chevron-double-up"], "f325", "M278.6 41.4L256 18.7 233.4 41.4l-192 192L18.7 256 64 301.3l22.6-22.6L256 109.3 425.4 278.6 448 301.3 493.3 256l-22.6-22.6-192-192zm0 192L256 210.7l-22.6 22.6-192 192L18.7 448 64 493.3l22.6-22.6L256 301.3 425.4 470.6 448 493.3 493.3 448l-22.6-22.6-192-192z"],
    "football": [512, 512, [127944, "football-ball"], "f44e", "M247.5 25.4c-13.5 3.3-26.4 7.2-38.6 11.7C142.9 61.6 96.7 103.6 66 153.6c-18.3 29.8-30.9 62.3-39.2 95.4L264.5 486.6c13.5-3.3 26.4-7.2 38.6-11.7c66-24.5 112.2-66.5 142.9-116.5c18.3-29.8 30.9-62.3 39.1-95.3L247.5 25.4zM495.2 205.3c6.1-56.8 1.4-112.2-7.7-156.4l-4.4-21.5-21.6-3.6c-58.2-9.7-109.9-12-155.6-7.9L495.2 205.3zM206.1 496L16.8 306.7c-6.1 56.8-1.4 112.2 7.7 156.4l4.4 21.5 21.6 3.6c58.2 9.7 109.9 12 155.6 7.9zM272 153.4l11.3 11.3 64 64L358.6 240 336 262.6l-11.3-11.3-64-64L249.4 176 272 153.4zm-48 48l11.3 11.3 64 64L310.6 288 288 310.6l-11.3-11.3-64-64L201.4 224 224 201.4zm-48 48l11.3 11.3 64 64L262.6 336 240 358.6l-11.3-11.3-64-64L153.4 272 176 249.4z"],
    "user-vneck": [448, 512, [], "e461", "M224 0a128 128 0 1 0 0 256A128 128 0 1 0 224 0zm0 432L138.7 304H64L0 512H448L384 304H309.3L224 432z"],
    "school-circle-exclamation": [640, 512, [], "e56c", "M640 96V266.8C608.1 221.6 555.5 192 496 192c-38.5 0-74.2 12.4-103.1 33.4c9.6-14.1 15.1-31.1 15.1-49.4c0-48.6-39.4-88-88-88s-88 39.4-88 88s39.4 88 88 88c15.6 0 30.2-4 42.9-11.1c-23.4 27.1-38.8 61.4-42.2 99.1H320c-35.3 0-64 28.7-64 64v96H0V96H160L320 0 480 96H640zM144 192H80v96h64V192zm0 128H80v96h64V320zM336 128v16 16h16 16v32H352 320 304V176 144 128h32zm160 96a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224V416H480v32h32zm0-176H480v16 80 16h32V368 288 272z"],
    "crop": [512, 512, [], "f125", "M128 0V32 64v64V338.7L338.7 128 192 128H160V64h32l210.7 0 38.6-38.6L464 2.7 509.3 48 486.6 70.6 448 109.3 448 384h32 32v64H480 448v32 32H384V480 448 384l0-210.7L173.3 384H320h32v64H320 96 64V416 128H32 0V64H32 64V32 0h64z"],
    "angles-down": [448, 512, ["angle-double-down"], "f103", "M246.6 470.6L224 493.3l-22.6-22.6-160-160L18.7 288 64 242.7l22.6 22.6L224 402.7 361.4 265.4 384 242.7 429.3 288l-22.6 22.6-160 160zm0-192L224 301.3l-22.6-22.6-160-160L18.7 96 64 50.7 86.6 73.4 224 210.7 361.4 73.4 384 50.7 429.3 96l-22.6 22.6-160 160z"],
    "users-rectangle": [640, 512, [], "e594", "M32 0H0V32 480v32H32 608h32V480 32 0H608 32zM64 448V64H576V448H64zM223.8 176a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM120 256L96 336h94.3l19.4-58.1 7.3-21.9H120zm329.7 80H544l-24-80H423.1l7.3 21.9L449.7 336zM432 384l-16-48-16-48H382.4 257.6 240l-16 48-16 48H432zm80-208a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM320 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "people-roof": [640, 512, [], "e537", "M335.6 12.1L320 3.3l-15.6 8.7-272 152L4.5 179.7l31.2 55.9 27.9-15.6L320 76.7 576.4 219.9l27.9 15.6 31.2-55.9-27.9-15.6-272-152zM320 240a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM144 336a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm392-40a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM96 352H81.9L75 364.3 19 465.1l-11.7 21 42 23.3 11.7-21 27-48.6V512H200V439.8l27 48.6 11.7 21 42-23.3-11.7-21-35.2-63.4 3.4-6.3L264 345.5V432H376V345.5l26.9 49.9 3.4 6.3L371 465.1l-11.7 21 42 23.3 11.7-21 27-48.6V512H552V439.8l27 48.6 11.7 21 42-23.3-11.7-21L565 364.3 558.1 352H544 448 434l-44.9-83.4L382.3 256H368 272 257.7l-6.8 12.6L206 352H192 96z"],
    "square-arrow-right": [448, 512, ["arrow-square-right"], "f33b", "M448 480l0-448L0 32 0 480l448 0zM361 273L249 385l-17 17L198.1 368l17-17 71-71L104 280l-24 0 0-48 24 0 182.1 0-71-71-17-17L232 110.1l17 17L361 239l17 17-17 17z"],
    "location-plus": [384, 512, ["map-marker-plus"], "f60a", "M192 512s192-208 192-320C384 86 298 0 192 0S0 86 0 192C0 304 192 512 192 512zM168 304V280 216H104 80V168h24 64V104 80h48l0 24v64h64 24v48H280 216v64 24H168z"],
    "lightbulb-exclamation-on": [640, 512, [], "e1ca", "M449.2 297.8c-19.8 27.1-39.7 54.4-49.2 86.2H240c-9.6-31.9-29.5-59.1-49.2-86.2l0 0 0 0c-5.2-7.1-10.4-14.2-15.4-21.4C155.6 247.9 144 213.3 144 176C144 78.8 222.8 0 320 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4l0 0 0 0zM240 512V416H400v96H240zM344 88V64H296V88 200v24h48V200 88zM296 256v48h48V256H296zM87.3 16l6 4 24 16 20 13.3L110.7 89.3 90.7 76l-24-16-6-4-20-13.3L67.3 2.7 87.3 16zM579.3 56l-6 4-24 16-20 13.3L502.7 49.3l20-13.3 24-16 6-4 20-13.3 26.6 39.9L579.3 56zM24 160H72 96v48H72 24 0V160H24zm544 0h48 24v48H616 568 544V160h24zM117.3 332l-24 16-6 4-20 13.3L40.7 325.3l20-13.3 6-4 24-16 20-13.3 26.6 39.9-20 13.3zm432-39.9l24 16 6 4 20 13.3-26.6 39.9-20-13.3-6-4-24-16-20-13.3 26.6-39.9 20 13.3z"],
    "people-line": [640, 512, [], "e534", "M320 112a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM144 208a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm392-40a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM96 224H81.9L75 236.3 19 337.1l-11.7 21 42 23.3 11.7-21 27-48.6V384H200V311.8l27 48.6 11.7 21 42-23.3-11.7-21-35.2-63.5 3.4-6.3L264 217.5V304H376V217.5l26.9 49.9 3.4 6.3L371 337.1l-11.7 21 42 23.3 11.7-21 27-48.6V384H552V311.8l27 48.6 11.7 21 42-23.3-11.7-21L565 236.3 558.1 224H544 448 434l-44.9-83.4L382.3 128H368 272 257.7l-6.8 12.6L206 224H192 96zM32 416H0v64H32 608h32V416H608 32z"],
    "beer-mug-empty": [512, 512, ["beer"], "f0fc", "M32 32H384V96h96 32v32V304v20.8l-19 8.4L384 381.7V480H32V32zM384 311.6l64-28.4V160H384V311.6zM160 144V128H128v16V368v16h32V368 144zm64 0V128H192v16V368v16h32V368 144zm64 0V128H256v16V368v16h32V368 144z"],
    "crate-empty": [512, 512, [], "e151", "M512 224H0V352H512V224zm0 160H0V512H512V384zM64 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM48 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM448 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM432 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "diagram-predecessor": [512, 512, [], "e477", "M448 416l0-64L64 352l0 64 384 0zm64 64l-64 0L64 480 0 480l0-64 0-64 0-64 64 0 384 0 64 0 0 64 0 64 0 64zM384 96l-96 0 0 128L0 224 0 32l208 0 80 0 128 0 32 0 0 32 0 64 64 0 0 32-96 96-96-96 0-32 64 0 0-32z"],
    "transporter": [512, 512, [], "e042", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm-18.4 80h15.4H307.1h15.4l9.6 12L409 236l20 25L379 301l-20-25-31-38.7V416H264V320H248v96H184V237.3L153 276l-20 25L83 261l20-25L180 140l9.6-12zM296 512H216 96V448H416v64H296zM480 32l32 16L480 64 464 96 448 64 416 48l32-16L464 0l16 32zM48 64L64 96l32 16L64 128 48 160 32 128 0 112 32 96 48 64z"],
    "calendar-circle-user": [576, 512, [], "e471", "M160 0H96V64H0v96H448V64H352V0H288V64H160V0zm96 368c0-91.8 70.3-167.2 160-175.3V192H0V512H330.8C285.6 480.1 256 427.5 256 368zm320 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-63.3 77.7c-20.4 21.2-49 34.3-80.7 34.3s-60.3-13.2-80.7-34.3L376 416H488l24.7 29.7zM384 336a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "arrow-up-long": [384, 512, ["long-arrow-up"], "f176", "M169.4 22.6L192 0l22.6 22.6 128 128 22.6 22.6L320 218.5l-22.6-22.6L224 122.5 224 480l0 32-64 0 0-32 0-357.5L86.6 195.9 64 218.5 18.7 173.3l22.6-22.6 128-128z"],
    "person-carry-box": [384, 512, ["person-carry"], "f4cf", "M80 96A48 48 0 1 0 80 0a48 48 0 1 0 0 96zM0 480l0 32 64 0 0-32v0V410.5l-64-64L0 480zM32 128H0v32V274.7c0 17 6.7 33.3 18.7 45.3l22.6 22.6 56.7 56.7 6.3 37.9 4 24 4 24 0 0 4 24 .5 2.7h64.9l-2.2-13.3-4-24 0 0-4-24-4-24-8-48-1.7-10.1-7.3-7.3L96 306.7V241.7l21.4 32.1 9.5 14.3H144h48 32 32H384V96H192V224H161.1l-54.5-81.7L97.1 128H80 32z"],
    "fire-flame-simple": [384, 512, ["burn"], "f46a", "M203.1 9.7L192 0 180.9 9.7C104.2 76.8 45.7 162.2 10.9 258C3.7 277.8 0 299 0 320.2C0 425.4 86.8 512 192 512s192-86.6 192-191.8c0-21.1-3.7-42.3-10.9-62.2c-34.8-95.8-93.3-181.2-170-248.3zm78.7 296.2c4.1 9.3 6.2 19.4 6.2 29.5c0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l.9-2.1c16.4-36.8 40.5-69.6 70.8-96.1L192 192l18 15.7c30.3 26.5 54.5 59.3 70.8 96.1l.9 2.1z"],
    "person": [320, 512, [129485, "male"], "f183", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM91.4 128h17.5H211.1h17.5l9.4 14.8 81.7 128-53.9 34.4-33.8-53V480v32H168V480 352H152V480v32H88V480 252.2l-33.8 53L.2 270.8 82 142.8 91.4 128z"],
    "laptop": [640, 512, [128187], "f109", "M96 32H64V64 352h64V96H512V352h64V64 32H544 96zM0 384v48l48 48H592l48-48V384H0z"],
    "file-csv": [512, 512, [], "f6dd", "M0 0H224V160H384V304H112V512H0V0zM384 128H256V0L384 128zM200 352h16c22.1 0 40 17.9 40 40v8 16H224V400v-8c0-4.4-3.6-8-8-8H200c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-8V448h32v16 8c0 22.1-17.9 40-40 40H200c-22.1 0-40-17.9-40-40V392c0-22.1 17.9-40 40-40zm133.1 0H368h16v32H368 333.1c-7.2 0-13.1 5.9-13.1 13.1c0 5.2 3 9.9 7.8 12l37.4 16.6c16.3 7.2 26.8 23.4 26.8 41.2c0 24.9-20.2 45.1-45.1 45.1H304 288V480h16 42.9c7.2 0 13.1-5.9 13.1-13.1c0-5.2-3-9.9-7.8-12l-37.4-16.6c-16.3-7.2-26.8-23.4-26.8-41.2c0-24.9 20.2-45.1 45.1-45.1zM448 352v16 61.1l16 42.7 16-42.7V368 352h32v16 64 2.9l-1 2.7-24 64L483.1 512H472 456 444.9L441 501.6l-24-64-1-2.7V432 368 352h32z"],
    "menorah": [640, 512, [], "f676", "M32 0L59.8 48.7C62.6 53.5 64 58.9 64 64.4C64 81.8 49.8 96 32.4 96h-.8C14.2 96 0 81.8 0 64.4c0-5.5 1.4-10.9 4.2-15.7L32 0zm96 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7C160 81.8 145.8 96 128.4 96h-.8C110.2 96 96 81.8 96 64.4c0-5.5 1.4-10.9 4.2-15.7L128 0zm68.2 48.7L224 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7C256 81.8 241.8 96 224.4 96h-.8C206.2 96 192 81.8 192 64.4c0-5.5 1.4-10.9 4.2-15.7zM320 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7C352 81.8 337.8 96 320.4 96h-.8C302.2 96 288 81.8 288 64.4c0-5.5 1.4-10.9 4.2-15.7L320 0zm68.2 48.7L416 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7C448 81.8 433.8 96 416.4 96h-.8C398.2 96 384 81.8 384 64.4c0-5.5 1.4-10.9 4.2-15.7zM512 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7C544 81.8 529.8 96 512.4 96h-.8C494.2 96 480 81.8 480 64.4c0-5.5 1.4-10.9 4.2-15.7L512 0zm68.2 48.7L608 0l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7C640 81.8 625.8 96 608.4 96h-.8C590.2 96 576 81.8 576 64.4c0-5.5 1.4-10.9 4.2-15.7zM64 128v32V320H288V160 128h64v32V320H576V160 128h64v32V352v32H608 352v64H480h32v64H480 320 160 128V448h32H288V384H32 0V352 160 128H64zm96 0v32V288H96V160 128h64zm96 0v32V288H192V160 128h64zm192 0v32V288H384V160 128h64zm96 0v32V288H480V160 128h64z"],
    "union": [384, 512, [8899], "f6a2", "M64 32V64 288c0 70.7 57.3 128 128 128s128-57.3 128-128V64 32h64V64 288c0 106-86 192-192 192S0 394 0 288V64 32H64z"],
    "chevrons-left": [512, 512, ["chevron-double-left"], "f323", "M41.4 233.4L18.7 256l22.6 22.6 192 192L256 493.3 301.3 448l-22.6-22.6L109.3 256 278.6 86.6 301.3 64 256 18.7 233.4 41.4l-192 192zm192 0L210.7 256l22.6 22.6 192 192L448 493.3 493.3 448l-22.6-22.6L301.3 256 470.6 86.6 493.3 64 448 18.7 425.4 41.4l-192 192z"],
    "circle-heart": [512, 512, ["heart-circle"], "f4c7", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM135.2 287.1c-14.9-14.9-23.2-35-23.2-56v-3.6c0-41.8 33.9-75.6 75.6-75.6c23 0 44.7 10.4 59.1 28.4l9.3 11.6 9.3-11.6c14.4-17.9 36.1-28.4 59.1-28.4c41.8 0 75.6 33.9 75.6 75.6v3.6c0 21-8.3 41.1-23.2 56L352 311.9l-96 96-96-96-24.8-24.8z"],
    "truck-plane": [640, 512, [], "e58f", "M200 0c31.5 0 56 54.7 56 86.1l0 9.9V500.7l-56-19.8L88 512V456l56-44.5V330.3L0 368V288l144-95.5V86.1C144 54.7 169.4 0 200 0zm88 128H640V448H608v64H544V448H384v64H320V448H288V128zM552 240H376l-24 64H576l-24-64zm16 160a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM384 376a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "record-vinyl": [512, 512, [], "f8d9", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256-96a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 224a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "bring-forward": [512, 512, [], "f856", "M224 448H448V224H384V160h64 64v64V448v64H448 224 160V448 384h64v64zM0 352V0H352V352H0z"],
    "square-p": [448, 512, [], "e279", "M448 32H0V480H448V32zM152 128h92c50.8 0 92 41.2 92 92s-41.2 92-92 92H176v48 24H128V360 288 152 128h24zm92 136c24.3 0 44-19.7 44-44s-19.7-44-44-44H176v88h68z"],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm416.5 46.8c-46.2 18.3-101.2 29-160.2 29s-114.1-10.6-160.2-29C112.3 376.7 177.9 432 256.3 432s144-55.3 160.2-129.2zM160 109.4l-7.2 15.1-16.6 34.7-38.1 5-16.6 2.2L93.6 178l27.9 26.5-7 37.8-3.1 16.5 14.7-8L160 232.5l33.8 18.3 14.7 8-3.1-16.5-7-37.8L226.4 178l12.2-11.5-16.6-2.2-38.1-5-16.6-34.7L160 109.4zm192 0l-7.2 15.1-16.6 34.7-38.1 5-16.6 2.2L285.6 178l27.9 26.5-7 37.8-3.1 16.5 14.7-8L352 232.5l33.8 18.3 14.7 8-3.1-16.5-7-37.8L418.4 178l12.2-11.5-16.6-2.2-38.1-5-16.6-34.7L352 109.4z"],
    "sigma": [384, 512, [8721], "f68b", "M0 480H32 352h32V448 384 352H320v32 32H109.3L246.6 278.6 269.3 256l-22.6-22.6L109.3 96H320v32 32h64V128 64 32H352 32 0V77.3l9.4 9.4L178.7 256 9.4 425.4 0 434.7V480z"],
    "camera-movie": [576, 512, [127909, 127910], "f8a9", "M128 64a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM352 256H128C57.3 256 0 198.7 0 128S57.3 0 128 0c48.2 0 90.2 26.6 112 66C261.8 26.6 303.8 0 352 0c70.7 0 128 57.3 128 128s-57.3 128-128 128zm0-192a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM576 256V512L448 448V320l128-64zM416 288V512H64V352H32 0V288H32 64h64 32H416z"],
    "bong": [448, 512, [], "f55c", "M128 273.1c-19.5 11.3-35.7 27.5-46.9 46.9H302.9c-11.2-19.4-27.4-35.6-46.9-46.9l-32-18.5V217.7 64H160V217.7v36.9l-32 18.5zm228.6 12.2C374 314.1 384 347.9 384 384c0 49.2-18.5 94-48.9 128H48.9C18.5 478 0 433.2 0 384c0-71.1 38.6-133.1 96-166.3V64H64V0H96h64 64 64 32V64H288V217.7c14.2 8.2 27.2 18.2 38.8 29.6L366.1 208l-7-7-17-17L376 150.1l17 17 24 24 24 24 17 17L424 265.9l-17-17-7-7-43.3 43.3z"],
    "clarinet": [640, 512, [], "f8ad", "M224 128h16 32 96 96 32 16v32H496 480v32h91.2l44-29.3L640 146.1V176 368v29.9l-24.9-16.6-44-29.3H96 92.9l-2.9-1.1-80-32L0 314.8V304 240 229.2l10.1-4 80-32 2.9-1.1H96 256V160H240 224V128zm224 32H384v32h64V160zm-96 0H288v32h64V160zM272 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "truck-flatbed": [640, 512, [], "e2b6", "M576 416h32 32V352H608V288 256 224 210.7l-9.4-9.4-96-96L493.3 96H480 416 400 352V352H231.6c-17.6-19.6-43.1-32-71.6-32s-54 12.4-71.6 32H0v64H64c0 53 43 96 96 96s96-43 96-96h96 32c0 53 43 96 96 96s96-43 96-96zM416 160h50.7L544 237.3V256H416V160zM112 416a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm368-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "spaghetti-monster-flying": [640, 512, ["pastafarianism"], "f67b", "M208 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 0c0 16.2-6 31.1-16 42.3l15.6 31.2c18.7-6 39.9-9.5 64.4-9.5s45.8 3.5 64.4 9.5L400 106.3C390 95.1 384 80.2 384 64c0-35.3 28.7-64 64-64s64 28.7 64 64s-28.7 64-64 64c-1.7 0-3.4-.1-5.1-.2L427.8 158c21.1 13.6 37.7 30.2 51.4 46.4c7.1 8.3 13.5 16.6 19.3 24l1.4 1.8c6.3 8.1 11.6 14.8 16.7 20.4C527.3 262.3 532.7 264 536 264c2.5 0 4.3-.6 7.1-3.3c3.7-3.5 7.1-8.8 12.5-17.4l.6-.9c4.6-7.4 11-17.6 19.4-25.7c9.7-9.3 22.9-16.7 40.4-16.7h24v48H616c-2.5 0-4.3 .6-7.1 3.3c-3.7 3.5-7.1 8.8-12.5 17.4l-.6 .9c-4.6 7.4-11 17.6-19.4 25.7c-9.7 9.3-22.9 16.7-40.4 16.7c-18.5 0-32.9-8.5-44.3-18.6c-3.1 4-6.6 8.3-10.5 12.7c1.4 4.3 2.8 8.5 4 12.5c.9 3 1.8 5.8 2.6 8.6c3 9.8 5.5 18.2 8.6 25.9c3.9 9.8 7.4 15.4 10.8 18.5c2.6 2.4 5.9 4.3 12.8 4.3c8.7 0 16.9-4.2 33.7-13.2c15-8 35.7-18.8 62.3-18.8h24v48H616c-13.4 0-24.7 5.2-39.7 13.2c-1 .6-2.1 1.1-3.2 1.7C559.9 414 541.4 424 520 424c-18.4 0-33.6-6.1-45.5-17.2c-11.1-10.3-17.9-23.7-22.7-36c-3.6-9-6.7-19.1-9.5-28.5c-16.4 12.3-36.1 23.6-58.9 31.3c3.6 10.8 8.4 23.5 14.4 36.2c7.5 15.9 16.2 30.4 25.8 40.5C433 460.5 441.2 464 448 464h24v48H448c-25.2 0-45-13.5-59.5-28.8c-14.5-15.4-25.7-34.9-34.2-53c-8-17-14.1-33.8-18.3-46.9c-5.2 .4-10.6 .6-16 .6s-10.8-.2-16-.6c-4.2 13-10.3 29.9-18.3 46.9c-8.5 18.1-19.8 37.6-34.2 53C237 498.5 217.2 512 192 512H168V464h24c6.8 0 15-3.5 24.5-13.7c9.5-10.1 18.3-24.6 25.8-40.5c5.9-12.6 10.7-25.4 14.4-36.2c-22.8-7.7-42.5-19-58.9-31.3c-2.9 9.4-6 19.5-9.5 28.5c-4.8 12.2-11.6 25.6-22.7 36C153.6 417.9 138.4 424 120 424c-21.4 0-39.9-10-53.1-17.1l0 0c-1.1-.6-2.2-1.2-3.2-1.7c-15-8-26.3-13.2-39.7-13.2H0V344H24c26.6 0 47.3 10.8 62.3 18.8c16.8 9 25 13.2 33.7 13.2c6.8 0 10.2-1.9 12.8-4.3c3.4-3.2 7-8.8 10.8-18.5c3-7.7 5.6-16.1 8.6-25.9c.8-2.7 1.7-5.6 2.6-8.6c1.2-4 2.6-8.2 4-12.5c-3.9-4.5-7.4-8.8-10.5-12.7C136.9 303.5 122.5 312 104 312c-17.5 0-30.7-7.4-40.4-16.7c-8.4-8.1-14.8-18.3-19.4-25.7l-.6-.9c-5.4-8.6-8.8-13.9-12.5-17.4c-2.8-2.7-4.6-3.3-7.1-3.3H0V200H24c17.5 0 30.7 7.4 40.4 16.7c8.4 8.1 14.8 18.3 19.4 25.7l.6 .9c5.4 8.6 8.8 13.9 12.5 17.4c2.8 2.7 4.6 3.3 7.1 3.3c3.3 0 8.7-1.7 19.4-13.4c5.1-5.6 10.4-12.3 16.7-20.4l1.4-1.8c5.8-7.4 12.2-15.7 19.3-24c13.8-16.2 30.3-32.8 51.4-46.4l-15.1-30.2c-1.7 .1-3.4 .2-5.1 .2c-35.3 0-64-28.7-64-64s28.7-64 64-64s64 28.7 64 64zm208 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "arrow-down-up-across-line": [576, 512, [], "e4af", "M160 509.3l22.6-22.6 96-96L301.3 368 256 322.7l-22.6 22.6L192 386.7V288H544h32V224H544 448V125.3l41.4 41.4L512 189.3 557.3 144l-22.6-22.6-96-96L416 2.7 393.4 25.4l-96 96L274.7 144 320 189.3l22.6-22.6L384 125.3V224H192 128 32 0v64H32h96v98.7L86.6 345.4 64 322.7 18.7 368l22.6 22.6 96 96L160 509.3zM128 64V192h64V64 32H128V64zM384 320V448l0 32h64V448 320H384z"],
    "leaf-heart": [512, 512, [], "f4cb", "M272 96H376c50.2 0 92.7-33 106.9-78.6C501.5 58.8 512 106.2 512 156.6C512 317.1 405.1 447.3 273 448l-1 0c-81.7 0-150.4-55.7-170.2-131.2C68.7 347.5 48 391.3 48 440v16 24H0V456 440c0-75.1 38.3-141.2 96.4-179.9C102.5 168.5 178.8 96 272 96v0zM189.7 241.1c0 14.3 5.9 28 16.4 37.8l70.9 66.4L288 355.5l10.9-10.2 70.9-66.4c10.5-9.8 16.4-23.5 16.4-37.8c0-28.6-23.2-51.8-51.8-51.8H331c-14 0-27.5 5.3-37.8 14.9l-5.2 4.8-5.2-4.8c-10.3-9.6-23.8-14.9-37.8-14.9h-3.5c-28.6 0-51.8 23.2-51.8 51.8z"],
    "house-building": [640, 512, [], "e1b1", "M640 0H320V161l64 53.3V192h64v64H416v32h32v64H416V512H640V0zM512 192h64v64H512V192zm64 96v64H512V288h64zM448 96v64H384V96h64zm64 0h64v64H512V96zM0 256V512H384V256L192 96 0 256zm240 16v96H144V272h96z"],
    "cheese-swiss": [512, 512, [129472], "f7f0", "M141.8 145.7L0 256H512C512 132.3 411.7 32 288 32L217.1 87.2c4.4 7.2 6.9 15.7 6.9 24.8c0 26.5-21.5 48-48 48c-13.4 0-25.5-5.5-34.2-14.3zM416 288c0 26.5-21.5 48-48 48s-48-21.5-48-48H0V480H512V288H416zM176 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "spoon": [512, 512, [129348, 61873, "utensil-spoon"], "f2e5", "M224 160.2C224 80 320 0 416 0c53 0 96 43 96 96c0 96-80 192-160.2 192H312.2l-21.5-21.5L70.6 486.6 48 509.3 2.7 464l22.6-22.6L245.5 221.3 224 199.8V160.2z"],
    "jar-wheat": [320, 512, [], "e517", "M32 0H288V64H32V0zM0 96H320V512H0V96zM192 320c35.3 0 64-28.7 64-64H208c-19.1 0-36.3 8.4-48 21.7c-11.7-13.3-28.9-21.7-48-21.7H64c0 35.3 28.7 64 64 64h16 32 16zm0-96c35.3 0 64-28.7 64-64H208c-19.1 0-36.3 8.4-48 21.7c-11.7-13.3-28.9-21.7-48-21.7H64c0 35.3 28.7 64 64 64h16 32 16zm0 192c35.3 0 64-28.7 64-64H208c-19.1 0-36.3 8.4-48 21.7c-11.7-13.3-28.9-21.7-48-21.7H64c0 35.3 28.7 64 64 64h16v32 16h32V448 416h16z"],
    "envelopes-bulk": [640, 512, ["mail-bulk"], "f674", "M480 0V128H224 192v32 64H96V0H480zM224 192V160h32H608V416H384V256 224H352 224V192zm128 64v32 18.1L192 420.3 32 306.1V256H320h32zm192-32H480v64h64V224zM352 345.4V512H32V345.4L182.7 453l9.3 6.6 9.3-6.6L352 345.4z"],
    "file-circle-exclamation": [576, 512, [], "e4eb", "M0 0H224V160H384v38.6C310.1 219.5 256 287.4 256 368c0 59.5 29.6 112.1 74.8 144H0V0zM384 128H256V0L384 128zm48 96a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224V416H416v32h32zm0-176H416v16 80 16h32V368 288 272z"],
    "bow-arrow": [512, 512, [127993], "f6b9", "M352 32L512 0 480 160l-47-47L183.8 362.1 200 416l-96 96L80 432 0 408l96-96 53.9 16.2L399 79 352 32zM192 64c47.7 0 95.4 13.2 137.1 39.7l-46.8 46.8c-28.1-15-59.2-22.5-90.3-22.5c-29.9 0-58.3 10.2-85.8 28.9L191 241.8 145.8 287 25.4 166.6 2.7 144 48 98.7 60.3 111c38-28.1 81.6-47 131.7-47zM361.5 229.7l46.8-46.8C434.8 224.6 448 272.3 448 320c0 50.1-18.9 93.7-47 131.7L413.3 464 368 509.3l-22.6-22.6L225 366.2 270.2 321l84.8 84.8C373.8 378.3 384 349.9 384 320c0-31.1-7.5-62.2-22.5-90.3z"],
    "cart-xmark": [576, 512, [], "e0dd", "M0 0H24 96h19.9l3.7 19.5L122 32H576L496 288H170.7l9.1 48H488h24v48H488 160 140.1l-3.7-19.5L76.1 48H24 0V0zM128 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM378.4 89.3L336 131.7 293.6 89.3l-28.3 28.3L307.7 160l-42.4 42.4 28.3 28.3L336 188.3l42.4 42.4 28.3-28.3L364.3 160l42.4-42.4L378.4 89.3z"],
    "hexagon-xmark": [512, 512, ["times-hexagon", "xmark-hexagon"], "f2ee", "M0 256L128 32H384L512 256 384 480H128L0 256zm353.9-64L320 158.1l-17 17-47 47-47-47-17-17L158.1 192l17 17 47 47-47 47-17 17L192 353.9l17-17 47-47 47 47 17 17L353.9 320l-17-17-47-47 47-47 17-17z"],
    "circle-h": [512, 512, [9405, "hospital-symbol"], "f47e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM368 152V256 360v24H320V360 280H192l0 80v24H144V360l0-80V232 152 128h48v24 80H320V152 128h48v24z"],
    "merge": [512, 512, [], "e526", "M160 64h15.4L185 76 303.4 224H384V160h32l96 96-96 96H384V288H303.4L185 436l-9.6 12H160 32 0V384H32 144.6L247 256 144.6 128H32 0V64H32 160z"],
    "pager": [512, 512, [128223], "f815", "M0 64H512V448H0V64zm64 64V256H448V128H64zM80 320H56v48H80h56 24V320H136 80zm136 0H192v48h24 48 24V320H264 216z"],
    "cart-minus": [576, 512, [], "e0db", "M0 0H24 96h19.9l3.7 19.5L122 32H576L496 288H170.7l9.1 48H488h24v48H488 160 140.1l-3.7-19.5L76.1 48H24 0V0zM128 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM256 172H416V132H256v40z"],
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M448 0H32V512H448V0zM320 288l32 96H128l32-96H320zM176 192a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM512 80V64H480V80v64 16h32V144 80zm0 112H480v16 64 16h32V272 208 192zm0 144V320H480v16 64 16h32V400 336z"],
    "pan-frying": [576, 512, [127859], "e42c", "M448 224c0 33.4-7.3 65.1-20.4 93.6l140.3 90.7L487.2 512 364.8 398.3C326.3 429.4 277.3 448 224 448C100.3 448 0 347.7 0 224S100.3 0 224 0S448 100.3 448 224zM319.9 154c-21.2-5.4-50.6-22.6-65.8-38.4c-24.5-25.5-65-26.3-90.5-1.8c-11.6 11.2-18.1 25.6-19.4 40.5c-2.2 24.7-9.2 56.2-21.5 77.6c-22.1 38.3-9 87.2 29.3 109.3s87.2 9 109.3-29.3c9.4-16.3 33-30 51.6-32.6c10.2-1.4 20.3-5.4 29.2-12c28.4-21.1 34.3-61.1 13.3-89.5c-9.1-12.3-21.8-20.4-35.5-23.9zM504 424a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "grid": [448, 512, ["grid-3"], "e195", "M0 32H128V160H0V32zM0 192H128V320H0V192zM128 352V480H0V352H128zM160 32H288V160H160V32zM288 192V320H160V192H288zM160 352H288V480H160V352zM448 32V160H320V32H448zM320 192H448V320H320V192zM448 352V480H320V352H448z"],
    "football-helmet": [512, 512, [], "f44f", "M494.2 226.2L340.3 245.5l14 74.5H496h16v16 72 72 16H496 368 354.7l-2.4-13.1-13.5-72L327.7 352H292l7.7 20.5c2.9 7.6 4.3 15.7 4.3 23.8v1.3c0 36.7-29.7 66.4-66.4 66.4c-9 0-17.9-1.8-26.1-5.4L112 416H77.1C39.1 373.5 16 317.5 16 256C16 123.5 123.5 16 256 16c122.5 0 223.5 91.7 238.2 210.2zM256 256l24 64h41.7l-13.2-70.6L256 256zm104.3 96l7.5 40H480V352H360.3zM480 424H373.8l7.5 40H480V424zM176 360a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "hand-love": [544, 512, [], "e1a5", "M224 0V32l0 96V352h96 32 96l0-96V96 64h64V96 336c0 97.2-78.8 176-176 176H316.8c-59.6 0-116.9-22.9-160-64L60.3 356.1l-29-27.6 55.2-57.9 29 27.6 44.6 42.4c0-1.5-.1-3.1-.1-4.6V32 0h64zm32 160h64V320H256V160zm160 32V320H352V192h64z"],
    "trees": [640, 512, [], "f724", "M64 128L192 0 320 128v32H272l80 96v32H304l80 96v32H224v64 32H160V480 416H0V384l80-96H32V256l80-96H64V128zM416 480V448 416 384 372.4l-7.4-8.9L372.3 320H384V288 256 244.4l-7.4-8.9L340.3 192H352V160 128 114.7l-9.4-9.4L448 0 576 128v32H528l80 96v32H560l80 96v32H480v64 32H416V480z"],
    "strikethrough": [512, 512, [], "f0cc", "M161.3 144c3.2-17.2 14-30.1 33.7-38.6c21.1-9 51.8-12.3 88.6-6.5c11.9 1.9 48.8 9.1 60.1 12l30.9 8.2 16.5-61.8-30.9-8.2c-14.3-3.8-53.6-11.4-66.6-13.4c-44.7-7-88.3-4.2-123.7 10.9c-36.5 15.6-64.4 44.8-71.8 87.3c-.1 .6-.2 1.1-.2 1.7c-2.8 23.9 .5 45.6 10.1 64.6c4.5 9 10.2 16.9 16.7 23.9H32 0v64H32 480h32V224H480 270.1c-.1 0-.3-.1-.4-.1l-1.1-.3c-36-10.8-65.2-19.6-85.2-33.1c-9.3-6.3-15-12.6-18.2-19.1c-3.1-6.1-5.2-14.6-3.8-27.4zM348.9 337.2c2.7 6.5 4.4 15.8 1.9 30.1c-3 17.6-13.8 30.8-33.9 39.4c-21.1 9-51.7 12.3-88.5 6.5c-18-2.9-49.1-13.5-74.4-22.1l0 0c-5.6-1.9-11-3.7-15.9-5.4l-30.4-10.1L87.5 436.3l30.4 10.1c3.6 1.2 7.9 2.7 12.7 4.3l0 0 0 0c24.9 8.5 63.6 21.7 87.6 25.6l0 0 .2 0c44.7 7 88.3 4.2 123.7-10.9c36.5-15.6 64.4-44.8 71.8-87.3c3.6-21 2.7-40.4-3.1-58.1H335.1c7 5.6 11.4 11.2 13.9 17.2z"],
    "page": [384, 512, [], "e428", "M0 512H384V112L272 0H0V512z"],
    "k": [320, 512, [107], "4b", "M236.5 32h83.2L309.4 44.5 166.8 215.9 317.9 480H244.2L123.1 268.5 64 339.6V448v32H0V448 328 64 32H64V64 239.5l39.4-47.4L236.5 32z"],
    "diagram-previous": [512, 512, [], "e478", "M448 352L64 352v64l384 0V352zm64-64v64 64 64H448 64 0V416 352 288H64 232V224l-40 0-32 0V192l73.4-73.4L256 96l22.6 22.6L352 192v32l-32 0-40 0v64H448h64zM0 32l512 0V224H384V192 178.7l-9.4-9.4-96-96L256 50.7 233.4 73.4l-96 96-9.4 9.4V192v32L0 224V32z"],
    "gauge-min": [512, 512, ["tachometer-alt-slowest"], "f628", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6 80.2 215 55 255.8l20.4 12.6 117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "folder-grid": [512, 512, [], "e188", "M512 480H0V32H224l48 64H512V480zM176 240H80v96h96V240zm128 0H208v96h96V240zm32 0v96h96V240H336z"],
    "eggplant": [512, 512, [], "e16c", "M480 65.9l31.4-31.4L477.4 .6 446.1 32H288l16 48 48 16 16 48 48 16 16 48 48 16V65.9zM271 82.3c-30.1 22.4-65.7 39.7-101.2 56.9C83.4 181.3-1.6 222.5 0 336c1.4 95.3 79.8 175.9 176.4 176c130.5 .1 227.9-140.1 276.4-263.4l-30.9-10.3-15.2-5.1-5.1-15.2-10.9-32.8-32.8-10.9-15.2-5.1-5.1-15.2-10.9-32.8-32.8-10.9-15.2-5.1-5.1-15.2L271 82.3z"],
    "ram": [640, 512, [128015], "f70a", "M336 64v8V96h48V72 64c0-8.8 7.2-16 16-16s16 7.2 16 16V96l-10.3 10.3-55.2 23.6-22.1 9.5 18.9 44.1 22.1-9.5 14.5-6.2V320H576V167.8l14.5 6.2 22.1 9.5 18.9-44.1-22.1-9.5-55.1-23.6L544 96V64c0-8.8 7.2-16 16-16s16 7.2 16 16v8V96h48V72 64c0-35.3-28.7-64-64-64s-64 28.7-64 64H464c0-35.3-28.7-64-64-64s-64 28.7-64 64zm-49.5 58.6l30.8-13.2C309.3 83.1 284.9 64 256 64c-19.2 0-36.5 8.5-48.2 21.9C196.9 77.2 183 72 168 72c-30.1 0-55.3 20.8-62.2 48.8c-3.2-.5-6.5-.8-9.8-.8c-35.3 0-64 28.7-64 64c0 5.3 .7 10.5 1.9 15.5C13.7 210.3 0 231.5 0 256s13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5c0 35.3 28.7 64 64 64c.5 0 1 0 1.5 0L120 512h88V426.3c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7V512h88l22.5-120c.5 0 1 0 1.5 0c26.9 0 49.9-16.5 59.3-40H352V216.4l-21.4 9.2L286.5 122.6zM464 160a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "landmark-flag": [512, 512, [], "e51c", "M368 0V96H272v32H464h32v64H464 48 16V128H48 240V0h32 96zM64 224h64V416h40V224h64V416h48V224h64V416h40V224h64V416l51.1 38.3c.1 .1 .2 .1 .2 .2L512 464v15.6c0 .3 0 .5 0 .8V512H480 32 0V480.4c0-.3 0-.5 0-.8V464l12.7-9.5c.1-.1 .2-.1 .2-.2L64 416V224z"],
    "lips": [576, 512, [128068, 128482], "f600", "M0 224L192 64l96 48 96-48L576 224s-80 224-240 224H240C80 448 0 224 0 224zm64 0s80 96 224 96s224-96 224-96L368 192s-48.1 16-80 16s-80-16-80-16L64 224z"],
    "pencil": [512, 512, [9999, 61504, "pencil-alt"], "f303", "M10.2 460.4L0 511.4l51-10.2 109-21.8L420.7 218.7l-16-16-96-96-16-16L32 351.4l-21.8 109zM315.3 68.1l16 16 96 96 16 16 34.7-34.7L512 127.4 478.1 93.5 417.9 33.4 384-.6 350.1 33.4 315.3 68.1zM99.9 351.4H112v48h48v12.1l-23.7 23.7-75.1 15 15-75.1 23.7-23.7zm226.7-176l-11.3 11.3-144 144L160 342.1l-22.6-22.6 11.3-11.3 144-144L304 152.8l22.6 22.6z"],
    "backward": [512, 512, [9194], "f04a", "M0 256L256 448V64L0 256zM512 448V64L288 232v48L512 448z"],
    "caret-right": [256, 512, [], "f0da", "M112 96L256 256 112 416l-48 0L64 96l48 0z"],
    "comments": [640, 512, [128490, 61670], "f086", "M416 176c0 97.2-93.1 176-208 176c-36.2 0-70.3-7.8-99.9-21.6L0 352l37.6-75.1C13.9 248.3 0 213.5 0 176C0 78.8 93.1 0 208 0S416 78.8 416 176zm32 0c0-5.2-.2-10.4-.6-15.5C555.1 167.1 640 243.2 640 336c0 37.5-13.9 72.3-37.6 100.9L640 512 531.9 490.4C502.3 504.2 468.2 512 432 512c-95.6 0-176.2-54.6-200.5-129C348.9 372.9 448 288.3 448 176z"],
    "paste": [512, 512, ["file-clipboard"], "f0ea", "M160 0c-23.7 0-44.4 12.9-55.4 32H0V448H192V128 96h32 96V32H215.4C204.4 12.9 183.7 0 160 0zm0 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm96 88H224v32V448v64H512V224l-96-96H320 256z"],
    "desktop-arrow-down": [576, 512, [], "e155", "M576 0H352V64H512V288H64V64H224V0H0V416H240l-10.7 32H160 128v64h32H416h32V448H416 346.7L336 416H576V0zM312 24V0H264V24 166.1l-39-39-17-17L174.1 144l17 17 80 80 17 17 17-17 80-80 17-17L368 110.1l-17 17-39 39V24z"],
    "code-pull-request": [512, 512, [], "e13c", "M56 56h48v48H56V56zM0 0V56v48 56H48V352H0v56 48 56H56h48 56V456 408 352H112V160h48V104 56 0H104 56 0zM56 408h48v48H56V408zm400 0v48H408V408h48zM400 192V352H352v56 48 56h56 48 56V456 408 352H464V192c0-70.7-57.3-128-128-128H320V0H288L192 96l96 96h32V128h16c35.3 0 64 28.7 64 64z"],
    "pumpkin": [576, 512, [], "f707", "M236.1 103.8C252.5 98.7 269.9 96 288 96c22.6 0 44.2 4.3 64 12V32L288 0 236.1 103.8zm158.1 27.9c15.4 11.7 28.9 25.9 39.8 42C392.6 144.9 342.3 128 288 128s-104.6 16.9-146 45.7c10.9-16.1 24.3-30.3 39.8-42c-9.6-2.4-19.6-3.7-29.8-3.7C68.1 128 0 214 0 320S68.1 512 152 512c24.4 0 47.5-7.3 68-20.2c20.5 12.9 43.6 20.2 68 20.2s47.5-7.3 68-20.2c20.5 12.9 43.6 20.2 68 20.2c83.9 0 152-86 152-192s-68.1-192-152-192c-10.2 0-20.1 1.3-29.8 3.7z"],
    "clipboard-list": [384, 512, [], "f46d", "M101.5 64C114.6 26.7 150.2 0 192 0s77.4 26.7 90.5 64H384V512H0V64H101.5zM224 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM160 352v32h16H304h16V352H304 176 160zM96 392a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm64-136v32h16H304h16V256H304 176 160zM96 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "pen-field": [640, 512, [], "e211", "M304 240L288 352l112-16L564.7 171.3l-96-96L304 240zM640 96L544 0 491.3 52.7l96 96L640 96zM32 128H0v32V480v32H32 544h32V480 320 288H512v32V448H64V192H256h32V128H256 32zM96 288v64h64V288H96zm160 0H192v64h64V288z"],
    "blueberries": [512, 512, [], "e2e8", "M512 176C512 78.8 433.2 0 336 0C255.4 0 187.4 54.2 166.6 128.2c3.1-.1 6.3-.2 9.4-.2c114.9 0 208 93.1 208 208c0 3.2-.1 6.3-.2 9.4C457.8 324.6 512 256.6 512 176zM176 512a176 176 0 1 0 0-352 176 176 0 1 0 0 352zm16-304v16 32h32 16v32H224 192v32 16H160V320 288H128 112V256h16 32V224 208h32zM384 64V96h32 16v32H416 384v32 16H352V160 128H320 304V96h16 32V64 48h32V64z"],
    "truck-ramp-box": [640, 512, ["truck-loading"], "f4de", "M640 0V400c0 61.9-50.1 112-112 112c-61.6 0-111.6-49.8-112-111.3L48.6 502.8l-30.8 8.6L.6 449.7l30.8-8.6L352 352.1V0H640zM576 400a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM14.8 176.8l77.3-20.7L117 248.8l61.8-16.6-24.8-92.7 77.3-20.7 58 216.4-216.4 58-58-216.4z"],
    "note": [448, 512, [], "e1ff", "M0 32H448V320H320 288v32V480H0V32zM402.7 352H448l-32 32-64 64-32 32V434.7 384 352h32 50.7zM112 112H64v48h48V112zM64 232v48h48V232H64zm48 120H64v48h48V352z"],
    "arrow-down-to-square": [512, 512, [], "e096", "M278.6 342.6l96-96L397.3 224 352 178.7l-22.6 22.6L288 242.7V32 0H224V32 242.7l-41.4-41.4L160 178.7 114.7 224l22.6 22.6 96 96L256 365.3l22.6-22.6zM32 32H0V64 480v32H32 480h32V480 64 32H480 384V96h64V448H64V96h64V32H32z"],
    "user-check": [640, 512, [], "f4fc", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM384 304l64 208H0L64 304H384zM617 177L489 305l-17 17-17-17-64-64-17-17L408 190.1l17 17 47 47L583 143l17-17L633.9 160l-17 17z"],
    "cloud-xmark": [640, 512, [], "e35f", "M144 480H0V336c0-62.7 40.1-116 96-135.8V192c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96v36c55.2 14.2 96 64.3 96 124V480H512 144zM417.9 224L384 190.1l-17 17-47 47-47-47-17-17L222.1 224l17 17 47 47-47 47-17 17L256 385.9l17-17 47-47 47 47 17 17L417.9 352l-17-17-47-47 47-47 17-17z"],
    "vial-virus": [512, 512, [], "e597", "M0 32H32 96h64 64 32V64 96H224V208.5l-47.4 47.4 39.6 39.6 .6 .6H216 160V408h56 .8l-.6 .6-39.6 39.6 11 11c-16.4 13-37.1 20.8-59.7 20.8c-53 0-96-43-96-96V96H0V64 32zM96 96v96h64V96H96zM216 376l0 0H192V352 328h24 .1c28.8 0 43.2-34.8 22.8-55.2l-17-17 17-17 17-17 17 17c20.4 20.4 55.2 5.9 55.2-22.9l0-.1V192h24 24v24 .2c.1 28.7 34.9 43 55.2 22.7l17-17 17 17 17 17-17 17c-20.4 20.4-6 55.2 22.8 55.2h.1 24v24 24H488l0 0c-28.8 0-43.2 34.8-22.9 55.2l17 17-17 17-17 17-17-17c-20.3-20.3-55-6-55.2 22.7v.2 24H352 328V488.2l0-.2c0-28.8-34.8-43.2-55.2-22.9l-17 17-17-17-17-17 17-17c20.4-20.4 5.9-55.2-22.9-55.2zm104-24a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm88 32a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "book-blank": [448, 512, [128213, 128215, 128216, 128217, "book-alt"], "f5d9", "M96 0C43 0 0 43 0 96V416c0 53 43 96 96 96H384h32 32V448H416V384h32V0H416 384 96zm0 384H352v64H96c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "golf-flag-hole": [512, 512, [], "e3ac", "M128 0L416 128 175.5 234.9c.4 1.6 .5 3.3 .5 5.1v84.8c25.2-3.1 52.1-4.8 80-4.8c141.4 0 256 43 256 96s-114.6 96-256 96S0 469 0 416c0-35.5 51.5-66.6 128-83.2V256 240 0zm96 448c35.3 0 64-14.3 64-32s-28.7-32-64-32s-64 14.3-64 32s28.7 32 64 32z"],
    "message-arrow-down": [512, 512, ["comment-alt-arrow-down"], "e1db", "M0 0H512V416H304L160 512V416H0V0zM280 120V96H232v24V238.1l-31-31-17-17L150.1 224l17 17 72 72 17 17 17-17 72-72 17-17L328 190.1l-17 17-31 31V120z"],
    "face-unamused": [512, 512, [], "e39f", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM96 192h16 64c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32H112 96V192zm208 0h64c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32H304 288V192h16zm12.1 202.7c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7l-10.7 11.9-23.8-21.4 10.7-11.9C188.2 355.4 216.3 336 256 336s67.8 19.4 83.9 37.3l10.7 11.9-23.8 21.4-10.7-11.9z"],
    "sheet-plastic": [384, 512, [], "e571", "M224 512H0V0H384V352H224V512zm32 0V384H384L256 512zM171.3 75.3L182.6 64 160 41.4 148.7 52.7l-96 96L41.4 160 64 182.6l11.3-11.3 96-96zm96 32L278.6 96 256 73.4 244.7 84.7l-160 160L73.4 256 96 278.6l11.3-11.3 160-160z"],
    "circle-9": [512, 512, [], "e0f6", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256 16a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm96-48c0-53-43-96-96-96s-96 43-96 96c0 49.2 37 89.8 84.7 95.3l-44.4 48.4L185.4 384l65.1 0 68.1-74.3c21.4-23.4 33.3-54 33.3-85.7z"],
    "blog": [512, 512, [], "f781", "M192 0V64c141.4 0 256 114.6 256 256h64C512 143.3 368.7 0 192 0zm0 96v64c88.4 0 160 71.6 160 160h64C416 196.3 315.7 96 192 96zM96 144V96H0v48V368c0 79.5 64.5 144 144 144s144-64.5 144-144s-64.5-144-144-144H128v96h16c26.5 0 48 21.5 48 48s-21.5 48-48 48s-48-21.5-48-48V144z"],
    "user-ninja": [448, 512, [129399], "f504", "M224 256c70.7 0 128-57.3 128-128S294.7 0 224 0c-49.6 0-92.6 28.2-113.8 69.4c-3-5.8-6.8-11.3-11.7-16.1c-25-25-67.9-22.6-67.9-22.6s-2.4 42.9 22.6 67.9c5.8 5.8 12.6 10.1 19.6 13.4c-7 3.2-13.8 7.6-19.6 13.4c-25 25-22.6 67.9-22.6 67.9s42.9 2.4 67.9-22.6c1.2-1.2 2.4-2.5 3.5-3.8c16.4 51.8 64.8 89.3 122 89.3zM448 512L384 304H308L224 416 140 304H64L0 512H448zM160 96H288h16v32H288 160 144V96h16z"],
    "pencil-slash": [640, 512, [], "e215", "M74.2 460.4L64 511.4l51-10.2 109-21.8L339.7 363.7l-76.8-60.5-27.6 27.6L224 342.1l-22.6-22.6 11.3-11.3 24.9-24.9-41-32.3L96 351.4l-21.8 109zM408.8 294.6l75.9-75.9-16-16-96-96-16-16-92 92L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L408.8 294.6zM306 214.8l50.7-50.7L368 152.8l22.6 22.6-11.3 11.3-47.8 47.8L306 214.8zM379.3 68.1l16 16 96 96 16 16 34.7-34.7L576 127.4 542.1 93.5 481.9 33.4 448-.6 414.1 33.4 379.3 68.1zM163.9 351.4H176v48h48v12.1l-23.7 23.7-75.1 15 15-75.1 23.7-23.7z"],
    "bowling-pins": [512, 512, [], "f437", "M128 0c35.3 0 64 28.7 64 64v1.1c0 7.4-1 14.8-2.9 21.9l-17.6 64.9c-.7 2.7-1.3 5.4-1.8 8.1H86.5c-.5-2.7-1.1-5.4-1.8-8.1L66.9 87.1c-2-7.2-2.9-14.6-2.9-22V64C64 28.7 92.7 0 128 0zM83.1 209.6c1.9-5.7 3.3-11.6 4.1-17.6H169c.8 6 2.2 11.8 4.1 17.6l49.3 148.3 3.1 9.4-2.7 9.5-32 112L184.1 512H160 96 71.9l-6.6-23.2-32-112-2.7-9.5 3.1-9.4L83.1 209.6zM384 0c35.3 0 64 28.7 64 64v1.1c0 7.4-1 14.8-2.9 21.9l-17.6 64.9c-.7 2.7-1.3 5.4-1.8 8.1H342.5c-.5-2.7-1.1-5.4-1.8-8.1L323 87.1c-2-7.2-3-14.6-3-22V64c0-35.3 28.7-64 64-64zM339.1 209.6c1.9-5.7 3.3-11.6 4.1-17.6H425c.8 6 2.2 11.8 4.1 17.6l49.3 148.3 3.1 9.4-2.7 9.5-32 112L440.1 512H416 352 327.9l-6.6-23.2-32-112-2.7-9.5 3.1-9.4 49.4-148.3z"],
    "person-arrow-up-from-line": [640, 512, [], "e539", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H123.4L114 142.8l-81.7 128 53.9 34.4 33.8-53V448H32 0v64H32 608h32V448H608 264V252.2l33.8 53 53.9-34.4L270 142.8 260.6 128H243.1 140.9zM200 448H184V352h16v96zM598.6 121.4l-80-80L496 18.7 473.4 41.4l-80 80L370.7 144 416 189.3l22.6-22.6L464 141.3 464 384v32h64V384 141.3l25.4 25.4L576 189.3 621.3 144l-22.6-22.6z"],
    "down-right": [384, 512, [], "e16b", "M368 432V144l-32-32L232 216 80 64 0 144 152 296 48 400l32 32H368z"],
    "scroll-torah": [640, 512, ["torah"], "f6a0", "M96 0H0V512H96V0zM512 32H128V480H512V32zM544 0V512h96V0H544zM187.1 332l10.5-18 33.8-58-33.8-58-10.5-18H208h67.8l33.9-58L320 104.2l10.4 17.8 33.9 58H432h20.9l-10.5 18-33.8 58 33.8 58 10.5 18H432 364.2l-33.9 58L320 407.8 309.6 390l-33.9-58H208 187.1zM320 360.2L336.4 332H303.6L320 360.2zM289.6 308h60.9l30.3-52-30.3-52H289.6l-30.3 52 30.3 52zm105.1-28.2L378.2 308h32.9l-16.4-28.2zM411.1 204H378.2l16.4 28.2L411.1 204zM320 151.8L303.6 180h32.9L320 151.8zm-74.7 80.4L261.8 204H228.9l16.4 28.2zM261.8 308l-16.4-28.2L228.9 308h32.9z"],
    "webhook": [576, 512, [], "e5d5", "M208 128c0-44.2 35.8-80 80-80s80 35.8 80 80c0 10.7-2.1 20.8-5.8 30l44.5 18c6-14.9 9.3-31.1 9.3-48.1C416 57.3 358.7 0 288 0S160 57.3 160 128c0 37.1 15.8 70.5 41 93.9L129.7 336c-.6 0-1.1 0-1.7 0c-26.5 0-48 21.5-48 48s21.5 48 48 48s48-21.5 48-48c0-8.1-2-15.8-5.6-22.5l82.8-132.5 12.7-20.3-20.3-12.7C223 181.7 208 156.6 208 128zm81.7 48l82.8 132.5 12.7 20.4 20.4-12.8c12.3-7.7 26.8-12.1 42.4-12.1c44.2 0 80 35.8 80 80s-35.8 80-80 80c-22.2 0-42.2-9-56.8-23.6l-34.1 33.8C380.3 497.5 412.5 512 448 512c70.7 0 128-57.3 128-128s-57.3-128-128-128c-16.3 0-31.9 3.1-46.3 8.6L330.4 150.5c3.6-6.7 5.6-14.4 5.6-22.5c0-26.5-21.5-48-48-48s-48 21.5-48 48s21.5 48 48 48c.6 0 1.1 0 1.7 0zM448 432c26.5 0 48-21.5 48-48s-21.5-48-48-48c-17.8 0-33.3 9.7-41.6 24H232 208v24c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-39.7 28.9-72.7 66.8-78.9L107 257.7C46.3 267.7 0 320.4 0 384c0 70.7 57.3 128 128 128c62.5 0 114.5-44.8 125.8-104H406.4c8.3 14.3 23.8 24 41.6 24z"],
    "blinds-open": [512, 512, [], "f8fc", "M0 0H32 480h32V64H480 160v64 64 66.7c13.6 4.8 24.4 15.6 29.3 29.3c.1 .3 .2 .7 .4 1c1.5 4.7 2.4 9.7 2.4 15c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16c4.8-13.6 15.6-24.4 29.3-29.3V192 128 64H32 0V0zM40 128H96v64H0l40-64zm0 160H65.6c-1 5.2-1.6 10.5-1.6 16c0 18 6 34.6 16 48H0l40-64zm472 64H208c10-13.4 16-30 16-48c0-5.5-.6-10.8-1.6-16H472l40 64zm0-160H192V128H472l40 64zM0 512l40-64H472l40 64H0z"],
    "fence": [512, 512, [], "e303", "M64 32L0 96V480H128V416h32V352H128V224h32V160H128V96L64 32zM320 352V224h32V160H320V96L256 32 192 96V480H320V416h32V352H320zM448 32L384 96V480H512V96L448 32z"],
    "up": [384, 512, ["arrow-alt-up"], "f357", "M192 32L0 224v32H128V480H256V256H384V224L192 32z"],
    "broom-ball": [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", "M376 248l40 40v32H364.3L256 211.7V160h32l40 40L528 0l48 48L376 248zM222.6 234.9L341.1 353.4c3.7 42.7-11.7 85.2-42.3 115.8C271.4 496.6 234.2 512 195.5 512L0 512V480L160 336 64 384l0-3.5c0-38.8 15.4-75.9 42.8-103.4c30.6-30.6 73.1-45.9 115.8-42.3zM464 352a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "drumstick": [512, 512, [127831], "f6d6", "M160 278.5V176C160 78.8 238.8 0 336 0s176 78.8 176 176s-78.8 176-176 176H233.5l-58.4 58.3C185.6 421.1 192 435.8 192 452c0 33.1-26.9 60-60 60s-60-26.9-60-60V440H60c-33.1 0-60-26.9-60-60s26.9-60 60-60c16.2 0 30.9 6.4 41.6 16.8L160 278.5z"],
    "square-v": [448, 512, [], "e284", "M448 32H0V480H448V32zM351.9 144L246 385.6 239.7 400H208.3L202 385.6 96.1 144h52.4L224 316.2 299.5 144h52.4z"],
    "face-awesome": [512, 512, ["gave-dandy"], "e409", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm203.5-95.6c-5.6 9.4-15.8 15.6-27.5 15.6c-17.7 0-32-14.3-32-32c0-9.1 3.8-17.4 10-23.2c-3.3-.5-6.6-.8-10-.8c-35.3 0-64 28.7-64 64v40H208V184c0-8.3-1.6-16.3-4.5-23.6zM384 176c-17.7 0-32-14.3-32-32c0-8.5 3.3-16.3 8.8-22c-5.4-1.3-11-2-16.8-2c-39.8 0-72 32.2-72 72v32H416V192c0-10.4-2.2-20.2-6.1-29.1c-5.8 8-15.2 13.1-25.9 13.1zm48 112h0H399.4 112.6 80h0l3.8 18.8c.9 4.5 2 8.9 3.2 13.2c21.1 75.2 89.9 128 169.1 128c55.9 0 106.6-26.3 139-68.3c0 0 0 0 0 0c16.2-20.9 27.8-45.6 33.2-73L432 288zM240.1 415.1c1.7-44 37.8-79.1 82.2-79.1c19.6 0 37.6 6.8 51.7 18.3C347.8 392 304.3 416 256 416c-5.4 0-10.7-.3-15.9-.9z"],
    "dial-off": [576, 512, [], "e162", "M320 0V64H256V0h64zM128 64v64H64V64h64zm384 0v64H448V64h64zm0 192h64v64H512V256zm0 192v64H448V448h64zM64 448h64v64H64V448zM0 256H64v64H0V256zm448 32c0 80.2-59 146.6-136 158.2V288 264H264v24V446.2c-77-11.6-136-78-136-158.2c0-88.4 71.6-160 160-160s160 71.6 160 160z"],
    "toggle-off": [576, 512, [], "f204", "M512 128V384H64V128H512zm64-64H512 64 0v64V384v64H64 512h64V384 128 64zM96 160V352H288V160H96z"],
    "face-smile-horns": [640, 512, [], "e391", "M320 0C264.6 0 213.2 17.6 171.3 47.6C57.1 42.8 0 0 0 0C0 80.1 55.6 160.1 74.1 184.5C67.5 207.2 64 231.2 64 256c0 141.4 114.6 256 256 256s256-114.6 256-256c0-24.8-3.5-48.8-10.1-71.5C584.4 160.1 640 80.1 640 0c0 0-57.1 42.8-171.3 47.6C426.8 17.6 375.4 0 320 0zM272.4 272c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-8.8 3.6-16.8 9.3-22.6l-30.7-10.2-15.2-5.1 10.1-30.4 15.2 5.1 96 32 15.2 5.1-10.1 30.4-15.2-5.1-10.9-3.6c.2 1.5 .3 2.9 .3 4.4zm128 32c-17.7 0-32-14.3-32-32c0-1.6 .1-3.2 .3-4.7l-11.7 3.9-15.2 5.1-10.1-30.4 15.2-5.1 96-32 15.2-5.1 10.1 30.4-15.2 5.1-30.2 10.1c5.9 5.8 9.5 13.9 9.5 22.8c0 17.7-14.3 32-32 32zM320 424c-71.6 0-113.7-47.7-126.3-72.8l28.6-14.3c8.7 17.5 41.3 55.2 97.7 55.2s88.9-37.7 97.7-55.2l28.6 14.3C433.7 376.3 391.6 424 320 424z"],
    "box-archive": [512, 512, ["archive"], "f187", "M512 32v96H0V32H512zM32 160H480V480H32V160zm128 64v32h16H336h16V224H336 176 160z"],
    "grapes": [512, 512, [], "e306", "M360 0s-40 40-40 80s7.3 55.3 32 80s40 32 80 32s80-40 80-40s-32-40-80-40c-32 0-40 8-40 8s8-8 8-40c0-48-40-80-40-80zM304 152a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM112 232a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm32 80A56 56 0 1 0 32 312a56 56 0 1 0 112 0zM112 456A56 56 0 1 0 0 456a56 56 0 1 0 112 0zm144-32a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm80 32a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM280 288a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm80 32a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "person-drowning": [576, 512, [], "e545", "M192 64V32H128V64 208v23.4l22.3 7.1 37.6 12-18.4 129c7.7 2.2 15.3 3.5 22.5 3.5c13 0 27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l0 0 0 0 1.1-.8L288 336l19.7 14.2 0 0c13.9 10 23.6 17 35.5 22.5c6.9 3.2 14.2 5.9 21.5 7.7l17.1-94 137.2-31.2 31.2-7.1-14.2-62.4-31.2 7.1L337.4 230.9 192 184.6V64zM320 192a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM272.4 461.1c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V416c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 409.9 19.3 416 0 416v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9z"],
    "dial-max": [576, 512, [], "e15e", "M320 0V64H256V0h64zM128 64v64H64V64h64zm384 0v64H448V64h64zm0 192h64v64H512V256zm0 192v64H448V448h64zM64 448h64v64H64V448zM0 256H64v64H0V256zm401.4-81.3c56.7 56.7 62 145.4 15.7 208L305.3 270.9l-17-17-33.9 33.9 17 17L383.2 416.7c-62.6 46.2-151.3 41-208-15.7c-62.5-62.5-62.5-163.8 0-226.3s163.8-62.5 226.3 0z"],
    "circle-m": [512, 512, [], "e115", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM128 152V128h36.3l7.2 9.9L256 255l84.5-117.1 7.2-9.9H384v24V360v24H336V360 226.2l-60.5 83.8L256 337l-19.5-26.9L176 226.2V360v24H128V360 152z"],
    "calendar-image": [448, 512, [], "e0d4", "M96 0V64H0v96H448V64H352V0H288V64H160V0H96zM448 192H0V512H448V192zM160 344l24 32 72-104L368 448H80l80-104zm-32-88a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-caret-down": [512, 512, ["caret-circle-down"], "f32d", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM384 240L256 368 128 240l0-32 256 0 0 32z"],
    "arrow-down-9-1": [576, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", "M160 479.4l23.6-25.7 88-96L293.2 334 246 290.8l-21.6 23.6L192 349.7V64 32H128V64 349.7L95.6 314.4 74 290.8 26.8 334l21.6 23.6 88 96L160 479.4zM352 288v64h32 16v64H384 352v64h32 48 48 32V416H480 464V320 288H432 384 352zM432 88a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-88 32c0 42.3 29.9 77.7 69.8 86.1l-25.1 41.3-5.2 8.6h74.9L502 184.1c11.7-19.3 18-41.5 18-64.1c0-48.6-39.4-88-88-88s-88 39.4-88 88z"],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", "M0 256C0 368.9 73.1 464.7 174.5 498.8C165.3 484 160 466.6 160 448V400.7c-31.9-23.3-55.2-57.8-64-97.9c46.2 18.3 101.2 29 160.2 29s114.1-10.6 160.2-29c-8.8 40.2-32.3 75-64.5 98.3V448c0 18.6-5.3 36-14.5 50.8C438.9 464.7 512 368.9 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zm230.9-64L112 256l45.7-64L112 128l118.9 64zM400 128l-45.7 64L400 256 281.1 192 400 128zM320 448V384H272v24H240V384H192v64c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "shish-kebab": [512, 512, [], "f821", "M438.6 73.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L416 141.3l-22.6 22.6L349.3 208 304 162.7l25.4-25.4c-17-35.7-10.8-79.7 18.8-109.3c37.5-37.5 98.3-37.5 135.8 0c31.4 31.4 36.5 79.2 15.3 115.9l-55.4-32c7.1-12.2 5.3-28.2-5.1-38.6zM104 453.3L46.6 510.6 1.4 465.4 58.7 408 104 453.3zM128 208l88-88L392 296l-88 88L128 208zM16 320l88-88L280 408l-88 88L16 320z"],
    "spray-can": [512, 512, [], "f5bd", "M224 0V128H96V0H224zM0 256c0-53 43-96 96-96H224c53 0 96 43 96 96V512H0V256zm240 80A80 80 0 1 0 80 336a80 80 0 1 0 160 0zM256 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM384 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM448 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM384 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "alarm-snooze": [512, 512, [], "f845", "M160 25.4C143 9.6 120.2 0 95.2 0C42.6 0 0 42.6 0 95.2c0 18.8 5.5 36.3 14.9 51.1L160 25.4zM256 512c50.3 0 96.8-16.6 134.2-44.6l19.2 19.2L432 509.3 477.3 464l-22.6-22.6-19.2-19.2c28-37.4 44.6-83.8 44.6-134.2C480 164.3 379.7 64 256 64S32 164.3 32 288c0 50.3 16.6 96.8 44.6 134.2L57.4 441.4 34.7 464 80 509.3l22.6-22.6 19.2-19.2c37.4 28 83.8 44.6 134.1 44.6zM497.1 146.4C506.5 131.6 512 114 512 95.2C512 42.6 469.4 0 416.8 0C391.8 0 369 9.6 352 25.4L497.1 146.4zM200 192h96 40.8L317 227.7 256.8 336H312h24v48H312 216 175.2L195 348.3 255.2 240H200 176V192h24z"],
    "scarecrow": [448, 512, [], "f70d", "M320 96c0 11.2-1.9 22-5.5 32H432l-16 32 32 32-32 32 16 32H320l32 160-64-32-64 32-64-32L96 416l32-160H16l16-32L0 192l32-32L16 128H133.5c-3.5-10-5.5-20.8-5.5-32c0-53 43-96 96-96s96 43 96 96zM208 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM192 480V435.8l17.7 8.8 14.3 7.2 14.3-7.2 17.7-8.8V480v32H192V480z"],
    "truck-monster": [640, 512, [], "f63b", "M224 0h32H384h16l9.6 12.8L496 128H608v96h32v64H608c-29.2-38.9-75.7-64-128-64s-98.8 25.1-128 64H288c-29.2-38.9-75.7-64-128-64s-98.8 25.1-128 64H0V224H32V128H224V32 0zM368 64H288v64H416L368 64zM128 256h64v20.6c7.4 2.2 14.6 5.2 21.3 8.8l14.6-14.6 45.3 45.3-14.6 14.6c3.6 6.7 6.6 13.8 8.8 21.3H288v64H267.4c-2.2 7.4-5.2 14.6-8.8 21.3l14.6 14.6-45.3 45.3-14.6-14.6c-6.7 3.6-13.8 6.6-21.3 8.8V512H128V491.4c-7.4-2.2-14.6-5.2-21.3-8.8L92.1 497.1 46.9 451.9l14.6-14.6c-3.6-6.7-6.6-13.8-8.8-21.3H32V352H52.6c2.2-7.4 5.2-14.6 8.8-21.3L46.9 316.1l45.3-45.3 14.6 14.6c6.7-3.6 13.8-6.6 21.3-8.8V256zm32 176a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM448 276.6V256h64v20.6c7.4 2.2 14.6 5.2 21.3 8.8l14.6-14.6 45.3 45.3-14.6 14.6c3.6 6.7 6.6 13.8 8.8 21.3H608v64H587.4c-2.2 7.4-5.2 14.6-8.8 21.3l14.6 14.6-45.3 45.3-14.6-14.6c-6.7 3.6-13.8 6.6-21.3 8.8V512H448V491.4c-7.4-2.2-14.6-5.2-21.3-8.8l-14.6 14.6-45.3-45.3 14.6-14.6c-3.6-6.7-6.6-13.8-8.8-21.3H352V352h20.6c2.2-7.4 5.2-14.6 8.8-21.3l-14.6-14.6 45.3-45.3 14.6 14.6c6.7-3.6 13.8-6.6 21.3-8.8zM528 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "gift-card": [576, 512, [], "f663", "M353.5 68.8C361.1 55.9 374.9 48 389.8 48H392c22.1 0 40 17.9 40 40s-17.9 40-40 40H320h-1.3l34.8-59.2zm-131 0L257.3 128H256 184c-22.1 0-40-17.9-40-40s17.9-40 40-40h2.2c14.9 0 28.8 7.9 36.3 20.8zm89.6-24.3L288 85.5l-24.1-41C247.7 16.9 218.1 0 186.2 0H184C135.4 0 96 39.4 96 88c0 14.4 3.5 28 9.6 40H64 0v64V448v64H64 512h64V448 192 128H512 470.4c6.1-12 9.6-25.6 9.6-40c0-48.6-39.4-88-88-88h-2.2c-31.9 0-61.5 16.9-77.7 44.4zM512 384v64H64V384H512zm0-64H64V192H230.1l-40.5 48.6 36.9 30.7L288 197.5l61.6 73.9 36.9-30.7L345.9 192H512V320z"],
    "w": [576, 512, [119], "57", "M506.8 32h67.6L430.3 458.2 423 480H376l-6.7-23L288 178.3 206.7 457 200 480H153l-7.4-21.8L1.6 32H69.2L173.8 341.4 257.3 55 264 32h48l6.7 23 83.5 286.4L506.8 32z"],
    "code-pull-request-draft": [448, 512, [], "e3fa", "M56 56v48h48V56H56zM0 0H56h48 56V56v48 56H112V352h48v56 48 56H104 56 0V456 408 352H48V160H0V104 56 0zM56 408v48h48V408H56zm336 0H344v48h48V408zm-48-56h48 56v56 48 56H392 344 288V456 408 352h56zM320 192h96v96H320V192zM416 32v96H320V32h96z"],
    "square-b": [448, 512, [], "e264", "M448 32H0V480H448V32zM128 128h24 92c42 0 76 34 76 76c0 16.2-5.1 31.3-13.8 43.7C324.3 261.6 336 283.4 336 308c0 42-34 76-76 76H152 128V360 280 256 232 152 128zm144 76c0-15.5-12.5-28-28-28H176v56h68c15.5 0 28-12.5 28-28zM176 336h84c15.5 0 28-12.5 28-28s-12.5-28-28-28H244 176v56z"],
    "elephant": [640, 512, [128024], "f6da", "M121.9 72.6c11.7-9.1 24.5-16.9 38.1-23.2V112c0 79.5 64.5 144 144 144h16V224H304c-61.9 0-112-50.1-112-112V38 0H304c30.5 0 58.2 12.2 78.4 32H384c88.4 0 160 71.6 160 160V311.4c-9.4 5.4-20.3 8.6-32 8.6c-20.9 0-39.5-10-51.2-25.6l-25.6 19.2c6.6 8.7 14.6 16.3 23.7 22.4h0c6.5 4.3 13.6 7.9 21.1 10.5v0c10 3.5 20.8 5.5 32 5.5s22-1.9 32-5.5v0c13.9-4.9 26.4-13 36.6-23.4l11.2-11.4 22.9 22.4-11.2 11.4C587.4 362 566.9 374.1 544 380v21.5c0 8 6.5 14.5 14.5 14.5c6.2 0 11.8-4 13.7-9.9l5.4-16.2 60.7 20.2L633 426.3c-10.7 32.1-40.7 53.7-74.5 53.7c-43.3 0-78.5-35.1-78.5-78.5V380c-25.2-6.5-47.3-20.4-64-39.3V512H288V410c-15.3 3.9-31.4 6-48 6s-32.7-2.1-48-6V512H64V337.1L45.9 377.7 2.1 358.3 32 290.9V248c0-72.2 35.4-136.2 89.9-175.4zM464 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "earth-africa": [512, 512, [127757, "globe-africa"], "f57c", "M454 192C427 108.4 348.5 48 256 48c-22.3 0-43.8 3.5-64 10V160h32l32-32h96l-64 64H200l-40 40v88h96v96h48l48-48V320h32V256l-32-32V192H454zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "rainbow": [640, 512, [127752], "f75b", "M320 96C178.6 96 64 210.6 64 352v96 32H0V448 352C0 175.3 143.3 32 320 32s320 143.3 320 320v96 32H576V448 352C576 210.6 461.4 96 320 96zm0 192c-35.3 0-64 28.7-64 64v96 32H192V448 352c0-70.7 57.3-128 128-128s128 57.3 128 128v96 32H384V448 352c0-35.3-28.7-64-64-64zM160 352v96 32H96V448 352c0-123.7 100.3-224 224-224s224 100.3 224 224v96 32H480V448 352c0-88.4-71.6-160-160-160s-160 71.6-160 160z"],
    "circle-notch": [512, 512, [], "f1ce", "M201.1 71.9C121.8 95.6 64 169.1 64 256c0 106 86 192 192 192s192-86 192-192c0-86.9-57.8-160.4-137.1-184.1l18.3-61.3C434.9 42.1 512 140 512 256c0 141.4-114.6 256-256 256S0 397.4 0 256C0 140 77.1 42.1 182.9 10.6l18.3 61.3z"],
    "tablet-screen-button": [448, 512, ["tablet-alt"], "f3fa", "M0 0H448V512H0V0zM256 448a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM384 64H64V384H384V64z"],
    "paw": [512, 512, [], "f1b0", "M310.1 189.7c-32.3-10.6-46.9-53.9-32.6-96.8s52.1-69.1 84.4-58.5s46.9 53.9 32.6 96.8s-52.1 69.1-84.4 58.5zM234.5 92.9c14.3 42.9-.3 86.2-32.6 96.8s-70.1-15.6-84.4-58.5s.3-86.2 32.6-96.8s70.1 15.6 84.4 58.5zM100.4 198.6c18.9 32.4 14.3 70.1-10.2 84.1s-59.7-.9-78.5-33.3S-2.7 179.3 21.8 165.3s59.7 .9 78.5 33.3zM64 480c0-176 128-256 192-256s192 80 192 256L256 432 64 480zM421.8 282.7c-24.5-14-29.1-51.7-10.2-84.1s54-47.3 78.5-33.3s29.1 51.7 10.2 84.1s-54 47.3-78.5 33.3z"],
    "message-question": [512, 512, [], "e1e3", "M0 0H512V416H304L160 512V416H0V0zM168 136v6.5l48 0 0-6.5c0-4.4 3.6-8 8-8h56.9c8.4 0 15.1 6.8 15.1 15.1c0 5.4-2.9 10.4-7.6 13.1l-44.3 25.4L232 188.6v13.9V224v24h48V224v-7.6l32.3-18.5c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1H224c-30.9 0-56 25.1-56 56zm64 152v48h48V288H232z"],
    "cloud": [640, 512, [9729], "f0c2", "M0 480H144 512 640V352c0-59.6-40.8-109.8-96-124V192c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192v8.2C40.1 220 0 273.3 0 336V480z"],
    "trowel-bricks": [512, 512, [], "e58a", "M256 152V256H208L0 128 208 0h48V104h88V80H512v96H344V152H256zm32 72H512V352H288V224zM160 384V512H0V384H160zm352 0V512H192V384H512z"],
    "square-3": [448, 512, [], "e258", "M448 32H0V480H448V32zM280 128h24v34.6l-7.8 7.1-50.8 46.5c41.9 4.8 74.6 40.4 74.6 83.6c0 46.5-37.7 84.2-84.2 84.2H210.7c-32.2 0-61.6-18.2-76-47l-4.2-8.3 42.9-21.5 4.2 8.3c6.3 12.5 19.1 20.4 33 20.4h25.2c20 0 36.2-16.2 36.2-36.2c0-20.1-16.3-36.3-36.4-36.2l-51.5 .3-24.1 .1V229.4l7.8-7.1L218.3 176H152 128V128h24H280z"],
    "face-flushed": [512, 512, [128563, "flushed"], "f579", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM176 400h16H320h16V368H320 192 176v32zM160 296a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm264-72a72 72 0 1 0 -144 0 72 72 0 1 0 144 0zm-288 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm192 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "hospital-user": [576, 512, [], "f80d", "M320 0H0V256H144h16v32H144 0v64H144h16v32H144 0V512H253.1L320 359V0zM184 64v40h40v48H184v40H136V152H96V104h40V64h48zM512 272a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm8 112H344L288 512H576L520 384z"],
    "microwave": [576, 512, [], "e01b", "M0 32H576V448H512v32H448V448H128v32H64V448H0V32zm96 96V352H416V128H96zm416-16H480V368h32V112z"],
    "chf-sign": [640, 512, [], "e602", "M80 96c-8.8 0-16 7.2-16 16V384v16c0 8.8 7.2 16 16 16s16-7.2 16-16V384h64v16c0 44.2-35.8 80-80 80s-80-35.8-80-80V384 112C0 67.8 35.8 32 80 32s80 35.8 80 80v16H96V112c0-8.8-7.2-16-16-16zM256 32V64 224h96V64 32h64V64 448v32H352V448 288H256V448v32H192V448 64 32h64zm192 0h32H608h32V96H608 512V224h64 32v64H576 512V448v32H448V448 64 32z"],
    "tent-arrow-left-right": [576, 512, [], "e57f", "M109.8 52.2L89.9 72l396.1 0L466.2 52.2l-17-17L483.2 1.3l17 17L561 79l17 17-17 17-60.8 60.8-17 17-33.9-33.9 17-17L486.1 120 89.9 120l19.8 19.8 17 17L92.8 190.7l-17-17L15 113l-17-17L15 79 75.8 18.2l17-17 33.9 33.9-17 17zM64 512L96 288 288 160 480 288l32 224H384L288 352V512H64z"],
    "cart-circle-arrow-up": [640, 512, [], "e3f0", "M24 0H0V48H24 76.1l60.3 316.5 3.7 19.5H160 320.7c-.5-5.3-.7-10.6-.7-16c0-10.9 1-21.6 2.9-32h-143l-9.1-48H339.2c29.1-57 88.4-96 156.8-96c10 0 19.7 .8 29.2 2.4L576 32H122l-2.4-12.5L115.9 0H96 24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM496 224a144 144 0 1 0 0 288 144 144 0 1 0 0-288zM417.4 360l11.3-11.3 56-56L496 281.4l11.3 11.3 56 56L574.6 360 552 382.6l-11.3-11.3L512 342.6V432v16H480V432 342.6l-28.7 28.7L440 382.6 417.4 360z"],
    "trash-clock": [576, 512, [], "e2b0", "M135.2 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8c-12.1 0-23.2 6.8-28.6 17.7zM416 128H32L53.2 467c1.6 25.3 22.6 45 47.9 45H330.8C285.6 480.1 256 427.5 256 368c0-90.4 68.2-164.9 155.9-174.9L416 128zM576 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM448 288v16 48h32 16v32H480 432 416V368 304 288h32z"],
    "gavel": [512, 512, ["legal"], "f0e3", "M344 56L320 80 432 192l24-24 56 56L368 368l-56-56 24-24L224 176l-24 24-56-56L288 0l56 56zM214.6 342.6L232 360 80 512 0 432 152 280l17.4 17.4L234.7 232 280 277.3l-65.4 65.4z"],
    "sprinkler-ceiling": [384, 512, [], "e44c", "M0 0V96v26.2l25.7 5.1L128 147.8V82.6L64 69.8V0H0zM256 82.6v65.3l102.3-20.5 25.7-5.1V96 0H320V69.8L256 82.6zM160 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-48 64a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM24 496a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM272 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-80 88a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-32 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm136-40a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm88 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM224 64V32H160V64 192H96 64v64H96h96 96 32V192H288 224V64z"],
    "browsers": [576, 512, [], "e0cb", "M576 0H96V416H576V0zM512 72v48H256V72H512zM160 64h64v64H160V64zM48 120V96H0v24V488v24H24 456h24V464H456 48V120z"],
    "trillium": [448, 512, [], "e588", "M224 0s-96 80-96 160c0 14.5 3.2 28.2 8.9 40.5c-13.1 1.3-26.1 5.4-38.2 12.4C29.4 252.9 8.2 376 8.2 376s117.3 43.1 186.6 3.1c11.8-6.8 21.7-15.8 29.3-26.1c7.6 10.3 17.4 19.3 29.3 26.1c69.3 40 186.6-3.1 186.6-3.1s-21.3-123.1-90.6-163.1c-12.1-7-25.1-11.1-38.2-12.4c5.7-12.3 8.9-26 8.9-40.5C320 80 224 0 224 0zM184 240a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM-4 120.5s-1.5 42.2 54.4 90.3c9.5-9.8 20.3-18.6 32.4-25.6c4.7-2.7 9.6-5.1 14.5-7.2c-.8-5.9-1.3-11.9-1.3-17.9c0-12.9 1.9-25.5 5.1-37.7C31.7 98.2-4 120.5-4 120.5zM210.7 406.9c-11.8 6.8-24.4 11.7-37.3 15C187.5 492.6 224 512 224 512s36.5-19.4 50.6-90.2c-12.9-3.3-25.5-8.2-37.3-15c-4.7-2.7-9.1-5.6-13.3-8.8c-4.2 3.2-8.6 6.1-13.3 8.8zM365.3 185.1c12.5 7.2 23.5 16.3 33.3 26.5c56.9-48.5 55.4-91.2 55.4-91.2s-36.3-22.7-106.9 2.5c3.1 12 4.9 24.4 4.9 37c0 6.1-.4 12.1-1.3 17.9c4.9 2.1 9.8 4.5 14.5 7.2z"],
    "music-slash": [640, 512, [], "f8d1", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7-60.8-47.2c10-12.6 15.9-27.8 15.9-44.1V120 48 5L534.8 17.4l-320 96L192 120.2v6.1L48.4 14.8zM315.3 222L512 163V292.6c-10-2.9-20.8-4.6-32-4.6c-22 0-42.2 6.2-58.4 16.5L315.3 222zM192 247.3V356.6c-10-2.9-20.8-4.6-32-4.6c-53 0-96 35.8-96 80s43 80 96 80s96-35.8 96-80V297.7l-64-50.4z"],
    "truck-ramp": [640, 512, [], "f4e0", "M640 400V0H352V352.1L31.4 441.2 .6 449.7l17.1 61.7 30.8-8.6L416 400.7c.4 61.5 50.4 111.3 112 111.3c61.9 0 112-50.1 112-112zM528 352a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "binoculars": [512, 512, [], "f1e5", "M192 32V96H96V32h96zm0 96V480H0V336l48-80L64 128H192zm128 0H448l16 128 48 80V480H320V128zm0-96h96V96H320V32zm-32 96V288H224V128h64z"],
    "microphone-slash": [640, 512, [], "f131", "M224 0H416V300.2l18 14c8.9-17.5 14-37.2 14-58.2V216 192h48v24 40c0 32.1-8.6 62.1-23.6 88L620.9 459.3l19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L224 151.1V0zM358.2 378.2l43.1 33.9c-17.6 9.2-36.9 15.4-57.3 18.2V464h48 24v48H392 320 248 224V464h24 48V430.4C210.2 418.7 144 345.1 144 256V216v-6.5l48 37.8V256c0 70.7 57.3 128 128 128c13.3 0 26.1-2 38.2-5.8z"],
    "box-tissue": [512, 512, [], "e05b", "M113.8 224L64 0H208c40 0 52 24 64 48s24 48 64 48H448L405.3 224 384 288H128l-14.2-64zM95.2 288H64v32h38.3H128 384h23.1H448V288H417.7l21.3-64H512V384H0V224H81l14.2 64zM0 416H512v96H0V416z"],
    "circle-c": [512, 512, [], "e101", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176 256c0 44.2 35.8 80 80 80c28.7 0 53.8-15.1 68-37.8l40.8 25.4C342.2 359.8 301.9 384 256 384c-70.7 0-128-57.3-128-128s57.3-128 128-128c45.9 0 86.2 24.2 108.7 60.5L324 213.8c-14.2-22.8-39.3-37.8-68-37.8c-44.2 0-80 35.8-80 80z"],
    "star-christmas": [512, 512, [], "f7d4", "M0 256l192 64 64 192 64-192 192-64L320 192 256 0 192 192 0 256zM54.1 88l17 17 48 48 17 17L169.9 136l-17-17L105 71l-17-17L54.1 88zm403.9 0L424 54.1 407 71l-48 48-17 17L376 169.9l17-17 48-48 17-17zM441 407l-48-48-17-17L342.1 376l17 17 48 48 17 17L457.9 424l-17-17zM54.1 424L88 457.9l17-17 48-48 17-17L136 342.1l-17 17L71 407l-17 17z"],
    "chart-bullet": [512, 512, [], "e0e1", "M288 32V56v8H448h64v64 32 64H448 288v8 24H240V232v-8H64 0V160 128 64H64 240V56 32h48zM160 128v32h80V128H160zm128 0v32H448V128H288zm48 224H256v32h80V352zm0-64v-8V256h48v24 8h64 64v64 32 64H448 384v8 24H336V456v-8H64 0V384 352 288H64 336zm48 64v32h64V352H384z"],
    "motorcycle": [640, 512, [127949], "f21c", "M280 32H256V80h24 57.7l16.4 30.3L256 192l-64-64H32v64h96c88.4 0 160 71.6 160 160c0 11-1.1 21.7-3.2 32h70.4c-2.1-10.3-3.2-21-3.2-32c0-52.2 25-98.6 63.7-127.8l15.4 28.6C402.4 276.3 384 312 384 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-13.5 0-26.5 2.1-38.7 6L418.2 128H512V32H448L391.7 78.9 373.1 44.6 366.3 32H352 280zM462.7 311.2l28.2 52.2 42.2-22.8-28.2-52.2c2.3-.3 4.7-.4 7.1-.4c35.3 0 64 28.7 64 64s-28.7 64-64 64s-64-28.7-64-64c0-15.5 5.5-29.7 14.7-40.8zM187.3 376c-9.5 23.5-32.5 40-59.3 40c-35.3 0-64-28.7-64-64s28.7-64 64-64c26.9 0 49.9 16.5 59.3 40h66.4C242.5 268.8 190.5 224 128 224C57.3 224 0 281.3 0 352s57.3 128 128 128c62.5 0 114.5-44.8 125.8-104H187.3zM128 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "tree-christmas": [448, 512, [127876], "f7db", "M144 81.3l53.3-28L224 0l26.7 53.3L304 80l-53.3 26.7L224 160l-26.7-53.3L144 81.3zM24 320L174.3 132.1 204.2 192h39.6l29.9-59.9L424 320v32H368l80 128v32H0V480L80 352H24V320zm160-32a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM288 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "tire-flat": [512, 512, [], "f632", "M256 32C114.6 32 0 146.6 0 288c0 47.9 13.2 92.8 36.1 131.1L0 448v64H512V448l-36.1-28.9C498.8 380.8 512 335.9 512 288C512 146.6 397.4 32 256 32zm96 384c-2.1 1.6-4.3 3.2-6.6 4.7C319.9 437.9 289.1 448 256 448c-36 0-69.3-11.9-96-32c-38.9-29.2-64-75.7-64-128c0-88.4 71.6-160 160-160s160 71.6 160 160c0 52.3-25.1 98.8-64 128zm-96-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm16 95c44.3-5.5 81.5-33.6 99.8-72.4l-61.9-20.1c-8.6 13.5-22.1 23.5-38 27.6l0 65zM381.7 312.2c1.5-7.8 2.3-15.9 2.3-24.2c0-36.8-15.5-69.9-40.3-93.3l-38.2 52.6c9.1 11 14.5 25.2 14.5 40.6c0 1.4 0 2.7-.1 4l61.8 20.1zM256 224c8.3 0 16.3 1.6 23.6 4.5l38.2-52.6C299.5 165.8 278.4 160 256 160s-43.5 5.8-61.8 15.9l28.1 38.8 10 13.8c7.3-2.9 15.3-4.5 23.6-4.5zM128 288c0 8.3 .8 16.3 2.3 24.2L192.1 292c-.1-1.3-.1-2.7-.1-4c0-15.4 5.5-29.6 14.5-40.6l-10.1-13.9-28.1-38.7C143.5 218.1 128 251.2 128 288zm12.2 54.6c18.3 38.8 55.5 66.9 99.8 72.4l0-65c-15.8-4.1-29.3-14.1-37.9-27.5l-61.9 20.1z"],
    "sunglasses": [576, 512, [128374], "f892", "M61 31.9l21.8 3.2 88.7 13.2 23.7 3.5-7 47.5-23.7-3.5L97.6 85.8c-8.4 34.3-15.4 59.6-22.4 84.6l0 0-.3 1c-8.1 29-16.1 57.8-26.2 100.6H224h32v32h64V272h32H527.3c-10.1-42.8-18.1-71.7-26.2-100.6l-.3-1 0 0 0 0 0 0c-7-25-14-50.3-22.4-84.6l-66.9 9.9-23.7 3.5-7-47.5 23.7-3.5 88.7-13.2L515 31.9l5 21.5c10.5 44.8 18.8 74.3 27.1 104.2l.2 .9c8.5 30.3 17.1 61.2 28 108.1l.6 2.7V272v0 32 48 24 72 32H544 352 320V448 368H256v80 32H224 32 0V448 376 352 304 272v0-2.8l.6-2.7c10.9-46.9 19.5-77.7 28-108.1l.3-.9C37.2 127.7 45.5 98.1 56 53.4l5-21.5zM64 336v60l120-60H64zm320 52l104-52H384v52z"],
    "badge": [512, 512, [], "f335", "M340.9 51.1C324.8 20.7 292.8 0 256 0s-68.8 20.7-84.9 51.1C138.2 41 101 49 75 75s-34 63.3-23.9 96.1C20.7 187.2 0 219.2 0 256s20.7 68.8 51.1 84.9C41 373.8 49 411 75 437s63.3 34 96.1 23.9C187.2 491.3 219.2 512 256 512s68.8-20.7 84.9-51.1C373.8 471 411 463 437 437s34-63.3 23.9-96.1C491.3 324.8 512 292.8 512 256s-20.7-68.8-51.1-84.9C471 138.2 463 101 437 75s-63.3-34-96.1-23.9z"],
    "message-pen": [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", "M0 0H512V416H304L160 512V416H0V0zM304.8 112l-29.1 29.1L323 188.4l29.1-29.1L304.8 112zm-51.7 51.7l-85.2 85.2L160 304.1l55.3-7.9L300.4 211l-47.3-47.3z"],
    "bell-concierge": [512, 512, [128718, "concierge-bell"], "f562", "M216 64H192v48h24 16v33.3C119.6 157.2 32 252.4 32 368H480c0-115.6-87.6-210.8-200-222.7V112h16 24V64H296 256 216zM24 400H0v48H24 488h24V400H488 24z"],
    "pen-ruler": [512, 512, ["pencil-ruler"], "f5ae", "M195.3 67.3l-56 56L128 134.6 105.4 112l11.3-11.3 56-56L128 0 0 128 105.4 233.4l128-128L195.3 67.3zM384 512L512 384l-44.7-44.7-56 56L400 406.6 377.4 384l11.3-11.3 56-56-38.1-38.1-128 128L384 512zM32 352L0 512l160-32L420.7 219.3l-128-128L32 352zM512 128L384 0 315.3 68.7l128 128L512 128z"],
    "arrow-progress": [512, 512, [], "e5df", "M256 128V96H64V224H480h32v32V448v32H480 416v32H288V384H416v32h32V288H32 0V256 64 32H32 256V0h24l72 64-72 64H256zM128 384v32h32V384h24l72 64-72 64H160V480H128v32H0V384H128zM512 0V128H384V0H512z"],
    "chess-rook-piece": [320, 512, ["chess-rook-alt"], "f448", "M67.4 384L80 264 40 224V96H96v48h32V96h64v48h32V96h56V224l-40 40 12.6 120H67.4zM136 248v40h48V248c0-13.3-10.7-24-24-24s-24 10.7-24 24zM16 512V480l48-64H256l48 64v32H16z"],
    "square-root": [576, 512, [8730], "f697", "M320 32H296l-6.7 23L198.1 367.6 123.6 239.9 114.4 224H96 32 0v64H32 77.6L180.4 464.1l9.3 15.9H232l6.7-23L344 96H544h32V32H544 320z"],
    "album-collection-circle-plus": [640, 512, [], "e48e", "M32 0H56 456h24V48H456 56 32V0zm8 512L0 160H512l-3.7 32.4c-4.1-.3-8.2-.4-12.3-.4c-46.9 0-89.5 18.3-121 48.2C342.9 220.1 301.4 208 256 208C154.4 208 72 268.9 72 344s82.4 136 184 136c33.2 0 64.4-6.5 91.3-17.9c12.4 19.6 28.6 36.6 47.5 49.9H40zM256 376c-17.7 0-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24s-14.3 24-32 24zM40 80H472h24v48H472 40 16V80H40zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80V288H480v16 48H432 416v32h16 48v48 16h32V432 384h48 16V352H560 512V304z"],
    "people-arrows": [640, 512, ["people-arrows-left-right"], "e068", "M128 128A64 64 0 1 0 128 0a64 64 0 1 0 0 128zm9.4 198.6L114.7 304l22.6-22.6 88-88L224 160H32L24 352H64V512H192V381.3l-54.6-54.6zM512 128A64 64 0 1 0 512 0a64 64 0 1 0 0 128zM616 352l-8-192H416l-1.4 33.4 88 88L525.3 304l-22.6 22.6L448 381.3V512H576V352h40zM272 192L160 304 272 416V336h96v80L480 304 368 192v80H272V192z"],
    "face-angry-horns": [640, 512, [], "e368", "M320 0C264.6 0 213.2 17.6 171.3 47.6C57.1 42.8 0 0 0 0C0 80.1 55.6 160.1 74.1 184.5C67.5 207.2 64 231.2 64 256c0 141.4 114.6 256 256 256s256-114.6 256-256c0-24.8-3.5-48.8-10.1-71.5C584.4 160.1 640 80.1 640 0c0 0-57.1 42.8-171.3 47.6C426.8 17.6 375.4 0 320 0zm70.8 422.6l-10.7-11.9c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7l-10.7 11.9-23.8-21.4 10.7-11.9C252.2 371.4 280.3 352 320 352s67.8 19.4 83.9 37.3l10.7 11.9-23.8 21.4zM240.4 304c-17.7 0-32-14.3-32-32c0-8.8 3.6-16.8 9.3-22.6l-30.7-10.2-15.2-5.1 10.1-30.4 15.2 5.1 96 32 15.2 5.1-10.1 30.4-15.2-5.1-10.9-3.6c.2 1.5 .3 2.9 .3 4.4c0 17.7-14.3 32-32 32zm192-32c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-1.6 .1-3.2 .3-4.7l-11.7 3.9-15.2 5.1-10.1-30.4 15.2-5.1 96-32 15.2-5.1 10.1 30.4-15.2 5.1-30.2 10.1c5.9 5.8 9.5 13.9 9.5 22.8z"],
    "mars-and-venus-burst": [640, 512, [], "e523", "M176 0L133.8 88.5 38.4 66.3l42.9 88.1L4.4 215.2 100 236.6l-.4 98L176 273.2l57.2 46c-16-28-25.2-60.5-25.2-95.2c0-60.7 28.1-114.7 72.1-149.9L218.2 88.5 176 0zM640 0H512L480 32l47 47-23.2 23.2C475.9 78.4 439.6 64 400 64c-88.4 0-160 71.6-160 160c0 80.2 59 146.6 136 158.2V384v.4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .3 .4 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3H352 328v48h24 24v.2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0l24 0H376v24h48V488H400l24 0v0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V486 486v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V485 485v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V484v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V483v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V481v-.1-.1-.1-.1-.1-.1-.1-.1V480v-.1-.1-.1-.1-.1-.1-.1V479v-.1-.1-.1-.1-.1-.1-.1V478v-.1-.1-.1-.1-.1-.1V477v-.1-.1-.1-.1-.1-.1V476v-.1-.1-.1-.1-.1-.1V475v-.1-.2-.2-.2-.2-.2V474v-.2-.2-.2-.2-.2V473v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V470v-.2-.2-.2-.2-.2V469v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V467v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V463v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V459v-.2-.2-.2-.2-.2-.2-.2-.2V457v-.2-.2-.2-.2V456h24 24V408H448 424v-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3V403v-.3-.3V402v-.3-.3V401v-.3-.3V400v-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.4-.3-.4-.4-.4-.4V393v-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4V388v-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4V384v-1.8c77-11.6 136-78 136-158.2c0-31.4-9-60.7-24.7-85.4L561 113l47 47 32-32V0zM400 128a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "tombstone": [448, 512, [], "f720", "M32 192C32 86 118 0 224 0S416 86 416 192V416H32V192zM0 448H32 416h32v64H416 32 0V448zM248 120V96H200v24 40H152 128v48h24 48V328v24h48V328 208h48 24V160H296 248V120z"],
    "square-caret-right": [448, 512, ["caret-square-right"], "f152", "M448 480l0-448L0 32 0 480l448 0zM192 128L320 256 192 384l-32 0 0-256 32 0z"],
    "scissors": [512, 512, [9984, 9986, 9988, "cut"], "f0c4", "M160 112a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-7.5 104.5c-12.6 4.9-26.2 7.5-40.5 7.5C50.1 224 0 173.9 0 112S50.1 0 112 0s112 50.1 112 112c0 14.3-2.7 27.9-7.5 40.5L256 192 416 32h64l32 32L216.5 359.5c4.9 12.6 7.5 26.2 7.5 40.5c0 61.9-50.1 112-112 112S0 461.9 0 400s50.1-112 112-112c14.3 0 27.9 2.7 40.5 7.5L192 256l-39.5-39.5zM278.6 342.6l64-64L512 448l-32 32H416L278.6 342.6zM112 352a48 48 0 1 0 0 96 48 48 0 1 0 0-96z"],
    "list-music": [512, 512, [], "f8c9", "M512 .4V44.8v64 23.1l-21.9 7.3L416 163.9V432c0 44.2-50.1 80-112 80s-112-35.8-112-80s50.1-80 112-80c17.2 0 33.5 2.8 48 7.7V140.8v-64V53.7l21.9-7.3 96-32L512 .4zM32 64H256h32v64H256 32 0V64H32zm0 128H256h32v64H256 32 0V192H32zm0 128h96 32v64H128 32 0V320H32z"],
    "sun-plant-wilt": [640, 512, [], "e57a", "M194.4 76.9L160 0 125.6 76.9 46.9 46.9l30.1 78.7L0 160l76.9 34.4L46.9 273.1l78.7-30.1L160 320l34.4-76.9 78.7 30.1-30.1-78.7L320 160l-76.9-34.4 30.1-78.7L194.4 76.9zM160 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm312 16c0-17.7 14.3-32 32-32s32 14.3 32 32v53.4c-14.8 7.7-24 23.1-24 44.6c0 19.5 21.5 52.9 48 78c26.5-25 48-58.7 48-78c0-21.5-9.2-37-24-44.6V176c0-44.2-35.8-80-80-80s-80 35.8-80 80v22.7c-9.8-4.3-20.6-6.7-32-6.7c-44.2 0-80 35.8-80 80v21.4c-14.8 7.7-24 23.1-24 44.6c0 19.5 21.5 52.9 48 78c26.5-25 48-58.7 48-78c0-21.5-9.2-37-24-44.6V272c0-17.7 14.3-32 32-32s32 14.3 32 32v8V448H32 0v64H32 608h32V448H608 504V280v-8V176z"],
    "toilets-portable": [576, 512, [], "e584", "M256 0V64H0V0H256zM0 96H24 232h24v24V488v24H208V488v-8H48v8 24H0V488 120 96zM208 224H176v16 64 16h32V304 240 224zM576 0V64H320V0H576zM320 96h24H552h24v24V488v24H528V488v-8H368v8 24H320V488 120 96zM528 224H496v16 64 16h32V304 240 224z"],
    "hockey-puck": [512, 512, [], "f453", "M256 256C114.6 256 0 213 0 160s114.6-96 256-96s256 43 256 96s-114.6 96-256 96zm192.3 1.8c24.7-9.3 46.9-21 63.7-35.6V376s-96 72-256 72S0 376 0 376V222.3c16.8 14.6 39 26.3 63.7 35.6C114.5 276.9 182.5 288 256 288s141.5-11.1 192.3-30.2z"],
    "mustache": [640, 512, [], "e5bc", "M192 112h-8l-6.4 4.8L94.1 179.5 35.7 147 0 127.2 0 168l0 39.4v0C0 313.8 86.2 400 192.6 400c46.7 0 91.7-16.9 126.9-47.7l.5-.4 .5 .4c35.1 30.7 80.2 47.7 126.9 47.7C553.8 400 640 313.8 640 207.4v0l0-39.4 0-40.8L604.3 147l-58.4 32.4-83.6-62.7L456 112h-8H368 357l-7.2 8.4L320 155.1l-29.8-34.7L283 112H272 192z"],
    "hyphen": [320, 512, [], "2d", "M0 224H32 288h32v64H288 32 0V224z"],
    "table": [512, 512, [], "f0ce", "M64 256V160H224v96H64zm0 64H224v96H64V320zm224 96V320H448v96H288zM448 256H288V160H448v96zM64 32H0V96 416v64H64 448h64V416 96 32H448 64z"],
    "user-chef": [448, 512, [], "e3d2", "M384 48c0 20.9-13.4 38.7-32 45.3V112v64c0 70.7-57.3 128-128 128s-128-57.3-128-128V112 93.3C77.4 86.7 64 68.9 64 48C64 21.5 85.5 0 112 0c14.3 0 27.2 6.3 36 16.3C156.8 6.3 169.7 0 184 0c16.7 0 31.4 8.5 40 21.5C232.6 8.5 247.3 0 264 0c14.3 0 27.2 6.3 36 16.3C308.8 6.3 321.7 0 336 0c26.5 0 48 21.5 48 48zM304 176V160H144v16c0 44.2 35.8 80 80 80s80-35.8 80-80zM128 410.8l224-89.6V352h48l48 160H352 128V410.8zM96 400V512H0L48 352H96V320l106.4 26.6-96.4 38.5-10.1 4V400zm128 32a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "message-image": [512, 512, ["comment-alt-image"], "e1e0", "M0 0H512V416H304L160 512V416H0V0zM176 128a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm120-16l-19.6 27.8L219.1 221l-17.1-19.3L184 181.5l-17.9 20.2-64 72L96 280.5v9.1 8 24h24 56 24 48 24H392h24v-24-8V282l-4.4-6.2-96-136L296 112z"],
    "users-medical": [640, 512, [], "f830", "M144 0a80 80 0 1 1 0 160A80 80 0 1 1 144 0zM512 0a80 80 0 1 1 0 160A80 80 0 1 1 512 0zM48 192H196c-2.6 10.2-4 21-4 32c0 38.2 16.8 72.5 43.3 96H0L48 192zM640 320H608V288H576 512 480v32H404.7c26.6-23.5 43.3-57.8 43.3-96c0-11-1.4-21.8-4-32H592l48 128zM480 480v32H128l48-160H416v32 64 32h32 32zM224 224a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zm288 96h64v64h64v64H576v64H512V448H448V384h64V320z"],
    "sensor-triangle-exclamation": [640, 512, ["sensor-alert"], "e029", "M448 32H0V480H237L448 93.2V32zM112 120V264v24H64V264 120 96h48v24zm96 0V264v24H160V264 120 96h48v24zm240 40L256 512H640L448 160zm16 144v64 16H432V368 304 288h32v16zM432 416h32v32H432V416z"],
    "magnifying-glass-arrow-right": [512, 512, [], "e521", "M416 208c0 45.9-14.9 88.3-40 122.7L486.6 441.4 509.3 464 464 509.3l-22.6-22.6L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM241 119l-17-17L190.1 136l17 17 31 31H120 96v48h24H238.1l-31 31-17 17L224 313.9l17-17 72-72 17-17-17-17-72-72z"],
    "tachograph-digital": [640, 512, ["digital-tachograph"], "f566", "M640 64H0V448H640V64zM352 128V256H64V128H352zM64 352H80 336h16v32H336 80 64V352zm320 0h16H560h16v32H560 400 384V352zM96 288v32H64V288H96zm32 0h32v32H128V288zm96 0v32H192V288h32zm32 0h32v32H256V288zm96 0v32H320V288h32z"],
    "face-mask": [576, 512, [], "e37f", "M509.8 384c21.8-37.7 34.2-81.4 34.2-128c0-2.2 0-4.5-.1-6.7L416 284.2V384h93.8zm-21.9 32H416v0l-32 32H192l-32-32v0H88.1c46.9 58.5 119 96 199.9 96s152.9-37.5 199.9-96zM66.2 384H160V284.2L32.1 249.3c-.1 2.2-.1 4.4-.1 6.7c0 46.6 12.5 90.3 34.2 128zM35 216.9l143.2 39H397.9l143.2-39C522.2 94.1 416.1 0 288 0S53.8 94.1 35 216.9zM240 176c-47 0-77.1 19.7-84.7 27.3l-22.6-22.6C146.4 167 184.6 144 240 144h16v32H240zm80-32h16c55.4 0 93.6 23 107.3 36.7l-22.6 22.6C413.1 195.7 383 176 336 176H320V144zM208 304H192v32h16H368h16V304H368 208zm0 64H192v32h16H368h16V368H368 208z"],
    "pickleball": [576, 512, [], "e435", "M288 0L528 240l-9 9c-24.8-15.7-54.3-24.8-85.9-24.8c-72 0-133 47.3-153.3 112.5L155.7 212.8l-11.3-11.3-22.6 22.7 11.3 11.3L273 374.9c-.2 3-.3 6.1-.3 9.1c0 31.7 9.2 61.2 25.2 86L288 480 160 432 80 512 16 448l80-80L48 240 288 0zm16 384a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm32-16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm80 80a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm0-64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm96 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm-80-80a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z"],
    "star-sharp-half": [576, 512, [], "e28c", "M288 391.2V.2L224.5 195.6H18.9L185.2 316.4 121.7 512 288 391.2z"],
    "users-slash": [640, 512, [], "e073", "M202.6 134.5C215.9 120.2 224 101.1 224 80c0-44.2-35.8-80-80-80C115.8 0 90.9 14.6 76.7 36.8l-28.3-22L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L441.5 320H640L592 192H444c2.6 10.2 4 21 4 32c0 30.1-10.4 57.7-27.7 79.5L395 283.9c13.1-16.4 21-37.2 21-59.9c0-53-43-96-96-96c-31.3 0-59.1 15-76.6 38.2l-40.8-31.7zM48 192L0 320H235.3c-20.6-18.2-35.3-42.8-40.8-70.8L121.8 192H48zM176 352L128 512H512l-5-16.5L324.9 352H176zM512 160A80 80 0 1 0 512 0a80 80 0 1 0 0 160z"],
    "clover": [448, 512, [], "e139", "M120.9 126.9L160 192 94.9 152.9C85.1 147.1 74 144 62.6 144C28 144 0 172 0 206.6V224l32 32L0 288v17.4C0 340 28 368 62.6 368c11.4 0 22.5-3.1 32.2-8.9L160 320l-39.1 65.1c-5.8 9.7-8.9 20.9-8.9 32.2c0 34.6 28 62.6 62.6 62.6H192l32-32 32 32h17.4c34.6 0 62.6-28 62.6-62.6c0-11.4-3.1-22.5-8.9-32.2L288 320l65.1 39.1c9.7 5.8 20.9 8.9 32.2 8.9c34.6 0 62.6-28 62.6-62.6V288l-32-32 32-32V206.6c0-34.6-28-62.6-62.6-62.6c-11.4 0-22.5 3.1-32.2 8.9L288 192l39.1-65.1c5.8-9.7 8.9-20.9 8.9-32.2C336 60 308 32 273.4 32H256L224 64 192 32H174.6C140 32 112 60 112 94.6c0 11.4 3.1 22.5 8.9 32.2z"],
    "meat": [512, 512, [127830], "f814", "M243.6 19.6C283.7-20.4 371.9 2.8 440.5 71.5s91.9 156.8 51.8 196.9l-40.5 40.5C403.9 357 338.7 384 270.8 384H201.5l-26.4 26.4C185.6 421.1 192 435.8 192 452c0 33.1-26.9 60-60 60s-60-26.9-60-60V440H60c-33.1 0-60-26.9-60-60s26.9-60 60-60c16.2 0 30.9 6.4 41.7 16.8L128 310.5V241.3c0-67.9 27-133 75-181l40.7-40.7zm64 184.8c49.6 49.6 113.3 66.4 142.2 37.4s12.2-92.6-37.4-142.2S299.1 33.2 270.2 62.2s-12.2 92.6 37.4 142.2zm36.3-36.3c-15.3-15.3-20.4-34.9-11.5-43.8s28.5-3.7 43.8 11.5s20.4 34.9 11.5 43.8s-28.5 3.7-43.8-11.5z"],
    "reply": [512, 512, [61714, "mail-reply"], "f3e5", "M0 208L192 384h32V288h80c61.9 0 112 50.1 112 112c0 48-32 80-32 80s128-48 128-176c0-97.2-78.8-176-176-176H224V32H192L0 208z"],
    "star-and-crescent": [512, 512, [9770], "f699", "M328 48c44.1 0 85 13.7 118.6 37.1C399.8 32.9 331.7 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c75.7 0 143.8-32.9 190.6-85.1C413 450.3 372.1 464 328 464c-114.9 0-208-93.1-208-208s93.1-208 208-208zm98.3 157.8L384 120l-42.3 85.8L247 219.5l68.5 66.7-16.2 94.2L384 336l84.6 44.5-16.2-94.2L521 219.5l-94.6-13.8z"],
    "empty-set": [512, 512, [8709, 216], "f656", "M435.4 121.8l67.2-67.2L457.4 9.4 390.1 76.6C352.8 48.6 306.3 32 256 32C132.3 32 32 132.3 32 256c0 50.3 16.6 96.8 44.6 134.1L9.4 457.4l45.3 45.3 67.2-67.2c37.4 28 83.8 44.6 134.1 44.6c123.7 0 224-100.3 224-224c0-50.3-16.6-96.8-44.6-134.1zm-91.2 .7L122.5 344.2C105.8 318.9 96 288.6 96 256c0-88.4 71.6-160 160-160c32.6 0 62.9 9.8 88.2 26.5zm-176.5 267L389.5 167.8C406.2 193.1 416 223.4 416 256c0 88.4-71.6 160-160 160c-32.6 0-62.9-9.8-88.2-26.5z"],
    "house-fire": [640, 512, [], "e50c", "M439.4 126L288.4 0 0 240v47.6H64.1V512H224V352h64c.1-56.8 36.1-108.7 71.8-149.9c24.3-28 51.2-52.6 79.6-76.1zm8.6 34.1s-128 103.6-128 192s71.6 160 160 160s160-71.6 160-160c0-73.6-96-160-96-160s-13.9 12.5-31 32c-32.3-37.5-65-64-65-64zM481 448c-45 0-81-29-81-78c0-24 15-45 45-82c4 5 62 79 62 79l36-42c3 4 5 8 7 12c18 33 10 75-20 96c-15 10-31 15-49 15z"],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", "M448 32H0V480H448V32zM152 232H296h24v48H296 152 128V232h24z"],
    "helicopter": [640, 512, [128641], "f533", "M576 64H384v64h32c88.4 0 160 71.6 160 160v64 32H544 384 288L192 256 32 192 0 64H64l48 64H320V64H128V0H576V64zM384 320H512V288c0-53-43-96-96-96H384V320zm256 96v64 32H608 224V448H576V416h64z"],
    "bird": [512, 512, [], "e469", "M0 160v32C0 294.3 68.5 380.5 162.1 407.4L217.6 512h54.3l-.7-1.2L221 416c1 0 2 0 3 0c12.6 0 25-1 37.1-3.1L313.6 512h54.3l-.7-1.2L308.3 399.6C390.3 366.3 448 285.9 448 192V170.7L512 128 447.4 84.9C441.9 37.1 401.3 0 352 0c-53 0-96 43-96 96v64H0zM352 96a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "compass": [512, 512, [129517], "f14e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM128 384l64-192 192-64L320 320 128 384zM288 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", "M0 480l448 0 0-448L0 32 0 480zM352 224L224 352 96 224l0-32 256 0 0 32z"],
    "heart-half-stroke": [512, 512, ["heart-half-alt"], "e1ac", "M256 389.5L402.7 242.8 427 218.5c13.5-13.5 21-31.7 21-50.7c0-39.6-32.1-71.8-71.8-71.8c-19 0-37.3 7.6-50.7 21l-24.2 24.2L256 186.5v203zM256 96l24.2-24.2c25.5-25.5 60-39.8 96-39.8C451.2 32 512 92.8 512 167.8c0 36-14.3 70.5-39.8 96L448 288 301.3 434.8 256 480l-45.3-45.3L64 288 39.8 263.8C14.3 238.3 0 203.8 0 167.8c0 0 0 0 0 0s0 0 0 0C0 92.8 60.8 32 135.8 32c36 0 70.5 14.3 96 39.8L256 96v0z"],
    "file-circle-question": [576, 512, [], "e4ef", "M0 0H224V160H384v38.6C310.1 219.5 256 287.4 256 368c0 59.5 29.6 112.1 74.8 144H0V0zM384 128H256V0L384 128zm48 96a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm-22.4 56c-23 0-41.6 18.6-41.6 41.6V328l32 0v-6.4c0-5.3 4.3-9.6 9.6-9.6h40.5c7.7 0 13.9 6.2 13.9 13.9c0 5.2-2.9 9.9-7.4 12.3l-32 16.8-8.6 4.5v9.7V376v16h32V378.9l23.5-12.3c15.1-7.9 24.5-23.6 24.5-40.6c0-25.4-20.6-45.9-45.9-45.9H409.6zM448 416H416v32h32V416z"],
    "laptop-code": [640, 512, [], "f5fc", "M64 32H96 544h32V64 352H512V96H128V352H64V64 32zM0 432V384H640v48l-48 48H48L0 432zM281 209l-31 31 31 31 17 17L264 321.9l-17-17-48-48-17-17 17-17 48-48 17-17L297.9 192l-17 17zM393 175l48 48 17 17-17 17-48 48-17 17L342.1 288l17-17 31-31-31-31-17-17L376 158.1l17 17z"],
    "joystick": [448, 512, [128377], "f8c5", "M336 112c0 50.7-33.7 93.6-80 107.4V320H192V219.4c-46.3-13.8-80-56.6-80-107.4C112 50.1 162.1 0 224 0s112 50.1 112 112zM200 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM64 320h64v32H448V512H0V352H64V320z"],
    "grill-fire": [576, 512, [], "e5a4", "M0 32H448V96c0 24.1-3.8 47.4-10.9 69.1c-16.9-16.3-34.8-31.3-53.1-46.1c-31.6 25.6-61.5 52.3-88.2 83.1c-28.9 33.3-58 73.7-68.1 117.9c-1.2 0-2.5 0-3.7 0c-16.9 0-33.4-1.9-49.3-5.4L151.8 368h72.8c1.4 16.7 4.9 32.8 10.2 48H160c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c3.4 0 6.8 .3 10.1 .8L129.2 299C52.9 263.3 0 185.8 0 96V32zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM449 224.1c17.2-19.5 31-32 31-32s96 86.4 96 160c0 88.4-71.6 160-160 160s-160-71.6-160-160s128-192 128-192s32.6 26.4 65 64zM466 433c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78c18 0 34-5 49-15z"],
    "rectangle-vertical-history": [576, 512, [], "e237", "M576 0H192V512H576V0zM96 48V464h48V48H96zM0 96V416H48V96H0z"],
    "swatchbook": [512, 512, [], "f5c3", "M0 416c0 53 43 96 96 96s96-43 96-96L192 0H0V416zM128 64v64H64V64h64zm0 128v64H64V192h64zM72 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm108.7 96H512V320H373L186.5 506.5c-1.9 1.9-3.8 3.7-5.8 5.5zM458 189.7L322.3 54 224 152.2V423.8l234-234z"],
    "prescription-bottle": [384, 512, [], "f485", "M0 0H384V96H0V0zM32 128H352V512H32V416H144h16V384H144 32V320H144h16V288H144 32V224H144h16V192H144 32V128z"],
    "bars": [448, 512, ["navicon"], "f0c9", "M0 64H448v64H0V64zM0 224H448v64H0V224zM448 384v64H0V384H448z"],
    "keyboard-left": [640, 512, [], "e1c3", "M160 64H640V448H160V64zm64 64v64h64V128H224zm64 96H224v64h64V224zm-64 96v64h64V320H224zM384 128H320v64h64V128zm-64 96v64h64V224H320zm160 96H320v64H480V320zM416 128v64h64V128H416zm64 96H416v64h64V224zm32-96v64h64V128H512zm64 96H512v64h64V224zm-64 96v64h64V320H512zM0 256l96-96h32V352H96L0 256z"],
    "people-group": [640, 512, [], "e533", "M128 32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM53.3 275.1L64 292.4V247.3L53.3 275.1zM0 280L40 176H212.3l-.1 .1-64 112L138 305.9 150 322.6l42 58.9V384v64H64V384L0 280zM448 381.5l42-58.9L502 305.9l-10.2-17.8-64-112-.1-.1H600l40 104L576 384v64H448V384v-2.5zM512 32a56 56 0 1 1 0 112 56 56 0 1 1 0-112zm74.7 243.1L576 247.3v45.1l10.7-17.3zM320 32a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM232.9 301.1L256 333.4V260.7l-23.1 40.4zM384 260.7v72.7l23.1-32.3L384 260.7zM464 304L384 416v64H256l0-64L176 304l64-112H400l64 112z"],
    "hourglass-end": [384, 512, [8987, "hourglass-3"], "f253", "M0 0H32 352h32V64H352v64 13.3l-9.4 9.4L237.3 256 342.6 361.4l9.4 9.4V384v64h32v64H352 32 0V448H32V384 370.7l9.4-9.4L146.7 256 41.4 150.6 32 141.3V128 64H0V0zM96 64v50.7l96 96 96-96V64H96z"],
    "heart-crack": [512, 512, [128148, "heart-broken"], "f7a9", "M224 208l64 112L160 208l80-80L175.7 38c-12.8-4-26.3-6-40-6C60.8 32 0 92.8 0 167.8c0 36 14.3 70.5 39.8 96L64 288 256 480 448 288l24.2-24.2c25.5-25.5 39.8-60 39.8-96C512 92.8 451.2 32 376.2 32c-27.6 0-54.4 8.4-76.8 23.8L320 128l-96 80z"],
    "face-beam-hand-over-mouth": [512, 512, [129325], "e47c", "M512 256c0 113.1-73.3 209.1-175.1 242.9l52.3-52.3L411.9 424l-22.6-22.6-9.4-9.4 9.4-9.4L411.9 360l-22.6-22.6-9.4-9.4 16-16-22.6-22.6-22.6-22.6L328 244.1l-16 16-9.4-9.4L280 228.1l-22.6 22.6-51.7 51.7H184 144 112v32 82.4c0 21.9 5.5 42.5 15.3 60.5C51.2 433 0 350.5 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256zM176 120c-28 0-56 40-56 80c0 0 28-32 56-32s56 32 56 32c0-40-28-80-56-80zm104 80s28-32 56-32s56 32 56 32c0-40-28-80-56-80s-56 40-56 80zm22.6 96l-11.3 11.3-56 56 9.4 9.4 72-72L328 289.4 350.6 312l-11.3 11.3-72 72 9.4 9.4 56-56L344 337.4 366.6 360l-11.3 11.3-56 56 9.4 9.4 24-24L344 401.4 366.6 424l-11.3 11.3-48.8 48.8C288.7 502 264.4 512 239.2 512c-52.6 0-95.2-42.6-95.2-95.2V404 384 354.4v-20h40v20 15l84.7-84.7L280 273.4 302.6 296z"],
    "droplet-percent": [384, 512, ["humidity"], "f750", "M192 512c106 0 192-86 192-192S192 0 192 0S0 214 0 320S86 512 192 512zm86.6-256l-11.3 11.3-128 128L128 406.6 105.4 384l11.3-11.3 128-128L256 233.4 278.6 256zM136 240a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM248 352a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "square-up-right": [448, 512, [8599, "external-link-square-alt"], "f360", "M0 32H448V480H0V32zM320 320V160H160l-24 24 52 52-76 76 56 56 76-76 52 52 24-24z"],
    "face-kiss-beam": [512, 512, [128537, "kiss-beam"], "f597", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm48.7-198.3c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448l-3.9-15 0 0 0 0 0 0 0 0 .2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1 0 0 0 0 0 0 0 0V361l0 0 0 0 0 0 0 0 .2-.1 .3-.2 .6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3-.5-.3-.2-.1 0 0 0 0 0 0 0 0 3.9-15c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4zM176 152c28 0 56 40 56 80c0 0-28-32-56-32s-56 32-56 32c0-40 28-80 56-80zm104 80c0-40 28-80 56-80s56 40 56 80c0 0-28-32-56-32s-56 32-56 32z"],
    "corn": [512, 512, [127805], "f6c7", "M512 40c0 15-8.3 28.1-20.5 34.9C499.2 82.2 504 92.6 504 104c0 18-11.8 33.2-28.2 38.2c2.7 5.4 4.2 11.4 4.2 17.8c0 18-11.8 33.2-28.2 38.2c2.7 5.4 4.2 11.4 4.2 17.8c0 22.1-17.9 40-40 40c-1.1 0-2.3 0-3.4-.1c2.2 4.9 3.4 10.4 3.4 16.1c0 13.6-6.8 25.7-17.3 32.9c-47.7-29.7-103.6-41.1-157.5-34.2c6.9-53.9-4.5-109.8-34.2-157.5C214.3 102.8 226.4 96 240 96c5.7 0 11.2 1.2 16.1 3.4c-.1-1.1-.1-2.2-.1-3.4c0-22.1 17.9-40 40-40c6.4 0 12.4 1.5 17.8 4.2C318.8 43.8 334 32 352 32c6.4 0 12.4 1.5 17.8 4.2C374.8 19.8 390 8 408 8c11.4 0 21.8 4.8 29.1 12.5C443.9 8.3 457 0 472 0c22.1 0 40 17.9 40 40zM139.9 82.5l10.4 10.4c50.2 50.2 69.4 119.6 57.5 184.6c-38.7 10.7-75.2 31.2-105.5 61.6L28.7 412.7 0 384V320L112 208 139.9 82.5zM51.3 435.3l73.6-73.6c28.6-28.6 63.5-47.1 100.1-55.6c67.6-15.6 141.4 3 194 55.6l10.4 10.4L304 400 192 512H128L51.3 435.3z"],
    "roller-coaster": [640, 512, [], "e324", "M64 190.1c0-31.8 15.8-60 40-77V456v24h48V456 96.2c2-.1 4-.2 6.1-.2c14.8 0 29.1 3.5 41.9 9.9V456v24h48V456 154.7l48 69.1V456v24h48V456 292.9l20.3 29.2c7.9 11.3 17.2 21.3 27.7 29.8V456v24h48V456 377.6c13.6 4.2 28 6.4 42.6 6.4H488v72 24h48V456 378.4c14.4-4.2 27.8-10.5 40-18.6V448v32h64V448 240h0c0-79.5-64.5-144-144-144h-4c-28.9 0-57.3 7.1-82.8 20.7l-51.6 27.5L432 251.3V177.1l7.3-3.9c12.7-6.8 26.5-11 40.7-12.5V287.9c.9 0 1.7 .1 2.6 .1H496c12.3 0 23.5-4.6 32-12.2V166.7c28.3 12.3 48 40.5 48 73.3h0c0 44.2-35.8 80-80 80H482.6c-26.2 0-50.8-12.8-65.7-34.4L287.9 99.9C258.4 57.4 209.9 32 158.1 32C70.8 32 0 102.8 0 190.1V448v32H64V448 190.1z"],
    "photo-film-music": [640, 512, [], "e228", "M640 0H192V320H368V256H352 288V224l72-80 28 32 60-80 51 68 141-47V0zM160 392V96H0V448H289.9c4.4-18.3 15.9-33.2 29.7-43.5c6.7-5 14.2-9.2 22.3-12.5H160zM288 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM56 152h48v48H56V152zm48 96v48H56V248h48zM56 344h48v48H56V344zM640 152l-31.6 10.5-192 64L400 232v17.3 48V418.8c-5.1-1-10.5-1.5-16-1.5c-35.3 0-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48V314.6l144-48v88.2c-5.1-1-10.5-1.5-16-1.5c-35.3 0-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48c0-1.5-.1-3-.3-4.4c.2-1.2 .3-2.4 .3-3.6v-160-48V152z"],
    "radar": [512, 512, [], "e024", "M304.8 173.3c-14.3-8.4-31-13.3-48.8-13.3c-53 0-96 43-96 96s43 96 96 96s96-43 96-96h64c0 73.5-49.6 135.5-117.2 154.2C290.8 394.7 274.7 384 256 384s-34.8 10.7-42.8 26.2c-51.7-14.3-92.8-53.9-109.4-104.6c14.4-8.3 24.1-23.8 24.1-41.7c0-19.4-11.5-36.1-28-43.7C116.2 149.1 179.9 96 256 96c35.5 0 68.3 11.6 94.9 31.2l22.8-22.8C341.2 79 300.4 64 256 64C163.1 64 85.7 129.9 67.9 217.6C47.2 222.9 32 241.7 32 264c0 23.8 17.3 43.6 40.1 47.4c19.3 64.3 71.5 114.4 137 130.9C213.8 463.8 233 480 256 480s42.2-16.2 46.9-37.8C386.3 421.3 448 345.9 448 256h64c0 141.4-114.6 256-256 256S0 397.4 0 256S114.6 0 256 0c62.1 0 118.9 22.1 163.3 58.8L455 23l17-17L505.9 40 489 57l-174 174c3.3 7.7 5.1 16.1 5.1 25c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c8.9 0 17.3 1.8 25 5.1l23.8-23.8z"],
    "sickle": [512, 512, [], "f822", "M224 352l-43-43c-33.9-33.9-53-80-53-128C128 81 209 0 309 0h11C426 0 512 86 512 192l-22.7-31.2C463.3 125.1 421.9 104 377.8 104C301.7 104 240 165.7 240 241.8v9.8c0 18.8 3.6 37.4 10.6 54.8L256 320l-32 32zM0 448l88-88L64 336l48-48L224 400l-48 48-24-24L64 512 0 448z"],
    "film": [512, 512, [127902], "f008", "M0 32H512V480H0V32zM48 352v64h64V352H48zm416 0H400v64h64V352zM48 224v64h64V224H48zm416 0H400v64h64V224zM48 96v64h64V96H48zm416 0H400v64h64V96zM160 96V224H352V96H160zM352 288H160V416H352V288z"],
    "coconut": [512, 512, [], "e2f6", "M141.1 141.1c-43.7 43.7-73 91.8-85.8 133.3c-13.2 42.7-7.4 71.9 7.5 86.7s44 20.6 86.7 7.5c41.5-12.8 89.6-42.1 133.3-85.8s73-91.8 85.8-133.3c13.2-42.7 7.4-71.9-7.5-86.7s-44-20.6-86.7-7.5c-41.5 12.8-89.6 42.1-133.3 85.8zM260.3 9.4C309.5-5.8 361.5-4.8 395.1 28.8l41 40.9C484.7 118.3 512 184.2 512 252.9c0 143.1-116 259-259 259c-68.7 0-134.6-27.3-183.2-75.9l-41-41C-4.8 361.5-5.8 309.5 9.4 260.3c15.6-50.4 49.7-105 97.8-153.1S209.9 25 260.3 9.4zm63.5 88.1c25 25-5.4 95.9-67.9 158.4s-133.4 92.9-158.4 67.9s5.4-95.9 67.9-158.4S298.8 72.6 323.8 97.6zm95.4 107.1l-11.3-11.3L385.3 216l11.3 11.3 32 32 11.3 11.3L462.6 248l-11.3-11.3-32-32zm-56 136l-11.3-11.3L329.3 352l11.3 11.3 32 32 11.3 11.3L406.6 384l-11.3-11.3-32-32zm-136 56l-11.3-11.3L193.3 408l11.3 11.3 32 32 11.3 11.3L270.6 440l-11.3-11.3-32-32z"],
    "ruler-horizontal": [640, 512, [], "f547", "M0 128L0 384l640 0 0-256-112 0 0 80 0 16-32 0 0-16 0-80-64 0 0 80 0 16-32 0 0-16 0-80-64 0 0 80 0 16-32 0 0-16 0-80-64 0 0 80 0 16-32 0 0-16 0-80-64 0 0 80 0 16-32 0 0-16 0-80L0 128z"],
    "shield-cross": [512, 512, [9960], "f712", "M267.6 4.5L256 0 244.4 4.5 36.9 85 17.8 92.5 16.6 113c-2.9 49.9 4.9 126.3 37.3 200.9c32.7 75.3 91 150 189.4 192.6L256 512l12.7-5.5c98.4-42.6 156.7-117.3 189.4-192.6c32.4-74.7 40.2-151 37.3-200.9l-1.2-20.5L475.1 85 267.6 4.5zM224 81.1l32-12.4 32 12.4V160H431c-1.5 19.5-4.7 41.3-10.1 64H288V423.8c-10 6.5-20.7 12.6-32 18.1c-11.3-5.5-22-11.6-32-18.1V224H91.2c-5.4-22.7-8.6-44.5-10.1-64H224V81.1z"],
    "cassette-tape": [576, 512, [128429], "f8ab", "M0 32H576V480H483.1L439 362.4 435.1 352H424 152 140.9L137 362.4 92.9 480H0V32zM412.9 384l36 96H127.1l36-96H412.9zM341.5 192H234.5c3.5 10 5.5 20.8 5.5 32s-1.9 22-5.5 32H341.5c-3.5-10-5.5-20.8-5.5-32s1.9-22 5.5-32zm90.5 0a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM112 224a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"],
    "square-terminal": [448, 512, [], "e32a", "M0 32H448V480H0V32zM62.1 176l17 17 63 63L79 319l-17 17L96 369.9l17-17 80-80 17-17-17-17-80-80-17-17L62.1 176zM216 336H192v48h24H360h24V336H360 216z"],
    "people-robbery": [576, 512, [], "e536", "M80 96A48 48 0 1 0 80 0a48 48 0 1 0 0 96zM40 128H8v32V288v32H8V480v32H72V480 352H88V480v32h64V480 252.7l13 20.5 9.4 14.9H192h48 32V224H240 209.6l-51.5-81.1L148.7 128H131.1 40zM400 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM273.1 168.2l6.3 23.8H304h24V480v32h64V480 352h16V480v32h64V480 192h24 24.6l6.3-23.8 32-120 8.2-30.9L505.3 .8l-8.2 30.9L471.4 128H408v0H392v0H328.6L302.9 31.8 294.7 .8 232.8 17.3l8.2 30.9 32 120z"],
    "lightbulb": [384, 512, [128161], "f0eb", "M272 384c9.6-31.9 29.5-59.1 49.2-86.2l0 0c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C368 78.8 289.2 0 192 0S16 78.8 16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4l0 0c19.8 27.1 39.7 54.4 49.2 86.2H272zM112 416v96H272V416H112zm0-240H80c0-61.9 50.1-112 112-112V96c-44.2 0-80 35.8-80 80z"],
    "caret-left": [256, 512, [], "f0d9", "M144 96L0 256 144 416l48 0 0-320-48 0z"],
    "comment-middle": [512, 512, [], "e149", "M320.1 409.4C430.5 386.3 512 304.9 512 208C512 93.1 397.4 0 256 0S0 93.1 0 208c0 96.9 81.5 178.3 191.9 201.4L256 512l64.1-102.6z"],
    "trash-can-list": [640, 512, [], "e2ab", "M288 0H128L112 32H0V96H416V32H304L288 0zm96 128H32V512H384V128zM160 208V432v16H128V432 208 192h32v16zm128 0V432v16H256V432 208 192h32v16zm352-80H448v64H640V128zM608 256H448v64H608V256zM448 384v64h96V384H448z"],
    "block": [640, 512, [], "e46a", "M96 32H544V480H96V32zm96 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm280 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM192 408a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm280 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "circle-exclamation": [512, 512, ["exclamation-circle"], "f06a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-384v24V264v24H232V264 152 128h48zM232 368V320h48v48H232z"],
    "school-circle-xmark": [640, 512, [], "e56d", "M640 96V266.8C608.1 221.6 555.5 192 496 192c-38.5 0-74.2 12.4-103.1 33.4c9.6-14.1 15.1-31.1 15.1-49.4c0-48.6-39.4-88-88-88s-88 39.4-88 88s39.4 88 88 88c15.6 0 30.2-4 42.9-11.1c-23.4 27.1-38.8 61.4-42.2 99.1H320c-35.3 0-64 28.7-64 64v96H0V96H160L320 0 480 96H640zM144 192H80v96h64V192zm0 128H80v96h64V320zM336 128v16 16h16 16v32H352 320 304V176 144 128h32zm160 96a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3L566.6 320 544 297.4l-11.3 11.3L496 345.4l-36.7-36.7L448 297.4 425.4 320l11.3 11.3L473.4 368l-36.7 36.7L425.4 416 448 438.6l11.3-11.3L496 390.6l36.7 36.7L544 438.6 566.6 416l-11.3-11.3L518.6 368l36.7-36.7z"],
    "arrow-right-from-bracket": [512, 512, ["sign-out"], "f08b", "M502.6 278.6L525.3 256l-22.6-22.6-128-128L352 82.7 306.7 128l22.6 22.6L402.7 224 192 224l-32 0 0 64 32 0 210.7 0-73.4 73.4L306.7 384 352 429.3l22.6-22.6 128-128zM160 96l32 0 0-64-32 0L32 32 0 32 0 64 0 448l0 32 32 0 128 0 32 0 0-64-32 0-96 0L64 96l96 0z"],
    "face-frown-slight": [512, 512, [], "e376", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM382.3 392.8l-28.6 14.3C344.9 389.7 312.4 352 256 352s-88.9 37.7-97.7 55.2l-28.6-14.3C142.3 367.7 184.4 320 256 320s113.7 47.7 126.3 72.8zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-chevron-down": [512, 512, ["chevron-circle-down"], "f13a", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM239 345L135 241l-17-17L152 190.1l17 17 87 87 87-87 17-17L393.9 224l-17 17L273 345l-17 17-17-17z"],
    "sidebar-flip": [512, 512, [], "e24f", "M512 32H0V480H512V32zM288 96V416H64V96H288zm64 0h96v48H352V96zm96 96v48H352V192h96zm-96 96h96v48H352V288z"],
    "unlock-keyhole": [448, 512, ["unlock-alt"], "f13e", "M144 144c0-44.2 35.8-80 80-80c38.7 0 71 27.5 78.4 64h64.7C359.2 56 298.1 0 224 0C144.5 0 80 64.5 80 144v48H0V512H448V192H144V144zM256 384H192 160V320h32 64 32v64H256z"],
    "temperature-list": [512, 512, [], "e299", "M81.8 317.8L96 300.2V277.5 64h96V277.5v22.7l14.2 17.6C217.4 331.5 224 348.9 224 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-19.1 6.6-36.5 17.8-50.3zM256 0H192 96 32V64 277.5C12 302.2 0 333.7 0 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5V64 0zM144 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V176 160H128v16V322.8c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48zM352 32H320V96h32H480h32V32H480 352zM320 160v64h32H480h32V160H480 352 320zm64 128H352v64h32 96 32V288H480 384z"],
    "cloud-showers-heavy": [512, 512, [], "f740", "M96 320H0V224c0-41.8 26.7-77.4 64-90.5V112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H416 96zM72 352h56L56 512H0L72 352zm120 0h56L176 512H120l72-160zm168 0L288 512H232l72-160h56zm64 0h56L408 512H352l72-160z"],
    "headphones-simple": [512, 512, ["headphones-alt"], "f58f", "M256 80C141.1 80 48 173.1 48 288V392v24H0V392 288C0 146.6 114.6 32 256 32s256 114.6 256 256V392v24H464V392 288c0-114.9-93.1-208-208-208zM80 288H192V480H80V288zm240 0H432V480H320V288z"],
    "sitemap": [576, 512, [], "f0e8", "M208 32H368V192H312v40H496h24v24 64h56V480H416V320h56V280H312v40h56V480H208V320h56V280H104v40h56V480H0V320H56V256 232H80 264V192H208V32z"],
    "pipe-section": [640, 512, [], "e438", "M64 96H0v32V384v32H64V384 128 96zm576 0H576v32V384v32h64V384 128 96zm-96 32H96V384H544V128z"],
    "space-station-moon-construction": [512, 512, ["space-station-moon-alt"], "e034", "M511 279.1c.7-7.6 1-15.3 1-23.1c0-10.8-.7-21.5-2-32H448V160H416 352V96h64V56.1C372.2 21 316.5 0 256 0C114.6 0 0 114.6 0 256c0 7.8 .3 15.5 1 23.1C73.2 304.7 160.8 320 256 320s182.8-15.3 255-40.9zM6.8 314.8C33.4 427.9 134.9 512 256 512c76.5 0 145.1-33.5 192-86.7V384H384V342.8c-40.7 6-83.7 9.2-128 9.2c-91.3 0-176.6-13.6-249.2-37.2zM192 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0-112a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "circle-dollar-to-slot": [512, 512, ["donate"], "f4b9", "M352 392.6c-28.7 15-61.4 23.4-96 23.4c-35.9 0-69.7-9.1-99.1-25.1c-19-10.3-36.1-23.5-50.9-38.9C70 314.6 48 263.9 48 208C48 93.1 141.1 0 256 0S464 93.1 464 208c0 55.9-22 106.6-57.9 144c-1 1-2 2.1-3 3.1c-14.9 14.9-32.2 27.6-51.1 37.5zM276.1 91.9H235.9V112v6c-5.6 1.2-10.9 2.9-15.9 5.1c-15 6.8-27.9 19.4-31.1 37.7c-1.8 10.2-.8 20 3.4 29c4.2 8.8 10.7 15 17.3 19.5c11.6 7.9 26.9 12.5 38.6 16l2.2 .7c13.9 4.2 23.4 7.4 29.3 11.7c2.5 1.8 3.4 3.2 3.7 4c.3 .8 .9 2.6 .2 6.7c-.6 3.5-2.5 6.4-8 8.8c-6.1 2.6-16 3.9-28.8 1.9c-6-1-16.7-4.6-26.2-7.9l0 0 0 0c-2.2-.8-4.4-1.5-6.4-2.1l-19-6.3-12.6 38 19 6.3c1.2 .4 2.7 .9 4.4 1.5l0 0 0 0c7.9 2.7 20.3 6.9 29.8 9.1V304v20.1h40.2V304v-5.5c5.3-1 10.5-2.5 15.4-4.6c15.7-6.7 28.4-19.7 31.6-38.7c1.8-10.4 1-20.3-3-29.4c-3.9-9-10.2-15.6-16.9-20.5c-12.2-8.8-28.3-13.7-40.4-17.4l-.8-.2c-14.2-4.3-23.8-7.3-29.9-11.4c-2.6-1.8-3.4-3-3.6-3.5c-.2-.3-.7-1.6-.1-5c.3-1.9 1.9-5.2 8.2-8.1c6.4-2.9 16.4-4.5 28.6-2.6c4.3 .7 17.9 3.3 21.7 4.3l19.3 5.1 10.3-38.7-19.3-5.1c-4.4-1.2-14.4-3.2-21-4.4V112 91.9zM32 352H64c19.5 25.9 44 47.7 72.2 64H64v32H256 448V416H375.8c28.2-16.3 52.8-38.1 72.2-64h32 32v32 96 32H480 32 0V480 384 352H32z"],
    "memory": [576, 512, [], "f538", "M576 64H0v82.7c18.6 6.6 32 24.4 32 45.3s-13.4 38.7-32 45.3V320H576V237.3c-18.6-6.6-32-24.4-32-45.3s13.4-38.7 32-45.3V64zm0 288H0v96H80V416 400h32v16 32h96V416 400h32v16 32h96V416 400h32v16 32h96V416 400h32v16 32h80V352zM192 128v32 64 32H128V224 160 128h64zm128 32v64 32H256V224 160 128h64v32zm128-32v32 64 32H384V224 160 128h64z"],
    "face-sleeping": [512, 512, [], "e38d", "M384 48V34.2C346.3 12.5 302.6 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512s256-114.6 256-256c0-46.6-12.5-90.3-34.2-128H432 384V80 72 64 48zM256 64h16 64 16V80v8 8l-6.4 4.8L309.3 128H336h16v32H336 272 256V144v-8-8l6.4-4.8L298.7 96H272 256V64zM216 384a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM395.2 234.4l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2c21.6 28.8 64.8 28.8 86.4 0zm-278.4 0c21.6 28.8 64.8 28.8 86.4 0l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2zM432 0H416V32h16 26.7L422.4 59.2 416 64v8 8V96h16 64 16V64H496 469.3l36.3-27.2L512 32V24 16 0H496 432z"],
    "road-spikes": [640, 512, [], "e568", "M32 96V352H160h64 64 64 64 64H608L448 96H416V249.6L320 96H288V249.6L192 96H160V249.6L64 96H32zM0 384v64H32 608h32V384H608 32 0z"],
    "fire-burner": [640, 512, [], "e4f1", "M353 64.1c17.2-19.5 31-32 31-32s96 86.4 96 160c0 88.4-71.6 160-160 160s-160-71.6-160-160s128-192 128-192s32.6 26.4 65 64zM370 273c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78c18 0 34-5 49-15zM32 256H64 96h32v64H96v64H544V320H512V256h32 32 32v32 96h32V512H0V384H32V288 256zM320 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM192 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "squirrel": [512, 512, [], "f71a", "M160 299.3c-19.9 22.6-32 52.2-32 84.7V512H256h64 32 96 32V448H448 432c10-13.4 16-30 16-48c0-26.2-12.6-49.4-32-64c-13.4-10-30-16-48-16c-9.4 0-18.3 1.6-26.7 4.5l-10.7-30.2c11.7-4.1 24.3-6.4 37.3-6.4c17.2 0 33.5 3.9 48 10.8V240h64l32-48V160l-87.9-58.6c-2.5-1.7-5.3-3-8.1-3.9V96 64c-20.4 0-38.2 10.9-48 27.1C358.2 74.9 340.4 64 320 64V96v32 54.2V224l-25.3 38c-2.2-.7-4.4-1.3-6.7-1.9V144C288 64.5 223.5 0 144 0S0 64.5 0 144s64.5 144 144 144c5.4 0 10.7-.3 16-.9v12.2zM416 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "arrow-up-to-line": [384, 512, ["arrow-to-top"], "f341", "M32 32H0V96H32 352h32V32H352 32zM214.6 169.4L192 146.7l-22.6 22.6-128 128L18.7 320 64 365.3l22.6-22.6L160 269.3V448v32h64V448 269.3l73.4 73.4L320 365.3 365.3 320l-22.6-22.6-128-128z"],
    "flag": [448, 512, [127988, 61725], "f024", "M64 32V0H0V32 64 368 480v32H64V480 352l64.3-16.1c41.1-10.3 84.6-5.5 122.5 13.4c44.2 22.1 95.5 24.8 141.7 7.4L448 336V16L393.6 43.2c-46.3 23.2-100.8 23.2-147.1 0c-35.1-17.6-75.4-22-113.5-12.5L64 48V32z"],
    "face-cowboy-hat": [512, 512, [], "e36e", "M192 0l64 32L320 0l55.4 110.8c36.5-11.1 68.9-27.1 95.3-46.8L488 81.3C460.8 163.5 367.2 224 256 224S51.2 163.5 24 81.3L41.3 64c26.4 19.7 58.8 35.7 95.3 46.8L192 0zM48 304c0-37.9 10.1-73.4 27.8-104c48.8 35.3 112.5 56 180.2 56s131.4-20.6 180.2-56c17.7 30.6 27.8 66.1 27.8 104c0 114.9-93.1 208-208 208S48 418.9 48 304zm208.2 72.8c-44.3 0-85.6-8-120.2-21.7c12.2 55.4 61.4 96.9 120.2 96.9s108-41.5 120.2-96.9c-34.6 13.8-75.9 21.7-120.2 21.7zM216 304a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm104 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "hanukiah": [640, 512, [128334], "f6e6", "M316.1 6c1.6-2.4 3-4.5 3.9-6c.9 1.6 2.3 3.6 3.9 6C331.2 17.1 344 36.3 344 56c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-19.7 12.8-38.9 20.1-50zM28.1 54c1.6-2.4 3-4.5 3.9-6c.9 1.6 2.3 3.6 3.9 6l0 0C43.2 65.1 56 84.3 56 104c0 13.3-10.7 24-24 24s-24-10.7-24-24C8 84.3 20.8 65.1 28.1 54zM112 48c.9 1.6 2.3 3.6 3.9 6l0 0c7.4 11.1 20.1 30.3 20.1 50c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-19.7 12.8-38.9 20.1-50c1.6-2.4 3-4.5 3.9-6zm60.1 6c1.6-2.4 3-4.5 3.9-6c.9 1.6 2.3 3.6 3.9 6l0 0c7.4 11.1 20.1 30.3 20.1 50c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-19.7 12.8-38.9 20.1-50zM240 48c.9 1.6 2.3 3.6 3.9 6l0 0c7.4 11.1 20.1 30.3 20.1 50c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-19.7 12.8-38.9 20.1-50c1.6-2.4 3-4.5 3.9-6zm156.1 6c1.6-2.4 3-4.5 3.9-6c.9 1.6 2.3 3.6 3.9 6c7.4 11.1 20.1 30.3 20.1 50c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-19.7 12.8-38.9 20.1-50zM528 48c.9 1.6 2.3 3.6 3.9 6c7.4 11.1 20.1 30.3 20.1 50c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-19.7 12.8-38.9 20.1-50c1.6-2.4 3-4.5 3.9-6zm-67.9 6c1.6-2.4 3-4.5 3.9-6c.9 1.6 2.3 3.6 3.9 6c7.4 11.1 20.1 30.3 20.1 50c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-19.7 12.8-38.9 20.1-50zM608 48c.9 1.6 2.3 3.6 3.9 6c7.4 11.1 20.1 30.3 20.1 50c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-19.7 12.8-38.9 20.1-50c1.6-2.4 3-4.5 3.9-6zM352 112v32V320H576V192 160h64v32V352v32H608 352v64H480h32v64H480 320 160 128V448h32H288V384H32 0V352 192 160H64v32V320H288V144 112h64zM128 160v16V288H96V176 160h32zm64 0v16V288H160V176 160h32zm64 0v16V288H224V176 160h32zm160 0v16V288H384V176 160h32zm64 0v16V288H448V176 160h32zm64 0v16V288H512V176 160h32z"],
    "chart-scatter-3d": [512, 512, [], "e0e8", "M64 32H0V96H64V32zM288 64V32H224V64 273L43.5 423.4 18.9 443.9l41 49.2 24.6-20.5L256 329.7 427.5 472.6l24.6 20.5 41-49.2-24.6-20.5L288 273V64zM0 224v64H64V224H0zm160-96H96v64h64V128zM352 32V96h64V32H352zm160 96H448v64h64V128zM352 224v64h64V224H352zM288 416H224v64h64V416z"],
    "display-chart-up": [576, 512, [], "e5e3", "M0 0H576V416H336l10.7 32H416h32v64H416 160 128V448h32 69.3L240 416H0V0zM64 64V352H512V64H64zM376 96h80 24v24 80 24H432V200 177.9L321 289l-17 17-17-17-63-63-87 87L103 279 207 175l17-17 17 17 63 63L398.1 144H376 352V96h24z"],
    "square-code": [448, 512, [], "e267", "M448 32H0V480H448V32zM177 209l-47 47 47 47 17 17L160 353.9l-17-17L79 273l-17-17 17-17 64-64 17-17L193.9 192l-17 17zM305 175l64 64 17 17-17 17-64 64-17 17L254.1 320l17-17 47-47-47-47-17-17L288 158.1l17 17z"],
    "feather": [512, 512, [129718], "f52d", "M113.9 448L73 489l-17 17L22.1 472l17-17L287.2 206.8l-22.3-22.3-11.3 11.3L64 385.4V224L242.7 45.3C271.7 16.3 311 0 352 0s80.3 16.3 109.3 45.3l5.5 5.5C495.7 79.7 512 119 512 160c0 26.3-6.7 51.9-19.2 74.6L368 272v16l80 0-52.6 52.6L304 368v16l48 0-64 64H113.9z"],
    "volume-low": [448, 512, [128264, "volume-down"], "f027", "M0 160V352H128L272 480h48V32H272L128 160H0zM409.6 332.8C432.9 315.3 448 287.4 448 256s-15.1-59.3-38.4-76.8l-28.8 38.4c11.7 8.8 19.2 22.7 19.2 38.4s-7.5 29.6-19.2 38.4l28.8 38.4z"],
    "xmark-to-slot": [576, 512, ["times-to-slot", "vote-nay"], "f771", "M96 32H480V384H96V32zM369 161l17-17L352 110.1l-17 17-47 47-47-47-17-17L190.1 144l17 17 47 47-47 47-17 17L224 305.9l17-17 47-47 47 47 17 17L385.9 272l-17-17-47-47 47-47zM0 288H64V416H512V288h64V480H0V288z"],
    "box-taped": [448, 512, ["box-alt"], "f49a", "M64 32L0 160H160L192 32H64zM288 160H448L384 32H256l32 128zM160 192H0V480H448V192H288v96H160V192z"],
    "comment-slash": [640, 512, [], "f4b3", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L513.7 376c38.8-36.5 62.3-84 62.3-136C576 125.1 461.4 32 320 32c-68.2 0-130.2 21.7-176 57L48.4 14.8zM64 240c0 49.6 21.3 95.1 56.9 130.8L80 480l150.4-45.1c27.9 8.5 58.1 13.1 89.6 13.1c37 0 72.3-6.4 104-17.9L82.9 161.3C70.7 185.6 64 212.2 64 240z"],
    "swords": [512, 512, [9876], "f71d", "M16 96L0 0 96 16 393.4 313.4l-80 80L16 96zM408 456l-72 24-32-32L448 304l32 32-24 72 56 56-48 48-56-56zM96 336l57.4-57.4 80 80L176 416l32 32-32 32-72-24L48 512 0 464l56-56L32 336l32-32 32 32zM496 96L358.6 233.4l-80-80L416 16 512 0 496 96z"],
    "cloud-sun-rain": [640, 512, [127782], "f743", "M104 104L121.3 0 208 60.7 294.7 0l13.2 79c-20.5 10.9-37.7 27.3-49.6 47.2c-14.6-9-31.8-14.1-50.2-14.1c-53 0-96 43-96 96c0 35.5 19.3 66.6 48 83.2v97.8L121.3 416 104 312 0 294.7 60.7 208 0 121.3 104 104zM294.5 415.9h.2l0 .1H304l-64 96H184l64-96h46.7l-.1-.1zm-49.4-260c-1.2 4.1-2.2 8.3-3 12.6c-37.9 14.6-67.2 46.6-77.8 86.4C151.8 243.1 144 226.5 144 208c0-35.3 28.7-64 64-64c13.8 0 26.7 4.4 37.1 11.9zM344 416h56l-64 96H280l64-96zm152 0l-64 96H376l64-96h56zm40 0h56l-64 96H472l64-96zm103.9-32.1l-80 0H288 192v-96c0-47.6 34.6-87 80-94.6l0-1.3c0-53 43-96 96-96c34.9 0 65.4 18.6 82.2 46.4c13-9.1 28.8-14.4 45.8-14.4c44.2 0 80 35.8 80 80c0 5.9-.6 11.7-1.9 17.2c37.4 6.7 65.8 39.4 65.8 78.7v80z"],
    "album": [448, 512, [128189], "f89f", "M0 32H448V480H0V32zM384 256A160 160 0 1 0 64 256a160 160 0 1 0 320 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-n": [512, 512, [], "e118", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm48-384h48v24V360v24H315.4l-7.2-10.3L208 228.8V360v24H160V360 152 128h36.6l7.2 10.3L304 283.2V152 128z"],
    "compress": [448, 512, [], "f066", "M160 64V32H96V64v64H32 0v64H32h96 32V160 64zM32 320H0v64H32 96v64 32h64V448 352 320H128 32zM352 64V32H288V64v96 32h32 96 32V128H416 352V64zM320 320H288v32 96 32h64V448 384h64 32V320H416 320z"],
    "wheat-awn": [512, 512, ["wheat-alt"], "e2cd", "M489 57l17-17L472 6.1 455 23 383 95l-17 17L400 145.9l17-17 72-72zM316.8 38.6L294.2 16 271.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-22.6-22.6-22.6 22.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8L90.5 219.6 67.9 242.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L25.4 441.4 2.7 464 48 509.3l22.6-22.6 52.9-52.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l22.6-22.6-22.6-22.6c-21.8-21.8-49.6-34.1-78.1-36.9l31.9-31.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0L396 321.5l-22.6-22.6c-21.8-21.8-49.6-34.1-78.1-36.9l31.9-31.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l22.6-22.6L475.2 197c-5.2-5.2-10.6-9.8-16.4-13.9L489 153l17-17L472 102.1l-17 17-43.4 43.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L393 57l17-17L376 6.1 359 23 329.1 52.9c-3.7-5-7.8-9.8-12.4-14.3z"],
    "ankh": [320, 512, [9765], "f644", "M96 128c0-35.3 28.7-64 64-64s64 28.7 64 64c0 41.6-20.7 76.6-46.6 104.1c-5.9 6.2-11.8 11.8-17.4 16.7c-5.6-4.9-11.5-10.5-17.4-16.7C116.7 204.6 96 169.6 96 128zM160 0C89.3 0 32 57.3 32 128c0 52.4 21.5 95.5 46.8 128H32 0v64H32h96V480v32h64V480 320h96 32V256H288 241.2c25.4-32.5 46.8-75.6 46.8-128C288 57.3 230.7 0 160 0z"],
    "hands-holding-child": [640, 512, [], "e4fa", "M320 0a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM290.5 96h59.1 8.8l6.7 5.7 50.5 42.7 18.3 15.5-31 36.7L384.5 181l-19.8-16.7L375.8 253l3 23.8-47.6 6-3-23.8-4.4-35h-7.6l-4.4 35-3 23.8-47.6-6 3-23.8 11.1-88.8L255.5 181l-18.3 15.5-31-36.7 18.3-15.5L275 101.7l6.7-5.7h8.8zM80 64v40 8 32 80 66.7l84.1 84.1L205.8 347l-36.4-36.4L146.7 288l-9.4-9.4L114.7 256 160 210.7l22.6 22.6 9.4 9.4 22.6 22.6 64 64 9.4 9.4V352v64 32 32 32H256 160 146.7l-9.4-9.4-128-128L0 365.3V352 224 160 128 104 64H80zm480 0h80v40 24 32 64V352v13.3l-9.4 9.4-128 128-9.4 9.4H480 384 352V480 448 416 352 338.7l9.4-9.4 64-64L448 242.7l9.4-9.4L480 210.7 525.3 256l-22.6 22.6-9.4 9.4-22.6 22.6L434.2 347l41.7 27.8L560 290.7V224 144 112v-8V64z"],
    "asterisk": [384, 512, [10033, 61545], "2a", "M224 32V64 199.5l95.5-57.3L347 125.7l32.9 54.9L352.5 197l-98.3 59 98.3 59 27.4 16.5L347 386.3l-27.4-16.5L224 312.5V448v32H160V448 312.5L64.5 369.8 37 386.3 4.1 331.4 31.5 315l98.3-59L31.5 197 4.1 180.6 37 125.7l27.4 16.5L160 199.5V64 32h64z"],
    "key-skeleton-left-right": [640, 512, [], "e3b4", "M448 128a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm-60 32c14.2 55.2 64.3 96 124 96c70.7 0 128-57.3 128-128S582.7 0 512 0C452.4 0 402.2 40.8 388 96L192 96H160l0 32 0 64 0 32 64 0 0-32 0-32h32v32 32h64V192 160h68zM192 384A64 64 0 1 1 64 384a64 64 0 1 1 128 0zm60-32c-14.2-55.2-64.3-96-124-96C57.3 256 0 313.3 0 384s57.3 128 128 128c59.6 0 109.8-40.8 124-96l196 0h32l0-32 0-64 0-32-64 0 0 32 0 32H384V320 288H320v32 32l-68 0z"],
    "comment-lines": [512, 512, [], "f4b0", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM152 176H128v48h24H360h24V176H360 152zm0 96H128v48h24H264h24V272H264 152z"],
    "luchador-mask": [448, 512, ["luchador", "mask-luchador"], "f455", "M224 0C100.3 0 0 100.3 0 224V512H448V224C448 100.3 347.7 0 224 0zM128 384c0 17.7 14.3 32 32 32H288c17.7 0 32-14.3 32-32s-14.3-32-32-32H160c-17.7 0-32 14.3-32 32zm224 0c0 35.3-28.7 64-64 64H160c-35.3 0-64-28.7-64-64c0-29.8 20.4-54.9 48-62V288c-44.2 0-80-35.8-80-80V192 160H96h48c44.2 0 80 35.8 80 80c0-44.2 35.8-80 80-80h48 32v32 16c0 44.2-35.8 80-80 80v34c27.6 7.1 48 32.2 48 62zM176 304v16h96V304l-16-16-32-32-32 32-16 16zm82.7-80c-1.8 5-2.7 10.4-2.7 16v16h32 16c20.9 0 38.7-13.4 45.3-32c1.8-5 2.7-10.4 2.7-16V192H320 304c-20.9 0-38.7 13.4-45.3 32zM144 192H128 96v16c0 5.6 1 11 2.7 16c6.6 18.6 24.4 32 45.3 32h16 32V240c0-5.6-1-11-2.7-16c-6.6-18.6-24.4-32-45.3-32z"],
    "square-check": [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M448 32H0V480H448V32zM337 209L209 337l-17 17-17-17-64-64-17-17L128 222.1l17 17 47 47L303 175l17-17L353.9 192l-17 17z"],
    "shredder": [512, 512, [], "f68a", "M64 0H96 368h13.3l9.4 9.4 48 48 9.4 9.4V80 192h64V384H0V192H64V32 0zM384 93.3L354.7 64H128V192H384V93.3zM456 248H408v48h48V248zM40 416H88v72 24H40V488 416zm96 0h48v72 24H136V488 416zm96 0h48v72 24H232V488 416zm96 0h48v72 24H328V488 416zm96 0h48v72 24H424V488 416z"],
    "book-open-cover": [640, 512, ["book-open-alt"], "e0c0", "M304 32V408L96 368V0L304 32zM64 400l256 51.2L576 400V28.8L640 16V448L320 512 0 448V16L64 28.8V400zm272 8V32L544 0V368L336 408z"],
    "sandwich": [512, 512, [129386], "f81f", "M0 64H512V176H0V64zM320 384l96-48h32 64V448H0V336H192h32l96 48zM144.2 209.1L256 238.9l111.8-29.8 8-2.1 8 2 96 24 31 7.8-15.5 62.1-31-7.8-88-22-112 29.9-8.2 2.2-8.2-2.2L135.7 273l-88 22-31 7.8L1.2 240.7l31-7.8 96-24 8-2 8 2.1z"],
    "peseta-sign": [384, 512, [], "e221", "M64 32H32V64v96H0v64H32v96V480H96V352h96c77.4 0 142-55 156.8-128H384V160H348.8C334 87 269.4 32 192 32H64zM282.5 160H96V96h96c41.8 0 77.4 26.7 90.5 64zM96 224H282.5c-13.2 37.3-48.7 64-90.5 64H96V224z"],
    "square-parking-slash": [640, 512, ["parking-slash"], "f617", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L544 399.6V32H96V51.8l-47.6-37zM224 151.1V128h32 80c53 0 96 43 96 96c0 26.2-10.5 49.9-27.5 67.3l-51.6-40.1C362 245.5 368 235.5 368 224c0-17.7-14.3-32-32-32H288v8.8l-64-49.7zM224 288V272.5L96 171.6V480H487.4L288 322.9V352v32H224V352 288z"],
    "train-tunnel": [512, 512, [], "e454", "M256 0C114.6 0 0 114.6 0 256V512H105.4l64-64H112V128H400V448H342.6l64 64H512V256C512 114.6 397.4 0 256 0zM361.4 512l-64-64H214.6l-64 64H361.4zM288 384a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64-192H160V320H352V192z"],
    "heading": [448, 512, ["header"], "f1dc", "M0 32H32 48h64 16 32V96H128 112V208H336V96H320 288V32h32 16 64 16 32V96H416 400V240 416h16 32v64H416 400 336 320 288V416h32 16V272H112V416h16 32v64H128 112 48 32 0V416H32 48V240 96H32 0V32z"],
    "ghost": [384, 512, [128123], "f6e2", "M48 448L0 480V192C0 86 86 0 192 0S384 86 384 192V480l-48-32-72 64-72-64-72 64L48 448zM160 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "face-anguished": [512, 512, [], "e369", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM256 320c44.2 0 80 35.8 80 80v16H176V400c0-44.2 35.8-80 80-80zM192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8l-11.7 10.9L89.4 143.2l11.7-10.9c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1h16v32H192zm141 .9c-4.3-.6-8.6-.9-13-.9H304V96h16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2l11.7 10.9-21.8 23.4-11.7-10.9c-15.5-14.5-34.8-24-56.1-26.8z"],
    "hockey-sticks": [640, 512, [], "f454", "M96 352V480v32h32 32 64 19.8l8.8-17.7 224-448L419.4 17.7 252.2 352H96zM0 352V512H64V352H0zm337.1 41.7l50.3 100.6 8.8 17.7H416h64v0h64V480 352H387.8l-14.9-29.9-35.8 71.6zM267.2 253.9l35.8-71.6L220.6 17.7 163.4 46.3 267.2 253.9zM576 352V512h64V352H576z"],
    "abacus": [576, 512, [129518], "f640", "M512 96V208H448V176h8 24V128H456h-8V96h64zm-96 32h-8H384v48h24 8v32H288V176h8 24V128H296h-8V96H416v32zm-160 0h-8H224v48h24 8v32H160V176h8 24V128H168h-8V96h96v32zm-128 0h-8H96v48h24 8v32H64V96h64v32zM64 416V240h64v24h-8H96v48h24 8v24h-8H96v48h24 8v32H64zm96-32h8 24V336H168h-8V312h8 24V264H168h-8V240h96v24h-8H224v48h24 8v24h-8H224v48h24 8v32H160V384zm128-72h8 24V264H296h-8V240H416v96h-8H384v48h24 8v32H288V384h8 24V336H296h-8V312zm160 72h8 24V336H456h-8V240h64V416H448V384zM64 32H0V96 416v64H64 512h64V416 96 32H512 64z"],
    "film-simple": [512, 512, ["film-alt"], "f3a0", "M384 32H128V96H64V32H0V480H64V416h64v64H384V416h64v64h64V32H448V96H384V32zM64 160h64v64H64V160zm384 0v64H384V160h64zM64 288h64v64H64V288zm384 0v64H384V288h64z"],
    "list": [512, 512, ["list-squares"], "f03a", "M112 48H16v96h96V48zm80 16H160v64h32H480h32V64H480 192zm0 160H160v64h32H480h32V224H480 192zm0 160H160v64h32H480h32V384H480 192zM16 208v96h96V208H16zm96 160H16v96h96V368z"],
    "tree-palm": [576, 512, [127796], "f82b", "M96 80l37.2 61.9c-4 3.5-8 7.2-12 11.2C41.9 232.3 64.6 322.8 98.5 356.8L248.4 206.9c4 10.8 7.8 26.2 9.7 47.2c4.2 46.5-1.6 116.8-32.7 216.4l-13 41.5H256h64 28.2l3.5-28c12.4-99-2.3-207.2-31.7-292H451.2L480 144l28.8 48H576c0-48-48-128-160-128c-43.7 0-77.6 12.2-102.8 29.8C296.5 49.4 248 0 160 0C48 0 0 80 0 128H67.2L96 80z"],
    "square-phone-flip": [448, 512, ["phone-square-alt"], "f87b", "M0 32H448V480H0V32zm280 96l-40 72 41.9 33.5c-18.1 34.2-46.2 62.3-80.4 80.4L168 272 96 312l16 72h16c123.7 0 224-100.3 224-224l0-16-72-16z"],
    "cart-plus": [576, 512, [], "f217", "M24 0H0V48H24 76.1l60.3 316.5 3.7 19.5H160 488h24V336H488 179.9l-9.1-48H496L576 32H122l-2.4-12.5L115.9 0H96 24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM316 180H256V140h60V80h40v60h60v40H356v60H316V180z"],
    "gamepad": [640, 512, [], "f11b", "M640 64H0V448H640V64zM496 168a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM392 304a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM168 176h48v56h56v48H216v56H168V280H112V232h56V176z"],
    "border-center-v": [448, 512, [], "f89d", "M448 480l0-64-64 0 0 64 64 0zm0-96l0-64-64 0 0 64 64 0zM64 384l0-64L0 320l0 64 64 0zM384 192l64 0 0-64-64 0 0 64zM64 192l0-64L0 128l0 64 64 0zm320 96l64 0 0-64-64 0 0 64zM64 288l0-64L0 224l0 64 64 0zM384 96l64 0 0-64-64 0 0 64zM0 96l64 0 0-64L0 32 0 96zM64 480l0-64L0 416l0 64 64 0zM288 288l64 0 0-64-64 0 0 64zM352 96l0-64-64 0 0 64 64 0zM288 480l64 0 0-64-64 0 0 64zM160 96l0-64L96 32l0 64 64 0zM96 480l64 0 0-64-64 0 0 64zm64-192l0-64-64 0 0 64 64 0zm32 160l0 32 64 0 0-32 0-384 0-32-64 0 0 32 0 384z"],
    "circle-dot": [512, 512, [128280, "dot-circle"], "f192", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-352a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "clipboard-medical": [384, 512, [], "e133", "M192 0c-41.8 0-77.4 26.7-90.5 64H0V512H384V64H282.5C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM160 288V224h64v64h64v64H224v64H160V352H96V288h64z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM123.3 132.7L112 121.4 89.4 144l11.3 11.3L137.4 192l-36.7 36.7L89.4 240 112 262.6l11.3-11.3L160 214.6l36.7 36.7L208 262.6 230.6 240l-11.3-11.3L182.6 192l36.7-36.7L230.6 144 208 121.4l-11.3 11.3L160 169.4l-36.7-36.7zm192 0L304 121.4 281.4 144l11.3 11.3L329.4 192l-36.7 36.7L281.4 240 304 262.6l11.3-11.3L352 214.6l36.7 36.7L400 262.6 422.6 240l-11.3-11.3L374.6 192l36.7-36.7L422.6 144 400 121.4l-11.3 11.3L352 169.4l-36.7-36.7z"],
    "egg": [384, 512, [129370], "f7fb", "M192 496C86 496 0 394 0 288C0 176 64 16 192 16s192 160 192 272c0 106-86 208-192 208zM96 288c0-24.5 5-54.4 15.1-82.8c10.1-28.5 25-54.1 43.7-71.2l-21.6-23.6c-23.9 21.8-41.1 52.7-52.3 84.2C69.7 226.1 64 259.7 64 288v16H96V288z"],
    "up-to-line": [384, 512, ["arrow-alt-to-top"], "f34d", "M32 288L192 128 352 288l0 32-96 0 0 160-128 0 0-160-96 0 0-32zM352 96L32 96 0 96 0 32l32 0 320 0 32 0 0 64-32 0z"],
    "house-medical-circle-xmark": [640, 512, [], "e513", "M320 368.7c.2 59.2 29.7 111.6 74.8 143.3H64.1V287.6H0V240L288.4 0 520.5 193.7c-8-1.1-16.2-1.7-24.5-1.7c-54.7 0-103.5 24.9-135.8 64H320V192H256v64H192v64h64v64h64V368.7zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3L566.6 320 544 297.4l-11.3 11.3L496 345.4l-36.7-36.7L448 297.4 425.4 320l11.3 11.3L473.4 368l-36.7 36.7L425.4 416 448 438.6l11.3-11.3L496 390.6l36.7 36.7L544 438.6 566.6 416l-11.3-11.3L518.6 368l36.7-36.7z"],
    "watch-fitness": [384, 512, [], "f63e", "M64 0H320V48H64V0zm0 464H320v48H64V464zM0 80H384V432H0V80zm139.2 80C106.5 160 80 186.5 80 219.2c0 16.1 6.6 31.5 18.2 42.7l82.8 79.6L192 352.1l11.1-10.7 82.8-79.6c11.6-11.2 18.2-26.6 18.2-42.7c0-32.7-26.5-59.2-59.2-59.2h-2.4c-15.9 0-31.2 6.2-42.7 17.2l-7.7 7.4-7.7-7.4c-11.5-11-26.8-17.2-42.7-17.2h-2.4z"],
    "clock-nine-thirty": [512, 512, [], "e34d", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V256 232H256 152 128v48h24 80V392v24h48V392z"],
    "campground": [576, 512, [9978], "f6bb", "M241 2l20 25 27 33.8L315 27 335 2l50 40L365 67l-36 45L569 412l7 8.8V432v48 32H544 32 0V480 432 420.8L7 412 247 112 211 67 191 42 241 2zm47 289.7L168.5 448H407.5L288 291.7z"],
    "folder-plus": [512, 512, [], "f65e", "M512 480H0V32H224l48 64H512V480zM232 400h48V376 312h64 24V264H344 280V200 176H232v24 64H168 144v48h24 64v64 24z"],
    "jug": [448, 512, [], "f8c6", "M160 0H288h32V64H288 160 128V0h32zM359 151l-3.7 3.7L387 190.9 393 185c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0zm67.9 67.9L416 229.8V512H32V224L144 96H304l19.7 22.5 1.4-1.4c28.1-28.1 73.7-28.1 101.8 0s28.1 73.7 0 101.8zM352 288H96V416H352V288z"],
    "futbol": [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", "M406.2 136.4l-28.5 80.1 70.1 48c-1.6 35.9-13 69.2-31.6 97.4l-85-2.3-24 81.5c-16.3 4.5-33.5 6.9-51.2 6.9s-34.9-2.4-51.2-6.9l-24-81.5-85 2.3c-18.6-28.1-30.1-61.5-31.6-97.4l70.1-48-28.5-80.1c21.5-26.9 50-47.9 82.8-60.2L256 128l67.4-51.8c32.8 12.3 61.3 33.3 82.8 60.2zM256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-336l-76.1 55.3L209 320.7h94l29.1-89.4L256 176z"],
    "snow-blowing": [640, 512, [], "f761", "M512 48h32c53 0 96 43 96 96s-43 96-96 96H416 384V176h32H544c17.7 0 32-14.3 32-32s-14.3-32-32-32H512 480V48h32zM200 64V88v25.4l12.7-12.7L224 89.4 246.6 112l-11.3 11.3L200 158.6v55.8l48.3-27.9 12.9-48.2 4.1-15.5 30.9 8.3-4.1 15.5-4.6 17.3 15-8.7 20.8-12 24 41.6-20.8 12-15 8.7 17.3 4.6 15.5 4.1L336 245.2 320.6 241l-48.2-12.9L224 256l48.3 27.9L320.6 271l15.5-4.1 8.3 30.9-15.5 4.1-17.3 4.6 15 8.7 20.8 12-24 41.6-20.8-12-15-8.7 4.6 17.3 4.1 15.5-30.9 8.3-4.1-15.5-12.9-48.2L200 297.6v55.8l35.3 35.3L246.6 400 224 422.6l-11.3-11.3L200 398.6V424v24H152V424 398.6l-12.7 12.7L128 422.6 105.4 400l11.3-11.3L152 353.4V297.6l-48.3 27.9L90.7 373.7l-4.1 15.5-30.9-8.3 4.1-15.5 4.6-17.3-15 8.7-20.8 12-24-41.6 20.8-12 15-8.7-17.3-4.6L7.7 297.7 16 266.8 31.4 271l48.2 12.9L128 256 79.7 228.1 31.4 241 16 245.2 7.7 214.3l15.5-4.1 17.3-4.6-15-8.7-20.8-12 24-41.6 20.8 12 15 8.7-4.6-17.3-4.1-15.5 30.9-8.3 4.1 15.5 12.9 48.2L152 214.4V158.6l-35.3-35.3L105.4 112 128 89.4l11.3 11.3L152 113.4V88 64h48zM480 464V400h32 24c17.7 0 32-14.3 32-32s-14.3-32-32-32H416 384V272h32H536c53 0 96 43 96 96s-43 96-96 96H512 480z"],
    "paintbrush": [576, 512, [128396, "paint-brush"], "f1fc", "M224 192L512 0l64 64L384 352l-75.3 30.1L193.9 267.3 224 192zm-54.4 96.2L287.8 406.4C284.5 465.3 235.7 512 176 512H0V448H64V400c0-59.7 46.7-108.5 105.6-111.8z"],
    "lock": [448, 512, [128274], "f023", "M144 144v48H304V144c0-44.2-35.8-80-80-80s-80 35.8-80 80zM80 192V144C80 64.5 144.5 0 224 0s144 64.5 144 144v48h80V512H0V192H80z"],
    "arrow-down-from-line": [384, 512, [8615, "arrow-from-top"], "f345", "M214.6 457.4L192 480l-22.6-22.6-128-128L18.7 306.7 64 261.5l22.6 22.6L160 357.5V194.7v-32h64v32V357.5l73.4-73.4L320 261.5l45.3 45.3-22.6 22.6-128 128zM32 98.7H0v-64H32 352h32v64H352 32z"],
    "gas-pump": [512, 512, [9981], "f52f", "M32 0H320V256h8c48.6 0 88 39.4 88 88v32c0 13.3 10.7 24 24 24s24-10.7 24-24V222c-27.6-7.1-48-32.2-48-62V96L368 48l32-32L512 128v40 24 32V376c0 39.8-32.2 72-72 72s-72-32.2-72-72V344c0-22.1-17.9-40-40-40h-8V416H32V0zM96 64V192H256V64H96zM352 448v64H0V448H352z"],
    "signal-bars-slash": [640, 512, ["signal-alt-slash"], "f694", "M608 0H512V374.7L448 325V128H352V250.5L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7-12.9-10V0zM288 322.9L203.1 256H192V512h96V322.9zM448 449l-96-75.6V512h96V449zM128 384H32V512h96V384z"],
    "monkey": [576, 512, [128018], "f6fb", "M160 416c0-80.6 49.6-149.6 120-178v18 32h32H447.9L566.1 400.9l9.9 9.5V424v56 32H512V480 437.7l-96-91.6V448h32 32v64H448 416 160C71.6 512 0 440.4 0 352V32 0H32 192h32V32 160v32H192 128 96V128h32 32V64H64V352c0 53 43 96 96 96V416zm96-288c0-35.3 28.6-64 64-64c15.7-37.6 52.8-64 96-64s80.4 26.4 96 64c35.3 0 64 28.7 64 64c0 32.6-24.4 59.6-56 63.5V256H416 344 312V228.2 191.5c-31.6-3.9-56-30.9-56-63.5zM384 64c-26.5 0-48 21.5-48 48c0 23.8 17.3 43.5 40 47.3V208h80V159.3c22.7-3.8 40-23.6 40-47.3c0-26.5-21.5-48-48-48H384zm0 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "rectangle-pro": [640, 512, ["pro"], "e235", "M640 32H0V480H640V32zM80 160h24 56c35.3 0 64 28.7 64 64s-28.7 64-64 64H128v40 24H80V328 264 184 160zm48 80h32c8.8 0 16-7.2 16-16s-7.2-16-16-16H128v32zm272 8c0-48.6 39.4-88 88-88s88 39.4 88 88v16c0 48.6-39.4 88-88 88s-88-39.4-88-88V248zm88-40c-22.1 0-40 17.9-40 40v16c0 22.1 17.9 40 40 40s40-17.9 40-40V248c0-22.1-17.9-40-40-40zM264 160h56c35.3 0 64 28.7 64 64c0 21.9-11 41.2-27.7 52.7l24.1 38.5 23 36.7H346.7l-7-11.3-33-52.7H288v40 24H240V328 264 184 160h24zm56 80c8.8 0 16-7.2 16-16s-7.2-16-16-16H288v32h32z"],
    "house-night": [640, 512, [], "e010", "M88 88c0-38.1 24.2-70.5 58-82.7C135.3 1.8 123.8 0 112 0C50.1 0 0 50.1 0 112s50.1 112 112 112c40.6 0 76.1-21.6 95.8-53.9c-9.9 3.8-20.6 5.9-31.8 5.9c-48.6 0-88-39.4-88-88zM256 0L234.7 42.7 192 64l42.7 21.3L256 128l21.3-42.7L320 64 277.3 42.7 256 0zM400 96L160 304v48h64V512H576V352h64V304L400 96zM352 288h96v96H352V288zM74.7 362.7L32 384l42.7 21.3L96 448l21.3-42.7L160 384l-42.7-21.3L96 320 74.7 362.7z"],
    "hot-tub-person": [512, 512, ["hot-tub"], "f593", "M272 24c0 26.7 14.3 46.4 35 73.4l1.4 1.9C327.5 124 352 155.8 352 200v24H304V200c0-26.7-14.3-46.4-35-73.4l-1.4-1.9C248.5 100 224 68.2 224 24V0h48V24zm112 0c0 26.7 14.3 46.4 35 73.4l1.4 1.9C439.5 124 464 155.8 464 200v24H416V200c0-26.7-14.3-46.4-35-73.4l-1.4-1.9C360.5 100 336 68.2 336 24V0h48V24zM0 512V336 256 160H128l128 96H512V512H0zM128 320H96v16 96 16h32V432 336 320zm96 0H192v16 96 16h32V432 336 320zm96 0H288v16 96 16h32V432 336 320zm96 0H384v16 96 16h32V432 336 320zM0 64a64 64 0 1 1 128 0A64 64 0 1 1 0 64z"],
    "blanket": [448, 512, [], "f498", "M0 32H32 416h32V64 224v32 48 48 32H416 128 96V320h32H384V304 288H64v64 64H416h32v64H416 32 0V448 352 256 224 64 32z"],
    "map-location": [576, 512, ["map-marked"], "f59f", "M288 320s120-130 120-200C408 53.7 354.3 0 288 0S168 53.7 168 120c0 70 120 200 120 200zM133 138.8L0 192V512l160-64V200.9c-11.9-21.4-21.5-42.6-27-62.1zM288 373.3s-51.5-55.7-96-121V448l192 64V252.3c-44.6 65.3-96 121-96 121zM422 189.6c-1.9 3.7-4 7.5-6 11.3V512l160-64V128L422 189.6z"],
    "house-flood-water": [576, 512, [], "e50e", "M80 144L288 0 496 144v48H447.4l.3 71.2c-7.9 5.5-14.9 9.8-22.9 13.5C411.6 282.7 397 287 384 287s-27.6-4.3-40.7-10.3c-12-5.5-21.7-12.5-35.5-22.5l0 0L288 240l-18.6 13.4-1.1 .8 0 0 0 0 0 0c-13.9 10-23.6 17-35.5 22.5C219.6 282.7 205 287 192 287s-27.6-4.3-40.7-10.3c-8.1-3.7-15.2-8.1-23.3-13.7V192H80l0-48zM288 373.4c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.8c-4.5 2.4-9.7 5.1-15.6 7.8C60.6 390.1 31.9 400 0 400V336c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l2.1-1.5 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l2.1-1.5 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l2.1-1.5 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7zM272.4 493.1c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.8c-4.5 2.4-9.7 5.1-15.6 7.8C60.6 502.1 31.9 512 0 512V448c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7z"],
    "comments-question-check": [640, 512, [], "e14f", "M416 176c0 97.2-93.1 176-208 176c-36.2 0-70.3-7.8-99.9-21.6L0 352l37.6-75.1C13.9 248.3 0 213.5 0 176C0 78.8 93.1 0 208 0S416 78.8 416 176zm32 0c0-5.2-.2-10.4-.6-15.5C555.1 167.1 640 243.2 640 336c0 37.5-13.9 72.3-37.6 100.9L640 512 531.9 490.4C502.3 504.2 468.2 512 432 512c-95.6 0-176.2-54.6-200.5-129C348.9 372.9 448 288.3 448 176zM181.3 77.3c-25.8 0-46.7 20.9-46.7 46.7v5.5l40 0V124c0-3.7 3-6.7 6.7-6.7h47.4c7 0 12.6 5.7 12.6 12.6c0 4.5-2.4 8.7-6.3 10.9L198 162.1l-10 5.8v11.6 17.9 20h40v-20V191l26.9-15.4c16.3-9.4 26.4-26.8 26.4-45.6c0-29.1-23.6-52.6-52.6-52.6H181.3zM228 250.7H188v40h40v-40zm338.1 75.5L580.3 312 552 283.7l-14.1 14.1L472 363.7l-25.9-25.9L432 323.7 403.7 352l14.1 14.1 40 40L472 420.3l14.1-14.1 80-80z"],
    "tree": [448, 512, [127794], "f1bb", "M224 0L56 176v32h48L24 288v32H80L0 416v32H192v32 32h64V480 448H448V416l-80-96h56V288l-80-80h48V176L224 0z"],
    "arrows-cross": [448, 512, [], "e0a2", "M288 32H256V96h32 50.7L25.4 409.4 2.7 432 48 477.3l22.6-22.6L384 141.3V192v32h64V192 64 32H416 288zM70.6 57.4L48 34.7 2.7 80l22.6 22.6L156.1 233.4l45.3-45.3L70.6 57.4zM338.7 416H288 256v64h32H416h32V448 320 288H384v32 50.7l-92.1-92.1-45.3 45.3L338.7 416z"],
    "backpack": [448, 512, [127890], "f5d4", "M136 0h24H288h24V24 96h8c70.7 0 128 57.3 128 128V512H384V400 304 288H368 80 64v16 96V512H0V224C0 153.3 57.3 96 128 96h8V24 0zM96 512V416H352v96H96zM264 48H184V96h80V48zm40 128H144 128v32h16H304h16V176H304zm48 208H96V320H352v64z"],
    "square-small": [320, 512, [], "e27e", "M0 96H320V416H0V96z"],
    "folder-arrow-up": [512, 512, ["folder-upload"], "e054", "M512 96V480H0V32H224l48 64H512zM280 376V273.9l31 31 17 17L361.9 288l-17-17-72-72-17-17-17 17-72 72-17 17L184 321.9l17-17 31-31V376v24h48V376z"],
    "bridge-lock": [640, 512, [], "e4cc", "M32 32H64 576h32V96H576 536v64h-8c-61.9 0-112 50.1-112 112v16H384l0 24.4c-17-15.2-39.4-24.4-64-24.4c-53 0-96 43-96 96v96H128V384c0-53-43-96-96-96V160h72V96H64 32V32zM408 96v64h80V96H408zm-48 64V96H280v64h80zM152 96v64h80V96H152zM528 240c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H416V320h32V272z"],
    "crosshairs-simple": [512, 512, [], "e59f", "M445.3 224H384 352v64h32 61.3C431.9 368.4 368.4 431.9 288 445.3V384 352H224v32 61.3C143.6 431.9 80.1 368.4 66.7 288H128h32V224H128 66.7C80.1 143.6 143.6 80.1 224 66.7l0 7.3 0 54.1 0 32 64 0 0-32 0-54.1 0-7.3C368.4 80.1 431.9 143.6 445.3 224zM256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512z"],
    "sack-dollar": [512, 512, [128176], "f81d", "M320 96H192L128 0H384L320 96zM192 128H320c3.8 2.5 8.1 5.3 13 8.4C389.7 172.7 512 250.9 512 416v96H416 96 0V416C0 250.9 122.3 172.7 179 136.4l0 0 0 0c4.8-3.1 9.2-5.9 13-8.4zm84 96V204H236v20 6c-5.6 1.2-11 2.9-16 5.1c-15 6.8-27.9 19.4-31.1 37.7c-1.8 10.2-.8 20 3.4 29c4.2 8.8 10.7 15 17.3 19.5c11.6 7.9 26.9 12.5 38.6 16l2.2 .7c13.9 4.2 23.4 7.4 29.3 11.7c2.5 1.8 3.4 3.2 3.7 4.1c.3 .8 .9 2.6 .2 6.7c-.6 3.5-2.5 6.4-8 8.8c-6.1 2.6-16 3.9-28.8 1.9c-6-1-16.7-4.6-26.2-7.9c-2.2-.8-4.4-1.5-6.4-2.2l-19-6.3-12.6 38 19 6.3c1.2 .4 2.7 .9 4.4 1.5l0 0c7.9 2.7 20.3 7 29.9 9.1V416v20h40V416v-5.5c5.4-1 10.6-2.5 15.4-4.6c15.7-6.7 28.4-19.7 31.6-38.7c1.8-10.4 1-20.3-3-29.4c-3.9-9-10.2-15.6-16.9-20.5c-12.2-8.8-28.3-13.7-40.4-17.4l0 0 0 0-.8-.2c-14.2-4.3-23.8-7.3-29.9-11.4c-2.6-1.8-3.4-3-3.6-3.5c-.2-.3-.7-1.6-.1-5c.3-1.9 1.9-5.2 8.2-8.1c6.4-2.9 16.4-4.5 28.6-2.6c4.3 .7 17.9 3.3 21.7 4.3l19.3 5.1 10.3-38.7-19.3-5.1c-4.4-1.2-14.5-3.2-21.1-4.4V224z"],
    "pen-to-square": [512, 512, ["edit"], "f044", "M144 272L128 384l112-16L436.7 171.3l-96-96L144 272zM512 96L416 0 363.3 52.7l96 96L512 96zM32 64H0V96 480v32H32 416h32V480 320 288H384v32V448H64V128H192h32V64H192 32z"],
    "square-sliders": [448, 512, ["sliders-h-square"], "f3f0", "M448 480l0-448L0 32 0 480l448 0zM384 304l0 64-32 0-32 0 0 16 0 32-64 0 0-32 0-16L96 368l-32 0 0-64 32 0 160 0 0-16 0-32 64 0 0 32 0 16 32 0 32 0zM352 144l32 0 0 64-32 0-160 0 0 16 0 32-64 0 0-32 0-16-32 0-32 0 0-64 32 0 32 0 0-16 0-32 64 0 0 32 0 16 160 0z"],
    "car-side": [640, 512, [128663], "f5e4", "M106.3 64H128 384h15.4L409 76 527.4 224H640V432H574.7c-7.6 45.4-47.1 80-94.7 80s-87.1-34.6-94.7-80H254.7c-7.6 45.4-47.1 80-94.7 80s-87.1-34.6-94.7-80H0V224H42.3l56-139.9 8-20.1zM434.7 432a48 48 0 1 0 90.5-32 48 48 0 1 0 -90.5 32zM208 416a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM111.3 224H224V128H149.7l-38.4 96zM272 224H445.4l-76.8-96H272v96z"],
    "message-middle-top": [512, 512, ["comment-middle-top-alt"], "e1e2", "M338.3 96H512V512H0V96H173.7L256 0l82.3 96z"],
    "lightbulb-on": [640, 512, [], "f672", "M449.2 297.8c-19.8 27.1-39.7 54.4-49.2 86.2H240c-9.6-31.9-29.5-59.1-49.2-86.2l0 0 0 0c-5.2-7.1-10.4-14.2-15.4-21.4C155.6 247.9 144 213.3 144 176C144 78.8 222.8 0 320 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4l0 0 0 0zM240 512V416H400v96H240zM320 96V64c-61.9 0-112 50.1-112 112h32c0-44.2 35.8-80 80-80zM87.3 16l6 4 24 16 20 13.3L110.7 89.3 90.7 76l-24-16-6-4-20-13.3L67.3 2.7 87.3 16zM579.3 56l-6 4-24 16-20 13.3L502.7 49.3l20-13.3 24-16 6-4 20-13.3 26.6 39.9L579.3 56zM24 160H72 96v48H72 24 0V160H24zm544 0h48 24v48H616 568 544V160h24zM117.3 332l-24 16-6 4-20 13.3L40.7 325.3l20-13.3 6-4 24-16 20-13.3 26.6 39.9-20 13.3zm432-39.9l24 16 6 4 20 13.3-26.6 39.9-20-13.3-6-4-24-16-20-13.3 26.6-39.9 20 13.3z"],
    "knife": [512, 512, ["utensil-knife"], "f2e4", "M320 146.7L466.7 0s45.3 40 45.3 104c0 73.2-68 140.8-164.3 236.4c-9 8.9-18.3 18.1-27.7 27.6l-65.4-65.4 0 0-184 184L48 509.3 2.7 464l22.6-22.6 272-272L320 146.7l0 0z"],
    "share-nodes": [448, 512, ["share-alt"], "f1e0", "M352 224c53 0 96-43 96-96s-43-96-96-96s-96 43-96 96c0 4 .2 8 .7 11.9l-94.1 47C145.4 170.2 121.9 160 96 160c-53 0-96 43-96 96s43 96 96 96c25.9 0 49.4-10.2 66.6-26.9l94.1 47c-.5 3.9-.7 7.8-.7 11.9c0 53 43 96 96 96s96-43 96-96s-43-96-96-96c-25.9 0-49.4 10.2-66.6 26.9l-94.1-47c.5-3.9 .7-7.8 .7-11.9s-.2-8-.7-11.9l94.1-47C302.6 213.8 326.1 224 352 224z"],
    "display-chart-up-circle-dollar": [640, 512, [], "e5e6", "M0 0H576V211.2c-19.5-10-41.1-16.4-64-18.5V64H64V352H320.7c-.5 5.3-.7 10.6-.7 16c0 59.5 29.5 112.1 74.8 144H160 128V448h32 69.3L240 416H0V0zM480 120v72.7c-16.8 1.5-32.9 5.4-48 11.3v-4V177.9L321 289l-17 17-17-17-63-63-87 87L103 279 207 175l17-17 17 17 63 63L398.1 144H376 352V96h24 80 24v24zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm120.8-32.6c.6-.9 1.8-2.1 4.2-3.4c5.1-2.7 12.5-4.1 18.7-4c8.2 .1 17.1 1.8 26.4 4.1l15.5 3.9 7.7-31.1L529.9 301c-5.6-1.4-11.6-2.7-17.9-3.7V288 272H480v16 9.5c-6.1 1.2-12.3 3.2-18 6.3c-11.8 6.3-23 18.4-21.8 37.2c1 16 11.7 25.3 21.6 30.7c8.8 4.7 19.7 7.8 28.6 10.3l1.8 .5c10.3 2.9 17.9 5.2 23.2 8.3c4.5 2.7 4.7 4.2 4.7 5.6c.1 2.4-.5 3.7-1 4.5c-.6 1-1.8 2.2-4 3.3c-4.7 2.5-11.8 3.8-18.5 3.6c-9.5-.3-18.5-3.1-29.9-6.8c-1.9-.6-3.8-1.2-5.8-1.8l-15.3-4.8L436 425.2l15.3 4.8c1.6 .5 3.3 1 5 1.6l0 0 0 0c7 2.3 15.1 4.8 23.7 6.6v11.4 16h32v-16V438.7c6.2-1.1 12.5-3.1 18.3-6.2c12.1-6.5 22.3-18.7 21.7-36.9c-.5-16.2-10.3-26.3-20.5-32.3c-9.4-5.6-21.2-8.9-30.5-11.5l-.2 0c-10.4-2.9-18.3-5.2-23.9-8.2c-4.8-2.6-4.8-4-4.8-4.5l0-.1c-.1-1.9 .3-2.9 .8-3.6z"],
    "wave-sine": [640, 512, [8767], "f899", "M215.9 106.3c-10-6.6-22.4-10.7-39.3-10.3c-34.9 .7-62.8 27.5-84.3 64.8c-10.2 17.7-17.6 35.6-22.5 49.3c-2.4 6.8-4.2 12.4-5.3 16.2c-.6 1.9-1 3.4-1.2 4.3l-.3 1 0 .2s0 0-31.1-7.7S.9 216.3 .9 216.3l0 0 0-.1 0-.2 .1-.5c.1-.4 .2-1 .4-1.6c.4-1.4 .9-3.3 1.6-5.7c1.4-4.8 3.5-11.6 6.4-19.6c5.7-16 14.6-37.7 27.3-59.7C61.2 86.7 105.2 33.5 175.3 32c29-.6 54.3 6.7 75.7 20.8c21.1 13.8 36.8 33 49.1 53.9c23.5 39.9 37.5 91.8 50.1 138.4c.2 .9 .5 1.7 .7 2.6c13.4 49.8 25.5 93.6 44.1 125.2c9 15.3 18.6 26 29 32.8c10 6.6 22.4 10.7 39.3 10.3c34.9-.7 62.8-27.5 84.3-64.8c10.2-17.7 17.6-35.6 22.5-49.3c2.4-6.8 4.2-12.4 5.3-16.2c.6-1.9 1-3.4 1.2-4.3l.3-1 0-.2s0 0 31.1 7.7s31.1 7.7 31.1 7.7l0 0 0 .1 0 .2-.1 .5c-.1 .4-.2 1-.4 1.6c-.4 1.4-.9 3.3-1.6 5.7c-1.4 4.8-3.5 11.6-6.4 19.6c-5.7 16-14.6 37.7-27.3 59.7c-24.3 42.1-68.3 95.4-138.4 96.9c-29 .6-54.3-6.7-75.7-20.8c-21.1-13.8-36.8-33-49.1-53.9c-23.5-39.9-37.5-91.9-50.1-138.4c-.2-.9-.5-1.7-.7-2.6c-13.4-49.8-25.5-93.6-44.1-125.2c-9-15.3-18.6-26-29-32.8z"],
    "heart-circle-minus": [576, 512, [], "e4ff", "M64 288L39.8 263.8C14.3 238.3 0 203.8 0 167.8C0 92.8 60.8 32 135.8 32c36 0 70.5 14.3 96 39.8L256 96l24.2-24.2c25.5-25.5 60-39.8 96-39.8C451.2 32 512 92.8 512 167.8c0 13.8-2.1 27.4-6.2 40.4C483.4 197.8 458.4 192 432 192c-97.2 0-176 78.8-176 176c0 32.2 8.6 62.3 23.7 88.3L256 480 64 288zm224 80a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 16V352H496 368 352v32h16H496h16z"],
    "circle-w": [512, 512, [], "e12c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM409.5 152L343.1 382.6l-5 17.4H302.5l-5.3-16.7L256 254.7 214.9 383.3 209.5 400H173.9l-5-17.4L102.5 152h50l40.7 141.5 39.9-124.8 5.3-16.7h35l5.3 16.7 39.9 124.8L359.5 152h50z"],
    "circle-calendar": [512, 512, ["calendar-circle"], "e102", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM224 96v32h64V96h32v32h64v64H128V128h64V96h32zM128 384V224H384V384H128z"],
    "hourglass-half": [384, 512, ["hourglass-2"], "f252", "M0 0H32 352h32V64H352v64 13.3l-9.4 9.4L237.3 256 342.6 361.4l9.4 9.4V384v64h32v64H352 32 0V448H32V384 370.7l9.4-9.4L146.7 256 41.4 150.6 32 141.3V128 64H0V0zM96 64v50.7L109.3 128H274.7L288 114.7V64H96zm13.3 320H274.7L192 301.3 109.3 384z"],
    "microscope": [512, 512, [128300], "f610", "M160 0h96V32h32V320H256v32H160V320H128V32h32V0zM32 448H320c70.7 0 128-57.3 128-128s-57.3-128-128-128V128c106 0 192 86 192 192c0 49.2-18.5 94-48.9 128H480h32v64H480 320 32 0V448H32zm80-64H304h16v32H304 112 96V384h16z"],
    "sunset": [576, 512, [127751], "f767", "M256 224v-1.8l-77.5-70.5-23.7-21.5 43.1-47.4 23.7 21.5L256 135.7V32 0h64V32l0 103.7 34.5-31.3 23.7-21.5 43 47.4-23.7 21.5L320 222.2V224h-2l-8.4 7.7L288 251.2l-21.5-19.6L258 224h-2zm-74 0l106 73.1L394 224l23.3 126.7L544 374l-40 58H406.7c-19-46.9-65-80-118.7-80s-99.7 33.1-118.7 80H72L32 374l126.7-23.3L182 224zM0 464H24 552h24v48H552 24 0V464z"],
    "sink": [512, 512, [], "e06d", "M288 96c0-17.7 14.3-32 32-32s32 14.3 32 32v32h64V96c0-53-43-96-96-96s-96 43-96 96V288H160V232 208H136 56 32v48H56h56v32H32 0v64H32 224h64H480h32V288H480 400V256h64 24V208H464 376 352v24 56H288V96zM480 384H32v32c0 53 43 96 96 96H384c53 0 96-43 96-96V384z"],
    "calendar-exclamation": [448, 512, [], "f334", "M96 0V64H0v96H448V64H352V0H288V64H160V0H96zM448 192H0V512H448V192zM248 240v24 96 24H200V360 264 240h48zm0 176v48H200V416h48z"],
    "truck-container-empty": [640, 512, [], "e2b5", "M456 160H432v24 72 32 32H208 80 32 0v32 32 16c0 44.2 35.8 80 80 80c26.2 0 49.4-12.6 64-32c14.6 19.4 37.8 32 64 32c44.2 0 80-35.8 80-80c0-5.5-.6-10.8-1.6-16L432 384l17.6 0c-1 5.2-1.6 10.5-1.6 16c0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16H640V288 256v-9.9l-7-7-72-72-7-7H544 456zm126.1 96H480V208h54.1l48 48zM528 368a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM176 400a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM80 368a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "hand-heart": [512, 512, [], "f4bc", "M288 0V32 256h32V64 32h64V64 256h32V128 96h64v32V336c0 97.2-78.8 176-176 176H284.8c-59.6 0-116.9-22.9-160-64L29.3 357 .3 329.4l55.2-57.9 29 27.6 43.6 41.5c0-1.5-.1-3.1-.1-4.6V64 32h64V64 256h32V32 0h64zM213.4 359.5c0 10.7 4.4 21 12.1 28.4L280.7 441l7.4 7.1 7.4-7.1 55.2-53.1c7.7-7.4 12.1-17.7 12.1-28.4c0-21.8-17.7-39.5-39.5-39.5h-1.6c-10.6 0-20.8 4.1-28.5 11.5l-5.1 4.9-5.1-4.9c-7.7-7.4-17.9-11.5-28.5-11.5h-1.6c-21.8 0-39.5 17.7-39.5 39.5z"],
    "bag-shopping": [448, 512, ["shopping-bag"], "f290", "M160 112c0-35.3 28.7-64 64-64s64 28.7 64 64v48H160V112zm-48 48H0V512H448V160H336V112C336 50.1 285.9 0 224 0S112 50.1 112 112v48zm24 48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm152 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "arrow-down-z-a": [576, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", "M160 479.4l23.6-25.7 88-96L293.2 334 246 290.8l-21.6 23.6L192 349.7V64 32H128V64 349.7L95.6 314.4 74 290.8 26.8 334l21.6 23.6 88 96L160 479.4zM320 32V96h32 52l-73 63.9L320 169.5V184v8 32h32H480h32V160H480 428l73-63.9L512 86.5V72 64 32H480 352 320zm75.5 224l-8.6 18.7-88 192L292.8 480h70.4l14.7-32h76.3l14.7 32h70.4l-6.1-13.3-88-192L436.5 256H395.5zM416 364.8L432.1 400H399.9L416 364.8z"],
    "mitten": [448, 512, [], "f7b5", "M352 384H64L5.4 178.9C1.8 166.4 0 153.4 0 140.3C0 62.8 62.8 0 140.3 0h3.4c66 0 123.5 44.9 139.5 108.9l33.6 134.3L368 192l80 80L352 384zM32 416H384v96H32V416z"],
    "reply-clock": [640, 512, ["reply-time"], "e239", "M352 144a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zM512 64H480V80v64 16h16 48 16V128H544 512V80 64zM224 160h96.7c8.1 89.7 83.5 160 175.3 160c5.1 0 10.2-.2 15.2-.6c.5 5.5 .8 11 .8 16.6c0 128-128 176-128 176s32-32 32-80c0-61.9-50.1-112-112-112H224v96H192L0 240 192 64h32v96z"],
    "person-rays": [512, 512, [], "e54d", "M256 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H187.4L178 142.8l-81.7 128 53.9 34.4 33.8-53V480v32h64V480 352h16V480v32h64V480 252.2l33.8 53 53.9-34.4L334 142.8 324.6 128H307.1 204.9zM57 23L40 6.1 6.1 40 23 57l64 64 17 17L137.9 104 121 87 57 23zM489 57l17-17L472 6.1 455 23 391 87l-17 17L408 137.9l17-17 64-64zM121 425l17-17L104 374.1 87 391 23 455l-17 17L40 505.9l17-17 64-64zM425 391l-17-17L374.1 408l17 17 64 64 17 17L505.9 472l-17-17-64-64z"],
    "right": [448, 512, [11157, "arrow-alt-right"], "f356", "M448 256L256 64l-32 0 0 128L0 192 0 320l224 0 0 128 32 0L448 256z"],
    "circle-f": [512, 512, [], "e10e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128H328h24v48H328 208v64h88 24v48H296 208v72 24H160V360 264 152 128h24z"],
    "users": [640, 512, [], "f0c0", "M144 0a80 80 0 1 1 0 160A80 80 0 1 1 144 0zM512 0a80 80 0 1 1 0 160A80 80 0 1 1 512 0zM48 192H196c-2.6 10.2-4 21-4 32c0 38.2 16.8 72.5 43.3 96H0L48 192zM640 320H404.7c26.6-23.5 43.3-57.8 43.3-96c0-11-1.4-21.8-4-32H592l48 128zM224 224a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zM464 352l48 160H128l48-160H464z"],
    "face-pleading": [512, 512, [], "e386", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm160 64c44.2 0 80-35.8 80-80c0-41.5-31.5-75.6-72-79.6c10-10.8 17.6-24.1 21.9-38.8l1.5-5.2 4.4-15.4L165 92.2l-4.4 15.4-1.5 5.2c-7 24.7-28.1 42.7-53.6 45.9L94 160.1l-15.9 2 4 31.8 13.8-1.7C85.9 205.5 80 222.1 80 240c0 44.2 35.8 80 80 80zm192 0c44.2 0 80-35.8 80-80c0-17.9-5.9-34.5-15.9-47.9l13.8 1.7 4-31.8-15.9-2-11.5-1.4c-25.5-3.2-46.6-21.3-53.6-45.9l-1.5-5.2L347 92.2 316.2 101l4.4 15.4 1.5 5.2c4.2 14.8 11.8 28 21.9 38.8c-40.4 4-72 38.1-72 79.6c0 44.2 35.8 80 80 80zM280.1 426.7l10.7 11.9 23.8-21.4-10.7-11.9C294.7 395.1 278.7 384 256 384s-38.7 11.1-47.9 21.3l-10.7 11.9 23.8 21.4 10.7-11.9c4.7-5.3 12.7-10.7 24.1-10.7s19.4 5.4 24.1 10.7zM128 232c17.7 0 32-14.3 32-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4c17.7 0 32-14.3 32-32z"],
    "eye-slash": [640, 512, [], "f070", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L524 384.1c41.9-44 70.2-93.9 84-128.1C578 181.3 478.4 32 320 32c-66.9 0-123.2 26.6-168.3 63L48.4 14.8zM222.5 150c25.6-23.6 59.9-38 97.5-38c79.5 0 144 64.5 144 144c0 24.7-6.2 47.9-17.1 68.2l-38.7-30.1c5.1-11.7 7.9-24.6 7.9-38.1c0-53-43-96-96-96c-6.4 0-12.7 .6-18.8 1.8l11.6 58.2L222.5 150zM444.9 446.6L373 389.9c-16.4 6.5-34.3 10.1-53 10.1c-79.5 0-144-64.5-144-144c0-6.9 .5-13.6 1.4-20.2L85.7 163.5C60.2 197.1 42.1 230.8 32 256c30 74.7 129.6 224 288 224c46.9 0 88.6-13.1 124.9-33.4zM324.8 351.9l-99.1-78.1C234 318.3 273.1 352 320 352c1.6 0 3.2 0 4.8-.1z"],
    "flask-vial": [640, 512, [], "e4f3", "M224 0h32V64H224V309.9l-59.3 96.3-4.7 7.7v9.1 19.6c-10 3.5-20.8 5.5-32 5.5c-53 0-96-43-96-96V64H0V0H32 96h64 64zM196.7 415.2L221 375.8l99-160.8V64H288V0h32 32H480h32 32V64H512V214.9L635.3 415.2l4.7 7.7V432v48 32H608 224 192V480 432v-8.4-.6l4.7-7.7zM96 64v96h64V64H96zm288 0V224v9.1l-4.7 7.7L330.5 320h171l-48.8-79.2-4.7-7.7V224 64H384z"],
    "police-box": [384, 512, [], "e021", "M208 0V16 32H320V64h32V448h32v64H0V448H32V64H64V32H176V16 0h32zM96 128v32h32V128H96zm0 48v32h32V176H96zm80-48H144v32h32V128zm-32 48v32h32V176H144zm96-48H208v32h32V128zm0 48H208v32h32V176zm16-48v32h32V128H256zm32 48H256v32h32V176zM96 240v80h80V240H96z"],
    "cucumber": [512, 512, [129362], "e401", "M37.5 474.5c47.8 47.8 123.9 49.9 174.2 6.4L232 501.3 277.3 456l-20.1-20.1L435.9 257.1 456 277.3 501.3 232l-20.4-20.4c43.5-50.3 41.4-126.4-6.4-174.2c-50-50-131-50-181 0L172.1 158.9 152 138.7 106.7 184l20.1 20.1L37.5 293.5c-50 50-50 131 0 181zM168 280v48H120V280h48zm112-32h48v48H280V248zM424 88v48H376V88h48z"],
    "head-side-brain": [512, 512, [], "f808", "M0 224.2C0 100.6 100.2 0 224 0h32C358.1 0 441.6 79.7 447.7 180.3L505 252l7 8.8V272v16 32H480 448v96 32H416 320v32 32H288 96 64V480 381.2c-41-41.9-64-98.3-64-157zM288 208h48c26.5 0 48-21.5 48-48s-21.5-48-48-48c-.9 0-1.8 0-2.7 .1C326.7 93.4 308.9 80 288 80c-8.6 0-16.6 2.2-23.5 6.2C255.9 72.8 241 64 224 64s-31.9 8.8-40.5 22.2c-7-3.9-15-6.2-23.5-6.2c-26.5 0-48 21.5-48 48c-26.5 0-48 21.5-48 48c0 20.9 13.4 38.7 32.1 45.3c0 .9-.1 1.8-.1 2.7c0 26.5 21.5 48 48 48h16v48h64V272h16c26.5 0 48-21.5 48-48V208zM160 176v2.7l-.1 0c0-.9 .1-1.8 .1-2.7z"],
    "hand": [512, 512, [129306, 9995, "hand-paper"], "f256", "M288 32V0H224V32 256H192V64 32H128V64 336c0 1.5 0 3.1 .1 4.6L84.5 299.1l-29-27.6L.3 329.4l29 27.6 95.5 91c43.1 41.1 100.4 64 160 64H304c97.2 0 176-78.8 176-176V128 96H416v32V256H384V64 32H320V64 256H288V32z"],
    "person-biking-mountain": [640, 512, [128693, "biking-mountain"], "f84b", "M448 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM427.2 160L336 88 223.2 175.2c-30.7 23.8-28.5 70.8 4.3 91.6L288 305.1V448h64V270.9l-57-38 60.3-48.5L404.8 224H512V160H427.2zM176 176L304 80 256 20H213.3L112 96l64 80zm-16 80H96v20.6c-7.4 2.2-14.6 5.2-21.3 8.8L60.1 270.9 14.9 316.1l14.6 14.6c-3.6 6.7-6.6 13.8-8.8 21.3H0v64H20.6c2.2 7.4 5.2 14.6 8.8 21.3L14.9 451.9l45.3 45.3 14.6-14.6c6.7 3.6 13.8 6.6 21.3 8.8V512h64V491.4c7.4-2.2 14.6-5.2 21.3-8.8l14.6 14.6 45.3-45.3-14.6-14.6c3.6-6.7 6.6-13.8 8.8-21.3H256V352H235.4c-2.2-7.4-5.2-14.6-8.8-21.3l14.6-14.6-45.3-45.3-14.6 14.6c-6.7-3.6-13.8-6.6-21.3-8.8V256zm-32 64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm352-64v20.6c-7.4 2.2-14.6 5.2-21.3 8.8l-14.6-14.6-45.3 45.3 14.6 14.6c-3.6 6.7-6.6 13.8-8.8 21.3H384v64h20.6c2.2 7.4 5.2 14.6 8.8 21.3l-14.6 14.6 45.3 45.3 14.6-14.6c6.7 3.6 13.8 6.6 21.3 8.8V512h64V491.4c7.4-2.2 14.6-5.2 21.3-8.8l14.6 14.6 45.3-45.3-14.6-14.6c3.6-6.7 6.6-13.8 8.8-21.3H640V352H619.4c-2.2-7.4-5.2-14.6-8.8-21.3l14.6-14.6-45.3-45.3-14.6 14.6c-6.7-3.6-13.8-6.6-21.3-8.8V256H480zM448 384a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "utensils-slash": [640, 512, [], "e464", "M303.9 213.2C314.1 198 320 179.7 320 160L288 0H256V160H240L224 0H192L180.3 117.2 160 101.4V0H128L114.7 66.3 48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L544 399.6V352 240 208 0C512 0 384 32 384 176v99.4l-80.1-62.2zM96.8 172.2c5.3 42 37.8 75.5 79.2 82.4V480v32h64V480 285.1L96.8 172.2z"],
    "print-magnifying-glass": [640, 512, ["print-search"], "f81a", "M128 0V32 160h64V64H418.7L448 93.3V160h64V80 66.7l-9.4-9.4-48-48L445.3 0H432 160 128zM352 192H64V384h64v96 32h32H480h32V485.8L498.2 472c-15.8 5.2-32.6 8-50.2 8c-36 0-69.3-11.9-96-32H192V384 368 352h99.2c-2.1-10.3-3.2-21-3.2-32c0-52.3 25.1-98.8 64-128zm96 48.1a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 208c26.7 0 51.5-8.2 72-22.1l63.1 62.7 17 16.9 33.8-34-17-16.9-63-62.6c13.9-20.5 22.1-45.3 22.1-71.9c0-70.7-57.3-128-128-128s-128 57.3-128 128s57.3 128 128 128z"],
    "folder-bookmark": [512, 512, [], "e186", "M512 480H0V32H224l48 64H512V480zM288 160V352l80-56 80 56V160H288z"],
    "om": [512, 512, [128329], "f679", "M368 0L336 32l32 32 32-32L368 0zm16 192H370.7l-9.4 9.4L306.7 256H245.2c6.9-14.5 10.8-30.8 10.8-48c0-61.9-50.1-112-112-112c-41.2 0-77.1 22.2-96.5 55.2l55.1 32.5C111 169.4 126.4 160 144 160c26.5 0 48 21.5 48 48s-21.5 48-48 48H88l24 64h32 16c35.3 0 64 28.7 64 64s-28.7 64-64 64C48 448 0 352 0 352s0 160 160 160c70.7 0 128-57.3 128-128c0-23.3-6.2-45.2-17.1-64H320h13.3l9.4-9.4L397.3 256H416c17.7 0 32 14.3 32 32v96c0 17.7-14.3 32-32 32c-64 0-96-48-96-48v64s16 48 96 48c53 0 96-43 96-96V288c0-53-43-96-96-96H384zM480 64s-66.5 32-112 32s-112-32-112-32s16 96 120 96c72 0 104-32 104-32V64z"],
    "pi": [448, 512, [], "f67e", "M32 64H0v64H32 96V345.8L66.3 420.1l59.4 23.8 32-80 2.3-5.7V352 128H288V416v32h32 80 23.1l7.3-21.9 16-48-60.7-20.2L376.9 384H352V128h64 32V64H416 32z"],
    "flask-round-potion": [448, 512, ["flask-potion"], "f6e1", "M192 206.2V167.4 64h64V167.4v38.8l34.4 17.9c46.2 24.1 77.5 72.2 77.6 127.6c-58.6-1.7-85.4-12.6-109.9-22.6c-22-9-42.2-17.2-82.1-17.2c-42.3 0-73.4 9.2-94.5 18.8c6.8-46.4 35.8-85.7 76-106.6L192 206.2zm128-38.8V64h32V0H320 256 192 128 96V64h32V167.4C61.4 202.1 16 271.8 16 352c0 64.3 29.2 121.8 75.1 160H356.9c45.9-38.2 75.1-95.7 75.1-160c0-80.2-45.4-149.9-112-184.6z"],
    "face-shush": [512, 512, [], "e38c", "M0 256C0 357.2 58.7 444.7 144 486.3V432 376 352 320h32 24V275.9c-14.8-6.9-26.6-15.9-35.3-24.6L153.4 240 176 217.4l11.3 11.3c3.5 3.5 7.7 7.1 12.7 10.5V224 192h32 48 32v32 15.2c4.9-3.4 9.2-7 12.7-10.5L336 217.4 358.6 240l-11.3 11.3c-8.7 8.7-20.5 17.7-35.3 24.6V320h8 32v32 10.1l.8-1 24.6 20.5 36.9 30.7 24.6 20.5-10 12C480 398 512 330.7 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zM176.4 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM280 248V224H232v24 72h48V248zM200 352H176v24 56 56 24h24 80 40 11.2l7.2-8.6 40-48 15.4-18.4-36.9-30.7-15.4 18.4L308.8 464H287.6L224 419.5V400h24 24v32h48V376 352H296 248 200z"],
    "worm": [512, 512, [], "e599", "M256 96c0-53 43-96 96-96H480V128v48 16V376c0 75.1-60.9 136-136 136s-136-60.9-136-136V296c0-22.1-17.9-40-40-40s-40 17.9-40 40V464v48H32V464 296c0-75.1 60.9-136 136-136s136 60.9 136 136v80c0 22.1 17.9 40 40 40s40-17.9 40-40V192H352c-53 0-96-43-96-96zm144-8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "house-circle-xmark": [640, 512, [], "e50b", "M520.5 193.7L288.4 0 0 240v47.6H64.1V512H224V352h96.7c8.1-89.7 83.5-160 175.3-160c8.3 0 16.5 .6 24.5 1.7zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7L518.6 368l36.7 36.7L566.6 416 544 438.6l-11.3-11.3L496 390.6l-36.7 36.7L448 438.6 425.4 416l11.3-11.3L473.4 368l-36.7-36.7L425.4 320 448 297.4l11.3 11.3L496 345.4l36.7-36.7L544 297.4 566.6 320l-11.3 11.3z"],
    "plug": [384, 512, [128268], "f1e6", "M128 0H64V32v96h64V32 0zM320 0H256V32v96h64V32 0zM32 160H0v64H32v32c0 77.4 55 142 128 156.8V512h64V412.8C297 398 352 333.4 352 256V224h32V160H352 32z"],
    "calendar-circle-exclamation": [576, 512, [], "e46e", "M160 0H96V64H0v96H448V64H352V0H288V64H160V0zm96 368c0-91.8 70.3-167.2 160-175.3V192H0V512H330.8C285.6 480.1 256 427.5 256 368zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64H416V416h32v32zm0-176v16 80 16H416V368 288 272h32z"],
    "square-i": [448, 512, [], "e272", "M448 32H0V480H448V32zM152 128h72 72 24v48H296 248V336h48 24v48H296 248 200 152 128V336h24 48V176H152 128V128h24z"],
    "chevron-up": [512, 512, [], "f077", "M256 82.7l22.6 22.6 192 192L493.3 320 448 365.3l-22.6-22.6L256 173.3 86.6 342.6 64 365.3 18.7 320l22.6-22.6 192-192L256 82.7z"],
    "face-saluting": [640, 512, [129761], "e484", "M310.1 61.9l-26.5 18-26.5 18-30 20.4 35.5 48.9 6.6 9.1c1-.1 2.1-.2 3.2-.2c17.7 0 32 14.3 32 32s-14.3 32-32 32c-13.1 0-24.4-7.9-29.3-19.1l-13.4 9.7-82.3 59.9c-13.9 10.1-29.5 16.6-45.6 19.6C126.5 425.5 229.1 512 352 512c141.4 0 256-114.6 256-256S493.4 0 352 0c-26.5 0-52.1 4-76.1 11.5l16.2 23.9 18 26.5zM128 185.8V146.8L239.2 71.3l26.5-18L229.7 .4l-26.5 18L35.1 132.5c-44.3 30.1-47.1 94.4-5.6 128.2l1.5 1.2c28.1 22.9 68.2 24 97.5 2.7l82.3-59.9 25.9-18.8-37.6-51.8 0 0 0 0L173.2 153 160 162.6l-14.2 10.4L128 185.8zM227.5 354l25-20c7.2 9 39.7 34 99.5 34s92.3-25 99.5-34l25 20c-14.1 17.6-56.3 46-124.5 46s-110.4-28.4-124.5-46zM432.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "gauge-simple-low": [512, 512, ["tachometer-slow"], "f62c", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-35.3-28.7-64-64-64c-2.1 0-4.1 .1-6.1 .3L173.3 140.9l-11.1-21.3-42.6 22.1 11.1 21.3 76.6 147.4C197.8 321.6 192 336.1 192 352c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "face-persevering": [512, 512, [], "e385", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm60.1-101.3c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7l-10.7 11.9-23.8-21.4 10.7-11.9C188.2 371.4 216.3 352 256 352s67.8 19.4 83.9 37.3l10.7 11.9-23.8 21.4-10.7-11.9zM222.6 112l-11.3 11.3-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4-15.8 2.6-5.3-31.6 15.8-2.6 2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4L200 89.4 222.6 112zm78.1 11.3L289.4 112 312 89.4l11.3 11.3 7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4 15.8 2.6-5.3 31.6-15.8-2.6-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4zM112 208l118.9 64L112 336l45.7-64L112 208zm169.1 64L400 208l-45.7 64L400 336 281.1 272z"],
    "circle-camera": [512, 512, ["camera-circle"], "e103", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM196 160l12-32h96l12 32h68V352H128V160h68zm108 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "hand-spock": [576, 512, [128406], "f259", "M251.2 39.7L242.9 8.8 181.1 25.4l8.3 30.9L242.9 256H213.3L166.6 102.7l-9.3-30.6L96.1 90.7l9.3 30.6 71.7 235.5-61.6-58.6-29-27.6L31.4 328.5l29 27.6L156.8 448c43.1 41.1 100.4 64 160 64h2.3H328h8.3c56.7 0 106.7-37.3 122.8-91.7l83.7-283.2 9.1-30.7L490.4 88.2l-9.1 30.7L440.8 256H416.1L455.3 70.6l6.6-31.3L399.3 26.1l-6.6 31.3L350.7 256H309.1L251.2 39.7z"],
    "spider-web": [576, 512, [128376], "f719", "M142 .1l23.1 4.3L288 27.5l122.8-23L434 .1l8.3 22 46.3 123.6 77 92.4L580.4 256l-14.9 17.9-77 92.4L442.2 489.8l-8.3 22-23.1-4.3L288 484.5l-122.8 23L142 511.9l-8.3-22L87.4 366.3l-77-92.4L-4.4 256l14.9-17.9 77-92.4L133.8 22.2 142 .1zm25.1 92.7l-28.9 77-1.7 4.4-3 3.6L88.4 232h44.7l34.8-39.8 21.4-60.6L167.1 92.8zm42.1-23.1l21.5 37.5L288 123.9l57.4-16.6 21.5-37.5L293.2 83.5l-5.2 1-5.2-1L209.2 69.7zM408.9 92.8l-22.2 38.8 21.4 60.6L442.9 232h44.7l-45.1-54.1-3-3.6-1.7-4.4-28.9-77zM487.6 280H442.9l-34.7 39.6-20.9 61.7 21.6 37.9 28.9-77 1.7-4.4 3-3.6L487.6 280zM366.8 442.3l-19.6-34.2-59.7-19.8-56.9 16.5-21.5 37.5 73.6-13.8 5.2-1 5.2 1 73.6 13.8zM167.1 419.2l22.2-38.8-21.4-60.6L133.1 280H88.4l45.1 54.1 3 3.6 1.7 4.4 28.9 77zM196.9 280l10.2 11.6 3 3.5 1.5 4.4 9.1 25.9L246.6 280H196.9zm68 64.9l16.5-4.8 7.2-2.1 7.1 2.3 16.1 5.3L288 304.4l-23.1 40.5zm90.6-19.2l8.8-26 1.5-4.5 3.1-3.6L379.1 280H329.4l26.1 45.7zM379.1 232l-10.2-11.6-3-3.5-1.5-4.4-9.1-25.9L329.4 232h49.8zm-68-64.9l-16.5 4.8-6.7 1.9-6.7-1.9-16.5-4.8L288 207.6l23.1-40.5zm-90.4 19.5l-9.1 25.9-1.5 4.4-3 3.5L196.9 232h49.8l-25.9-45.3z"],
    "circle-microphone": [512, 512, ["microphone-circle"], "e116", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 256V96h96V256c0 26.5-21.5 48-48 48s-48-21.5-48-48zm-48-32v16 16c0 53 43 96 96 96s96-43 96-96V240 224h32v16 16c0 65.3-48.9 119.1-112 127v17 16H240V400 383c-63.1-7.9-112-61.7-112-127V240 224h32z"],
    "book-arrow-up": [448, 512, [], "e0ba", "M0 96C0 43 43 0 96 0H384h32 32V384H416v64h32v64H416 384 96c-53 0-96-43-96-96V96zM64 416c0 17.7 14.3 32 32 32H352V384H264V209.9l39 39 17 17L353.9 232l-17-17-80-80-17-17-17 17-80 80-17 17L160 265.9l17-17 39-39V384H96c-17.7 0-32 14.3-32 32z"],
    "popsicle": [320, 512, [], "e43e", "M160 0C71.6 0 0 71.6 0 160V384H320V160C320 71.6 248.4 0 160 0zm32 512V416H128v96h64z"],
    "command": [512, 512, [], "e142", "M0 0H32 160h32V32v96H320V32 0h32H480h32V32 160v32H480 384V320h96 32v32V480v32H480 352 320V480 384H192v96 32H160 32 0V480 352 320H32h96V192H32 0V160 32 0zM128 128V64H64v64h64zm64 192H320V192H192V320zm-64 64H64v64h64V384zm256 0v64h64V384H384zm0-256h64V64H384v64z"],
    "blinds": [512, 512, [], "f8fb", "M32 0H0V64H16L0 128H128V64h32v64H512L496 64h16V0H480 32zM24 160L0 256H98.7c4.8-13.6 15.6-24.4 29.3-29.3V160H24zM144 320c-20.9 0-38.7-13.4-45.3-32H24L0 384H512l-24-96H189.3c-6.6 18.6-24.4 32-45.3 32zm16-93.3c13.6 4.8 24.4 15.6 29.3 29.3H512l-24-96H160v66.7zM0 512H512l-24-96H24L0 512z"],
    "stopwatch": [448, 512, [9201], "f2f2", "M224 0H144V64h48V98.4C92.3 113.8 16 200 16 304c0 114.9 93.1 208 208 208s208-93.1 208-208c0-41.8-12.3-80.7-33.5-113.2l24.1-24.1L445.3 144 400 98.7l-22.6 22.6L355.7 143c-28.1-23-62.2-38.8-99.7-44.6V64h48V0H224zm24 216V328v24H200V328 216 192h48v24z"],
    "saxophone": [640, 512, [127927], "f8dc", "M246.7 176L171.4 306.1c-2.2 3.8-3.4 8.2-3.4 12.6v2.6c0 12.5 10.1 22.6 22.6 22.6c6 0 11.8-2.4 16-6.6L319 225l-8-8-17-17L328 166.1l17 17 8 8L367 177l-8-8-17-17L376 118.1l17 17 8 8L415 129l-8-8-17-17L424 70.1l17 17 8 8 63-63h80l48 32V96H544L288.6 418.6C257.9 457.4 211.2 480 161.8 480C72.4 480 0 407.6 0 318.2v-3.1c0-12.7 1.5-25.4 4.4-37.8L28.2 176H24 0V128H24 264h24v48H264 246.7zM120 320a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm8-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "square-2": [448, 512, [], "e257", "M448 32H0V480H448V32zM161.7 146.5c15.8-12 35.2-18.4 55.1-18.1l3.4 .1c46.5 .7 83.8 38.6 83.8 85.1c0 23.5-9.7 46-26.9 62.1L212.7 336H296h24v48H296 152 128V349.6l7.6-7.1L244.3 240.6c7.5-7 11.7-16.8 11.7-27.1c0-20.3-16.3-36.8-36.6-37.1l-3.4-.1c-9.1-.1-18 2.8-25.3 8.3L174.5 197l-19.1 14.5-29.1-38.2 19.1-14.5 16.2-12.3z"],
    "field-hockey-stick-ball": [512, 512, [127953, "field-hockey"], "f44c", "M514.8 58.9L487.5 98.4l-36.3 52.5L371.3 97.5l37.2-53.8L435.8 4.3l79 54.6zm-161.6 65L433 177.2 241 454.9c-24.6 35.5-64.9 56.8-108.1 56.9C59.5 512 .1 452.3 .6 378.9l0-2.2c.2-25.7 7.8-50.8 21.8-72.4l17.3-26.5 26.3-40.2 80.4 52.5-26.3 40.2-17.3 26.5c-4 6.1-6.2 13.3-6.2 20.6l0 2.2c-.1 20 16 36.2 36 36.1c11.7 0 22.7-5.8 29.4-15.5L353.1 123.9zM432 352a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "arrow-up-square-triangle": [576, 512, ["sort-shapes-up-alt"], "f88b", "M512 32V224H320V32H512zm-352 .4l23.7 26 80 88 21.5 23.7-47.4 43.1-21.5-23.7L192 162.8V448v32H128V448 162.8l-24.3 26.8L82.2 213.2 34.8 170.2l21.5-23.7 80-88 23.7-26zM416 288L528 480H304L416 288z"],
    "face-scream": [640, 512, [], "e38b", "M569 315.8c4.6-19.2 7-39.2 7-59.8C576 114.6 461.4 0 320 0S64 114.6 64 256c0 20.6 2.4 40.7 7 59.9L82.3 306l20.6-18 21 17.5c57.5 48 87.8 118 98 187C252.1 505.1 285.2 512 320 512c34.8 0 68-6.9 98.2-19.5c10.2-69 40.4-139 98-187l21-17.5 20.6 18 11.3 9.8zM320 320c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V368c0-26.5 21.5-48 48-48zm-46.6-77c-22.5 36.9-62.8 54.7-90.1 39.8s-31.1-56.9-8.7-93.7s62.8-54.7 90.1-39.8s31.1 56.9 8.7 93.7zm183.4 39.8c-27.3 14.9-67.6-2.9-90.1-39.8s-18.6-78.8 8.6-93.7s67.6 2.9 90.1 39.8s18.6 78.8-8.6 93.7zM192 512c-7-68.4-34.8-137-88.7-181.9L39.1 386.2c26.4 40 43.6 75.3 43.2 125.7L192 512zm365.7 0c-.4-50.5 16.7-85.7 43.2-125.7l-64.3-56.2C482.8 375 455 443.6 448 512l109.8 0z"],
    "square-m": [448, 512, [], "e276", "M448 32H0V480H448V32zM96 152V128h36.3l7.2 9.9L224 255l84.5-117.1 7.2-9.9H352v24V360v24H304V360 226.2l-60.5 83.8L224 337l-19.5-26.9L144 226.2V360v24H96V360 152z"],
    "camera-web": [448, 512, ["webcam"], "f832", "M340.5 415.4C405 376 448 305 448 224C448 100.3 347.7 0 224 0S0 100.3 0 224c0 81 43 152 107.5 191.4L32 472v40H416V472l-75.5-56.6zM224 352a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-288a160 160 0 1 1 0 320 160 160 0 1 1 0-320zM176 224H144c0-44.2 35.8-80 80-80v32c-26.5 0-48 21.5-48 48z"],
    "comment-arrow-down": [512, 512, [], "e143", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM280 152V128H232v24V270.1l-31-31-17-17L150.1 256l17 17 72 72 17 17 17-17 72-72 17-17L328 222.1l-17 17-31 31V152z"],
    "lightbulb-cfl": [320, 512, [], "e5a6", "M160 64l-25.2 5L0 96V32L122.5 7.5 160 0V38.3 64zm160 0v64L0 192V128L320 64zM0 288V224l320-64v64L0 288zM64 480V384H96V301.4l48-9.6V384h32V348.8 320 284.8L320 256v64l-96 19.2V384h32v96H192v32H128V480H64z"],
    "window-frame-open": [512, 512, [], "e050", "M480 64V224v64H416 96 32V224 64 0H96 416h64V64zM232 64H96V224H232V64zm48 0V224H416V64H280zM96 448H416V320h64V448h32v64H480 448 64 32 0V448H32V320H96V448z"],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm48.7-198.3c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448l-3.9-15 0 0 0 0 0 0 0 0 .2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1 0 0 0 0 0 0 0 0V361l0 0 0 0 0 0 0 0 .2-.1 .3-.2 .6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3-.5-.3-.2-.1 0 0 0 0 0 0 0 0 3.9-15c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "bridge-circle-xmark": [640, 512, [], "e4cb", "M64 32H32V96H64h40v64H32V288c53 0 96 43 96 96v96h96V384c0-53 43-96 96-96c6.3 0 12.4 .6 18.3 1.7C367.1 231.8 426.9 192 496 192c42.5 0 81.6 15.1 112 40.2V160H536V96h40 32V32H576 64zM488 96v64H408V96h80zM360 96v64H280V96h80zM232 96v64H152V96h80zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7L518.6 368l36.7 36.7L566.6 416 544 438.6l-11.3-11.3L496 390.6l-36.7 36.7L448 438.6 425.4 416l11.3-11.3L473.4 368l-36.7-36.7L425.4 320 448 297.4l11.3 11.3L496 345.4l36.7-36.7L544 297.4 566.6 320l-11.3 11.3z"],
    "period": [128, 512, [], "2e", "M0 352H128V480H0V352z"],
    "face-grin-tongue": [512, 512, [128539, "grin-tongue"], "f589", "M0 256C0 368.9 73.1 464.7 174.5 498.8C165.3 484 160 466.6 160 448V400.7c-24-17.5-43.1-41.4-54.8-69.2c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19c12.3-3.8 24.3 6.9 19.3 18.7c-11.8 28-31.1 52-55.4 69.6V448c0 18.6-5.3 36-14.5 50.8C438.9 464.7 512 368.9 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zm176.4-80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM320 448V384H272v24H240V384H192v64c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "up-to-dotted-line": [448, 512, [], "e457", "M64 32V96H0V32H64zm96 0V96H96V32h64zm32 0h64V96H192V32zm160 0V96H288V32h64zm32 0h64V96H384V32zM64 288L224 128 384 288v32H288V480H160V320H64V288z"],
    "thought-bubble": [512, 512, [], "e32e", "M256 0c-53.7 0-99.7 33.1-118.7 80H128C57.3 80 0 137.3 0 208s57.3 128 128 128h44.8c16.6 28.7 47.6 48 83.2 48s66.6-19.3 83.2-48H384c70.7 0 128-57.3 128-128s-57.3-128-128-128h-9.3c-19-46.9-65-80-118.7-80zM0 448v64H64V448H0zm184-56H104v80h80V392z"],
    "skeleton-ribs": [640, 512, [], "e5cb", "M352 32V0H288V32 64H224 205.9l-9.3 15.5L224 96c-27.4-16.5-27.4-16.5-27.4-16.5l0 0 0 0-.1 .1-.3 .4-.9 1.5c-.8 1.3-1.9 3.2-3.2 5.6c-2.8 4.9-6.7 11.9-11.3 20.7c-9.3 17.6-21.7 42.4-34.1 71.4c-2.8 6.5-5.6 13.2-8.4 20.2l-.4 .1 .1 .6C116.4 254.4 96 321.6 96 384v64 32h32 64 5.8l5.4-2L288 446.2V480v32h64V480 446.2L436.8 478l5.4 2H448h64 32V448 384c0-62.4-20.4-129.6-41.9-183.7l.1-.6-.4-.1c-2.8-7-5.6-13.7-8.4-20.2c-12.4-29-24.8-53.8-34.1-71.4c-4.7-8.8-8.6-15.8-11.3-20.7c-1.4-2.4-2.5-4.3-3.2-5.6l-.9-1.5-.3-.4-.1-.1 0 0 0 0s0 0-27.4 16.5l27.4-16.5L434.1 64H416 352V32zm-64 96v38.3l-72.7 16.2c8.1-17.6 15.8-32.8 22-44.5c1.9-3.7 3.8-7 5.4-10H288zM186 254.6l102-22.7v39.7L171.3 303.4c4.1-16.4 9.2-32.8 14.7-48.8zM160.3 372.7L288 337.9v39.9L186.2 416H160V384c0-3.7 .1-7.5 .3-11.3zM352 377.8V339l118.8 35.6 9.1 2.7c.1 2.2 .1 4.4 .1 6.6v32H453.8L352 377.8zm117.8-70.3L352 272.2V231.9l102 22.7c6 17.3 11.4 35.2 15.7 53zm-45-125L352 166.3V128h45.4c1.6 3 3.4 6.3 5.4 10c6.2 11.7 13.9 26.9 22 44.5zM0 80v32 96 32V480v32H64V480 240 224l16-12c30.2-22.7 48-58.2 48-96v-4V80H96 32 0zm608 0H544 512v32 4c0 37.8 17.8 73.3 48 96l16 12v16V480v32h64V480 240 208 112 80H608z"],
    "raygun": [576, 512, [], "e025", "M192 64h96V56 32h48V56 296v24H288V296v-8L176 512 48 448l80-160H112C50.1 288 0 237.9 0 176C0 131.3 26.2 92.8 64 74.8V0L192 64zm224 0V88v56h64l96-48V256l-96-48H416v56 24H368V264 88 64h48zM136 176a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "flute": [640, 512, [], "f8b9", "M0 160H96V352H0V160zM640 352H128V160H640V352zM320 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "acorn": [448, 512, [], "f6ae", "M259.7 48.4c-3.3 4.8-6 10.1-8 15.6H352c53 0 96 43 96 96v32H0V160c0-53 43-96 96-96H202.1c3-15.3 9.2-29.9 18.1-42.9L233.9 1.4l39.5 27.3L259.7 48.4zM224 480C80 432 48 304 48 224H224 400c0 80-32 208-176 256z"],
    "video-arrow-up-right": [576, 512, [], "e2c9", "M0 64H384V448H0V64zm576 0V448L416 337.1V174.9L576 64zM152 160H128v48h24 54.1L103 311l-17 17L120 361.9l17-17 103-103V296v24h48V296 184 160H264 152z"],
    "grate-droplet": [576, 512, [], "e194", "M0 32H32h96 96 96 96 32V64v93.9L343.7 318.1c-15.4 23.7-23.7 51.4-23.7 79.7V400c0 29.6 8.9 57.1 24.2 80H320 224 128 32 0V448 256 64 32zM64 96V224H96V96H64zm0 320H96V288H64V416zm128 0V288H160V416h32zm96 0V288H256V416h32zM384 96H352V224h32V96zM256 96V224h32V96H256zm-96 0V224h32V96H160zm304 96l93.5 143.6c12.1 18.5 18.5 40.2 18.5 62.3V400c0 61.9-50.1 112-112 112s-112-50.1-112-112v-2.1c0-22.1 6.4-43.7 18.5-62.3L464 192z"],
    "seal-exclamation": [512, 512, [], "e242", "M256 0l75 75H437V181l75 75-75 75V437H331l-75 75-75-75H75V331L0 256l75-75V75H181L256 0zm24 128H232v24V264v24h48V264 152 128zM232 320v48h48V320H232z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M128 0H96V64h27C78.1 107.2 8 190.2 8 288c0 47.4 30.8 72.3 56 84.7V400H256V372.7c25.2-12.5 56-37.4 56-84.7c0-37.3-10.2-72.4-25.3-104.1l-99.4 99.4L176 294.6 153.4 272l11.3-11.3L270.8 154.6c-23-37.9-51.5-69.2-73.8-90.6h27V0H192 128zM0 512H320V480l-48-48H48L0 480v32z"],
    "message-sms": [512, 512, [], "e1e5", "M0 0H512V416H304L160 512V416H0V0zM192 144v16 96 16h32V256 203l18.4 29.5L256 254.2l13.6-21.7L288 203v53 16h32V256 160 144H304h-8-8.9l-4.7 7.5L256 193.8l-26.4-42.3-4.7-7.5H216h-8H192zm-87.8 37.5l0 0c0-.2 .3-1.8 4-3.4c3.7-1.7 9.8-2.7 17.6-1.5c2.8 .4 11.8 2.2 14.2 2.8l15.5 4.1 8.2-30.9-15.5-4.1c-3.9-1.1-14.1-3-17.5-3.5c-12.6-2-25.3-.8-35.7 4c-10.6 4.8-20 13.8-22.3 27.1c-1.3 7.2-.6 14.4 2.5 20.9c3 6.4 7.8 10.9 12.5 14.1c8.1 5.5 18.7 8.7 26.4 11l0 0 1.5 .5c9.4 2.8 15.3 4.9 18.7 7.4c1.4 1 1.6 1.6 1.6 1.6l0 0c0 .1 .1 .2 .1 .6c0 .4 .1 1.2-.2 2.3c-.2 1.3-.8 2.6-3.8 3.9c-3.5 1.5-9.5 2.4-17.8 1.1c-3.8-.6-10.6-2.9-16.9-5.1l0 0 0 0c-1.5-.5-3-1-4.4-1.5l-15.2-5.1L67.8 258.1l15.2 5.1c.8 .3 1.7 .6 2.8 1l0 0c6.1 2.1 16.7 5.7 23.5 6.8l0 0 .1 0c12.2 1.9 24.7 1.3 35.3-3.3c11.2-4.8 20.3-14.1 22.7-27.8c1.3-7.3 .7-14.5-2.2-21.2c-2.8-6.6-7.4-11.3-12.2-14.7c-8.5-6.2-19.6-9.5-27.6-11.9l-.7-.2c-9.6-2.9-15.6-4.8-19.2-7.3c-1-.7-1.4-1.1-1.5-1.3c0-.2-.1-.8 .1-1.8zm-.1 1.9a.1 .1 0 1 0 .1-.1 .1 .1 0 1 0 -.1 .1zm272.1-1.9l0 0c0-.2 .3-1.8 4-3.4c3.7-1.7 9.8-2.7 17.6-1.5c2.8 .4 11.8 2.2 14.2 2.8l15.5 4.1 8.2-30.9-15.5-4.1c-4-1.1-14.1-3-17.5-3.5c-12.6-2-25.3-.8-35.7 4c-10.6 4.8-20 13.8-22.3 27.1c-1.3 7.2-.6 14.4 2.5 20.9c3 6.4 7.8 10.9 12.5 14.1c8.1 5.5 18.7 8.7 26.4 11l1.5 .5c9.4 2.8 15.3 4.9 18.7 7.4c1.4 1 1.6 1.6 1.6 1.6l0 0c0 .1 .1 .2 .1 .6c0 .4 .1 1.2-.2 2.3c-.2 1.3-.8 2.6-3.8 3.9c-3.5 1.5-9.5 2.4-17.8 1.1c-3.8-.6-10.6-2.9-16.9-5.1l0 0c-1.5-.5-3-1-4.4-1.5l-15.2-5.1-10.1 30.4 15.2 5.1c.8 .3 1.7 .6 2.8 1l0 0c6.1 2.1 16.7 5.7 23.5 6.8l0 0 .1 0c12.2 1.9 24.7 1.3 35.3-3.3c11.2-4.8 20.3-14.1 22.7-27.8c1.3-7.3 .7-14.5-2.2-21.2c-2.8-6.6-7.4-11.3-12.2-14.7c-8.5-6.2-19.6-9.5-27.6-11.9l-.7-.2c-9.6-2.9-15.6-4.8-19.2-7.3c-1-.7-1.4-1.1-1.5-1.3c0-.2-.1-.8 .1-1.8zm-.1 1.9a.1 .1 0 1 0 .1-.1 .1 .1 0 1 0 -.1 .1z"],
    "coffee-beans": [512, 512, [], "e13f", "M296.3 82.7l-30-60.1C317.7-16.7 401.1-4 459.4 54.4c56.4 56.4 70.2 136.2 35.5 188L466 184.5 296.3 82.7zm-24.5 22.6L441.5 207.1l30 60.1c-51.5 39.2-134.8 26.5-193.2-31.8C222 179 208.2 99.2 242.9 47.4l28.9 57.9zM88.8 250.9l-1.5 4.4 1.1 4.5 46.9 187.5-21.2 63.7C50 502.4 0 434.5 0 352c0-79.8 46.7-145.9 107.8-158l-19 57zm31.8 5.7l21.2-63.7C206 201.6 256 269.5 256 352c0 79.8-46.7 145.9-107.8 158l19-57 1.5-4.4-1.1-4.5L120.7 256.6z"],
    "hat-witch": [576, 512, [], "f6e7", "M224 128L112 384H224V304 288h16 96 16v16 80H464L384 192l32-64h64l32 64L544 88 440 0 224 128zm96 256V320H256v64h64zM0 416v32l128 64H448l128-64V416H0z"],
    "face-grin-wink": [512, 512, ["grin-wink"], "f58c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm.3-180.2c59.1 0 114.1-10.6 160.2-29C400.3 376.7 334.7 432 256.3 432s-144-55.3-160.2-129.2c46.2 18.3 101.2 29 160.2 29zm122.9-94.2c-21.6-28.8-64.8-28.8-86.4 0l-25.6-19.2c34.4-45.9 103.2-45.9 137.6 0l-25.6 19.2zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "clock-three-thirty": [512, 512, [], "e357", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V256 232h24H360h24v48H360 280V392v24H232V392z"],
    "ear-deaf": [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", "M509.3 48L486.6 70.6l-24 24L440 117.3 394.7 72l22.6-22.6 24-24L464 2.7 509.3 48zm-304 304l-22.6 22.6-112 112L48 509.3 2.7 464l22.6-22.6 112-112L160 306.7 205.3 352zM240 128c-61.9 0-112 50.1-112 112H64c0-97.2 78.8-176 176-176s176 78.8 176 176c0 54.7-25 103.5-64 135.8V400c0 61.9-50.1 112-112 112H208V448h32c26.5 0 48-21.5 48-48V359.8 342.7l14.2-9.5C332.3 313 352 278.8 352 240c0-61.9-50.1-112-112-112zM208 240H160c0-44.2 35.8-80 80-80s80 35.8 80 80H272c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "alarm-clock": [512, 512, [9200], "f34e", "M161.3 25.6C144.1 9.7 121.2 0 96 0C43 0 0 43 0 96c0 19 5.5 36.6 15 51.5L161.3 25.6zM256 512c50.3 0 96.8-16.6 134.2-44.6l19.2 19.2L432 509.3 477.3 464l-22.6-22.6-19.2-19.2c28-37.4 44.6-83.8 44.6-134.2C480 164.3 379.7 64 256 64S32 164.3 32 288c0 50.3 16.6 96.8 44.6 134.2L57.4 441.4 34.7 464 80 509.3l22.6-22.6 19.2-19.2c37.4 28 83.8 44.6 134.1 44.6zM498.3 147.5c9.5-14.9 15-32.6 15-51.5c0-53-43-96-96-96C392.1 0 369.1 9.7 352 25.6L498.3 147.5zM280 184v94.1l41 41 17 17L304 369.9l-17-17-48-48-7-7V288 184 160h48v24z"],
    "eclipse": [640, 512, [], "f749", "M256 73.1L150 0 126.7 126.7 0 150 73.1 256 0 362l126.7 23.3L150 512l106-73.1L362 512l12.5-68.2c-31.6-15.1-58.8-37.9-79.2-66c-12.4 4-25.6 6.2-39.4 6.2c-70.7 0-128-57.3-128-128s57.3-128 128-128c13.7 0 27 2.2 39.4 6.2c20.3-28.1 47.6-50.9 79.2-66L362 0 256 73.1zM256 256c0-33.6 8-65.4 22.1-93.4c-7.1-1.7-14.5-2.6-22.1-2.6c-53 0-96 43-96 96s43 96 96 96c7.6 0 15-.9 22.1-2.6C264 321.3 256 289.6 256 256zM464 432a176 176 0 1 0 0-352 176 176 0 1 0 0 352z"],
    "face-relieved": [512, 512, [], "e389", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.7 379.3l22.6-22.6c13 13 35.8 27.3 68.7 27.3s55.6-14.3 68.7-27.3l22.6 22.6C329.4 397.2 298.9 416 256 416s-73.4-18.8-91.3-36.7zM197.1 95.2l-6.3 2.1c-23.6 7.9-44 23.4-57.8 44.1l-7.6 11.5L98.7 135.1l7.6-11.5c17.8-26.6 43.9-46.6 74.3-56.7l6.3-2.1 10.1 30.4zm124.2 2.1l-6.3-2.1 10.1-30.4 6.3 2.1c30.4 10.1 56.5 30.1 74.3 56.7l7.6 11.5-26.6 17.8L379 141.4c-13.8-20.7-34.1-36.3-57.8-44.1zm73.9 137.1l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2c21.6 28.8 64.8 28.8 86.4 0zm-278.4 0c21.6 28.8 64.8 28.8 86.4 0l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2z"],
    "road-circle-check": [640, 512, [], "e564", "M160 32H288V96v32h64V96 32H480l46.5 162.6c-9.9-1.7-20.1-2.6-30.5-2.6c-59.5 0-112.1 29.6-144 74.8V224 192H288v32 64 32h38.6c-4.3 15.3-6.6 31.4-6.6 48c0 5.4 .2 10.7 .7 16H288v32 64H32L160 32zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm222.6-32L552 313.4l-11.3 11.3L480 385.4l-28.7-28.7L440 345.4 417.4 368l11.3 11.3 40 40L480 430.6l11.3-11.3 72-72L574.6 336z"],
    "dice-five": [448, 512, [9860], "f523", "M448 32H0V480H448V32zM128 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "octagon-minus": [512, 512, ["minus-octagon"], "f308", "M0 160V352L160 512H352L512 352V160L352 0H160L0 160zm184 72H328h24v48H328 184 160V232h24z"],
    "square-rss": [448, 512, ["rss-square"], "f143", "M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm32 80c150.2 0 272 121.8 272 272H320c0-123.7-100.3-224-224-224V112zm0 96c97.2 0 176 78.8 176 176H224c0-70.7-57.3-128-128-128V208zm0 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "face-zany": [512, 512, [], "e3a4", "M384.1 477.7C506.5 407 548.5 250.4 477.8 128S250.5-36.4 128.1 34.3S-36.3 261.6 34.4 384c36.2 62.7 94.9 104.3 160.1 120.5c-11.5-15.8-18.4-35.4-18.4-56.5V403.5c-16-10.5-30.2-24-41.9-40.2L409.9 204.1c29.4 65.1 11.7 141.7-41.9 187.4V448c0 15.4-3.6 30-10.1 42.9c8.8-3.8 17.5-8.2 26.1-13.2zM128 160a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm112-8a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zm96 296V384H288v24H256V384H208v64c0 35.3 28.7 64 64 64s64-28.7 64-64zM152 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm144-56a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "tricycle": [512, 512, [], "e5c3", "M280 32H256V80h24 88v21l-47.6 40.8c-.8 .7-1.6 1.4-2.3 2.2H307.2c-58.8 0-114 23.9-154.1 64.6L133.6 176H136h24V128H136 56 32v48H56 77.6l44 73.4c-1.3 2.2-2.6 4.5-3.9 6.7c-1.9-.1-3.9-.1-5.8-.1C50.1 256 0 306.1 0 368s50.1 112 112 112s112-50.1 112-112c0-42.4-23.6-79.4-58.4-98.4c30.7-48.1 84-77.6 141.6-77.6h12.1l11 43.8C286.4 256.1 256 300.5 256 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-2.4 0-4.8 .1-7.2 .2l-13.9-55.6 44.7-38.3L416 123V112 56 32H392 280zm64.2 260l16.5 65.9 46.6-11.6-16.5-65.9c36.6 3.4 65.2 34.2 65.2 71.7c0 39.8-32.2 72-72 72s-72-32.2-72-72c0-25.1 12.8-47.1 32.2-60zM112 312a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "land-mine-on": [640, 512, [], "e51b", "M344 24V168v24H296V168 24 0h48V24zM69.7 132.3l104 72 19.7 13.7-27.3 39.5-19.7-13.7-104-72L22.6 158.1l27.3-39.5 19.7 13.7zm528 39.5l-104 72-19.7 13.7-27.3-39.5 19.7-13.7 104-72 19.7-13.7 27.3 39.5-19.7 13.7zM192 288H448v64H192V288zm-64 96H512l64 128H64l64-128z"],
    "square-arrow-up-left": [448, 512, [], "e263", "M448 32H0V480H448V32zM136 144H288h24v48H288 193.9L329 327l17 17L312 377.9l-17-17-135-135V328v24H112V328 168 144h24z"],
    "i-cursor": [256, 512, [], "f246", "M32 0c38.2 0 72.5 16.8 96 43.3C151.5 16.8 185.8 0 224 0h32V64H224c-35.3 0-64 28.7-64 64v96h32 32v64H192 160v96c0 35.3 28.7 64 64 64h32v64H224c-38.2 0-72.5-16.8-96-43.3C104.5 495.2 70.2 512 32 512H0V448H32c35.3 0 64-28.7 64-64V288H64 32V224H64 96V128c0-35.3-28.7-64-64-64H0V0H32z"],
    "chart-mixed-up-circle-dollar": [576, 512, [], "e5d9", "M400 0H368V64h32 28.8L319.4 151.5 211.2 70.4 191.4 55.5 172 71 12 199l40 50L192.6 136.5l108.2 81.1 19.3 14.5c4.4-3.6 9-7.1 13.8-10.3L340 217 480 105v39 32h64V144 32 0H512 400zM160 224V480h64V224H160zM32 320V480H96V320H32zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM408.1 339l0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2v10.8 16H416v-16V438.1c-8.6-1.7-16.7-4.3-23.7-6.6l0 0 0 0c-1.7-.6-3.4-1.1-5-1.6L372 425.2l9.5-30.6 15.3 4.8c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3V288 272h32v16 9.4c6.3 .9 12.3 2.3 17.9 3.7l15.5 3.9-7.7 31.1-15.5-3.9c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"],
    "salt-shaker": [384, 512, [129474], "e446", "M384 512l-8-64L335.9 127C326.8 54.5 265.1 0 192 0S57.2 54.5 48.1 127L8 448 0 512H64.5h255H384zm-72.5-64H72.5l32-256h175l32 256zM192 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM128 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM240 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "stamp": [512, 512, [], "f5bf", "M320 167.6c19.6-17.6 32-43.1 32-71.6c0-53-43-96-96-96s-96 43-96 96c0 28.4 12.4 54 32 71.6V256H112C50.1 256 0 306.1 0 368v48H32v32 64H96 416h64V448 416h32V368c0-61.9-50.1-112-112-112H320V167.6zM416 416v32H96V416H416z"],
    "file-plus": [384, 512, [], "f319", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM216 240v24 48h48 24v48H264 216v48 24H168V408 360H120 96V312h24 48V264 240h48z"],
    "draw-square": [448, 512, [], "f5ef", "M0 96C0 60.7 28.7 32 64 32c23.7 0 44.4 12.9 55.4 32H328.6c11.1-19.1 31.7-32 55.4-32c35.3 0 64 28.7 64 64c0 23.7-12.9 44.4-32 55.4V360.6c19.1 11.1 32 31.7 32 55.4c0 35.3-28.7 64-64 64c-23.7 0-44.4-12.9-55.4-32H119.4c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4V151.4C12.9 140.4 0 119.7 0 96zm96 55.4V360.6c9.7 5.6 17.8 13.7 23.4 23.4H328.6c5.6-9.7 13.7-17.8 23.4-23.4V151.4c-9.7-5.6-17.8-13.7-23.4-23.4H119.4c-5.6 9.7-13.7 17.8-23.4 23.4z"],
    "toilet-paper-under-slash": [640, 512, ["toilet-paper-reverse-slash"], "e2a1", "M528 512h48v0H224V416H406.2L528 512zm48-87.6l44.9 34.9 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L94.9 50.9C112 19.3 134.9 0 160 0H412.2C400.6 12.2 391 26.9 383.5 41.9C363.5 82 352 135.1 352 192c0 21.4 1.6 42.3 4.7 62.2l39.2 30.4c-7.6-27.5-11.9-59-11.9-92.6c0-83.6 26.7-154.7 64-181.1C458 3.8 468.8 0 480 0c53 0 96 86 96 192c0 35-4.7 67.8-12.8 96c-11.6 39.9-30.1 70.8-52.3 85.9L537 394.2c16.3-13.6 29.3-32 39-51.1v81.3zM64 192c0-15 .9-29.6 2.5-43.6L365.5 384H160c-53 0-96-86-96-192zm416 64c17.7 0 32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64s14.3 64 32 64z"],
    "stairs": [576, 512, [], "e289", "M384 32h32H544h32V96H544 448v96 32H416 320v96 32H288 192v96 32H160 32 0V416H32h96V320 288h32 96V192 160h32 96V64 32z"],
    "drone-front": [640, 512, ["drone-alt"], "f860", "M160 112V96H96v16H24 0v48H24 96v16 16 64 20.8l19 8.4 56.5 25.1-21.9 26.3-5.6 6.7V352v40 24h48V392 360.7l25.1-30.1L259 349.2l6.2 2.8H272h96 6.8l6.2-2.8 41.9-18.6L448 360.7V392v24h48V392 352v-8.7l-5.6-6.7-21.9-26.3L525 285.2l19-8.4V256 192 176 160h72 24V112H616 544V96H480v16H376 352v48h24H480v16 16 43.2l-17.8 7.9-40.6-23.7C390.7 201.5 355.7 192 320 192s-70.7 9.5-101.6 27.5l-40.6 23.7L160 235.2V192 176 160H264h24V112H264 160z"],
    "glass-empty": [384, 512, [], "e191", "M99.2 448H284.8l30-384H69.2l30 384zM344 512H40L5 64 0 0H64.2 319.8 384l-5 64L344 512z"],
    "dial-high": [576, 512, [], "e15c", "M320 0V64H256V0h64zM128 64v64H64V64h64zm384 0v64H448V64h64zm0 192h64v64H512V256zm0 192v64H448V448h64zM64 448h64v64H64V448zM0 256H64v64H0V256zM288.4 127.6c80.2 0 146.6 59 158.2 136H288.4h-24v48h24H446.6c-11.6 77-78 136-158.2 136c-88.4 0-160-71.6-160-160s71.6-160 160-160z"],
    "user-helmet-safety": [448, 512, [128119, "user-construction", "user-hard-hat"], "f82c", "M256 0H192V80L163.6 23.1C125.6 43.5 99 82.6 96.2 128H96 72v48H96 352h24V128H352h-.2C349 82.6 322.4 43.5 284.4 23.1L256 80V0zM224 320c65.3 0 119.1-48.9 127-112H97c7.9 63.1 61.7 112 127 112zM448 512L400 352H48L0 512H448z"],
    "i": [320, 512, [105], "49", "M32 32H0V96H32h96V416H32 0v64H32h96 64 96 32V416H288 192V96h96 32V32H288 192 160 128 32z"],
    "hryvnia-sign": [384, 512, [8372, "hryvnia"], "f6f2", "M114.2 123.1C131.5 105.7 155 96 179.5 96H223c27.1 0 49 21.9 49 49c0 11.5-4 22.4-11.1 31H0v64H155.5l-50.6 28.9c-1.7 1-3.4 2-5.1 3.1H0v64H52.3c-2.8 9.9-4.3 20.4-4.3 31c0 62.4 50.6 113 113 113h43.5c41.5 0 81.3-16.5 110.6-45.8l11.5-11.5-45.3-45.3-11.5 11.5C252.5 406.3 229 416 204.5 416H161c-27.1 0-49-21.9-49-49c0-11.5 4-22.4 11.1-31H384V272H228.5l50.6-28.9c1.7-1 3.4-2 5.1-3.1H384V176H331.7c2.8-10 4.3-20.4 4.3-31c0-62.4-50.6-113-113-113H179.5C138.1 32 98.3 48.5 68.9 77.8L57.4 89.4l45.3 45.3 11.5-11.5z"],
    "arrow-down-left-and-arrow-up-right-to-center": [512, 512, [], "e092", "M381.3 176L502.6 54.6 457.4 9.4 336 130.7V80 48H272V80 208v32h32H432h32V176H432 381.3zM80 272H48v64H80h50.7L9.4 457.4l45.3 45.3L176 381.3V432v32h64V432 304 272H208 80z"],
    "pills": [576, 512, [], "f484", "M112 96c-26.5 0-48 21.5-48 48V256h96V144c0-26.5-21.5-48-48-48zM0 144C0 82.1 50.1 32 112 32s112 50.1 112 112V368c0 61.9-50.1 112-112 112S0 429.9 0 368V144zM576 320c0 38.4-13.5 73.7-36.1 101.3L314.7 196.1C342.3 173.5 377.6 160 416 160c88.4 0 160 71.6 160 160zM416 480c-88.4 0-160-71.6-160-160c0-38.4 13.5-73.7 36.1-101.3L517.3 443.9C489.7 466.5 454.4 480 416 480z"],
    "face-grin-wide": [512, 512, [128515, "grin-alt"], "f581", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm.3-180.2c59.1 0 114.1-10.6 160.2-29C400.3 376.7 334.7 432 256.3 432s-144-55.3-160.2-129.2c46.2 18.3 101.2 29 160.2 29zM208 192c0 35.3-14.3 64-32 64s-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64zm128 64c-17.7 0-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64z"],
    "tooth": [448, 512, [129463], "f5c9", "M186.1 52.1C169.3 39.1 148.7 32 127.5 32C74.7 32 32 74.7 32 127.5v6.2c0 15.8 3.7 31.3 10.7 45.5L73 239.6l39.4 220.6 3.5 19.8H136h8 19.9l3.7-19.5L195.9 312h56.3l28.3 148.5 3.7 19.5H304h8 20.1l3.5-19.8L375 239.6l30.2-60.5c7.1-14.1 10.7-29.7 10.7-45.5v-2.1c0-55-44.6-99.6-99.6-99.6c-24.1 0-47.4 8.8-65.6 24.6l-3.2 2.8 32.1 25-19.6 25.3-37-28.8-37-28.8z"],
    "basketball-hoop": [640, 512, [], "f435", "M320 0C434 0 513.6 48.5 564.1 96.9c32.2 30.8 54.7 65.7 75.9 104.2V372.8L505.6 432.6 526.2 288H493.9l-7.2 50.3-22.9 160-2 13.7H448h-8-7.2l-4.8-5.3-44.2-49.5L340 506.6l-4.8 5.4H328 312h-7.2l-4.8-5.4-43.9-49.4-44.2 49.5-4.8 5.3H200h-8H178.1l-2-13.7-22.9-160L146.1 288H113.8l20.6 144.6L0 372.8V201.1c21.2-38.5 43.7-73.4 75.9-104.2C126.4 48.5 206 0 320 0zM178.4 288l5.2 36.6 44-36.6H178.4zm99.3 0l-1.2 1L320 337.6 363.4 289l-1.2-1H277.8zm134.5 0l44 36.6 5.2-36.6H412.3zM176 128H160v16 64H112 96v32h16 64H464h64 16V208H528 480V144 128H464 176zm272 32v48H192V160H448zM388 309.4l-46.6 52.2 42.4 47.5 52.7-59.3L388 309.4zm47.9 158l11.7-81.9-42.3 47.6 30.6 34.3zM320 385.6l-42.4 47.5L319.2 480h1.6l41.6-46.8L320 385.6zm-21.4-24L252 309.4l-48.5 40.3 52.7 59.3 42.4-47.5zM204.1 467.4l30.6-34.3-42.3-47.6 11.7 81.9z"],
    "objects-align-bottom": [512, 512, [], "e3bb", "M512 512V464L0 464l0 48 512 0zM64 384H224L224 0H64l0 384zm224 0l160 0 0-256H288l0 256z"],
    "v": [384, 512, [118], "56", "M-.2 32L162.1 459.4l7.8 20.6h44.2l7.8-20.6L384.2 32H315.7L192 357.8 68.3 32H-.2z"],
    "sparkles": [512, 512, [10024], "f890", "M384 64L416 0l32 64 64 32-64 32-32 64-32-64L320 96l64-32zM128 192L192 64l64 128 128 64L256 320 192 448 128 320 0 256l128-64zM416 320l32 64 64 32-64 32-32 64-32-64-64-32 64-32 32-64z"],
    "squid": [512, 512, [129425], "e450", "M396.3 26C430.3 16 468.6 7.2 512 0c-7.1 42.7-15.7 80.7-25.5 114.2l18.2 115.3 3.5 22.1-22.1-3.9-50.8-9C388.3 320.2 332.5 350 287.6 354.6l37.2 37.2c6.2 6.2 16.4 6.2 22.6 0l56.1-56.1c19-19 49.9-18.7 68.6 .7l27.5 28.6 9.5 9.9-8.3 10.9-2.5 3.3c-28.3 37-81 40.1-113.6 10.9L370 414.4c-18.7 18.7-49.1 18.7-67.9 0l-45.3-45.3L223 403.1l32.6 32.6c19.5 19.5 18.6 51.5-2.1 69.8l-2.8 2.5L229.4 484l2.8-2.5c6.9-6.1 7.2-16.8 .7-23.3l-56-56c-1.7 6.5-4.7 12.7-8.8 18.4l-20.1 27.3c-2.5 3.5-3.9 7.6-3.9 11.9c0 11.1 9 20.1 20.1 20.1H176h16v32H176 164.1c-28.8 0-52.1-23.3-52.1-52.1c0-11.1 3.6-21.9 10.1-30.9l20.1-27.3c6.8-9.2 5.8-22-2.3-30.1c-8.2-8.2-21.2-9.1-30.4-2.1l-26.2 20c-9 6.9-20.1 10.6-31.4 10.6C23.2 400 0 376.8 0 348.1L0 336l0-16H32l0 16v12.1c0 11 8.9 19.9 19.9 19.9c4.4 0 8.6-1.4 12-4.1l26.2-20c5.8-4.4 12.3-7.6 19.1-9.4L53.8 279.2c-6.4-6.4-16.7-6.2-22.9 .3L27.6 283 4.4 261l3.3-3.5c18.6-19.6 49.7-20 68.7-.9l33.4 33.4L143.8 256 98.5 210.7c-18.7-18.7-18.7-49.1 0-67.9L113 128.4C83.6 95.6 86.6 42.9 123.4 14.2l3.7-2.9 11-8.6 10 9.8 29 28.4c19.1 18.7 19.3 49.4 .4 68.3l-56.3 56.3c-6.2 6.2-6.2 16.4 0 22.6l36.3 36.3c4.7-45 34.7-100.8 116.4-147.9l-8.8-49.7L261.2 4.7l22.1 3.5L396.3 26zM200.9 280a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 64a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "leafy-green": [576, 512, [129388], "e41d", "M216.5 26.2C181.6-8.7 125-8.7 90.1 26.2c-15.4 15.4-24 35.1-25.8 55.3C49 83.9 34.3 91.1 22.4 102.9c-28.3 28.3-29.8 73.3-4.5 103.4v72.6L72.1 333l0 80.4L96 389.5V290.7l48-48v-96l66.1-66.1c2.8-15.4 8.4-29.8 16.2-42.7c-2.9-4.1-6.2-8-9.9-11.7zM549.9 183.9C566.2 164.4 576 139.4 576 112C576 50.1 525.9 0 464 0c-27.4 0-52.4 9.8-71.9 26.1C376.3 14.7 357 8 336 8c-50.2 0-91.4 38.5-95.6 87.6L176 160v96l-48 48v98.7L89.4 441.4 66.7 464 112 509.3l22.6-22.6L173.3 448H272l48-48h96l64.4-64.4c49.1-4.2 87.6-45.4 87.6-95.6c0-21-6.7-40.3-18.1-56.1zM486.6 112l-11.3 11.3L390.6 208H448h16v32H448 358.6l-59.3 59.3-48 48L240 358.6 217.4 336l11.3-11.3L272 281.4V192 176h32v16 57.4l36.7-36.7 112-112L464 89.4 486.6 112z"],
    "circle-arrow-up-right": [512, 512, [], "e0fc", "M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zm88 144H192 168v48h24 94.1L151 327l-17 17L168 377.9l17-17 135-135V328v24h48V328 168 144H344z"],
    "calendars": [512, 512, [], "e0d7", "M256 0H192V64H96v96H512V64H416V0H352V64H256V0zM96 192V416H512V192H96zM0 160V488v24H24 416V464H48V160H0z"],
    "bangladeshi-taka-sign": [384, 512, [], "e2e6", "M0 96H32c17.7 0 32 14.3 32 32v32H0v64H64V384c0 53 43 96 96 96h32c106 0 192-86 192-192V256c0-53-43-96-96-96H256v64h32c17.7 0 32 14.3 32 32v32c0 70.7-57.3 128-128 128H160c-17.7 0-32-14.3-32-32V224h64V160H128V128c0-53-43-96-96-96H0V96z"],
    "bicycle": [640, 512, [128690], "f206", "M312 32H288V80h24 25.7l34.6 64H222.9l-27.4-38-7.2-10H176 120 96v48h24 43.7l22.1 30.7-26.6 53.1c-10-2.5-20.5-3.8-31.2-3.8C57.3 224 0 281.3 0 352s57.3 128 128 128c65.3 0 119.1-48.9 127-112h49 13.7l7-11.8 84.8-143.5 21.7 40.1C402.4 276.3 384 312 384 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-13.5 0-26.5 2.1-38.7 6L373.1 44.6 366.3 32H352 312zM458.6 303.7l32.3 59.7 11.4 21.1 42.2-22.8-11.4-21.1-32.3-59.7c3.6-.6 7.4-.9 11.2-.9c39.8 0 72 32.2 72 72s-32.2 72-72 72s-72-32.2-72-72c0-18.6 7-35.5 18.6-48.3zM128 368h70.2c-7.3 32.1-36 56-70.2 56c-39.8 0-72-32.2-72-72s32.2-72 72-72c1.7 0 3.4 .1 5.1 .2l-26.5 53.1L128 368zm38.8-48l50.7-101.3 72.9 101.2-.1 .1H166.8zm90.6-128H365.9L317 274.8 257.4 192z"],
    "hammer-war": [384, 512, [], "f6e4", "M224 0V32 56.9L336 32h48V288H336L192 256 48 288H0V32H48L160 56.9V32 0h64zM192 288.8l32 7.1V480v32H160V480 295.9l32-7.1z"],
    "circle-d": [512, 512, [], "e104", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128h72c70.7 0 128 57.3 128 128s-57.3 128-128 128H184 160V360 152 128h24zm72 208c44.2 0 80-35.8 80-80s-35.8-80-80-80H208V336h48z"],
    "spider-black-widow": [512, 512, [], "f718", "M0 118.7v21.2l1.2 3.7 24 72L29 227l11.4 3.8L116.1 256 40.4 281.2 29 285l-3.8 11.4-24 72L0 372.1v21.2l39.2 13.1 7.6-22.8L67 323l84.2-28.1L79 367 67.7 378.4l6.2 14.8 40 96 9.2 22.2 44.3-18.5-9.2-22.2-33.8-81.2L160 353.9c1 52.1 43.6 94.1 96 94.1s95-41.9 96-94.1l35.7 35.7-33.8 81.2-9.2 22.2 44.3 18.5 9.2-22.2 40-96 6.2-14.8L433 367l-72.1-72.1L445 323l20.2 60.6 7.6 22.8L512 393.3V372.1l-1.2-3.7-24-72L483 285l-11.4-3.8L395.9 256l75.7-25.2L483 227l3.8-11.4 24-72 1.2-3.7V118.7l-39.2-13.1-7.6 22.8L445 189l-84.2 28.1L433 145l11.4-11.4-6.2-14.8-40-96L388.9 .6 344.6 19.1l9.2 22.2 33.8 81.2L336 174.1V160c0-38.7-27.5-71-64-78.4V128H240V81.6c-36.5 7.4-64 39.7-64 78.4v14.1l-51.7-51.7 33.8-81.2 9.2-22.2L123.1 .6l-9.2 22.2-40 96-6.2 14.8L79 145l72.1 72.1L67 189 46.8 128.4l-7.6-22.8L0 118.7zM216 288h80v16l-24 32 24 32v16H216V368l24-32-24-32V288z"],
    "staff-snake": [384, 512, ["rod-asclepius", "rod-snake", "staff-aesculapius"], "e579", "M208 511l0 1H176l0-1-1.5-47H136 96V384h40 36l-1-32H152c-53 0-96-43-96-96c0-47.6 34.6-87.1 80-94.7V256c0 8.8 7.2 16 16 16h16.5L164 128H136h-9.2c-4.5 18.4-21.1 32-40.8 32H0V96C0 69.5 21.5 48 48 48H58c1.1 0 2.3 0 3.4 .1c.9-.1 1.7-.1 2.6-.1h97.5L160 0h64l-1.5 48H288c53 0 96 43 96 96s-43 96-96 96H248V160h40c8.8 0 16-7.2 16-16s-7.2-16-16-16H248 220l-4.5 144H256c53 0 96 43 96 96s-43 96-96 96H240V384h16c8.8 0 16-7.2 16-16s-7.2-16-16-16H213l-5 159zM64 112a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "pear": [512, 512, [], "e20c", "M510.7 35.2l-17 17L457.9 88c33.9 49.8 28.8 118.3-15.4 162.5l-58.8 58.8c.2 3.5 .3 7.1 .3 10.7c0 106-86 192-192 192S0 426 0 320S86 128 192 128c3.6 0 7.2 .1 10.7 .3l58.8-58.8c44.2-44.2 112.6-49.3 162.5-15.4l35.9-35.9 17-17 33.9 33.9zM288 320c0 53-43 96-96 96v32c70.7 0 128-57.3 128-128H288z"],
    "head-side-cough-slash": [640, 512, [], "e062", "M448 325l46 35.7c6.5 1.7 11.9 6 15 11.7l46.1 35.8c8.7 1.1 16 7 19.2 14.9L616.7 456c10.7 .3 19.6 7.6 22.4 17.4l.8 .6-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7 40 31.1C126.1 17.1 173.2 0 224.3 0H256C358.1 0 441.6 79.7 447.7 180.3L505 252l7 8.8V272v16 32H480 448v5zM0 224.3c0-38.7 9.8-75.2 27.1-107L341.8 365.3 320 368v40l82.5 5.2L448 449v31H320v32H288 256 96 64V480 381.2C23 339.3 0 283 0 224.3zM616 360a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-64-48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40-24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "triangle": [512, 512, [9650], "f2ec", "M0 480L256 32 512 480H0z"],
    "apartment": [576, 512, [], "e468", "M448 0H128V96H0V512H128h32 96V384h64V512h96 32H576V192H448V0zM320 320V256h64v64H320zm192 96H448V352h64v64zM64 320V256h64v64H64zm64 96H64V352h64v64zm64-96V256h64v64H192zM384 64v64H320V64h64zM192 64h64v64H192V64zM384 224H320V160h64v64zm64 96V256h64v64H448zM128 224H64V160h64v64zm64 0V160h64v64H192z"],
    "truck-medical": [640, 512, [128657, "ambulance"], "f0f9", "M416 0H0V416H64c0 53 43 96 96 96s96-43 96-96H384c0 53 43 96 96 96s96-43 96-96h32 32V352H608V288 256 224 210.7l-9.4-9.4-96-96L493.3 96H480 416V0zM544 240v16H416V160h48 2.7L544 237.3V240zM160 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm272 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM176 64h64v64h64v64H240v64H176V192H112V128l64 0V64z"],
    "pepper": [512, 512, [129745], "e432", "M191.6 36.7c0 0 0 0 0 0l0 0 0 0 0 0s0 0 16.4-17.5S224.4 1.7 224.4 1.7l0 0 0 0 .1 .1 .2 .2 .6 .6c.5 .5 1.1 1.1 2 2c1.6 1.7 3.8 4 6.4 7c5.1 5.9 11.9 14.5 18.7 25.4c10.3 16.4 21 38.8 25.5 65.4m0 0c17.7-6.8 37.6-8.4 57.4-3.4c10.5 2.6 20.1 6.9 28.7 12.4c21.5-13.8 48.5-19.1 75.3-12.4c51.4 12.9 82.7 65 69.8 116.4l-56 224c-12.9 51.4-65 82.7-116.4 69.8c-10.5-2.6-20.1-6.9-28.7-12.4c-5.7 3.7-11.8 6.8-18.4 9.2c-10.6 4-21.9 6.1-33.5 6.1c-11.8 0-23.3-2.1-34-6.2c-6.5-2.4-12.5-5.5-18.2-9.1c-8.6 5.5-18.2 9.8-28.7 12.4C123.8 522 71.7 490.7 58.9 439.3l-56-224C-10 163.8 21.3 111.7 72.7 98.9c14.4-3.6 28.8-3.7 42.4-1C84.2 128.6 72.1 176 83.8 223l41 163.8 31-7.8-41-163.8C102 163.8 125.3 111.7 176.7 98.9c4-1 7.9-1.7 11.9-2.2c8.3-1 16.5-.9 24.5 .2c.5 .1 .9 .1 1.4 .2c4.7 .7 9.3 1.8 13.9 3.2c-3.8-14.5-10.1-27.4-16.7-37.9c-5.2-8.4-10.4-15-14.3-19.4c-1.9-2.2-3.5-3.9-4.5-4.9c-.5-.5-.9-.9-1.1-1.1l-.2-.2"],
    "piano": [512, 512, [], "f8d4", "M0 192V512H512V288L384 224V192C384 86 298 0 192 0S0 86 0 192zM416 352h32v96H64V352H96v48 16h32V400 352h32v48 16h32V400 352h32v48 16h32V400 352h64v48 16h32V400 352h32v48 16h32V400 352z"],
    "gun-squirt": [576, 512, [], "e19d", "M128 32V56v8H512h32V96v32h32v64H544v32 32H512 248l-18 72h42V312 288h48v24 40 40 24H272V392 376H218L192 480H32L88.1 255.7C38.8 251.7 0 210.4 0 160c0-47.6 34.6-87.1 80-94.7V56 32h48zm352 96H64v64H480V128z"],
    "wheat-awn-circle-exclamation": [640, 512, [], "e598", "M489 57l17-17L472 6.1 455 23 383 95l-17 17L400 145.9l17-17 72-72zM316.8 38.6L294.1 16 271.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-22.6-22.6-22.6 22.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8L90.5 219.6 67.9 242.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L25.4 441.4 2.7 464 48 509.3l22.6-22.6 52.9-52.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l22.6-22.6-22.6-22.6c-21.8-21.8-49.6-34.1-78.1-36.9l31.9-31.9 12.2 12.2c22.5 22.5 53.3 31.5 82.5 27c0-1 0-2.1 0-3.1c0-33.1 9.1-64.1 25-90.5c-15.5-8.7-32.5-13.8-49.8-15.5l31.9-31.9 12.2 12.2c6 6 12.6 11.1 19.7 15.2c27.5-34 67.3-57.5 112.6-63.8c-4.1-3.8-8.4-7.3-12.9-10.5L489 153l17-17L472 102.1l-17 17-43.4 43.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L393 57l17-17L376 6.1 359 23 329.1 52.9c-3.7-5-7.8-9.8-12.4-14.3zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64H480V416h32v32zm0-176v16 80 16H480V368 288 272h32z"],
    "snowman": [512, 512, [9731, 9924], "f7d0", "M352 96c0 18.7-5.4 36.2-14.7 51c9.3 9.8 16.8 21.3 22.1 34L408 160.2V120 96h48v24 19.6l22.5-9.7 22.1-9.5 18.9 44.1-22.1 9.5-56 24-73.6 31.5c-.6 11.8-3 23.1-6.9 33.6C394.7 292.6 416 335.8 416 384c0 52.3-25.1 98.8-64 128H160c-38.9-29.2-64-75.7-64-128c0-48.2 21.3-91.4 55.1-120.8c-3.9-10.5-6.3-21.8-6.9-33.6L70.5 198.1l-56-24-22.1-9.5 18.9-44.1 22.1 9.5L56 139.6V120 96h48v24 40.2L152.6 181c5.3-12.7 12.8-24.2 22.1-34c-9.3-14.8-14.7-32.3-14.7-51c0-53 43-96 96-96s96 43 96 96zM272 272H240v32h32V272zm0 96V336H240v32h32zM240 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-48 24v.3c0 2.9 .8 5.8 2.3 8.3L256 152l13.7-23.4c1.5-2.5 2.3-5.4 2.3-8.3V120c0-8.8-7.2-16-16-16s-16 7.2-16 16zm32 88H240v32h32V208z"],
    "user-alien": [448, 512, [], "e04a", "M64 167C64 74.8 135.6 0 224 0s160 74.8 160 167c0 119.3-160 217-160 217s-160-97.7-160-217zm80 9H128 112v16c0 35.3 28.7 64 64 64h16 16V240c0-35.3-28.7-64-64-64zm96 64v16h16 16c35.3 0 64-28.7 64-64V176H320 304c-35.3 0-64 28.7-64 64zM400 352l48 160H0L48 352h80l96 72 96-72h80z"],
    "shield-check": [512, 512, [], "f2f7", "M256 0l11.6 4.5L475.1 85l19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9c-32.7 75.2-91.1 150-189.4 192.6L256 512l-12.7-5.5C144.9 463.9 86.5 389.2 53.9 313.9C21.4 239.3 13.6 162.9 16.6 113l1.2-20.5L36.9 85 244.4 4.5 256 0zM369 209l17-17L352 158.1l-17 17-111 111-47-47-17-17L126.1 256l17 17 64 64 17 17 17-17L369 209z"],
    "mortar-pestle": [512, 512, [], "f5a7", "M469.5 0L252.3 160H397.3L510.1 47.2 469.5 0zM32 192H0v64H32c0 82.5 43.4 147.7 123.9 176.2C138.4 454.1 128 481.8 128 512H384c0-30.2-10.4-57.9-27.9-79.8C436.6 403.7 480 338.5 480 256h32V192H480 32z"],
    "road-barrier": [640, 512, [], "e562", "M64 64V32H0V64 448v32H64V448 266.3L149.2 96H64V64zm576 0V32H576V64v53.7L490.8 288H576V448v32h64V448 64zM330.8 96l-5.4 10.7L234.8 288h74.3l5.4-10.7L405.2 96H330.8zM437.2 288l5.4-10.7L533.2 96H458.8l-5.4 10.7L362.8 288h74.3zM277.2 96H202.8l-5.4 10.7L106.8 288h74.3l5.4-10.7L277.2 96z"],
    "chart-candlestick": [512, 512, [], "e0e2", "M64 64V32H0V64 448v32H32 480h32V416H480 64V64zM320 48V32H288V48 96H256V256h32v48 16h32V304 256h32V96H320V48zm64 144V320h32v48 16h32V368 320h32V192H448V144 128H416v16 48H384zM224 128H192V80 64H160V80v48H128V320h32v48 16h32V368 320h32V128z"],
    "briefcase-blank": [512, 512, [], "e0c8", "M152 0H128V24 96H0V480H512V96H384V24 0H360 152zM336 96H176V48H336V96z"],
    "school": [640, 512, [127979], "f549", "M640 512H384V416c0-35.3-28.7-64-64-64s-64 28.7-64 64v96H0V96H160L320 0 480 96H640V512zM144 192H80v96h64V192zm352 0v96h64V192H496zM144 320H80v96h64V320zm352 0v96h64V320H496zM408 176a88 88 0 1 0 -176 0 88 88 0 1 0 176 0zm-72-48v16 16h16 16v32H352 320 304V176 144 128h32z"],
    "igloo": [576, 512, [], "f7ae", "M320 33.8V160H48.5C100.2 82.8 188.1 32 288 32c10.8 0 21.5 .6 32 1.8zM352 160V39.1C424.9 55.7 487.2 99.8 527.5 160H352zM29.9 192H96V320H0c0-46 10.8-89.4 29.9-128zM192 320H128V192H448V320H384v32H576V480H352V352c0-35.3-28.7-64-64-64s-64 28.7-64 64V480H0V352H192V320zm288 0V192h66.1c19.2 38.6 29.9 82 29.9 128H480z"],
    "bracket-round": [192, 512, ["parenthesis"], "28", "M0 256C0 140.2 71.9 62.9 110.2 37.4l35.5 53.3C120.1 107.7 64 167 64 256s56.1 148.3 81.8 165.4l-35.5 53.3C71.9 449.1 0 371.8 0 256z"],
    "joint": [640, 512, [], "f595", "M384 0h64V43c0 38.2 15.2 74.8 42.2 101.8l21 21c21 21 32.8 49.5 32.8 79.2v43H480V245c0-12.7-5.1-24.9-14.1-33.9l-21-21C405.9 151.1 384 98.1 384 43V0zM640 288H576V245c0-38.2-15.2-74.8-42.2-101.8l-21-21c-21-21-32.8-49.5-32.8-79.2V0h64V43c0 12.7 5.1 24.9 14.1 33.9l21 21c39 39 60.9 91.9 60.9 147.1v43zM0 432s89.6-64 234.6-77.5L365.8 512H288C112 512 0 432 0 432zm464 80H407.5L274.3 352.2c4.5-.1 9.1-.2 13.7-.2h48 56.5L525.8 512H464zm103.5 0L434.2 352H640V512H624 567.5z"],
    "horse-saddle": [576, 512, [], "f8c3", "M448 160v78.1V240h0c-.5 30-12.8 56.4-32 75.7V512H320V346.7c-4.1-.7-8.2-1.6-12.3-2.8L256 329.1V256h48 16V240 128C320 57.3 377.3 0 448 0h32 80 16V32H560 544l32 32V192l-80 32-32-64H448zM224 256v64 8 8 19.9l-14.1 14.1-27 27 38.3 115H120.1L82.5 399.2 73.1 371l21-21 26.6-26.6L78.2 259.9c-7.3-11-11.9-23.4-13.6-36.4C54.6 230.8 48 242.6 48 256v56 24H0V312 256c0-44.6 33.2-81.5 76.3-87.2c11.4-18.7 29.9-32.7 51.7-38.2V240v16h16 80zm-64-32V128h43.2H256h32v96H160zM512 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "mug-marshmallows": [512, 512, [], "f7b7", "M32 32H226.7l-73.4 73.4L130.7 128H32V32zm240 0l96 96H176l96-96zM0 160H96v96h64V160H352h32 16c61.9 0 112 50.1 112 112s-50.1 112-112 112H384v96H0V160zm384 64v96h16c26.5 0 48-21.5 48-48s-21.5-48-48-48H384z"],
    "filters": [640, 512, [], "e17e", "M192 96L352 256V384l128 96V256L640 96V32H192V96zM0 96v64L160 320v96l128 96V320l32-32V269.3L169.4 118.6l-9.4-9.4V96H0z"],
    "bell-on": [640, 512, [128365], "f8fa", "M352 0H288V51.2C215 66 160 130.6 160 208v88L96 368v48H544V368l-64-72V208c0-77.4-55-142-128-156.8V0zm32 448H320 256c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7s18.7-28.3 18.7-45.3zM0 176v48H24h80 24V176H104 24 0zm536 0H512v48h24 80 24V176H616 536zM608.2 50.7L586.7 7.8 565.3 18.5l-64 32L479.8 61.3l21.5 42.9 21.5-10.7 64-32 21.5-10.7zM53.3 61.5l64 32 21.5 10.7 21.5-42.9L138.7 50.5l-64-32L53.3 7.8 31.8 50.7 53.3 61.5z"],
    "angle-right": [320, 512, [8250], "f105", "M301.3 256l-22.6 22.6-160 160L96 461.3 50.7 416l22.6-22.6L210.7 256 73.4 118.6 50.7 96 96 50.7l22.6 22.6 160 160L301.3 256z"],
    "dial-med": [576, 512, [], "e15f", "M320 0V64H256V0h64zM128 64v64H64V64h64zm384 0v64H448V64h64zm0 192h64v64H512V256zm0 192v64H448V448h64zM64 448h64v64H64V448zM0 256H64v64H0V256zm128 31.2C128 207 187 140.6 264 129l0 158.2v24l48 0v-24L312 129c77 11.6 136 78 136 158.2c0 88.4-71.6 160-160 160s-160-71.6-160-160z"],
    "horse": [576, 512, [128014], "f6f0", "M448 238.1V160h16l32 64 80-32V64L544 32h16 16V0H560 480 448C377.3 0 320 57.3 320 128H256 203.2 148.8c-30.7 0-57.6 16.3-72.5 40.8C33.2 174.5 0 211.4 0 256v56 24H48V312 256c0-13.4 6.6-25.2 16.7-32.5c1.6 13 6.3 25.4 13.6 36.4l42.4 63.6L94.1 350.1l-21 21 9.4 28.1L120.1 512H221.3L182.9 397l27-27L224 355.9V336 320l83.7 23.9c4.1 1.2 8.2 2.1 12.3 2.8V512h96V315.7c19.2-19.2 31.5-45.7 32-75.7h0v-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "q": [448, 512, [113], "51", "M64 256c0 88.4 71.6 160 160 160c25.3 0 49.2-5.9 70.5-16.3L194.9 256h77.9l72.4 104.5c24.2-28 38.8-64.5 38.8-104.5c0-88.4-71.6-160-160-160S64 167.6 64 256zM331.3 452.7C299.4 470.1 262.9 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32s224 100.3 224 224c0 61.8-25 117.8-65.5 158.3l66.2 95.5 1.5 2.2H372.4l-41.1-59.3z"],
    "monitor-waveform": [576, 512, ["monitor-heart-rate"], "f611", "M576 32H0V480H576V32zM80 96H496h16v16V400v16H496 80 64V400 272 112 96H80zM96 256h96 8.6l4.8 7.1L223 289.6l51.2-89.5 14.8-26 13.4 26.7L329.9 256H400h16v32H400 320h-9.9l-4.4-8.8-18.6-37.3-49.2 86L225 350.4l-14.4-21.5L183.4 288H96v96H480V128H96V256z"],
    "link-simple": [576, 512, [], "e1cd", "M0 256C0 167.6 71.6 96 160 96h64 32v64H224 160c-53 0-96 43-96 96s43 96 96 96h64 32v64H224 160C71.6 416 0 344.4 0 256zm576 0c0 88.4-71.6 160-160 160H352 320V352h32 64c53 0 96-43 96-96s-43-96-96-96H352 320V96h32 64c88.4 0 160 71.6 160 160zM192 224H384h32v64H384 192 160V224h32z"],
    "whistle": [640, 512, [], "f460", "M0 128c0 28.4 18.5 52.5 44.1 60.8C36.3 209.7 32 232.4 32 256c0 106 86 192 192 192c64.9 0 122.3-32.2 157-81.5L544 448l96-112L492.2 221.5 448 248l-32-24 13.8-50.8L352.2 113c-6.9-6.2-14.3-11.9-22-17C299.8 75.8 263.3 64 224 64c-38.8 0-74.8 11.5-105 31.2C107.8 76.5 87.4 64 64 64C28.7 64 0 92.7 0 128zm224 64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM48 128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "g": [448, 512, [103], "47", "M224 96C135.6 96 64 167.6 64 256s71.6 160 160 160c77.4 0 142-55 156.8-128H224V224H416h32v32c0 123.7-100.3 224-224 224S0 379.7 0 256S100.3 32 224 32c70.8 0 134 32.9 175 84.1l-50 40C319.6 119.4 274.6 96 224 96z"],
    "wine-glass-crack": [320, 512, ["fragile"], "f4bb", "M14.5 192.7L32 0h0H136l32 48L80 104 200 224 160 120l80-56L208 0h80 0l17.5 192.7C312.3 267.3 262 332.9 192 348.5V448h80v64H160 48V448h80V348.5C58 332.9 7.7 267.3 14.5 192.7z"],
    "slot-machine": [640, 512, [], "e3ce", "M448 0H64V64H448V0zm64 96H0V416H64v96H416h32H592h32V480 211.8c9.8-8.8 16-21.6 16-35.8c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 14.2 6.2 27 16 35.8V448H448V416h64V96zM80 176h72 24v24 8 5.3l-2.2 4.8L119.4 336H66.5l3.7-8.1 48-103.9H80 56V176H80zM263.4 336H210.5l3.7-8.1 48-103.9H224 200V176h24 72 24v24 8 5.3l-2.2 4.8L263.4 336zm144 0H354.5l3.7-8.1 48-103.9H368 344V176h24 72 24v24 8 5.3l-2.2 4.8L407.4 336z"],
    "notes-medical": [512, 512, [], "f481", "M96 416V32H480V320l-96 96H96zM320 128H256v64H192v64h64v64h64V256h64V192H320V128zM296 464h24v48H296 24 0V488 152 128l48 0v24l0 312H296z"],
    "car-wash": [448, 512, [], "f5e6", "M64 128c-26.5 0-48-21.5-48-48C16 48 64 0 64 0s48 48 48 80s-21.5 48-48 48zm160 0c-26.5 0-48-21.5-48-48c0-32 48-80 48-80s48 48 48 80s-21.5 48-48 48zM432 80c0 32-21.5 48-48 48s-48-21.5-48-48c0-32 48-80 48-80s48 48 48 80zM106.9 160H128 320h21.1l8.3 19.4L396 288h36v96 64 64H352V448H96v64H16V448 384 288H52L98.6 179.4l8.3-19.4zm192 64H149.1l-27.4 64H326.3l-27.4-64zM96 392a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm280-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "escalator": [640, 512, [], "e171", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM424 160h24 96 64V288H544 472L234.1 496.2 216 512H192 96 32V384H96h72L405.9 175.8 424 160zM320 128v80.4l-128 112V128H320z"],
    "comment-image": [512, 512, [], "e148", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM192 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 288v32H416V288L296 144 195.5 264.6 160 224 96 288z"],
    "temperature-half": [320, 512, [127777, "temperature-2", "thermometer-2", "thermometer-half"], "f2c9", "M112 300.2L97.8 317.8C86.6 331.5 80 348.9 80 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-19.1-6.6-36.5-17.8-50.3L208 300.2V277.5 64H112V277.5v22.7zM208 0h64V64 277.5c20 24.7 32 56.2 32 90.5c0 79.5-64.5 144-144 144S16 447.6 16 368c0-34.3 12-65.8 32-90.5V64 0h64 96zm0 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V208 192h32v16V322.8c18.6 6.6 32 24.4 32 45.3z"],
    "dong-sign": [384, 512, [], "e169", "M320 32H256V64H192v64h64v49.1c-18.8-10.9-40.7-17.1-64-17.1c-70.7 0-128 57.3-128 128s57.3 128 128 128c23.3 0 45.2-6.2 64-17.1V416h64V288 128h32V64H320V32zM128 288a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM384 512V448H0v64H384z"],
    "donut": [512, 512, [127849, "doughnut"], "e406", "M0 208C0 119.6 114.6 48 256 48s256 71.6 256 160v24 16 22.1l-55.2 27.6-2.3 1.2-1.8 1.8-44 44-74.3 7.4-1.5 .2-1.5 .4L256 375.3l-75.4-22.6-1.5-.4-1.5-.2-74.3-7.4-44-44-1.8-1.8-2.3-1.2L0 270.1V248 232 208zm0 97.9l38.5 19.3 46.2 46.2 4 4 5.7 .6 78.5 7.8 78.5 23.6 4.6 1.4 4.6-1.4 78.5-23.6 78.5-7.8 5.7-.6 4-4 46.2-46.2L512 305.9C510.4 393.4 396.4 464 256 464S1.6 393.4 0 305.9zM283.3 107.3L294.6 96 272 73.4 260.7 84.7l-16 16L233.4 112 256 134.6l11.3-11.3 16-16zm-112 16L182.6 112 160 89.4l-11.3 11.3-32 32L105.4 144 128 166.6l11.3-11.3 32-32zm224 9.4L384 121.4 361.4 144l11.3 11.3 32 32L416 198.6 438.6 176l-11.3-11.3-32-32zM64 192H48v32H64 96h16V192H96 64zm331.3 36.7L384 217.4 361.4 240l11.3 11.3 32 32L416 294.6 438.6 272l-11.3-11.3-32-32zm-240 16L144 233.4 121.4 256l11.3 11.3 32 32L176 310.6 198.6 288l-11.3-11.3-32-32zm176 38.6L342.6 272 320 249.4l-11.3 11.3-32 32L265.4 304 288 326.6l11.3-11.3 32-32zM320 192c0-17.7-28.7-32-64-32s-64 14.3-64 32s28.7 32 64 32s64-14.3 64-32z"],
    "capsules": [576, 512, [], "f46b", "M64 144c0-26.5 21.5-48 48-48s48 21.5 48 48V256H64V144zM0 144V368c0 61.9 50.1 112 112 112s112-50.1 112-112V189.6c1.8 19.1 8.2 38 19.8 54.8L372.3 431.7c35.5 51.7 105.3 64.3 156 28.1s63-107.5 27.5-159.2L427.3 113.3C391.8 61.5 321.9 49 271.3 85.2c-28 20-44.3 50.8-47.3 83V144c0-61.9-50.1-112-112-112S0 82.1 0 144zm296.6 64.2c-16-23.3-10-55.3 11.9-71c21.2-15.1 50.5-10.3 66 12.2l67 97.6L361.6 303l-65-94.8zM491 407.7c-.8 .6-1.6 1.1-2.4 1.6l4-2.8c-.5 .4-1 .8-1.6 1.2z"],
    "poo-storm": [448, 512, ["poo-bolt"], "f75a", "M208 0c64 0 112 43 112 96c0 11.2-1.9 22-5.5 32H320c35.3 0 64 28.7 64 64c0 12.7-3.7 24.6-10.1 34.5c42.5 9.9 74.1 48 74.1 93.5v64H352V320H275.5l40-128h-51L64 344.3V384H0V320c0-45.5 31.6-83.6 74.1-93.5C67.7 216.6 64 204.7 64 192c0-35.3 28.7-64 64-64h32C272 96 208 0 208 0zM184 384H96V360L272 224 232 352h88v24L144 512l40-128z"],
    "tally-1": [640, 512, [], "e294", "M160 32V64 448v32H96V448 64 32h64z"],
    "face-frown-open": [512, 512, [128550, "frown-open"], "f57a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM255.6 368c-38.7 0-74.5 11.4-103.6 30.6c4.7-53 49.3-94.6 103.6-94.6s98.8 41.6 103.6 94.6C330.1 379.4 294.3 368 255.6 368z"],
    "square-dashed": [448, 512, [], "e269", "M32 32h96V96H64v64H0V64 32H32zM0 192H64V320H0V192zm384 0h64V320H384V192zm64-32H384V96H320V32h96 32V64v96zm0 192v96 32H416 320V416h64V352h64zM64 352v64h64v64H32 0V448 352H64zM288 480H160V416H288v64zM160 96V32H288V96H160z"],
    "square-j": [448, 512, [], "e273", "M448 32H0V480H448V32zM304 152V288c0 53-43 96-96 96s-96-43-96-96v-8V256h48v24 8c0 26.5 21.5 48 48 48s48-21.5 48-48V152 128h48v24z"],
    "hand-point-up": [384, 512, [9757], "f0a6", "M32 0H96V240H32V0zM224 160h64V288H224V160zm-32-32V240H128V128h64zm128 64h64V320H320V192zM0 363V272H192v48 32H96 80v32H96 208h16V368 320h64v32h96c0 88.4-71.6 160-160 160H162.3c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363z"],
    "money-bill": [576, 512, [], "f0d6", "M576 64H0V448H576V64zM128 384H64V320c35.3 0 64 28.7 64 64zM64 192V128h64c0 35.3-28.7 64-64 64zM448 384c0-35.3 28.7-64 64-64v64H448zm64-192c-35.3 0-64-28.7-64-64h64v64zM288 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "arrow-up-big-small": [576, 512, ["sort-size-up"], "f88e", "M320 32V256H544V32H320zm0 288V480H480V320H320zM183.7 58.5L160 32.4l-23.7 26-80 88L34.8 170.2l47.4 43.1 21.5-23.7L128 162.8V448v32h64V448 162.8l24.3 26.8 21.5 23.7 47.4-43.1-21.5-23.7-80-88z"],
    "barcode-read": [576, 512, [], "f464", "M24 0H0V24 160H48V48H160V0H24zM192 384V128H128V384h64zM352 128H288V384h64V128zm96 0H384V384h64V128zM576 0H552 416V48H528V160h48V24 0zM24 512H160V464H48V352H0V488v24H24zm552 0V488 352H528V464H416v48H552h24zM256 128H224V384h32V128z"],
    "baguette": [640, 512, [129366], "e3d8", "M583 234.5c58.8-39.2 74.7-118.7 35.5-177.5S499.8-17.7 441 21.5L356.5 77.8l70.8 70.8L438.6 160 416 182.6l-11.3-11.3L329.3 96l-88 58.7 74 74L326.6 240 304 262.6l-11.3-11.3-78.6-78.6-88 58.7 77.2 77.2L214.6 320 192 342.6l-11.3-11.3L98.9 249.6 57 277.5C-1.8 316.7-17.7 396.2 21.5 455s118.7 74.7 177.5 35.5l384-256z"],
    "bowl-soft-serve": [512, 512, [], "e46b", "M288 0H256l10.8 16.3c3.4 5 5.2 11 5.2 17c0 17-13.7 30.7-30.7 30.7H160c-35.3 0-64 28.7-64 64c0 11.7 3.1 22.6 8.6 32H96c-35.3 0-64 28.7-64 64v64H480V224c0-35.3-28.7-64-64-64h-8.6c5.4-9.4 8.6-20.3 8.6-32C416 57.3 358.7 0 288 0zM64 320H48v16 8c0 57.4 46.6 104 104 104h32l-24 64H352l-24-64h32c57.4 0 104-46.6 104-104v-8V320H448 64z"],
    "face-holding-back-tears": [512, 512, [129401], "e482", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM256 432c55.6 0 88.4-37 98.3-56.8l-28.6-14.3C319.6 373 296.4 400 256 400s-63.6-27-69.7-39.2l-28.6 14.3C167.6 395 200.4 432 256 432zM240 272V240c0-41.5-31.5-75.6-72-79.6c10-10.8 17.6-24.1 21.9-38.8l1.5-5.2 4.4-15.4L165 92.2l-4.4 15.4-1.5 5.2c-7 24.7-28.1 42.7-53.6 45.9L94 160.1l-15.9 2 4 31.8 13.8-1.7C85.9 205.5 80 222.1 80 240c0 18 6 34.6 16 48v32 16h32V320v-6.7c9.8 4.3 20.6 6.7 32 6.7c18 0 34.6-6 48-16v16h32V304 288 272zm144 41.3V320v16h32V320 288c10-13.4 16-30 16-48c0-17.9-5.9-34.5-15.9-47.9l13.8 1.7 4-31.8-15.9-2-11.5-1.4c-25.5-3.2-46.6-21.3-53.6-45.9l-1.5-5.2L347 92.2 316.2 101l4.4 15.4 1.5 5.2c4.2 14.8 11.8 28 21.9 38.8c-40.4 4-72 38.1-72 79.6c0 44.2 35.8 80 80 80c11.4 0 22.2-2.4 32-6.7zM128 232c17.7 0 32-14.3 32-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4c17.7 0 32-14.3 32-32z"],
    "square-up": [448, 512, [11014, "arrow-alt-square-up"], "f353", "M448 32H0V480H448V32zM352 256H272V384H176V256H96V224L224 96 352 224v32z"],
    "train-subway-tunnel": [512, 512, ["subway-tunnel"], "e2a3", "M0 256C0 114.6 114.6 0 256 0S512 114.6 512 256V512H406.6l-64-64H400V128H112V448h57.4l-64 64H0V256zM297.4 448l64 64H150.6l64-64h82.7zM240 192V320H160V192h80zm32 128V192h80V320H272zm-88 32a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm120 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "square-exclamation": [448, 512, ["exclamation-square"], "f321", "M448 32H0V480H448V32zM248 128v24V264v24H200V264 152 128h48zM200 320h48v48H200V320z"],
    "semicolon": [192, 512, [], "3b", "M160 64V192H32V64H160zM16 512L48 288H160L80 512H16z"],
    "bookmark": [384, 512, [128278, 61591], "f02e", "M0 512L192 400 384 512V0H0V512z"],
    "fan-table": [448, 512, [], "e004", "M256 413.6C355.7 398.2 432 312 432 208C432 93.1 338.9 0 224 0S16 93.1 16 208c0 104 76.3 190.2 176 205.6V448H96 64v64H96 224 352h32V448H352 256V413.6zM178.9 53.7L224.3 166c18.5-25.3 50-39.8 83.3-35.1c48.1 6.8 81.7 51.3 74.9 99.4l-2.2 15.8-120-16.9c12.6 28.7 9.5 63.2-11.2 89.7c-29.9 38.3-85.2 45.1-123.5 15.2l-12.6-9.8 74.6-95.5c-31.2-3.4-59.5-23.4-72.1-54.5C97.2 129.1 119 77.9 164.1 59.7l14.8-6zM224 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "align-justify": [448, 512, [], "f039", "M448 32H0V96H448V32zm0 256H0v64H448V288zM0 160v64H448V160H0zM448 416H0v64H448V416z"],
    "battery-low": [576, 512, ["battery-1"], "e0b1", "M480 160V352H64V160H480zM64 96H0v64V352v64H64 480h64V352 320h32V192H544V160 96H480 64zm96 96H96V320h64V192z"],
    "credit-card-front": [576, 512, [], "f38a", "M0 32H576V480H0V32zM480 288H96v32H480V288zM96 352v32h96V352H96zm128 0v32H384V352H224zM512 96H384v96H512V96z"],
    "brain-arrow-curved-right": [640, 512, ["mind-share"], "f677", "M240 0V56 456v56H184c-28.9 0-52.7-21.9-55.7-50.1c-5.2 1.4-10.7 2.1-16.3 2.1c-35.3 0-64-28.7-64-64c0-7.4 1.3-14.6 3.6-21.2C21.4 367.4 0 338.2 0 304c0-31.9 18.7-59.5 45.8-72.3C37.1 220.8 32 207 32 192c0-30.7 21.6-56.3 50.4-62.6C80.8 123.9 80 118 80 112c0-29.9 20.6-55.1 48.3-62.1C131.3 21.9 155.1 0 184 0h56zm32 0h56c28.9 0 52.6 21.9 55.7 49.9c27.8 7 48.3 32.1 48.3 62.1c0 6-.8 11.9-2.4 17.4c28.8 6.2 50.4 31.9 50.4 62.6c0 15-5.1 28.8-13.8 39.7c4.9 2.3 9.5 5.1 13.8 8.3v32H448c-79.5 0-144 64.5-144 144c0 42.7 21.1 74 40.3 93.6c-5.2 1.6-10.7 2.4-16.3 2.4H272V456 56 0zM528 240L640 352 528 464H512V400H464c-35.3 0-64 28.7-64 64v48s-64-32-64-96c0-61.9 50.1-112 112-112h64V240h16z"],
    "umbrella-beach": [576, 512, [127958], "f5ca", "M346.3 271.8l-60.1-21.9L214 448H32 0v64H32 544h32V448H544 282.1l64.1-176.2zm121.1-.2l-3.3 9.1 101.7 37c20.7-90.4-9.7-183.3-75.2-244.3c2 8 3.2 16.3 3.4 24.8l.2 6c1.8 57-7.3 113.8-26.8 167.4zM462 99.1c-1.1-34.4-22.5-64.8-54.4-77.4c-.9-.4-1.9-.7-2.8-1.1c-33-11.7-69.8-2.4-93.1 23.8l-4 4.5C272.4 88.3 245 134.2 226.8 184l-3.3 9.1L434 269.7l3.3-9.1c18.1-49.8 26.6-102.5 24.9-155.5l-.2-6zM88.4 143.9l105 38.2 3.3-9.1c19.5-53.6 49.1-103 87.1-145.5l4-4.5c6.2-6.9 13.1-13 20.5-18.2C217 7.7 131.5 59.7 88.4 143.9z"],
    "helmet-un": [512, 512, [], "e503", "M479.5 224C471.2 98.9 367.2 0 240 0C107.5 0 0 107.5 0 240V352v32H32 200h14.9L343.5 505.4c4.5 4.2 10.4 6.6 16.5 6.6h96 24V464H456 369.5l-1.5-1.5V288h48 32 32 32V224H480h-.5zM320 417.2l-78-73.7L274.4 288H320V417.2zM160 112v64c0 8.8 7.2 16 16 16s16-7.2 16-16V112 96h32v16 64c0 26.5-21.5 48-48 48s-48-21.5-48-48V112 96h32v16zM272 96h8 9.9l4.4 8.8L320 156.2V112 96h32v16 96 16H336h-8-9.9l-4.4-8.8L288 163.8V208v16H256V208 112 96h16z"],
    "location-smile": [384, 512, ["map-marker-smile"], "f60d", "M192 512s192-208 192-320C384 86 298 0 192 0S0 86 0 192C0 304 192 512 192 512zM128 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM95.4 267.1l33.3-22.2c6.2 9.4 29.1 31.1 63.4 31.1s57.1-21.7 63.4-31.1l33.3 22.2C277.1 284.4 243.1 316 192 316s-85.1-31.6-96.6-48.9z"],
    "arrow-left-to-line": [448, 512, [8676, "arrow-to-left"], "f33e", "M0 96V64H64V96 416v32H0V416 96zM137.4 278.6L114.7 256l22.6-22.6 128-128L288 82.7 333.3 128l-22.6 22.6L237.3 224 416 224h32v64H416l-178.7 0 73.4 73.4L333.3 384 288 429.3l-22.6-22.6-128-128z"],
    "bullseye": [512, 512, [], "f140", "M448 256A192 192 0 1 0 64 256a192 192 0 1 0 384 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256 80a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "sushi": [576, 512, [127843, "nigiri"], "e48a", "M479.7 320l-73.8-24.5L506.3 125.6c24.8 26.7 42.1 60.7 48.5 98.8L576 352l-57.4-19.1L479.7 320h0zM393.5 66.1c32.9 4.8 63.2 18 88.7 37.5L374.8 285.2l-92.7-30.8L393.5 66.1zm-36-2.1L235.6 270.4 96.1 318.7 246.6 64H357.5zM21.3 224.4C36.6 132.2 116.1 64.6 209.5 64L49.4 334.9 0 352 21.3 224.4zM32 384v-9.2l250.1-86.7 261.9 87V384c0 35.3-28.7 64-64 64c-19.1 0-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7C132.3 439.6 115.1 448 96 448c-35.3 0-64-28.7-64-64z"],
    "message-captions": [512, 512, ["comment-alt-captions"], "e1de", "M0 0H512V416H304L160 512V416H0V0zM120 192H96v48h24H264h24V192H264 120zm224 0H320v48h24 48 24V192H392 344zM120 272H96v48h24 48 24V272H168 120zm128 0H224v48h24H392h24V272H392 248z"],
    "trash-list": [640, 512, [], "e2b1", "M288 0l16 32H416V96H0V32H112L128 0H288zM32 128H384L360 512H56L32 128zm608 0v64H448V128H640zM608 256v64H448V256H608zM448 384h96v64H448V384z"],
    "bacon": [576, 512, [129363], "f7e5", "M210.8 190c-27.5 47.2-53 91-210.8 162l58.8 73.4c68.6-32.2 110.4-60.4 138.9-86.5c30-27.5 46-53.2 63.5-81.5l1.2-1.9c18.2-29.3 38.1-60.8 76.2-96.1c33.8-31.3 81.4-65 154.2-103.4L448 0C269.6 89.2 239.1 141.4 210.8 190zM79.3 451.1L128 512c157.8-71 183.3-114.8 210.8-162c28.3-48.6 58.7-100.8 237.2-190L513.2 81.5C439 120.2 392.4 153.4 360.4 183c-34.9 32.2-52.9 60.7-70.8 89.4L288 275c-17.5 28.2-35.4 57.1-68.7 87.6c-30.5 28-73.4 56.8-140 88.6z"],
    "option": [640, 512, [], "e318", "M448 448H432.6L423 436 176.6 128H32 0V64H32 192h15.4L217 76 463.4 384H608h32v64H608 448zm0-320H416V64h32H608h32v64H608 448z"],
    "hand-point-down": [384, 512, [], "f0a7", "M32 512H96V272H32V512zM224 352h64V224H224V352zm-32 32V272H128V384h64zm128-64h64V192H320V320zM0 149v91H192V192 160H96 80V128H96 208h16v16 48h64V160h96C384 71.6 312.4 0 224 0H162.3C119.8 0 79.1 16.9 49.1 46.9L37.5 58.5C13.5 82.5 0 115.1 0 149z"],
    "arrow-up-from-bracket": [448, 512, [], "e09a", "M246.6 25.4L224 2.7 201.4 25.4l-128 128L50.7 176 96 221.3l22.6-22.6L192 125.3V320v32h64V320 125.3l73.4 73.4L352 221.3 397.3 176l-22.6-22.6-128-128zM64 352V320H0v32V480v32H32 416h32V480 352 320H384v32 96H64V352z"],
    "trash-plus": [448, 512, [], "e2b2", "M304 0l16 32H448V96H0V32H128L144 0H304zM32 128H416L392 512H56L32 128zM200 432h48V408 344h64 24V296H312 248V232l0-24H200v24 64H136 112v48h24 64v64 24z"],
    "objects-align-top": [512, 512, [], "e3c0", "M512 0V48H0V0H512zM64 128H224V512H64V128zm224 0H448V384H288V128z"],
    "folder": [512, 512, [128193, 128447, 61716, "folder-blank"], "f07b", "M0 480H512V96H272L224 32H0V480z"],
    "face-anxious-sweat": [576, 512, [], "e36a", "M288 512c141.4 0 256-114.6 256-256S429.4 0 288 0S32 114.6 32 256l16-21.3 25.6 34.1L112 320c10.4 13.8 16 30.7 16 48c0 24.6-11.1 46.5-28.5 61.2C146.3 480.1 213.4 512 288 512zM79.3 404.4C89.5 395.6 96 382.5 96 368c0-10.4-3.4-20.5-9.6-28.8L68 314.7 48 288 36.4 303.5 9.6 339.2C3.4 347.5 0 357.6 0 368c0 26.5 21.5 48 48 48c12 0 22.9-4.4 31.3-11.6zM288 320c44.2 0 80 35.8 80 80v16H208V400c0-44.2 35.8-80 80-80zm79.6-80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-128 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM227.3 171.3l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4-15.8 2.6-5.3-31.6 15.8-2.6 2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4L216 137.4 238.6 160l-11.3 11.3zM337.4 160L360 137.4l11.3 11.3 7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4 15.8 2.6-5.3 31.6-15.8-2.6-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4L337.4 160z"],
    "credit-card-blank": [576, 512, [], "f389", "M576 32H0V480H576V32zM96 352h96v32H96V352zm128 0H384v32H224V352z"],
    "file-waveform": [448, 512, ["file-medical-alt"], "f478", "M256 0H32V288H144h9.9l4.4 8.8L176 332.2l49.7-99.4L240 204.2l14.3 28.6L281.9 288H352h16v32H352 272h-9.9l-4.4-8.8L240 275.8l-49.7 99.4L176 403.8l-14.3-28.6L134.1 320H32V512H416V160H256V0zm32 0V128H416L288 0z"],
    "microchip-ai": [512, 512, [], "e1ec", "M176 24V0H128V24 64H64v64H24 0v48H24 64v56H24 0v48H24 64v56H24 0v48H24 64v64h64v40 24h48V488 448h56v40 24h48V488 448h56v40 24h48V488 448h64V384h40 24V336H488 448V280h40 24V232H488 448V176h40 24V128H488 448V64H384V24 0H336V24 64H280V24 0H232V24 64H176V24zM352 176v16V320v16H320V320 192 176h32zM162.5 336H127.5l9.8-22.4 14-32 42-96 4.2-9.6h20.9l4.2 9.6 42 96 14 32 9.8 22.4H253.5l-4.2-9.6L239.5 304H176.5l-9.8 22.4-4.2 9.6zM208 231.9L190.5 272h35.1L208 231.9z"],
    "mug": [576, 512, [], "f874", "M384 64H32V448H416V320h32c70.7 0 128-57.3 128-128s-57.3-128-128-128H416 384zm32 64h32c35.3 0 64 28.7 64 64s-28.7 64-64 64H416V128z"],
    "plane-up-slash": [640, 512, [], "e22e", "M256 93.7C256 59.5 285 0 320 0c36 0 64 59.5 64 93.7V160L576 288v96l-91.2-30.4L620.9 459.3l19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L244.9 167.4 256 160V93.7zM448 449v63L320 480 192 512V448l64-48V320L64 384V288l97.3-64.9L384 398.5V400l38.4 28.8L448 449z"],
    "radiation": [512, 512, [], "f7b9", "M216 186.7c-23.9 13.8-40 39.7-40 69.3L0 256C0 161.3 51.5 78.5 128 34.3l88 152.4zM256 336c14.6 0 28.2-3.9 40-10.7l88 152.4C346.4 499.5 302.6 512 256 512s-90.4-12.5-128-34.3l88-152.4c11.8 6.8 25.4 10.7 40 10.7zm256-80l-176 0c0-29.6-16.1-55.5-40-69.3L384 34.3c76.5 44.3 128 127 128 221.7zM256 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "pen-circle": [512, 512, [], "e20e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM144 288L252.7 179.3l80 80L224 368l-96 16 16-96zm256-96l-44.7 44.7-80-80L320 112l80 80z"],
    "bag-seedling": [512, 512, [], "e5f2", "M32 0H480L448 64H64L32 0zM56 96H456l10.6 42.5c8.9 35.5 13.4 72 13.4 108.7v17.7c0 36.6-4.5 73.1-13.4 108.7L456 416H56L45.4 373.5C36.5 338 32 301.5 32 264.8V247.2c0-36.6 4.5-73.1 13.4-108.7L56 96zm8 352H448l32 64H32l32-64zm96-288H128v16c0 59.2 45.9 107.6 104 111.7V328v24h48V328 287.7c58.1-4.1 104-52.6 104-111.7V160H352c-40.7 0-76.4 21.8-96 54.3c-19.6-32.5-55.3-54.3-96-54.3z"],
    "chart-simple": [448, 512, [], "e473", "M160 32H288V480H160V32zM0 224H128V480H0V224zM448 96V480H320V96H448z"],
    "crutches": [640, 512, [], "f7f8", "M154.2 23.8L176.9 1.1l45.3 45.3L204.5 64 297 156.5l-45.3 45.3-92.5-92.5L108.5 160 228.1 279.6l-13.9 55.7-10.5 10.5L63.3 205.3 45.7 222.9 .4 177.6 23 155 154.2 23.8zm278.5 370l2.8-2.8 2.4 2.4 .1 .1 72.9 72.9-45.3 45.3-73-73-27.9-27.9 67.9-17zM485 23.8L616.2 155l22.6 22.6-45.3 45.3L571 200.2 439.8 69 417.1 46.4 462.4 1.1 485 23.8zM281.4 217.4L412.1 86.6l45.3 45.3L405.3 184 456 234.7l52.1-52.1 45.3 45.3L422.6 358.6l-6.3 6.3-8.6 2.2L288.4 396.9l-41.7 41.7-73 73-45.3-45.3 72.9-72.9 .1-.1 41.7-41.7L273 232.2l2.1-8.6 6.3-6.3zm51.5 39L316 324l67.7-16.9L410.7 280 360 229.3l-27.1 27.1z"],
    "circle-parking": [512, 512, ["parking-circle"], "f615", "M448 256A192 192 0 1 0 64 256a192 192 0 1 0 384 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM200 128h80c53 0 96 43 96 96s-43 96-96 96H232v32 32H168V352 320 256 160 128h32zm112 96c0-17.7-14.3-32-32-32H232v64h48c17.7 0 32-14.3 32-32z"],
    "mars-stroke": [512, 512, [9894], "f229", "M512 0H384L352 32l41.4 41.4-23 23L345 71l-17-17L294.1 88l17 17 25.4 25.4L307.8 159c-28.4-19.5-62.7-31-99.8-31c-97.2 0-176 78.8-176 176s78.8 176 176 176s176-78.8 176-176c0-37-11.4-71.4-31-99.8l28.6-28.6L407 201l17 17L457.9 184l-17-17-25.4-25.4 23-23L480 160l32-32V0zM96 304a112 112 0 1 1 224 0A112 112 0 1 1 96 304z"],
    "leaf-oak": [512, 512, [], "f6f7", "M512 248V176l-48-32 16-64L432 32 368 48 336 0H264L240 96 176 32 128 80l16 112L96 160 32 224l48 96 0 65.4L229.6 235.8l11.3-11.3 22.3 22.3L55 455l-17 17L72 505.9l17-17 57-57H192l96 48 64-64-32-48 112 16 48-48-64-64 96-24z"],
    "square-bolt": [448, 512, [], "e265", "M448 32H0V480H448V32zM200 272H112V248L288 112 248 240h88v24L160 400l40-128z"],
    "vial": [512, 512, [129514], "f492", "M356.1 22.8L333.4 .2 288.2 45.4 306.7 64 28.1 342.6C10.1 360.6 0 385 0 410.5V416c0 53 43 96 96 96h5.5c25.5 0 49.9-10.1 67.9-28.1L448 205.3l18.6 18.6 45.3-45.3-22.6-22.6-18.6-18.6-96-96 0 0L356.1 22.8zM205.3 256L352 109.3 402.7 160l-96 96H205.3z"],
    "gauge": [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-26.9-16.5-49.9-40-59.3V88 64H232V88 292.7c-23.5 9.5-40 32.5-40 59.3c0 35.3 28.7 64 64 64s64-28.7 64-64zM144 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "wand-magic-sparkles": [576, 512, ["magic-wand-sparkles"], "e2ca", "M234.7 42.7L192 64l42.7 21.3L256 128l21.3-42.7L320 64 277.3 42.7 256 0 234.7 42.7zM384.4 192.4l-32.8-32.8L432 79.2 464.8 112l-80.4 80.4zM96 32L64 96 0 128l64 32 32 64 32-64 64-32L128 96 96 32zM416 352l-64 32 64 32 32 64 32-64 64-32-64-32-32-64-32 64zM144 512l39.6-39.6L504.4 151.6 544 112 504.4 72.4 471.6 39.6 432 0 392.4 39.6 71.6 360.4 32 400l39.6 39.6 32.8 32.8L144 512z"],
    "lambda": [448, 512, [], "f66e", "M32 32H0V96H32 140.2l16.4 32.9L2.2 480H72.1L193.8 203.3 323.4 462.3l8.8 17.7H352h64 32V416H416 371.8L188.6 49.7 179.8 32H160 32z"],
    "e": [320, 512, [101], "45", "M32 32H0V64 224v32 32V448v32H32 288h32V416H288 64V288H224h32V224H224 64V96H288h32V32H288 32z"],
    "pizza": [576, 512, [127829], "f817", "M256 464c57.4 0 109.4-23.3 147.1-60.9L437 437c-46.3 46.3-110.3 75-181 75C114.6 512 0 397.4 0 256S114.6 0 256 0c70.7 0 134.7 28.7 181 75l-33.9 33.9C365.4 71.3 313.4 48 256 48C141.1 48 48 141.1 48 256s93.1 208 208 208zm124.5-83.5c-68.7 68.7-180.2 68.7-248.9 0s-68.7-180.2 0-248.9s180.2-68.7 248.9 0L256 256 380.5 380.5zM192 264a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm24-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm72 184a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm190.6 14.6C509.4 354.3 528 307.3 528 256s-18.6-98.3-49.4-134.6l34-34c39.5 45 63.4 104 63.4 168.6s-23.9 123.6-63.4 168.6l-34-34zM344 256l35.5-35.5c3.6 2.2 7.9 3.5 12.5 3.5c13.3 0 24-10.7 24-24c0-4.6-1.3-8.9-3.5-12.5l43.4-43.4c53.5 64.8 53.5 158.9 0 223.8L344 256zm104 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "bowl-chopsticks-noodles": [512, 512, [], "e2ea", "M0 96v32l128-20v32L0 144v32H128v48H0l3.6 61.2C8.5 368.1 58 438.2 128 472.9V512H384V472.9c70-34.6 119.5-104.8 124.4-187.7L512 224H288 256V176 136 88 48 40 16H208V40 57 95.5v42V176v48H176V176 138.5v-38V63 56 32H128V56 72L0 96zm512 80V128l-224 7v41H512zm0-128V0L288 42V83L512 48z"],
    "h3": [640, 512, [], "f315", "M64 96V64H0V96 256 416v32H64V416 288H256V416v32h64V416 256 96 64H256V96 224H64V96zm560 13.3V64H592 400 368v64h32H514.7L432 210.7V272h16 72c30.9 0 56 25.1 56 56s-25.1 56-56 56H459.7c-11 0-20.6-7.5-23.3-18.2L431 344.2 369 359.8l5.4 21.6c9.8 39.2 45 66.7 85.4 66.7H520c66.3 0 120-53.7 120-120c0-64.6-51-117.2-114.9-119.9l89.5-89.5 9.4-9.4z"],
    "pen-clip": [512, 512, ["pen-alt"], "f305", "M512 128l-72.4 72.4-128-128L384 0 512 128zM224 30.1l17 17L417 223l-1 1-33 33L160 480 0 512 32 352 255 129l-31-31-95 95-17 17L78.1 176l17-17L207 47l17-17z"],
    "bridge-circle-exclamation": [640, 512, [], "e4ca", "M64 32H32V96H64h40v64H32V288c53 0 96 43 96 96v96h96V384c0-53 43-96 96-96c6.3 0 12.4 .6 18.3 1.7C367.1 231.8 426.9 192 496 192c42.5 0 81.6 15.1 112 40.2V160H536V96h40 32V32H576 64zM488 96v64H408V96h80zM360 96v64H280V96h80zM232 96v64H152V96h80zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64H480V416h32v32zm0-176v16 80 16H480V368 288 272h32z"],
    "badge-percent": [512, 512, [], "f646", "M256 0c36.8 0 68.8 20.7 84.9 51.1C373.8 41 411 49 437 75s34 63.3 23.9 96.1C491.3 187.2 512 219.2 512 256s-20.7 68.8-51.1 84.9C471 373.8 463 411 437 437s-63.3 34-96.1 23.9C324.8 491.3 292.8 512 256 512s-68.8-20.7-84.9-51.1C138.2 471 101 463 75 437s-34-63.3-23.9-96.1C20.7 324.8 0 292.8 0 256s20.7-68.8 51.1-84.9C41 138.2 49 101 75 75s63.3-34 96.1-23.9C187.2 20.7 219.2 0 256 0zM192 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM337 209l17-17L320 158.1l-17 17L175 303l-17 17L192 353.9l17-17L337 209z"],
    "user": [448, 512, [128100, 62144], "f007", "M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zM448 512L384 304H64L0 512H448z"],
    "sensor": [448, 512, [], "e028", "M448 32H0V480H448V32zM112 120V264v24H64V264 120 96h48v24zm96 0V264v24H160V264 120 96h48v24z"],
    "comma": [192, 512, [], "2c", "M48 288L16 512H80l80-224H48z"],
    "school-circle-check": [640, 512, [], "e56b", "M640 512H597.2l0 0H640v0zm-245.2 0l0 0H384v0h10.8zM576 211.2c25.6 13.1 47.6 32.2 64 55.6V96H480L320 0 160 96H0V512H256V416c0-35.3 28.7-64 64-64h0v0h.7c3.4-37.7 18.7-72.1 42.2-99.1C350.2 260 335.6 264 320 264c-48.6 0-88-39.4-88-88s39.4-88 88-88s88 39.4 88 88c0 18.3-5.6 35.3-15.1 49.4c16.5-11.9 35.1-21.1 55.1-26.8V160H576v51.2zM144 192v96H80V192h64zm0 128v96H80V320h64zM336 128H304v16 32 16h16 32 16V160H352 336V144 128zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-65.4-32l-11.3 11.3-72 72L480 430.6l-11.3-11.3-40-40L417.4 368 440 345.4l11.3 11.3L480 385.4l60.7-60.7L552 313.4 574.6 336z"],
    "toilet-paper-under": [512, 512, ["toilet-paper-reverse"], "e2a0", "M96 0H348.2C336.6 12.2 327 26.9 319.5 41.9C299.5 82 288 135.1 288 192s11.5 110 31.5 150.1c7.5 15 17.1 29.7 28.7 41.9H96C43 384 0 298 0 192S43 0 96 0zM320 192c0-83.6 26.7-154.7 64-181.1C394 3.8 404.8 0 416 0c53 0 96 86 96 192c0 35-4.7 67.8-12.8 96c-16.6 57.4-47.6 96-83.2 96c-11.2 0-22-3.8-32-10.9c-37.3-26.4-64-97.5-64-181.1zm64 0c0 35.3 14.3 64 32 64s32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64zM160 416H416c44.8 0 76.9-35.2 96-72.9V512H160V416zM64 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm64 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "light-emergency": [448, 512, [], "e41f", "M64 192c0-88.4 71.6-160 160-160s160 71.6 160 160V352H64V192zm160-80V80c-61.9 0-112 50.1-112 112h32c0-44.2 35.8-80 80-80zM448 480H0V384H448v96z"],
    "arrow-down-to-arc": [512, 512, [], "e4ae", "M256 448c106 0 192-86 192-192l64 0c0 141.4-114.6 256-256 256S0 397.4 0 256l64 0c0 106 86 192 192 192zM390.6 230.6l-112 112L256 365.3l-22.6-22.6-112-112L98.7 208 144 162.7l22.6 22.6L224 242.7 224 32l0-32 64 0 0 32 0 210.7 57.4-57.4L368 162.7 413.3 208l-22.6 22.6z"],
    "dumpster": [576, 512, [], "f793", "M32 32L0 160H114.9L140.5 32H32zM272 160V32H173.1L147.5 160H272zm32 0H428.5L402.9 32H304V160zm157.1 0H576L544 32H435.5l25.6 128zM32 192l4 32H0v64H44L64 448l0 32h64V448H448v32h64V448l20-160h44V224H540l4-32H32z"],
    "van-shuttle": [640, 512, [128656, "shuttle-van"], "f5b6", "M32 32H0V64 352v32H32 64c0 53 43 96 96 96s96-43 96-96H384c0 53 43 96 96 96s96-43 96-96h32 32V352 216 204.3l-7.5-8.9-128-152L494.9 32H480 352 192 32zM546 192H384V96h81.1L546 192zM64 192V96h96v96H64zm160 0V96h96v96H224zM432 384a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM160 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "building-user": [640, 512, [], "e4da", "M384 0H0V512H144V384h96V512h77.1L384 359V0zM64 224h64v64H64V224zm160 0v64H160V224h64zm32 0h64v64H256V224zM128 96v64H64V96h64zm32 0h64v64H160V96zm160 0v64H256V96h64zM576 272a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm8 112H408L352 512H640L584 384z"],
    "light-switch": [384, 512, [], "e017", "M384 0H0V512H384V0zM96 272H288V416H96V272zm0-32V96H288V240H96zM192 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 416a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "square-caret-left": [448, 512, ["caret-square-left"], "f191", "M0 32L0 480l448 0 0-448L0 32zM256 384L128 256 256 128l32 0 0 256-32 0z"],
    "highlighter": [576, 512, [], "f591", "M314.3 314.3L460.3 110.8 433.2 83.7 229.7 229.7l84.5 84.5zM128 320V224L440 0 544 104 320 416H224l-48 48L80 368l48-48 0 0zM4.7 468.7l65.4-65.4 70.6 70.6-33.4 33.4-4.7 4.7H96 16 0V496 480v-6.6l4.7-4.7z"],
    "wave-pulse": [640, 512, ["heart-rate"], "f5f8", "M285.2 0H312h16 25.5l5.7 24.9 63.9 281.3 27.6-63 8.4-19.2H480 608h32v64H608 500.9L453.3 396.8 444.9 416H424 408 382.5l-5.7-24.9-54-237.6L263.5 485.6 258.8 512H232 216 191L185 487.8 135 288H32 0V224H32 160h25l6.1 24.2 29.1 116.3L280.5 26.4 285.2 0z"],
    "key": [512, 512, [128273], "f084", "M336 352c97.2 0 176-78.8 176-176S433.2 0 336 0S160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7L7 391l-7 7V408v80 24H24h80 24V488 448h40 24V424 384h40 9.9l7-7 33.3-33.3c16.9 5.4 35 8.3 53.7 8.3zM376 96a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "hat-santa": [640, 512, [], "f7a7", "M149.7 137.8L64 352H448L384 192l81.3 22.2-2.6-13.4-6.3-32.2 32.3-5.6 5.4-.9L434.4 91.6c-32-37.8-79-59.6-128.5-59.6c-68.8 0-130.7 41.9-156.3 105.8zm395.8 23.5L526.9 189l-32.8 5.6 6.4 32.7-19.2 27.2L509 273.1l5.6 32.8 32.7-6.4 27.2 19.2L593.1 291l32.8-5.6-6.4-32.7 19.2-27.2L611 206.9l-5.6-32.8-32.7 6.4-27.2-19.2zM0 384v96H48 464h48V384H464 48 0z"],
    "tamale": [320, 512, [129748], "e451", "M0 48S48 0 160 0S320 48 320 48L295.4 208H236.2L248 72.7l.7-8-15.9-1.4-.7 8L220.1 208H168V64 56H152v8V208H99.9L88 71.3l-.7-8L71.3 64.7l.7 8L83.8 208H24.6L0 48zM256 304h39.4L320 464s-48 48-160 48S0 464 0 464L24.6 304H64L44.8 329.6l34.5 25.9L72 439.3l-.7 8 15.9 1.4 .7-8 6.4-73.9 27.2 20.4 28.8-38.4 1.6-2.1V448v8h16v-8V346.7l1.6 2.1 28.8 38.4 27.2-20.4 6.4 73.9 .7 8 15.9-1.4-.7-8-7.3-83.8 34.5-25.9L256 304zM24 240H160 296h16v32H296 192l28.8 38.4 9.6 12.8-25.6 19.2-9.6-12.8L160 282.7l-35.2 46.9-9.6 12.8L89.6 323.2l9.6-12.8L128 272H24 8V240H24z"],
    "box-check": [448, 512, [], "f467", "M208 32V160H0L64 32H208zm32 0H384l64 128H240V32zM0 192H448V480H0V192zm337 89l17-17L320 230.1l-17 17-111 111-47-47-17-17L94.1 328l17 17 64 64 17 17 17-17L337 281z"],
    "bullhorn": [512, 512, [128226, 128363], "f0a1", "M440 0H426.1l-9.5 10.1L382 47.1C333.6 98.7 266 128 195.2 128H192 160 0V352H64V512H192V352l3.2 0c70.8 0 138.4 29.3 186.8 80.9l34.7 37 9.5 10.1H440h8 32V448 300.4c18.6-8.8 32-32.5 32-60.4s-13.4-51.6-32-60.4V32 0H448h-8zM416 103.6V240 376.4C356.7 319.8 277.7 288 195.2 288H192V192h3.2c82.4 0 161.4-31.8 220.8-88.4z"],
    "steak": [576, 512, [129385], "f824", "M268.8 37.4C295.7 12.4 329.7 0 368 0c65 0 117.7 39 150.5 80c33.9 42.4 57.5 99.6 57.5 160c0 83.9-55.1 152.8-113.4 196.2C402.1 481.2 321.7 512 240 512H0V360c0-38.6 17.8-68.3 42.5-88.1c19.6-15.8 41.4-26.8 63.3-37.8c27.3-13.8 54.6-27.6 77.7-50.7c13.8-13.8 19.7-27.9 30-52.9c3.2-7.7 6.8-16.5 11.2-26.6c7.7-17.6 20.6-44.7 44.1-66.5zm36.8 122l0 0c2.5-6 4.8-11.8 7.1-17c6.9-15.7 13.3-27.1 21.5-34.7c7.5-7 17.5-11.7 33.9-11.7c25.4 0 53.3 16.2 75.5 44c22 27.5 36.5 64.1 36.5 100c0 40.8-28.3 84.6-74.7 119.2C359.4 393.4 298.6 416 240 416H96V360c0-9 2.6-13.2 6.9-16.9c5.8-5 15-9.1 30.2-15.5l1.2-.5c29.3-12.4 71.2-30 117-75.8c28.6-28.6 42.9-63.7 54.3-91.9zm6.8-75.2c-13.3 12.4-21.9 29-29 45.3c-2.9 6.6-5.6 13.2-8.3 19.8c-11.4 27.8-22.8 55.7-46.4 79.3c-41.4 41.4-78.6 57.1-107 69l-1.1 .5-.7 .3 0 0c-13.5 5.7-27.5 11.6-37.7 20.3C70.4 328.8 64 342.1 64 360v72 16H80 240c66.3 0 133.6-25.4 184.4-63.2C474.8 347.4 512 295.2 512 240c0-44.1-17.5-87.5-43.5-120C442.7 87.8 406.6 64 368 64c-23.7 0-41.7 7.3-55.6 20.3zM384 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "location-crosshairs-slash": [640, 512, ["location-slash"], "f603", "M352 32V0H288V32 66.7c-40.2 6.7-76.2 26-103.8 53.6L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L485.2 353.9C497 334 505.4 311.7 509.3 288H544h32V224H544 509.3C495.9 143.6 432.4 80.1 352 66.7V32zm82 282.2l-39-30.3c3.2-8.7 5-18.1 5-27.9c0-44.2-35.8-80-80-80c-16.9 0-32.7 5.3-45.6 14.3l-39-30.3c22.6-19.9 52.2-32 84.6-32c70.7 0 128 57.3 128 128c0 21-5 40.7-14 58.2zM414.9 422.9l-56.8-44.7C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128c0-2.9 .1-5.7 .3-8.5l-56.8-44.7c-2 6.9-3.6 14-4.8 21.3H96 64v64H96h34.7c13.5 80.4 76.9 143.9 157.3 157.3V480v32h64V480 445.3c22.6-3.8 43.8-11.5 62.9-22.4z"],
    "person-dolly": [512, 512, [], "f4d0", "M32 48a48 48 0 1 1 96 0A48 48 0 1 1 32 48zM0 346.5l64 64V480v0l0 32L0 512l0-32L0 346.5zM0 128H32 80 97.1l9.5 14.3L161.1 224h46.1l-6.5-26.2-5.8-23.3 46.6-11.6 5.8 23.3 49.6 198.4c17.6 2.4 32.9 12 42.8 25.7l134.4-33.6 23.3-5.8 11.6 46.6-23.3 5.8L351.4 456.9C347.1 488 320.3 512 288 512c-35.3 0-64-28.7-64-64c0-21.3 10.4-40.1 26.3-51.7L223.3 288H144 126.9l-9.5-14.3L96 241.7v65.1l54.6 54.6 7.3 7.3 1.7 10.1 8 48 4 24 4 24 0 0 4 24 2.2 13.3H116.9l-.5-2.7-4-24 0 0-4-24-4-24-6.3-37.9L41.4 342.6 18.7 320C6.7 308 0 291.7 0 274.7V160 128zM288 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm38.4-80L288 230.4 441.6 192 480 345.6 326.4 384z"],
    "globe": [512, 512, [127760], "f0ac", "M352 256c0 22.1-2.2 43.5-6.1 64H166.1c-3.9-20.5-6.1-41.9-6.1-64s2.2-43.5 6.1-64H345.9c3.9 20.5 6.1 41.9 6.1 64zm26.4-64H503.9c5.3 20.5 8.1 41.9 8.1 64s-2.8 43.5-8.1 64H378.4c3.6-20.5 5.6-41.9 5.6-64s-2-43.5-5.6-64zm115-32h-122c-17-65.6-48.3-120-74-156.7c89.2 14.5 163 75.2 196 156.7zm-155.1 0H173.7c11.4-40.2 28.4-75.9 45.8-105.4c13-21.9 25.9-40 36.5-53.5c10.5 13.5 23.5 31.6 36.5 53.5c17.4 29.4 34.5 65.1 45.8 105.4zm-197.7 0H18.6c33-81.5 106.7-142.2 196-156.7c-25.7 36.7-57 91-74 156.7zM8.1 192H133.6c-3.6 20.5-5.6 41.9-5.6 64s2 43.5 5.6 64H8.1C2.8 299.5 0 278.1 0 256s2.8-43.5 8.1-64zM173.7 352H338.3c-11.4 40.2-28.4 75.9-45.8 105.4c-13 21.9-25.9 40-36.5 53.5c-10.5-13.5-23.5-31.6-36.5-53.5c-17.4-29.4-34.5-65.1-45.8-105.4zm-33.2 0c17 65.6 48.3 120 74 156.7c-89.2-14.5-163-75.2-196-156.7h122zm352.8 0c-33 81.5-106.7 142.2-196 156.7c25.7-36.7 57-91 74-156.7h122z"],
    "synagogue": [640, 512, [128333], "f69b", "M320 0L160 128v32V272 512H288V416c0-17.7 14.3-32 32-32s32 14.3 32 32v96H480V272 160 128L320 0zM512 240V512H640V272l-80-80-48 48zM80 192L0 272V512H128V240L80 192zm240-73.9l21.3 36.9H384L362.7 192 384 228.9H341.3L320 265.9l-21.3-36.9H256L277.4 192 256 155.1h42.7L320 118.1z"],
    "file-chart-column": [384, 512, ["file-chart-line"], "f659", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM216 248V424v24H168V424 248 224h48v24zm88 64V424v24H256V424 312 288h48v24zM128 376v48 24H80V424 376 352h48v24z"],
    "person-half-dress": [320, 512, [], "e548", "M160 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm72 416V480 252.2l33.8 53 53.9-34.4L238 142.8 228.6 128H211.1 168V352 480v32h64zM152 384V128H108.9 91.4l-9.4 14.8L.2 270.8l53.9 34.4 42-65.8L48 384H88v96 32h64V480 384h0z"],
    "folder-image": [512, 512, [], "e18a", "M512 480H0V32H224l48 64H512V480zM176 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm120-16l-19.6 27.8L219.1 317l-17.1-19.3L184 277.5l-17.9 20.2-64 72L96 376.5v9.1 8 24h24 56 24 48 24H392h24v-24-8V378l-4.4-6.2-96-136L296 208z"],
    "calendar-pen": [512, 512, ["calendar-edit"], "f333", "M192 0V64H320V0h64V64h96v96H32V64h96V0h64zM32 192H480V512H32V192zM312.7 351.3l-56-56L168 384l-8 64 64-8 88.7-88.7zm22.6-22.6L368 296l-56-56-32.7 32.7 56 56z"],
    "road-bridge": [640, 512, [], "e563", "M320 0H640V512H320V0zM504 200H456v24 64 24h48V288 224 200zm0 184V360H456v24 64 24h48V448 384zm0-344H456V64v64 24h48V128 64 40zM32 96H288v64H248v64h40v96c-53 0-96 43-96 96v96H96V416c0-53-43-96-96-96V224H72V160H32 0V96H32zm168 64H120v64h80V160z"],
    "face-smile-tear": [512, 512, [], "e393", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm153.6 57.4l-24.2 21 10.5 12.1c22.2 25.7 61 53.5 116.1 53.5h16V368H256c-43.4 0-74-21.8-91.9-42.5l-10.5-12.1zM352 288l-38.4 51.2c-6.2 8.3-9.6 18.4-9.6 28.8c0 26.5 21.5 48 48 48s48-21.5 48-48c0-10.4-3.4-20.5-9.6-28.8L352 288zM208.4 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "message-plus": [512, 512, ["comment-alt-plus"], "f4a8", "M0 0H512V416H304L160 512V416H0V0zM232 320h48V296 232h64 24V184H344 280V120 96H232v24 64H168 144v48h24 64v64 24z"],
    "location-arrow": [448, 512, [], "f124", "M0 256H224V480h48L432 48 0 208v48z"],
    "c": [384, 512, [99], "43", "M329.1 142.9c-62.5-62.5-155.8-62.5-218.3 0s-62.5 163.8 0 226.3s155.8 62.5 218.3 0l45.3 45.3c-87.5 87.5-221.3 87.5-308.8 0s-87.5-229.3 0-316.8s221.3-87.5 308.8 0l-45.3 45.3z"],
    "tablet-button": [448, 512, [], "f10a", "M448 0H0V512H448V0zM224 400a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "rectangle-history-circle-user": [640, 512, [], "e4a4", "M320 368c0 59.5 29.5 112.1 74.8 144L0 512V160l512 0v32.7c-5.3-.5-10.6-.7-16-.7c-97.2 0-176 78.8-176 176zM464 80v48L48 128V80l416 0zM416 0V48L96 48V0H416zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224.7 77.7L552 416H440l-24.7 29.7c20.4 21.2 49 34.3 80.7 34.3s60.3-13.2 80.7-34.3zM544 336a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "building-lock": [576, 512, [], "e4d6", "M384 0H0V512H144V384h96V512h80l0-224h32V272c0-30.5 12.2-58.2 32-78.4V0zM320 288H256V224h64v64zM64 224h64v64H64V224zm160 0v64H160V224h64zM128 96v64H64V96h64zm32 0h64v64H160V96zm160 0v64H256V96h64zM464 240c17.7 0 32 14.3 32 32v48H432V272c0-17.7 14.3-32 32-32zm-80 32v48H352V512H576V320H544V272c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "chart-line-up": [512, 512, [], "e0e5", "M64 64V32H0V64 448v32H32 480h32V416H480 64V64zm288 64l-32 32 41.4 41.4L304 258.7l-73.4-73.4L208 162.7l-22.6 22.6-80 80 45.3 45.3L208 253.3l73.4 73.4L304 349.3l22.6-22.6 80-80L448 288l32-32V128H352z"],
    "mailbox": [576, 512, [128234], "f813", "M0 208V448H288V208c0-79.5-64.5-144-144-144S0 128.5 0 208zm64-16H80 208h16v32H208 80 64V192zM320 448H576V208c0-79.5-64.5-144-144-144H245.2C290.4 95.9 320 148.5 320 208V448zm64-256h16 64 32 16v16 64 16H496 464 448V272 224H400 384V192z"],
    "truck-bolt": [640, 512, [], "e3d0", "M0 0H416V96h80L608 208V352h32v64H608 576c0 53-43 96-96 96s-96-43-96-96H256c0 53-43 96-96 96s-96-43-96-96H0V0zM416 256H544V240l-80-80H416v96zM160 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm368-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM96 192h88l-24 96L288 160H200l24-96L96 192z"],
    "pizza-slice": [512, 512, [], "f818", "M99.9 112.2L0 512l399.8-99.9c.2-4 .2-8 .2-12.1c0-159.1-128.9-288-288-288c-4 0-8.1 .1-12.1 .2zM432 404l80-20C512 171.9 340.1 0 128 0L108 80c1.3 0 2.7 0 4 0c176.7 0 320 143.3 320 320c0 1.3 0 2.7 0 4zM176 208a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM96 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "money-bill-wave": [576, 512, [], "f53a", "M0 60.3V451.7c96 48.9 192 24.5 288 0s192-48.9 288 0V60.3c-96-48.9-192-24.5-288 0s-192 48.9-288 0zM288 352c-44.2 0-80-43-80-96s35.8-96 80-96s80 43 80 96s-35.8 96-80 96zM64 352c35.3 0 64 28.7 64 64H64V352zm64-208c0 35.3-28.7 64-64 64V144h64zM512 304v64H448c0-35.3 28.7-64 64-64zM448 96h64v64c-35.3 0-64-28.7-64-64z"],
    "chart-area": [512, 512, ["area-chart"], "f1fe", "M64 64V32H0V64 448v32H32 480h32V416H480 64V64zm64 288H480V240L384 128l-64 64L240 96 128 224V352z"],
    "house-flag": [640, 512, [], "e50d", "M512 0V32H640V192H512V512H448V192 32 0h64zM416 165.2V512H320V352H192V512H64.1V287.6H0V240L256.4 32 416 165.2z"],
    "circle-three-quarters-stroke": [512, 512, [], "e5d4", "M256 64V256H448c0-106-86-192-192-192zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "person-circle-minus": [576, 512, [], "e540", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM91.4 128h17.5H211.1h17.5l9.4 14.8 66.4 104c-15.5 16.3-28 35.7-36.3 57l-2.3 1.4-33.8-53V480v32H168V480 352H152V480v32H88V480 252.2l-33.8 53L.2 270.8 82 142.8 91.4 128zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 16V352H496 368 352v32h16H496h16z"],
    "scalpel": [512, 512, [], "f61d", "M352 288L495.7 115.6C506.2 102.9 512 87 512 70.5V66.2C512 29.7 482.3 0 445.8 0c-18.9 0-36.9 8.1-49.5 22.2L160 288H352zM176 320L0 512s288-16 288-192H176z"],
    "ban": [512, 512, [128683, "cancel"], "f05e", "M367.2 412.5L99.5 144.8C77.1 176.1 64 214.5 64 256c0 106 86 192 192 192c41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3C434.9 335.9 448 297.5 448 256c0-106-86-192-192-192c-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "bell-exclamation": [448, 512, [], "f848", "M256 0H192V51.2C119 66 64 130.6 64 208v88L0 368v48H448V368l-64-72V208c0-77.4-55-142-128-156.8V0zm32 448H224 160c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7s18.7-28.3 18.7-45.3zM248 112v24 96 24H200V232 136 112h48zm0 184v48H200V296h48z"],
    "circle-bookmark": [512, 512, ["bookmark-circle"], "e100", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 384V128H352V384l-96-64-96 64z"],
    "egg-fried": [512, 512, [], "f7fc", "M284.3 39.3c30.4 31.6 89.1 65.9 131.5 76.7c27.5 7 52.8 23.2 71 47.8c42.1 56.8 30.2 137-26.6 179.1c-17.8 13.2-37.9 21.1-58.4 24c-37.2 5.2-84.5 32.7-103.3 65.2c-44.2 76.5-142 102.7-218.6 58.6S-22.7 348.5 21.4 272c24.8-42.9 38.7-105.9 43.1-155.2C67.1 87 80.1 58 103.3 35.7c51-49 132-47.4 181 3.6zM336 240a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-160 0H144c0-44.2 35.8-80 80-80v32c-26.5 0-48 21.5-48 48z"],
    "face-weary": [512, 512, [], "e3a1", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM211.3 187.3l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4-15.8 2.6-5.3-31.6 15.8-2.6 2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4L200 153.4 222.6 176l-11.3 11.3zM289.4 176L312 153.4l11.3 11.3 7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4 15.8 2.6-5.3 31.6-15.8-2.6-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4L289.4 176zM256 384c-48.9 0-93.5 16.8-127.4 44.3c-.4-4.1-.6-8.2-.6-12.3c0-70.7 57.3-128 128-128s128 57.3 128 128c0 4.2-.2 8.3-.6 12.3C349.5 400.8 304.9 384 256 384z"],
    "uniform-martial-arts": [640, 512, [], "e3d1", "M180 0h57.7l69.9 144.7L253 288H144V133.1L96 220.3V368v48H0V368 208 195.7l5.9-10.8 88-160L107.6 0H136h8 36zM144 352V320H264h56H496v32H388.4 349.9L392 415.2l8.9 13.3-26.6 17.8L365.4 433 320 364.8 274.6 433l-8.9 13.3-26.6-17.8 8.9-13.3L290.1 352H251.6 144zm77.3 45.5l-26.6 39.9 79.9 53.3 26.6-39.9L320 422.5l18.8 28.2 26.6 39.9 79.9-53.3-26.6-39.9-9-13.5H496V512H144V384h86.3l-9 13.5zM496 133.1V288H287.2l52.7-138.3L396.9 0H460h36 8 28.4l13.7 24.9 88 160 5.9 10.8V208 368v48H544V368 220.3l-48-87.3z"],
    "camera-rotate": [640, 512, [], "e0d8", "M224 32L202.7 96H64V480H576V96H437.3L416 32H224zM448 272H360l-16-16 27-27c-13.6-13.4-31.9-21-51-21c-19.2 0-37.7 7.6-51.3 21.3L249 249 215 215l19.7-19.7C257.4 172.7 288 160 320 160c31.8 0 62.4 12.6 85 35l27-27 16 16v88zM192 304h88l16 16-27 27c13.6 13.4 31.9 21 51 21c19.2 0 37.7-7.6 51.3-21.3L391 327 425 361l-19.7 19.7C382.6 403.3 352 416 320 416c-31.8 0-62.4-12.6-85-35l-27 27-16-16V304z"],
    "sun-dust": [512, 512, [], "f764", "M256 73.1L150 0 126.7 126.7 0 150 73.1 256 0 362l126.7 23.3 0 0 38.8-38.8C142.3 323.3 128 291.3 128 256c0-70.7 57.3-128 128-128c35.3 0 67.4 14.3 90.5 37.5l38.8-38.8 0 0L362 0 256 73.1zM188.1 323.9L323.9 188.1C306.5 170.7 282.5 160 256 160c-53 0-96 43-96 96c0 26.5 10.7 50.5 28.1 67.9zM512 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm48 112a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM240 432a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-80 80a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM432 400a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "comment-text": [512, 512, [], "e14d", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM184 160H160v48h24 48V312v24h48V312 208h48 24V160H328 256 184z"],
    "spray-can-sparkles": [512, 512, ["air-freshener"], "f5d0", "M224 0V128H96V0H224zM0 256c0-53 43-96 96-96H224c53 0 96 43 96 96V512H0V256zm240 80A80 80 0 1 0 80 336a80 80 0 1 0 160 0zM384 128l16-32 16 32 32 16-32 16-16 32-16-32-32-16 32-16zM336 0l16 32 32 16L352 64 336 96 320 64 288 48l32-16L336 0zM448 32L464 0l16 32 32 16L480 64 464 96 448 64 416 48l32-16zm16 160l16 32 32 16-32 16-16 32-16-32-32-16 32-16 16-32z"],
    "signal-bars": [640, 512, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", "M608 0H512V512h96V0zM352 128V512h96V128H352zM288 256H192V512h96V256zM128 384H32V512h96V384z"],
    "diamond-exclamation": [512, 512, [], "e405", "M256 0L0 256 256 512 512 256 256 0zm24 128v24V264v24H232V264 152 128h48zM232 368V320h48v48H232z"],
    "star": [576, 512, [11088, 61446], "f005", "M288.1 0l86.5 164 182.7 31.6L428 328.5 454.4 512 288.1 430.2 121.7 512l26.4-183.5L18.9 195.6 201.5 164 288.1 0z"],
    "dial-min": [576, 512, [], "e161", "M320 0V64H256V0h64zM128 64v64H64V64h64zm384 0v64H448V64h64zm0 192h64v64H512V256zm0 192v64H448V448h64zM64 448h64v64H64V448zM0 256H64v64H0V256zM400.9 401c-56.7 56.7-145.4 62-208 15.7L304.7 304.9l17-17-33.9-33.9-17 17L158.9 382.8c-46.2-62.6-41-151.3 15.7-208c62.5-62.5 163.8-62.5 226.3 0s62.5 163.8 0 226.3z"],
    "repeat": [512, 512, [128257], "f363", "M0 224V96 64H32 320V0h32l96 96-96 96H320V128H64v96 32H0V224zm512 64V416v32H480 192v64H160L64 416l96-96h32v64H448V288 256h64v32z"],
    "cross": [384, 512, [128327, 10013], "f654", "M256 0H128V128H0V256H128V512H256V256H384V128H256V0z"],
    "page-caret-down": [384, 512, ["file-caret-down"], "e429", "M384 112V512H0V0H272L384 112zM96 224v32l96 96 96-96V224H96z"],
    "box": [448, 512, [128230], "f466", "M64 32L0 160H208V32H64zM240 160H448L384 32H240V160zm208 32H0V480H448V192z"],
    "venus-mars": [640, 512, [9892], "f228", "M176 288a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM352 176c0 86.3-62.1 158.1-144 173.1V384h32 32v64H240 208v32 32H144V480 448H112 80V384h32 32V349.1C62.1 334.1 0 262.3 0 176C0 78.8 78.8 0 176 0s176 78.8 176 176zM271.9 360.6c19.3-10.1 36.9-23.1 52.1-38.4c20 18.5 46.7 29.8 76.1 29.8c61.9 0 112-50.1 112-112s-50.1-112-112-112c-7.2 0-14.3 .7-21.1 2c-4.9-21.5-13-41.7-24-60.2C369.3 66 384.4 64 400 64c37 0 71.4 11.4 99.8 31l21.6-21.6L480 32 512 0H640V128l-32 32-41.4-41.4L545 140.2c19.5 28.4 31 62.7 31 99.8c0 97.2-78.8 176-176 176c-50.5 0-96-21.3-128.1-55.4z"],
    "clock-seven-thirty": [512, 512, [], "e351", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V335.3l-20 30-13.3 20-39.9-26.6 13.3-20 64-96L280 256V392v24H232V392z"],
    "arrow-pointer": [320, 512, ["mouse-pointer"], "f245", "M32 32L0 46.9V432l29 31.8 96.1-117.2 48.2 102.7 13.6 29 57.9-27.2-13.6-29L183.3 320H320l-.1-42L32 32z"],
    "clock-four-thirty": [512, 512, [], "e34b", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V300.8L338.7 340l20 13.3 26.6-39.9-20-13.3-96-64L232 211.2V256 392v24h48V392z"],
    "signal-bars-good": [640, 512, ["signal-alt-3"], "f693", "M448 128H352V512h96V128zM192 256V512h96V256H192zM32 384V512h96V384H32z"],
    "cactus": [512, 512, [127797], "f8a7", "M160 96c0-53 43-96 96-96s96 43 96 96V352h64V272 224h96v48V400v48H464 352v64H160V320H48 0V272 144 96H96v48 80h64V96zm80 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "lightbulb-gear": [576, 512, [], "e5fd", "M225.9 372.5l6.6 11.5H112c-9.6-31.9-29.5-59.1-49.2-86.2l0 0c-5.2-7.1-10.4-14.2-15.4-21.4C27.6 247.9 16 213.3 16 176C16 78.8 94.8 0 192 0c96.7 0 175.1 77.9 176 174.4H340v44.6l-37.1-21.4L225.9 330.9 262 351.7l-36.1 20.8zM112 416H251l21 36.3V512H112V416zm0-240c0-44.2 35.8-80 80-80V64C130.1 64 80 114.1 80 176h32zm260 30.4h88.1v42.4c7.9 3.4 15.4 7.7 22.3 12.8l35-20.2 45 77.8-35.2 20.3c.4 4 .7 8.1 .7 12.3s-.2 8.2-.7 12.3l35.2 20.3-45 77.8-35.1-20.2c-6.9 5.1-14.3 9.4-22.3 12.8V497H372V454.8c-8-3.4-15.6-7.7-22.5-12.9l-34.9 20.1-45-77.8 34.9-20.1c-.4-4.1-.7-8.2-.7-12.4s.2-8.3 .7-12.4l-34.9-20.2 44.9-77.8 34.9 20.2c6.9-5.1 14.5-9.4 22.5-12.9V206.4zm92.1 145.3a48.1 48.1 0 1 0 -96.1 0 48.1 48.1 0 1 0 96.1 0z"],
    "maximize": [512, 512, ["expand-arrows-alt"], "f31e", "M32 192l32 32 52-52 84 84-84 84L64 288 32 320V480H192l32-32-52-52 84-84 84 84-52 52 32 32H480V320l-32-32-52 52-84-84 84-84 52 52 32-32 0-160H320L288 64l52 52-84 84-84-84 52-52L192 32H32V192z"],
    "charging-station": [576, 512, [], "f5e7", "M320 0H32V416H320V304h16c22.1 0 40 17.9 40 40v32c0 39.8 32.2 72 72 72s72-32.2 72-72V252.3c32.5-10.2 56-40.5 56-76.3V128H544V80 64H512V80v48H480V80 64H448V80v48H416v48c0 35.8 23.5 66.1 56 76.3V376c0 13.3-10.7 24-24 24s-24-10.7-24-24V344c0-48.6-39.4-88-88-88H320V0zM208 96l-24 96h88L144 320l24-96H80L208 96zM352 448H0v64H352V448z"],
    "shapes": [512, 512, ["triangle-circle-square"], "f61f", "M160 224H416L288 0 160 224zm128 48V496H512V272H288zM128 512a128 128 0 1 0 0-256 128 128 0 1 0 0 256z"],
    "plane-tail": [512, 512, [], "e22c", "M512 256V512H256L0 416V320l64-16L0 0H144L384 256H512zM224 352H200v48h24H352h24V352H352 224z"],
    "gauge-simple-max": [512, 512, ["tachometer-fastest"], "f62b", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-3.7-.3-7.3-.9-10.8l117.5-72.8L457 255.8 431.8 215l-20.4 12.6L293.8 300.4C283.2 292.6 270.1 288 256 288c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64z"],
    "circle-u": [512, 512, [], "e127", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 168V288c0 35.3 28.7 64 64 64s64-28.7 64-64V168 144h48v24V288c0 61.9-50.1 112-112 112s-112-50.1-112-112V168 144h48v24z"],
    "shield-slash": [640, 512, [], "e24b", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L498.4 364.1c9.1-15.2 17-30.7 23.8-46.2c32.5-74.2 40.3-150.2 37.3-199.8l-1.2-20.6L539 90.2l-207.5-80L320 5.7l-11.5 4.4L130.7 78.7 48.4 14.8zM117.9 318c32.7 74.8 91.1 149.1 189.5 191.4l12.6 5.4 12.6-5.4c41.8-18 76.3-41.7 104.8-68.8L80.6 159.5C83 205.3 93.5 262.1 117.9 318z"],
    "square-phone-hangup": [448, 512, ["phone-square-down"], "e27a", "M448 32H0V480H448V32zM346.7 320L272 299.2l5.6-49.1c-34.9-10.5-72.3-10.5-107.2 0l5.6 49.1L101.3 320 64 262.8l10.7-10.4c82.5-80.5 216.2-80.5 298.7 0L384 262.8 346.7 320z"],
    "arrow-up-left": [384, 512, [], "e09d", "M64 96H32v32V352v32H96V352 205.3L297.4 406.6 320 429.3 365.3 384l-22.6-22.6L141.3 160H288h32V96H288 64z"],
    "transporter-1": [512, 512, [], "e043", "M256 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H189.6L180 140 103 236 83 261 133 301l20-25 31-38.7V288H328V237.3L359 276l20 25L429 261l-20-25L332 140l-9.6-12H307.1 204.9zM416 512V448H96v64H216h80H416zm48-384l-16 32-32 16 32 16 16 32 16-32 32-16-32-16-16-32zM64 352L48 320 32 352 0 368l32 16 16 32 16-32 32-16L64 352zm112-32H160v32h16H336h16V320H336 176zm0 64H160v32h16H336h16V384H336 176z"],
    "peanuts": [640, 512, [129372], "e431", "M297.4 102.4c5.4 12.2 8.5 24.9 9.4 37.5c-3.7 12.1-7.9 20.1-13.4 25.6c-10.6 10.6-27.1 16.9-50 21.5c-35.8 6.5-68.2 23.2-94.7 49.8C114.3 271.1 96 315.4 96 364V493.9L55.3 512 9.7 409.6C3.5 395.7 .4 381.2 0 366.9c-.4-14.3 2-28.9 7.4-43.1c5.5-14.2 13.5-26.7 23.4-37c5.4-5.7 11.4-10.8 18-15.3c15.4-10.9 30.1-23.9 36.8-41.5s4.6-37.1 .4-55.5c-1.9-7.8-2.9-15.7-3.1-23.5c-.4-14.2 2-28.7 7.3-42.9l.2-.4c5.4-14.1 13.4-26.5 23.3-36.9c9.8-10.4 21.9-19 35.7-25.2L251.9 0l45.6 102.4zM492 0H640V148c0 40.6-16.4 77.4-42.9 104.2l-.9 .9c-14.1 14-30.3 24.6-47.6 31.7c-9.5 4-19.6 6.9-30 8.8c-24.5 4.8-49.1 12.6-66.7 30.3s-25.4 42.2-30.3 66.7c-1.9 10.4-4.9 20.5-8.8 30c-7.1 17.1-17.5 33.2-31.3 47.2c-.6 .6-1.1 1.1-1.7 1.7C353.1 495.8 316.5 512 276 512H128V364c0-20.1 4-39.2 11.2-56.7c7.2-17.5 17.9-33.8 32.1-48c14.2-14.2 30.6-24.9 48.1-32.1c9.5-4 19.6-6.9 30-8.8c24.5-4.8 49.1-12.6 66.7-30.3s25.4-42.2 30.3-66.7c1.9-10.4 4.9-20.5 8.8-30C362.4 74 373 57.8 387.1 43.6l.4-.4c14.2-14.1 30.5-24.8 47.8-32C452.8 4 471.9 0 492 0zm52 147.2a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zm0 64a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zm-64 0a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zm-224 224a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zM339.2 416a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm0-64a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0z"],
    "shuffle": [512, 512, [128256, "random"], "f074", "M512 128L416 32H384V96H320 304l-9.6 12.8L244 176l40 53.3L336 160h48v64h32l96-96zm0 256l-96-96H384v64H336L153.6 108.8 144 96H128 32 0v64H32h80L294.4 403.2 304 416h16 64v64h32l96-96zM204 336l-40-53.3L112 352H32 0v64H32h96 16l9.6-12.8L204 336z"],
    "person-running": [448, 512, [127939, "running"], "f70c", "M272 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM128 96H114.7l-9.4 9.4-48 48L34.7 176 80 221.3l22.6-22.6L141.3 160h27.7l-31.3 94c-9.3 28 1.7 58.8 26.8 74.5l86.2 53.9-9.4 32.8-16 56L213.6 512h66.6l6.6-23.2 16-56 16-56 6.6-23.2L305 340.9 238 299l29-77.4 24.3 48.6 8.8 17.7H320h48 32V224H368 339.8l-39.2-78.3-5.4-10.9-11.3-4.5-80-32L198.2 96H192 128zM109.5 310.7L91.2 352H32 0v64H32h80 20.8l8.4-19L157 361.6l-9.5-6c-17.5-10.9-30.5-26.8-37.9-44.9z"],
    "mobile-retro": [320, 512, [], "e527", "M0 0H320V512H0V0zM64 128V256H256V128H64zM184 304H136v48h48V304zm-48 80v48h48V384H136zm128 0H216v48h48V384zM56 384v48h48V384H56zm208-80H216v48h48V304zM56 304v48h48V304H56zM128 48H112V80h16 64 16V48H192 128z"],
    "grip-lines-vertical": [192, 512, [], "f7a5", "M64 32H0V480H64V32zm128 0H128V480h64V32z"],
    "bin-bottles-recycle": [640, 512, [], "e5f6", "M256 0H128V32H112V64h16H256h16V32H256V0zM32 144v48H352V144h0l-32.4-16.2L256 96H128L32 144zm543.6-8V94.1l-64-30V0h-128V64.1l-61.8 29 44.5 22.3 17.7 8.8V144v48H575.6V136zM640 224H0v64H32L64 512H576l32-224h32V224zM304 288h32 8.6l4.7 7.2 26.3 40-27.1 17L327.4 320H312.6l-20.3 30.5-27.1-17 25.6-38.4 4.8-7.1H304zm89.3 73.9l19.3 29.3 2.6 4V400v32 16h-16H337.7V416h45.5V404.8l-17.1-25.9 27.1-17zM305.7 416v32H240 224V432 400v-4.8l2.7-4 20.6-31 27.1 17L256 404.8V416h49.7z"],
    "arrow-up-from-square": [512, 512, [], "e09c", "M278.6 25.4L256 2.7 233.4 25.4l-96 96L114.7 144 160 189.3l22.6-22.6L224 125.3V320v32h64V320 125.3l41.4 41.4L352 189.3 397.3 144l-22.6-22.6-96-96zM32 32H0V64 480v32H32 480h32V480 64 32H480 416V96h32V448H64V96H96V32H32z"],
    "file-dashed-line": [640, 512, ["page-break"], "f877", "M128 0H352V160H512v96H128V0zm0 368H512V512H128V368zM512 128H384V0L512 128zM56 288H168h24v48H168 56 32V288H56zm224 0h80 24v48H360 280 256V288h24zm192 0H584h24v48H584 472 448V288h24z"],
    "bracket-curly-right": [256, 512, [], "7d", "M160 32h32V64 178.7l54.6 54.6 9.4 9.4v26.5l-9.4 9.4L192 333.3V448v32H160 64 32V416H64h64V320 306.7l9.4-9.4L178.7 256l-41.4-41.4-9.4-9.4V192 96H64 32V32H64h96z"],
    "spider": [512, 512, [128375], "f717", "M0 139.9V118.7l39.2-13.1 7.6 22.8L67 189l84.2 28.1L79 145 67.7 133.6l6.2-14.8 40-96L123.1 .6l44.3 18.5-9.2 22.2-33.8 81.2L176 174.1V160c0-38.7 27.5-71 64-78.4V128h32V81.6c36.5 7.4 64 39.7 64 78.4v14.1l51.7-51.7L353.8 41.2l-9.2-22.2L388.9 .6l9.2 22.2 40 96 6.2 14.8L433 145l-72.1 72.1L445 189l20.2-60.6 7.6-22.8L512 118.7v21.2l-1.2 3.7-24 72L483 227l-11.4 3.8L395.9 256l75.7 25.2L483 285l3.8 11.4 24 72 1.2 3.7v21.2l-39.2 13.1-7.6-22.8L445 323l-84.2-28.1L433 367l11.4 11.4-6.2 14.8-40 96-9.2 22.2-44.3-18.5 9.2-22.2 33.8-81.2L352 353.9c-1 52.1-43.6 94.1-96 94.1s-95-41.9-96-94.1l-35.7 35.7 33.8 81.2 9.2 22.2-44.3 18.5-9.2-22.2-40-96-6.2-14.8L79 367l72.1-72.1L67 323 46.8 383.6l-7.6 22.8L0 393.3V372.1l1.2-3.7 24-72L29 285l11.4-3.8L116.1 256 40.4 230.8 29 227l-3.8-11.4-24-72L0 139.9z"],
    "clock-three": [512, 512, [], "e356", "M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zM232 120V256v24h24H360h24V232H360 280V120 96H232v24z"],
    "hands-bound": [640, 512, [], "e4f9", "M96 32V0H32V32 64 96v80 16 32 11.8l7.7 9L131.6 352H128 104v48h24 32H288h64H480h32 24V352H512h-3.6l91.9-107.2 7.7-9V224 192 176 96 64 32 0H544V32 64 96v67.9l-76.2 86.4L432.1 226l39.8-44.8 21.3-23.9-47.8-42.5-21.3 23.9-64 72-8.1 9.1V232v88 32H288V320 232 219.8l-8.1-9.1-64-72-21.3-23.9-47.8 42.5 21.3 23.9L207.9 226l-35.7 24.2L96 163.9V96 64 32zm32 400H104v48h24 32v32H288V480h64v32H480V480h32 24V432H512 480 352 288 160 128z"],
    "scalpel-line-dashed": [576, 512, ["scalpel-path"], "f61e", "M495.7 115.6L352 288H160L396.2 22.2C408.8 8.1 426.8 0 445.8 0C482.3 0 512 29.7 512 66.2v4.2c0 16.5-5.8 32.5-16.3 45.1zM0 512L176 320H288C288 496 0 512 0 512zm240-32h64 16v32H304 240 224V480h16zm128 0h64 16v32H432 368 352V480h16zm128 0h64 16v32H560 496 480V480h16z"],
    "file-invoice-dollar": [384, 512, [], "f571", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM64 64H80h64 16V96H144 80 64V64zm0 64H80h64 16v32H144 80 64V128zm144 96v16 9.6c5.9 1 19 3.5 24.1 4.9l15.5 4.1-8.2 30.9-15.5-4.1c-4-1.1-17.7-3.7-22.1-4.4c-12.8-2-23.6-.4-30.9 2.9c-7.2 3.3-9.9 7.5-10.5 11c-.7 4.1-.1 6.2 .5 7.4c.6 1.4 2 3.1 5 5.1c6.7 4.6 17.1 7.8 31 12l.6 .2c12.3 3.7 27.9 8.4 39.5 16.8c6.3 4.6 12 10.6 15.6 18.8c3.6 8.3 4.4 17.4 2.7 27.2c-3 17.5-14.6 29.4-29.3 35.7c-5.6 2.4-11.6 4-17.9 4.9V432v16H176V432v-9.6c-9.4-1.7-23.6-6.6-32.4-9.6l0 0 0 0 0 0c-1.8-.6-3.3-1.1-4.6-1.6l-15.2-5.1 10.1-30.4 15.2 5.1c1.9 .6 4 1.3 6.1 2.1l0 0 0 0c9.5 3.2 20.7 7 27.1 8.1c13.3 2.1 24 .8 31-2.2c6.5-2.8 9.5-6.7 10.3-11.8c.8-4.7 .2-7.3-.5-9c-.7-1.7-2.2-3.6-5.1-5.7c-6.5-4.7-16.7-8.1-30.5-12.3l-2-.6c-11.9-3.6-26.6-8-37.7-15.5c-6.2-4.2-12.2-10-15.9-17.9c-3.8-8.1-4.7-17.1-3.1-26.6c2.9-16.7 14.7-28.4 28.8-34.7c5.6-2.6 11.8-4.4 18.3-5.4V240 224h32z"],
    "pipe-smoking": [640, 512, [], "e3c4", "M489.5 0h17.1H608h32V64H608 523.8L435 197.1l-15.5-10.4-24-16-13.7-9.1L480 14.2 489.5 0zM351.1 179.6l26.6 17.8 24 16 26.6 17.8-17.8 26.6L287.8 442.1C258.6 485.8 209.6 512 157.1 512C70.3 512 0 441.7 0 354.9V256 224H32 224h32v32 66.3l77.4-116.1 17.8-26.6z"],
    "face-astonished": [512, 512, [], "e36b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-208c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V352c0-26.5 21.5-48 48-48zM144.4 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8l-11.7 10.9L89.4 143.2l11.7-10.9c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1h16v32H192zm141 .9c-4.3-.6-8.6-.9-13-.9H304V96h16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2l11.7 10.9-21.8 23.4-11.7-10.9c-15.5-14.5-34.8-24-56.1-26.8z"],
    "window": [512, 512, [], "f40e", "M512 32H0V480H512V32zM128 96v64H64V96h64zm32 0h64v64H160V96zm160 0v64H256V96h64z"],
    "plane-circle-exclamation": [640, 512, [], "e556", "M192 93.7C192 59.5 221 0 256 0c36 0 64 59.5 64 93.7l0 66.3 85.5 57C354.3 247.8 320 303.9 320 368c0 54.7 24.9 103.5 64 135.8V512L256 480 128 512V448l64-48V320L0 384V288L192 160V93.7zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224V416H480v32h32zm0-176H480v16 80 16h32V368 288 272z"],
    "ear": [384, 512, [128066], "f5f0", "M384 192c0 71.2-38.7 133.3-96.3 166.5c.2 3.1 .3 6.3 .3 9.5c0 79.5-64.5 144-144 144S0 447.5 0 368V192C0 86 86 0 192 0S384 86 384 192zm-256 0c0-35.3 28.7-64 64-64s64 28.7 64 64v8 24h48V200v-8c0-61.9-50.1-112-112-112S80 130.1 80 192v40 14.8l13.3 6.6L128 270.8v5.9L88.6 309.6 70.2 324.9l30.7 36.9 18.4-15.4 48-40 8.6-7.2V288 256 241.2l-13.3-6.6L128 217.2V192z"],
    "file-lock": [576, 512, [], "e3a6", "M0 0H224V160H384v33.6c-19.8 20.2-32 47.9-32 78.4v15.7H320L320 512H0V0zM384 128H256V0L384 128zm80 112c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H352V320h32V272z"],
    "diagram-venn": [640, 512, [], "e15a", "M256 412.8C216.4 372.4 192 317 192 256s24.4-116.4 64-156.8C245.7 97.1 235 96 224 96C135.6 96 64 167.6 64 256s71.6 160 160 160c11 0 21.7-1.1 32-3.2zm64 45.7c-29.1 13.8-61.6 21.6-96 21.6C100.3 480 0 379.7 0 256S100.3 32 224 32c34.4 0 66.9 7.7 96 21.6C349.1 39.7 381.6 32 416 32c123.7 0 224 100.3 224 224s-100.3 224-224 224c-34.4 0-66.9-7.7-96-21.6zM370.7 192H269.3c-6.5 14.9-10.8 31.1-12.5 48H383.2c-1.7-16.9-6-33.1-12.5-48zM269.3 320H370.7c6.5-14.9 10.8-31.1 12.5-48H256.8c1.7 16.9 6 33.1 12.5 48zM288 352c9.1 12.1 19.9 22.9 32 32c12.1-9.1 22.9-19.9 32-32H288zm64-192c-9.1-12.1-19.9-22.9-32-32c-12.1 9.1-22.9 19.9-32 32h64z"],
    "x-ray": [512, 512, [], "f497", "M0 32H32 480h32V96H480V416h32v64H480 32 0V416H32V96H0V32zM272 96H240v16 32H160 144v32h16 80v48H128 112v32h16H240v70.6L181.3 304H128v57.6L170.7 416H341.3L384 361.6V304H330.7L272 326.6V256H384h16V224H384 272V176h80 16V144H352 272V112 96zM208 352a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "goal-net": [640, 512, [], "e3ab", "M32 32H0V64 448v32H64V448 96H576V448v32h64V448 64 32H608 32zm160 96H160v64H96v32h64v64H96v32h64v64H96v32h64v64h32V416h64v64h32V416h64v64h32V416h64v64h32V416h64V384H480V320h64V288H480V224h64V192H480V128H448v64H384V128H352v64H288V128H256v64H192V128zm64 256H192V320h64v64zm96 0H288V320h64v64zm96 0H384V320h64v64zm0-96H384V224h64v64zm-96 0H288V224h64v64zm-96 0H192V224h64v64z"],
    "coffin-cross": [384, 512, [], "e051", "M104 512L0 144 112 0H272L384 144 280 512H104zM216 120V96H168v24 40H120 96v48h24 48V328v24h48V328 208h48 24V160H264 216V120z"],
    "spell-check": [576, 512, [], "f891", "M106.7 0L98.5 19.7 5.1 243.7 0 256H69.3l13.3-32h90.7l13.3 32H256l-5.1-12.3-93.3-224L149.3 0H106.7zm2.7 160L128 115.2 146.7 160H109.3zM288 0H256V32v96 96 32h32 80c44.2 0 80-35.8 80-80c0-23.1-9.8-43.8-25.4-58.4c6-11.2 9.4-24 9.4-37.6c0-44.2-35.8-80-80-80H288zm80 80c0 8.8-7.2 16-16 16H320V64h32c8.8 0 16 7.2 16 16zM320 192V160h32 16c8.8 0 16 7.2 16 16s-7.2 16-16 16H320zM550.6 294.6L573.3 272 528 226.7l-22.6 22.6L336 418.7l-73.4-73.4L240 322.7 194.7 368l22.6 22.6 96 96L336 509.3l22.6-22.6 192-192z"],
    "location-xmark": [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", "M192 512s192-208 192-320C384 86 298 0 192 0S0 86 0 192C0 304 192 512 192 512zm97.9-384l-17 17-47 47 47 47 17 17L256 289.9l-17-17-47-47-47 47-17 17L94.1 256l17-17 47-47-47-47-17-17L128 94.1l17 17 47 47 47-47 17-17L289.9 128z"],
    "circle-quarter-stroke": [512, 512, [], "e5d3", "M64 256H256l0-192c106 0 192 86 192 192s-86 192-192 192S64 362 64 256zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256z"],
    "lasso": [576, 512, [], "f8c8", "M576 176c0 97.2-128.9 176-288 176c-13.2 0-26.3-.5-39-1.6c4.6 12.8 7 26.5 7 40.6c0 66.8-54.2 121-121 121H64 32V448H64h71c31.5 0 57-25.5 57-57c0-21.6-12.2-41.3-31.5-51l-46.8-23.4 .2-.4C44.7 284.1 0 233.2 0 176C0 78.8 128.9 0 288 0S576 78.8 576 176zM288 288c123.7 0 224-50.1 224-112s-100.3-112-224-112S64 114.1 64 176s100.3 112 224 112z"],
    "slash": [640, 512, [], "f715", "M29.4 .1l19 14.7L620.9 459.3l19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1z"],
    "person-to-portal": [512, 512, ["portal-enter"], "e022", "M224 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM114.7 96H128h64 6.2l5.7 2.3 80 32 11.3 4.5 5.4 10.9L339.8 224h12.8C357.5 97.7 391.2 0 432 0c44.2 0 80 114.6 80 256s-35.8 256-80 256c-40.8 0-74.5-97.7-79.4-224H320 300.2l-8.8-17.7-24.3-48.6L238 299 305 340.9l20.4 12.8-6.6 23.2-16 56-16 56L280.1 512H213.6l11.7-40.8 16-56 9.4-32.8-86.2-53.9c-25.1-15.7-36.1-46.5-26.8-74.5l31.3-94H141.3l-38.6 38.6L80 221.3 34.7 176l22.6-22.6 48-48 9.4-9.4zM91.2 352l18.3-41.3c7.4 18.1 20.4 33.9 37.9 44.9l9.5 6L141.2 397l-8.4 19H112 32 0V352H32 91.2z"],
    "calendar-star": [512, 512, [], "f736", "M192 0V64H320V0h64V64h96v96H32V64h96V0h64zM32 192H480V512H32V192zM285.6 303.2L256 232l-29.6 71.2-76.9 6.2 58.6 50.2-17.9 75L256 394.4l65.8 40.2-17.9-75 58.6-50.2-76.9-6.2z"],
    "computer-mouse": [384, 512, [128433, "mouse"], "f8cc", "M0 192H176V0H0V192zm0 32V352c0 88.4 71.6 160 160 160h64c88.4 0 160-71.6 160-160V224H192 0zm384-32V0H208V192H384z"],
    "arrow-right-to-bracket": [512, 512, ["sign-in"], "f090", "M352 96l96 0 0 320-96 0-32 0 0 64 32 0 128 0 32 0 0-32 0-384 0-32-32 0L352 32l-32 0 0 64 32 0zm-9.4 182.6L365.3 256l-22.6-22.6-128-128L192 82.7 146.7 128l22.6 22.6L242.7 224 32 224 0 224l0 64 32 0 210.7 0-73.4 73.4L146.7 384 192 429.3l22.6-22.6 128-128z"],
    "pegasus": [576, 512, [], "f703", "M448 238.1V160h16l32 64 80-32V64L544 32h16 16V0H560 480 448C377.3 0 320 57.3 320 128L160 32s-20.2 141.7 68.1 199.7c-8.7-2.7-16.7-6.1-24.2-10.1c-22.5-12.1-38.6-29.4-49.9-49.8c-7.3-13.2-12.7-27.8-16.5-43c-25.9 3.5-48.1 18.6-61.1 40C33.2 174.5 0 211.4 0 256v56 24H48V312 256c0-13.4 6.6-25.2 16.7-32.5c1.6 13 6.3 25.4 13.6 36.4l42.4 63.6L94.1 350.1l-21 21 9.4 28.1L120.1 512H221.3L182.9 397l27-27L224 355.9V336 320l83.7 23.9c4.1 1.2 8.2 2.1 12.3 2.8V512h96V315.7c19.2-19.2 31.5-45.7 32-75.7h0v-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "files-medical": [448, 512, [], "f7fd", "M320 128V96 0H96V416H448V128H352 320zm96-64L384 32 352 0V45.3 64 96h32 18.7H448L416 64zM48 96H0v24V488v24H24 328h24V464H328 48V120 96zm192 64h64v64h64v64H304v64H240V288H176V224h64V160z"],
    "nfc-lock": [576, 512, [], "e1f8", "M0 32H448V161.1c-24.9 3.6-47.2 15.3-64 32.5V112 96H368 224 208v16 98.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V128H352V272v16H320l0 96H96V128h48 16V96H144 80 64v16V400v16H80 320l0 64H0V32zM464 240c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H352V320h32V272z"],
    "person-ski-lift": [512, 512, ["ski-lift"], "f7c8", "M256 198.3l-32 8.5V0h32V198.3zM64 80a48 48 0 1 1 96 0A48 48 0 1 1 64 80zm103.5 60.7l13.7 30.1 32.7 71.9 65.9-17.6L320 256V388.5l144-53.2V312 288h48v24 40c0 10-6.3 19-15.7 22.5l-344 127.1L129.8 510l-16.6-45 22.5-8.3L256 412.2V297.7l-66.7 17.8c-22.6 6-46.2-5.1-55.9-26.3L96.9 210.3 83.8 182l27.9-13.8 26.1-12.9 29.6-14.7zm-121.8 49L125 355.6l68.7-18.7 23.2-6.3 12.6 46.3-23.2 6.3-88 24L99 412.4l-8.6-18.1-88-184L-8 188.7 35.3 168l10.4 21.7z"],
    "square-6": [448, 512, [], "e25b", "M0 32H448V480H0V32zM224 240a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm-96 48c0 53 43 96 96 96s96-43 96-96c0-49.2-37-89.8-84.7-95.3l44.4-48.4L294.6 128H229.4l-68.1 74.3c-21.4 23.4-33.3 54-33.3 85.7z"],
    "shop-slash": [640, 512, ["store-alt-slash"], "e070", "M0 192V128l15.1-20.1L121.8 192H0zm276.6 0L320 225.7V224h64v51.4l128 99.4V224h64V424.4l44.9 34.9 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L71.5 32.7 96 0H544l96 128v64H276.6zM320 384V348.1l64 50.4V512H64V384 224h64V384H320z"],
    "wind-turbine": [512, 512, [], "f89b", "M340.8 425L317.1 202.8 415.4 2 234.8 133.7l-223 15.2 204.4 90.6L340.8 425zM288 403.8l-64-95.2V464H152 128v48h24H360h24V464H360 288V403.8zM256 168a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "sliders-simple": [512, 512, [], "e253", "M64 384l64 0 0-64-64 0 0 64zm128 0l0 64-64 0-64 0L0 448l0-64 0-64 0-64 64 0 64 0 64 0 0 64 288 0 32 0 0 64-32 0-288 0zM32 192L0 192l0-64 32 0 288 0 0-64 64 0 64 0 64 0 0 64 0 64 0 64-64 0-64 0-64 0 0-64L32 192zm416 0l0-64-64 0 0 64 64 0z"],
    "grid-round": [448, 512, [], "e5da", "M128 96A64 64 0 1 1 0 96a64 64 0 1 1 128 0zm0 160A64 64 0 1 1 0 256a64 64 0 1 1 128 0zM64 480a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM288 96A64 64 0 1 1 160 96a64 64 0 1 1 128 0zM224 320a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm64 96a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm96-256a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm64 96a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM384 480a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"],
    "badge-sheriff": [448, 512, [], "f8a2", "M272 48c0 14.8-6.7 28-17.2 36.8L289 143.5l65.9 .3c6.7-18.5 24.4-31.7 45.2-31.7c26.5 0 48 21.5 48 48s-21.5 48-48 48c-5.9 0-11.6-1.1-16.9-3.1L353.9 256l29.2 51.1c5.3-2 10.9-3.1 16.9-3.1c26.5 0 48 21.5 48 48s-21.5 48-48 48c-20.8 0-38.5-13.2-45.2-31.7l-65.9 .3-34.2 58.7c10.5 8.8 17.2 22 17.2 36.8c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-14.8 6.7-28 17.2-36.8L159 368.5l-65.9-.3C86.5 386.8 68.8 400 48 400c-26.5 0-48-21.5-48-48s21.5-48 48-48c5.9 0 11.6 1.1 16.9 3.1L94.1 256 64.9 204.9c-5.3 2-10.9 3.1-16.9 3.1c-26.5 0-48-21.5-48-48s21.5-48 48-48c20.8 0 38.5 13.2 45.2 31.7l65.9-.3 34.2-58.7C182.7 76 176 62.8 176 48c0-26.5 21.5-48 48-48s48 21.5 48 48zM224 336l80-80-80-80-80 80 80 80z"],
    "server": [512, 512, [], "f233", "M512 32H0V224H512V32zM344 104a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm48 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM512 288H0V480H512V288zM344 360a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "virus-covid-slash": [640, 512, [], "e4a9", "M360 48h24V0H360 320 280 256V48h24 16V81.6c-38.3 5.2-72.7 22.8-99 48.5l-25.5-19.8 1.4-1.4 28.3-28.3 17-17L184.2 29.7l-17 17L139 75l-5.7 5.7L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L472.4 344c11.2-19.3 18.8-41 21.9-64H528v16 24h48V296 256 216 192H528v24 16H494.4c-4.2-30.7-16.3-58.8-34.1-82.3L484 125.9l11.3 11.3 17 17 33.9-33.9-17-17L501 75 472.7 46.7l-17-17L421.8 63.7l17 17L450.1 92l-23.8 23.8C402.8 97.9 374.7 85.8 344 81.6V48h16zm41.3 364.2L149.2 213.5c-1.5 6-2.7 12.2-3.5 18.5H112V216 192H64v24 40 40 24h48V296 280h33.6c4.2 30.7 16.3 58.8 34.1 82.3L156 386.1l-11.3-11.3-17-17L93.7 391.8l17 17L139 437l28.3 28.3 17 17 33.9-33.9-17-17L189.9 420l23.8-23.8c23.5 17.9 51.7 29.9 82.3 34.1V464H280 256v48h24 40 40 24V464H360 344V430.4c20.4-2.8 39.7-9.1 57.3-18.2z"],
    "intersection": [384, 512, [8898], "f668", "M64 480V448 224c0-70.7 57.3-128 128-128s128 57.3 128 128V448v32h64V448 224c0-106-86-192-192-192S0 118 0 224V448v32H64z"],
    "shop-lock": [640, 512, [], "e4a5", "M0 192H449.6c20.2-19.8 47.9-32 78.4-32s58.2 12.2 78.4 32H640V128L544 0H96L0 128v64zm384 32H320V384H128V224H64V384 512H384V384 287.7 224zm144 16c17.7 0 32 14.3 32 32v48H496V272c0-17.7 14.3-32 32-32zm-80 32v48H416V512H640V320H608V272c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "family": [512, 512, [], "e300", "M128 128A64 64 0 1 0 128 0a64 64 0 1 0 0 128zm48 48c0-5.5 .6-10.8 1.6-16H32L24 352H64V512H176V448H144V416 256 224h32 16c-10-13.4-16-30-16-48zM336 448v64H448V384h64L448 160H334.4c1 5.2 1.6 10.5 1.6 16c0 18-6 34.6-16 48h16 32v32V416v32H336zm48-320A64 64 0 1 0 384 0a64 64 0 1 0 0 128zM256 224a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm80 192V256H176V416h32v96h96V416h32z"],
    "hourglass-start": [384, 512, ["hourglass-1"], "f251", "M0 0H32 352h32V64H352v64 13.3l-9.4 9.4L237.3 256 342.6 361.4l9.4 9.4V384v64h32v64H352 32 0V448H32V384 370.7l9.4-9.4L146.7 256 41.4 150.6 32 141.3V128 64H0V0zM96 397.3V448H288V397.3l-96-96-96 96z"],
    "user-hair-buns": [448, 512, [], "e3d3", "M304 128v16c0 44.2-35.8 80-80 80s-80-35.8-80-80V128c0-5.5 .6-10.8 1.6-16H192l32-32 32 32h46.4c1 5.2 1.6 10.5 1.6 16zM40 192h65.3c19 46.9 65 80 118.7 80s99.7-33.1 118.7-80H408V64H334.9C312.7 25.7 271.4 0 224 0s-88.7 25.7-110.9 64H40V192zM448 512L384 320H64L0 512H448z"],
    "blender-phone": [576, 512, [], "f6b6", "M153.6 44.8l-25 89.6-58.9-6.7c-12.6 41.8-12.6 86.8 0 128.6l58.9-6.7 25 89.6L84.9 384 72.4 371.2c-96.6-99-96.6-259.4 0-358.4L84.9 0l68.7 44.8zM224 352L192 0H576L558.5 64H400 384V96h16H549.8l-17.5 64H400 384v32h16H523.6l-17.5 64H400 384v32h16 97.5L480 352H224zm320 32V512H160V384H544zM352 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "hourglass-clock": [576, 512, [], "e41b", "M0 0H32 352h32V64H352v64 13.3l-9.4 9.4L237.3 256l36 36c-11 23-17.2 48.8-17.2 76c0 59.5 29.6 112.1 74.8 144H32 0V448H32V384 370.7l9.4-9.4L146.7 256 41.4 150.6 32 141.3V128 64H0V0zM96 64v50.7L109.3 128H274.7L288 114.7V64H96zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm160-80H416v16 64 16h16 48 16V352H480 448V304 288z"],
    "person-seat-reclined": [512, 512, [], "e21f", "M176 128a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0 32H135l9.9 39.8 25.9 103.8C178 332 203.6 352 233 352h7 89.9l37.5 99.3 10.7 28.3 28.8-9 48-15.1 30.5-9.6-19.1-61.1-30.5 9.6-19.2 6-34.7-91.7L374.1 288H352 265l-8-32h63 32V192H320 241l-1.9-7.8L233 160H208 176zm-80.5-5.9l-5.9-31.5L26.7 134.4l5.9 31.5 48 256L85.4 448H112 272h32V384H272 138.6L95.5 154.1z"],
    "paper-plane-top": [512, 512, ["paper-plane-alt", "send"], "e20a", "M83.4 226.6L304 256 83.4 285.4 0 480H64L512 256 64 32H0L83.4 226.6z"],
    "message-arrow-up": [512, 512, ["comment-alt-arrow-up"], "e1dc", "M0 0H512V416H304L160 512V416H0V0zM280 296V185.9l31 31 17 17L361.9 200l-17-17-72-72-17-17-17 17-72 72-17 17L184 233.9l17-17 31-31V296v24h48V296z"],
    "lightbulb-exclamation": [384, 512, [], "f671", "M272 384c9.6-31.9 29.5-59.1 49.2-86.2l0 0c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C368 78.8 289.2 0 192 0S16 78.8 16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4l0 0c19.8 27.1 39.7 54.4 49.2 86.2H272zM112 416v96H272V416H112zM216 64V88 200v24H168V200 88 64h48zM168 304V256h48v48H168z"],
    "layer-minus": [576, 512, ["layer-group-minus"], "f5fe", "M384 56v48h24H520h24V56H520 408 384zM0 256L288 384 576 256 288 128 0 256zM288 419L104.6 337.5 0 384 288 512 576 384 471.4 337.5 288 419z"],
    "chart-pie-simple-circle-currency": [640, 512, [], "e604", "M496 192c4.6 0 9.3 .2 13.8 .5C494.5 83.7 401 0 288 0c-5.4 0-10.7 .2-16 .6V240H375.2c31.5-29.8 74-48 120.8-48zM320 368c0-28.8 6.9-56 19.2-80H224V32.5C98.9 40.8 0 144.8 0 272C0 404.6 107.5 512 240 512c43.8 0 84.8-11.7 120.1-32.2C335 449.4 320 410.5 320 368zm320 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM521.4 393.4a35.9 35.9 0 1 0 -50.7-50.7 35.9 35.9 0 1 0 50.7 50.7zm10 32.6c-21.6 13.2-49.1 13.2-70.7 0l-25.3 25.3-22.6-22.6L438 403.3c-13.2-21.6-13.2-49.1 0-70.7l-25.3-25.3 22.6-22.6L460.7 310c21.6-13.2 49.1-13.2 70.7 0l25.3-25.3 22.6 22.6L554 332.7c13.2 21.6 13.2 49.1 0 70.7l25.3 25.3-22.6 22.6L531.3 426z"],
    "circle-e": [512, 512, [], "e109", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128H328h24v48H328 208v56h88 24v48H296 208v56H328h24v48H328 184 160V360 256 152 128h24z"],
    "building-wheat": [640, 512, [], "e4db", "M0 0H384V512H240V384H144V512H0V0zM128 224H64v64h64V224zm32 0v64h64V224H160zm160 0H256v64h64V224zM64 96v64h64V96H64zm160 0H160v64h64V96zm32 0v64h64V96H256zm384 96v16c0 44.2-35.8 80-80 80H544V272c0-44.2 35.8-80 80-80h16zm0 128c0 44.2-35.8 80-80 80H544V384c0-44.2 35.8-80 80-80h16v16zm0 112c0 44.2-35.8 80-80 80H544V496c0-44.2 35.8-80 80-80h16v16zM512 496v16H496c-44.2 0-80-35.8-80-80V416h16c44.2 0 80 35.8 80 80zm0-96H496c-44.2 0-80-35.8-80-80V304h16c44.2 0 80 35.8 80 80v16zm0-128v16H496c-44.2 0-80-35.8-80-80V192h16c44.2 0 80 35.8 80 80zM552 32V56 160v24H504V160 56 32l48 0zm72 64v32 24H576V128 96 72h48V96zM480 72V96v32 24l-48 0V128 96 72h48z"],
    "gauge-max": [512, 512, ["tachometer-alt-fastest"], "f626", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64c0-3.7-.3-7.3-.9-10.8l117.5-72.8L457 255.8 431.8 215l-20.4 12.6L293.8 300.4C283.2 292.6 270.1 288 256 288c-35.3 0-64 28.7-64 64s28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "person-breastfeeding": [448, 512, [], "e53a", "M144 80a80 80 0 1 1 160 0A80 80 0 1 1 144 80zM269.2 443.8l23-32.9-52.8-8.8L192 354.7l0-66.7H168 128l0 53.3 0 26.7c0 .7 0 1.4 .1 2.1l69.2 34.3 43 21.3-42.6 86-43-21.3L26.7 427 0 413.8 0 384l0-16 0-16 9.6-12.8 96-128L120 192h24H320h26.2l14.2 22 72 112 17.4 27.1-18.5 26.4-56 80-27.5 39.3-78.6-55zM276 376a44 44 0 1 0 0-88 44 44 0 1 0 0 88z"],
    "apostrophe": [192, 512, [], "27", "M72 352c66.3 0 120-53.7 120-120l0-8 0-96 0-96L0 32 0 224l128 0 0 8c0 30.9-25.1 56-56 56l-8 0-32 0 0 64 32 0 8 0z"],
    "fire-hydrant": [384, 512, [], "e17f", "M224 32v4c45 11.6 80.4 47 92 92h12 24v48H328 56 32V128H56 68c11.6-45 47-80.4 92-92V32 0h64V32zM32 464H56h8V400H16V272H64V208H320v64h48V400H320v64h8 24v48H328h-8H64 56 32V464zm160-64a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "right-to-bracket": [512, 512, ["sign-in-alt"], "f2f6", "M192 96L352 256 192 416l-32 0 0-96L0 320 0 192l160 0 0-96 32 0zM352 416l96 0 0-320-96 0-32 0 0-64 32 0 128 0 32 0 0 32 0 384 0 32-32 0-128 0-32 0 0-64 32 0z"],
    "video-plus": [576, 512, [], "f4e1", "M0 64H384V448H0V64zm576 0V448L416 337.1V174.9L576 64zM216 184V160H168v24 48H120 96v48h24 48v48 24h48V328 280h48 24V232H264 216V184z"],
    "square-right": [448, 512, [10145, "arrow-alt-square-right"], "f352", "M448 480l0-448L0 32 0 480l448 0zM224 384l0-80L96 304l0-96 128 0 0-80 32 0L384 256 256 384l-32 0z"],
    "comment-smile": [512, 512, [], "f4b4", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM192 208a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM168.4 254.1l-35.8 32 16 17.9c26.3 29.4 64.7 48 107.3 48s81-18.6 107.3-48l16-17.9-35.8-32-16 17.9c-17.6 19.7-43.1 32-71.6 32s-53.9-12.3-71.6-32l-16-17.9z"],
    "venus": [384, 512, [9792], "f221", "M80 176a112 112 0 1 1 224 0A112 112 0 1 1 80 176zM224 349.1c81.9-15 144-86.8 144-173.1C368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1V384H128 96v64h32 32v32 32h64V480 448h32 32V384H256 224V349.1z"],
    "passport": [448, 512, [], "f5ab", "M0 0H448V512H0V0zM183 278.8c-27.9-13.2-48.4-39.4-53.7-70.8h39.1c1.6 30.4 7.7 53.8 14.6 70.8zm41.3 9.2l-.3 0-.3 0c-2.4-3.5-5.7-8.9-9.1-16.5c-6-13.6-12.4-34.3-14.2-63.5h47.1c-1.8 29.2-8.1 49.9-14.2 63.5c-3.4 7.6-6.7 13-9.1 16.5zm40.7-9.2c6.8-17.1 12.9-40.4 14.6-70.8h39.1c-5.3 31.4-25.8 57.6-53.7 70.8zM279.6 176c-1.6-30.4-7.7-53.8-14.6-70.8c27.9 13.2 48.4 39.4 53.7 70.8H279.6zM223.7 96l.3 0 .3 0c2.4 3.5 5.7 8.9 9.1 16.5c6 13.6 12.4 34.3 14.2 63.5H200.5c1.8-29.2 8.1-49.9 14.2-63.5c3.4-7.6 6.7-13 9.1-16.5zM183 105.2c-6.8 17.1-12.9 40.4-14.6 70.8H129.3c5.3-31.4 25.8-57.6 53.7-70.8zM352 192A128 128 0 1 0 96 192a128 128 0 1 0 256 0zM112 384H96v32h16H336h16V384H336 112z"],
    "inbox-in": [512, 512, [128229, "inbox-arrow-down"], "f310", "M288 32V210.7l41.4-41.4L352 146.7 397.3 192l-22.6 22.6-96 96L256 333.3l-22.6-22.6-96-96L114.7 192 160 146.7l22.6 22.6L224 210.7V32 0h64V32zM0 320H144l32 64H336l32-64H512V512H0V320z"],
    "heart-pulse": [512, 512, ["heartbeat"], "f21e", "M64 288h80 16l6.2-14.8 18.7-44.9 49.3 109.5 20.7 46.1 22.6-45.2L320 253.7l10.5 21.1 6.6 13.3H352h96l0 0L256 480 64 288l0 0zM20.8 240C7.3 218.5 0 193.5 0 167.8C0 92.8 60.8 32 135.8 32c36 0 70.5 14.3 96 39.8L256 96l24.2-24.2c25.5-25.5 60-39.8 96-39.8C451.2 32 512 92.8 512 167.8c0 25.8-7.3 50.8-20.8 72.2H366.8l-25.4-50.7L320 146.3l-21.5 42.9-41.4 82.8L205.9 158.2l-22.7-50.5-21.3 51.1L128 240H20.8z"],
    "circle-8": [512, 512, [], "e0f5", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM264 128H248c-39.8 0-72 32.2-72 72c0 15.7 5 30.1 13.5 42c-18 14.7-29.5 37-29.5 62c0 44.2 35.8 80 80 80h32c44.2 0 80-35.8 80-80c0-25-11.5-47.4-29.5-62c8.5-11.8 13.5-26.3 13.5-42c0-39.8-32.2-72-72-72zm-16 96c-13.2 0-24-10.8-24-24s10.7-24 24-24h16c13.3 0 24 10.7 24 24s-10.7 24-24 24c0 0 0 0 0 0H248s0 0 0 0zm16 48h8c17.7 0 32 14.3 32 32s-14.3 32-32 32H240c-17.7 0-32-14.3-32-32s14.3-32 32-32h8 16z"],
    "clouds-moon": [640, 512, [], "f745", "M448 140C448 72.3 499 16.5 564.7 8.9C548.2 3.1 530.5 0 512 0C423.6 0 352 71.6 352 160c0 11.5 1.2 22.7 3.5 33.5c53.7 8.2 96.5 49.8 106.4 103c14.2 5.4 27.1 13.3 38.4 23.1c3.9 .3 7.8 .4 11.8 .4c51.2 0 96.7-24 126-61.4c-17.5 8.6-37.2 13.4-58 13.4c-72.9 0-132-59.1-132-132zM106.8 288.1c18-37.9 56.5-64.1 101.3-64.1c12.9 0 25.3 2.2 36.8 6.2c19.6-19.9 45.8-33.5 75-37.2l0-.9c0-35.3-28.6-64-64-64c-7.4 0-14.6 1.3-21.2 3.6c-11.5-30.1-40.6-51.6-74.8-51.6c-38.9 0-71.3 27.8-78.5 64.6c-3.1-.4-6.3-.6-9.5-.6c-39.8 0-72 32.2-72 72v72H72h34.8zM64 511.9l80 0H415.9h96v-96c0-47.6-34.6-87-80-94.6l0-1.3c0-53-43-96-96-96c-34.9 0-65.4 18.6-82.2 46.4C240.8 261.3 225 256 208 256c-44.2 0-80 35.8-80 80c0 5.9 .6 11.7 1.9 17.2C92.4 359.9 64 392.6 64 431.9v80z"],
    "clock-ten-thirty": [512, 512, [], "e355", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V256 243.2L269.3 236l-96-64-20-13.3-26.6 39.9 20 13.3L232 268.8V392v24h48V392z"],
    "people-carry-box": [640, 512, ["people-carry"], "f4ce", "M176 48A48 48 0 1 0 80 48a48 48 0 1 0 96 0zM80 128H48v32V274.7c0 17 6.7 33.3 18.7 45.3l22.6 22.6 56.7 56.7 6.3 37.9 8 48 4 24 .5 2.7h64.9l-2.2-13.3-4-24-8-48-8-48-1.7-10.1-7.3-7.3L144 306.7V241.7l21.4 32.1 3.7 5.5 5.6 3.6 49.6 32 7.9 5.1h9.4H256V288h0v32H383.8h.2 14.2 9.4l7.9-5.1 49.6-32 5.6-3.6 3.7-5.5 21.4-32.1v65.1l-54.6 54.6-7.3 7.3-1.7 10.1-8 48-8 48-4 24L410 512h64.9l.5-2.7 4-24 8-48 6.3-37.9 56.8-56.7L573.1 320c12-12 18.7-28.3 18.7-45.3V160 128h-32-48H494.7l-9.5 14.3-60.3 90.5-8.9 5.7V128H224V238.6l-9.1-5.8-60.3-90.5L145.1 128H128 80zM52.5 351L9.5 486.3 1.3 512H68.5l2-6.3 33-103.7L52.5 351zM463.8 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM587.3 351l-51 50.9 33 103.7 2 6.3h67.2l-8.2-25.7L587.3 351z"],
    "folder-user": [512, 512, [], "e18e", "M512 96V480H0V32H224l48 64H512zM320 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm16 96H176l-24 64H360l-24-64z"],
    "trash-can-xmark": [448, 512, [], "e2ae", "M304 0l16 32H448V96H0V32H128L144 0H304zM32 128H416V512H32V128zM321.9 256L288 222.1l-17 17-47 47-47-47-17-17L126.1 256l17 17 47 47-47 47-17 17L160 417.9l17-17 47-47 47 47 17 17L321.9 384l-17-17-47-47 47-47 17-17z"],
    "temperature-high": [512, 512, [], "f769", "M416 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 128A96 96 0 1 0 416 0a96 96 0 1 0 0 192zM81.8 317.8L96 300.2V277.5 64h96V277.5v22.7l14.2 17.6C217.4 331.5 224 348.9 224 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-19.1 6.6-36.5 17.8-50.3zM256 0H192 96 32V64 277.5C12 302.2 0 333.7 0 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5V64 0zM144 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V112 96H128v16V322.8c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48z"],
    "microchip": [512, 512, [], "f2db", "M176 24V0H128V24 64H64v64H24 0v48H24 64v56H24 0v48H24 64v56H24 0v48H24 64v64h64v40 24h48V488 448h56v40 24h48V488 448h56v40 24h48V488 448h64V384h40 24V336H488 448V280h40 24V232H488 448V176h40 24V128H488 448V64H384V24 0H336V24 64H280V24 0H232V24 64H176V24zM352 160H160V352H352V160zM160 128H352h32v32V352v32H352 160 128V352 160 128h32z"],
    "left-long-to-line": [640, 512, [], "e41e", "M0 416l0 32 64 0 0-32L64 96l0-32L0 64 0 96 0 416zM288 96L128 256 288 416l32 0 0-96 320 0 0-128-320 0 0-96-32 0z"],
    "crown": [576, 512, [128081], "f521", "M309 106c11.4-7 19-19.7 19-34c0-22.1-17.9-40-40-40s-40 17.9-40 40c0 14.4 7.6 27 19 34L192 256 72 160c5-6.7 8-15 8-24c0-22.1-17.9-40-40-40S0 113.9 0 136s17.9 40 40 40c.2 0 .5 0 .7 0L96 480H480l55.3-304c.2 0 .5 0 .7 0c22.1 0 40-17.9 40-40s-17.9-40-40-40s-40 17.9-40 40c0 9 3 17.3 8 24L384 256 309 106z"],
    "weight-hanging": [512, 512, [], "f5cd", "M224 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm122.5 32c3.5-10 5.5-20.8 5.5-32c0-53-43-96-96-96s-96 43-96 96c0 11.2 1.9 22 5.5 32H88L0 512H512L424 128H346.5z"],
    "xmarks-lines": [640, 512, [], "e59a", "M32 32H0V96H32 608h32V32H608 32zm0 384H0v64H32 608h32V416H608 32zM57 183l-17-17L6.1 200l17 17 39 39L23 295l-17 17L40 345.9l17-17 39-39 39 39 17 17L185.9 312l-17-17-39-39 39-39 17-17L152 166.1l-17 17-39 39L57 183zm224 0l-17-17L230.1 200l17 17 39 39-39 39-17 17L264 345.9l17-17 39-39 39 39 17 17L409.9 312l-17-17-39-39 39-39 17-17L376 166.1l-17 17-39 39-39-39zm224 0l-17-17L454.1 200l17 17 39 39-39 39-17 17L488 345.9l17-17 39-39 39 39 17 17L633.9 312l-17-17-39-39 39-39 17-17L600 166.1l-17 17-39 39-39-39z"],
    "file-prescription": [384, 512, [], "f572", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM104 196h72c33.1 0 60 26.9 60 60c0 25.5-15.9 47.2-38.3 55.9l43 40.3 33.8-31 14.7-13.5 27 29.5-14.7 13.5L270 379.7l31.7 29.7 14.6 13.7-27.4 29.2-14.6-13.7-33.9-31.8-34.9 32-14.7 13.5-27-29.5 14.7-13.5 32.6-29.9-64.8-60.8-2.8-2.6H124v44 20H84V360 296 216 196h20zm55.1 79.7l.3 .3H176c11 0 20-9 20-20s-9-20-20-20H124v40h34.8l.3-.3z"],
    "calendar-range": [512, 512, [], "e0d6", "M128 0V64H32v96H480V64H384V0H320V64H192V0H128zM480 192H32V512H480V192zM160 256v64H96V256h64zM352 448V384h64v64H352zm64-184v48H224V264H416zM96 392H288v48H96V392z"],
    "flower-daffodil": [512, 512, [9880], "f800", "M288 281.3c9.8 4.3 20.6 6.7 32 6.7c44.2 0 80-35.8 80-80c0-26.2-12.6-49.4-32-64c19.4-14.6 32-37.8 32-64c0-44.2-35.8-80-80-80c-26.2 0-49.4 12.6-64 32C241.4 12.6 218.2 0 192 0c-44.2 0-80 35.8-80 80c0 26.2 12.6 49.4 32 64c-19.4 14.6-32 37.8-32 64c0 44.2 35.8 80 80 80c11.4 0 22.2-2.4 32-6.7V394.8C192.1 349.5 139.5 320 80 320H0v16c0 97.2 78.8 176 176 176h48 32 32 48c97.2 0 176-78.8 176-176V320H432c-59.5 0-112.1 29.5-144 74.8V281.3zM200 144l56-56 56 56-56 56-56-56z"],
    "hand-back-point-up": [448, 512, [], "e1a2", "M176 0H96V224v13.3V240v80 16H64V320 264L16 304v68c0 38 16.9 74 46.1 98.3l5.4 4.5c28.8 24 65 37.1 102.4 37.1H288c70.7 0 128-57.3 128-128V368 320 240H336V208H256V176H176V0z"],
    "weight-scale": [512, 512, ["weight"], "f496", "M128 176a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zM391.8 64C359.5 24.9 310.7 0 256 0S152.5 24.9 120.2 64H0V512H512V64H391.8zM296 224c0-10.6-4.1-20.2-10.9-27.4l33.6-78.3 6.3-14.7L295.6 91l-6.3 14.7L255.7 184c-22 .1-39.7 18-39.7 40c0 22.1 17.9 40 40 40s40-17.9 40-40z"],
    "star-exclamation": [576, 512, [], "f2f3", "M374.6 164L288.1 0 201.5 164 18.9 195.6 148.1 328.5 121.7 512l166.4-81.8L454.4 512 428 328.5 557.2 195.6 374.6 164zM312 160v24 80 24H264V264 184 160h48zM264 320h48v48H264V320z"],
    "books": [512, 512, [128218], "f5db", "M355.4 398.3L320 268.3V142.8l93.7-25.1 67.2 247L355.4 398.3zM405.3 86.8L320 109.6V16.3L381.7 0l23.6 86.8zM363.8 429.2l125.5-33.6L512 478.9 386.3 512l-22.5-82.8zM0 0H128V96H0V0zM0 128H128V384H0V128zM0 416H128v96H0V416zM160 0H288V96H160V0zm0 128H288V384H160V128zm0 288H288v96H160V416z"],
    "user-group": [640, 512, [128101, "user-friends"], "f500", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM384 304l64 208H0L64 304H384zM640 512H481.5l-2.9-9.4L422.4 320H576l64 192zM432 256c-31 0-59-12.6-79.3-32.9C372.4 196.5 384 163.6 384 128c0-26.8-6.6-52.1-18.3-74.3C384.3 40.1 407.2 32 432 32c61.9 0 112 50.1 112 112s-50.1 112-112 112z"],
    "arrow-up-a-z": [576, 512, ["sort-alpha-up"], "f15e", "M395.5 32l-8.6 18.7-88 192L292.8 256h70.4l14.7-32h76.3l14.7 32h70.4l-6.1-13.3-88-192L436.5 32H395.5zm4.4 144L416 140.8 432.1 176H399.9zM183.6 58.4L160 32.6 136.4 58.4l-88 96L26.8 178 74 221.2l21.6-23.6L128 162.3V448v32h64V448 162.3l32.4 35.4L246 221.2 293.2 178l-21.6-23.6-88-96zM352 288H320v64h32 52l-73 63.9L320 425.5V440v8 32h32H480h32V416H480 428l73-63.9 10.9-9.6V328v-8V288H480 352z"],
    "layer-plus": [576, 512, ["layer-group-plus"], "f5ff", "M488 24V0H440V24 56H408 384v48h24 32v32 24h48V136 104h32 24V56H520 488V24zM0 256L288 384 576 256 288 128 0 256zM288 419L104.6 337.5 0 384 288 512 576 384 471.4 337.5 288 419z"],
    "play-pause": [640, 512, [], "e22f", "M320 256L64 448V64L320 256zM448 96V416v32H384V416 96 64h64V96zm128 0V416v32H512V416 96 64h64V96z"],
    "block-question": [640, 512, [], "e3dd", "M544 32H96V480H544V32zM168 80a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm280 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM168 384a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm280 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM232 200c0-30.9 25.1-56 56-56h56.9c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L344 280.4V288v24H296V288 266.5 252.6l12.1-6.9 44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H288c-4.4 0-8 3.6-8 8l0 6.5-48 0V200zm64 152h48v48H296V352z"],
    "snooze": [448, 512, [128164, "zzz"], "f880", "M192 0H160V64h32 33.3l-57.6 67.2-7.7 9V152v8 32h32 96 32V128H288 254.7l57.6-67.2 7.7-9V40 32 0H288 192zM320 224H288v64h32 33.3l-57.6 67.2-7.7 9V376v8 32h32 96 32V352H416 382.7l57.6-67.2 7.7-9V264v-8V224H416 320zM32 256H0v64H32h98.7L9.4 441.4 0 450.7V464v16 32H32 192h32V448H192 93.3L214.6 326.6l9.4-9.4V304 288 256H192 32z"],
    "scanner-image": [576, 512, [], "f8f3", "M78.5 46.7L50 32.2 21 89.2l28.5 14.5L410.8 288H32 0v32V448v32H32 544h32V448 320 300.4l-17.5-8.9L78.5 46.7zM64 352h64v64H64V352zm160 0v64H160V352h64z"],
    "tv-retro": [512, 512, [128250], "f401", "M185 23l-17-17L134.1 40l17 17 39 39H0V512H512V96H321.9l39-39 17-17L344 6.1 327 23l-71 71L185 23zM424 232a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM64 160H384V448H64V160z"],
    "square-t": [448, 512, [], "e280", "M448 32H0V480H448V32zM120 144H224 328h24v48H328 248V360v24H200V360 192H120 96V144h24z"],
    "farm": [576, 512, ["barn-silo"], "f864", "M0 96C0 43 43 0 96 0s96 43 96 96H0zm0 32H181.4l-51 123.8-2.4 5.9V264 512H0V128zM160 512V264l56-136L368 64l152 64 56 136V512H432V400H304V512H160zM416 224H320v96h96V224z"],
    "chess-knight": [448, 512, [9822], "f441", "M96 48L64 80V240l48 40 112-72v40L64 352v48H384l28.7-157.8c2.2-12.1 3.3-24.4 3.3-36.8C416 92 324 0 210.5 0H64V32L96 48zm24 68a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zM16 512H432V480l-48-48H64L16 480v32z"],
    "bars-sort": [448, 512, [], "e0ae", "M0 64H448v64H0V64zM0 224H320v64H0V224zM192 384v64H0V384H192z"],
    "pallet-boxes": [640, 512, [57863, "palette-boxes", "pallet-alt"], "f483", "M64 0H320V256H64V0zM384 64H576V256H384V64zM0 320H32 64 96h32H288h32 32H512h32 32 32 32v64H608 576v64h32 32v64H608 576 544 512 352 320 288 128 96 64 32 0V448H32 64V384H32 0V320zM128 448H288V384H128v64zm224 0H512V384H352v64z"],
    "face-laugh-squint": [512, 512, ["laugh-squint"], "f59b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-80c-83 0-151.2-63.1-159.2-144H415.2c-8 80.9-76.2 144-159.2 144zM112 112l118.9 64L112 240l45.7-64L112 112zm169.1 64L400 112l-45.7 64L400 240 281.1 176z"],
    "code-simple": [576, 512, [], "e13d", "M199.9 133.3L90.8 256 199.9 378.7l21.3 23.9-47.8 42.5-21.3-23.9-128-144L5.2 256l18.9-21.3 128-144 21.3-23.9 47.8 42.5-21.3 23.9zm176.2 0l-21.3-23.9 47.8-42.5 21.3 23.9 128 144L570.8 256l-18.9 21.3-128 144-21.3 23.9-47.8-42.5 21.3-23.9L485.2 256 376.1 133.3z"],
    "bolt-slash": [640, 512, [], "e0b8", "M112 288l163.6 25.2L171.8 231.4 112 288zm321.3 25.7L528 224 356.7 197.6 416 0 241.8 165 48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L433.4 313.7zm-151.2 4.6L224 512 362 381.2l-79.9-63z"],
    "panel-fire": [640, 512, [], "e42f", "M0 32H448v87c-22.3 18.1-43.9 36.8-64 57V96H64V224H341.7c-17 21.9-32.7 46.1-42.6 72H264v48h24.2c-.2 2.7-.2 5.4-.2 8.2c0 49.1 18.4 93.9 48.8 127.8H0V32zM168 296v48h48V296H168zm-96 0v48h48V296H72zm441-71.9c17.2-19.5 31-32 31-32s96 86.4 96 160c0 88.4-71.6 160-160 160s-160-71.6-160-160s128-192 128-192s32.6 26.4 65 64zM530 433c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78c18 0 34-5 49-15z"],
    "binary-circle-check": [640, 512, [], "e33c", "M224 0h32 48 32V32 160h16 32v64H352 304 256 224V160h32 16V64H256 224V0zM0 288H32 80h32v32V448h16 32v64H128 80 32 0V448H32 48V352H32 0V288zM32 0H160h32V32 192v32H160 32 0V192 32 0H32zM64 160h64V64H64v96zM192 288h32H339.2c-12.3 24-19.2 51.2-19.2 80V352H256v96h32 32 19.2c11 21.5 26.3 40.5 44.8 55.8V512H352 224 192V480 320 288zm128 80c0 5.4 .2 10.7 .7 16H320V368zm32 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm222.6-32L552 313.4l-11.3 11.3L480 385.4l-28.7-28.7L440 345.4 417.4 368l11.3 11.3 40 40L480 430.6l11.3-11.3 72-72L574.6 336z"],
    "comment-minus": [512, 512, [], "f4b1", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM184 216H160v48h24H328h24V216H328 184z"],
    "burrito": [512, 512, [127791], "f7ed", "M251.4 52.6L4.6 299.4C34.3 322.4 71.6 336 112 336c79.2 0 146.2-52.3 168.3-124.3c5-16.3 7.7-33.7 7.7-51.7c0-40.4-13.6-77.7-36.6-107.4zm15-32C299.7 57.5 320 106.4 320 160c0 11.9-1 23.6-2.9 34.9c11.4-1.9 23-2.9 34.9-2.9c53.6 0 102.5 20.3 139.4 53.6c12.8-14.2 20.6-33 20.6-53.6c0-11.4-2.4-22.2-6.7-32c4.3-9.8 6.7-20.6 6.7-32c0-34.6-22-64.1-52.8-75.2C448.1 22 418.6 0 384 0c-11.4 0-22.2 2.4-32 6.7C342.2 2.4 331.4 0 320 0c-20.6 0-39.4 7.8-53.6 20.6zm193 240C429.7 237.6 392.4 224 352 224c-15.2 0-29.9 1.9-43.9 5.5C279.5 310.2 202.5 368 112 368c-41.2 0-79.7-12-112-32.7V400L112 512h96L459.4 260.6z"],
    "violin": [640, 512, [127931], "f8ed", "M520 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM333.8 52.2l17-17L316.8 1.3l-17 17L18.2 299.8l-17 17 33.9 33.9 17-17L333.8 52.2zM472 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm48-48a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM614.6 70.6L637.3 48 592 2.7 569.4 25.4 417 177.7C398 166.5 375.7 160 352 160c-25.4 0-49.1 7.4-69 20.2c3.2 8.7 5 18.1 5 27.8c0 44.2-35.8 80-80 80c-16.7 0-32.3-5.1-45.1-13.9c-21.7 25.2-34.9 58-34.9 93.9c0 17 2.9 33.2 8.3 48.4L188 375l22.4-17.9 20.3 20.3 32 32 20.3 20.3L265 452l-41.4 51.7c15.1 5.4 31.4 8.3 48.4 8.3c35.9 0 68.7-13.1 93.9-34.9C357.1 464.3 352 448.7 352 432c0-44.2 35.8-80 80-80c9.8 0 19.2 1.8 27.8 5c12.8-19.9 20.2-43.6 20.2-69c0-23.7-6.5-46-17.7-65L614.6 70.6zM208 400l0 0-80 64 48 48 18.2-22.8s0 0 0 0l1.9-2.4L240 432l-32-32 0 0z"],
    "objects-column": [448, 512, [], "e3c1", "M192 32H0V288H192V32zM448 224H256V480H448V224zM0 352V480H192V352H0zM448 32H256V160H448V32z"],
    "square-chevron-down": [448, 512, ["chevron-square-down"], "f329", "M0 480l448 0 0-448L0 32 0 480zM207 345L103 241l-17-17L120 190.1l17 17 87 87 87-87 17-17L361.9 224l-17 17L241 345l-17 17-17-17z"],
    "comment-plus": [512, 512, [], "f4b2", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM232 352h48V328 264h64 24V216H344 280V152 128H232v24 64H168 144v48h24 64v64 24z"],
    "triangle-instrument": [576, 512, ["triangle-music"], "f8e2", "M320 32V0H256V32 85.3l-5.3 8.9L38.4 448 0 512H74.6 501.4 576l-38.4-64L437.7 281.5 391 328.1 463 448H113L288 156.4l60.6 101-41.8 41.8c-5.9-2.1-12.2-3.2-18.8-3.2c-30.9 0-56 25.1-56 56s25.1 56 56 56s56-25.1 56-56c0-6.6-1.1-12.9-3.2-18.8l33.3-33.3 46.6-46.6L537 137l17-17L520 86.1l-17 17L395.3 210.8l-70-116.6L320 85.3V32z"],
    "wheelchair": [512, 512, [], "f193", "M192 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM48 352c0 61.9 50.1 112 112 112c49.9 0 92.3-32.7 106.7-77.8l45.7 14.6C291.8 465.3 231.4 512 160 512C71.6 512 0 440.4 0 352c0-78.3 56.3-143.5 130.6-157.3l8.8 47.2C87.4 251.5 48 297.2 48 352zM153 128h39 32 26.2l5.1 25.7 4.5 22.3H336h32v64H336 272.6l9.6 48H384h22.2l7.8 20.8 37.1 99 10.7-3.6 30.3-10.2 20.5 60.6-30.3 10.2-40 13.5-29.3 9.9-10.9-29L361.8 352H256.6c-.4 0-.8 0-1.3 0H224 197.8l-5.1-25.7-32-160L153 128z"],
    "user-pilot-tie": [448, 512, [], "e2c1", "M80 99.2V128c16 10.7 67.2 32 144 32s128-21.3 144-32V99.2L400 80V48L224 0 48 48V80L80 99.2zm88.8-40.7l14.3 7.2L224 86.1l40.8-20.4 14.3-7.2 14.3 28.6-14.3 7.2-48 24-7.2 3.6-7.2-3.6-48-24-14.3-7.2 14.3-28.6zM98.1 168.8C96.7 176.3 96 184.1 96 192c0 70.7 57.3 128 128 128s128-57.3 128-128c0-7.9-.7-15.7-2.1-23.2C310.8 183.8 268.4 192 224 192s-86.8-8.2-125.9-23.2zM448 512L400 352H320L252.2 464.9 240 416l32-64H176l32 64-12.2 48.9L128 352H48L0 512l192 0h64l192 0zM320 416h16 32 16v32H368 336 320V416z"],
    "piano-keyboard": [576, 512, [127929], "f8d5", "M576 64H0V448H576V64zM512 224V384H432V320h16V288 224h64zM400 384H304V320h16V288 224h64v64 32h16v64zm-128 0H176V320h16V288 224h64v64 32h16v64zm-128 0H64V224h64v64 32h16v64z"],
    "bed-empty": [640, 512, [128719], "f8f9", "M64 64V32H0V64 256v96 32 64 32H64V448 416H352 576v32 32h64V448 256 224H608 64V64z"],
    "circle-arrow-up": [512, 512, ["arrow-circle-up"], "f0aa", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm17-393L385 231l17 17L368 281.9l-17-17-71-71V376v24H232V376 193.9l-71 71-17 17L110.1 248l17-17L239 119l17-17 17 17z"],
    "toggle-on": [576, 512, [], "f205", "M576 64H0V448H576V64zm-96 96V352H288V160H480z"],
    "rectangle-vertical": [384, 512, ["rectangle-portrait"], "f2fb", "M384 0l0 512L0 512 0 0 384 0z"],
    "person-walking": [320, 512, [128694, "walking"], "f554", "M256 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM142.3 128.6l-10-2-9.3 4.1-72 32-12.9 5.7-4.5 13.4-16 48L7.5 260.2l60.7 20.2 10.1-30.4 11.5-34.6 36.7-16.3-17 63.6c-5.6 21.1-.1 43.6 14.7 59.7l70.9 77.4 22 80.5 8.4 30.9 61.7-16.8-8.4-30.9-24-88-2-7.5-5.2-5.7-52.3-57 18.4-62.4 13.7 27.4 4.8 9.5 9.5 4.8 48 24 28.6-57.2-38.5-19.2-35.2-70.5-7-14-15.3-3.1-80-16zM68.7 398L25.4 441.4 2.7 464 48 509.3l22.6-22.6 48-48 4.6-4.6 2.4-6.1 15.7-39.3-40.7-44.4c-2.5-2.7-4.8-5.6-7-8.6L68.7 398z"],
    "l": [320, 512, [108], "4c", "M96 32V64 416H288h32v64H288 64 32V448 64 32H96z"],
    "signal-stream": [576, 512, [], "f8dd", "M200.1 186.6l-50.2-39.7C126.2 176.9 112 214.8 112 256s14.2 79.1 37.9 109.1l50.2-39.7C185 306.3 176 282.2 176 256s9-50.3 24.1-69.4zm-87.9-69.4L61.9 77.5C23.2 126.6 0 188.6 0 256s23.2 129.4 61.9 178.5l50.2-39.7C82 356.6 64 308.5 64 256s18-100.6 48.2-138.8zM375.9 325.4l50.2 39.7c23.7-30 37.9-67.9 37.9-109.1s-14.2-79.1-37.9-109.1l-50.2 39.7C391 205.7 400 229.8 400 256s-9 50.3-24.1 69.4zm87.9 69.4l50.2 39.7C552.8 385.4 576 323.4 576 256s-23.2-129.4-61.9-178.5l-50.2 39.7C494 155.4 512 203.5 512 256s-18 100.6-48.2 138.8zM288 312a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"],
    "down-to-bracket": [448, 512, [], "e4e7", "M384 192L224 352 64 192V160l96 0L160 0H288l0 160 96 0 0 32zM64 352v96H384V352 320h64v32V480v32H416 32 0V480 352 320H64v32z"],
    "circle-z": [512, 512, [], "e130", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm96-352.5l-4.3 6.2L229.8 336H328h24v48H328 184 160V352.5l4.3-6.2L282.2 176H184 160V128h24H328h24v31.5z"],
    "stars": [512, 512, [], "f762", "M356 60L336 0 316 60 256 80l60 20 20 60 20-60 60-20L356 60zM464 208l-16-48-16 48-48 16 48 16 16 48 16-48 48-16-48-16zM253.3 265.1L193.5 144 133.7 265.1 0 284.6l96.7 94.3L73.9 512l119.6-62.9L313 512 290.2 378.9l96.7-94.3L253.3 265.1z"],
    "fire": [448, 512, [128293], "f06d", "M0 276.5C0 144 176 0 176 0s64.5 59.3 88.6 89.4c11-14.4 47.4-42.9 47.4-42.9s136 113.4 136 229.9C448 404.2 348.2 512 224 512C98.4 512 0 404.1 0 276.5zM225.7 416c25.3 0 47.7-7 68.8-21c42.1-29.4 53.4-88.2 28.1-134.4c-2.8-5.6-5.6-11.2-9.8-16.8l-50.6 58.8s-81.4-103.6-87.1-110.6C133.1 243.8 112 273.2 112 306.8C112 375.4 162.6 416 225.7 416z"],
    "bed-pulse": [640, 512, ["procedures"], "f487", "M472 0h16 14.8l6.6 13.3L534.8 64H616h24v48H616 520 505.2l-6.6-13.3L480.4 62.5 429.7 170.2 423.2 184H408 392 376.4l-6.3-14.3L344.4 112H216 192V64h24H360h15.6l6.3 14.3 18.5 41.5 49.9-106L456.8 0H472zM320 160h10.7l10.1 22.7L355.6 216H392h16 35.5l15.1-32.2L469.9 160H544c53 0 96 43 96 96V480v32H576V480 448H352 320 64v32 32H0V480 96 64H64V96 352H288V192 160h32zm-144 0a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "house-day": [640, 512, [], "e00e", "M160 0L119.6 62.4 46.9 46.9l15.6 72.7L0 160l62.4 40.4L46.9 273.1l72.7-15.6 16.2 25.1 3.2-2.8 52.1-45.1c-9.6 4-20.1 6.3-31.1 6.3c-44.2 0-80-35.8-80-80s35.8-80 80-80s80 35.8 80 80c0 15.1-4.2 29.3-11.5 41.3l67-58.1-38-24.6 15.6-72.7L200.4 62.4 160 0zm48 160a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM400 96L160 304v48h64V512H576V352h64V304L400 96zM352 288h96v96H352V288z"],
    "shuttle-space": [640, 512, ["space-shuttle"], "f197", "M192 480H128l0-96 224 0L192 480zM96 380.8V384v96H32V384H24 0V360 328 184 152 128H24h8V32H96l0 96v3.2L150.7 160H456c70.4 0 127.6 23.5 171.2 81.6L638 256l-10.8 14.4C583.6 328.5 526.4 352 456 352H150.7L96 380.8zM128 128V32h64l160 96-224 0zM512 248c0-22.1-17.9-40-40-40v96c22.1 0 40-17.9 40-40V248z"],
    "shirt-long-sleeve": [640, 512, [], "e3c7", "M136 0H107.6L93.9 24.9l-88 160L0 195.7V208 368v48H96V368 220.3l48-87.3V512H496V133.1l48 87.3V368v48h96V368 208 195.7l-5.9-10.8-88-160L532.4 0H504h-8H460 416c0 53-43 96-96 96s-96-43-96-96H180 144h-8z"],
    "chart-pie-simple": [512, 512, ["chart-pie-alt"], "f64e", "M511.4 240H272V.6c5.3-.4 10.6-.6 16-.6C411.7 0 512 100.3 512 224c0 5.4-.2 10.7-.6 16zM0 272C0 144.8 98.9 40.8 224 32.5V288H479.5C471.2 413.1 367.2 512 240 512C107.5 512 0 404.6 0 272z"],
    "face-laugh": [512, 512, ["laugh"], "f599", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-80c-83 0-151.2-63.1-159.2-144H415.2c-8 80.9-76.2 144-159.2 144zM144.4 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "folder-open": [576, 512, [128194, 128449, 61717], "f07c", "M99.4 209.7L0 408.4V32H208l64 64H480v96H128 108.2l-8.8 17.7zM0 480L128 224H576L448 480H0z"],
    "album-collection-circle-user": [640, 512, [], "e48f", "M32 0H56 456h24V48H456 56 32V0zm8 512L0 160H512l-3.7 32.4c-4.1-.3-8.2-.4-12.3-.4c-46.9 0-89.5 18.3-121 48.2C342.9 220.1 301.4 208 256 208C154.4 208 72 268.9 72 344s82.4 136 184 136c33.2 0 64.4-6.5 91.3-17.9c12.4 19.6 28.6 36.6 47.5 49.9H40zM256 376c-17.7 0-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24s-14.3 24-32 24zM40 80H472h24v48H472 40 16V80H40zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224.7 77.7L552 416H440l-24.7 29.7c20.4 21.2 49 34.3 80.7 34.3s60.3-13.2 80.7-34.3zM544 336a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "candy": [640, 512, [127852], "e3e7", "M318.1 64c-24.5 .2-47.9 5.1-69.4 13.7L419.9 420c20.3-12.4 38.1-28.5 52.6-47.3L318.1 64zM492.3 340.8c4.6-9.3 8.4-19 11.5-29.1l101 53.5L633 327l-35.6-35.6L640 279V233l-42.6-12.5L633 185l-28.2-38.2-101 53.5c-20.5-67.8-77.6-119.8-148.3-133L492.3 340.8zm-101 93.5L220.1 92c-20.3 12.4-38.2 28.5-52.6 47.3L321.9 448c24.5-.2 47.9-5.1 69.4-13.7zM284.5 444.7L147.7 171.2c-4.6 9.3-8.4 19-11.5 29.1l-101-53.5L7 185l35.6 35.6L0 233v46l42.6 12.5L7 327l28.2 38.2 101-53.5c20.5 67.8 77.6 119.8 148.3 133z"],
    "bowl-hot": [512, 512, ["soup"], "f823", "M176 24c0 26.5 10.5 38.7 25.9 56.1l.4 .4C218.8 99 240 122.9 240 168v24H192V168c0-26.5-10.5-38.7-25.9-56.1l-.4-.4C149.2 93 128 69.1 128 24V0h48V24zm128 0c0 26.5 10.5 38.7 25.9 56.1l.4 .4C346.8 99 368 122.9 368 168v24H320V168c0-26.5-10.5-38.7-25.9-56.1l-.4-.4C277.2 93 256 69.1 256 24V0h48V24zM0 224H512l-3.6 61.2C503.5 368.1 454 438.2 384 472.9V512H128V472.9C58 438.2 8.5 368.1 3.6 285.2L0 224z"],
    "flatbread": [512, 512, [129747], "e40b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM171.3 363.3l-22.6-22.6 192-192 22.6 22.6-192 192zm80-240l-128 128-22.6-22.6 128-128 22.6 22.6zm32 288l-22.6-22.6 128-128 22.6 22.6-128 128z"],
    "heart-circle-plus": [576, 512, [], "e500", "M64 288L39.8 263.8C14.3 238.3 0 203.8 0 167.8C0 92.8 60.8 32 135.8 32c36 0 70.5 14.3 96 39.8L256 96l24.2-24.2c25.5-25.5 60-39.8 96-39.8C451.2 32 512 92.8 512 167.8c0 13.8-2.1 27.4-6.2 40.4C483.4 197.8 458.4 192 432 192c-97.2 0-176 78.8-176 176c0 32.2 8.6 62.3 23.7 88.3L256 480 64 288zm368-64a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80V288H416v16 48H368 352v32h16 48v48 16h32V432 384h48 16V352H496 448V304z"],
    "code-fork": [448, 512, [], "e13b", "M104 56v48H56V56h48zM56 0H0V56v48 56H48v32c0 53 43 96 96 96h48v64H144v56 48 56h56 48 56V456 408 352H256V288h48c53 0 96-43 96-96V160h48V104 56 0H392 344 288V56v48 56h48v32c0 17.7-14.3 32-32 32H144c-17.7 0-32-14.3-32-32V160h48V104 56 0H104 56zM392 56v48H344V56h48zM200 408h48v48H200V408z"],
    "city": [640, 512, [127961], "f64f", "M480 0H288V96H224V24 0H176V24 96H112V24 0H64V24 96H0v96V512H288h64H480 640V192H480V0zm96 352v64H512V352h64zm-384 0h64v64H192V352zm-64 64H64V352h64v64zM512 256h64v64H512V256zM64 160h64v64H64V160zm192 96v64H192V256h64zm0-96v64H192V160h64zM64 320V256h64v64H64zm352-64v64H352V256h64zM352 64h64v64H352V64zm64 96v64H352V160h64z"],
    "signal-bars-weak": [640, 512, ["signal-alt-1"], "f691", "M32 384h96V512H32V384z"],
    "microphone-lines": [384, 512, [127897, "microphone-alt"], "f3c9", "M96 0V256c0 53 43 96 96 96s96-43 96-96H208 192V224h16 80V192H208 192V160h16 80V128H208 192V96h16 80V0H96zM320 224v32c0 70.7-57.3 128-128 128s-128-57.3-128-128V216 192H16v24 40c0 89.1 66.2 162.7 152 174.4V464H120 96v48h24 72 72 24V464H264 216V430.4c85.8-11.7 152-85.3 152-174.4V216 192H320v24 8z"],
    "clock-twelve": [512, 512, [], "e358", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392V256v24H232V256 120 96h48v24z"],
    "pepper-hot": [512, 512, [127798], "f816", "M423.9 44.4L419 35.7l42-23.3 4.8 8.7c19.3 34.7 19.8 75.7 3.4 110C495.8 159.6 512 197.9 512 240c0 33.1-10.1 63.9-27.3 89.4L448 256H336L320 144l-88-9.8C261.3 101 304.2 80 352 80c28.3 0 54.8 7.3 77.8 20.2c5.5-18.2 3.7-38.4-6-55.8zM171.2 345.5L262 163.9l29.4 6.5 12.9 90.1 3.9 27.5H336h92.2l23.9 47.8C372.3 443.9 244.3 512 103.2 512H0V432l84.5-18.8c37.6-8.4 69.5-33.2 86.7-67.7z"],
    "citrus-slice": [512, 512, [], "e2f5", "M391.4 391.4C294.5 488.2 137.9 487.9 41 391L7 425c115.6 115.6 302.6 116 418.3 .3S540.5 122.6 425 7L391 41c96.9 96.9 97.1 253.6 .3 350.4zM176 428.3V254c-7.1-1.8-13.7-4.9-19.7-8.8L48 353.5l15.3 15.3c32 32 71.4 51.8 112.7 59.5zm69.1-272c4 5.9 7 12.6 8.8 19.7H428.3c-7.7-41.2-27.4-80.5-59.2-112.4L353.5 48 245.1 156.3zM254 208c-1.5 5.9-3.8 11.4-6.8 16.5L379.6 357c36.8-42.6 54.2-96.1 52.2-149H254zm-29.5 39.1c-5.1 3-10.6 5.3-16.5 6.8V431.9c52.9 1.9 106.4-15.5 149-52.2L224.5 247.1z"],
    "sheep": [640, 512, [128017], "f711", "M576 135.8l14.5 6.2 22.1 9.5 18.9-44.1-22.1-9.5L554.3 74.3 512 32H448L405.7 74.3 350.5 97.9l-22.1 9.5 18.9 44.1 22.1-9.5 14.5-6.2V288H576V135.8zM464 128a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM286.5 90.6l15.8-6.8C290.6 71.6 274.2 64 256 64c-19.2 0-36.5 8.5-48.2 21.9C196.9 77.2 183 72 168 72c-30.1 0-55.3 20.8-62.2 48.8c-3.2-.5-6.5-.8-9.8-.8c-35.3 0-64 28.7-64 64c0 5.3 .7 10.5 1.9 15.5C13.7 210.3 0 231.5 0 256s13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5c0 35.3 28.7 64 64 64c.5 0 1 0 1.5 0L120 512h88V426.3c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7V512h88l22.5-120c.5 0 1 0 1.5 0c35.3 0 64-28.7 64-64c0-2.7-.2-5.4-.5-8H352V184.4l-21.4 9.2L286.5 90.6z"],
    "unlock": [448, 512, [128275], "f09c", "M224 64c-44.2 0-80 35.8-80 80v48H448V512H0V192H80V144C80 64.5 144.5 0 224 0c74.1 0 135.2 56 143.1 128H302.4C295 91.5 262.7 64 224 64z"],
    "colon-sign": [384, 512, [], "e140", "M255.2 23.3l-9.8 41.9c9.9 1.1 19.6 3 29 5.5l14.5-62 62.3 14.5L333.6 98.4c16.8 11.7 31.7 26 43.9 42.4l-51.2 38.4c-2.8-3.8-5.9-7.4-9.1-10.8L268.9 375.9c23.1-8.6 43-23.7 57.5-43.1l51.2 38.4c-29.6 39.4-74 67-125 74.6l-13.4 57.4-62.3-14.5 10.3-44.3c-9.8-1.9-19.3-4.5-28.4-7.9l-15.6 66.7L80.8 488.7l19.9-85.5C58.7 368 32 315.1 32 256C32 165.6 94.5 89.7 178.7 69.4L192.8 8.7l62.3 14.5zM201.7 382.1l58.1-249c-9.3-2.7-19.1-4.4-29.1-4.9L173.4 373.6c9 3.9 18.4 6.7 28.3 8.5zM96 256c0 26.8 8.2 51.6 22.3 72.2l42.9-183.7C122.3 166.4 96 208.1 96 256z"],
    "headset": [512, 512, [], "f590", "M256 48C141.1 48 48 141.1 48 256v40 24H0V296 256C0 114.6 114.6 0 256 0S512 114.6 512 256V464.1v24l-24 0L320 488v24H240c-26.5 0-48-21.5-48-48s21.5-48 48-48h80v24l144 .1V256c0-114.9-93.1-208-208-208zM192 224V384H80V224H192zm240 0V384H320V224H432z"],
    "badger-honey": [640, 512, [129441], "f6b4", "M160 400l20.6-48H298.7L320 480h96L393 342.1c27.9-29 80.6-70.8 144.1-90.8L560 288l29.5-47.2c6.1-.5 12.3-.8 18.5-.8l32-32V144L496 64H432L368 96H192 160 128C57.3 96 0 153.3 0 224v32 32H49.1c9 15.5 21.1 29 35.6 39.5L64 400l24 80h96l-24-80zM368 144h11.3l10.1-5.1L443.3 112h40.2L570 160H518.6c.9 2.5 1.4 5.2 1.4 8c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-2.8 .5-5.5 1.4-8H432L272 256H192c-52.3 0-96.2-35.8-108.5-84.3c14.7-17 36.4-27.7 60.5-27.7H368z"],
    "h4": [640, 512, [], "f86a", "M64 64V96 224H256V96 64h64V96 256 416v32H256V416 288H64V416v32H0V416 256 96 64H64zm576 0V96 416v32H576V416 320H416 377.6l6.9-37.8L424.5 64h65.1L454.4 256H576V96 64h64z"],
    "store-slash": [640, 512, [], "e071", "M579.6 103.8L512 0H128L94.8 50.9 48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L544 399.6V384 252.6c-4 1-8 1.8-12.3 2.3l-.1 0c-5.3 .7-10.7 1.1-16.2 1.1c-12.4 0-24.3-1.9-35.4-5.3v99.2l-179.1-139c7.1-4.4 13.5-9.7 19-15.8c15.9 17.6 39.1 29 65.2 29c26.2 0 49.3-11.4 65.2-29c16 17.6 39.1 29 65.2 29c4.1 0 8.1-.3 12.1-.8c55.5-7.4 81.8-72.5 52.1-119.4zM112.2 223.2c4 .5 8.1 .8 12.1 .8c11 0 21.4-2 31-5.6L48.9 134.5c-6.1 40.6 19.5 82.8 63.3 88.7zM160 384V250.6c-11.2 3.5-23.2 5.4-35.6 5.4c-5.5 0-11-.4-16.3-1.1l-.1 0c-4.1-.6-8.1-1.3-12-2.3V384 512H528L365.5 384H160z"],
    "road-circle-xmark": [640, 512, [], "e566", "M160 32H288V96v32h64V96 32H480l46.5 162.6c-9.9-1.7-20.1-2.6-30.5-2.6c-59.5 0-112.1 29.6-144 74.8V224 192H288v32 64 32h38.6c-4.3 15.3-6.6 31.4-6.6 48c0 5.4 .2 10.7 .7 16H288v32 64H32L160 32zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3L566.6 320 544 297.4l-11.3 11.3L496 345.4l-36.7-36.7L448 297.4 425.4 320l11.3 11.3L473.4 368l-36.7 36.7L425.4 416 448 438.6l11.3-11.3L496 390.6l36.7 36.7L544 438.6 566.6 416l-11.3-11.3L518.6 368l36.7-36.7z"],
    "signal-slash": [640, 512, [], "f695", "M544 512h64v0H544v0zm0-112.4V32 0h64V32 449.3l12.9 10 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L288 200.8V192h64v32 26.5l64 49.7V128 96h64v32V349.9l64 49.7zm-64 74.6V480v32H416V480 423.8l64 50.4zM352 373.3V480v32H288V480 322.9l64 50.4zM224 288v32V480v32H160V480 320 288h64zM96 416v64 32H32V480 416 384H96v32z"],
    "user-minus": [640, 512, [], "f503", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM384 304l64 208H0L64 304H384zm88-104H616h24v48H616 472 448V200h24z"],
    "mars-stroke-up": [320, 512, [9896, "mars-stroke-v"], "f22a", "M160 0L80 80V96h56v24H104 80v48h24 32v24c0 .6 0 1.2 .1 1.8C59.1 205.3 0 271.8 0 352c0 88.4 71.6 160 160 160s160-71.6 160-160c0-80.2-59.1-146.7-136.1-158.2c0-.6 .1-1.2 .1-1.8V168h32 24V120H216 184V96h56V80L160 0zM64 352a96 96 0 1 1 192 0A96 96 0 1 1 64 352z"],
    "champagne-glasses": [640, 512, [129346, "glass-cheers"], "f79f", "M183.6 127.4L209 79.2l61.2 22.3-11.5 53.2-75-27.3zM178.4 0L87.7 172.2C60.2 224.4 76.8 287 122 319.8L91.1 404.7 52 390.4 21.9 379.5 0 439.6l30.1 10.9 69.2 25.2L168.6 501l30.1 10.9 21.9-60.1-30.1-10.9-39.2-14.3 30.9-84.9c55.7 3.9 108.6-33.3 121.2-91L320 173.8l16.7 76.9c12.5 57.7 65.4 94.9 121.2 91l30.9 84.9-39.2 14.3-30.1 10.9 21.9 60.1L471.4 501l69.2-25.2 69.2-25.2L640 439.6l-21.9-60.1L588 390.4l-39.2 14.3L518 319.8c45.2-32.8 61.8-95.4 34.3-147.6L461.6 0 320 51.5 178.4 0zm278 127.4l-75 27.3-11.5-53.2L431 79.2l25.3 48.1z"],
    "taco": [512, 512, [127790], "f826", "M256 32l69.9 54.1 88.3-2.7 24.7 84.9L512 218l-22.2 61.8C437.5 207.2 352.3 160 256 160s-181.5 47.2-233.8 119.8L0 218l73.1-49.7L97.8 83.4l88.3 2.7L256 32zM0 480V448C0 306.6 114.6 192 256 192s256 114.6 256 256v32H0zm112-64a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "hexagon-plus": [512, 512, ["plus-hexagon"], "f300", "M0 256L128 32H384L512 256 384 480H128L0 256zM232 368h48V344 280h64 24V232H344 280V168 144H232v24 64H168 144v48h24 64v64 24z"],
    "clipboard": [384, 512, [128203], "f328", "M192 0c-41.8 0-77.4 26.7-90.5 64H0V512H384V64H282.5C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM112 192H272h16v32H272 112 96V192h16z"],
    "house-circle-exclamation": [640, 512, [], "e50a", "M520.5 193.7L288.4 0 0 240v47.6H64.1V512H224V352h96.7c8.1-89.7 83.5-160 175.3-160c8.3 0 16.5 .6 24.5 1.7zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64H480V416h32v32zm0-176v16 80 16H480V368 288 272h32z"],
    "file-arrow-up": [384, 512, ["file-upload"], "f574", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM216 408v24H168V408 305.9l-31 31-17 17L86.1 320l17-17 72-72 17-17 17 17 72 72 17 17L264 353.9l-17-17-31-31V408z"],
    "wifi": [640, 512, ["wifi-3", "wifi-strong"], "f1eb", "M54.2 202.9C123.2 136.7 216.8 96 320 96s196.8 40.7 265.8 106.9l44.3-46.2C549.7 79.5 440.4 32 320 32S90.3 79.5 9.8 156.7l44.3 46.2zM320 256c56.8 0 108.6 21.1 148.2 56l42.4-48C459.8 219.2 393 192 320 192s-139.8 27.2-190.5 72l42.4 48c39.5-34.9 91.3-56 148.2-56zm64 160a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "messages": [640, 512, ["comments-alt"], "f4b6", "M0 0H416V320H202.7L96 384V320H0V0zM256 448V352H448V128H640V448H544v64L437.3 448H256z"],
    "bath": [512, 512, [128705, "bathtub"], "f2cd", "M64 0H32V32 256H0v64H32 480h32V256H480 96V64h18.7l18.8 18.8C130 91.8 128 101.7 128 112c0 19.6 7 37.5 18.7 51.4L134.1 176 168 209.9l17-17L289 89l17-17L272 38.1 259.4 50.7C245.5 39 227.6 32 208 32c-10.3 0-20.2 2-29.2 5.5L150.6 9.4 141.3 0H128 64zM32 352v16c0 28.4 12.4 54 32 71.6V480v32h64V480 464H384v16 32h64V480 439.6c19.6-17.6 32-43.1 32-71.6V352H32z"],
    "umbrella-simple": [512, 512, ["umbrella-alt"], "e2bc", "M288 0V32v2C414.3 49.7 512 157.5 512 288H0C0 157.5 97.7 49.7 224 34V32 0h64zm0 430.6c0 45-36.5 81.4-81.4 81.4c-30.8 0-59-17.4-72.8-45l-2.3-4.7-14.3-28.6 57.2-28.6 14.3 28.6 2.3 4.7c3 5.9 9 9.6 15.6 9.6c9.6 0 17.4-7.8 17.4-17.4V320h64V430.6z"],
    "rectangle-history-circle-plus": [640, 512, [], "e4a3", "M320 368c0 59.5 29.5 112.1 74.8 144L0 512V160l512 0v32.7c-5.3-.5-10.6-.7-16-.7c-97.2 0-176 78.8-176 176zM464 80v48L48 128V80l416 0zM416 0V48L96 48V0H416zm80 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80V288H480v16 48H432 416v32h16 48v48 16h32V432 384h48 16V352H560 512V304z"],
    "underline": [448, 512, [], "f0cd", "M16 32H48h96 32V96H144 128V224c0 53 43 96 96 96s96-43 96-96V96H304 272V32h32 96 32V96H400 384V224c0 88.4-71.6 160-160 160s-160-71.6-160-160V96H48 16V32zM0 480V416H32 416h32v64H416 32 0z"],
    "prescription-bottle-pill": [576, 512, [], "e5c0", "M0 0H384V96H0V0zM32 128H352v83.2c-57 29.1-96 88.4-96 156.8c0 59.5 29.6 112.1 74.8 144H32V416H144h16V384H144 32V320H144h16V288H144 32V224H144h16V192H144 32V128zM288 368c0-34 11.8-65.2 31.5-89.9L521.9 480.5C497.2 500.2 466 512 432 512c-79.5 0-144-64.5-144-144zm288 0c0 34-11.8 65.2-31.5 89.9L342.1 255.5C366.8 235.8 398 224 432 224c79.5 0 144 64.5 144 144z"],
    "user-pen": [640, 512, ["user-edit"], "f4ff", "M224 0a128 128 0 1 1 0 256A128 128 0 1 1 224 0zM331 417.4L317.4 512H0L64 304H384l14.2 46.2L331 417.4zM569 223.8l71 71-41.3 41.3-71-71L569 223.8zm-63.9 63.9l71 71L434.9 500 352 511.9 363.9 429 505.1 287.8z"],
    "binary-slash": [640, 512, [], "e33e", "M352 0V64h32 16v96H384 352v64h32 48 48 32V160H480 464V32 0H432 384 352zM128 288v64h32 16v96H160 128v64h32 48 48 32V448H256 240V320 288H208 160 128zM160 0H128V32 76.6L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L512 374.7V320 288H480 400.3l-82.4-64H320V192 32 0H288 160zm75.4 160L192 126.3V64h64v96H235.4zM320 480v32h32H480h32V499.4L446.8 448H384V398.5l-64-50.4V480z"],
    "square-o": [448, 512, [], "e278", "M448 32H0V480H448V32zM144 256a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zm80 128a128 128 0 1 1 0-256 128 128 0 1 1 0 256z"],
    "signature": [640, 512, [], "f5b7", "M192 128c0-17.7 14.3-32 32-32s32 14.3 32 32v7.8c0 27.7-2.4 55.3-7.1 82.5l-130 39L96 264.2V288 448v32h32 64 18.6l9.2-16.1 25.5-44.7c26.8-47 46.5-97.7 58.4-150.5l94.4-28.3-12.5 37.5-14 42.1H416 544h32V256H544 460.4l18-53.9 19.5-58.5-59 17.7L316.4 198.1c2.4-20.7 3.6-41.4 3.6-62.3V128c0-53-43-96-96-96s-96 43-96 96v32 32h64V160 128zM160 311.8l71.8-21.5c-10.4 33.8-24.5 66.4-42.1 97.2L173.4 416H160V311.8zM24 368H0v48H24 64.3c-.2-2.8-.3-5.6-.3-8.5V368H24zm592 48h24V368H616 305.9c-6.7 16.3-14.2 32.3-22.3 48H616z"],
    "stroopwafel": [512, 512, [], "f551", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM75 188.1L52.4 210.7l11.3 11.3L97.6 256 63.7 289.9 52.4 301.3 75 323.9l11.3-11.3 33.9-33.9 45.3 45.3-56.6 56.6L97.6 391.8l22.6 22.6 11.3-11.3 56.6-56.6 45.3 45.3-33.9 33.9L188.1 437l22.6 22.6 11.3-11.3L256 414.4l33.9 33.9 11.3 11.3L323.9 437l-11.3-11.3-33.9-33.9 45.3-45.3 56.6 56.6 11.3 11.3 22.6-22.6-11.3-11.3-56.6-56.6 45.3-45.3 33.9 33.9L437 323.9l22.6-22.6-11.3-11.3L414.4 256l33.9-33.9 11.3-11.3L437 188.1l-11.3 11.3-33.9 33.9-45.3-45.3 56.6-56.6 11.3-11.3L391.8 97.6l-11.3 11.3-56.6 56.6-45.3-45.3 33.9-33.9L323.9 75 301.3 52.4 289.9 63.7 256 97.6 222.1 63.7 210.7 52.4 188.1 75l11.3 11.3 33.9 33.9-45.3 45.3-56.6-56.6L120.2 97.6 97.6 120.2l11.3 11.3 56.6 56.6-45.3 45.3L86.3 199.4 75 188.1zm181 181l-45.3-45.3L256 278.6l45.3 45.3L256 369.1zm67.9-67.9L278.6 256l45.3-45.3L369.1 256l-45.3 45.3zM210.7 188.1L256 142.9l45.3 45.3L256 233.4l-45.3-45.3zm-22.6 22.6L233.4 256l-45.3 45.3L142.9 256l45.3-45.3z"],
    "bold": [384, 512, [], "f032", "M0 32H32 80 96 224c70.7 0 128 57.3 128 128c0 31.3-11.3 60.1-30 82.3c37.1 22.4 62 63.1 62 109.7c0 70.7-57.3 128-128 128H96 80 32 0V416H32 48V256 96H32 0V32zM224 224c35.3 0 64-28.7 64-64s-28.7-64-64-64H112V224H224zM112 288V416H256c35.3 0 64-28.7 64-64s-28.7-64-64-64H224 112z"],
    "anchor-lock": [640, 512, [], "e4ad", "M320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm21.1 80C367 158.8 384 129.4 384 96c0-53-43-96-96-96s-96 43-96 96c0 33.4 17 62.8 42.9 80H224 192v64h32 32V448H128V352h64L96 256 0 352H64V480v32H96 288h96l0-64H320V240h32 32V176H352 341.1zM528 240c17.7 0 32 14.3 32 32v48H496V272c0-17.7 14.3-32 32-32zm-80 32v48H416V512H640V320H608V272c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "building-ngo": [384, 512, [], "e4d7", "M384 0H0V512H144V384h96V512H384V0zM64 288V224h64v64H64zm160-64v64H160V224h64zm32 64V224h64v64H256zM32 64H48h8 9.9l4.4 8.8L96 124.2V80 64h32V80v96 16H112h-8H94.1l-4.4-8.8L64 131.8V176v16H32V176 80 64zm136 0h48 16V96H216 184v64h16V144 128h32v16 32 16H216 168 152V176 80 64h16zm120 48v32c0 8.8 7.2 16 16 16s16-7.2 16-16V112c0-8.8-7.2-16-16-16s-16 7.2-16 16zm16-48c26.5 0 48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V112c0-26.5 21.5-48 48-48z"],
    "transporter-3": [512, 512, [], "e045", "M256 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM96 512H216h80H416V448H96v64zm0-256.5c0 .3 0 .7 0 1V288h16H400h16V256H400 112 96v-.5zM464 0L448 32 416 48l32 16 16 32 16-32 32-16L480 32 464 0zM64 128L48 96 32 128 0 144l32 16 16 32 16-32 32-16L64 128zm112 0H160v32h16H336h16V128H336 176zm-32 64H128v32h16H368h16V192H368 144zm32 128H160v32h16H336h16V320H336 176zm0 64H160v32h16H336h16V384H336 176z"],
    "engine-warning": [640, 512, ["engine-exclamation"], "f5f2", "M424 112H400l-72 0v16 16H432l80 64V448H224l-51.2-64H96V280H48v72 24H0V352 160 136H48v24 72H96V144l64 0 48 0 72 0V128 112l-72 0H184V64h24H400h24v48zM324 208V188H284v20 88 20h40V296 208zm4 144H280v48h48V352zM640 192V448H544V192h96z"],
    "circle-down-right": [512, 512, [], "e108", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zm96 192V352H192l-24-24 52-52-76-76 56-56 76 76 52-52 24 24z"],
    "square-k": [448, 512, [], "e274", "M448 32H0V480H448V32zM337.1 128l-1 1.1L238.3 238.3 330 376.7l4.8 7.3H277.2L205.1 275.2 176 307.7V360v24H128V360 298.5 152 128h48v24 83.8L190.1 220l82.5-92h64.5z"],
    "manat-sign": [384, 512, [], "e1d5", "M224 32H160V98.7C69.2 113.9 0 192.9 0 288V448v32H64V448 288c0-59.6 40.8-109.8 96-124V480h64V164c55.2 14.2 96 64.3 96 124V448v32h64V448 288c0-95.1-69.2-174.1-160-189.3V32z"],
    "money-check-pen": [640, 512, ["money-check-edit"], "f872", "M0 64H576V172.4L564.4 184l0 0L331 417.4 326.6 448H0V64zM96 288v32H352V288H96zm352-96H96v32H448V192zm121 31.8l71 71-41.3 41.3-71-71L569 223.8zm-63.9 63.9l71 71L434.9 500 352 511.9 363.9 429 505.1 287.8z"],
    "not-equal": [448, 512, [], "f53e", "M328 32h75.8l-.7 1.1L332.8 144H400h32v64H400 292.3l-60.8 96H400h32v64H400 190.9L120 480H44.3l.7-1.1L115.2 368H48 16V304H48 155.7l60.8-96H48 16V144H48 257.1L328 32z"],
    "border-top-left": [448, 512, ["border-style"], "f853", "M0 448l0 32 64 0 0-32L64 96l352 0 32 0 0-64-32 0L32 32 0 32 0 64 0 448zm160-32l-64 0 0 64 64 0 0-64zm192 0l-64 0 0 64 64 0 0-64zm-96 64l0-64-64 0 0 64 64 0zm192-64l-64 0 0 64 64 0 0-64zM384 288l64 0 0-64-64 0 0 64zm0 32l0 64 64 0 0-64-64 0zm0-128l64 0 0-64-64 0 0 64z"],
    "map-location-dot": [576, 512, ["map-marked-alt"], "f5a0", "M408 120c0 70-120 200-120 200s-120-130-120-200C168 53.7 221.7 0 288 0s120 53.7 120 120zM160 200.9V448L0 512V192l133-53.2c5.5 19.4 15.1 40.6 27 62.1zm224 51.5V512L192 448V252.3c44.5 65.3 96 121 96 121s51.4-55.7 96-121zm32-51.5c2.1-3.8 4.1-7.5 6-11.3L576 128V448L416 512V200.9zM288 152a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "tilde": [448, 512, [63135], "7e", "M0 128H32h96 13.3l9.4 9.4L333.3 320H384V192 160h64v32V352v32H416 320 306.7l-9.4-9.4L114.7 192H64V320v32H0V320 160 128z"],
    "jedi": [576, 512, [], "f669", "M245.2 318.3l-25.1-50.2 50.1 25.1L280 0h16l9.8 293.2 50.1-25.1-25.1 50.2L384 336l-53.2 17.7 25.1 50.2-47.2-23.6 2.2 65.7C370.6 435.2 416 382.9 416 320c0-38.3-16.8-72.7-43.5-96.1C417.8 195.6 448 145.3 448 88c0-30.5-8.5-59-23.3-83.2c64.9 37.8 112.8 101.7 129.2 177.4L512 224h47.5c.3 5.3 .5 10.6 .5 16c0 18.2-1.8 36-5.2 53.2L496 352h39.9C493.3 446.4 398.3 512 288 512S82.7 446.4 40.1 352H80L21.2 293.2C17.8 276 16 258.2 16 240c0-5.4 .2-10.7 .5-16H64L22.2 182.2C38.5 106.5 86.4 42.6 151.3 4.8C136.5 29 128 57.5 128 88c0 57.3 30.2 107.6 75.5 135.9C176.8 247.3 160 281.7 160 320c0 62.9 45.4 115.2 105.1 126l2.2-65.7-47.2 23.6 25.1-50.2L192 336l53.2-17.7z"],
    "square-poll-vertical": [448, 512, ["poll"], "f681", "M448 32H0V480H448V32zM160 224V384H96V224h64zm32-96h64V384H192V128zM352 288v96H288V288h64z"],
    "arrow-down-square-triangle": [576, 512, ["sort-shapes-down-alt"], "f889", "M160 479.6l23.7-26 80-88 21.5-23.7-47.4-43-21.5 23.7L192 349.2V64 32H128V64 349.2l-24.3-26.8L82.2 298.8l-47.4 43 21.5 23.7 80 88 23.7 26zM416 288L304 480H528L416 288zM512 32H320V224H512V32z"],
    "mug-hot": [512, 512, [9749], "f7b6", "M112 0H64V24c0 38.9 23.4 59.4 39.1 73.1l1.1 1C120.5 112.3 128 119.9 128 136v24h48V136c0-38.9-23.4-59.4-39.1-73.1l-1.1-1C119.5 47.7 112 40.1 112 24V0zM0 192V512H384V416h16c61.9 0 112-50.1 112-112s-50.1-112-112-112H384 352 0zm384 64h16c26.5 0 48 21.5 48 48s-21.5 48-48 48H384V256zM224 24V0H176V24c0 38.9 23.4 59.4 39.1 73.1l1.1 1C232.5 112.3 240 119.9 240 136v24h48V136c0-38.9-23.4-59.4-39.1-73.1l-1.1-1C231.5 47.7 224 40.1 224 24z"],
    "dog-leashed": [576, 512, [129454], "f6d4", "M176 192h80V383.3c-5.3 .5-10.6 .7-16 .7c-28.8 0-56-6.9-80-19.2V512H64V247.1c-29.1-13.6-50.5-41.4-54.8-75.1l-1-7.9-4-31.8 63.5-7.9 4 31.8 1 7.9c2 16 15.6 28 31.8 28H144h16 16zM320 364.8c-10.1 5.2-20.8 9.4-32 12.6V208.1L416 262l0 250H320V364.8zM426.7 192l-6.2 37.2L305.9 180.9 336 0h32l24 32h72l32 32h80v48c0 44.2-35.8 80-80 80H464 448 426.7zM448 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM132.6 13L275 148.4l11.6 11-22 23.2-11.6-11L110.6 36.2 99 25.2 121 2l11.6 11z"],
    "car-battery": [512, 512, ["battery-car"], "f5df", "M80 64H208V96h96V64H432V96h80V448H0V96H80V64zM384 192V176H352v16 32H320 304v32h16 32v32 16h32V288 256h32 16V224H416 384V192zM80 224v32H96h96 16V224H192 96 80z"],
    "face-downcast-sweat": [512, 512, [], "e371", "M48 0L86.4 51.2c2 2.7 3.7 5.6 5.1 8.6C94.5 66.1 96 73 96 80c0 9.9-3 19.2-8.2 26.8C79.2 119.6 64.6 128 48 128c-4.4 0-8.7-.6-12.8-1.7c0 0 0 0 0 0C14.9 120.7 0 102.1 0 80C0 69.6 3.4 59.5 9.6 51.2L48 0zm80 80c0-13.9-3.6-27.4-10.4-39.4C157.5 14.9 205 0 256 0C397.4 0 512 114.6 512 256s-114.6 256-256 256S0 397.4 0 256c0-35.8 7.3-69.9 20.6-100.8c8.5 3.1 17.8 4.8 27.4 4.8c44.2 0 80-35.8 80-80zM316.1 410.7l10.7 11.9 23.8-21.4-10.7-11.9C323.8 371.4 295.7 352 256 352s-67.8 19.4-83.9 37.3l-10.7 11.9 23.8 21.4 10.7-11.9c11.7-13 31.6-26.7 60.1-26.7s48.4 13.7 60.1 26.7zM96 256v32h16 96 16V256H208 112 96zm208 0H288v32h16 96 16V256H400 304z"],
    "mailbox-flag-up": [576, 512, [], "e5bb", "M576 208c0-42.6-18.5-81-48-107.3V80 16H464 400 336V64H245.2C290.4 95.9 320 148.5 320 208V448H576V208zM384 224V208 112 80 64h16l64 0h16V80v32 16H464 416v80 16H384zM0 208V448H288V208c0-79.5-64.5-144-144-144S0 128.5 0 208zm64 0c0-8.8 7.2-16 16-16H208c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16z"],
    "memo-circle-info": [576, 512, [], "e49a", "M384 0H0V512H330.8C285.6 480.1 256 427.5 256 368c0-80.6 54.1-148.5 128-169.4V0zM80 128H304h16v32H304 80 64V128H80zm0 96H240h16v32H240 80 64V224H80zm0 96h96 16v32H176 80 64V320H80zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm15.3-224v32h-32V288h32zm1.2 64v16 64l15.5 0 0 32-15.5 0H448l-32 0-16 0 0-32 16 0 .5 0V384l-.5 0-16 0 0-32 16 0 16.5 0 16 0z"],
    "gift": [512, 512, [127873], "f06b", "M190.5 68.8L225.3 128H224 152c-22.1 0-40-17.9-40-40s17.9-40 40-40h2.2c14.9 0 28.8 7.9 36.3 20.8zM64 88c0 14.4 3.5 28 9.6 40H0V256H512V128H438.4c6.1-12 9.6-25.6 9.6-40c0-48.6-39.4-88-88-88h-2.2c-31.9 0-61.5 16.9-77.7 44.4L256 85.5l-24.1-41C215.7 16.9 186.1 0 154.2 0H152C103.4 0 64 39.4 64 88zm336 0c0 22.1-17.9 40-40 40H288h-1.3l34.8-59.2C329.1 55.9 342.9 48 357.8 48H360c22.1 0 40 17.9 40 40zM32 288V512H224V288H32zM288 512H480V288H288V512z"],
    "dice-two": [448, 512, [9857], "f528", "M0 32H448V480H0V32zM352 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "volume": [576, 512, [128265, "volume-medium"], "f6a8", "M32 160V352H160L304 480h48V32H304L160 160H32zM441.6 332.8C464.9 315.3 480 287.4 480 256s-15.1-59.3-38.4-76.8l-28.8 38.4c11.7 8.8 19.2 22.7 19.2 38.4s-7.5 29.6-19.2 38.4l28.8 38.4zm57.6 76.8c46.6-35 76.8-90.8 76.8-153.6s-30.2-118.6-76.8-153.6l-28.8 38.4c35 26.3 57.6 68.1 57.6 115.2s-22.6 88.9-57.6 115.2l28.8 38.4z"],
    "transporter-5": [512, 512, [], "e2a6", "M480 32l32 16L480 64 464 96 448 64 416 48l32-16L464 0l16 32zM48 128l16 32 32 16L64 192 48 224 32 192 0 176l32-16 16-32zM416 512H296 216 96V448H416v64zM224 0h64 16V32H288 224 208V0h16zM176 128H336h16v32H336 176 160V128h16zM112 256H400h16v32H400 112 96V256h16zm64 128H336h16v32H336 176 160V384h16z"],
    "gauge-circle-bolt": [640, 512, [], "e496", "M496 192c2.7 0 5.3 .1 8 .2C475.6 81.7 375.4 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c39.5 0 77-9 110.4-25C337.6 455.7 320 413.9 320 368c0-97.2 78.8-176 176-176zM320 352c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3V88 64h48V88 292.7c23.5 9.5 40 32.5 40 59.3zM144 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM336 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm24-224l-10.7 64H576L472 448l10.7-64H416l104-96z"],
    "coin-front": [512, 512, [], "e3fc", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM256 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320zm0 352a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm24-264V160H232v24V328v24h48V328 184z"],
    "file-slash": [640, 512, [], "e3a7", "M128 76.6L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L512 374.7V160H352V0H128V76.6zM128 512H512V499.4L128 196.8V512zM512 128L384 0V128H512z"],
    "message-arrow-up-right": [512, 512, [], "e1dd", "M0 0H512V416H304L160 512V416H0V0zM200 128H176v48h24 54.1l-87 87-17 17L184 313.9l17-17 87-87V264v24h48V264 152 128H312 200z"],
    "treasure-chest": [576, 512, [], "f723", "M0 160v96H128V32C57.3 32 0 89.3 0 160zM0 480H128V288H0V480zm416 0V288H352v64H224V288H160V480H416zm160 0V288H448V480H576zm0-320c0-70.7-57.3-128-128-128V256H576V160zM416 256V32H160V256h64V192H352v64h64zM304 240V224H272v16 64 16h32V304 240z"],
    "chess-queen": [512, 512, [9819], "f445", "M200 56a56 56 0 1 1 112 0A56 56 0 1 1 200 56zM64 480l48-48H400l48 48v32H64V480zM424 192c20.6 0 39-9.7 50.7-24.9L512 192 400 400H112L0 192l37.3-24.9C49 182.3 67.4 192 88 192c35.3 0 64-28.7 64-64h42c6.2 24 26 42.6 50.7 47c3.4 .6 7.2 1 11.3 1s7.8-.3 11.3-1c24.7-4.4 44.5-23 50.7-47h42c0 35.3 28.7 64 64 64z"],
    "paintbrush-fine": [576, 512, ["paint-brush-alt", "paint-brush-fine", "paintbrush-alt"], "f5a9", "M575.2 80l-39.6 39.6L306.9 348.3l-79.2-79.2L456.4 40.4 496 .8 575.2 80zM205.1 291.7l79.2 79.2-.1 .1c2.5 9.3 3.8 19 3.8 29c0 61.9-50.1 112-112 112H0V448H64V400c0-61.9 50.1-112 112-112c10 0 19.8 1.3 29 3.8l.1-.1z"],
    "glasses": [576, 512, [], "f530", "M61 31.9l21.8 3.2 88.7 13.2 23.7 3.5-7 47.5-23.7-3.5L97.6 85.8c-8.4 34.3-15.4 59.6-22.4 84.6l0 0-.3 1c-8.1 29-16.1 57.8-26.2 100.6H224h32v32h64V272h32H527.3c-10.1-42.8-18.1-71.7-26.2-100.6l-.3-1 0 0 0 0 0 0c-7-25-14-50.3-22.4-84.6l-66.9 9.9-23.7 3.5-7-47.5 23.7-3.5 88.7-13.2L515 31.9l5 21.5c10.5 44.8 18.8 74.3 27.1 104.2l.2 .9c8.5 30.3 17.1 61.2 28 108.1l.6 2.7V272v0 32 48 24 72 32H544 352 320V448 368H256v80 32H224 32 0V448 376 352 304 272v0-2.8l.6-2.7c10.9-46.9 19.5-77.7 28-108.1l.3-.9C37.2 127.7 45.5 98.1 56 53.4l5-21.5zM64 336v80H192V336H64zm320 80H512V336H384v80z"],
    "hood-cloak": [576, 512, [], "f6ef", "M0 464v48H128V320c0-88.4 71.6-160 160-160s160 71.6 160 160V512H576V464l-64-80V288c0-98.4-42.4-172.6-104.8-215.2L480 0H288C160 0 64 128 64 288v96L0 464zm416 48V320c0-70.7-57.3-128-128-128s-128 57.3-128 128V512H416z"],
    "square-quote": [448, 512, [], "e329", "M0 32H448V480H0V32zM208 160H96V272h64v8c0 13.3-10.7 24-24 24H112v48h24c39.8 0 72-32.2 72-72v-8V216 192 160zm32 0V272h64v8c0 13.3-10.7 24-24 24H256v48h24c39.8 0 72-32.2 72-72v-8V216 192 160H240z"],
    "up-left": [384, 512, [], "e2bd", "M16 80V368l32 32L152 296 304 448l80-80L232 216 336 112 304 80H16z"],
    "bring-front": [640, 512, [], "f857", "M64 64h64 32 32 64V0H192 64 0V64 192v64H64h64V192H64V64zM480 448H448 384v64h64H576h64V448 320 256H576 512v64h64V448H512 480zm0-352H160V416H480V96z"],
    "chess-board": [448, 512, [], "f43c", "M448 32H0V480H448V32zM128 96v64h64V96h64v64h64V96h64v64H320v64h64v64H320v64h64v64H320V352H256v64H192V352H128v64H64V352h64V288H64V224h64V160H64V96h64zm64 128h64V160H192v64zm0 64V224H128v64h64zm64 0H192v64h64V288zm0 0h64V224H256v64z"],
    "burger-cheese": [512, 512, [127828, "cheeseburger"], "f7f1", "M32 192v32H480V192s0-160-224-160S32 192 32 192zm96-80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm240 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM256 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM480 384H32v96H480V384zM224 256H192v0H16v96H496V256H448v0H416l-96 64-96-64z"],
    "building-circle-check": [640, 512, [], "e4d2", "M384 0H0V512H144V384h96V512H384v-8.2c-39.1-32.3-64-81.1-64-135.8s24.9-103.5 64-135.8V0zM64 224h64v64H64V224zm160 0v64H160V224h64zm32 0h64v64H256V224zM128 96v64H64V96h64zm32 0h64v64H160V96zm160 0v64H256V96h64zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-65.4-32l-11.3 11.3-72 72L480 430.6l-11.3-11.3-40-40L417.4 368 440 345.4l11.3 11.3L480 385.4l60.7-60.7L552 313.4 574.6 336z"],
    "repeat-1": [512, 512, [128258], "f365", "M0 96V224v32H64V224 128H320v64h32l96-96L352 0H320V64H32 0V96zM512 416V288 256H448v32 96H192V320H160L64 416l96 96h32V448H480h32V416zM224 240h16v56 24h48V296 216 192H264 224h-8v48h8z"],
    "arrow-down-to-line": [384, 512, ["arrow-to-bottom"], "f33d", "M214.6 342.6L192 365.3l-22.6-22.6-128-128L18.7 192 64 146.7l22.6 22.6L160 242.7V64 32h64V64 242.7l73.4-73.4L320 146.7 365.3 192l-22.6 22.6-128 128zM32 416H352h32v64H352 32 0V416H32z"],
    "grid-5": [448, 512, [], "e199", "M0 32H64V96H0V32zm0 96H64v64H0V128zm64 96v64H0V224H64zM0 320H64v64H0V320zm64 96v64H0V416H64zM96 32h64V96H96V32zm64 96v64H96V128h64zM96 224h64v64H96V224zm64 96v64H96V320h64zM96 416h64v64H96V416zM256 32V96H192V32h64zm-64 96h64v64H192V128zm64 96v64H192V224h64zm-64 96h64v64H192V320zm64 96v64H192V416h64zM288 32h64V96H288V32zm64 96v64H288V128h64zm-64 96h64v64H288V224zm64 96v64H288V320h64zm-64 96h64v64H288V416zM448 32V96H384V32h64zm-64 96h64v64H384V128zm64 96v64H384V224h64zm-64 96h64v64H384V320zm64 96v64H384V416h64z"],
    "right-long-to-line": [640, 512, [], "e444", "M640 96V64H576V96 416v32h64V416 96zM352 416L512 256 352 96H320v96L0 192V320l320 0v96h32z"],
    "person-chalkboard": [640, 512, [], "e53d", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H122.8l-9.3 15.5L48.9 251.1 32.4 278.5l54.9 33L103.7 284 120 256.9V480v32h64V480 352h16V480v32h64V480 192h56 64 16 32V128H400 384V64H576V256H384V224H320v32 64h64H576h64V256 64 0H576 384 320V64v64H243.1 140.9z"],
    "mars-stroke-right": [640, 512, [9897, "mars-stroke-h"], "f22b", "M320 256A112 112 0 1 0 96 256a112 112 0 1 0 224 0zm62.4 24C370.7 365.8 297.1 432 208 432c-97.2 0-176-78.8-176-176s78.8-176 176-176c89.1 0 162.7 66.2 174.4 152H416V184 160h48v24 48h32V160h32l96 96-96 96H496V280H464v48 24H416V328 280H382.4z"],
    "hand-back-fist": [448, 512, ["hand-rock"], "f255", "M192 0H96V80 96v32 48 16H64V176 128H32V233.5c0 44.7 19.8 87 54.1 115.6c12.6 10.5 26.8 18.8 41.9 24.7V512H352V374.7c46.9-19 80-65 80-118.7V224 128 96H352V64H272V32H192V0z"],
    "grid-round-5": [448, 512, [], "e5de", "M64 64A32 32 0 1 1 0 64a32 32 0 1 1 64 0zm0 96A32 32 0 1 1 0 160a32 32 0 1 1 64 0zM32 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64A32 32 0 1 1 0 352a32 32 0 1 1 64 0zM32 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM160 64A32 32 0 1 1 96 64a32 32 0 1 1 64 0zM128 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM128 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM352 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM320 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM320 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "tally": [640, 512, ["tally-5"], "f69c", "M160 32V64 278.5l64-22.6V64 32h64V64 233.4l64-22.6V64 32h64V64 188.2l64-22.6V64 32h64V64v79l37.4-13.2 30.2-10.7 21.3 60.4-30.2 10.7L544 210.9V448v32H480V448 233.5l-64 22.6V448v32H352V448 278.6l-64 22.6V448v32H224V448 323.8l-64 22.6V448v32H96V448 369L58.6 382.2 28.5 392.8 7.2 332.5l30.2-10.6L96 301.1V64 32h64z"],
    "square-caret-up": [448, 512, ["caret-square-up"], "f151", "M448 32H0V480H448V32zM96 288L224 160 352 288v32H96V288z"],
    "cloud-showers-water": [576, 512, [], "e4e4", "M224 0c38.6 0 71.9 22.8 87.2 55.7C325.7 41.1 345.8 32 368 32c38.7 0 71 27.5 78.4 64H448c35.3 0 64 28.7 64 64v64H64V160c0-35.3 28.7-64 64-64c0-53 43-96 96-96zM32 384l72-128h48L80 384H32zM264 256L192 384H144l72-128h48zm64 0h48L304 384H256l72-128zm160 0L416 384H368l72-128h48zM272.4 493.1c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 502.1 31.9 512 0 512V448c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M64 32V64 416H480h32v64H480 32 0V448 64 32H64zm64 64l32 0 192 0 32 0v64l-32 0-192 0-32 0 0-64zm32 96H288h32v64H288 160 128V192h32zm0 96H416h32v64H416 160 128V288h32z"],
    "hands-bubbles": [576, 512, ["hands-wash"], "e05e", "M416 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM32 128l0 32 .1 72.6c.1 52.2 23.9 101 63.9 133c.8-80.9 42.8-155.8 111.5-198.8l46.6-29.1 34.2-21.4 39-67.5 12-20.8L297.7 4l-12 20.8-84 145.5-20.8-12L244.2 48.8l12-20.8L214.6 4l-12 20.8L139.4 134.3l0 0-43.3 75L96 160l0-32L32 128zm284.1-11.8l28.8 46.1 28.7-49.8 12-20.8-41.6-24-12 20.8-16 27.7zm43.2 69.1L376 212h23.4L420 176.2l12-20.8-41.6-24-12 20.8-19.1 33.1zm-61.1-37.4l-27.1 17-60.2 37.6C159.3 234.7 128 291.2 128 352v8c0 8.9 .8 17.6 2.2 26.1c35.4 8.2 61.8 40 61.8 77.9c0 6.3-.7 12.5-2.1 18.4C215.1 501 246.3 512 280 512H456h24V464H456 352V440H488h24V392H488 352V368H520h24V320H520 352V296H488h24V248H488 352v0H258.8L305 219.1l27.1-17-33.9-54.3zM544 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM112 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "less-than-equal": [448, 512, [], "f537", "M413.3 33.8l2.7-1v67.9L159.5 192 416 283.2v67.9l-2.7-1-360-128L32 214.6V169.4l21.3-7.6 360-128zM32 416H416h32v64H416 32 0V416H32z"],
    "train": [448, 512, [128646], "f238", "M448 0H0V448H66.7L25.4 489.4 2.7 512H93.3l64-64H290.7l64 64h90.5l-22.6-22.6L381.3 448H448V0zM384 64V224H64V64H384zM176 336a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "up-from-dotted-line": [448, 512, [], "e456", "M64 192L224 32 384 192v32H288V384H160V224H64V192zm0 224v64H0V416H64zm96 0v64H96V416h64zm32 64V416h64v64H192zm160-64v64H288V416h64zm32 0h64v64H384V416z"],
    "eye-low-vision": [640, 512, ["low-vision"], "f2a8", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L524 384.1c41.9-44 70.2-93.9 84-128.1C578 181.3 478.4 32 320 32c-66.9 0-123.2 26.6-168.3 63L48.4 14.8zM222.5 150c51.7-47.6 131.8-51.4 188-5.9c54.7 44.3 68.5 120.3 36.3 180.1l-38.7-30.1c5.1-11.7 7.9-24.6 7.9-38.1c0-53-43-96-96-96c-6.4 0-12.7 .6-18.8 1.8l11.6 58.2L222.5 150zM444.9 446.6L85.7 163.5c-10.9 14.3-20.4 28.6-28.5 42.2L393.1 469c18.3-5.7 35.6-13.3 51.8-22.4zM329.2 479.8L34.9 249.2c-1 2.3-2 4.6-2.9 6.8c30 74.7 129.6 224 288 224c3.1 0 6.1-.1 9.2-.2z"],
    "traffic-light-go": [320, 512, [], "f638", "M320 0H0V352c0 88.4 71.6 160 160 160s160-71.6 160-160V0zM160 416a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm0-200a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm0 72a48 48 0 1 1 0-96 48 48 0 1 1 0 96zM136 112a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm72 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"],
    "face-exhaling": [576, 512, [], "e480", "M256 512c55.8 0 107.4-17.9 149.5-48.2c-10.5-9.3-17.9-22.1-20.5-36.5l-42.2-12.7L320 407.8V360.2l22.8-6.8L385 340.7c5.3-30 31.5-52.7 63-52.7c.7 0 1.4 0 2.1 0c13.2-14.7 32.3-24 53.7-24c2.7 0 5.4 .2 8.1 .5c.1-2.8 .1-5.6 .1-8.5C512 114.6 397.4 0 256 0S0 114.6 0 256S114.6 512 256 512zM203.2 234.4l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2c21.6 28.8 64.8 28.8 86.4 0zm105.6 0c21.6 28.8 64.8 28.8 86.4 0l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2zM256 344a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm287.4-5.5c.1-.8 .1-1.7 .1-2.5c0-22.1-17.9-40-39.9-40c-16.9 0-31.4 10.5-37.2 25.4c-3.3-.9-6.9-1.4-10.5-1.4c-22.1 0-39.9 17.9-39.9 40c0 1.6 .1 3.2 .3 4.7L352 384l65.8 19.8c-1.2 3.9-1.9 8-1.9 12.2c0 22.1 17.9 40 39.9 40c4.9 0 9.6-.9 14-2.5c7.1 11.1 19.5 18.5 33.7 18.5c22.1 0 39.9-17.9 39.9-40c0-.8 0-1.7-.1-2.5c19-6.4 32.6-24.4 32.6-45.5s-13.6-39.1-32.6-45.5z"],
    "sensor-fire": [640, 512, [], "e02a", "M448 32H0V480H336.8C306.5 446.1 288 401.3 288 352.2c0-56.8 36.1-108.8 71.8-150.1c26.7-30.8 56.6-57.5 88.2-83.1V32zM112 120V264v24H64V264 120 96h48v24zm96 0V264v24H160V264 120 96h48v24zM513 224.1c-32.3-37.5-65-64-65-64s-128 103.6-128 192s71.6 160 160 160s160-71.6 160-160c0-73.6-96-160-96-160s-13.9 12.5-31 32zM530 433c-15 10-31 15-49 15c-45 0-81-29-81-78c0-24 15-45 45-82c4 5 62 79 62 79l36-42c3 4 5 8 7 12c18 33 10 75-20 96z"],
    "user-unlock": [640, 512, [], "e058", "M352 128A128 128 0 1 0 96 128a128 128 0 1 0 256 0zm32 384l0-208 0 0H64L0 512H384zM496 272c0-17.7 14.3-32 32-32s32 14.3 32 32h48c0-44.2-35.8-80-80-80s-80 35.8-80 80v48H416V512H640V320H608 560 512 496V272z"],
    "hexagon-divide": [512, 512, [], "e1ad", "M0 256L128 32H384L512 256 384 480H128L0 256zM288 128H224v64h64V128zM168 232H144v48h24H344h24V232H344 168zm56 88v64h64V320H224z"],
    "00": [640, 512, [], "e467", "M144 32C64.5 32 0 96.5 0 176V336c0 79.5 64.5 144 144 144s144-64.5 144-144V176c0-79.5-64.5-144-144-144zM64 176c0-44.2 35.8-80 80-80s80 35.8 80 80V336c0 44.2-35.8 80-80 80s-80-35.8-80-80V176zM496 32c-79.5 0-144 64.5-144 144V336c0 79.5 64.5 144 144 144s144-64.5 144-144V176c0-79.5-64.5-144-144-144zM416 176c0-44.2 35.8-80 80-80s80 35.8 80 80V336c0 44.2-35.8 80-80 80s-80-35.8-80-80V176z"],
    "crow": [640, 512, [], "f520", "M456 0c-48.6 0-88 39.4-88 88v29.2L.3 400l39 50.7L126.1 384H259.2l18.6 45.1 14 34 14 34 6.1 14.9h51.9l-13.6-33.1-14-34-14-34L311.1 384H352c1.1 0 2.1 0 3.2 0l46.6 113.2 6.1 14.9h51.9l-13.6-33.1-42-102C484.9 354.1 544 280 544 192V128v-8l96-24V64L592 32H523.9C507.7 12.5 483.3 0 456 0zm0 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "cassette-betamax": [576, 512, ["betamax"], "f8a4", "M576 32H0v96H576V32zm0 128H0V480H576V160zM192 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM64 320a96 96 0 1 1 192 0A96 96 0 1 1 64 320zm256-96H512V416H320V224z"],
    "sailboat": [576, 512, [], "e445", "M256 352V0L528 352H256zM0 384H576L480 512H96L0 384zM224 64V352H48L224 64z"],
    "window-restore": [512, 512, [], "f2d2", "M448 64H192V96H128V64 0h64H448h64V64 320v64H448 416V320h32V64zM0 512V128H384V512H0zM64 256H320V192H64v64z"],
    "nfc-magnifying-glass": [640, 512, [], "e1f9", "M0 32H448V160c-22.8 0-44.4 4.8-64 13.3V112 96H368 224 208v16 98.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V128H352v64c-38.9 29.2-64 75.7-64 128c0 22.8 4.8 44.4 13.3 64H96V128h48 16V96H144 80 64v16V400v16H80 320c29.2 38.9 75.7 64 128 64H0V32zM448 400.2a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 48c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 26.7-8.2 51.4-22.1 71.9l63 62.6 17 16.9-33.8 34-17-16.9L520 426c-20.5 14-45.3 22.1-72 22.1z"],
    "file-binary": [384, 512, [], "e175", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM80 256h96 16v16V400v16H176 80 64V400 272 256H80zM96 384h64V288H96v96zM240 256h32 16v16V384h16 16v32H304 272 240 224V384h16 16V288H240 224V256h16z"],
    "circle-v": [512, 512, [], "e12a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM383.9 144L278 385.6 271.7 400H240.3L234 385.6 128.1 144h52.4L256 316.2 331.5 144h52.4z"],
    "square-plus": [448, 512, [61846, "plus-square"], "f0fe", "M448 32H0V480H448V32zM200 368V344 280H136 112V232h24 64V168 144h48l0 24v64h64 24v48H312 248v64 24H200z"],
    "bowl-scoops": [448, 512, [127813], "e3df", "M224 208c0-22.7 6.7-43.8 18.3-61.4c19.8-30.2 53.8-50.2 92.6-50.6l1.1 0c61.9 0 112 50.1 112 112c0 5.4-.4 10.8-1.1 16H225.1c-.7-5.2-1.1-10.6-1.1-16zM0 208C0 146.1 50.1 96 112 96l1.1 0c38.7 .4 72.7 20.4 92.6 50.6C196.9 165.2 192 186 192 208c0 5.4 .3 10.7 .9 16H1.1C.4 218.8 0 213.4 0 208zM325.4 64.4c-40.9 3-77.1 23-101.4 53.1c-24.3-30.1-60.5-50.1-101.4-53.1C140.5 26.3 179.2 0 224 0s83.5 26.3 101.4 64.4zM4.5 300.7L0 256H448l-4.5 44.7C437 366.2 381.9 416 316.2 416H256l80 72v24H112V488l80-72H131.8C66.1 416 11 366.2 4.5 300.7z"],
    "mistletoe": [576, 512, [], "f7b4", "M312 24V0H264V24v94.1l-98 98L91.3 230.4C38.3 240.6 0 287 0 341c0 41.4 33.6 75 75 75c50.5 0 94.3-33.5 108.1-81.2c7.2 10.4 19.3 17.2 32.9 17.2c22.1 0 40-17.9 40-40s-17.9-40-40-40c-7.9 0-15.3 2.3-21.5 6.3l5.4-28.2L264 185.9v72.4c14.7 13.2 24 32.3 24 53.7c0 39.8-32.2 72-72 72c-7.2 0-14.2-1.1-20.8-3c-2.1 8.4-3.2 17.1-3.2 25.9V416c0 53 43 96 96 96s96-43 96-96v-9.1c0-25.1-9-49.4-25.3-68.4L312 284V185.9L376.1 250l14.4 74.7C400.6 377.7 447 416 501 416c41.4 0 75-33.6 75-75c0-54-38.3-100.3-91.3-110.5L410 216.1l-98-98V24zm64 88a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "custard": [576, 512, [127854], "e403", "M448 64l25.9 116.5-69.5-19.9-4.4-1.3-4.4 1.3L288 191.4 180.4 160.6l-4.4-1.3-4.4 1.3-69.5 19.9L128 64H448zM64.3 350.9L94.2 216 176 192.6l107.6 30.7 4.4 1.3 4.4-1.3L400 192.6 481.8 216 512 352 64.3 350.9zM32 384H544h32v64H544 32 0V384H32z"],
    "lacrosse-stick": [512, 512, [], "e3b5", "M336 64v0c.1 0 .2 0 .3 0c19.9 0 48.1 13.6 73.1 38.6s38.6 53.2 38.6 73.1c0 .1 0 .2 0 .3h0c0 33.1-21.9 62.1-53.7 71.2l-35.1 10L353 259l-5 4-54 43.2c-11.1 8.9-25 13.8-39.2 13.8c-34.7 0-62.8-28.1-62.8-62.8c0-14.3 4.9-28.1 13.8-39.2L249 164l4-5 1.8-6.2 10-35.1C273.9 85.9 302.9 64 336 64zm0-64V0C274.4 0 220.2 40.9 203.3 100.1L195 129l-39.2 49c-18 22.5-27.8 50.4-27.8 79.2c0 23.4 6.3 45.3 17.4 64.1l-120 120L2.7 464 48 509.3l22.6-22.6 120-120c18.8 11.1 40.7 17.4 64.1 17.4c28.8 0 56.7-9.8 79.2-27.8L383 317l28.9-8.3C471.1 291.8 512 237.6 512 176h0c0-.1 0-.2 0-.3c0-43.8-26.4-87.4-57.3-118.4S380.1 0 336.3 0c-.1 0-.2 0-.3 0z"],
    "hockey-mask": [448, 512, [], "f6ee", "M0 240C0 432 48 512 224 512s224-80 224-272V0H224 0V240zM160 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM176 296a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-24 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM272 296a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM264 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm8 280a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-24 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM128 272c-35.3 0-64-28.7-64-64V176H192v32c0 35.3-28.7 64-64 64zm256-64c0 35.3-28.7 64-64 64s-64-28.7-64-64V176H384v32z"],
    "sunrise": [576, 512, [127749], "f766", "M354.5 154.9L320 123.5V208v32H256V208 123.5l-34.5 31.3-23.7 21.5L154.8 129l23.7-21.5 88-80L288 8l21.5 19.6 88 80L421.2 129l-43 47.4-23.7-21.5zM182 224l106 73.1L394 224l23.3 126.7L544 374l-40 58H406.7c-19-46.9-65-80-118.7-80s-99.7 33.1-118.7 80H72L32 374l126.7-23.3L182 224zm22.9 208c16.6-28.7 47.6-48 83.2-48s66.6 19.3 83.2 48H204.8zM0 464H24 552h24v48H552 24 0V464z"],
    "panel-ews": [512, 512, [], "e42e", "M512 0H0V288H16c44.2 0 80 35.8 80 80v16c0 17.7 14.3 32 32 32s32-14.3 32-32V352H128V256h96v96H192v32c0 35.3-28.7 64-64 64s-64-28.7-64-64V368c0-26.5-21.5-48-48-48H0V512H512V0zM112 64h96 16V96H208 112 96V64h16zm192 0h96 16V96H400 304 288V64h16zM112 128h96 16v32H208 112 96V128h16zm192 0h96 16v32H400 304 288V128h16zM416 256V448H288V256H416z"],
    "torii-gate": [512, 512, [9961], "f6a1", "M384 128v64h64V128l64-64V0L416 32H96L0 0V64l64 64v64h64V128h96v64h64V128h96zM64 288V480v32h64V480 288H384V480v32h64V480 288h32 32V224H480 32 0v64H32 64z"],
    "cloud-exclamation": [640, 512, [], "e491", "M144 480H0V336c0-62.7 40.1-116 96-135.8V192c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96v36c55.2 14.2 96 64.3 96 124V480H512 144zM344 160H296v24V296v24h48V296 184 160zM296 352v48h48V352H296z"],
    "message-lines": [512, 512, ["comment-alt-lines"], "f4a6", "M0 0H512V416H304L160 512V416H0V0zM152 144H128v48h24H360h24V144H360 152zm0 96H128v48h24H264h24V240H264 152z"],
    "frog": [576, 512, [], "f52e", "M368 32c41.7 0 75.9 31.8 79.7 72.5L576 144v80L400.8 323.5 493.3 416H544h32v64H544 480 466.7l-9.4-9.4L346.9 360.2c11.7-36 3.2-77.1-25.4-105.7c-40.6-40.6-106.3-40.6-146.9-.1L101 324.4l-11.6 11 22.1 23.2 11.6-11 73.8-70.2 .1-.1 .1-.1c3.5-3.5 7.3-6.6 11.3-9.2c27.9-18.5 65.9-15.4 90.5 9.2c24.7 24.7 27.7 62.9 9 90.9c-2.6 3.8-5.6 7.5-9 10.9L261.8 416H320h32v64H320 32 0V448 416C0 249.6 127 112.9 289.3 97.5C296.2 60.2 328.8 32 368 32zm0 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "bucket": [448, 512, [], "e4cf", "M75.5 0H96 352h20.5l3.2 20.3L397.8 160H349.2L331.5 48h-215L98.8 160H50.2L72.3 20.3 75.5 0zM0 192H448v64H410.9L384 512H64L37.1 256H0V192z"],
    "floppy-disk-pen": [576, 512, [], "e182", "M0 32H32 320h13.3l9.4 9.4 96 96 9.4 9.4V160v76.4l-181 181L258 480H32 0V448 64 32zM320 96H64V224H320V96zM288 352a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM505 224l71 71-41.3 41.3-71-71L505 224zm-63.9 63.9l71 71L370.9 500.1 288 512l11.9-82.9L441.1 287.9z"],
    "image": [512, 512, [], "f03e", "M0 32H512V480H0V32zM323.5 202.1L304 174.7l-19.5 27.3L196.2 325.6l-26.3-29.6L152 275.9l-17.9 20.2-64 72L64 374.9V384v8 24H88h72 24 32 24H424h24V392v-8-7.7l-4.5-6.3-120-168zM112 192a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "window-frame": [512, 512, [129695], "e04f", "M32 256V64 0H96 416h64V64 256 448h32v64H480 416 96 32 0V448H32V256zm384 32H280V448H416V288zm-184 0H96V448H232V288zm48-64H416V64H280V224zM232 64H96V224H232V64z"],
    "microphone": [384, 512, [], "f130", "M288 0H96V256c0 53 43 96 96 96s96-43 96-96V0zM64 216V192H16v24 40c0 89.1 66.2 162.7 152 174.4V464H120 96v48h24 72 72 24V464H264 216V430.4c85.8-11.7 152-85.3 152-174.4V216 192H320v24 40c0 70.7-57.3 128-128 128s-128-57.3-128-128V216z"],
    "cow": [640, 512, [128004], "f6c8", "M480 64H272 256 144C77.7 64 24 117.7 24 184v54C9.4 249.8 0 267.8 0 288v32H8c35.3 0 64-28.7 64-64V224 184c0-21.3 9.3-40.5 24-53.7V192v64V448h96V327.8c9.9 6.6 20.6 12 32 16.1V368v16h32V368 351.1c5.3 .6 10.6 .9 16 .9s10.7-.3 16-.9V368v16h32V368 343.8c11.4-4 22.1-9.4 32-16.1V448h96V256l32 32v64l64 96h64l32-160-16-22.4V184 160H576v24 14.4L480 64zm80 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM160 128H384v32l-30.1 30.1C332.2 211.8 302.7 224 272 224s-60.2-12.2-81.9-33.9L160 160V128z"],
    "file-zip": [512, 512, [], "e5ee", "M0 0H224V160H384V304H176V512H0V0zM384 128H256V0L384 128zM240 352h64 16v16 8 4.2l-2.1 3.7L263 480h41 16v32H304 240 224V496v-8-4.2l2.1-3.7L281 384H240 224V352h16zm144 16V496v16H352V496 368 352h32v16zm32-16h16 24c30.9 0 56 25.1 56 56s-25.1 56-56 56h-8v32 16H416V496 448 368 352zm32 80h8c13.3 0 24-10.7 24-24s-10.7-24-24-24h-8v48z"],
    "square-ring": [448, 512, [], "e44f", "M448 32H0V480H448V32zM128 256a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm96 160a160 160 0 1 1 0-320 160 160 0 1 1 0 320z"],
    "down-from-line": [384, 512, ["arrow-alt-from-top"], "f349", "M352 320L192 480 32 320l0-32 96 0 0-160 128 0 0 160 96 0 0 32zm0-224L32 96 0 96 0 32l32 0 320 0 32 0 0 64-32 0z"],
    "caret-up": [320, 512, [], "f0d8", "M0 272L160 128 320 272v48H0V272z"],
    "shield-xmark": [512, 512, ["shield-times"], "e24c", "M256 0l11.6 4.5L475.1 85l19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9c-32.7 75.2-91.1 150-189.4 192.6L256 512l-12.7-5.5C144.9 463.9 86.5 389.2 53.9 313.9C21.4 239.3 13.6 162.9 16.6 113l1.2-20.5L36.9 85 244.4 4.5 256 0zm97.9 192L320 158.1l-17 17-47 47-47-47-17-17L158.1 192l17 17 47 47-47 47-17 17L192 353.9l17-17 47-47 47 47 17 17L353.9 320l-17-17-47-47 47-47 17-17z"],
    "screwdriver": [512, 512, [129691], "f54a", "M353.9 192H416L512 64 448 0 320 96v62.1l-82.3 82.3 33.9 33.9L353.9 192zM0 416l96 96L280 328l-96-96L0 416z"],
    "circle-sort-down": [512, 512, ["sort-circle-down"], "e031", "M512 256A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM144 320V288H368v32L256 416 144 320zm0-96V192L256 96l112 96v32H336 176 144zm112-85.9L193.2 192H318.8L256 138.1z"],
    "folder-closed": [512, 512, [], "e185", "M512 480H0V192H512V480zm0-320H0V32H224l48 64H512v64z"],
    "house-tsunami": [576, 512, [], "e515", "M80.8 136.5C104.9 93.8 152.6 64 209 64c16.9 0 33.1 2.7 48.2 7.7l20.1-60.8C255.8 3.8 232.8 0 209 0C95.2 0 0 88 0 200c0 91.6 53.5 172.1 142.2 194.1c13.4 3.8 27.5 5.9 42.2 5.9v-.1c2.5 .1 5 .1 7.6 .1v0c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V336c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5 0 0c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l0 0-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1v0c-12.4 0-24-1.5-34.9-4.3C121.6 320.2 96 287 96 248c0-48.5 39.5-88 88.4-88c13.5 0 26.1 3 37.5 8.3l27.1-58C229.3 101.1 207.4 96 184.4 96c-40 0-76.4 15.4-103.6 40.5zM448 32L320 128V262.9c8.1 5.6 15.2 10 23.3 13.7c13.1 6 27.7 10.3 40.7 10.3s27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l0 0L480 240l19.7 14.2c13.9 10 23.6 17 35.5 22.5c13.1 6 27.6 10.3 40.5 10.3l-.4-159L448 32zM272.4 493.1c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V448c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7L96 408.7l-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 441.9 19.3 448 0 448v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9z"],
    "square-nfi": [448, 512, [], "e576", "M448 32H0V480H448V32zM80 160h8 9.9l4.4 8.8L160 284.2V176 160h32v16V336v16H176h-8-9.9l-4.4-8.8L96 227.8V336v16H64V336 176 160H80zm160 0h64 16v32H304 256v32h48 16v32H304 256v80 16H224V336 240 176 160h16zm144 16V336v16H352V336 176 160h32v16z"],
    "forklift": [640, 512, [], "f47a", "M128 0H96V32 160H0V416c0 53 43 96 96 96s96-43 96-96h64c0 53 43 96 96 96s96-43 96-96c0-28.4-12.4-54-32-71.6V256v-5.5l-1.9-5.2-80-224L326.6 0H304 128zM256 256l-96-96V64H281.4L350 256H256zM96 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm256 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM544 32V0H480V32 416v32h32 96 32V384H608 544V32z"],
    "arrow-up-from-ground-water": [576, 512, [], "e4b5", "M320 352V320 125.3l25.4 25.4L368 173.3 413.3 128l-22.6-22.6-80-80L288 2.7 265.4 25.4l-80 80L162.7 128 208 173.3l22.6-22.6L256 125.3 256 320v32h64zM288 485.4c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.6 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V448c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7L96 408.7l-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 441.9 19.3 448 0 448v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.6 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.6 11.1-5.3 15.6-7.7zM192 192H0V415c13 0 27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l1.1-.8L96 368l18.6 13.4 1.1 .8 0 0c13.9 10 23.6 17 35.5 22.5c13.1 6 27.7 10.3 40.7 10.3V192zm384 0H384V415c13 0 27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l0 0 0 0L480 368l19.7 14.2 0 0c13.9 10 23.6 17 35.5 22.5c13.1 6 27.7 10.3 40.7 10.3V192z"],
    "bracket-square-right": [192, 512, [], "5d", "M192 32H160 64 32V96H64h64V416H64 32v64H64h96 32V448 64 32z"],
    "martini-glass": [512, 512, [127864, "glass-martini-alt"], "f57b", "M0 48L16 64 210.7 258.7 224 272V448H160 128v64h32 96 96 32V448H352 288V272l13.3-13.3L496 64l16-16V0H448 64 0V48zm341.5 80h-171l-64-64h299l-64 64z"],
    "rotate-left": [512, 512, ["rotate-back", "rotate-backward", "undo-alt"], "f2ea", "M142.9 142.9L200 200l-24 24H16V64L40 40 97.6 97.6l0 0c87.5-87.5 229.3-87.5 316.8 0s87.5 229.3 0 316.8s-229.3 87.5-316.8 0l45.3-45.3c62.5 62.5 163.8 62.5 226.3 0s62.5-163.8 0-226.3s-163.8-62.5-226.3 0l0 0z"],
    "table-columns": [512, 512, ["columns"], "f0db", "M0 32H512V480H0V32zM64 160V416H224V160H64zm384 0H288V416H448V160z"],
    "square-a": [448, 512, [], "e25f", "M448 32H0V480H448V32zM208.8 128h30.5l6.5 13.8L359.4 384h-53l-22.5-48H164.2l-22.5 48h-53L202.3 141.8l6.5-13.8zM224 208.5L186.7 288h74.6L224 208.5z"],
    "tick": [128, 512, [], "e32f", "M32 288L0 32H128L96 288H32z"],
    "lemon": [448, 512, [127819], "f094", "M448 80L400 32 327.7 56.1C244 16.3 146.2 46.2 80.2 112.2s-96 163.7-56.1 247.4L0 432l48 48 72.3-24.1c83.7 39.8 181.4 9.9 247.4-56.1s96-163.7 56.1-247.4L448 80zM212.5 127.4c-54.6 16-101.1 62.5-117.1 117.1l-4.5 15.4-30.7-9 4.5-15.4c19.1-65.1 73.7-119.8 138.9-138.9l15.4-4.5 9 30.7-15.4 4.5z"],
    "head-side-mask": [576, 512, [], "e063", "M32 224.3c0-22.7 3.4-44.7 9.7-65.3L256 301.9V512H128 96V480 381.2C55 339.3 32 283 32 224.3zM268.8 272L53.5 128.4C89.4 52.5 166.8 0 256.3 0H288C390.1 0 473.6 79.7 479.7 180.3L537 252l7 8.8V272l-272 0h-3.2zM304 304H544v0l-19.7 64H368 352v32h16H514.5l-9.8 32H368 352v32h16H494.8L480 512H288V304h16s0 0 0 0zm80-80a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "handshake": [640, 512, [], "f2b5", "M298.8 64H224l-96 64V352h28.2l73.9 67.4 35.4 32.4 47.7-52.2 22.3 20.5 35.4 32.4 44.8-48.9 35.2 32.2 64.9-70.8-35.4-32.4-134.2-123-96.4 75-13 10.1-9.7-13.4-64-88-8.9-12.3 11.8-9.6L298.8 64zm74.1 124.9L512 316.8V128h-.7l-3.9-2.5L411.3 64H349.7L197.9 186.9l45.3 62.3 131-101.9 12.6-9.8 19.6 25.3-12.6 9.8-20.9 16.2zM96 128H0V384H96V128zM48 320a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM544 128V384h96V128H544zm32 208a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "gem": [512, 512, [128142], "f3a5", "M0 208L256 480 512 208 400 32H112L0 208zM376 64L299.6 189 464 208 256 232 48 208l164.4-19L136 64 256 177.7 376 64z"],
    "dolly": [576, 512, ["dolly-box"], "f472", "M0 0H32h96 23.1l7.3 21.9L257.7 320c30.1 .5 56.8 14.9 74 37l202.1-67.4 30.4-10.1 20.2 60.7-30.4 10.1L352 417.7c-.9 52.2-43.5 94.3-96 94.3c-53 0-96-43-96-96c0-30.8 14.5-58.2 37-75.8L104.9 64H32 0V0zM311 79.4l19.8 60.9 60.9-19.8L371.8 59.6l76.1-24.7 69.2 213L327.2 309.6c-9.3-6.3-19.6-11.3-30.4-15L234.9 104.1 311 79.4z"],
    "smoking": [640, 512, [128684], "f48d", "M448 0V43c0 38.2 15.2 74.8 42.2 101.8l21 21c21 21 32.8 49.5 32.8 79.2v43H480V245c0-12.7-5.1-24.9-14.1-33.9l-21-21C405.9 151.1 384 98.1 384 43V0h64zM576 288V245c0-38.2-15.2-74.8-42.2-101.8l-21-21c-21-21-32.8-49.5-32.8-79.2V0h64V43c0 12.7 5.1 24.9 14.1 33.9l21 21c39 39 60.9 91.9 60.9 147.1v43H576zM0 352H32 416h32v32 96 32H416 32 0V480 384 352zm224 64v32H384V416H224zm320-64v32 96 32H480V480 384 352h64zm96 0v32 96 32H576V480 384 352h64z"],
    "minimize": [512, 512, ["compress-arrows-alt"], "f78c", "M288 64l32-32 52 52L456 0l56 56-84 84 52 52-32 32H288V64zm0 384V288H448l32 32-52 52 84 84-56 56-84-84-52 52-32-32zm-96 32l-52-52L56 512 0 456l84-84L32 320l32-32H224V448l-32 32zM224 64V224H64L32 192l52-52L0 56 56 0l84 84 52-52 32 32z"],
    "refrigerator": [384, 512, [], "e026", "M384 0H0V160H288V112 96h32v16 48h64V0zm0 192H320V368v16H288V368 192H0V512H384V192z"],
    "monument": [384, 512, [], "f5a6", "M192 0L96 96 56 416H328L288 96 192 0zm64 320H128V272H256v48zM32 448H0v64H32 352h32V448H352 32z"],
    "octagon-xmark": [512, 512, ["times-octagon", "xmark-octagon"], "f2f0", "M0 160V352L160 512H352L512 352V160L352 0H160L0 160zm353.9 32l-17 17-47 47 47 47 17 17L320 353.9l-17-17-47-47-47 47-17 17L158.1 320l17-17 47-47-47-47-17-17L192 158.1l17 17 47 47 47-47 17-17L353.9 192z"],
    "align-slash": [640, 512, [], "f846", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L482.7 352H544V288H400.3l-82.4-64H544V160H235.4L153 96H544V32H96V51.8l-47.6-37zM324.9 352l-81.2-64H96v64H324.9zM162.5 224L96 171.6V224h66.5zM487.4 480l-81.2-64H96v64H487.4z"],
    "snowplow": [640, 512, [], "f7d2", "M128 0V160H64V298.8C26.2 316.8 0 355.3 0 400c0 61.9 50.1 112 112 112H368c61.9 0 112-50.1 112-112c0-17.2-3.9-33.5-10.8-48H512v64 13.3l9.4 9.4 64 64 45.3-45.3L576 402.7V352 288 235.2L633 164l-50-40-64 80-7 8.8V224v64H448V224L339.8 0H128zM64 400c0-26.5 21.5-48 48-48H368c26.5 0 48 21.5 48 48s-21.5 48-48 48H112c-26.5 0-48-21.5-48-48zM380.2 224H256l-64-64V64H300.2l80 160zM120 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm264-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM280 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-56-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "angles-right": [512, 512, [187, "angle-double-right"], "f101", "M278.6 278.6L301.3 256l-22.6-22.6-160-160L96 50.7 50.7 96l22.6 22.6L210.7 256 73.4 393.4 50.7 416 96 461.3l22.6-22.6 160-160zm192 0L493.3 256l-22.6-22.6-160-160L288 50.7 242.7 96l22.6 22.6L402.7 256 265.4 393.4 242.7 416 288 461.3l22.6-22.6 160-160z"],
    "truck-ramp-couch": [640, 512, ["truck-couch"], "f4dd", "M640 0V400c0 61.9-50.1 112-112 112c-61.6 0-111.6-49.8-112-111.3L48.6 502.8l-30.8 8.6L.6 449.7l30.8-8.6L352 352.1V0H640zM576 400a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM294.5 209.2c8.7-2.3 17.4-2.1 25.5 .2V334.8l-38.7 10.4L126.7 386.6 34 411.5 13.3 334.2c-6.9-25.6 8.3-51.9 33.9-58.8s51.9 8.3 58.8 33.9l4.1 15.5 154.5-41.4-4.1-15.5c-6.9-25.6 8.3-51.9 33.9-58.8zM8 252.8c-9.1-34.1 11.1-69.2 45.3-78.4l185.5-49.7c34.1-9.1 69.2 11.1 78.4 45.3l1.7 6.4c-10.6-1.6-21.6-1.1-32.6 1.9c-37.4 10-61.5 44.9-59.2 82.1L131.2 286c-16.6-33.4-54.9-51.5-92.3-41.5c-11 2.9-20.8 8-29.2 14.7L8 252.8z"],
    "cannabis": [512, 512, [], "f55f", "M329.9 199.3c11.2-8.5 23-16.1 34.8-22.8c41-23.3 84.4-36.9 112.2-42.5l23.5-4.7-4.7 23.5c-5.6 27.7-19.3 70.9-42.7 111.7c-9.3 16.2-20.3 32.4-33.2 47.1c24.8 6.7 46.2 16.9 60 24.6l25.2 14-25.2 14c-14.8 8.2-38.4 19.4-65.5 26c-18.9 4.6-40.1 7.3-61.4 4.7l8.3 33.1 8.5 33.7-31.1-15.5L280 417.2V488v24H232V488 417.2l-58.5 29.1-31.1 15.5 8.5-33.7 8.3-33.1c-21.4 2.5-42.6-.1-61.4-4.7c-27.1-6.7-50.7-17.8-65.5-26L7 350.3l25.2-14c13.8-7.7 35.2-17.8 60-24.6C79.3 297 68.3 280.8 59 264.6c-23.4-40.8-37.1-84-42.7-111.7l-4.7-23.5L35.1 134c27.9 5.5 71.2 19.2 112.2 42.5c11.8 6.7 23.6 14.3 34.8 22.8C179.1 83.9 256 0 256 0s76.9 83.9 73.9 199.3z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM384 256L176 384V128L384 256z"],
    "arrow-up-right-and-arrow-down-left-from-center": [512, 512, [], "e0a0", "M352 0H320V64h32 50.7L297.4 169.4 274.7 192 320 237.3l22.6-22.6L448 109.3V160v32h64V160 32 0H480 352zM214.6 342.6L237.3 320 192 274.7l-22.6 22.6L64 402.7V352 320H0v32V480v32H32 160h32V448H160 109.3L214.6 342.6z"],
    "tablets": [640, 512, [], "f490", "M640 160C640 71.6 568.4 0 480 0c-38.4 0-73.7 13.5-101.3 36.1L603.9 261.3C626.5 233.7 640 198.4 640 160zM480 320c38.4 0 73.7-13.5 101.3-36.1L356.1 58.7C333.5 86.3 320 121.6 320 160c0 88.4 71.6 160 160 160zM160 512c83 0 151.2-63.1 159.2-144H.8C8.8 448.9 77 512 160 512zM.8 336H319.2c-8-80.9-76.2-144-159.2-144S8.8 255.1 .8 336z"],
    "360-degrees": [640, 512, [], "e2dc", "M640 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM305.7 67.4L320 96c-14.3-28.6-14.3-28.6-14.3-28.6l0 0-.1 0-.1 .1-.3 .2-.9 .5c-.7 .4-1.7 .9-2.8 1.6c-2.3 1.3-5.4 3.2-9.1 5.7c-7.3 4.9-17 12.2-26.9 22C245.9 116.9 224 148.5 224 192v96 32h0v48c0 44.2 35.8 80 80 80s80-35.8 80-80V272c0-44.2-35.8-80-80-80c-5.5 0-10.8 .6-16 1.6V192c0-20.5 10.1-36.9 22.6-49.4c6.2-6.2 12.4-10.9 17.1-14c2.3-1.5 4.2-2.7 5.4-3.3c.6-.3 1-.6 1.2-.7l.1-.1 28.5-14.2L334.3 53.1 305.7 67.4zM32 64H0v64H32 97.3L39.7 195.2l-7.7 9V216v8 32H64 80c26.5 0 48 21.5 48 48v48c0 17.7-14.3 32-32 32s-32-14.3-32-32H0c0 53 43 96 96 96s96-43 96-96V304c0-47.6-29.8-88.3-71.7-104.5l64-74.6 7.7-9V104 96 64H160 32zm448 80c0-8.8 7.2-16 16-16s16 7.2 16 16V368c0 8.8-7.2 16-16 16s-16-7.2-16-16V144zm16-80c-44.2 0-80 35.8-80 80V368c0 44.2 35.8 80 80 80s80-35.8 80-80V144c0-44.2-35.8-80-80-80zM288 272c0-8.8 7.2-16 16-16s16 7.2 16 16v96c0 8.8-7.2 16-16 16s-16-7.2-16-16V272z"],
    "ethernet": [512, 512, [], "f796", "M0 192V448H96V336 320h32v16V448h64V336 320h32v16V448h64V336 320h32v16V448h64V336 320h32v16V448h96V192H448V128H384V64H128v64H64v64H0z"],
    "euro-sign": [320, 512, [8364, "eur", "euro"], "f153", "M48.6 240c-.4 5.3-.6 10.6-.6 16s.2 10.7 .6 16H0v64H62.7C94.9 420.2 176.5 480 272 480h48V416H272c-59.2 0-110.9-32.2-138.6-80H288V272H112.8c-.5-5.3-.8-10.6-.8-16s.3-10.7 .8-16H288V176H133.4c27.7-47.8 79.4-80 138.6-80h48V32H272C176.5 32 94.9 91.8 62.7 176H0v64H48.6z"],
    "chair": [448, 512, [129681], "f6c0", "M296 48V256H248V48H200V256H152V48H112V256H64V48 0h48H336h48V48 256H336V48H296zM0 384V352l32-64H416l32 64v32H416v96 32H352V480 384H96v96 32H32V480 384H0z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209L241 337l-17 17-17-17-64-64-17-17L160 222.1l17 17 47 47L335 175l17-17L385.9 192l-17 17z"],
    "square-dashed-circle-plus": [576, 512, [], "e5c2", "M32 32H0V64v96H64V96h64V32H32zM0 192V320H64V192H0zM0 352v96 32H32h96V416H64V352H0zM432 192c5.4 0 10.7 .2 16 .7V64 32H416 320V96h64V198.6c15.3-4.3 31.4-6.6 48-6.6zM262.6 416H160v64H296.2c-15.3-18.5-26.9-40.2-33.6-64zM160 96H288V32H160V96zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208v48h48 16v32H496 448v48 16H416V432 384H368 352V352h16 48V304 288h32v16z"],
    "money-simple-from-bracket": [640, 512, [], "e313", "M32 0H608h32V32 160v32H576V160 64H64v96 32H0V160 32 0H32zM512 96l0 416-384 0 0-416 384 0zM320 352c53 0 96-35.8 96-80s-43-80-96-80s-96 35.8-96 80s43 80 96 80z"],
    "bat": [576, 512, [], "f6b5", "M224 48l32 32h64l32-32 27.9 111.7L480 112c61.9 72.3 96 164.3 96 259.5V400l-96-48-48 80-64-64L288 480 208 368l-64 64L96 352 0 400V371.5C0 276.3 34.1 184.3 96 112l100.1 47.7L224 48z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm96-352V352H160V160H352z"],
    "head-side-headphones": [512, 512, [], "f8c2", "M160 106.8V9.3C67.4 36.9 0 122.8 0 224.2c0 58.7 23 115.1 64 157V480v32H96 288h32V480 448h96 32V416 320h32 32V288 272 260.8l-7-8.8-57.3-71.7C441.6 79.7 358.1 0 256 0V106.8c37.8 18 64 56.5 64 101.2c0 61.9-50.1 112-112 112s-112-50.1-112-112c0-44.7 26.2-83.2 64-101.2zM176 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 0a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "phone-rotary": [512, 512, [9742], "f8d3", "M0 128s96-96 256-96s256 96 256 96v80H416l-32-80s-48-24-128-24s-128 24-128 24L96 208H0V128zM32 480V384L160 160H352L480 384v96H32zM328 312a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"],
    "compass-drafting": [512, 512, ["drafting-compass"], "f568", "M352 96c0 14.1-3.1 27.6-8.6 39.7l53.9 90.3c-23.9 26-54.9 45.4-89.8 55.1L256 192 188 309.5c21.5 6.8 44.3 10.5 68 10.5c82.9 0 155.3-45 194.1-112l55.4 32C455.7 326 362.6 384 256 384c-35.4 0-69.4-6.4-100.7-18.1L91.4 476.2 0 512V417.8L64 310.7C41.3 290.4 21.9 266.5 6.6 240l55.4-32c9.8 17 21.9 32.6 35.7 46.4l70.9-118.7c-5.5-12.1-8.5-25.5-8.5-39.7c0-53 43-96 96-96s96 43 96 96zm20.9 297.9c33.8-13.3 64.7-32.1 91.7-55.3L512 417.8V512l-91.4-35.8-47.6-82.2zM256 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "plate-wheat": [512, 512, [], "e55a", "M400 32c44.2 0 80 35.8 80 80v32H464c-44.2 0-80-35.8-80-80V32h16zM56 64h48 24v48H104 56 32V64H56zM24 136H136h24v48H136 24 0V136H24zm8 72H56h48 24v48H104 56 32V208zM272 32h16c44.2 0 80 35.8 80 80v32H352c-44.2 0-80-35.8-80-80V32zm-96 0c44.2 0 80 35.8 80 80v32H240c-44.2 0-80-35.8-80-80V32h16zM480 176v32c0 44.2-35.8 80-80 80H384V256c0-44.2 35.8-80 80-80h16zm-128 0h16v32c0 44.2-35.8 80-80 80H272V256c0-44.2 35.8-80 80-80zm-96 0v32c0 44.2-35.8 80-80 80H160V256c0-44.2 35.8-80 80-80h16zM96 444C40.8 429.8 0 379.6 0 320H512c0 59.6-40.8 109.8-96 124v36H96V444z"],
    "calendar-circle-minus": [576, 512, [], "e46f", "M160 0H96V64H0v96H448V64H352V0H288V64H160V0zm96 368c0-91.8 70.3-167.2 160-175.3V192H0V512H330.8C285.6 480.1 256 427.5 256 368zm320 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-64 16H496 368 352V352h16H496h16v32z"],
    "chopsticks": [640, 512, [], "e3f7", "M420.5 60.9L24.6 510.4 0 491 343.1 0l77.5 60.9zM576 61l64 74.6L149.4 512 129 488.2 576 61z"],
    "car-wrench": [512, 512, ["car-mechanic"], "f5e3", "M80 0c32.8 0 61 19.7 73.3 48H358.7C371 19.7 399.2 0 432 0c12.5 0 24.4 2.9 34.9 8c19.6 9.5 34.8 26.9 41.4 48H480 453.2 432v48h21.2H480h28.3c-6.6 21.1-21.8 38.5-41.4 48c-10.6 5.1-22.4 8-34.9 8c-32.8 0-61-19.7-73.3-48H153.3C141 140.3 112.8 160 80 160c-12.5 0-24.4-2.9-34.9-8c-19.6-9.5-34.8-26.9-41.4-48H32 58.8 80V56H58.8 32 3.7C10.3 34.9 25.4 17.5 45.1 8C55.6 2.9 67.5 0 80 0zm49.4 160H152 360h22.6l7.6 21.2L428.3 288H464v96 64 64H384V448H128v64H48V448 384 288H83.7l38.1-106.8 7.6-21.2zm208 64H174.6l-22.9 64H360.3l-22.9-64zM128 392a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm280-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "icicles": [512, 512, [], "f7ad", "M96 352L0 0H512L416 512 336 160 288 352 240 192 192 416 144 192 96 352z"],
    "person-shelter": [512, 512, [], "e54f", "M64 181.4V512H0V144L256 0 512 144V512H448V181.4L256 73.4 64 181.4zM256 128a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm-48 96h96 14.3l6.8 12.6 56 104 11.4 21.1-42.3 22.8-11.4-21.1L312 313.5V488v24H264V488 400H248v88 24H200V488 313.5l-26.9 49.9-11.4 21.1-42.3-22.8 11.4-21.1 56-104 6.8-12.6H208z"],
    "neuter": [384, 512, [9906], "f22c", "M80 176a112 112 0 1 1 224 0A112 112 0 1 1 80 176zM224 349.1c81.9-15 144-86.8 144-173.1C368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1V480v32h64V480 349.1z"],
    "id-badge": [384, 512, [], "f2c1", "M384 0H0V512H384V0zM272 320l32 96H80l32-96H272zM128 224a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM144 64h96 16V96H240 144 128V64h16z"],
    "kazoo": [640, 512, [], "f8c7", "M514 128h94 32v32V352v32H608 514c-19.8 10.2-42.2 16-66 16s-46.3-5.8-66-16H224h-4.6l-4.4-1.3-192-56L0 320V296 216 192l23-6.7 192-56 4.4-1.3H224 382c19.8-10.2 42.2-16 66-16s46.3 5.8 66 16zm30 128a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM427.3 212.7L448 233.4l20.7-20.7L480 201.4 502.6 224l-11.3 11.3L470.6 256l20.7 20.7L502.6 288 480 310.6l-11.3-11.3L448 278.6l-20.7 20.7L416 310.6 393.4 288l11.3-11.3L425.4 256l-20.7-20.7L393.4 224 416 201.4l11.3 11.3z"],
    "marker": [512, 512, [], "f5a1", "M32 352L0 512l160-32L292.7 347.3l-128-128L32 352zM187.3 196.7l128 128L485.5 154.5c17-17 26.5-40 26.5-64C512 40.5 471.5 0 421.5 0c-24 0-47 9.5-64 26.5L318.2 65.8 269.6 18.1l-17-16.7L235.8 18.2 111 143l-17 17L128 193.9l17-17L253 69l31.3 30.7-97 97z"],
    "bin-bottles": [640, 512, [], "e5f5", "M256 0V32h16V64H256 128 112V32h16V0H256zM32 144l96-48H256l63.6 31.8L352 144h0v48H32V144zm543.6-8v56H384V144 124.2l-17.7-8.8L321.8 93.1l61.8-29V0h128V64.1l64 30V136zM0 224H640v64H608L576 512H64L32 288H0V224z"],
    "face-laugh-beam": [512, 512, [128513, "laugh-beam"], "f59a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-80c-83 0-151.2-63.1-159.2-144H415.2c-8 80.9-76.2 144-159.2 144zM176 136c28 0 56 40 56 80c0 0-28-32-56-32s-56 32-56 32c0-40 28-80 56-80zm104 80c0-40 28-80 56-80s56 40 56 80c0 0-28-32-56-32s-56 32-56 32z"],
    "square-arrow-down-left": [448, 512, [], "e261", "M448 480H0V32H448V480zM136 368H288h24V320H288 193.9L329 185l17-17L312 134.1l-17 17-135 135V184 160H112v24V344v24h24z"],
    "battery-bolt": [576, 512, [], "f376", "M64 352H189.5l-20 64H64 0V352 160 96H64 307.5l-84.3 64H64V352zm172.5 64l84.3-64H480V160H354.5l20-64H480h64v64 32h32V320H544v32 64H480 236.5zM208 400l40-128H160V248L336 112 296 240h88v24L208 400z"],
    "tree-large": [448, 512, [], "f7dd", "M56 176L224 0 392 176v32H344l80 112v32H368l80 128v32H0V480L80 352H24V320l80-112H56V176z"],
    "helicopter-symbol": [512, 512, [], "e502", "M445.3 224H510C495.6 108.2 403.8 16.4 288 2V66.7C368.4 80.1 431.9 143.6 445.3 224zM510 288H445.3C431.9 368.4 368.4 431.9 288 445.4V510c115.8-14.4 207.6-106.2 222-222zM2 288C16.4 403.8 108.2 495.6 224 510V445.4C143.6 431.9 80.1 368.4 66.7 288H2zm0-64H66.7C80.1 143.6 143.6 80.1 224 66.7V2C108.2 16.4 16.4 108.2 2 224zm206-64V128H144v32V352v32h64V352 288h96v64 32h64V352 160 128H304v32 64H208V160z"],
    "aperture": [512, 512, [], "e2df", "M256 0c12.1 0 23.9 .8 35.5 2.4L163.6 224 76.6 73.3C122.8 28 186.1 0 256 0zM0 256C0 196.6 20.2 141.9 54.2 98.5L182.1 320H8.1C2.8 299.5 0 278.1 0 256zM187.5 502.7C110.6 481.4 48.2 425.1 18.6 352H274.5l-87 150.7zM256 512c-12.1 0-23.9-.8-35.5-2.4L348.4 288l87 150.7C389.2 484 325.9 512 256 512zM512 256c0 59.4-20.2 114.1-54.2 157.5L329.9 192h174c5.3 20.5 8.1 41.9 8.1 64zM324.5 9.3C401.4 30.6 463.8 86.9 493.4 160H237.5l87-150.7z"],
    "universal-access": [512, 512, [], "f29a", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm160.4-86.5L138 161.1 121.1 206l22.5 8.4 64 24 .4 .2v53.5l-30.8 92.3-7.6 22.8 45.5 15.2 7.6-22.8L249.3 320h13.4l26.5 79.6 7.6 22.8 45.5-15.2-7.6-22.8L304 292.1V238.6l.4-.2 64-24 22.5-8.4L374 161.1l-22.5 8.4L291.6 192H220.4l-59.9-22.5zM256 160a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"],
    "gear-complex": [512, 512, [], "e5e9", "M302.7 0h-96l-7 55.7c-16.8 4.7-32.7 11.5-47.5 20L107.6 41 39.7 108.9l35 45c-8.3 14.7-14.8 30.4-19.4 47L-1.3 208 0 304l55.3 7c4.5 16.6 11.1 32.4 19.4 47.1l-35 45L107.6 471l44.6-34.7c14.8 8.5 30.7 15.3 47.5 20l7 55.7h96l6.9-55c17.2-4.6 33.6-11.3 48.7-19.9L401.8 471l67.9-67.9L436.2 360c8.8-15.3 15.8-31.8 20.6-49.3l54-6.7V208l-54-6.7c-4.7-17.4-11.7-34-20.6-49.3l33.5-43.1L401.8 41 358.3 74.9c-15.2-8.6-31.5-15.3-48.7-19.9L302.7 0zM256 176a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "file-magnifying-glass": [384, 512, ["file-search"], "f865", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zm16 304c0 17.8-4.9 34.5-13.3 48.9L297 391.2l17 17L280 442.1l-17-17-38.4-38.4C210.4 395.2 193.8 400 176 400c-53 0-96-43-96-96s43-96 96-96s96 43 96 96zm-96 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "up-right": [384, 512, [], "e2be", "M368 80V368l-32 32L232 296 80 448 0 368 152 216 48 112 80 80H368z"],
    "circle-chevron-up": [512, 512, ["chevron-circle-up"], "f139", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm17-345L377 271l17 17L360 321.9l-17-17-87-87-87 87-17 17L118.1 288l17-17L239 167l17-17 17 17z"],
    "user-police": [448, 512, [], "e333", "M80 99.2L48 80V48L224 0 400 48V80L368 99.2V128c-16 10.7-67.2 32-144 32s-128-21.3-144-32V99.2zM227 48.6l-3-1.2-3 1.2L189 61.4l-5 2v5.4c0 17.2 7 46.1 36.9 58.6l3.1 1.3 3.1-1.3C257 114.9 264 86 264 68.8V63.4l-5-2L227 48.6zM98.1 168.8c39.1 15 81.5 23.2 125.9 23.2s86.8-8.2 125.9-23.2c1.4 7.5 2.1 15.3 2.1 23.2c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-7.9 .7-15.7 2.1-23.2zM138.7 352L224 416l85.3-64H400l48 160H0L48 352h90.7zM352 400.4l-4.6 14.2-6.1 18.8-19.8 0-14.9 0 12.1 8.7 16 11.6-6.2 18.8L324 486.5l12-8.8 16-11.7 16 11.7 12 8.8-4.6-14.1-6.2-18.8 16-11.6 12.1-8.7-14.9 0-19.8 0-6.1-18.8L352 400.4z"],
    "lari-sign": [384, 512, [], "e1c8", "M176 32V96.7c5.3-.4 10.6-.7 16-.7s10.7 .2 16 .7V32h64v81.4c66.1 30.3 112 97.1 112 174.6H320c0-40.4-18.7-76.5-48-99.9V288H208V161c-5.2-.7-10.6-1-16-1s-10.8 .3-16 1V288H112l0-99.9C82.7 211.5 64 247.6 64 288c0 70.7 57.3 128 128 128H384v64H192 0V416H48.9C18.5 382 0 337.2 0 288c0-77.5 45.9-144.3 112-174.6L112 32h64z"],
    "volcano": [512, 512, [127755], "f770", "M160 144c-35.3 0-64-28.7-64-64s28.7-64 64-64c15.7 0 30 5.6 41.2 15C212.4 12.4 232.7 0 256 0s43.6 12.4 54.8 31C322 21.6 336.3 16 352 16c35.3 0 64 28.7 64 64s-28.7 64-64 64H304l-32 48H240l-32-48H160zM298.4 272H213.6l-66.2 74.5L240 320l80 64 54-27-75.6-85zM192 224H320L512 440v24 48H464 48 0V464 440L192 224z"],
    "teddy-bear": [576, 512, [], "e3cf", "M152 102C137.5 91.8 128 75 128 56c0-30.9 25.1-56 56-56c22.3 0 41.6 13.1 50.6 32H288h53.4c9-18.9 28.3-32 50.6-32c30.9 0 56 25.1 56 56c0 19-9.5 35.8-24 46v26c0 70.7-60.9 128-136 128s-136-57.3-136-128V102zm88 26a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm0 64c0-26.5-28.7-48-64-48s-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48zm-32-8c0 13.3-14.3 24-32 24s-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24zM88 148.6l29.7 37.7L143.5 219c73.7 93.5 215.4 93.5 289.1 0l25.8-32.7L488 148.6 563.4 208l-29.7 37.7-25.8 32.7c-17.7 22.4-37.9 41.3-59.9 56.7V400h40l8-48 80 16L552 512l-40 0-32 0L96 512H64 24L0 368l80-16 8 48h40V335.1c-22-15.4-42.3-34.3-59.9-56.7L42.3 245.7 12.6 208 88 148.6zM384 384l-32-32H224l-32 32v32H384V384z"],
    "stocking": [384, 512, [], "f7d5", "M384 0H64V96H384V0zM96 128V256L55.7 282.9C20.9 306.1 0 345.1 0 386.9v2.2C0 457 55 512 122.8 512c24.2 0 48-7.2 68.1-20.6L352 384V128H96z"],
    "person-walking-dashed-line-arrow-right": [640, 512, [], "e553", "M208 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM132.3 126.6l10 2 80 16 15.3 3.1 7 14 35.2 70.5 38.5 19.2-28.6 57.2-48-24-9.5-4.8-4.8-9.5-13.7-27.4-18.4 62.4 52.3 57 5.2 5.7 2 7.5 24 88 8.4 30.9-61.7 16.8-8.4-30.9-22-80.5-70.9-77.4c-14.8-16.1-20.3-38.6-14.7-59.7l17-63.6L89.9 215.5 78.4 250.1 68.2 280.5 7.5 260.2l10.1-30.4 16-48 4.5-13.4L51 162.8l72-32 9.3-4.1zm-38.6 209c2.1 3 4.5 5.8 7 8.6l40.7 44.4-15.7 39.3-2.4 6.1-4.6 4.6-48 48L48 509.3 2.7 464l22.6-22.6L68.7 398l25-62.4zM416 24V72 96H368V72 24 0h48V24zM534.6 153.4l80 80L637.3 256l-22.6 22.6-80 80L512 381.3 466.7 336l22.6-22.6L514.7 288H384 352V224h32H514.7l-25.4-25.4L466.7 176 512 130.7l22.6 22.6zM416 128v24 16 24H368V168 152 128h48zm0 216v16 24H368V360 344 320h48v24zm0 72v24 48 24H368V488 440 416h48z"],
    "image-slash": [640, 512, [], "e1b7", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L576 424.4V32H70.5L48.4 14.8zM157.7 99.6c5.7-2.3 11.8-3.6 18.3-3.6c26.5 0 48 21.5 48 48c0 2.3-.2 4.6-.5 6.8L157.7 99.6zM327.5 231.5l21-29.4L368 174.7l19.5 27.3 120 168 1.9 2.7-182-141.3zM214.2 279.9l8-8.8L64 146.4V480H487.4l-81.2-64H292.8 280 248 224 152 128V392v-8-9.3l6.2-6.9 80-88z"],
    "mask-snorkel": [576, 512, [], "e3b7", "M576 32V64v96H512v32h64V376c0 75.1-60.9 136-136 136h-8c-70.7 0-128-57.3-128-128V352h64v32c0 35.3 28.7 64 64 64h8c39.8 0 72-32.2 72-72V64 32h64zM0 64H448V288H272l-32-64H208l-32 64H0V64z"],
    "smoke": [640, 512, [], "f760", "M172.3 194.3c-9.2-1.5-18.7-2.3-28.3-2.3c-29.2 0-56.7 7.1-80.9 19.6C43.7 189.2 32 160 32 128C32 57.3 89.3 0 160 0c40.1 0 75.9 18.4 99.3 47.3C277.4 37.5 298 32 320 32c44.3 0 83.4 22.5 106.4 56.8c-11.5 7.3-22 16-31.2 25.9C372.7 102.8 347.2 96 320 96c-66.5 0-123.5 40.6-147.7 98.3zm276.3 62.5C419.5 217.5 372.7 192 320 192c-31.5 0-60.9 9.1-85.7 24.9c-9.6-5.8-19.8-10.6-30.5-14.5C224 158.5 268.4 128 320 128c31.3 0 60.1 11.3 82.3 30c22.4-37.1 63.1-62 109.7-62c70.7 0 128 57.3 128 128c0 42.2-20.4 79.6-51.9 102.9C563.1 284.5 516.9 256 464 256c-5.2 0-10.3 .3-15.4 .8zM144 512H0V368c0-79.5 64.5-144 144-144c34.5 0 66.1 12.1 90.9 32.3C257.6 236.2 287.4 224 320 224c49.1 0 91.8 27.7 113.2 68.3c9.8-2.8 20.1-4.3 30.8-4.3c61.9 0 112 50.1 112 112V512H464 144z"],
    "sterling-sign": [320, 512, [163, "gbp", "pound-sign"], "f154", "M112 159.2c0-34.9 28.3-63.2 63.2-63.2c7.4 0 14.7 1.3 21.6 3.8l72.2 26.3L299.1 137 321 76.9 290.9 65.9 218.7 39.7c-13.9-5.1-28.6-7.7-43.5-7.7C105 32 48 89 48 159.2V224H0v64H48v48.4L3.4 425.7 0 432.4V440v8 32H32 288h32V416H288 79.8l28.8-57.7 3.4-6.8V344 288H256V224H112V159.2z"],
    "battery-exclamation": [576, 512, [], "e0b0", "M208 96v64H64V352H192v64H64 0V352 160 96H64 208zm128 64V96H480h64v64 32h32V320H544v32 64H480 352V352H480V160H336zM296 96v24V296v24H248V296 120 96h48zm8 256v64H240V352h64z"],
    "viruses": [640, 512, [], "e076", "M168 0h24 24V24 37.5c0 35.6 43.1 53.5 68.3 28.3l9.5-9.5 17-17 17 17 0 0 0 0 17 17-17 17-9.5 9.5C293 124.9 310.9 168 346.5 168H360h24v24 24H360 346.5c-35.6 0-53.5 43.1-28.3 68.3l0 0 9.5 9.5 17 17-17 17-17 17-17-17-9.5-9.5 0 0C259.1 293 216 310.9 216 346.5V360v24H192 168V360 346.5c0-35.6-43.1-53.5-68.3-28.3l-9.5 9.5-17 17-17-17-17-17 17-17 9.5-9.5C91 259.1 73.1 216 37.5 216H24 0V192 168H24 37.5c35.6 0 53.5-43.1 28.3-68.3l-9.5-9.5-17-17 17-17 17-17 17 17 9.5 9.5 0 0C124.9 91 168 73.1 168 37.5V24 0zm72 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-48-64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM597.8 266.2l11.3 11.3-11.3 11.3C574.5 312.1 591 352 624 352h16v16 16H624c-33 0-49.5 39.9-26.2 63.2l11.3 11.3-11.3 11.3-11.3 11.3-11.3-11.3C551.9 446.5 512 463 512 496v16H496 480V496c0-33-39.9-49.5-63.2-26.2l-11.3 11.3-11.3-11.3 0 0-11.3-11.3 11.3-11.3C417.5 423.9 401 384 368 384H352V368 352h16c33 0 49.5-39.9 26.2-63.2l-11.3-11.3 11.3-11.3 0 0 11.3-11.3 11.3 11.3C440.1 289.5 480 273 480 240V224h16 16v16c0 33 39.9 49.5 63.2 26.2l11.3-11.3 11.3 11.3zM512 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "square-person-confined": [448, 512, [], "e577", "M0 32H448V480H0V32zM256 144a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm18.7 48l-9.4 9.4-16 16-9.4 9.4 0 13.3 0 66.7-41.4-41.4-51.2 8.3-24 48-12 24-12 24-12 24L76.2 416h71.6l8.8-17.7 12-24 12-24 4.1-8.3 54.7 54.7c12.4 12.4 29.1 19.3 46.6 19.3c36.4 0 65.9-29.5 65.9-65.9V224 192H320 288 274.7z"],
    "user-tie": [448, 512, [], "f508", "M224 256A128 128 0 1 1 224 0a128 128 0 1 1 0 256zM209.1 359.2L176 304h48 48l-33.1 55.2 33.4 123.9L312.2 320H384l64 192H280 265.1 182.9 168 0L64 320h71.8l39.9 163.1 33.4-123.9z"],
    "arrow-down-long": [384, 512, ["long-arrow-down"], "f175", "M214.6 489.4L192 512l-22.6-22.6-128-128L18.7 338.7 64 293.5l22.6 22.6L160 389.5 160 32l0-32h64V32l0 357.5 73.4-73.4L320 293.5l45.3 45.3-22.6 22.6-128 128z"],
    "tent-arrow-down-to-line": [640, 512, [], "e57e", "M241.9 136l-17 17-64 64-17 17-17-17L63 153l-17-17L80 102.1l17 17 23 23L120 24V0h48V24l0 118.1 23-23 17-17L241.9 136zM384 448h76.8L384 320V448zm219.4 0H608h32v64H608 32 0V448H32 164.6L192 256 384 128 576 256l27.4 192z"],
    "certificate": [512, 512, [], "f0a3", "M187.4 0L256 57.2 324.6 0l30.8 83.9 88-15.3-15.3 88L512 187.4 454.8 256 512 324.6l-83.9 30.8 15.3 88-88-15.3L324.6 512 256 454.8 187.4 512l-30.8-83.9-88 15.3 15.3-88L0 324.6 57.2 256 0 187.4l83.9-30.8-15.3-88 88 15.3L187.4 0z"],
    "crystal-ball": [448, 512, [], "e362", "M448 224c0 62.7-25.7 119.3-67.2 160H67.2C25.7 343.3 0 286.7 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224zM177.3 110.7L160 64l-17.3 46.7L96 128l46.7 17.3L160 192l17.3-46.7L224 128l-46.7-17.3zM304 112l-25.9 70.1L208 208l70.1 25.9L304 304l25.9-70.1L400 208l-70.1-25.9L304 112zM0 512l64-96H384l64 96H0z"],
    "reply-all": [576, 512, ["mail-reply-all"], "f122", "M106.4 184.4L224 76.6V32H192L0 208 192 384h32V339.4L106.4 231.6 80.6 208l25.7-23.6zM224 120l-72.3 66.3L128 208l23.7 21.7L224 296l96 88h32V288h16c61.9 0 112 50.1 112 112c0 48-32 80-32 80s128-48 128-176c0-97.2-78.8-176-176-176H352V32H320l-96 88z"],
    "suitcase": [512, 512, [129523], "f0f2", "M152 0H128V24 96v32V480H384V128 96 24 0H360 152zM336 96H176V48H336V96zM0 96V480H96V96H0zM512 480V96H416V480h96z"],
    "person-skating": [448, 512, ["skating"], "f7c5", "M352 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM128 96h32H320h13.3l9.4 9.4 19.3 19.3 23.4 23.4-24.2 22.6-83.4 77.8 64.9 64.9 9.4 9.4V336v80 32H288V416 349.3l-77.9-77.8c-26.6-26.6-24.6-70.3 4.3-94.4l20.4-17H160 128V96zM81.4 353.4l86.9-86.9c4.6 10 11 19.3 19.3 27.5l21.8 21.8-82.7 82.7L104 421.3 58.7 376l22.6-22.6zm307 91.2l31 7.8-3.9 15.5-8 32-3 12.1H392 288 272V480h16 91.5l5-19.9 3.9-15.5zM135.2 478.3l-32 16-10.3 5.2-8.2-8.2-72-72L1.4 408 24 385.4l11.3 11.3 63.8 63.8 21.7-10.8 14.3-7.2 14.3 28.6-14.3 7.2z"],
    "star-shooting": [512, 512, [127776], "e036", "M297 57l17-17L280 6.1 263 23 231 55l-17 17L248 105.9l17-17 32-32zM489 249l17-17L472 198.1l-17 17-32 32-17 17L440 297.9l17-17 32-32zm17-209L472 6.1 455 23 327 151l-17 17L344 201.9l17-17L489 57l17-17zM253.3 265.1L193.5 144 133.7 265.1 0 284.6l96.7 94.3L73.9 512l119.6-62.9L313 512 290.2 378.9l96.7-94.3L253.3 265.1z"],
    "binary-lock": [640, 512, [], "e33d", "M224 0V64h32 16v96H256 224v64h32 48 48 32V160H352 336V32 0H304 256 224zM0 288v64H32 48v96H32 0v64H32 80h48 32V448H128 112V320 288H80 32 0zM32 0H0V32 192v32H32 160h32V192 32 0H160 32zM64 160V64h64v96H64zM192 288v32V480v32h32H352h32V480 320 288H352 224 192zm64 64h64v96H256V352zM528 240c17.7 0 32 14.3 32 32v48H496V272c0-17.7 14.3-32 32-32zm-80 32v48H416V512H640V320H608V272c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "filter-circle-dollar": [576, 512, ["funnel-dollar"], "f662", "M192 384V288L0 64V0H512V64L399.8 194.9C318 210.1 256 281.8 256 368c0 27.8 6.4 54.1 17.9 77.4L192 384zm96-16a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm120.8-32.6c.6-.9 1.8-2.1 4.2-3.4c5.1-2.7 12.5-4.1 18.7-4c8.2 .1 17.1 1.8 26.4 4.1l15.5 3.9 7.7-31.1L465.9 301c-5.6-1.4-11.6-2.7-17.9-3.7V288 272H416v16 9.5c-6.1 1.2-12.3 3.2-18 6.3c-11.8 6.3-23 18.4-21.8 37.2c1 16 11.7 25.3 21.6 30.7c8.8 4.7 19.7 7.8 28.6 10.3l1.8 .5c10.3 2.9 17.9 5.2 23.2 8.3c4.5 2.7 4.7 4.2 4.7 5.6c.1 2.4-.5 3.7-1 4.5c-.6 1-1.8 2.2-4 3.3c-4.7 2.5-11.8 3.8-18.5 3.6c-9.5-.3-18.5-3.1-29.9-6.8c-1.9-.6-3.8-1.2-5.8-1.8l-15.3-4.8L372 425.2l15.3 4.8c1.6 .5 3.3 1 5 1.6l0 0 0 0c7 2.3 15.1 4.8 23.7 6.6v11.4 16h32v-16V438.7c6.2-1.1 12.5-3.1 18.3-6.2c12.1-6.5 22.3-18.7 21.7-36.9c-.5-16.2-10.3-26.3-20.5-32.3c-9.4-5.6-21.2-8.9-30.5-11.5l-.2 0c-10.4-2.9-18.3-5.2-23.9-8.2c-4.8-2.6-4.8-4-4.8-4.5l0-.1c-.1-1.9 .3-2.9 .8-3.6z"],
    "camera-retro": [512, 512, [128247], "f083", "M220.6 121.2L271.1 96H448v96H333.2c-21.9-15.1-48.5-24-77.2-24s-55.2 8.9-77.2 24H64V128H192c9.9 0 19.7-2.3 28.6-6.8zM256 32L192 64H160V32H64V64H0v64V416v64H64 448h64V416 96 32H448 256zM168 304a88 88 0 1 1 176 0 88 88 0 1 1 -176 0z"],
    "circle-arrow-down": [512, 512, ["arrow-circle-down"], "f0ab", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm17-119L385 281l17-17L368 230.1l-17 17-71 71V136 112H232v24V318.1l-71-71-17-17L110.1 264l17 17L239 393l17 17 17-17z"],
    "comment-pen": [512, 512, ["comment-edit"], "f4ae", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM304.8 144l-29.1 29.1L323 220.4l29.1-29.1L304.8 144zm-51.7 51.7l-85.2 85.2L160 336.1l55.3-7.9L300.4 243l-47.3-47.3z"],
    "file-import": [512, 512, ["arrow-right-to-file"], "f56f", "M128 0H352V160H512V512H128V336H302.1l-39 39-17 17L280 425.9l17-17 80-80 17-17-17-17-80-80-17-17L246.1 232l17 17 39 39H128V0zm0 288v48H24 0V288H24 128zM512 128H384V0L512 128z"],
    "banjo": [512, 512, [129685], "f8a3", "M367.1 99.7L376 64 448 0l64 64-64 72-35.7 8.9L331.3 226c13.9 20.6 23.4 44.3 27 70H360h24v48H360h-1.7c-4.1 28.5-15.3 54.6-31.7 76.6l1.2 1.2 17 17-33.9 33.9-17-17-1.2-1.2c-22 16.5-48.2 27.7-76.6 31.7V488v24H168V488v-1.7c-28.5-4.1-54.6-15.3-76.6-31.7l-1.2 1.2-17 17L39.3 438.8l17-17 1.2-1.2C41 398.6 29.8 372.5 25.7 344H24 0V296H24h1.7c4.1-28.5 15.3-54.6 31.7-76.6l-1.2-1.2-17-17 33.9-33.9 17 17 1.2 1.2c22-16.5 48.2-27.7 76.6-31.7V152 128h48v24 1.7c25.7 3.7 49.5 13.1 70 27l81.1-81.1zM192 432a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM155.3 308.7l48 48L214.6 368 192 390.6l-11.3-11.3-48-48L121.4 320 144 297.4l11.3 11.3z"],
    "square-arrow-up-right": [448, 512, ["external-link-square"], "f14c", "M0 32H448V480H0V32zM312 144H160 136v48h24 94.1L119 327l-17 17L136 377.9l17-17 135-135V328v24h48V328 168 144H312z"],
    "light-emergency-on": [640, 512, [], "e420", "M69.3 36l-20-13.3L22.7 62.7 42.7 76l48 32 20 13.3 26.6-39.9L117.3 68l-48-32zM597.3 76l20-13.3L590.7 22.7 570.7 36l-48 32-20 13.3 26.6 39.9 20-13.3 48-32zM24 192H0v48H24 96h24V192H96 24zm520 0H520v48h24 72 24V192H616 544zM320 32c-88.4 0-160 71.6-160 160V352H480V192c0-88.4-71.6-160-160-160zM240 192H208c0-61.9 50.1-112 112-112v32c-44.2 0-80 35.8-80 80zM544 384H96v96H544V384z"],
    "kerning": [640, 512, [], "f86f", "M201.3 489.6l208-480 29.4 12.7-208 480-29.4-12.7zM419.6 352l-27.2 64H322.8L450.5 115.5 458.8 96h42.3l8.3 19.5L637.2 416H567.6l-27.2-64H419.6zm93.7-64L480 209.8 446.8 288h66.5zM317.2 96L189.4 396.5 181.2 416H138.8l-8.3-19.5L2.8 96H72.4L160 302.2 247.6 96h69.5z"],
    "box-open": [640, 512, [], "f49e", "M64 32L320 64 576 32l64 128-64 18.3L416 224l-57.6-96L320 64l-38.4 64L224 224 64 178.3 0 160 64 32zm0 384V211.6l151.2 43.2 23.6 6.7 12.6-21L318.9 128h2.2l67.5 112.5 12.6 21 23.6-6.7L576 211.6V416L320 480 64 416z"],
    "square-f": [448, 512, [], "e270", "M448 32H0V480H448V32zM152 128H296h24v48H296 176v64h88 24v48H264 176v72 24H128V360 264 152 128h24z"],
    "scroll": [576, 512, [128220], "f70e", "M0 80v80H48 96V80c0-26.5-21.5-48-48-48S0 53.5 0 80zM112 32c10 13.4 16 30 16 48V384c0 35.3 28.7 64 64 64s64-28.7 64-64V336 320h16H480V128c0-53-43-96-96-96H112zM464 480c61.9 0 112-50.1 112-112V352H288v32c0 53-43 96-96 96H368h96z"],
    "spa": [576, 512, [], "f5bb", "M207.8 252.3C158.4 214.4 96.5 192 30 192H0C0 351.1 128.9 480 288 480s288-128.9 288-288H546c-56.1 0-108.8 15.9-153.6 43.6c-33.5 20.7-62.5 48-85.3 80.2c-7 9.9-13.4 20.3-19.1 31c-5.7-10.8-12.1-21.1-19.1-31c-17.1-24.2-37.7-45.6-61-63.5zM288 32s-66.4 56.9-97 170.8c37.7 21.6 70.7 50.5 97 85c26.3-34.5 59.3-63.4 97-85C354.4 88.9 288 32 288 32z"],
    "arrow-left-from-line": [448, 512, [8612, "arrow-from-right"], "f344", "M384 96V64h64V96 416v32H384V416 96zM25.4 278.6L2.7 256l22.6-22.6 128-128L176 82.7 221.3 128l-22.6 22.6L125.3 224 288 224h32v64H288l-162.7 0 73.4 73.4L221.3 384 176 429.3l-22.6-22.6-128-128z"],
    "strawberry": [512, 512, [], "e32b", "M320 80c0 33.9 11 44.3 29.4 61.7l0 0c3.3 3.1 6.9 6.5 10.6 10.3s7.1 7.3 10.3 10.6l0 0C387.7 181 398.1 192 432 192c40 0 80-40 80-40s-29.5-36.8-74.3-39.8c.7-.7 1.5-1.5 2.2-2.2c21.5-21.5 48.2-52.2 62.1-84.5L457.9 6.5C447.8 30.2 426.5 55.5 406 76c-2 2-4.1 4-6 5.9c0-.6 0-1.3 0-2c0-48-40-80-40-80s-40 40-40 80zM192.2 64C96.2 64 0 160 0 336V512H176c176 0 272-96 272-192c0-32.8-12.5-65.5-37.5-90.5l-128-128C257.6 76.6 224.9 64.1 192.2 64zM172.8 172.8c-11.9 11.9-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6s2.3 23.3-9.6 35.2zm-32 96c-11.9 11.9-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6s2.3 23.3-9.6 35.2zm73.6 28.8s2.3 23.3-9.6 35.2s-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6zm54.4 99.2c-11.9 11.9-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6s2.3 23.3-9.6 35.2zM118.4 329.6s2.3 23.3-9.6 35.2s-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6zm54.4 99.2c-11.9 11.9-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6s2.3 23.3-9.6 35.2zm73.6-227.2s2.3 23.3-9.6 35.2s-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6zm54.4 99.2c-11.9 11.9-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6s2.3 23.3-9.6 35.2zm73.6 28.8s2.3 23.3-9.6 35.2s-35.2 9.6-35.2 9.6s-2.3-23.3 9.6-35.2s35.2-9.6 35.2-9.6z"],
    "location-pin-lock": [512, 512, [], "e51f", "M192 512s28.8-31.1 64-75.8L256 288h32V272c0-55.6 40.5-101.7 93.6-110.5C367 70 287.7 0 192 0C86 0 0 86 0 192C0 304 192 512 192 512zm0-384a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM400 240c17.7 0 32 14.3 32 32v48H368V272c0-17.7 14.3-32 32-32zm-80 32v48H288V512H512V320H480V272c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "pause": [320, 512, [9208], "f04c", "M128 64H0V448H128V64zm192 0H192V448H320V64z"],
    "clock-eight-thirty": [512, 512, [], "e346", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V300.8L173.3 340l-20 13.3-26.6-39.9 20-13.3 96-64L280 211.2V256 392v24H232V392z"],
    "plane-engines": [576, 512, [9992, "plane-alt"], "f3de", "M576 256c0-35-59.5-64-93.7-64l-116.6 0-36.6-64 22.9 0 0-64-59.4 0L256 0 160 0l54.9 192L112 192 64 128 0 128l24.2 96.9C10.3 228.4 0 241 0 256s10.3 27.6 24.2 31.1L0 384l64 0 48-64 102.9 0L160 512l96 0 36.6-64 59.4 0 0-64-22.9 0 36.6-64 116.6 0c34.2 0 93.7-28 93.7-64z"],
    "hill-avalanche": [576, 512, [], "e507", "M0 512H480L0 32V512zM551.1 391.1c34.4-34.4 34.4-90.1 0-124.4s-90.1-34.4-124.5 0l33.9 33.9c15.6-15.6 40.9-15.6 56.6 0s15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-81.7-81.7C401.2 261.3 416 236.4 416 208c0-33.9-21.1-62.9-50.9-74.5c1.9-6.8 2.9-14 2.9-21.5c0-44.2-35.8-80-80-80c-27.3 0-51.5 13.7-65.9 34.6C216.3 46.6 197.9 32 176 32c-26.5 0-48 21.5-48 48c0 4 .5 7.9 1.4 11.6L439.7 401.9c34.2 23.1 81.1 19.5 111.4-10.8zM448 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm64 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "temperature-empty": [320, 512, ["temperature-0", "thermometer-0", "thermometer-empty"], "f2cb", "M97.8 317.8L112 300.2V277.5 64h96V277.5v22.7l14.2 17.6C233.4 331.5 240 348.9 240 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-19.1 6.6-36.5 17.8-50.3zM272 0H208 112 48V64 277.5C28 302.2 16 333.7 16 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5V64 0zM160 416a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "bomb": [512, 512, [128163], "f1e2", "M432 0L405.3 53.3 352 80l53.3 26.7L432 160l26.7-53.3L512 80 458.7 53.3 432 0zM326.6 105.4L304 82.7l-22.6 22.6-2.9 2.9C256.5 100.3 232.7 96 208 96C93.1 96 0 189.1 0 304S93.1 512 208 512s208-93.1 208-208c0-24.7-4.3-48.5-12.2-70.5l2.9-2.9L429.3 208l-22.6-22.6-80-80zM200 192c-57.4 0-104 46.6-104 104v8H64v-8c0-75.1 60.9-136 136-136h8v32h-8z"],
    "gauge-low": [512, 512, ["tachometer-alt-slow"], "f627", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-.6 0-1.3 0-1.9 0L190 142.3l-9.7-22-43.9 19.3 9.7 22 64.1 145.7C198.9 318.9 192 334.6 192 352c0 35.3 28.7 64 64 64zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "registered": [512, 512, [174], "f25d", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 128h24H288c44.2 0 80 35.8 80 80c0 37.8-26.3 69.5-61.6 77.9L369.1 384h-57l-61.3-96H208v72 24H160V360 264 152 128zm48 112h56 24c17.7 0 32-14.3 32-32s-14.3-32-32-32H208v64z"],
    "trash-can-plus": [448, 512, [], "e2ac", "M304 0l16 32H448V96H0V32H128L144 0H304zM32 128H416V512H32V128zm168 72v80H120v48h80v80h48V328h80V280H248V200H200z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M576 32H0V480H576V32zM256 288l32 96H64l32-96H256zM112 192a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256-32H496h16v32H496 368 352V160h16zm0 64H496h16v32H496 368 352V224h16zm0 64H496h16v32H496 368 352V288h16z"],
    "scale-unbalanced-flip": [640, 512, ["balance-scale-right"], "f516", "M251.1 39.3L138.1 1.6 117.9 62.4l125.9 42c7 22 23.3 39.9 44.2 49V448H128 96v64h32H320h32V480 153.3c5.1-2.2 9.9-5 14.4-8.2l135.5 45.2 30.4 10.1 20.2-60.7-30.4-10.1L399.5 88.8c.3-2.9 .5-5.8 .5-8.8c0-44.2-35.8-80-80-80c-29.3 0-55 15.8-68.9 39.3zM528 224H496 481.5l-6.7 12.9-88 168-2.7 5.2V416l0 32v9.9l7 7 40 40 7 7H448 576h9.9l7-7 40-40 7-7V448 416v-5.9l-2.7-5.2-88-168L542.5 224H528zm60.9 192H435.1l75.4-144h3l75.4 144zM158.5 96H144 112 97.5l-6.7 12.9-88 168L0 282.1V288v32 9.9l7 7 40 40 7 7H64 192h9.9l7-7 40-40 7-7V320 288v-5.9l-2.7-5.2-88-168L158.5 96zm-29 48l75.4 144H51.1l75.4-144h3z"],
    "globe-snow": [448, 512, [], "f7a3", "M380.8 384c41.5-40.7 67.2-97.3 67.2-160C448 100.3 347.7 0 224 0S0 100.3 0 224c0 62.7 25.7 119.3 67.2 160H192V352H112V336l80-80H144V240l80-80 80 80v16H256l80 80v16H256v32H380.8zM80 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM224 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm112 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM0 512H448l-64-96H64L0 512z"],
    "subscript": [512, 512, [], "f12c", "M0 64H32 64 80.7l9.6 13.6L176 200.2 261.8 77.6 271.3 64H288h32 32v64H320 304.7L215.1 256l89.6 128H320h32v64H320 288 271.3l-9.6-13.6L176 311.8 90.2 434.4 80.7 448H64 32 0V384H32 47.3l89.6-128L47.3 128H32 0V64zM384 288h32 32 32v32V448h32v64H480 416 384V448h32V352H384V288z"],
    "diamond-turn-right": [512, 512, ["directions"], "f5eb", "M256 0L0 256 256 512 512 256 256 0zm48 336H288V264H208v64 24H160V328 240 216h24H288V144h16l96 96-96 96z"],
    "integral": [320, 512, [], "f667", "M128 0h32H272h32V32 96v32H240V96 64H192V480v32H160 48 16V480 416 384H80v32 32h48V32 0z"],
    "burst": [512, 512, [], "e4dc", "M256 0l56.8 118.8L437 75 393.2 199.2 512 256 393.2 312.8 437 437 312.8 393.2 256 512 199.2 393.2 75 437l43.8-124.2L0 256l118.8-56.8L0 0 199.2 118.8 256 0z"],
    "house-laptop": [640, 512, ["laptop-house"], "e066", "M0 208L240 0 480 208v16H288V192H192v96h80V416H64V256H0V208zm544 96H352V448H544V304zm-240 0V256h48H544h48v48V448h48v32l-32 32H592 544 352 304 288l-32-32V448h48V304z"],
    "face-tired": [512, 512, [128555, "tired"], "f5c8", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-128c-48.9 0-93.5 16.8-127.4 44.3c-.4-4.1-.6-8.2-.6-12.3c0-70.7 57.3-128 128-128s128 57.3 128 128c0 4.2-.2 8.3-.6 12.3C349.5 400.8 304.9 384 256 384zM112 144l118.9 64L112 272l45.7-64L112 144zm169.1 64L400 144l-45.7 64L400 272 281.1 208z"],
    "money-bills": [640, 512, [], "e1f3", "M96 32V384H640V32H96zm64 224c35.3 0 64 28.7 64 64H160V256zM224 96c0 35.3-28.7 64-64 64V96h64zM576 256v64H512c0-35.3 28.7-64 64-64zM512 96h64v64c-35.3 0-64-28.7-64-64zM288 208a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM48 120V96H0v24V456v24H24 520h24V432H520 48V120z"],
    "blinds-raised": [512, 512, [], "f8fd", "M32 0H0V64H16L0 128H128V64h32v64H512L496 64h16V0H480 32zM144 512c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V224H512l-16-64H160v64H128V160H16L0 224H128V418.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48z"],
    "smog": [640, 512, [], "f75f", "M192 287.1c-5.3 .6-10.6 .9-16 .9H32V144C32 64.5 96.5 0 176 0c34.5 0 66.1 12.1 90.9 32.3C289.6 12.2 319.4 0 352 0c49.1 0 91.8 27.7 113.2 68.3C475 65.5 485.3 64 496 64c61.9 0 112 50.1 112 112V288H496 468.7c-22.6 19.9-52.2 32-84.7 32s-62.1-12.1-84.7-32H192v-.9zM616 368h24v48H616 280 256V368h24H616zm-64 96h24v48H552 440 416V464h24H552zm-192 0h24v48H360 24 0V464H24 360zM224 368v48H200 96 72V368H96 200h24z"],
    "ufo-beam": [576, 512, [], "e048", "M184 152s24 40 104 40s104-40 104-40c0-48-33.3-104-104-104s-104 56-104 104zm-42.6-40.4C159.1 47.2 218.1 0 288 0s128.9 47.2 146.6 111.6C519.2 131.1 576 167 576 208c0 61.9-128.9 112-288 112S0 269.9 0 208c0-41 56.8-76.9 141.4-96.4zM256 256l32 32 32-32-32-32-32 32zM96 176L64 208l32 32 32-32L96 176zm352 32l32 32 32-32-32-32-32 32zM74.1 326.3l4.2-9.5c14.2 5.6 29.6 10.6 45.9 15l-6.2 14-64 144-9.7 21.9L.3 492.2l9.7-21.9 64-144zm384 19.5l-6.2-14c16.3-4.4 31.6-9.4 45.9-15l4.2 9.5 64 144 9.7 21.9-43.9 19.5-9.7-21.9-64-144z"],
    "circle-caret-up": [512, 512, ["caret-circle-up"], "f331", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM128 272L256 144 384 272v32H128V272z"],
    "user-vneck-hair-long": [448, 512, [], "e463", "M304 144c0 44.2-35.8 80-80 80s-80-35.8-80-80V128c0-5.5 .6-10.8 1.6-16H208l32-32 16 16h41.3c4.3 9.8 6.7 20.6 6.7 32v16zM224 0C153.3 0 96 57.3 96 128v16 48L48 240v32H224 400V240l-48-48V144 128C352 57.3 294.7 0 224 0zm0 416l-72-96H64L0 512H448L384 320H296l-72 96z"],
    "square-a-lock": [576, 512, [], "e44d", "M0 32H448V161.1c-54.3 7.8-96 54.4-96 110.9v16H320h-5.7L245.7 141.8 239.2 128H208.8l-6.5 13.8L88.6 384h53l22.5-48H283.8l22.5 48H320l0 96H0V32zM261.3 288H186.7L224 208.5 261.3 288zM464 240c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H352V320h32V272z"],
    "crutch": [512, 512, [], "f7f7", "M334.4 1.1L289.1 46.4 311.8 69 443 200.2l22.6 22.6 45.3-45.3L488.2 155 357 23.8 334.4 1.1zM209.3 161.5l-55.9 55.9-6.3 6.3-2.1 8.6L115.1 351.6 73.4 393.4l-.1 .1L.4 466.3l45.3 45.3 73-73 41.7-41.7L279.8 367l8.6-2.2 6.3-6.3 56-56 74.7-74.7-45.3-45.3L328 234.7 277.3 184l52.1-52.1L284.1 86.6l-74.6 74.6c0 0-.1 .1-.1 .1s-.1 .1-.1 .1zM232 229.3L282.7 280l-27.1 27.1L188 324l16.9-67.7L232 229.3z"],
    "gas-pump-slash": [640, 512, [], "f5f4", "M96 0H384V275.4L521.4 382c4.2-6.3 6.6-13.9 6.6-22V224H480V96L432 48l32-32L576 128v40 24 32V360c0 19.2-6.2 37-16.6 51.5l61.6 47.8 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L96 51.8V0zm0 171.6L384 398.5V416H96V171.6zM64 448H416v32 32H64V448z"],
    "font-awesome": [448, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M328.5 80c-62.8 0-86.6-32-149.3-32C128.4 48 104.4 68.6 64 76.8V32H0V480H64V140.8c40.4-8 64.4-28.8 115.2-28.8c62.7 0 86.4 32 149.3 32c18.9 0 37.6-3.1 55.5-9.3v208c-17.8 6.2-36.6 9.4-55.5 9.3c-62.8 0-86.6-32-149.3-32c-17.4 0-34.7 2.7-51.2 8.2v64c16.5-5.5 33.8-8.2 51.2-8.2c62.7 0 86.4 32 149.3 32c37.1 0 56.4-9.6 119.5-32V48c-63.1 22.4-82.3 32-119.5 32z"],
    "cloud-arrow-up": [640, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", "M144 480H0V336c0-62.7 40.1-116 96-135.8V192c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96v36c55.2 14.2 96 64.3 96 124V480H512 144zm79-217l-17 17L240 313.9l17-17 39-39V392v24h48V392 257.9l39 39 17 17L433.9 280l-17-17-80-80-17-17-17 17-80 80z"],
    "palette": [512, 512, [127912], "f53f", "M256 0C397.4 0 512 114.6 512 256v64H355.9c-37.5 0-67.9 30.4-67.9 67.9c0 18 7.2 35.3 19.9 48L320 448l-64 64C114.6 512 0 397.4 0 256S114.6 0 256 0zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-96 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "transporter-4": [512, 512, [], "e2a5", "M224 0h64 16V32H288 224 208V0h16zm0 64h64 16V96H288 224 208V64h16zm-48 64H336h16v32H336 176 160V128h16zm-32 64H368h16v32H368 144 128V192h16zm-32 64H400h16v32H400 112 96V256h16zm64 64H336h16v32H336 176 160V320h16zm0 64H336h16v32H336 176 160V384h16zM416 512H296 216 96V448H416v64zM64 384l32 16L64 416 48 448 32 416 0 400l32-16 16-32 16 32zM464 128l16 32 32 16-32 16-16 32-16-32-32-16 32-16 16-32z"],
    "chart-mixed-up-circle-currency": [576, 512, [], "e5d8", "M400 0H368V64h32 28.8L319.4 151.5 211.2 70.4 191.4 55.5 172 71 12 199l40 50L192.6 136.5l108.2 81.1 19.3 14.5c4.4-3.6 9-7.1 13.8-10.3L340 217 480 105v39 32h64V144 32 0H512 400zM160 224V480h64V224H160zM32 320V480H96V320H32zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm25.4-169.4a35.9 35.9 0 1 0 -50.7 50.7 35.9 35.9 0 1 0 50.7-50.7zM396.7 426l-25.3 25.3-22.6-22.6L374 403.3c-13.2-21.6-13.2-49.1 0-70.7l-25.3-25.3 22.6-22.6L396.7 310c21.6-13.2 49.1-13.2 70.7 0l25.3-25.3 22.6 22.6L490 332.7c13.2 21.6 13.2 49.1 0 70.7l25.3 25.3-22.6 22.6L467.3 426c-21.6 13.2-49.1 13.2-70.7 0z"],
    "objects-align-right": [512, 512, [], "e3bf", "M512 512H464V0l48 0V512zM384 64V224L0 224V64l384 0zm0 224V448H128V288H384z"],
    "arrows-turn-right": [448, 512, [], "e4c0", "M358.6 25.4L336 2.7 290.7 48l22.6 22.6L338.7 96H32 0v32V256v32H64V256 160H338.7l-25.4 25.4L290.7 208 336 253.3l22.6-22.6 80-80L461.3 128l-22.6-22.6-80-80zm-96 256L240 258.7 194.7 304l22.6 22.6L242.7 352H32 0v32 96 32H64V480 416H242.7l-25.4 25.4L194.7 464 240 509.3l22.6-22.6 80-80L365.3 384l-22.6-22.6-80-80z"],
    "vest": [448, 512, [], "e085", "M207.1 237.4L151.2 69.7C168.7 79.8 192.7 88 224 88s55.3-8.2 72.8-18.3L224 288V512H448V256l-64-96V128 24 0H360 320h-7H299.6l-6.9 11.1-.3 .4c-.4 .6-1.2 1.5-2.3 2.8c-2.3 2.6-6.1 6.3-11.5 10.1C268.1 31.8 250.6 40 224 40s-44.1-8.2-54.7-15.6c-5.4-3.8-9.2-7.5-11.5-10.1c-1.1-1.3-1.9-2.3-2.3-2.8l-.3-.4L148.4 0H135h-7H88 64V24 128v32L0 256V512H192V288v-5.2l1.6-4.9 13.5-40.5zM336 345.4l11.3 11.3 48 48L406.6 416 384 438.6l-11.3-11.3-48-48L313.4 368 336 345.4zM100.7 356.7L112 345.4 134.6 368l-11.3 11.3-48 48L64 438.6 41.4 416l11.3-11.3 48-48z"],
    "pig": [640, 512, [128022], "f706", "M453.1 46L528 32V78c0 19.7-9 37.8-23.6 49.7c6.4 4.9 12.7 10.1 18.6 15.7c17.6-15.9 28.5-38.6 29-63.3h40 16v32c0 32.8-24.6 59.8-56.3 63.5l6.8 9C570 200 585 212.5 602.2 221.1L608 224h32V368H572.5c-22.2 21.2-49.7 36.2-79.8 43.3L473.1 480H384V416H320 272v64H182.9L155 382.4C110.3 358 80 310.5 80 256V240H47.4C21.2 240 0 218.8 0 192.6c0-21.8 14.8-40.7 35.9-46l8.2-2 7.8 31-8.2 2c-6.9 1.7-11.7 7.9-11.7 15c0 8.5 6.9 15.4 15.4 15.4H83.2C98 135 162.6 80 240 80H362.4c14.6 0 29 1.4 43.1 4c8.4-19.3 25.9-33.8 47.7-37.9zM468 256a20 20 0 1 0 0-40 20 20 0 1 0 0 40z"],
    "inbox-full": [512, 512, [], "e1ba", "M71 32H96 416h25L447 56.2l64 256 1 3.8V320 448v32H480 32 0V448 320v-3.9l1-3.8 64-256L71 32zm50 64L73 288h71l32 64H336l32-64h71L391 96H121zm55 48H336h16v32H336 176 160V144h16zm-32 80H368h16v32H368 144 128V224h16z"],
    "circle-envelope": [512, 512, ["envelope-circle"], "e10c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM128 204.1V160H384v44.1L256 254.8 128 204.1zm133.9 82.8L384 238.5V352H128V238.5l122.1 48.4 5.9 2.3 5.9-2.3z"],
    "triangle-person-digging": [640, 512, ["construction"], "f85d", "M320 32L64 480H576L320 32zM285.9 225.1l40 16 5.6 2.3 2.7 5.4 27.6 55.3 52.1 31.3L432 304l64 112H368l30.2-52.8-56.7-34-85.7-51.4-14.4-8.6 9.3-14 16-24 7.2-10.8 12.1 4.8zM288 184a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM237.2 307.4l14.9 9.3 60.3 37.7 7.5 4.7V368v32 16H304 288V400 376.9l-37.9-23.7L218.9 416H183.1l2.6-5.1 43.7-87.7 7.9-15.8z"],
    "ferry": [576, 512, [], "e4ea", "M224 0H352h32V32h48 48V64L468 80 456 96H120L108 80 96 64V32h48 48V0h32zM64 128H512V304l-60.2 84.3c-9.7 6.9-17.7 12.1-27.1 16.4C411.6 410.7 397 415 384 415s-27.6-4.3-40.7-10.3c-12-5.5-21.7-12.5-35.5-22.5l0 0 0 0L288 368l-18.6 13.4-1.1 .8 0 0 0 0c-13.9 10-23.6 17-35.5 22.5C219.6 410.7 205 415 192 415s-27.6-4.3-40.7-10.3c-9.4-4.3-17.4-9.5-27.1-16.4L64 304V128zm64 64v96H448V192H128zM272.4 493.1c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 502.1 31.9 512 0 512V448c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7z"],
    "bullseye-arrow": [512, 512, [127919], "f648", "M366.4 213.5l28.6 4.8c3.3 12 5 24.7 5 37.7c0 79.5-64.5 144-144 144s-144-64.5-144-144s64.5-144 144-144c13.1 0 25.7 1.7 37.7 5l4.8 28.6-31.2 31.2c-3.7-.5-7.5-.8-11.3-.8c-44.2 0-80 35.8-80 80s35.8 80 80 80s80-35.8 80-80c0-3.8-.3-7.6-.8-11.3l31.2-31.2zM448 256c0-10.9-.9-21.6-2.7-32.1l9.3-9.3 43.1-43.1C507 198 512 226.4 512 256c0 141.4-114.6 256-256 256S0 397.4 0 256S114.6 0 256 0c29.6 0 58 5 84.5 14.3L297.4 57.4l-9.3 9.3C277.6 64.9 266.9 64 256 64C150 64 64 150 64 256s86 192 192 192s192-86 192-192zm-12.3-67.7L432 192l-66.9-11.2L265 281 231 247 331.2 146.9 320 80l3.7-3.7 48.5-48.5L400 0l25.7 64.4L432 80l15.6 6.3L512 112l-27.8 27.8-48.5 48.5z"],
    "arrows-down-to-people": [640, 512, [], "e4b9", "M120 0h48V24 142.1l23-23 17-17L241.9 136l-17 17-64 64-17 17-17-17L63 153l-17-17L80 102.1l17 17 23 23V24 0zM280 200a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM104 296a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm392-40a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM81.9 352H96h96 14l44.9-83.4 6.8-12.6H272h96 14.3l6.8 12.6L434 352h14 96 14.1l6.9 12.3 56 100.8 11.7 21-42 23.3-11.7-21-27-48.6V512H440V439.8l-27 48.6-11.7 21-42-23.3 11.7-21 35.2-63.4-3.4-6.3L376 345.5V432H264V345.5l-26.9 49.9-3.4 6.3L269 465.1l11.7 21-42 23.3-11.7-21-27-48.6V512H88V439.8L61 488.5l-11.7 21-42-23.3 11.7-21L75 364.3 81.9 352zM415 153l-17-17L432 102.1l17 17 23 23V24 0h48V24 142.1l23-23 17-17L593.9 136l-17 17-64 64-17 17-17-17-64-64z"],
    "seedling": [512, 512, [127793, "sprout"], "f4d8", "M512 0V32c0 113.6-84.6 207.5-194.2 222c-7.1-53.4-30.6-101.6-65.3-139.3C290.8 46.3 364 0 448 0h64zM0 64H64c123.7 0 224 100.3 224 224v32V480v32H224V480 320C100.3 320 0 219.7 0 96V64z"],
    "clock-seven": [512, 512, [], "e350", "M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zM232 120V248.7l-60 90-13.3 20 39.9 26.6 13.3-20 64-96 4-6V256 120 96H232v24z"],
    "left-right": [512, 512, [8596, "arrows-alt-h"], "f337", "M384 128L512 256 384 384l-32 0 0-80-192 0 0 80-32 0L0 256 128 128l32 0 0 80 192 0 0-80 32 0z"],
    "boxes-packing": [640, 512, [], "e4c7", "M640 0H256V128H416V256H384V512H640V0zM507.3 260.7l64 64-22.6 22.6L512 310.6V432v16H480V432 310.6l-36.7 36.7-22.6-22.6 64-64L496 249.4l11.3 11.3zM0 160v64H384V160H0zm352 96H32V512H352V256zm-96 64v32H128V320H256z"],
    "circle-arrow-left": [512, 512, ["arrow-circle-left"], "f0a8", "M512 256A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM119 239L231 127l17-17L281.9 144l-17 17-71 71L376 232l24 0 0 48-24 0-182.1 0 71 71 17 17L248 401.9l-17-17L119 273l-17-17 17-17z"],
    "flashlight": [640, 512, [128294], "f8b8", "M576 416h64V96H576V416zM544 97.7C449.1 107.9 384 160 384 160H0V352H384s65.1 52.1 160 62.3V97.7zM224 224h96v64H224V224z"],
    "group-arrows-rotate": [512, 512, [], "e4f6", "M159.7 89.9c20.8-12.1 44-20.4 68.8-23.9L219.5 2.6c-35.2 5-68.1 17.2-97.2 35.1C114.3 34 105.4 32 96 32C60.7 32 32 60.7 32 96c0 9.4 2 18.3 5.6 26.3c-17.8 29.1-30 61.9-35 97.2l63.4 9.1c3.5-24.8 11.8-48 23.9-68.8c2 .2 4.1 .3 6.1 .3c35.3 0 64-28.7 64-64c0-2.1-.1-4.1-.3-6.1zm262.4 69.9c12.1 20.8 20.4 44 23.9 68.8l63.4-9.1c-5-35.2-17.2-68.1-35.1-97.2c3.6-8 5.6-16.9 5.6-26.3c0-35.3-28.7-64-64-64c-9.4 0-18.3 2-26.3 5.6c-29.1-17.8-61.9-30-97.2-35.1l-9.1 63.4c24.8 3.5 48 11.8 68.8 23.9c-.2 2-.3 4.1-.3 6.1c0 35.3 28.7 64 64 64c2.1 0 4.1-.1 6.2-.3zM89.9 352.3c-12.1-20.8-20.4-44-23.9-68.8L2.6 292.5c5 35.2 17.2 68.1 35 97.2C34 397.7 32 406.6 32 416c0 35.3 28.7 64 64 64c9.4 0 18.3-2 26.3-5.6c29.1 17.8 61.9 30 97.2 35l9.1-63.4c-24.8-3.5-48-11.8-68.8-23.9c.2-2 .3-4.1 .3-6.1c0-35.3-28.7-64-64-64c-2.1 0-4.1 .1-6.1 .3zm262.4 69.9c-20.8 12.1-44 20.4-68.8 23.9l9.1 63.4c35.2-5 68.1-17.2 97.2-35c8 3.6 16.9 5.6 26.3 5.6c35.3 0 64-28.7 64-64c0-9.4-2-18.3-5.6-26.3c17.8-29.1 30-61.9 35.1-97.2l-63.4-9.1c-3.5 24.8-11.8 48-23.9 68.8c-2-.2-4.1-.3-6.2-.3c-35.3 0-64 28.7-64 64c0 2.1 .1 4.1 .3 6.2zM227.7 313.8c-20.8-10.6-34.9-32.2-34.9-57c0-15.6 5.6-29.9 14.9-41.1l25.9 25.9 0-81.6L152 160l21.7 21.7c-17.9 19.8-28.9 46.2-28.9 75.1c0 43.6 24.9 81.3 61.1 99.8l21.8-42.7zm93.1-58.6c0 15.6-5.6 29.9-14.9 41.1L280 270.4l0 81.6h81.6l-21.7-21.7c17.9-19.8 28.9-46.2 28.9-75.1c0-43.6-24.9-81.3-61.1-99.8l-21.8 42.7c20.8 10.6 34.9 32.2 34.9 57z"],
    "bowl-food": [512, 512, [], "e4c6", "M0 192c0-35.3 28.7-64 64-64c.5 0 1.1 0 1.6 0C73 91.5 105.3 64 144 64c15 0 29 4.1 40.9 11.2C198.2 49.6 225.1 32 256 32s57.8 17.6 71.1 43.2C339 68.1 353 64 368 64c38.7 0 71 27.5 78.4 64c.5 0 1.1 0 1.6 0c35.3 0 64 28.7 64 64c0 11.7-3.1 22.6-8.6 32H8.6C3.1 214.6 0 203.7 0 192zm0 88V256H512v24c0 67-39.2 124.9-96 151.8V480H96V431.8C39.2 404.9 0 347 0 280z"],
    "square-9": [448, 512, [], "e25e", "M0 32H448V480H0V32zM224 272a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm96-48c0-53-43-96-96-96s-96 43-96 96c0 49.2 37 89.8 84.7 95.3l-44.4 48.4L153.4 384h65.1l68.1-74.3c21.4-23.4 33.3-54 33.3-85.7z"],
    "candy-cane": [512, 512, [], "f786", "M348.8 131.5c3.7-2.3 7.9-3.5 12.2-3.5c12.7 0 23 10.3 23 23v5.6c0 9.9-5.1 19.1-13.5 24.3L14.5 403.5 82.4 512l356-222.5c45.8-28.6 73.6-78.8 73.6-132.8V151C512 67.6 444.4 0 361 0c-28.3 0-56 8-80.1 23L200.4 73.3l67.8 108.5 80.5-50.3zM298.4 49.8c9.2-5.7 19.1-10.1 29.4-13.1L348 97.5c-5.7 1.4-11.2 3.7-16.3 6.8l-12.6 7.9L298.4 49.8zm88.5 52.7l46.2-46.2c8.5 6.5 16.1 14.1 22.6 22.6l-46.2 46.2c-5.1-9.6-13-17.5-22.6-22.6zm28.9 59.3l61.6 20.5c-2.2 10.5-5.8 20.7-10.5 30.2l-62-20.7c6.2-8.8 10.1-19.1 11-30.1zm-86.1 82.5l60.4 37.7-30.2 18.9-60.4-37.7 30.2-18.9zm-107.2 67l60.4 37.7-30.2 18.9-60.4-37.7 30.2-18.9zM119.3 375.7l60.4 37.7-30.2 18.9L89.1 394.6l30.2-18.9z"],
    "arrow-down-wide-short": [576, 512, ["sort-amount-asc", "sort-amount-down"], "f160", "M320 480H288V416h32 32 32v64H352 320zm0-128H288V288h32 96 32v64H416 320zm0-128H288V160h32H480h32v64H480 320zm0-128H288V32h32H544h32V96H544 320zM151.7 469.5l-23.7 26-23.7-26-80-88L2.8 357.8l47.4-43 21.5 23.7L96 365.2V80 48h64V80 365.2l24.3-26.8 21.5-23.7 47.4 43-21.5 23.7-80 88z"],
    "square-dollar": [448, 512, ["dollar-square", "usd-square"], "f2e9", "M448 32H0V480H448V32zM244.2 149.4c18.3 2.6 36.2 7 54.1 11.5l-10.5 41.9c-16.3-4.1-32.5-8.1-49.1-10.6c-16.4-2.4-30.1-.5-39.3 3.5c-11 4.7-18 16.2-6.3 23.7c8.5 5.4 21.5 9.2 39.4 14.3l.8 .2c15.6 4.4 35.5 10.1 50.4 20.3c19.4 13.3 28.5 34.9 24.2 58.1c-4.1 22.4-19.7 37.1-38.4 44.7c-7.8 3.2-16.3 5.2-25.2 6.2V400H201V361.1c-11.7-2.6-26.7-7.4-36.6-10.6l0 0c-6.6-2.1-13.1-4.2-19.7-6.2c-2.3-.7-4.5-1.4-6.8-2.1l12.9-41.2c2.2 .7 4.4 1.4 6.6 2.1c7.3 2.3 14.6 4.6 21.9 6.9l0 0c12.1 3.9 26.4 8.4 34.5 9.7c17 2.5 30.6 1 39.5-2.6c12-4.8 17.7-19.1 5.9-27.1c-10.1-6.9-22.6-10.3-34.5-13.5c-2.3-.6-4.5-1.2-6.8-1.9c-15.1-4.3-34-9.6-48.2-18.7c-19.5-12.5-29.4-33.3-25.2-56.4c3.9-21.5 19.9-35.8 37.8-43.5c5.8-2.5 12.1-4.4 18.6-5.7V112h43.2v37.4z"],
    "phone-arrow-right": [512, 512, [], "e5be", "M144 0L0 32 0 64C0 311.4 200.6 512 448 512h32l32-144L368 288l-67 83.8C232.5 335.7 176.3 279.5 140.2 211L224 144 144 0zM413.8 23l-17-17L362.9 40l17 17 39 39H312 288v48h24H418.9l-39 39-17 17 33.9 33.9 17-17 80-80 17-17-17-17-80-80z"],
    "hand-holding-seedling": [576, 512, [], "f4bf", "M96 0c0 88.4 71.6 160 160 160v96 32h64V256 160C320 71.6 248.4 0 160 0H96zM480 0H416c-40.7 0-77.8 15.2-106 40.1c25.7 32.1 41.3 72.6 42 116.7C425 142 480 77.4 480 0zM140 327L68.8 384H0V512H32 224 384h12.4l10.2-7 128-88 33-22.7-45.3-65.9-33 22.7-94.5 65H256V384h32 64 32V320H352 288 224 160 148.8l-8.8 7z"],
    "message-check": [512, 512, ["comment-alt-check"], "f4a2", "M0 0H512V416H304L160 512V416H0V0zM369 153l17-17L352 102.1l-17 17-111 111-47-47-17-17L126.1 200l17 17 64 64 17 17 17-17L369 153z"],
    "cloud-bolt": [512, 512, [127785, "thunderstorm"], "f76c", "M0 320H96h48L312.6 192h51l-40 128H400h16 96V224c0-53-43-96-96-96V112c0-44.2-35.8-80-80-80c-24.3 0-46.1 10.9-60.8 28C256.5 24.3 219.1 0 176 0C114.1 0 64 50.1 64 112v21.5C26.7 146.6 0 182.2 0 224v96zm232 64L192 512 368 376V352H280l40-128L144 360v24h88z"],
    "chart-line-up-down": [512, 512, [], "e5d7", "M64 64V32H0V64 448v32H32 480h32V416H480 64V64zm416 0H352L336 80l41.4 41.4L288 210.7l-57.4-57.4L208 130.7l-22.6 22.6-88 88 45.3 45.3L208 221.3l57.4 57.4L288 301.3l22.6-22.6 112-112L464 208l16-16V64zm0 320V256l-16-16-41.4 41.4-34.7-34.7-45.3 45.3 34.7 34.7L336 368l16 16H480z"],
    "text-slash": [640, 512, ["remove-format"], "f87d", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L355.7 253.4 400.2 96H503L497 120.2 487 160h66l6.1-24.2 16-64L585 32H544 192 167L161 56.2l-9.6 38.5L48.4 14.8zM206.6 137.6l.5-1.9L217 96H333.7L301.2 211.1l-94.6-73.4zM327.3 353.9L272.9 311 243.3 416H192 160v64h32H352h32V416H352 309.8l17.6-62.1z"],
    "watch": [384, 512, [8986], "f2e1", "M320 0V72.2C283.7 46.8 239.6 32 192 32s-91.7 14.8-128 40.2V0H320zm0 439.8V512H64V439.8c36.3 25.3 80.4 40.2 128 40.2s91.7-14.8 128-40.2zM0 256a192 192 0 1 1 384 0A192 192 0 1 1 0 256zm216-80V152H168v24 80 12.8l10.7 7.1 48 32 20 13.3 26.6-39.9-20-13.3L216 243.2V176z"],
    "circle-down-left": [512, 512, [], "e107", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM160 192V352H320l24-24-52-52 76-76-56-56-76 76-52-52-24 24z"],
    "text": [448, 512, [], "f893", "M0 32H32 192h64H416h32V64v64 32H384V128 96H256l0 320h48 32v64H304 144 112V416h32 48l0-320H64v32 32H0V128 64 32z"],
    "projector": [640, 512, [], "f8d6", "M440 24V0H392V24v80 24h48V104 24zM281 39l-17-17L230.1 56l17 17 56 56 17 17L353.9 112 337 95 281 39zM585 73l17-17L568 22.1 551 39 495 95l-17 17L512 145.9l17-17 56-56zm55 119H512c-26.7-20.1-60-32-96-32s-69.3 11.9-96 32H0V448H64l16 64h64l16-64H320c26.7 20.1 60 32 96 32c24.4 0 47.5-5.5 68.2-15.2L496 512h64l16-64h64V192zM416 224a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM64 320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "face-smile-wink": [512, 512, [128521, "smile-wink"], "f4da", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM129.7 327.2l28.6-14.3c8.7 17.5 41.3 55.2 97.7 55.2s88.9-37.7 97.7-55.2l28.6 14.3C369.7 352.3 327.6 400 256 400s-113.7-47.7-126.3-72.8zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm148.4 29.6l-25.6-19.2c34.4-45.9 103.2-45.9 137.6 0l-25.6 19.2c-21.6-28.8-64.8-28.8-86.4 0z"],
    "tombstone-blank": [448, 512, [129702, "tombstone-alt"], "f721", "M224 0C118 0 32 86 32 192V416H416V192C416 86 330 0 224 0zM32 448H0v64H32 416h32V448H416 32z"],
    "chess-king-piece": [256, 512, ["chess-king-alt"], "f440", "M144 16V0H112V16 32H96 80V64H96h16V96H40v32l28.6 80H48v48H72h5.8L60.4 384H195.6L178.2 256H184h24V208H187.4L216 128V96H144V64h16 16V32H160 144V16zM43.9 416l-2.4 3.4-40 56L0 477.4V480v24 8H8 248h8v-8V480v-2.6l-1.5-2.1-40-56-2.4-3.4H208 48 43.9z"],
    "circle-6": [512, 512, [], "e0f3", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256-16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm-96 48c0 53 43 96 96 96s96-43 96-96c0-49.2-37-89.8-84.7-95.3l44.4-48.4L326.6 128H261.4l-68.1 74.3c-21.4 23.4-33.3 54-33.3 85.7z"],
    "left": [448, 512, ["arrow-alt-left"], "f355", "M0 256L192 448l32 0 0-128 224 0 0-128-224 0 0-128-32 0L0 256z"],
    "file-word": [384, 512, [], "f1c2", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM107.6 240l31.7 109.3L164 257.7l4.8-17.7h18.4 9.6 18.4l4.8 17.7 24.7 91.5L276.4 240h50L271.1 430.7 266 448H248h-8H221.6l-4.8-17.7-24.8-92-24.8 92L162.4 448H144h-8H118l-5-17.3L57.7 240h50z"],
    "file-powerpoint": [384, 512, [], "f1c4", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM136 240h68c42 0 76 34 76 76s-34 76-76 76H160v32 24H112V424 368 264 240h24zm68 104c15.5 0 28-12.5 28-28s-12.5-28-28-28H160v56h44z"],
    "square-down": [448, 512, [11015, "arrow-alt-square-down"], "f350", "M0 480l448 0 0-448L0 32 0 480zM96 256l80 0 0-128 96 0 0 128 80 0 0 32L224 416 96 288l0-32z"],
    "objects-align-center-vertical": [512, 512, [], "e3bd", "M64 32H224V232h64V96H448V232h64v48H448V416H288V280H224V480H64V280H0V232H64V32z"],
    "arrows-left-right": [512, 512, ["arrows-h"], "f07e", "M486.6 278.6L509.3 256l-22.6-22.6-96-96L368 114.7 322.7 160l22.6 22.6L386.7 224l-261.5 0 41.4-41.4L189.3 160 144 114.7l-22.6 22.6-96 96L2.7 256l22.6 22.6 96 96L144 397.3 189.3 352l-22.6-22.6L125.3 288l261.5 0-41.4 41.4L322.7 352 368 397.3l22.6-22.6 96-96z"],
    "house-lock": [640, 512, [], "e510", "M288.4 0L488.7 167.1C446.2 183 416 224 416 272v16H384l0 224H352V352H224V512H64.1V287.6H0V240L288.4 0zM528 240c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H416V320h32V272z"],
    "cloud-arrow-down": [640, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", "M144 480H0V336c0-62.7 40.1-116 96-135.8V192c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96v36c55.2 14.2 96 64.3 96 124V480H512 144zm79-167l80 80 17 17 17-17 80-80 17-17L400 262.1l-17 17-39 39V184 160H296v24V318.1l-39-39-17-17L206.1 296l17 17z"],
    "wreath": [448, 512, [], "f7e2", "M182.6 0c15.8 0 30.2 5.7 41.4 15.2C235.2 5.7 249.6 0 265.4 0c27.9 0 51.6 17.8 60.3 42.6c5.8-1.7 11.9-2.6 18.2-2.6c35.3 0 64 28.7 64 64c0 6.3-.9 12.5-2.6 18.2c24.8 8.8 42.6 32.5 42.6 60.3c0 15.8-5.7 30.2-15.2 41.4c9.5 11.2 15.2 25.6 15.2 41.4c0 27.9-17.8 51.6-42.6 60.3c1.7 5.8 2.6 11.9 2.6 18.2c0 32.6-24.4 59.6-56 63.5V384 339.6l-42.1 14L224 382.3l-85.9-28.6L96 339.6V384v23.5c-31.6-3.9-56-30.9-56-63.5c0-6.3 .9-12.5 2.6-18.2C17.8 317 0 293.3 0 265.4c0-15.8 5.7-30.2 15.2-41.4C5.7 212.8 0 198.4 0 182.6c0-27.9 17.8-51.6 42.6-60.3C40.9 116.5 40 110.3 40 104c0-35.3 28.7-64 64-64c6.3 0 12.5 .9 18.2 2.6C131 17.8 154.7 0 182.6 0zM224 120l-29.8 31.9-43.7-1.5 1.5 43.7L120 224l31.9 29.8-1.5 43.7 43.7-1.5L224 328l29.8-31.9 43.7 1.5-1.5-43.7L328 224l-31.9-29.8 1.5-43.7-43.7 1.5L224 120zM128 384l96 32 96-32V512l-96-32-96 32V384z"],
    "children": [640, 512, [], "e4e1", "M160 128A64 64 0 1 0 160 0a64 64 0 1 0 0 128zm-41.5 32H102.3l-9.6 13.1-70.5 96L3.3 294.9l51.6 37.9 18.9-25.8L88 287.6v.4 2.3L56 400H88v80 32h64V480 400h16v80 32h64V480 400h32L232 290.3V288v-.4l14.2 19.3 18.9 25.8 51.6-37.9-18.9-25.8-70.5-96L217.7 160H201.5h-83zM480 128A64 64 0 1 0 480 0a64 64 0 1 0 0 128zm-41.5 32H422.3l-9.6 13.1-70.5 96-18.9 25.8 51.6 37.9 18.9-25.8L408 287.6V480v32h64V480 384h16v96 32h64V480 287.6l14.2 19.3 18.9 25.8 51.6-37.9-18.9-25.8-70.5-96L537.7 160H521.5h-83z"],
    "meter-droplet": [640, 512, [], "e1ea", "M256 512c53.7 0 103.5-16.5 144.6-44.7C390 447.2 384 424.3 384 400v-2.1c0-28.3 8.2-56 23.7-79.7L499.6 177C466.3 74.3 369.8 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512zM192 160v32 32H128V192 160 128h64v32zm96 0v32 32H224V192 160 128h64v32zm96 0v32 32H320V192 160 128h64v32zm144 32L434.5 335.6c-12.1 18.5-18.5 40.2-18.5 62.3V400c0 61.9 50.1 112 112 112s112-50.1 112-112v-2.1c0-22.1-6.4-43.7-18.5-62.3L528 192z"],
    "chalkboard": [576, 512, ["blackboard"], "f51b", "M64 32H32V64 384H96V96H480V384h64V64 32H512 64zM224 352v64H32 0v64H32 544h32V416H544 416V352H224z"],
    "user-large-slash": [640, 512, ["user-alt-slash"], "f4fa", "M576 512H528L284.3 320H144L64 512H576l0 0zM382.2 273.9C430.6 250.7 464 201.3 464 144C464 64.5 399.5 0 320 0C250.1 0 191.8 49.9 178.7 116L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L382.2 273.9z"],
    "signal-strong": [640, 512, ["signal-4"], "f68f", "M480 128V96H416v32V480v32h64V480 128zM352 224V192H288v32V480v32h64V480 224zM224 288H160v32V480v32h64V480 320 288zM96 416V384H32v32 64 32H96V480 416z"],
    "lollipop": [512, 512, [127853, "lollypop"], "e424", "M210.8 334.8C265.3 314.2 304 261.6 304 200v-8c0-61.9-50.1-112-112-112S80 130.1 80 192c0 39.8 32.2 72 72 72s72-32.2 72-72V176H176v16c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-35.3 28.7-64 64-64s64 28.7 64 64v8c0 53-43 96-96 96h-8C94.6 296 48 249.4 48 192c0-79.5 64.5-144 144-144s144 64.5 144 144c0 73.2-54.6 133.6-125.2 142.8zM0 192C0 298 86 384 192 384c41.5 0 79.9-13.1 111.2-35.5L465.4 510.6l45.3-45.3L348.5 303.2C370.9 271.9 384 233.5 384 192C384 86 298 0 192 0S0 86 0 192z"],
    "list-tree": [512, 512, [], "e1d2", "M96 48H0v96H24V256 416v24H48h80v24h96V368H128v24H72V280h56v24h96V208H128v24H72V144H96V48zm64 16v64h32H480h32V64H480 192 160zM288 224v64h32H480h32V224H480 320 288zm0 160v64h32H480h32V384H480 320 288z"],
    "envelope-open": [512, 512, [62135], "f2b6", "M64 246.9L256 384 448 246.9V224L256 80 64 224v22.9zM0 192L256 0 512 192V448v64H448 64 0V448 192z"],
    "draw-circle": [512, 512, [], "f5ed", "M104 206c14.7 11.7 24 29.8 24 50s-9.4 38.3-24 50c15.8 48.2 53.9 86.2 102 102c11.7-14.7 29.8-24 50-24s38.3 9.4 50 24c48.2-15.8 86.2-53.9 102-102c-14.7-11.7-24-29.8-24-50s9.4-38.3 24-50c-15.8-48.2-53.9-86.2-102-102c-11.7 14.7-29.8 24-50 24s-38.3-9.4-50-24c-48.2 15.8-86.2 53.9-102 102zm92.7 266.1c-76-20.8-135.9-80.7-156.7-156.7C16.5 305.8 0 282.8 0 256s16.5-49.8 39.9-59.3c20.8-76 80.7-135.9 156.7-156.7C206.2 16.5 229.2 0 256 0s49.8 16.5 59.3 39.9c76 20.8 135.9 80.7 156.7 156.7c23.4 9.5 39.9 32.5 39.9 59.3s-16.5 49.8-39.9 59.3c-20.8 76-80.7 135.9-156.7 156.7C305.8 495.5 282.8 512 256 512s-49.8-16.5-59.3-39.9z"],
    "cat-space": [640, 512, [], "e001", "M576 160c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-32.5 12.1-62.1 32-84.7V160c0 53 43 96 96 96s96-43 96-96V75.3c19.9 22.6 32 52.2 32 84.7zM416 96L374.9 54.9C395.6 40.5 420.8 32 448 32s52.4 8.5 73.1 22.9L480 96H416zm64 220.8C553 302 608 237.4 608 160C608 71.6 536.4 0 448 0S288 71.6 288 160c0 11.7 1.3 23.1 3.6 34.1c-54.9 8.1-102.2 39.5-131.6 83.8V192c0-53-43-96-96-96H32v64H64c17.7 0 32 14.3 32 32V480v32h32H336h32V448H336 280L416 339.2V480v32h64V480 316.8zM400 160a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM241.3 46.7L224 0 206.7 46.7 160 64l46.7 17.3L224 128l17.3-46.7L288 64 241.3 46.7z"],
    "handshake-simple-slash": [640, 512, ["handshake-alt-slash"], "e05f", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L509 372.4l6.8-7.4-35.4-32.4-134.2-123-23.4 18.2-26.1-20.3 77.4-60.2 12.6-9.8 19.6 25.3-12.6 9.8-20.9 16.2L550.2 352H640V128H592 516h-4-.7l-3.9-2.5L411.3 64H349.7L233.2 158.3l-26-20.2L298.8 64H224l-60.4 40.3L48.4 14.8zM0 128V352H156.2l73.9 67.4 35.4 32.4 47.7-52.2 22.3 20.5 35.4 32.4 34.2-37.3L40.6 128H0z"],
    "rabbit-running": [576, 512, ["rabbit-fast"], "f709", "M448 32l-24 0-4.7 16.5c-3.2 11.2-5 22.5-5.6 33.8c23.5 20.8 41.5 47.4 51.9 77.7H439.9c-18-44.5-55.4-79-102.1-93L328 64 296 80l7.1 19.7c13.5 37.5 39.5 68.4 72.9 88.2v26.8L271.7 154.9C240.8 137.3 205.8 128 170.2 128c-32.3 0-62.2 16.8-78.9 44.4C81 159.9 65.4 152 48 152c-30.9 0-56 25.1-56 56s25.1 56 56 56c11.3 0 21.8-3.3 30.6-9.1c4.9 17.2 14.5 33.1 28.4 45.9L258.4 439.6l9.2 8.4H280 408h32V384H408 344 327.2 312V340.5c0-42.9-28.4-80.5-69.6-92.3l-30.8-8.8 8.8-30.8 30.8 8.8c55 15.7 92.8 65.9 92.8 123.1v15.7l56-32.4 6.4-3.7H568V231.1l-71-57.9c8-48.9-7.6-99.1-42.8-135L448 32zM152.1 408.4l-26.8 17.5 35 53.6L187.1 462l28.2-18.4-48.7-44.6-14.5 9.5zM472 240a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "memo-pad": [448, 512, [], "e1da", "M0 0V96H448V0H0zM0 128V512H448V128H0zm96 80h16H336h16v32H336 112 96V208zm0 96h16H336h16v32H336 112 96V304zm0 96h16 96 16v32H208 112 96V400z"],
    "mattress-pillow": [640, 512, [], "e525", "M256 64H0V448H256V64zm32 384H640V64H288V448zM64 128H192V384H64V128z"],
    "alarm-plus": [512, 512, [], "f844", "M14.9 146.4C5.5 131.6 0 114 0 95.2C0 42.6 42.6 0 95.2 0c25 0 47.8 9.6 64.8 25.4L14.9 146.4zM390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6l-19.2 19.2L80 509.3 34.7 464l22.6-22.6 19.2-19.2C48.6 384.8 32 338.3 32 288C32 164.3 132.3 64 256 64s224 100.3 224 224c0 50.3-16.6 96.8-44.6 134.2l19.2 19.2L477.3 464 432 509.3l-22.6-22.6-19.2-19.2zM352 25.4C369 9.6 391.8 0 416.8 0C469.4 0 512 42.6 512 95.2c0 18.8-5.5 36.3-14.9 51.1L352 25.4zM280 176H232v24 64H168 144v48h24 64v64 24h48V376 312h64 24V264H344 280V200 176z"],
    "alicorn": [640, 512, [], "f6b0", "M448 160v78.1V240h0c-.5 30-12.8 56.4-32 75.7V512H320V346.7c-4.1-.7-8.2-1.6-12.3-2.8L224 320v16 19.9l-14.1 14.1-27 27 38.3 115H120.1L82.5 399.2 73.1 371l21-21 26.6-26.6L78.2 259.9c-7.3-11-11.9-23.4-13.6-36.4C54.6 230.8 48 242.6 48 256v56 24H0V312 256c0-44.6 33.2-81.5 76.3-87.2c13-21.4 35.2-36.5 61.1-40c3.8 15.3 9.2 29.8 16.5 43c11.3 20.4 27.4 37.7 49.9 49.8c7.5 4 15.5 7.4 24.2 10.1C139.8 173.7 160 32 160 32l160 96C320 57.3 377.3 0 448 0h32 64 16V32H544 528l16 16h96V64L560 90.7V192l-80 32-32-64zm64-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "comment-question": [512, 512, [], "e14b", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM168 168v6.5l48 0 0-6.5c0-4.4 3.6-8 8-8h56.9c8.4 0 15.1 6.8 15.1 15.1c0 5.4-2.9 10.4-7.6 13.1l-44.3 25.4L232 220.6v13.9V256v24h48V256v-7.6l32.3-18.5c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1H224c-30.9 0-56 25.1-56 56zm64 152v48h48V320H232z"],
    "gingerbread-man": [448, 512, [], "f79d", "M320 96c0 33.4-17 62.8-42.9 80H368h64V304H368 320v24.8l80 96V512H306l-82-98.4L142 512H48V424.8l80-96V304H80 16V176H80h90.9C145 158.8 128 129.4 128 96c0-53 43-96 96-96s96 43 96 96zM192 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-16-48a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "guarani-sign": [384, 512, [], "e19a", "M224 0H160V66.7C69.2 81.9 0 160.9 0 256s69.2 174.1 160 189.3V512h64V445.3c90.8-15.2 160-94.2 160-189.3V224H352 224V132c22.1 5.7 41.8 17.1 57.6 32.6l44.8-45.7C299 92 263.5 73.3 224 66.7V0zM160 132V380c-55.2-14.2-96-64.3-96-124s40.8-109.8 96-124zM224 380V288h92c-11.6 45-47 80.4-92 92z"],
    "burger-fries": [640, 512, [], "e0cd", "M64 32L97.4 221.4 117.7 272H128V90.7L112 0 64 32zM18.7 192H59.7L41.8 90.5 0 80 18.7 192zM384 80L342.7 90.3 325.8 192h7.3c10.4-6.1 22-11.7 35-16.5L384 80zM256 512V304H96L64 224H0L64 512H256zm0-240h4c2.2-5.2 4.7-10.3 7.6-15.3c3.1-5.3 7-11.3 11.9-17.7l10.2-25.5L320 32 256 48V272zm-96 0h64V240 32L160 0V272zm480 15.8s-32-96-176-96s-176 96-176 96v32H640v-32zm-256-48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-256 112v64H640v-64H288zm0 96v64H640v-64H288z"],
    "mug-tea": [576, 512, [], "f875", "M144 64v64L96 176V288H224V176l-48-48V64H384h32 32c70.7 0 128 57.3 128 128s-57.3 128-128 128H416V448H32V64H144zM416 256h32c35.3 0 64-28.7 64-64s-28.7-64-64-64H416V256z"],
    "border-top": [448, 512, [], "f855", "M0 32H448V96H0V32zm0 96H64v64H0V128zm448 0v64H384V128h64zm-256 0h64v64H192V128zM64 320v64H0V320H64zm320 0h64v64H384V320zm-128 0v64H192V320h64zM0 224H64v64H0V224zm448 0v64H384V224h64zm-256 0h64v64H192V224zM64 416v64H0V416H64zm320 0h64v64H384V416zm-128 0v64H192V416h64zM96 224h64v64H96V224zm64 192v64H96V416h64zm128 0h64v64H288V416zm64-192v64H288V224h64z"],
    "arrows-rotate": [512, 512, [128472, "refresh", "sync"], "f021", "M105.1 202.6c7.7-21.8 20.2-42.3 37.8-59.8c62.5-62.5 163.8-62.5 226.3 0L386.3 160H336 304v64h32H464h32V192 64 32H432V64v51.2L414.4 97.6c-87.5-87.5-229.3-87.5-316.8 0C73.2 122 55.6 150.7 44.8 181.4l60.4 21.3zM80 396.9l17.6 17.5 0 0c87.5 87.4 229.3 87.4 316.7 0c24.4-24.4 42.1-53.1 52.9-83.7l-60.4-21.3c-7.7 21.8-20.2 42.3-37.8 59.8c-62.5 62.5-163.8 62.5-226.3 0l-.1-.1L125.6 352H176h32V288H176 48 16v32V448v32H80V448 396.9z"],
    "circle-book-open": [512, 512, ["book-circle"], "e0ff", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 336c-27.8 0-56 16-56 16V176s28.2-16 56-16s56 16 56 16V352s-28.2-16-56-16zm144 0c-27.8 0-56 16-56 16V176s28.2-16 56-16s56 16 56 16V352s-28.2-16-56-16z"],
    "arrows-to-dotted-line": [448, 512, [], "e0a6", "M256 32V0H192V32 64H128V96l96 96 96-96V64H256V32zM192 448v32 32h64V480 448h64V416l-96-96-96 96v32h64zM64 224H0v64H64V224zm32 0v64h64V224H96zm160 0H192v64h64V224zm32 0v64h64V224H288zm96 0v64h64V224H384z"],
    "fire-extinguisher": [512, 512, [129519], "f134", "M128 0h96V56h64V32L512 0V160L288 128V104H224v34.8c37.8 18 64 56.5 64 101.2V384H64V240c0-44.7 26.2-83.2 64-101.2V110c-36.2 11.1-66 36.9-82.3 70.5l-43.1-21C26.7 109.8 72.7 72.6 128 60.4V0zM288 512H64V416H288v96zM176 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "garage-open": [640, 512, [], "e00b", "M0 128V512H96V192H544V512h96V128L320 0 0 128zM176.7 320l-15.1 39.4-1.6 4.2V368v24 24 64 32h64V480 464H416v16 32h64V480 416 392 366.2v-4.5l-1.7-4.2L463.7 320H412.1l6.3 16H222l6.2-16H176.7zM240 376a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm136 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM512 224H128v64H512V224z"],
    "shelves-empty": [640, 512, [], "e246", "M64 32V0H0V32 160v32 32V416v32 32 32H64V480H576v32h64V480 448 416 224 192 160 32 0H576V32 160H64V32zm0 192H576V416H64V224z"],
    "cruzeiro-sign": [448, 512, [], "e152", "M96 256c0-88.4 71.6-160 160-160c47.8 0 90.6 20.9 120 54.2l48-42.4C383 61.4 322.9 32 256 32C132.3 32 32 132.3 32 256s100.3 224 224 224c66.9 0 127-29.4 168-75.8l-48-42.4C346.6 395.1 303.8 416 256 416V320v-1.4c0-16.9 13.7-30.6 30.6-30.6c5.6 0 11 1.5 15.8 4.4l25.1 15.1 32.9-54.9-25.1-15.1c-14.7-8.8-31.5-13.5-48.7-13.5c-10.7 0-21 1.8-30.6 5.1V224H192v94.6V320v82.7C135.5 378 96 321.6 96 256z"],
    "watch-apple": [384, 512, [], "e2cb", "M64 0V48H320V0H64zM384 80H0V432H384V80zM192 213.3a42.7 42.7 0 1 1 0 85.3 42.7 42.7 0 1 1 0-85.3zM213.3 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-74.7-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm74.7-160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-74.7-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm224-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm32 240H64v48H320V464z"],
    "watch-calculator": [384, 512, [], "f8f0", "M64 0H320V48H64V0zm0 512V464H320v48H64zM0 80H384V432H0V80zm64 64v64H320V144H64zm48 104H64v48h48V248zm56 0v48h48V248H168zm152 0H272v48h48V248zM64 336v48h48V336H64zm152 0H168v48h48V336zm56 0v48h48V336H272z"],
    "list-dropdown": [512, 512, [], "e1cf", "M512 32H0V480H512V32zM448 192V416H64V192H448zM352 96h96l-48 48L352 96zM128 232H104v48h24H384h24V232H384 128zm0 96H104v48h24H384h24V328H384 128z"],
    "cabinet-filing": [448, 512, [128452], "f64b", "M0 0H448V240H0V0zM0 272H448V512H0V272zM128 96v16 32 16h32V144 128H288v16 16h32V144 112 96H304 144 128zm0 256v16 32 16h32V400 384H288v16 16h32V400 368 352H304 144 128z"],
    "burger-soda": [640, 512, [], "f858", "M224 0H205l-4.4 18.5L174.9 128H32 0v64H32 333.1c14.5-8.5 31.3-16 50.9-21.6V128H352 224.2L243 48h37 24V0H280 224zM40 224L64 512H256V282.6c3-9.1 6.7-17.5 11.6-25.9c5.4-9.3 13.4-20.8 24.8-32.7H40zm600 63.8s-32-96-176-96s-176 96-176 96v32H640v-32zm-256-48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-256 112v64H640v-64H288zm0 96v64H640v-64H288z"],
    "square-arrow-up": [448, 512, ["arrow-square-up"], "f33c", "M448 32H0V480H448V32zM241 119L353 231l17 17L336 281.9l-17-17-71-71V376v24H200V376 193.9l-71 71-17 17L78.1 248l17-17L207 119l17-17 17 17z"],
    "greater-than-equal": [448, 512, [], "f532", "M34.7 33.8l-2.7-1v67.9L288.5 192 32 283.2v67.9l2.7-1 360-128 21.3-7.6V169.4l-21.3-7.6-360-128zM416 416H32 0v64H32 416h32V416H416z"],
    "pallet-box": [640, 512, [], "e208", "M128 0H256V128l64-48 64 48V0H512V256H128V0zM0 320H32 64 96h32H288h32 32H512h32 32 32 32v64H608 576v64h32 32v64H608 576 544 512 352 320 288 128 96 64 32 0V448H32 64V384H32 0V320zM128 448H288V384H128v64zm224 0H512V384H352v64z"],
    "face-confounded": [512, 512, [], "e36c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM216.9 354.7L256 380.8l39.1-26.1 8.9-5.9 8.9 5.9 40.3 26.8 23.7-11.8 14.3-7.2 14.3 28.6-14.3 7.2-32 16-8.3 4.2-7.7-5.2L304 387.2l-39.1 26.1-8.9 5.9-8.9-5.9L208 387.2l-39.1 26.1-7.7 5.2-8.3-4.2-32-16-14.3-7.2 14.3-28.6 14.3 7.2 23.7 11.8 40.3-26.8 8.9-5.9 8.9 5.9zM112 192l118.9 64L112 320l45.7-64L112 192zm169.1 64L400 192l-45.7 64L400 320 281.1 256z"],
    "shield-halved": [512, 512, ["shield-alt"], "f3ed", "M267.6 4.5L256 0 244.4 4.5 36.9 85 17.8 92.5 16.6 113c-2.9 49.9 4.9 126.3 37.3 200.9c32.7 75.3 91 150 189.4 192.6L256 512l12.7-5.5c98.4-42.6 156.7-117.3 189.4-192.6c32.4-74.7 40.2-151 37.3-200.9l-1.2-20.5L475.1 85 267.6 4.5zM256 68.7l0 0L432 137c-.5 40.9-8.8 96.8-32.6 151.5c-26.2 60.3-70.6 118-143.5 153.5V68.7z"],
    "truck-plow": [640, 512, [], "f7de", "M128 32h32H288h18.1l9.3 15.5L402.1 192H480v96h32V176v-8.9l4.6-7.6 48-80L581 52.1 635.9 85l-16.5 27.4L576 184.9V288v64 7.1l43.4 72.4L635.9 459 581 491.9l-16.5-27.4-48-80-4.6-7.6V368 352H474.5c3.5 10 5.5 20.8 5.5 32c0 53-43 96-96 96s-96-43-96-96c0-11.2 1.9-22 5.5-32H224c-1.9 0-3.8-.2-5.6-.5c3.7 10.2 5.6 21.1 5.6 32.5c0 53-43 96-96 96s-96-43-96-96c0-11.2 1.9-22 5.5-32H0V192H128V64 32zm64 160H327.5L269.9 96H192v96zM160 384a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm256 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "book-atlas": [448, 512, ["atlas"], "f558", "M0 96C0 43 43 0 96 0H384h32 32V384H416v64h32v64H416 384 96c-53 0-96-43-96-96V96zM64 416c0 17.7 14.3 32 32 32H352V384H96c-17.7 0-32 14.3-32 32zM247.4 283.8c-3.7 3.7-6.2 4.2-7.4 4.2s-3.7-.5-7.4-4.2c-3.8-3.7-8-10-11.8-18.9c-6.2-14.5-10.8-34.3-12.2-56.9h63c-1.5 22.6-6 42.4-12.2 56.9c-3.8 8.9-8 15.2-11.8 18.9zm42.7-9.9c7.3-18.3 12-41.1 13.4-65.9h31.1c-4.7 27.9-21.4 51.7-44.5 65.9zm0-163.8c23.2 14.2 39.9 38 44.5 65.9H303.5c-1.4-24.7-6.1-47.5-13.4-65.9zM368 192a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM145.3 208h31.1c1.4 24.7 6.1 47.5 13.4 65.9c-23.2-14.2-39.9-38-44.5-65.9zm31.1-32H145.3c4.7-27.9 21.4-51.7 44.5-65.9c-7.3 18.3-12 41.1-13.4 65.9zm56.1-75.8c3.7-3.7 6.2-4.2 7.4-4.2s3.7 .5 7.4 4.2c3.8 3.7 8 10 11.8 18.9c6.2 14.5 10.8 34.3 12.2 56.9h-63c1.5-22.6 6-42.4 12.2-56.9c3.8-8.9 8-15.2 11.8-18.9z"],
    "virus": [512, 512, [], "e074", "M256 0H224V32 43.5c0 49.9-60.3 74.9-95.6 39.6L120.2 75 97.6 52.4 75 75l0 0 0 0L52.4 97.6 75 120.2l8.2 8.2 0 0C118.4 163.7 93.4 224 43.5 224H32 0v32 32H32 43.5c49.9 0 74.9 60.3 39.6 95.6L75 391.8 52.4 414.4 75 437l0 0 22.6 22.6L120.2 437l8.2-8.2 0 0c35.3-35.2 95.6-10.3 95.6 39.6V480v32h32 32V480 468.5c0-49.9 60.3-74.9 95.6-39.6l8.2 8.2 22.6 22.6L437 437l22.6-22.6L437 391.8l-8.2-8.2c-35.3-35.3-10.3-95.6 39.6-95.6H480h32V256 224H480 468.5c-49.9 0-74.9-60.3-39.6-95.6l8.2-8.2 22.6-22.6L437 75 414.4 52.4 391.8 75l-8.2 8.2 0 0C348.3 118.4 288 93.4 288 43.5V32 0H256zM176 224a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm128 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "grid-round-2": [512, 512, [], "e5db", "M128 32a96 96 0 1 0 0 192 96 96 0 1 0 0-192zm0 256a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM288 128a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm96 160a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"],
    "comment-middle-top": [512, 512, [], "e14a", "M320.1 102.6C430.5 125.7 512 207.1 512 304c0 114.9-114.6 208-256 208S0 418.9 0 304c0-96.9 81.5-178.3 191.9-201.4L256 0l64.1 102.6z"],
    "envelope-circle-check": [640, 512, [], "e4e8", "M0 64v80L256 320l78.4-53.9c26.1-60.2 84.9-103 154.1-105.9L512 144V64H0zM274.1 346.4L256 358.8l-18.1-12.5L0 182.8V448H360.2C335.1 417.6 320 378.5 320 336c0-7.5 .5-14.9 1.4-22.1l-47.2 32.5zM640 336a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-65.4-32l-11.3 11.3-72 72L480 398.6l-11.3-11.3-40-40L417.4 336 440 313.4l11.3 11.3L480 353.4l60.7-60.7L552 281.4 574.6 304z"],
    "layer-group": [576, 512, [], "f5fd", "M0 128L288 256 576 128 288 0 0 128zm104.6 81.5L0 256 288 384 576 256 471.4 209.5 288 291 104.6 209.5zM288 419L104.6 337.5 0 384 288 512 576 384 471.4 337.5 288 419z"],
    "restroom-simple": [640, 512, [], "e23a", "M192 64A64 64 0 1 0 64 64a64 64 0 1 0 128 0zm32 96H32L24 352H64V512H192V352h40l-8-192zM344 0H296V24 488v24h48V488 24 0zM512 128A64 64 0 1 0 512 0a64 64 0 1 0 0 128zM640 384L576 160H448L384 384h64V512H576V384h64z"],
    "arrows-to-dot": [512, 512, [], "e4be", "M256 192L160 96V64h64V32 0h64V32 64h64V96l-96 96zM416 352l-96-96 96-96h32v64h32l32 0v64H480 448v64H416zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 64l96 96v32H288v32 32H224V480 448H160V416l96-96zM96 352H64l0-64H32 0V224l32 0H64l0-64H96l96 96L96 352z"],
    "border-outer": [448, 512, [], "f851", "M64 96V416H384V96H64zM0 32H64 384h64V96 416v64H384 64 0V416 96 32zm256 96v64H192V128h64zM96 224h64v64H96V224zm160 0v64H192V224h64zm32 0h64v64H288V224zm-32 96v64H192V320h64z"],
    "hashtag-lock": [576, 512, [], "e415", "M308.9 32h64.9l-16 96H432h12.9l-5.8 34.8c-20.5 4.7-38.9 15-53.5 29.2H347.1l-16 96H320l0 96h-4.9l-16 96H234.2l16-96H155.1l-16 96H74.2l16-96H16 3.1l10.7-64H16h84.9l21.3-128H48 35.1l10.7-64H48h84.9l16-96h64.9l-16 96h95.1l16-96zM165.8 320h95.1l21.3-128H187.1L165.8 320zM464 240c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H352V320h32V272z"],
    "clock-two-thirty": [512, 512, [], "e35b", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V256 243.2l10.7-7.1 96-64 20-13.3 26.6 39.9-20 13.3L280 268.8V392v24H232V392z"],
    "archway": [512, 512, [], "f557", "M0 32H32 480h32V96H480 32 0V32zM0 416H32V128H480V416h32v64H480 416 384 352V352c0-53-43-96-96-96s-96 43-96 96V480H128 96 32 0V416z"],
    "heart-circle-check": [576, 512, [], "e4fd", "M64 288L39.8 263.8C14.3 238.3 0 203.8 0 167.8C0 92.8 60.8 32 135.8 32c36 0 70.5 14.3 96 39.8L256 96l24.2-24.2c25.5-25.5 60-39.8 96-39.8C451.2 32 512 92.8 512 167.8c0 13.8-2.1 27.4-6.2 40.4C483.4 197.8 458.4 192 432 192c-97.2 0-176 78.8-176 176c0 32.2 8.6 62.3 23.7 88.3L256 480 64 288zm224 80a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm222.6-32L488 313.4l-11.3 11.3L416 385.4l-28.7-28.7L376 345.4 353.4 368l11.3 11.3 40 40L416 430.6l11.3-11.3 72-72L510.6 336z"],
    "house-chimney-crack": [576, 512, ["house-damage"], "f6f1", "M576 287.6H511.8l1 224.4H326.4L288 448l96-80L224 256l64 112-96 80 38.4 64H64.1V287.6H0V240L288.4 0 416 106.5V32h96V186.6L576 240v47.6z"],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM96 32h16 32 16V64H144 112 96V32zm0 64h16 32 16v32H144 112 96V96zm0 64h16 32 16v32H144 112 96V160zM64 416V344L96 224h64l32 120v72H64zm48-80H96v32h16 32 16V336H144 112z"],
    "heart-half": [512, 512, [], "e1ab", "M39.8 263.8L256 480V96L231.8 71.8c-25.5-25.5-60-39.8-96-39.8C60.8 32 0 92.8 0 167.8c0 36 14.3 70.5 39.8 96z"],
    "comment-check": [512, 512, [], "f4ac", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM369 193l17-17L352 142.1l-17 17-111 111-47-47-17-17L126.1 240l17 17 64 64 17 17 17-17L369 193z"],
    "square": [448, 512, [9632, 9723, 9724, 61590], "f0c8", "M0 32H448V480H0V32z"],
    "memo": [384, 512, [], "e1d8", "M384 0H0V512H384V0zM80 128H304h16v32H304 80 64V128H80zm0 96H304h16v32H304 80 64V224H80zm0 96H208h16v32H208 80 64V320H80z"],
    "martini-glass-empty": [512, 512, ["glass-martini"], "f000", "M0 48L16 64 210.7 258.7 224 272V448H160 128v64h32 96 96 32V448H352 288V272l13.3-13.3L496 64l16-16V0H448 64 0V48zM106.5 64h299L256 213.5 106.5 64z"],
    "couch": [640, 512, [], "f4b8", "M64 32V192H96h32v32 96H512V224 192h32 32V32H64zm0 192H0V480H96V448H544v32h96V224H576 544v32 64 32H512 128 96V320 256 224H64z"],
    "cedi-sign": [384, 512, [], "e0df", "M256 32V0H192V32 66.7C101.2 81.9 32 160.9 32 256s69.2 174.1 160 189.3V480v32h64V480 445.3c49.6-8.3 92.7-35.6 121.6-74.1l-51.2-38.4c-17.2 22.9-41.9 39.8-70.4 47.2V132c28.5 7.3 53.2 24.2 70.4 47.2l51.2-38.4C348.7 102.3 305.6 75 256 66.7V32zM192 132V380c-55.2-14.2-96-64.3-96-124s40.8-109.8 96-124z"],
    "italic": [384, 512, [], "f033", "M128 32h32H352h32V96H352 293.3L160 416h64 32v64H224 32 0V416H32 90.7L224 96H160 128V32z"],
    "glass-citrus": [512, 512, [], "f869", "M448 144c0-44.2-35.8-80-80-80c-26.2 0-49.4 12.6-64 32H232.2C252 40.1 305.3 0 368 0c79.5 0 144 64.5 144 144s-64.5 144-144 144l-.5 0 6.7-64.2c41.3-3.2 73.8-37.7 73.8-79.8zM274.3 256l6.7-64H71l6.7 64H274.3zM312 512H40L6.7 192 0 128H64.3 287.7 352l-6.7 64L312 512z"],
    "calendar-lines-pen": [576, 512, [], "e472", "M160 0V64H288V0h64V64h96v96H0V64H96V0h64zM0 192H448v44.4l-181 181L253.4 512H0V192zm288 80H96v48H288V272zm-64 96H96v48H224V368zM505 223.8l71 71-41.3 41.3-71-71L505 223.8zm-63.9 63.9l71 71L370.9 500 288 511.9 299.9 429 441.1 287.8z"],
    "church": [640, 512, [9962], "f51d", "M344 24V0H296V24 48H264 240V96h24 32v46.4L160 224V512h96V416c0-35.3 28.7-64 64-64s64 28.7 64 64v96h96V224L344 142.4V96h32 24V48H376 344V24zM0 344V512H128V273.6L0 344zM640 512V344L512 273.6V512H640z"],
    "person-snowmobiling": [640, 512, ["snowmobile"], "f7d1", "M240 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM373.5 85.3L362.7 63.8 319.8 85.3l10.7 21.5 37.4 74.7L360 192H304l-80-72H160L106.7 220.6c-11.4 21.6-9.4 47.8 5.3 67.4H80L31.1 385.8c5.4-1.2 11.1-1.8 16.9-1.8H272c26.2 0 49.4 12.6 64 32H450l36 48H440 416v48h24H568h9.9l7-7 32-32 17-17L600 422.1l-17 17-25 25H546l-46-61.3L576 352V256L419.8 177.9 373.5 85.3zM272 256h40l-24 32H264l-72-32 32-48 48 48zM48 416c-26.5 0-48 21.5-48 48s21.5 48 48 48H272c26.5 0 48-21.5 48-48s-21.5-48-48-48H48z"],
    "face-hushed": [512, 512, [], "e37b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM256 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM192 160c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8l-11.7 10.9L89.4 175.2l11.7-10.9c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1h16v32H192zm141 .9c-4.3-.6-8.6-.9-13-.9H304V128h16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2l11.7 10.9-21.8 23.4-11.7-10.9c-15.5-14.5-34.8-24-56.1-26.8z"],
    "comments-dollar": [640, 512, [], "f653", "M208 352c114.9 0 208-78.8 208-176S322.9 0 208 0S0 78.8 0 176c0 37.5 13.9 72.3 37.6 100.9L0 352l108.1-21.6C137.7 344.2 171.8 352 208 352zm23.5 31C255.8 457.4 336.4 512 432 512c36.2 0 70.3-7.8 99.9-21.6L640 512l-37.6-75.1C626.1 408.3 640 373.5 640 336c0-92.8-84.9-168.9-192.6-175.5c.4 5.1 .6 10.3 .6 15.5c0 112.3-99.1 196.9-216.5 207zM228 80v6.3c6.6 1.2 16.7 3.2 21.1 4.4l19.3 5.1-10.3 38.7-19.3-5.1c-3.8-1-17.4-3.7-21.7-4.3c-12.2-1.9-22.2-.3-28.6 2.6c-6.3 2.9-7.9 6.2-8.2 8.1c-.6 3.4 0 4.7 .1 5c.3 .5 1 1.8 3.6 3.5c6.1 4.2 15.7 7.2 29.9 11.4l.8 .2 0 0 0 0c12.1 3.7 28.3 8.5 40.4 17.4c6.7 4.9 13 11.4 16.9 20.5c4 9.1 4.8 19.1 3 29.4c-3.3 19-15.9 32-31.6 38.7c-4.9 2.1-10.1 3.6-15.4 4.6V272v20H188V272v-6.4c-9.5-2.2-22-6.4-29.9-9.1l0 0c-1.7-.6-3.2-1.1-4.4-1.5l-19-6.3 12.6-38 19 6.3c2 .7 4.2 1.4 6.4 2.1l0 0c9.5 3.2 20.2 6.9 26.2 7.9c12.8 2 22.7 .7 28.8-1.9c5.5-2.3 7.4-5.3 8-8.8c.7-4 .1-5.9-.2-6.7c-.4-.9-1.3-2.2-3.7-4c-5.9-4.3-15.3-7.5-29.3-11.7l-2.2-.7c-11.7-3.5-27-8.1-38.6-16c-6.6-4.5-13.2-10.7-17.3-19.5c-4.2-9-5.2-18.8-3.4-29c3.2-18.3 16.2-30.9 31.1-37.7c5-2.3 10.4-4 16-5.1V80 60h40V80z"],
    "pickaxe": [512, 512, [], "e5bf", "M462.4 373.5l0 0-.1-.2-.3-.8c-.3-.7-.7-1.8-1.3-3.3c-1.2-2.9-3-7.2-5.5-12.7c-5-11-12.6-26.7-23.1-45.3c-21-37.3-53.6-86-99.5-132s-94.7-78.5-132-99.5c-18.6-10.5-34.3-18.1-45.3-23.1c-5.5-2.5-9.8-4.3-12.7-5.5c-1.4-.6-2.5-1-3.3-1.3l-.8-.3-.2-.1 0 0 0 0 0 0 0 0L99.6 35.3 138 19.8C169.5 7 204 0 240 0c61 0 117.4 20.1 162.8 54L424 32l56 56-22 21.2C491.9 154.6 512 211 512 272c0 36-7 70.5-19.8 102l-15.5 38.4-14.3-38.8 0 0 0 0zM310.1 201.9c8.7 8.7 16.8 17.4 24.5 26.2L40 512 0 472 283.8 177.4c8.8 7.7 17.6 15.8 26.2 24.5z"],
    "link-simple-slash": [640, 512, [], "e1ce", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7-87.5-68C578.2 363 608 313 608 256c0-88.4-71.6-160-160-160H384 352v64h32 64c53 0 96 43 96 96c0 42.9-28.2 79.3-67 91.5L400.3 288H416h32V224H416 317.9l-82.4-64H256h32V96H256 192c-11.8 0-23.2 1.3-34.3 3.7L48.4 14.8zM70.7 151.7C46.6 179.7 32 216.1 32 256c0 88.4 71.6 160 160 160h64 32V352H256 192c-53 0-96-43-96-96c0-24.9 9.5-47.6 25-64.6L70.7 151.7z"],
    "democrat": [640, 512, [], "f747", "M64 32C64 12.1 80 0 80 0l48 45.7L176 0s16 12.1 16 32c0 26.5-21.9 42-29.5 46.6L248 160H480l64 0h14.3l9.5 10.6 72 80-47.6 42.8-49.4-54.9L544 240v80H192L144 208 72 256 0 184 87.6 74.6C78.1 67.4 64 53.2 64 32zM448 352h96v64 96H448V416H288v96H192V416 352h96H448zM269.3 234.7L256.1 208 243 234.7l-30.2 3.9 22.1 20.4L229.4 288l26.8-14.1L282.9 288l-5.5-29.1 22.1-20.4-30.2-3.9zM368.1 208L355 234.7l-30.2 3.9 22.1 20.4L341.4 288l26.8-14.1L394.9 288l-5.5-29.1 22.1-20.4-30.2-3.9L368.1 208zm125.1 26.7L480.1 208 467 234.7l-30.2 3.9 22.1 20.4L453.4 288l26.8-14.1L506.9 288l-5.5-29.1 22.1-20.4-30.2-3.9z"],
    "face-confused": [512, 512, [], "e36d", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM171.1 395.6l-1.1 .9-12.5 10-20-25 12.5-10 1.1-.9C205 327.5 272 304 341 304h11 16v32H352 341c-61.8 0-121.7 21-169.9 59.6zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "pinball": [448, 512, [], "e229", "M352 224a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM34.3 361.6c9.2 7.7 19.9 13.8 32 17.7l307.8 99.1 29.6-55.7-246-208.3c-40.6-34.1-101.2-28.8-135.2 11.8S-6.3 327.5 34.3 361.6zM64 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "z": [384, 512, [122], "5a", "M384 32V75.6l-7.4 8.9L100.3 416H352h32v64H352 32 0V436.4l7.4-8.9L283.7 96H32 0V32H32 352h32z"],
    "person-skiing": [512, 512, [9975, "skiing"], "f7c9", "M380.7 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM13.8 247.6l21.3 11.1L232.7 361.3l46.2-69.2-76.5-76.5c-14.4-14.4-20.2-33.4-18.4-51.5l110.2 52.7 48.6 48.6 18.6 18.6-14.6 21.8L289.8 391l126.4 65.6 37.1-18.5 21.5-10.7 21.5 42.9L474.7 481l-48 24-10.9 5.5-10.9-5.6L12.9 301.3-8.4 290.2l22.1-42.6zM118.9 65.6L137 74.2l8.7-17.4 7.2-14.3 28.6 14.3-7.2 14.3-8.5 16.9 52.6 25.2c1-.5 2.1-1 3.2-1.5L323 66.8l26.2-11.6 14.4 24.8 51.7 88.6 48.6 27.7 27.8 15.9-31.8 55.6-27.8-15.9-56-32-7.4-4.3-4.3-7.4L346.8 178l-28.3 12.6-6.8 3-6.7-3.2L151.5 116.7l-9.2 18.4-7.2 14.3-28.6-14.3 7.2-14.3 9-18-17.6-8.4L90.7 87.5l13.8-28.8 14.4 6.9z"],
    "deer": [512, 512, [129420], "f78e", "M256 0V16 40c0 13.3 10.7 24 24 24h16c13.3 0 24-10.7 24-24V16 0h32V16 40c0 8.6-1.9 16.7-5.4 24h30.6H416c13.3 0 24-10.7 24-24V16 0h32V16 40c0 21.7-12.3 40.4-30.3 49.8c.6 .5 1.1 1.1 1.7 1.6L512 160v64H416h-5.3L384 304v64V512H288V368H240l-64-27.4V344v19.9l-14.1 14.1-26.6 26.6L173.3 512H71.5L34.7 408 24.7 379.4l21.4-21.4L72.1 332 56 315.9c-3-3-5.7-6.1-8.1-9.5l-1.8 23.3-47.9-3.7L.1 302.2 2.4 272c4.2-54.2 49.3-96 103.7-96h7.9H128h96 78.4l9.6-32H256V112l64-16H296 280c-30.9 0-56-25.1-56-56V16 0h32zM400 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "input-pipe": [640, 512, [], "e1be", "M64 128V384H576V128H64zM0 64H64 576h64v64V384v64H576 64 0V384 128 64zM144 184V328v24H96V328 184 160h48v24z"],
    "road-lock": [640, 512, [], "e567", "M288 32H160L32 480H288V416 384h64v32 64h32l0-192h32V272c0-58.1 44.2-105.8 100.7-111.4L480 32H352V96v32H288V96 32zm64 192v64 32H288V288 224 192h64v32zm176 16c17.7 0 32 14.3 32 32v48H496V272c0-17.7 14.3-32 32-32zm-80 32v48H416V512H640V320H608V272c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "a": [384, 512, [97], "41", "M169.9 32h44.2l7.8 20.6 109.3 288L384.2 480H315.7l-36.4-96H104.7L68.3 480H-.2L52.7 340.6l109.3-288L169.9 32zm85 288L192 154.2 129 320H255z"],
    "bookmark-slash": [640, 512, [], "e0c2", "M128 512V196.9L512 499.4V512L320 400 128 512zM512 374.7l108.9 84.6 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L128 76.6V0H512V374.7z"],
    "temperature-arrow-down": [576, 512, ["temperature-down"], "e03f", "M113.8 317.8L128 300.1V277.5 64h96V277.5v22.7l14.2 17.6C249.4 331.5 256 348.9 256 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-19.1 6.6-36.5 17.8-50.3zM288 0H224 128 64V64 277.5C44 302.2 32 333.7 32 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5V64 0zM176 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V272 256H160v16 50.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48zm368-64H480l0-288V32H416V64l0 288H352v32l96 96 96-96V352z"],
    "mace": [512, 512, [], "f6f8", "M328.3 94.1c42.7 13.2 76.4 46.9 89.6 89.6L512 224l-94.1 40.3c-13.2 42.7-46.9 76.4-89.6 89.6L288 448l-40.3-94.1c-10.8-3.4-21.1-8-30.5-13.8L70.6 486.6 48 509.3 2.7 464l22.6-22.6L171.9 294.9c-5.8-9.5-10.5-19.7-13.8-30.5L64 224l94.1-40.3c13.2-42.7 46.9-76.4 89.6-89.6L288 0l40.3 94.1zM288 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "feather-pointed": [512, 512, ["feather-alt"], "f56b", "M137.4 131.6C228.5 40.5 428.3 6.9 512 0c-4.4 53.7-19.8 155.2-54.4 245.1L368 272v16l71.1 0c-8.2 16.9-17.2 32.9-27.1 47.6L304 368v16l66.4 0c-61.9 54.9-164.4 88.3-238 45.5L73 489l-17 17L22.1 472l17-17L287.2 206.8l-22.3-22.3-11.3 11.3L78.1 371.3c-37.9-77 1.1-181.5 59.3-239.7z"],
    "sausage": [512, 512, [], "f820", "M320 160c0-42.1 27.1-77.8 64.7-90.8L360 0H472L447.3 69.2c37.7 13 64.7 48.7 64.7 90.8c0 194.4-157.6 352-352 352c-42.1 0-77.8-27.1-90.8-64.7L0 472V360l69.2 24.7c13-37.7 48.7-64.7 90.8-64.7c88.4 0 160-71.6 160-160zM160 400c132.5 0 240-107.5 240-240H368c0 114.9-93.1 208-208 208v32z"],
    "trash-can-clock": [576, 512, [], "e2aa", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM32 128H416v64.7c-29.3 2.6-56.6 12.5-80 27.7V208c0-8.8-7.2-16-16-16s-16 7.2-16 16v39.2c-29.8 31.5-48 74-48 120.8c0 59.5 29.6 112.1 74.8 144H96c-35.3 0-64-28.7-64-64V128zm96 64c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm64 176a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm160-80H416v16 64 16h16 48 16V352H480 448V304 288z"],
    "p": [320, 512, [112], "50", "M64 288h96c53 0 96-43 96-96s-43-96-96-96H64V288zM0 352V320 288 96 64 32H32 64h96c88.4 0 160 71.6 160 160s-71.6 160-160 160H64v96 32H0V448 352z"],
    "broom-wide": [512, 512, [], "e5d1", "M328 136L464 0l48 48L376 184l40 40-37.8 61.9L226.1 133.8 288 96l40 40zM191 155.3L356.7 321 240 512 108 380l20-60L68 340 0 272 191 155.3z"],
    "snowflake": [448, 512, [10052, 10054], "f2dc", "M256 32V0H192V32 62.1l-8.6-8.6-17-17L132.5 70.4l17 17L192 129.9v70.6l-61.2-35.3-15.6-58.2L109 83.9 62.7 96.3l6.2 23.2L72 131.3l-12.2-7-27.7-16L.2 163.7l27.7 16 12.2 7-11.8 3.2L5.1 196.1l12.4 46.4 23.2-6.2 58.2-15.6L160 256 98.8 291.3 40.7 275.7l-23.2-6.2L5.1 315.9l23.2 6.2L40 325.3l-12.2 7L.2 348.3l32 55.4 27.7-16 12.2-7-3.2 11.8-6.2 23.2L109 428.1l6.2-23.2 15.6-58.2L192 311.4v70.6l-42.6 42.6-17 17 33.9 33.9 17-17 8.6-8.6V480v32h64V480 449.9l8.6 8.6 17 17 33.9-33.9-17-17L256 382.1V311.4l61.2 35.3 15.6 58.2 6.2 23.2 46.4-12.4-6.2-23.2L376 380.7l12.2 7 27.7 16 32-55.4-27.7-16-12.2-7 11.8-3.2 23.2-6.2-12.4-46.4-23.2 6.2-58.2 15.6L288 256l61.2-35.3 58.2 15.6 23.2 6.2 12.4-46.4-23.2-6.2L408 186.7l12.2-7 27.7-16-32-55.4-27.7 16-12.2 7 3.2-11.8 6.2-23.2L339 83.9l-6.2 23.2-15.6 58.2L256 200.6V129.9l42.6-42.6 17-17L281.6 36.5l-17 17L256 62.1V32z"],
    "stomach": [512, 512, [], "f623", "M192 32V0H128V32 192v32h32 96v64c0 35.3-28.7 64-64 64H32 0v32 16 80 32H64V480 432h48c24.6 0 36 9.5 58.2 28.2l0 0c1.7 1.4 3.4 2.9 5.3 4.4c12.6 10.5 28.4 22.9 49.6 32.2C246.5 506.2 272 512 304 512c114.9 0 208-93.1 208-208V224c0-70.7-57.3-128-128-128c-47.4 0-88.7 25.7-110.9 64H192V32zM445.1 332.7c-7.2 1.9-14.6 3.3-21.1 3.3c-16.8 .2-28.4-7.9-40-16s-23.2-16.3-40-16c-7.9 .1-17.1 2.1-25.6 4.6c1.1-6.7 1.6-13.6 1.6-20.6V224c0-35.3 28.7-64 64-64s64 28.7 64 64v80c0 9.8-1 19.4-2.9 28.7z"],
    "newspaper": [512, 512, [128240], "f1ea", "M96 32h32H480h32V64 448v32H480 160 128 80 32 0V448 128 96H64v32V416H80 96V64 32zm64 64V224H320V96H160zm224 0v32h16 32 16V96H432 400 384zm0 96v32h16 32 16V192H432 400 384zM160 288v32h16H432h16V288H432 176 160zm0 96v32h16H432h16V384H432 176 160z"],
    "rectangle-ad": [576, 512, ["ad"], "f641", "M576 32H0V480H576V32zM368 280a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm24-72c8.4 0 16.5 1.4 24 4.1V184 160h48v24 96 48 24H416v-4.1c-7.5 2.7-15.6 4.1-24 4.1c-39.8 0-72-32.2-72-72s32.2-72 72-72zM192.3 160H208h4 16.1l6.1 14.8L307.4 352H255.4l-9.9-24h-74l-10.4 24H108.8L186 174.4l6.3-14.4zm.2 120h33.3l-16.2-39.2L192.4 280z"],
    "guitar-electric": [512, 512, [127928], "f8be", "M352 64v50.7L244.9 221.9c-21.9-40.6 14.1-76.5 14.1-76.5l-23.8-23.8-40.7 40.7c-9.4 9.4-15.4 21.8-21.2 34c-1.6 3.4-3.2 6.7-4.9 10c-3.5 6.9-8.7 14.6-16.4 22.3c-24.9 24.9-65.2 40-90.3 47.6c-14.6 4.4-28.3 11.6-39 22.4c-30.3 30.3-30.3 79.3 0 109.6l80.5 81.3C118.8 505 139.5 512.5 160 512c19.2-.5 38.2-8.1 52.8-22.7c10.8-10.8 18-24.5 22.4-39c7.5-25.1 22.7-66.2 47.6-91.2c7.7-7.7 15.4-12.9 22.3-16.4c3.3-1.7 6.6-3.3 10-4.9c12.2-5.8 24.6-11.8 34-21.2l28.8-28.8L354 264.1s-26.5 26.5-64.2 3.4L444.6 112.6c16.1 4.8 34.1 .7 46.5-11.7c19.7-19.7 17.9-52.1-3.8-69.5L448 0 352 64zM195.3 268.7l48 48L254.6 328 232 350.6l-11.3-11.3-48-48L161.4 280 184 257.4l11.3 11.3zm-64 64l48 48L190.6 392 168 414.6l-11.3-11.3-48-48L97.4 344 120 321.4l11.3 11.3z"],
    "arrow-turn-down-right": [512, 512, [], "e3d6", "M64 64V32H0V64 288v32H32 386.7l-73.4 73.4L290.7 416 336 461.3l22.6-22.6 128-128L509.3 288l-22.6-22.6-128-128L336 114.7 290.7 160l22.6 22.6L386.7 256H64V64z"],
    "moon-cloud": [640, 512, [], "f754", "M543.6 41.2c-82.8 21.2-144 96.5-144 186c0 106 85.8 192 191.5 192c16.8 0 33.1-2.2 48.6-6.2c-40.6 41.4-97.2 67-159.8 67c-47.6 0-91.7-14.8-128-40.1V344c0-54.6-42-99.3-95.5-103.7C264.6 123.9 361.5 32 480 32c22.1 0 43.5 3.2 63.6 9.2zM64 416H0V352c0-35.3 28.7-64 64-64c.5 0 1.1 0 1.6 0c7.4-36.5 39.7-64 78.4-64c35 0 64.8 22.5 75.6 53.8c8.7-3.7 18.3-5.8 28.4-5.8c39.8 0 72 32.2 72 72c0 2.7-.1 5.4-.4 8h.4v64H248 64z"],
    "bread-slice-butter": [512, 512, [], "e3e1", "M0 192C0 64 192 32 256 32s256 32 256 160c0 35.3-28.7 64-64 64V480H64V256c-35.3 0-64-28.7-64-64zM256 376l88-88-88-88-88 88 88 88z"],
    "circle-arrow-right": [512, 512, ["arrow-circle-right"], "f0a9", "M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm393 17L281 385l-17 17L230.1 368l17-17 71-71L136 280l-24 0 0-48 24 0 182.1 0-71-71-17-17L264 110.1l17 17L393 239l17 17-17 17z"],
    "user-group-crown": [640, 512, ["users-crown"], "f6a5", "M96 0V53.7 144c0 70.7 57.3 128 128 128s128-57.3 128-128V53.7 0L304 24l-16 8L224 0 160 32l-16-8L96 0zm48 144V128H304v16c0 44.2-35.8 80-80 80s-80-35.8-80-80zM448 512L384 304H64L0 512H448zm192 0L576 320H422.4l56.2 182.6 2.9 9.4H640zM432 256c61.9 0 112-50.1 112-112s-50.1-112-112-112c-17.2 0-33.5 3.9-48 10.8V53.7 144c0 31.4-9 60.6-24.6 85.3C379 245.9 404.3 256 432 256z"],
    "circle-i": [512, 512, [], "e111", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128h72 72 24v48H328 280V336h48 24v48H328 280 232 184 160V336h24 48V176H184 160V128h24z"],
    "toilet-paper-check": [640, 512, [], "e5b2", "M384 192c0-65.5 13.2-142.4 60.2-192H160C107 0 64 86 64 192c0 89.9-3.9 190.6-37.6 275.8L8 512H333.3C376 409.7 384 301.9 384 192zM512 384c53 0 96-86 96-192S565 0 512 0s-96 86-96 192s43 192 96 192zm0-128c-17.7 0-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64zM291.3 187.3l-72 72L208 270.6l-11.3-11.3-40-40L145.4 208 168 185.4l11.3 11.3L208 225.4l60.7-60.7L280 153.4 302.6 176l-11.3 11.3z"],
    "filter-circle-xmark": [576, 512, [], "e17b", "M192 384V288L0 64V0H512V64L399.8 194.9C318 210.1 256 281.8 256 368c0 27.8 6.4 54.1 17.9 77.4L192 384zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3L502.6 320 480 297.4l-11.3 11.3L432 345.4l-36.7-36.7L384 297.4 361.4 320l11.3 11.3L409.4 368l-36.7 36.7L361.4 416 384 438.6l11.3-11.3L432 390.6l36.7 36.7L480 438.6 502.6 416l-11.3-11.3L454.6 368l36.7-36.7z"],
    "locust": [576, 512, [], "e520", "M288 32h24 48c116.6 0 211.6 92.4 215.9 208h.1v7.3l0 .7v72l0 .3c-.2 44.1-35.9 79.7-80 79.7H483.6l45.7 80H474.1l-45.7-80H348l-55.4 80H234.2l55.4-80h-53l-59.8 80H116.9l65-86.9-41.2-15.7L59.6 480H-1.5L269.2 137.1l25-31.7 15.9 37.1 21.5 50.2 41.2-55.1 24.9-33.3 16.4 38.2L455.8 240h72C523.6 150.9 450.1 80 360 80H312 288V32zM403.6 240l-17.3-40.3L356.2 240h47.4zm-107.3 0l2.1-2.8-16.6-38.6L249.1 240h47.2zM32 240H150.7L64.1 348.2 32 336V240zm464 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "sort": [320, 512, ["unsorted"], "f0dc", "M160 32L0 176v48H320V176L160 32zm0 448L320 336V288H0v48L160 480z"],
    "list-ol": [512, 512, ["list-1-2", "list-numeric"], "f0cb", "M32 32H56 80h24V56 176h8 24v48H112h-8H56 48 24V176H48h8V80H32V32zM8 352c0-35.3 28.7-64 64-64H89.2c34.7 0 62.8 28.1 62.8 62.8c0 17.7-7.5 34.6-20.5 46.5L93.4 432H128h24v48H128 32 8V456v-.6V444.8l7.8-7.1 83.3-75.9c3.1-2.8 4.8-6.8 4.8-11c0-8.2-6.6-14.8-14.8-14.8H72c-8.8 0-16 7.2-16 16H8zM224 64H480h32v64H480 224 192V64h32zm0 160H480h32v64H480 224 192V224h32zm0 160H480h32v64H480 224 192V384h32z"],
    "chart-waterfall": [512, 512, [], "e0eb", "M64 32V64 416H480h32v64H480 32 0V448 64 32H64zM192 224v32 64 32H128V320 256 224h64zm96-64v64 32H224V224 160 128h64v32zm96-96V96v64 32H320V160 96 64h64zm96 32V320v32H416V320 96 64h64V96z"],
    "sparkle": [448, 512, [], "e5d6", "M149.3 181.3L224 32l74.7 149.3L448 256 298.7 330.7 224 480 149.3 330.7 0 256l149.3-74.7z"],
    "face-party": [640, 512, [], "e383", "M54.3 144.7L35 93.5C49.7 67.8 67.7 44.3 88.5 23.6l45.8 12.2C99.7 65.1 72.1 102.3 54.3 144.7zm-1-130.5C41.5 27.2 30.7 41 20.9 55.6L0 0 53.3 14.2zM531.7 400C485.6 467.6 408 512 320 512C178.6 512 64 397.4 64 256S178.6 0 320 0C433.4 0 529.7 73.8 563.3 176H528 480v48 64 16H432 412.9c-1.2-2.3-2.6-4.4-4.2-6.3c-4.3-5.2-10.1-9.7-16.7-13.4C378.7 276.9 361.4 272 344 272l-3.9 15 0 0 0 0 0 0 0 0 .2 .1c.2 .1 .5 .3 .9 .5c.8 .5 2 1.2 3.4 2.1c2.8 1.9 6.5 4.5 10.2 7.6c3.7 3.1 7.2 6.6 9.6 10.1c2.5 3.5 3.5 6.4 3.5 8.6s-1 5-3.5 8.6c-2.5 3.5-5.9 6.9-9.6 10.1c-3.7 3.1-7.4 5.7-10.2 7.6c-1.4 .9-2.6 1.6-3.4 2.1c-.4 .2-.7 .4-.9 .5l-.2 .1 0 0 0 0 0 0 0 0V359l0 0 0 0 0 0 0 0 .2 .1c.2 .1 .5 .3 .9 .5c.8 .5 2 1.2 3.4 2.1c2.8 1.9 6.5 4.5 10.2 7.6c3.7 3.1 7.2 6.6 9.6 10.1c2.5 3.5 3.5 6.4 3.5 8.6s-1 5-3.5 8.6c-2.5 3.5-5.9 6.9-9.6 10.1c-3.7 3.1-7.4 5.7-10.2 7.6c-1.4 .9-2.6 1.6-3.4 2.1c-.4 .2-.7 .4-.9 .5l-.2 .1 0 0 0 0 0 0 0 0 3.9 15c17.4 0 34.7-4.9 47.9-12.3c6.6-3.7 12.5-8.2 16.7-13.4c1.6-2 3.1-4.1 4.2-6.3H432h99.7zM384 351.7V336h16H608V240H544v32h32 16v32H576 528 512V288 224 208h16 96 16v16V352v16H624 400 384V352.3l-.8-.3 .8-.3zM196.8 237.6c21.6-28.8 64.8-28.8 86.4 0l25.6-19.2c-34.4-45.9-103.2-45.9-137.6 0l25.6 19.2zm246.4 0l25.6-19.2c-34.4-45.9-103.2-45.9-137.6 0l25.6 19.2c21.6-28.8 64.8-28.8 86.4 0z"],
    "kidneys": [640, 512, [], "f5fb", "M152 0c-21.5 0-45.5 6.3-64.3 23.8C56.4 52.8 0 119.6 0 224c0 24.9 3.5 54.7 7.1 79.1c7.1 48 48.8 80.9 95.3 80.9c58.4 0 104-50.4 98.2-108.5l-7.3-72.7 39.2-44.1c15.2-17.1 23.5-39.1 23.5-61.9c0-31.2-15.6-60.2-41.5-77.5l-3.4-2.3C194.5 5.9 175.1 0 155.2 0H152zM488 0h-3.2c-19.9 0-39.4 5.9-55.9 16.9l-3.4 2.3C399.6 36.5 384 65.6 384 96.7c0 22.8 8.4 44.8 23.5 61.9l39.2 44.1-7.3 72.7C433.7 333.6 479.3 384 537.7 384c46.5 0 88.2-32.9 95.3-80.9c3.6-24.4 7.1-54.2 7.1-79.1c0-104.4-56.4-171.2-87.7-200.2C533.5 6.3 509.5 0 488 0zM226.5 213.5l3.6 36.3L256 262.8V488v24h48V488 248 233.2l-13.3-6.6-52.5-26.2-11.8 13.3zm187.1 0l-11.8-13.3-52.5 26.2L336 233.2V248 488v24h48V488 262.8l25.9-12.9 3.6-36.3z"],
    "wifi-exclamation": [640, 512, [], "e2cf", "M296 320h48L368 32H272l24 288zm24.2 32h-.3c-35.3 .1-63.8 28.7-63.8 64c0 35.3 28.7 64 64 64s64-28.7 64-64c0-35.3-28.6-63.9-63.8-64zm66-152.4l-5.4 64.7c32.8 9.2 62.5 25.7 87.4 47.7l42.4-48c-34.9-30.8-77.4-53.3-124.4-64.4zM259.3 264.3l-5.4-64.7c-46.9 11-89.4 33.5-124.4 64.4l42.4 48c24.9-21.9 54.6-38.4 87.4-47.7zm326.6-61.4l44.3-46.2C567.8 96.9 488.2 54.9 399.5 39l-5.3 64.1c73.6 14.4 139.6 49.8 191.7 99.7zm-340-99.7L240.5 39C151.8 54.9 72.2 96.9 9.8 156.7l44.3 46.2c52-49.9 118.1-85.4 191.7-99.7z"],
    "chart-network": [640, 512, [], "f78a", "M288 0H160V128h58.6l29.1 62.3C221.8 210.4 203 239 195.6 272H128V240H0V368H128V336h67.6c14.6 64.1 71.9 112 140.4 112c38.4 0 73.3-15 99.1-39.5L512 459.8V512H640V384H513.7l-43.1-28.7c6.1-15.9 9.4-33.2 9.4-51.3c0-20.3-4.2-39.7-11.8-57.2L542.8 192H640V64H512v71.3l-81.7 59.9C405 173.3 372.1 160 336 160c-10.4 0-20.6 1.1-30.4 3.2L288 125.5V0zm48 256a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "person-dress-burst": [640, 512, [], "e544", "M176 0L133.8 88.5 38.4 66.3l42.9 88.1L4.4 215.2 100 236.6l-.4 98L176 273.2l76.4 61.4-.4-98L312.8 223l15-23.5-57.1-45.1 42.9-88.1L218.2 88.5 176 0zM480 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H411.4l-9.4 14.8-81.7 128 53.9 34.4 42-65.8L368 384h40v96 32h64V480 384h16v96 32h64V480 384h40L543.8 239.4l42 65.8 53.9-34.4L558 142.8 548.6 128H531.1 428.9z"],
    "dice-d4": [512, 512, [], "f6d0", "M0 320L240 0V512L0 320zM272 0L512 320 272 512V0z"],
    "money-check-dollar": [576, 512, ["money-check-alt"], "f53d", "M576 64H0V448H576V64zM512 192v32H256V192H512zM256 288H512v32H256V288zM164 160v6.3c6.6 1.2 16.7 3.2 21.1 4.4l19.3 5.1-10.3 38.7-19.3-5.1c-3.8-1-17.4-3.7-21.7-4.3c-12.2-1.9-22.2-.3-28.6 2.6c-6.3 2.9-7.9 6.2-8.2 8.1c-.6 3.4 0 4.7 .1 5c.3 .5 1 1.8 3.6 3.5c6.1 4.2 15.7 7.2 29.9 11.4l.8 .2 0 0 0 0c12.1 3.7 28.3 8.5 40.4 17.4c6.7 4.9 13 11.4 16.9 20.5c4 9.1 4.8 19.1 3 29.4c-3.3 19-15.9 32-31.6 38.7c-4.9 2.1-10.1 3.6-15.4 4.6V352v20H124V352v-6.4c-9.5-2.2-22-6.4-29.9-9.1l0 0c-1.7-.6-3.2-1.1-4.4-1.5l-19-6.3 12.6-38 19 6.3c2 .7 4.2 1.4 6.4 2.1c9.5 3.2 20.2 6.9 26.2 7.9c12.8 2 22.7 .7 28.8-1.9c5.5-2.3 7.4-5.3 8-8.8c.7-4 .1-5.9-.2-6.7c-.4-.9-1.3-2.2-3.7-4c-5.9-4.3-15.3-7.5-29.3-11.7l-2.2-.7c-11.7-3.5-27-8.1-38.6-16c-6.6-4.5-13.2-10.7-17.3-19.5c-4.2-9-5.2-18.8-3.4-29c3.2-18.3 16.2-30.9 31.1-37.7c5-2.3 10.4-4 16-5.1v-6V140h40v20z"],
    "vector-square": [448, 512, [], "f5cb", "M400 80v32H368V80h32zM368 32H320V64H128V32H80 48 0V80v32 48H32V352H0v48 32 48H48 80h48V448H320v32h48 32 48V432 400 352H416V160h32V112 80 32H400 368zM96 160h32V128H320v32h32V352H320v32H128V352H96V160zM80 400v32H48V400H80zm288 0h32v32H368V400zM48 80H80v32H48V80z"],
    "bread-slice": [512, 512, [], "f7ec", "M256 32C192 32 0 64 0 192c0 35.3 28.7 64 64 64V480H448V256c35.3 0 64-28.7 64-64C512 64 320 32 256 32z"],
    "language": [640, 512, [], "f1ab", "M256 64H0V448H256h48 16H576h64V384 128 64H576 320 304 256zm320 64V384H320V128H576zM144.9 160h30.3l3.4 8.6 47.8 119.6c.1 .3 .2 .6 .3 .9l23.8 59.6 1.4 3.4H208.9l-14.4-36H125.5l-14.4 36H68.1l1.4-3.4L93.3 289c.1-.3 .2-.6 .4-.9l47.8-119.6 3.4-8.6zM160 229.9L141.5 276h36.9L160 229.9zM468 164H428v20 4H392 372v40h20 56 32.9l-22.7 50-20.1-20.1L424 243.7 395.7 272l14.1 14.1 12.4 12.4-23.2 11.6-17.9 8.9 17.9 35.8 17.9-8.9 38.2-19.1 30.6 18.3 17.2 10.3 20.6-34.3-17.1-10.3-15-9L524.9 228H540V188H520h-8H468v-4V164z"],
    "wheat-awn-slash": [640, 512, [], "e338", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L362.5 258.7l28.6-28.6 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l22.6-22.6L539.2 197c-5.2-5.2-10.6-9.8-16.4-13.9L553 153l17-17L536 102.1l-17 17-43.4 43.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L457 57l17-17L440 6.1 423 23 393.1 52.9c-3.7-5-7.8-9.8-12.4-14.3L358.1 16 335.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-22.6-22.6-22.6 22.6c-3.5 3.5-6.6 7.1-9.4 10.9L48.4 14.8zM293.8 327.5l-50.6-39.9-29.5 29.5c-3.4-27.3-15.5-53.8-36.5-74.8l-22.6-22.6-22.6 22.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L89.4 441.4 66.7 464 112 509.3l22.6-22.6 52.9-52.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l22.6-22.6-22.6-22.6c-21.8-21.8-49.6-34.1-78.1-36.9l36.3-36.3zM553 57l17-17L536 6.1 519 23 447 95l-17 17L464 145.9l17-17 72-72z"],
    "face-kiss-wink-heart": [512, 512, [128536, "kiss-wink-heart"], "f598", "M498 339.7c9.1-26.2 14-54.4 14-83.7C512 114.6 397.4 0 256 0S0 114.6 0 256S114.6 512 256 512c35.4 0 69.1-7.2 99.7-20.2c-4.8-5.5-8.5-12.2-10.4-19.7l-22.9-89.3c-10-39 11.8-80.9 51.8-92.1c37.2-10.4 73.8 10.1 87.5 44c12.7-1.6 25.1 .4 36.2 5zM296 332c0 6.9-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C258.7 443.1 241.4 448 224 448c-3.6 0-6.8-2.5-7.7-6s.6-7.2 3.8-9l0 0 0 0 0 0 0 0 .2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.6-.4-.3-.2-.2-.1 0 0 0 0 0 0c-2.5-1.4-4.1-4.1-4.1-7s1.6-5.6 4.1-7l0 0 0 0 0 0 0 0 0 0 .2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1 0 0 0 0 0 0c-3.2-1.8-4.7-5.5-3.8-9s4.1-6 7.7-6c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm194.8 57.6c-17.6-23.5-52.8-23.5-70.4 0c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4c30.4-40.5 91.2-40.5 121.6 0c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2zM434 352.3c-6-23.2-28.8-37-51.1-30.8s-35.4 30.1-29.5 53.4l22.9 89.3c2.2 8.7 11.2 13.9 19.8 11.4l84.9-23.8c22.2-6.2 35.4-30.1 29.5-53.4s-28.8-37-51.1-30.8l-20.2 5.6-5.4-21z"],
    "dagger": [384, 512, [], "f6cb", "M224 0V32v96h80 32 48v48c0 26.5-21.5 48-48 48c-20.9 0-38.7-13.4-45.3-32H192 93.3c-6.6 18.6-24.4 32-45.3 32c-26.5 0-48-21.5-48-48V128H48 80h80V32 0h64zM128 224H256V432l-64 80-64-80V224z"],
    "podium": [448, 512, [], "f680", "M288 0H192V24H168c-48.6 0-88 39.4-88 88v32H24 0v48H24 424h24V144H424 128V112c0-22.1 17.9-40 40-40h24V96h96c26.5 0 48-21.5 48-48s-21.5-48-48-48zM48 224L80 512H368l32-288H48z"],
    "memo-circle-check": [576, 512, [], "e1d9", "M384 0H0V512H330.8C285.6 480.1 256 427.5 256 368c0-80.6 54.1-148.5 128-169.4V0zM80 128H304h16v32H304 80 64V128H80zm0 96H240h16v32H240 80 64V224H80zm0 96h96 16v32H176 80 64V320H80zm496 48a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-65.4-32l-11.3 11.3-72 72L416 430.6l-11.3-11.3-40-40L353.4 368 376 345.4l11.3 11.3L416 385.4l60.7-60.7L488 313.4 510.6 336z"],
    "route-highway": [448, 512, [], "f61a", "M240.5 12.6L224 2.7l-16.5 9.9-4.7 2.8c-37.5 22.5-84 24.3-123.1 4.7l-1.4-.7L51.2 5.8l-15 26.3-32 56L-4.3 103l7.7 15.3 18.2 36.4C28.4 168.4 32 183.5 32 198.8c0 12.5-2.4 25-7.1 36.6L9.1 275C3.1 290.1 0 306.2 0 322.5c0 50 29.1 95.4 74.6 116.3l136.1 62.4 13.3 6.1 13.3-6.1 136.1-62.4c45.5-20.8 74.6-66.3 74.6-116.3c0-16.3-3.1-32.4-9.1-47.5l-15.8-39.5c-4.7-11.7-7.1-24.1-7.1-36.6c0-15.3 3.6-30.4 10.4-44.1l18.2-36.4 7.7-15.3-8.5-14.9-32-56-15-26.3L369.7 19.4l-1.4 .7c-39.1 19.6-85.6 17.8-123.1-4.7l-4.7-2.8zM95.9 192H352.1c-.1 2.3-.1 4.6-.1 6.8c0 20.7 3.9 41.2 11.6 60.4l15.8 39.5c3 7.5 4.6 15.6 4.6 23.7c0 25-14.6 47.7-37.3 58.1L224 436.8 101.3 380.5C78.6 370.1 64 347.4 64 322.5c0-8.1 1.6-16.2 4.6-23.7l15.8-39.5C92.1 240 96 219.5 96 198.8c0-2.3 0-4.6-.1-6.8z"],
    "down-to-line": [384, 512, ["arrow-alt-to-bottom"], "f34a", "M352 224L192 384 32 224l0-32 96 0 0-160H256l0 160 96 0 0 32zM32 416H352h32v64H352 32 0V416H32z"],
    "filter": [512, 512, [], "f0b0", "M192 416V320L0 96V32H512V96L320 320V512L192 416z"],
    "square-g": [448, 512, [], "e271", "M448 32H0V480H448V32zM144 256c0 44.2 35.8 80 80 80c35.8 0 66.1-23.5 76.3-56H248 224V232h24 80 24v24c0 70.7-57.3 128-128 128s-128-57.3-128-128s57.3-128 128-128c32.8 0 62.7 12.3 85.3 32.6l-32 35.8C263.2 183.7 244.5 176 224 176c-44.2 0-80 35.8-80 80z"],
    "circle-phone": [512, 512, ["phone-circle"], "e11b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM200 128l40 72-41.9 33.5c18.1 34.2 46.2 62.3 80.4 80.4L312 272l72 40-16 72H352c-123.7 0-224-100.3-224-224l0-16 72-16z"],
    "clipboard-prescription": [384, 512, [], "f5e8", "M192 0c-41.8 0-77.4 26.7-90.5 64H0V512H384V64H282.5C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM104 196h72c33.1 0 60 26.9 60 60c0 25.5-15.9 47.2-38.3 55.9l43 40.3 33.8-31 14.7-13.5 27 29.5-14.7 13.5L270 379.7l31.7 29.7 14.6 13.7-27.4 29.2-14.6-13.7-33.9-31.8-34.9 32-14.7 13.5-27-29.5 14.7-13.5 32.6-29.9-64.8-60.8-2.8-2.6H124v44 20H84V360 296 216 196h20zm55.1 79.7l.3 .3H176c11 0 20-9 20-20s-9-20-20-20H124v40h34.8l.3-.3z"],
    "user-nurse-hair": [448, 512, [], "e45d", "M96 48L224 0 352 48v80h-.3c.2 2.6 .3 5.3 .3 8v40c0 70.7-57.3 128-128 128s-128-57.3-128-128v0V136c0-2.7 .1-5.4 .3-8H96V48zm48 128c0 44.2 35.8 80 80 80s80-35.8 80-80V160H256l-16-16-32 32H144zM126.1 320L224 424l97.9-104H384l64 192H0L64 320h62.1zM208 64H184V96h24v24h32V96h24V64H240V40H208V64z"],
    "question": [320, 512, [10067, 10068, 61736], "3f", "M80 160c0-35.3 28.7-64 64-64h32c35.3 0 64 28.7 64 64v9.3c0 19.6-9 38.2-24.5 50.3l-75.3 59.2L128 288.4V304v48h64V319.6L255.1 270C286 245.7 304 208.6 304 169.3V160c0-70.7-57.3-128-128-128H144C73.3 32 16 89.3 16 160v16H80V160zM200 400H120v80h80V400z"],
    "file-signature": [576, 512, [], "f573", "M224 0H0V512H384V427l-1.7 1.7L262.2 445.9l-11.7 1.9-11.6 1.9-5.3-10.5L222.1 416H209.9l-11.6 23.2-4.4 8.8H184h-8H164.1l-3.4-11.4L144 381l-16.7 55.6L123.9 448H112 80 64V416H80h20.1l20.6-68.6 3.4-11.4H136h16 11.9l3.4 11.4 15.4 51.4 3-5.9 4.4-8.8H200h32 9.9l4.4 8.8 7.2 14.5L267 313.4l117-117V160H224V0zm32 0V128H384L256 0zM505 119.8l-41.3 41.3 71 71L576 190.8l-71-71zm-63.9 63.9L299.9 325 288 407.9 370.9 396 512.1 254.7l-71-71z"],
    "toggle-large-on": [576, 512, [], "e5b1", "M576 64H0V448H576V64zm-64 64V384H256V128H512z"],
    "up-down-left-right": [512, 512, ["arrows-alt"], "f0b2", "M160 96L256 0l96 96v32H288v96h96V160h32l96 96-96 96-32 0V288H288v96h64v32l-96 96-96-96V384h64V288H128v64H96L0 256l96-96h32v64h96V128H160V96z"],
    "dryer-heat": [448, 512, ["dryer-alt"], "f862", "M448 0H0V512H448V0zM224 160a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM64 88a24 24 0 1 1 48 0A24 24 0 1 1 64 88zM184 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM171.3 204.7l-22.6 22.6L177.4 256c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l28.7 28.7 22.6-22.6L190.6 352c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6l-28.7-28.7zM280 233.4l-28.7-28.7-22.6 22.6L257.4 256c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l28.7 28.7 22.6-22.6L270.6 352c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6z"],
    "house-chimney-user": [576, 512, [], "e065", "M511.8 287.6H576V240l-64-53.4V32H416v74.5L288.4 0 0 240v47.6H64.1V512H512.8l-1-224.4zM288 160a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm80 160l32 96H176l32-96H368z"],
    "hand-holding-heart": [576, 512, [], "f4be", "M148 74c0 20.1 8.2 39.4 22.7 53.3l103.4 99.5L288 240.2l13.9-13.3 103.4-99.5C419.8 113.4 428 94.1 428 74c0-40.9-33.1-74-74-74h-3c-19.9 0-39.1 7.7-53.4 21.5L288 30.7l-9.6-9.2C264.1 7.7 244.9 0 225 0h-3c-40.9 0-74 33.1-74 74zm-8 253L68.8 384H0V512H32 224 384h12.4l10.2-7 128-88 33-22.7-45.3-65.9-33 22.7-94.5 65H256V384h32 64 32V320H352 288 224 160 148.8l-8.8 7z"],
    "arrow-up-small-big": [576, 512, ["sort-size-up-alt"], "f88f", "M320 32V192H480V32H320zm0 224V480H544V256H320zM183.7 58.5L160 32.4l-23.7 26-80 88L34.8 170.2l47.4 43.1 21.5-23.7L128 162.8V448v32h64V448 162.8l24.3 26.8 21.5 23.7 47.4-43.1-21.5-23.7-80-88z"],
    "train-track": [576, 512, [], "e453", "M407.1 32H339.6l21.3 64H215.1l21.3-64H168.9L147.6 96H112 80v64h32 14.3l-21.3 64H72 40v64H72 83.6L62.3 352H32 0v64H32h8.9L19.6 480H87.1l21.3-64H467.6l21.3 64h67.5l-21.3-64H544h32V352H544 513.7l-21.3-64H504h32V224H504 471.1l-21.3-64H464h32V96H464 428.4L407.1 32zM382.3 160l21.3 64H172.4l21.3-64H382.3zm42.7 128l21.3 64H129.7l21.3-64H424.9z"],
    "puzzle-piece": [512, 512, [129513], "f12e", "M192 89.6c-19.1-8.3-32-23.8-32-41.6c0-26.5 28.7-48 64-48s64 21.5 64 48c0 17.8-12.9 33.3-32 41.6V128H384V256h38.4c8.3-19.1 23.8-32 41.6-32c26.5 0 48 28.7 48 64s-21.5 64-48 64c-17.8 0-33.3-12.9-41.6-32H384V512H256V473.6c19.1-8.3 32-23.8 32-41.6c0-26.5-28.7-48-64-48s-64 21.5-64 48c0 17.8 12.9 33.3 32 41.6V512H0V320H38.4c8.3 19.1 23.8 32 41.6 32c26.5 0 48-28.7 48-64s-21.5-64-48-64c-17.8 0-33.3 12.9-41.6 32H0V128H192V89.6z"],
    "money-check": [576, 512, [], "f53c", "M576 64H0V448H576V64zM288 224v32H96V224H288zm192 96v32H96V320H480zm0-160v96H352V160H480z"],
    "star-half-stroke": [640, 512, ["star-half-alt"], "f5c0", "M351.7 60l54.8 104 115.8 20 66.9 11.6-47.3 48.7L460 328.5l16.7 116.3 9.7 67.2-60.9-29.9L320.1 430.2 214.6 482.1 153.7 512l9.7-67.2 16.7-116.3L98.2 244.2 50.9 195.6 117.7 184l115.8-20L288.4 60 320.1 0l31.7 60zM320.1 367.8l24.7 12.1 71.1 35-11.3-78.4-3.9-27.3 19.2-19.7 55.2-56.8L397 219.1l-27.1-4.7L357 190.1l-37-70.1V367.8z"],
    "file-exclamation": [384, 512, [], "f31a", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM216 192v24V328v24H168V328 216 192h48zM168 384h48v48H168V384z"],
    "code": [640, 512, [], "f121", "M362.8 8l-9.4 30.6-128 416L216 485.2 277.2 504l9.4-30.6 128-416L424 26.8 362.8 8zm71.9 136l22.6 22.6L546.7 256l-89.4 89.4L434.7 368 480 413.3l22.6-22.6 112-112L637.3 256l-22.6-22.6-112-112L480 98.7 434.7 144zM160 98.7l-22.6 22.6-112 112L2.7 256l22.6 22.6 112 112L160 413.3 205.3 368l-22.6-22.6L93.3 256l89.4-89.4L205.3 144 160 98.7z"],
    "whiskey-glass": [512, 512, [129347, "glass-whiskey"], "f7a0", "M92.1 224L73.8 96H438.2L419.9 224H92.1zM64 480H448L502.9 96 512 32H447.4 64.6 0L9.1 96 64 480z"],
    "moon-stars": [512, 512, [], "f755", "M320 64L304 16 288 64 240 80l48 16 16 48 16-48 48-16L320 64zM440 200l-24-72-24 72-72 24 72 24 24 72 24-72 72-24-72-24zM128 288c0-72.5 48.2-133.7 114.2-153.4c-16-4.3-32.9-6.6-50.2-6.6C86 128 0 214 0 320S86 512 192 512c61.5 0 116.2-28.9 151.3-73.8c-17.2 6.4-35.9 9.8-55.3 9.8c-88.4 0-160-71.6-160-160z"],
    "building-circle-exclamation": [640, 512, [], "e4d3", "M384 0H0V512H144V384h96V512H384v-8.2c-39.1-32.3-64-81.1-64-135.8s24.9-103.5 64-135.8V0zM64 224h64v64H64V224zm160 0v64H160V224h64zm32 0h64v64H256V224zM128 96v64H64V96h64zm32 0h64v64H160V96zm160 0v64H256V96h64zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64H480V416h32v32zm0-176v16 80 16H480V368 288 272h32z"],
    "clothes-hanger": [640, 512, [], "e136", "M209.8 84.8C222.3 35 267.1 0 318.5 0H320c61.9 0 112 50.1 112 112v6.3c0 36.5-17.8 70.8-47.8 91.8l-8.3 5.8L626.3 389.7l13.7 9.5V416v64 32H608 32 0V480 416 399.3l13.7-9.5L301.6 189.8l.1-.1 45.8-32c12.8-9 20.5-23.7 20.5-39.3V112c0-26.5-21.5-48-48-48h-1.5c-22 0-41.2 15-46.6 36.4l-.9 3.4-7.8 31-62.1-15.5 7.8-31 .9-3.4zM320 255L64 432.7V448H576V432.7L320 255z"],
    "mobile-notch": [384, 512, ["mobile-iphone"], "e1ee", "M128 64V96H256V64h48V448H80V64h48zM80 0H16V64 448v64H80 304h64V448 64 0H304 80zm48 384v32h16 96 16V384H240 144 128z"],
    "magnifying-glass-chart": [512, 512, [], "e522", "M416 208c0 45.9-14.9 88.3-40 122.7L486.6 441.4 509.3 464 464 509.3l-22.6-22.6L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zm-312 8v64l0 24h48V280l0-64V192H104l0 24zm80-96V280l0 24h48l0-24V120 96l-48 0v24zm80 64v96 24h48V280 184 160l-48 0v24z"],
    "arrow-up-right-from-square": [512, 512, ["external-link"], "f08e", "M320 0H288V64h32 82.7L201.4 265.4 178.7 288 224 333.3l22.6-22.6L448 109.3V192v32h64V192 32 0H480 320zM32 32H0V64 480v32H32 456h32V480 352 320H424v32 96H64V96h96 32V32H160 32z"],
    "cubes-stacked": [448, 512, [], "e4e6", "M192 32V160H320V32H192zM165.8 159L55 223l64 110.9 110.9-64L165.8 159zM256 192V320H384V192H256zM448 480V352H320V480H448zM160 352V480H288V352H160zm-32 0H0V480H128V352z"],
    "images-user": [576, 512, [], "e1b9", "M96 32V384H576V32H96zM336 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM440 320H232l24-64H416l24 64zM48 120V96H0v24V456v24H24 456h24V432H456 48V120z"],
    "won-sign": [512, 512, [8361, "krw", "won"], "f159", "M56.6 224L3.2 32H69.7L123 224h57.8L220.9 56.5 226.8 32H252h8 25.2l5.9 24.5L331.2 224H389L442.3 32h66.4L455.4 224H480h32v64H480 437.7L390.8 456.6 384.3 480H360h-8H326.8l-5.9-24.5L280.8 288H231.2L191.1 455.5 185.2 480H160h-8H127.7l-6.5-23.4L74.3 288H32 0V224H32 56.6zm84.2 64L154 335.7 165.4 288H140.8zm105.8-64h18.9L256 184.7 246.6 224zm100 64L358 335.7 371.2 288H346.6z"],
    "image-polaroid-user": [448, 512, [], "e1b6", "M0 32H448V480H0V32zM64 96V352h56l24-64H304l24 64h56V96H64zm96 96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "virus-covid": [512, 512, [], "e4a8", "M320 48H296 280V81.6c30.7 4.2 58.8 16.3 82.3 34.1L386.1 92 374.8 80.6l-17-17 33.9-33.9 17 17L437 75l28.3 28.3 17 17-33.9 33.9-17-17L420 125.9l-23.8 23.8c17.9 23.5 29.9 51.7 34.1 82.3H464V216 192h48v24 40 40 24H464V296 280H430.4c-4.2 30.7-16.3 58.8-34.1 82.3L420 386.1l11.3-11.3 17-17 33.9 33.9-17 17L437 437l-28.3 28.3-17 17-33.9-33.9 17-17L386.1 420l-23.8-23.8c-23.5 17.9-51.7 29.9-82.3 34.1V464h16 24v48H296 256 216 192V464h24 16V430.4c-30.7-4.2-58.8-16.3-82.3-34.1L125.9 420l11.3 11.3 17 17-33.9 33.9-17-17L75 437 46.7 408.7l-17-17 33.9-33.9 17 17L92 386.1l23.8-23.8C97.9 338.8 85.8 310.7 81.6 280H48v16 24H0V296 256 216 192H48v24 16H81.6c4.2-30.7 16.3-58.8 34.1-82.3L92 125.9 80.6 137.2l-17 17L29.7 120.2l17-17L75 75l28.3-28.3 17-17 33.9 33.9-17 17L125.9 92l23.8 23.8c23.5-17.9 51.7-29.9 82.3-34.1V48H216 192V0h24 40 40 24V48zM240 224a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm64 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "square-ellipsis": [448, 512, [], "e26e", "M448 480l0-448L0 32 0 480l448 0zM160 224l0 64-64 0 0-64 64 0zm32 0l64 0 0 64-64 0 0-64zm160 0l0 64-64 0 0-64 64 0z"],
    "pie": [576, 512, [129383], "f705", "M544 240H531.3C497.7 137.8 401.4 64 288 64S78.3 137.8 44.7 240H32 0v64H32h9.2l63.9-30.4 6-2.9 6.3 2.3L200 303l82.5-30 5.5-2 5.5 2L376 303l82.5-30 6.3-2.3 6.1 2.9L534.8 304H544h32V240H544zM96 448H480l38.7-116.2-55.6-26.5L381.5 335l-5.5 2-5.5-2L288 305l-82.5 30-5.5 2-5.5-2-81.7-29.7L57.3 331.8 96 448zM206.3 151.2l-16 32-7.2 14.3-28.6-14.3 7.2-14.3 16-32 7.2-14.3 28.6 14.3-7.2 14.3zm192-14.3l16 32 7.2 14.3-28.6 14.3-7.2-14.3-16-32-7.2-14.3 28.6-14.3 7.2 14.3zM304 144v32 16H272V176 144 128h32v16z"],
    "chess-knight-piece": [320, 512, ["chess-knight-alt"], "f442", "M57.6 102.4L32 128V248l38.4 32L160 222.4v32L48 337.6V384H272l27.1-109.6c3.3-13.3 4.9-27 4.9-40.7C304 140 228 64 134.2 64H32V89.6l25.6 12.8zm19.2 54.4a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM0 477.4V512H320V477.4L276.1 416H43.9L0 477.4z"],
    "austral-sign": [448, 512, [], "e0a9", "M194.3 32H216h16 21.7l8 20.1L330.5 224H416h32v64H416 356.1l12.8 32H416h32v64H416 394.5l27.2 68.1L432.9 480H363.9l-1.6-4.1L325.5 384H122.5L85.7 475.9 84.1 480H15.1l11.2-27.9L53.5 384H32 0V320H32 79.1l12.8-32H32 0V224H32h85.5L186.3 52.1l8-20.1zM224 130.2L186.5 224h75.1L224 130.2zM148.1 320H299.9l-12.8-32H160.9l-12.8 32z"],
    "cloud-plus": [640, 512, [], "e35e", "M144 480H0V336c0-62.7 40.1-116 96-135.8V192c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96v36c55.2 14.2 96 64.3 96 124V480H512 144zm152-80h48V376 312h64 24V264H408 344V200 176H296v24 64H232 208v48h24 64v64 24z"],
    "f": [320, 512, [102], "46", "M32 32H0V64 224v32 32V448v32H64V448 288H224h32V224H224 64V96H288h32V32H288 32z"],
    "leaf": [512, 512, [], "f06c", "M272 96H376c50.2 0 92.7-33 106.9-78.6C501.5 58.8 512 106.2 512 156.6C512 317.1 405.1 447.3 273 448l-1 0c-81.7 0-150.4-55.7-170.2-131.2C68.7 347.5 48 391.3 48 440v16 24H0V456 440c0-75.1 38.3-141.2 96.4-179.9c0 0 0 0 0 0c17.1-11.4 36-20.4 56.1-26.6s41.4-9.5 63.5-9.5c0 0 0 0 0 0h72 16 16V192H304 216c-40.2 0-78.2 9.6-111.7 26.5C126.9 147.5 193.4 96 272 96v0z"],
    "bed-bunk": [576, 512, [], "f8f8", "M64 32V0H0V32 480v32H64V480 448H256 512v32 32h64V480 448 416 288 256 192 160 128 112C576 50.1 525.9 0 464 0H256 224V32v96H64V32zM512 256H256 224v32 96H64V192H256 512v64zM192 304a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM144 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "road": [576, 512, [128739], "f018", "M256 32H128L0 480H256V416 384h64v32 64H576L448 32H320V96v32H256V96 32zm64 192v64 32H256V288 224 192h64v32z"],
    "taxi": [512, 512, [128662, "cab"], "f1ba", "M352 0H160V64H120 97.3L89.8 85.4 41.3 224H0V432v80H96V432H416v80h96V432 224H470.7L422.2 85.4 414.7 64H392 352V0zm17.3 128l33.6 96H109.1l33.6-96H369.3zM96 288a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm288 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "person-circle-plus": [576, 512, [], "e541", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM91.4 128h17.5H211.1h17.5l9.4 14.8 66.4 104c-15.5 16.3-28 35.7-36.3 57l-2.3 1.4-33.8-53V480v32H168V480 352H152V480v32H88V480 252.2l-33.8 53L.2 270.8 82 142.8 91.4 128zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80V288H416v16 48H368 352v32h16 48v48 16h32V432 384h48 16V352H496 448V304z"],
    "chart-pie": [576, 512, ["pie-chart"], "f200", "M304 240V.6c5.3-.4 10.6-.6 16-.6C443.7 0 544 100.3 544 224c0 5.4-.2 10.7-.6 16H304zM32 272C32 144.8 130.9 40.8 256 32.5V288L425 457c-41.5 34.4-94.8 55-153 55C139.5 512 32 404.6 32 272zm288 16H575.5C571 355.9 538.3 416.1 489 457L320 288z"],
    "bolt-lightning": [384, 512, [], "e0b7", "M0 288L32 0H256L208 160H384v48L128 512l48-224H0z"],
    "clock-eight": [512, 512, [], "e345", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392V256v12.8L269.3 276l-96 64-20 13.3-26.6-39.9 20-13.3L232 243.2V120 96h48v24z"],
    "sack-xmark": [512, 512, [], "e56a", "M192 96H320L384 0H128l64 96zm128 32H192c-3.8 2.5-8.1 5.3-13 8.4l0 0 0 0C122.3 172.7 0 250.9 0 416v96H96 416h96V416c0-165.1-122.3-243.3-179-279.6c-4.8-3.1-9.2-5.9-13-8.4zM222.1 336l-55-55L201 247l55 55 55-55L345 281l-55 55 55 55L311 425l-55-55-55 55L167 391l55-55z"],
    "file-excel": [384, 512, [], "f1c3", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM97.7 240h56.8L192 299.1 229.5 240h56.8L220.4 344l65.9 104H229.5L192 388.9 154.5 448H97.7l65.9-104L97.7 240z"],
    "file-contract": [384, 512, [], "f56c", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM80 64h64 16V96H144 80 64V64H80zm0 64h64 16v32H144 80 64V128H80zm56 176h16 11.9l3.4 11.4 15.4 51.4 3-5.9 4.4-8.8H200h32 9.9l4.4 8.8L257.9 384H304h16v32H304 248h-9.9l-4.4-8.8L222.1 384H209.9l-11.6 23.2-4.4 8.8H184h-8H164.1l-3.4-11.4L144 349l-16.7 55.6L123.9 416H112 80 64V384H80h20.1l20.6-68.6 3.4-11.4H136z"],
    "fish-fins": [576, 512, [], "e4f2", "M224 64l13.5 53.9c-37.7 17.5-67.9 43.1-90.6 67.6L32 128 0 160l48 96L0 352l32 32 114.9-57.5c22.6 24.4 52.8 50 90.6 67.6L224 448l48 32 73.4-64.2C499.1 409.8 576 256 576 256s-76.9-153.8-230.6-159.8L272 32 224 64zM416 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-q": [512, 512, [], "e11e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-336c-44.2 0-80 35.8-80 80s35.8 80 80 80c13.9 0 26.9-3.5 38.3-9.7L238.1 256h61.5l28.3 35.3c5.3-10.7 8.2-22.6 8.2-35.3c0-44.2-35.8-80-80-80zm0 208c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 28.1-9 54-24.4 75.1L401.9 384H340.5l-15.9-19.9C304.7 376.7 281.2 384 256 384z"],
    "building-flag": [640, 512, [], "e4d5", "M384 0H0V512H144V384h96V512H384V0zM64 224h64v64H64V224zm160 0v64H160V224h64zm32 0h64v64H256V224zM128 96v64H64V96h64zm32 0h64v64H160V96zm160 0v64H256V96h64zM480 0H416V32 512h64V192H640V32H480V0z"],
    "face-grin-beam": [512, 512, [128516, "grin-beam"], "f582", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm.3-180.2c59.1 0 114.1-10.6 160.2-29C400.3 376.7 334.7 432 256.3 432s-144-55.3-160.2-129.2c46.2 18.3 101.2 29 160.2 29zM176 152c28 0 56 40 56 80c0 0-28-32-56-32s-56 32-56 32c0-40 28-80 56-80zm104 80c0-40 28-80 56-80s56 40 56 80c0 0-28-32-56-32s-56 32-56 32z"],
    "object-ungroup": [640, 512, [], "f248", "M128 0H0V128H32v96H0V352H128V320H320v32H448V224H416V128h32V0H320V32H128V0zM352 224v32H320 128 96V224 128 96h32H320h32v32 96zM320 512V480H512v32H640V384H608V288h32V160H512v32H480v64h32 32v32 96 32H512 480 320 288V384 352H224v32H192V512H320z"],
    "face-disguise": [512, 512, [], "e370", "M256 512c141.4 0 256-114.6 256-256c0-16.4-1.5-32.5-4.5-48H440c0 49.4-37.4 90.1-85.4 95.4l4.5 2.3 8.8 4.4V320v32 9.9l-8.8 4.4-14.3 7.1L364.5 398l10 12.5-25 20-10-12.5-23.9-29.9-7.3 3.6 10.5 26.3 5.9 14.9-29.7 11.9-5.9-14.9-9.5-23.9-7.6 3.8V432v16H240V432 409.9l-7.6-3.8-9.5 23.9-5.9 14.9-29.7-11.9 5.9-14.9 10.5-26.3-7.3-3.6L172.5 418l-10 12.5-25-20 10-12.5 19.6-24.5-14.3-7.1-8.8-4.4V352 320v-9.9l8.8-4.4 4.5-2.3c-48-5.3-85.4-46-85.4-95.4H4.5C1.5 223.5 0 239.6 0 256C0 397.4 114.6 512 256 512zm55.1-249.3c2.9 1.8 5.4 3.2 6.8 3.8c7.9 3.5 16.8 5.5 26.1 5.5c35.3 0 64-28.7 64-64s-28.7-64-64-64s-64 28.7-64 64c0 4.4 .4 8.7 1.3 12.8l29.6 42.3 .2-.4zM232 208c0-35.3-28.7-64-64-64s-64 28.7-64 64s28.7 64 64 64c9.3 0 18.1-2 26.1-5.5c1.4-.6 3.9-2 6.8-3.8l.2 .4 29.6-42.3c.8-4.1 1.3-8.4 1.3-12.8zM12.7 176H77.5c5.3-14.9 14.1-28 25.4-38.5l-5.2-10.3-7.2-14.3 28.6-14.3 7.2 14.3 3.5 7c4.6-2 9.3-3.6 14.2-4.9V96 80h32V96v16.3c4.4 .4 8.7 1 13 2l4.7-9.5 7.2-14.3 28.6 14.3-7.2 14.3-3.6 7.3c16.4 10.2 29.5 25.3 37.3 43.1c7.8-17.9 20.9-32.9 37.3-43.1l-3.6-7.3-7.2-14.3 28.6-14.3 7.2 14.3 4.7 9.5c4.2-.9 8.6-1.6 13-2V96 80h32V96v19c4.9 1.3 9.6 2.9 14.2 4.9l3.5-7 7.2-14.3 28.6 14.3-7.2 14.3-5.2 10.3c11.3 10.5 20.1 23.7 25.4 38.5h64.7C465.7 73.8 369.4 0 256 0S46.3 73.8 12.7 176zM256 240.5l-50.9 72.7-2.3 3.3-3.6 1.8L176 329.9v12.2l80 40 80-40V329.9l-23.2-11.6-3.6-1.8-2.3-3.3L256 240.5zM144 216a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm200-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "circle-arrow-down-right": [512, 512, [], "e0fa", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zm88 368H192 168V320h24 94.1L151 185l-17-17L168 134.1l17 17 135 135V184 160h48v24V344v24H344z"],
    "alien-8bit": [640, 512, [128126, "alien-monster"], "f8f6", "M128 32h64V64h64v64H384V64h64V32h64V96H448v32 32h64v64h32V128h64V288H544v96H480v96H416 352V416h64V384H224v32h64v64H224 160V384H96V288H32V128H96v96h32V160h64V128 96H128V32zm64 288h64V224H192v96zm192 0h64V224H384v96z"],
    "hand-point-ribbon": [448, 512, [], "e1a6", "M64 0h64V32h32v96H0L43.6 80 0 32H64V0zm96 128v32 80h64V128H160zM64 160h64v80H64V160zm192 0h64V288H256V160zm96 32h64V320H352V192zM32 363V272H224v48 32H128 112v32h16H240h16V368 320h64v32h96c0 88.4-71.6 160-160 160H194.3c-42.4 0-83.1-16.9-113.1-46.9L69.5 453.5C45.5 429.5 32 396.9 32 363z"],
    "poop": [512, 512, [], "f619", "M176 128c44.2 0 80-35.8 80-80c0-17.5-5.6-33.7-15.1-46.8C245.8 .4 250.9 0 256 0c53 0 96 43 96 96c0 11.2-1.9 22-5.5 32H352c35.3 0 64 28.7 64 64c0 19.1-8.4 36.3-21.7 48H408c39.8 0 72 32.2 72 72c0 25.6-13.4 48.2-33.6 60.9C484.5 385.6 512 421.6 512 464v48H0V464c0-42.4 27.5-78.4 65.6-91.1C45.4 360.2 32 337.6 32 312c0-39.8 32.2-72 72-72h13.7C104.4 228.3 96 211.1 96 192c0-35.3 28.7-64 64-64h5.5H176z"],
    "object-exclude": [512, 512, [], "e49c", "M0 0H352V160H512V512H160V352H0V0zM320 192H192V320H320V192z"],
    "telescope": [576, 512, [128301], "e03e", "M476 277.7l97-56L445 0 348 56 476 277.7zM336.3 99.7c-1-1.8-2-3.6-2.8-5.4L36.7 284.9l19.2 33.3L0 350.5l49.9 86.4 55.9-32.3 16.3 28.2 115.7-62.1L180.3 512h51.8L304 335.6 375.9 512h51.8L346.4 312.5l86.1-46.2-.2-.3-96-166.3z"],
    "location-pin": [384, 512, ["map-marker"], "f041", "M384 192c0 112-192 320-192 320S0 304 0 192C0 86 86 0 192 0S384 86 384 192z"],
    "square-list": [448, 512, [], "e489", "M0 32H448V480H0V32zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32-128a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-248H168v48h24H352h24V136H352 192zm0 96H168v48h24H352h24V232H352 192zm0 96H168v48h24H352h24V328H352 192z"],
    "kaaba": [576, 512, [128331], "f66b", "M288 0L0 96v32 15.1 .9l288 96 288-96v-.9V128 96L288 0zm0 189.4L79.8 120 288 50.6 496.2 120 288 189.4zM0 176.9v46.3l5.1 1.7L64 244.5v33.7L0 256.9V416l288 96 288-96V256.9l-64 21.3V244.5l58.9-19.6 5.1-1.7V176.9L293.1 271.2l-5.1 1.7-5.1-1.7L0 176.9zm96 112V255.1l96 32v33.7l-96-32zm128 42.7V297.8l64 21.3 64-21.3v33.7l-58.9 19.6-5.1 1.7-5.1-1.7L224 331.5zm160-44.4l96-32v33.7l-96 32V287.1z"],
    "toilet-paper": [640, 512, [129531], "f71e", "M384 192c0-65.5 13.2-142.4 60.2-192H160C107 0 64 86 64 192c0 89.9-3.9 190.6-37.6 275.8L8 512H333.3C376 409.7 384 301.9 384 192zM512 384c53 0 96-86 96-192S565 0 512 0s-96 86-96 192s43 192 96 192zm0-128c-17.7 0-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64zM112 208a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "helmet-safety": [576, 512, ["hard-hat", "hat-hard"], "f807", "M352 32H224V66.3 176L159.6 85.8C84.1 121.8 32 198.8 32 288v64H544l0-66.4c-.9-88.1-52.8-164.1-127.5-199.8L352 176V66.3 32zM0 408s80 72 288 72s288-72 288-72V384H0v24z"],
    "comment-code": [512, 512, [], "e147", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM217 193l17-17L200 142.1l-17 17-64 64-17 17 17 17 64 64 17 17L233.9 304l-17-17-47-47 47-47zM329 159l-17-17L278.1 176l17 17 47 47-47 47-17 17L312 337.9l17-17 64-64 17-17-17-17-64-64z"],
    "sim-cards": [448, 512, [], "e251", "M128 0H96V32 384v32h32H416h32V384 128 114.7l-9.4-9.4-96-96L333.3 0H320 128zm80 144v48H160V144h48zm-48 80h64 96 64v48H320 224 160V224zm224-32H336V144h48v48zm-80-48v48H240V144h64zm80 160v48H336V304h48zm-80 48H240V304h64v48zm-96 0H160V304h48v48zM48 120V96H0v24V488v24H24 360h24V464H360 48V120z"],
    "starship": [640, 512, [], "e039", "M448 192a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 256a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm32-192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM188.9 205.4L137 160h71 32V96H208 32 0v64H32 64.1l65.5 57.3L96 224v64l33.6 6.7L64.1 352H32 0v64H32 208h32V352H208 137l51.9-45.4 43 8.6c-5.2-18.9-7.9-38.7-7.9-59.2s2.7-40.3 7.9-59.2l-43 8.6z"],
    "eject": [448, 512, [9167], "f052", "M0 320V272L224 32 448 272v48H0zM448 480H0V384H448v96z"],
    "circle-right": [512, 512, [61838, "arrow-alt-circle-right"], "f35a", "M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM256 384l0-80-128 0 0-96 128 0 0-80 32 0L416 256 288 384l-32 0z"],
    "plane-circle-check": [640, 512, [], "e555", "M192 93.7C192 59.5 221 0 256 0c36 0 64 59.5 64 93.7l0 66.3 85.5 57C354.3 247.8 320 303.9 320 368c0 54.7 24.9 103.5 64 135.8V512L256 480 128 512V448l64-48V320L0 384V288L192 160V93.7zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm222.6-32L552 313.4l-11.3 11.3L480 385.4l-28.7-28.7L440 345.4 417.4 368l11.3 11.3 40 40L480 430.6l11.3-11.3 72-72L574.6 336z"],
    "seal": [512, 512, [], "e241", "M331 75L256 0 181 75H75V181L0 256l75 75V437H181l75 75 75-75H437V331l75-75-75-75V75H331z"],
    "user-cowboy": [448, 512, [], "f8ea", "M160 0L110 112.4c27.2 8.7 64.7 15.6 114 15.6s86.8-6.9 114-15.6L288 0 224 32 160 0zM83.8 137.1c-32.4-12.7-49.4-27.2-55-34.7L.8 117.1c9.3 27.9 35 62.4 72.5 89.9c7.1 5.2 14.7 10.1 22.7 14.8c0 .8 0 1.5 0 2.3c0 70.7 57.3 128 128 128s128-57.3 128-128c0-.8 0-1.5 0-2.3c8-4.6 15.6-9.6 22.7-14.8c37.6-27.4 63.2-62 72.5-89.9l-28-14.7c-5.6 7.5-22.7 22-55 34.7C332.2 149.6 286.2 160 224 160s-108.2-10.4-140.2-22.9zM400 384H48L0 512H448L400 384z"],
    "hexagon-vertical-nft": [448, 512, [], "e505", "M0 128V384L224 512 448 384V128L224 0 0 128zm80 32h8H99.9l3.4 11.4L128 253.7V176 160h32v16V336v16H144h-8H124.1l-3.4-11.4L96 258.3V336v16H64V336 176 160H80zm128 0h48 16v32H256 224v48h32 16v32H256 224v64 16H192V336 256 176 160h16zm96 0h32 32 16v32H368 352V336v16H320V336 192H304 288V160h16z"],
    "face-rolling-eyes": [512, 512, [128580, "meh-rolling-eyes"], "f5a5", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 368H320h16v32H320 192 176V368h16zm32-144c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26 15.5-48.4 37.8-58.4c-3.7 5.2-5.8 11.6-5.8 18.4c0 17.7 14.3 32 32 32s32-14.3 32-32c0-6.9-2.2-13.2-5.8-18.4C208.5 175.6 224 198 224 224zm128 64c-35.3 0-64-28.7-64-64c0-26 15.5-48.4 37.8-58.4c-3.7 5.2-5.8 11.6-5.8 18.4c0 17.7 14.3 32 32 32s32-14.3 32-32c0-6.9-2.2-13.2-5.8-18.4C400.5 175.6 416 198 416 224c0 35.3-28.7 64-64 64z"],
    "bread-loaf": [640, 512, [127838], "f7eb", "M397.4 34.9c-2.1-.9-4.1-1.9-6.2-2.8c3.1-.1 6-.2 8.8-.2c64 0 240 32 240 160c0 35.3-28.7 64-64 64V480H448V282.5c37.3-13.2 64-48.7 64-90.5c0-82.2-57.6-130.7-114.6-157.1zM0 192C0 64 176 32 240 32s240 32 240 160c0 35.3-28.7 64-64 64V480H64V256c-35.3 0-64-28.7-64-64z"],
    "rings-wedding": [512, 512, [], "f81b", "M128.7 102.4L96 48 128 0h96l32 48-32.7 54.4C297.5 123.1 352 191.2 352 272c0 52.3-22.8 99.2-59 131.5c-18.7-11.9-32.1-31.5-35.9-54.2C276.2 329.2 288 302 288 272c0-12-1.9-23.6-5.4-34.5c-34.9 19-58.6 56-58.6 98.5c0 61.9 50.1 112 112 112s112-50.1 112-112c0-46.1-27.8-85.7-67.6-102.9c-5-26.2-14.8-50.7-28.6-72.4C441.6 168.7 512 244.1 512 336c0 97.2-78.8 176-176 176c-55.3 0-104.7-25.5-137-65.5c-7.5 1-15.2 1.5-23 1.5C78.8 448 0 369.2 0 272c0-80.8 54.5-148.9 128.7-169.6zM64 272c0 58.7 45.1 106.8 102.5 111.6c-4.2-15.1-6.5-31.1-6.5-47.6c0-64.4 34.5-120.7 86.1-151.3C226.9 169.2 202.5 160 176 160c-61.9 0-112 50.1-112 112z"],
    "object-group": [576, 512, [], "f247", "M0 128V64 0H64h64V32H448V0h64 64V64v64H544V384h32v64 64H512 448V480H128v32H64 0V448 384H32V128H0zM96 416H480V96H96V416zm32-288H320V288H128V128zM256 320h64 32V288 224h96V384H256V320z"],
    "french-fries": [384, 512, [127839], "f803", "M64 32L97.4 221.4 117.7 272H128V90.7L112 0 64 32zM18.7 192H59.7L41.8 90.5 0 80 18.7 192zM384 80L342.7 90.3 325.8 192h39.6L384 80zM320 32L256 48V272h10.3l23.4-58.6L320 32zM160 272h64V240 32L160 0V272zM0 224L64 512H320l64-288H320l-32 80H96L64 224H0z"],
    "chart-line": [512, 512, ["line-chart"], "f201", "M64 64V32H0V64 448v32H32 480h32V416H480 64V64zM342.6 278.6l128-128-45.3-45.3L320 210.7l-57.4-57.4L240 130.7l-22.6 22.6-112 112 45.3 45.3L240 221.3l57.4 57.4L320 301.3l22.6-22.6z"],
    "calendar-arrow-down": [448, 512, ["calendar-download"], "e0d0", "M160 0V64H288V0h64V64h96v96H0V64H96V0h64zM0 192H448V512H0V192zm248 72V240H200v24V366.1l-39-39-17-17L110.1 344l17 17 80 80 17 17 17-17 80-80 17-17L304 310.1l-17 17-39 39V264z"],
    "send-back": [640, 512, [], "f87e", "M192 64V192H64V64H192zM64 0H0V64 192v64H64 192h64V192 64 0H192 64zM576 320V448H448V320H576zM448 256H384v64V448v64h64H576h64V448 320 256H576 448zM160 288V416H352V256 224h32 96V96H288V256v32H256 160z"],
    "mask-ventilator": [640, 512, [], "e524", "M384 393.2v76.6c38-12.6 70.6-36 93.5-66.4l144.4-36.1 18.2-4.5V344 152 128H616 454.5c-2.3-3.5-4.6-7-6.9-10.4L384 32H256l-64 85.6c-2.4 3.4-4.7 6.9-6.9 10.4H24 0v24V344v18.7l18.2 4.5 144.1 36c22.7 30.5 55.4 54.1 93.8 66.6V393.3c-19.7-16.4-32-40.3-32-66.9c0-26.5 12.4-63.2 32-91.6L288 192h32 32l31.8 42.8c19.7 28.4 32.2 65.1 32.2 91.6c0 26.7-12.4 50.4-32 66.8zM134.3 346.8L48 325.3V176H159.1C139.4 219.2 128 264.7 128 300.8c0 15.9 2.2 31.4 6.3 46zM480.7 176H592V325.3l-86.4 21.6c4.2-14.7 6.4-30.1 6.4-46.1c0-36.1-11.6-81.6-31.3-124.8zM288 288V512h64V288H288z"],
    "signature-lock": [640, 512, [], "e3ca", "M96 128c0-17.7 14.3-32 32-32s32 14.3 32 32v7.8c0 27.7-2.4 55.3-7.1 82.5l-130 39L0 264.2V288 448v32H32 96h18.6l9.2-16.1 25.5-44.7c26.8-47 46.5-97.7 58.4-150.5L288 244.6V288v32h32 32 32V287.7 256H352V201.6v-43l-41.2 12.4-90.4 27.1c2.4-20.7 3.6-41.4 3.6-62.3V128c0-53-43-96-96-96s-96 43-96 96v32 32H96V160 128zM209.9 368c-6.7 16.3-14.2 32.3-22.3 48H384l0-48H209.9zM64 311.8l71.8-21.5c-10.4 33.8-24.5 66.4-42.1 97.2L77.4 416H64V311.8zM528 240c17.7 0 32 14.3 32 32v48H496V272c0-17.7 14.3-32 32-32zm-80 32v48H416V512H640V320H608V272c0-44.2-35.8-80-80-80s-80 35.8-80 80z"],
    "arrow-right": [448, 512, [8594], "f061", "M422.6 278.6L445.3 256l-22.6-22.6-144-144L256 66.7 210.8 112l22.6 22.6L322.8 224 32 224 0 224l0 64 32 0 290.7 0-89.4 89.4L210.8 400 256 445.3l22.6-22.6 144-144z"],
    "signs-post": [512, 512, ["map-signs"], "f277", "M224 0h64V32H448l64 64-64 64H32V32H224V0zm0 224V192h64v32H480V352H64L0 288l64-64H224zm64 160V512H224V384h64z"],
    "octagon-plus": [512, 512, ["plus-octagon"], "f301", "M0 160V352L160 512H352L512 352V160L352 0H160L0 160zM232 368V344 280H168 144V232h24 64V168 144h48v24 64h64 24v48H344 280v64 24H232z"],
    "cash-register": [512, 512, [], "f788", "M320 0H32V128H144v32H32L0 371.2V512H512V371.2L480 160H208V128H320V0zM96 48H256h16V80H256 96 80V48H96zM64 416H80 432h16v32H432 80 64V416zm72-200v48H88V216h48zm48 48V216h48v48H184zm0 32v48H136V296h48zm96-80h48v48H280V216zm-48 80h48v48H232V296zm144-80h48v48H376V216zm0 80v48H328V296h48z"],
    "person-circle-question": [576, 512, [], "e542", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM91.4 128h17.5H211.1h17.5l9.4 14.8 66.4 104c-15.5 16.3-28 35.7-36.3 57l-2.3 1.4-33.8-53V480v32H168V480 352H152V480v32H88V480 252.2l-33.8 53L.2 270.8 82 142.8 91.4 128zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm-22.4 56c-23 0-41.6 18.6-41.6 41.6V328l32 0v-6.4c0-5.3 4.3-9.6 9.6-9.6h40.5c7.7 0 13.9 6.2 13.9 13.9c0 5.2-2.9 9.9-7.4 12.3l-32 16.8-8.6 4.5v9.7V376v16h32V378.9l23.5-12.3c15.1-7.9 24.5-23.6 24.5-40.6c0-25.4-20.6-45.9-45.9-45.9H409.6zM448 416H416v32h32V416z"],
    "melon-slice": [512, 512, [], "e311", "M391.4 391.4C294.6 488.2 137.9 487.9 41 391L7 425c115.6 115.6 302.6 116 418.3 .3S540.5 122.6 425 7L391 41c96.9 96.9 97.1 253.6 .3 350.4zM320 128c0 106-86 192-192 192c-14.4 0-28.4-1.6-41.9-4.6L48 353.5l15.3 15.3c84.4 84.4 221.1 84.4 305.5 0c84.2-84.2 84.4-220.7 .3-305.1L353.5 48 315.4 86.1c3 13.5 4.6 27.5 4.6 41.9z"],
    "space-station-moon": [512, 512, [], "e033", "M512 256c0 7.8-.3 15.5-1 23.1C438.8 304.7 351.2 320 256 320s-182.8-15.3-255-40.9c-.7-7.6-1-15.3-1-23.1C0 114.6 114.6 0 256 0S512 114.6 512 256zM256 512C134.9 512 33.4 427.9 6.8 314.8C79.4 338.4 164.7 352 256 352s176.6-13.6 249.2-37.2C478.6 427.9 377.1 512 256 512zM160 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"],
    "message-smile": [512, 512, ["comment-alt-smile"], "f4aa", "M0 0H512V416H304L160 512V416H0V0zM192 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM168.4 222.1l-35.8 32 16 17.9c26.3 29.4 64.7 48 107.3 48s81-18.6 107.3-48l16-17.9-35.8-32-16 17.9c-17.6 19.7-43.1 32-71.6 32s-53.9-12.3-71.6-32l-16-17.9z"],
    "cup-straw": [384, 512, [129380], "e363", "M224 0h56 24V48H280 243l-18.8 80H352h32v64H352 32 0V128H32 174.9L200.6 18.5 205 0h19zM64 512L40 224H344L320 512H64z"],
    "left-from-line": [448, 512, ["arrow-alt-from-right"], "f348", "M160 416L0 256 160 96l32 0 0 96 160 0 0 128-160 0 0 96-32 0zm224 0l0-320 0-32 64 0 0 32 0 320 0 32-64 0 0-32z"],
    "h": [384, 512, [104], "48", "M320 256l0 192v32l64 0V448l0-192V224 192 64 32H320V64 192L64 192 64 64V32H0V64 192v64V448v32H64l0-32 0-192 256 0z"],
    "basket-shopping-simple": [576, 512, ["shopping-basket-alt"], "e0af", "M256.4 29.8L245.3 51.1 171.8 192H404.2L330.7 51.1 319.6 29.8 362.2 7.6l11.1 21.3L458.4 192H576v64H544L480 512H96L32 256H0V192H117.6L202.7 28.9 213.8 7.6l42.6 22.2zM144 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm312-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "hands-holding-heart": [640, 512, ["hands-heart"], "f4c3", "M180 74c0-40.9 33.1-74 74-74h3c19.9 0 39.1 7.7 53.4 21.5l9.6 9.2 9.6-9.2C343.9 7.7 363.1 0 383 0h3c40.9 0 74 33.1 74 74c0 20.1-8.2 39.4-22.7 53.3L333.9 226.8 320 240.2l-13.9-13.3L202.7 127.3C188.2 113.4 180 94.1 180 74zM80 64v40 8 32 80 66.7l84.1 84.1L205.8 347l-36.4-36.4L146.7 288l-9.4-9.4L114.7 256 160 210.7l22.6 22.6 9.4 9.4 22.6 22.6 64 64 9.4 9.4V352v64 32 32 32H256 160 146.7l-9.4-9.4-128-128L0 365.3V352 224 160 128 104 64H80zm480 0h80v40 24 32 64V352v13.3l-9.4 9.4-128 128-9.4 9.4H480 384 352V480 448 416 352 338.7l9.4-9.4 64-64L448 242.7l9.4-9.4L480 210.7 525.3 256l-22.6 22.6-9.4 9.4-22.6 22.6L434.2 347l41.7 27.8L560 290.7V224 144 112v-8V64z"],
    "clock-nine": [512, 512, [], "e34c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392V256v24H256 152 128V232h24 80V120 96h48v24z"],
    "tarp": [576, 512, [], "e57b", "M576 288V64H0V448l416 0 0-160H576zm0 32H448l0 128L576 320zM96 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "face-sleepy": [512, 512, [], "e38e", "M256 512c47.1 0 91.2-12.7 129.1-34.9c-.7-4.3-1.1-8.7-1.1-13.1c0-22.9-.7-52.8-14.9-74.8l-13.9-21.7 18.2-18.2 20-20 15.4-15.4 19.9 8.6c20.7 8.9 42.4 21.3 61.4 37.3C504.2 328.1 512 293 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256S114.6 512 256 512zM474.8 389s0 0 0 0c-15-13.8-33.2-25.2-51.4-33.8l-.9-.4c-2.2-1-4.4-2-6.5-2.9l-20 20s0 0 0 0l0 0c8.8 13.8 13.8 29.1 16.5 43.9s3.3 28.9 3.4 40.1c0 2.9 0 5.6 0 8.1c0 26.5 21.5 48 48 48s48-21.5 48-48c0-29.7-15.4-54.9-37.2-75zm-219.1-5c-33.9 0-65.2 8.5-90.6 23c4.1-39.8 43.1-71 90.6-71s86.5 31.2 90.6 71c-25.4-14.5-56.8-23-90.6-23zM395.2 242.4l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2c21.6 28.8 64.8 28.8 86.4 0zm-278.4 0c21.6 28.8 64.8 28.8 86.4 0l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2z"],
    "hand-horns": [384, 512, [], "e1a9", "M32 0H96V240H32V0zM224 160h64V288H224V160zm-32-32V240H128V128h64zM320 64h64V192 320v32c0 88.4-71.6 160-160 160H162.3c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363V272H184h8v48 32H96 80v32H96 208h16V368 320h96V192 64z"],
    "screwdriver-wrench": [512, 512, ["tools"], "f7d9", "M224 144C224 64.5 288.5 0 368 0c19 0 37.1 3.7 53.7 10.3L336 96v80h80l85.7-85.7C508.3 106.9 512 125 512 144c0 61.3-38.3 113.7-92.3 134.4l-45.1-45.1L352 210.7l-22.6 22.6-8.4 8.4-97-97 0-.8zM0 416L168.4 247.6 241.8 321l-8.4 8.4L210.7 352l22.6 22.6L96 512 0 416zm137.9-8L104 374.1 70.1 408 104 441.9 137.9 408zM287 321l-129-129H96L0 64 64 0 192 96v62.1L321 287l31-31L512 416l-96 96L256 352l31-31z"],
    "arrows-to-eye": [640, 512, [], "e4bf", "M40 112l38.1 0L0 33.9 33.9 0 112 78.1 112 40V16l48 0V40l0 96v24H136l-96 0H16l0-48H40zm521.9 0l38.1 0h24v48H600l-96 0H480V136l0-96V16l48 0V40 78.1L606.1 0 640 33.9 561.9 112zM128 256c20-48 86.4-144 192-144s172 96 192 144c-20 48-86.4 144-192 144s-172-96-192-144zm192 64a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM528 433.9V472v24H480V472 376 352h24 96 24v48H600 561.9L640 478.1 606.1 512 528 433.9zM112 472V433.9L33.9 512 0 478.1 78.1 400H40 16l0-48H40h96 24v24 96 24H112V472z"],
    "circle-three-quarters": [512, 512, [], "e125", "M256 0C114.6 0 0 114.6 0 256S114.6 512 256 512s256-114.6 256-256H256V0z"],
    "trophy-star": [576, 512, ["trophy-alt"], "f2eb", "M128 0c0 22.6 .6 43.9 1.6 64H24 0V88C0 222.5 70.4 295.7 140.5 334.1c34.5 18.9 68.8 29.3 94.3 35c5.9 1.3 11.3 2.4 16.2 3.3c1.7 .9 3.4 1.8 5.1 2.6V448H184 160v24 16 24h24H392h24V488 472 448H392 320V374.9c1.7-.8 3.3-1.7 5.1-2.6c4.9-.9 10.3-1.9 16.2-3.3c25.5-5.7 59.8-16.1 94.3-35C505.6 295.7 576 222.5 576 88V64H552 446.4c1-20.1 1.6-41.4 1.6-64H128zM48.9 112h84.4c9.1 90.1 29.2 150.3 51.9 190.6c-7.2-3.2-14.4-6.7-21.7-10.7C109.8 262.6 56.4 209.9 48.9 112zM412.5 291.9c-7.2 4-14.5 7.5-21.7 10.7c22.7-40.3 42.8-100.5 51.9-190.6h84.4c-7.5 97.9-60.9 150.6-114.6 179.9zM316.2 129.2l63.1 9.2-45.7 44.5 10.8 62.8L288 216l-56.4 29.7 10.8-62.8-45.7-44.5 63.1-9.2L288 72l28.2 57.2z"],
    "plug-circle-bolt": [576, 512, [], "e55b", "M128 0H64V32v96h64V32 0zM320 0H256V32v96h64V32 0zM32 160H0v64H32v32c0 77.4 55 142 128 156.8V512h64V412.8c12.3-2.5 24.1-6.4 35.1-11.5c-2.1-10.8-3.1-21.9-3.1-33.3c0-80.6 54.1-148.5 128-169.4V160H352 32zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm24-224l-10.7 64H512L408 448l10.7-64H352l104-96z"],
    "face-thermometer": [576, 512, [], "e39a", "M543.4 273.6C534.4 406.8 423.5 512 288 512C146.6 512 32 397.4 32 256S146.6 0 288 0C391.8 0 481.2 61.8 521.4 150.7l-6 5.8L338 328.5c-14.7-5.2-31.3-8.5-50-8.5c-71.6 0-113.7 47.7-126.3 72.8l28.6 14.3c8.7-17.5 41.3-55.2 97.7-55.2s88.9 37.7 97.7 55.2l28.6-14.3c-2-4-4.8-8.7-8.3-13.6l10.3-10-24.8-24.8L383 336l17-17 8.5 8.5 25.1 25.1 15.3-14.8-25.4-25.4L415 304l17-17 8.5 8.5 25.7 25.7 15.3-14.8-25.9-25.9L447 272l17-17 8.5 8.5 26.2 26.2L514 275l-26.5-26.5L479 240l17-17 8.5 8.5 26.8 26.8 12.6-12.1c.1 3.3 .2 6.6 .2 9.9c0 4.9-.1 9.8-.4 14.6L545 272l-1.6 1.6zM208.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "grid-round-4": [448, 512, [], "e5dd", "M44.8 121.6a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6zm0 119.5a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6zm44.8 74.7A44.8 44.8 0 1 1 0 315.7a44.8 44.8 0 1 1 89.6 0zM44.8 480a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6zM209.1 76.8a44.8 44.8 0 1 1 -89.6 0 44.8 44.8 0 1 1 89.6 0zM164.3 241.1a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6zm44.8 74.7a44.8 44.8 0 1 1 -89.6 0 44.8 44.8 0 1 1 89.6 0zM164.3 480a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6zM328.5 76.8a44.8 44.8 0 1 1 -89.6 0 44.8 44.8 0 1 1 89.6 0zM283.7 241.1a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6zm44.8 74.7a44.8 44.8 0 1 1 -89.6 0 44.8 44.8 0 1 1 89.6 0zM283.7 480a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6zM448 76.8a44.8 44.8 0 1 1 -89.6 0 44.8 44.8 0 1 1 89.6 0zM403.2 241.1a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6zM448 315.7a44.8 44.8 0 1 1 -89.6 0 44.8 44.8 0 1 1 89.6 0zM403.2 480a44.8 44.8 0 1 1 0-89.6 44.8 44.8 0 1 1 0 89.6z"],
    "shirt-running": [384, 512, [], "e3c8", "M112 0V32 80c0 44.2 35.8 80 80 80s80-35.8 80-80V32 0h64V32 64 80v48l7.6 20.4L0 393.8V256L48 128V80 64 32 0h64zM0 472.5L366.9 210.4 384 256V512H0V472.5z"],
    "book-circle-arrow-up": [640, 512, [], "e0bd", "M96 0C43 0 0 43 0 96V416c0 53 43 96 96 96H384h10.8c-23.3-16.4-42.5-38.4-55.6-64H96c-17.7 0-32-14.3-32-32s14.3-32 32-32H320.7c-.5-5.3-.7-10.6-.7-16c0-80.6 54.1-148.5 128-169.4V0H416 384 96zM496 224a144 144 0 1 0 0 288 144 144 0 1 0 0-288zM417.4 360l11.3-11.3 56-56L496 281.4l11.3 11.3 56 56L574.6 360 552 382.6l-11.3-11.3L512 342.6V432v16H480V432 342.6l-28.7 28.7L440 382.6 417.4 360z"],
    "face-nauseated": [512, 512, [], "e381", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm79.6-336a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-128 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-12.3-84.7l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4-15.8 2.6-5.3-31.6 15.8-2.6 2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4L184 89.4 206.6 112l-11.3 11.3zM305.4 112L328 89.4l11.3 11.3 7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4 15.8 2.6-5.3 31.6-15.8-2.6-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4L305.4 112zM168 282.7c19.5 11.3 33.8 30.5 38.4 53.3h99.2c4.6-22.8 18.9-42 38.4-53.3l13.8-8 16 27.7-13.8 8c-14.4 8.3-24 23.8-24 41.6s9.6 33.3 24 41.6l13.8 8-16 27.7-13.8-8c-19.5-11.3-33.8-30.5-38.4-53.3H206.4c-4.6 22.8-18.9 42-38.4 53.3l-13.8 8-16-27.7 13.8-8c14.4-8.3 24-23.8 24-41.6s-9.6-33.3-24-41.6l-13.8-8 16-27.7 13.8 8z"],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 9829, 10084, 61578], "f004", "M39.8 263.8L64 288 256 480 448 288l24.2-24.2c25.5-25.5 39.8-60 39.8-96C512 92.8 451.2 32 376.2 32c-36 0-70.5 14.3-96 39.8L256 96 231.8 71.8c-25.5-25.5-60-39.8-96-39.8C60.8 32 0 92.8 0 167.8c0 36 14.3 70.5 39.8 96z"],
    "file-chart-pie": [384, 512, [], "f65a", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zm56 320H192V200c66.3 0 120 53.7 120 120zM160 210.4V352H301.6c-11.1 54.8-59.5 96-117.6 96c-66.3 0-120-53.7-120-120c0-58.1 41.2-106.5 96-117.6z"],
    "mars-and-venus": [512, 512, [9893], "f224", "M368 0H496V128l-32 32-47-47-25.6 25.6C407 163.3 416 192.6 416 224c0 80.2-59 146.6-136 158.2V384v.4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .4 .3 .4 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3h24 24v48H304 280v.2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .2 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0l-24 0-24 0v0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V486 486v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V485 485v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V484v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V483v-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1-.1V481v-.1-.1-.1-.1-.1-.1-.1-.1V480v-.1-.1-.1-.1-.1-.1-.1V479v-.1-.1-.1-.1-.1-.1-.1V478v-.1-.1-.1-.1-.1-.1V477v-.1-.1-.1-.1-.1-.1V476v-.1-.1-.1-.1-.1-.1V475v-.1-.2-.2-.2-.2-.2V474v-.2-.2-.2-.2-.2V473v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V470v-.2-.2-.2-.2-.2V469v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V467v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V463v-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2-.2V459v-.2-.2-.2-.2-.2-.2-.2-.2V457v-.2-.2-.2-.2V456H208 184V408h24 24v-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3V403v-.3-.3V402v-.3-.3V401v-.3-.3V400v-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.3-.4-.3-.4-.4-.4-.4V393v-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4V388v-.4-.4-.4-.4-.4-.4-.4-.4-.4-.4V384v-1.8C155 370.6 96 304.2 96 224c0-88.4 71.6-160 160-160c39.6 0 75.9 14.4 103.8 38.2L383 79 336 32 368 0zM256 488h24v24H232V488h24zm96-264a96 96 0 1 0 -192 0 96 96 0 1 0 192 0z"],
    "house-user": [576, 512, ["home-user"], "e1b0", "M576 287.6H511.8l1 224.4H64.1V287.6H0V240L288.4 0 576 240v47.6zM352 224a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm48 192l-32-96H208l-32 96H400z"],
    "circle-arrow-down-left": [512, 512, [], "e0f9", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM168 368H320h24V320H320 225.9L361 185l17-17L344 134.1l-17 17-135 135V184 160H144v24V344v24h24z"],
    "dumpster-fire": [640, 512, [], "f794", "M32 32L0 160H114.9L140.5 32H32zM272 160V32H173.1L147.5 160H272zm32 0h64.8c15.8-17.2 32.5-33.2 50-48.5L402.9 32H304V160zm240-42.9c9.5 8.5 18.7 17 27.7 25.7L544 32H435.5l11.2 56 1.3-1c22.7 18.4 44.8 37.2 65.3 58.2c7.6-7.5 15.6-14.6 23.5-21.7l0 0c2.4-2.1 4.8-4.3 7.2-6.4zm-256 203c0-47.2 24.9-91 53.7-128.2H32l4 32H0v64H44L64 448v32h64V448H336.8C306.4 414.1 288 369.3 288 320.2zm225-128c-32.3-37.5-65-64-65-64s-128 103.6-128 192s71.6 160 160 160s160-71.6 160-160c0-73.6-96-160-96-160s-13.9 12.5-31 32zM530 401c-15 10-31 15-49 15c-45 0-81-29-81-78c0-24 15-45 45-82c4 5 62 79 62 79l36-42c3 4 5 8 7 12c18 33 10 75-20 96z"],
    "hexagon-minus": [512, 512, ["minus-hexagon"], "f307", "M0 256L128 32H384L512 256 384 480H128L0 256zm184-24H160v48h24H328h24V232H328 184z"],
    "left-to-line": [448, 512, ["arrow-alt-to-left"], "f34b", "M256 416L96 256 256 96l32 0 0 96 160 0 0 128-160 0 0 96-32 0zM64 96l0 320 0 32L0 448l0-32L0 96 0 64l64 0 0 32z"],
    "house-crack": [576, 512, [], "e3b1", "M511.8 287.6H576V240L288.4 0 0 240v47.6H64.1V512H230.4L192 448l96-80L224 256 384 368l-96 80 38.4 64H512.8l-1-224.4z"],
    "paw-simple": [448, 512, ["paw-alt"], "f701", "M192 80A48 48 0 1 0 96 80a48 48 0 1 0 96 0zm-16 80L107.7 283C64.2 293.8 32 333.2 32 380c0 55.2 44.8 100 100 100c24.8 0 47.5-9 65-24h54c17.5 15 40.2 24 65 24c55.2 0 100-44.8 100-100c0-46.8-32.2-86.2-75.7-97L272 160H176zm128-32a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm144 64a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM48 240a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "arrow-left-long-to-line": [640, 512, [], "e3d4", "M0 96V64H64V96 416v32H0V416 96zM128 256l22.6-22.6 128-128 22.6-22.6L346.5 128l-22.6 22.6L250.5 224 608 224h32v64l-32 0-357.5 0 73.4 73.4L346.5 384l-45.3 45.3-22.6-22.6-128-128L128 256z"],
    "brackets-round": [512, 512, ["parentheses"], "e0c5", "M110.2 37.4C71.9 62.9 0 140.2 0 256S71.9 449.1 110.2 474.6l35.5-53.3C120.1 404.3 64 345 64 256s56.1-148.3 81.8-165.4L110.2 37.4zm291.5 0L366.2 90.6C391.9 107.7 448 167 448 256s-56.1 148.3-81.8 165.4l35.5 53.3C440.1 449.1 512 371.8 512 256s-71.9-193.1-110.2-218.6z"],
    "martini-glass-citrus": [576, 512, ["cocktail"], "f561", "M432 240c53 0 96-43 96-96s-43-96-96-96c-35.5 0-66.6 19.3-83.2 48H296.2C316 40.1 369.3 0 432 0c79.5 0 144 64.5 144 144s-64.5 144-144 144c-28.2 0-54.5-8.1-76.7-22.1l35.3-35.3c12.5 6 26.6 9.4 41.4 9.4zM0 160V128H416v32L232 344V464h88v48H232 208 96V464h88V344L0 160z"],
    "user-shakespeare": [448, 512, [], "e2c2", "M224 48c44.2 0 80 35.8 80 80v32c0 40.1-29.5 73.3-68 79.1V224 212H212v12 15.1c-38.5-5.8-68-39-68-79.1V128c0-44.2 35.8-80 80-80zM96 128v32 8L64 208v64h98c18.4 10.2 39.5 16 62 16s43.6-5.8 62-16h98V208l-32-40v-8V128C352 57.3 294.7 0 224 0S96 57.3 96 128zm96 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-48 31l-8.5 8.5C204.9 178.1 194.1 180 192 180H180v24h12c7 0 19.6-3 32.1-12.3c2.2 1.6 4.5 3.2 7.1 4.6c6.5 3.8 15.4 7.6 24.8 7.6h12V180H256c-3.3 0-7.8-1.5-12.8-4.4c-4.8-2.8-8.8-6.1-10.7-8.1L224 159zM448 512L384 320H343.9l-5.3-16H304 144 109.4l-5.3 16H64L0 512H208c0-8.8 7.2-16 16-16s16 7.2 16 16H448zM224 432a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-96-32V352H320v48l-40-16H168l-40 16z"],
    "arrow-right-to-arc": [512, 512, [], "e4b2", "M448 256c0-106-86-192-192-192V0C397.4 0 512 114.6 512 256s-114.6 256-256 256V448c106 0 192-86 192-192zM230.6 121.4l112 112L365.3 256l-22.6 22.6-112 112L208 413.3 162.7 368l22.6-22.6L242.7 288H32 0V224H32 242.7l-57.4-57.4L162.7 144 208 98.7l22.6 22.6z"],
    "face-surprise": [512, 512, [128558, "surprise"], "f5c2", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM256 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "bottle-water": [320, 512, [], "e4c5", "M224 0V64H96V0H224zM32 151.7c0-15.6 9-29.8 23.2-36.5L96.3 96H223.7l41.1 19.3c14.1 6.6 23.2 20.8 23.2 36.5c0 14.4-7.5 27-18.9 34.1c11.5 8.8 18.9 22.6 18.9 38.2c0 16.7-8.5 31.4-21.5 40c12.9 8.6 21.5 23.3 21.5 40s-8.5 31.4-21.5 40c12.9 8.6 21.5 23.3 21.5 40s-8.5 31.4-21.5 40c12.9 8.6 21.5 23.3 21.5 40v48H32V464c0-16.7 8.5-31.4 21.5-40C40.5 415.4 32 400.7 32 384s8.5-31.4 21.5-40C40.5 335.4 32 320.7 32 304s8.5-31.4 21.5-40C40.5 255.4 32 240.7 32 224c0-15.6 7.4-29.4 18.9-38.2C39.5 178.7 32 166.1 32 151.7zM96 224v32H224V224H96zM224 352H96v32H224V352z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM224 192V320v32H160V320 192 160h64v32zm128 0V320v32H288V320 192 160h64v32z"],
    "gauge-circle-plus": [640, 512, [], "e498", "M496 192c2.7 0 5.3 .1 8 .2C475.6 81.7 375.4 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c39.5 0 77-9 110.4-25C337.6 455.7 320 413.9 320 368c0-97.2 78.8-176 176-176zM320 352c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3V88 64h48V88 292.7c23.5 9.5 40 32.5 40 59.3zM144 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM336 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208v48h48 16v32H560 512v48 16H480V432 384H432 416V352h16 48V304 288h32v16z"],
    "folders": [576, 512, [], "f660", "M576 384V96H368L304 32H96V384H576zM48 120V96H0v24V456v24H24 456h24V432H456 48V120z"],
    "angel": [576, 512, [], "f779", "M384 64.2c0 .1-.1 .3-.2 .6c-.3 .6-.9 1.8-2.3 3.5c-1.4 1.7-3.4 3.6-6.2 5.6c6.7 8.3 12.2 17.6 16.3 27.7C407 91 416 78 416 64c0-35.3-57.3-64-128-64S160 28.7 160 64c0 14 9 27 24.3 37.5c4.1-10 9.6-19.3 16.3-27.7c-2.7-2-4.8-4-6.2-5.6c-1.4-1.7-2-2.8-2.3-3.5c-.1-.3-.2-.5-.2-.6s0-.1 0-.2s0-.1 0-.2s.1-.3 .2-.6c.3-.6 .9-1.8 2.3-3.5c2.9-3.5 8.4-7.9 17.3-12.4C229.6 38.4 256.5 32 288 32s58.4 6.4 76.2 15.4c8.9 4.5 14.4 8.9 17.3 12.4c1.4 1.7 2 2.8 2.3 3.5c.1 .3 .2 .5 .2 .6s0 .1 0 .2s0 .1 0 .2zM368 144a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM209.4 285.3L120 464H49.2l42.4-91.9 11.3-24.4L87.9 325.4 48 265.5V208h84.1l77.3 77.3zM248 256l-96-96H48 0v48 72l48 72L0 456v8 48H48 96h96H384h96 48 48V464v-8L528 352l48-72V208 160H528 424l-96 96H248zM526.8 464H456L366.6 285.3 443.9 208H528v57.5l-39.9 59.9-14.9 22.4 11.3 24.4L526.8 464z"],
    "value-absolute": [512, 512, [], "f6a6", "M64 32H0V64 448v32H64V448 64 32zM182.6 137.4L160 114.7 114.7 160l22.6 22.6L210.7 256l-73.4 73.4L114.7 352 160 397.3l22.6-22.6L256 301.3l73.4 73.4L352 397.3 397.3 352l-22.6-22.6L301.3 256l73.4-73.4L397.3 160 352 114.7l-22.6 22.6L256 210.7l-73.4-73.4zM512 64V32H448V64 448v32h64V448 64z"],
    "rabbit": [512, 512, [128007], "f708", "M311.9 128h24c1-23.7-2.8-47.2-11-69.2c7.6-17.8 18.6-34.2 32.7-48.3L368 0l24 8 3 11.9c10.4 41.6 3.3 85.1-18.6 120.8L448 199.1V288H352v10.3l78 210.6 1.2 3.1H362.9L317.7 390.1 265.6 448H288h32v64H288 208 160 128 96V471.2C85.8 481.6 71.7 488 56 488c-30.9 0-56-25.1-56-56s25.1-56 56-56c17.4 0 33 8 43.3 20.5C114 317.7 176.8 255.9 256 242.7V153.8c-29.7-37.6-42.4-86.4-34-134.4L224 8l32-8 10.4 10.3C298 41.7 314.1 84.6 311.9 128zM368 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "toilet-paper-slash": [640, 512, [], "e072", "M94.9 50.9L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7-98.4-76.4C570.6 372.4 608 291 608 192C608 86 565 0 512 0s-96 86-96 192c0 48.6 9 92.9 23.9 126.7l-57.8-44.9c1.4-27.1 1.9-54.4 1.9-81.9c0-65.5 13.2-142.4 60.2-192H160c-25.1 0-48 19.3-65.1 50.9zM369.5 387.1L66.5 148.4C64.9 162.4 64 177 64 192c0 89.9-3.9 190.6-37.6 275.8L8 512H333.3c17-40.8 28.5-82.5 36.2-124.9zM544 192c0 35.3-14.3 64-32 64s-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64z"],
    "circle-euro": [512, 512, [], "e5ce", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM144 272c-.6-5-.9-10.1-.9-15.2c0-5.7 .4-11.3 1.1-16.8H112V208h40.7c19.2-46.9 65.4-80 119.2-80H313h24v48H313 271.9c-26.3 0-49.6 12.6-64.4 32H304v32H192.9c-1.1 5.4-1.7 11-1.7 16.8c0 5.2 .5 10.3 1.4 15.2H304v32H206.4c14.7 20.3 38.5 33.5 65.5 33.5H313h24v48H313 271.9c-54.4 0-101-33.8-119.8-81.5H112V272h32z"],
    "apple-whole": [448, 512, [127822, 127823, "apple-alt"], "f5d1", "M208 96V80c0-44.2 35.8-80 80-80h16 16V16 32c0 44.2-35.8 80-80 80H224 208V96zM0 288c0-76.3 35.7-160 112-160l112 32 112-32c76.3 0 112 83.7 112 160c0 128-80 224-160 224l-64-16-64 16C80 512 0 416 0 288z"],
    "kitchen-set": [576, 512, [], "e51a", "M240 144A96 96 0 1 0 48 144a96 96 0 1 0 192 0zm44.4 32C269.9 240.1 212.5 288 144 288C64.5 288 0 223.5 0 144S64.5 0 144 0c68.5 0 125.9 47.9 140.4 112H344V96h48H496h48v48 48H496 392 344V176H284.4zM144 80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM424 240v32H544v48H256V272H376V240h48zM288 352H512V512H288V352zM176 320c26.5 0 48 21.5 48 48s-21.5 48-48 48H160v32H32V320h96 32 16zm0 64c8.8 0 16-7.2 16-16s-7.2-16-16-16H160v32h16zm48 80v48H0V464H224z"],
    "diamond-half": [512, 512, [], "e5b7", "M256 0L0 256 256 512V0z"],
    "lock-keyhole": [448, 512, ["lock-alt"], "f30d", "M224 64c44.2 0 80 35.8 80 80v48H144V144c0-44.2 35.8-80 80-80zM80 144v48H0V512H448V192H368V144C368 64.5 303.5 0 224 0S80 64.5 80 144zM256 320v64 32H192V384 320 288h64v32z"],
    "r": [320, 512, [114], "52", "M32 32H0V64 288 448v32H64V448 320h93.2L246 480h73.2l-4.2-7.5L225.5 311.3C280.7 291.1 320 238.1 320 176c0-79.5-64.5-144-144-144H32zM176 256H64V96H176c44.2 0 80 35.8 80 80s-35.8 80-80 80z"],
    "temperature-quarter": [320, 512, ["temperature-1", "thermometer-1", "thermometer-quarter"], "f2ca", "M112 300.2L97.8 317.8C86.6 331.5 80 348.9 80 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-19.1-6.6-36.5-17.8-50.3L208 300.2V277.5 64H112V277.5v22.7zM208 0h64V64 277.5c20 24.7 32 56.2 32 90.5c0 79.5-64.5 144-144 144S16 447.6 16 368c0-34.3 12-65.8 32-90.5V64 0h64 96zm0 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V272 256h32v16 50.8c18.6 6.6 32 24.4 32 45.3z"],
    "square-info": [448, 512, [8505, "info-square"], "f30f", "M448 32H0V480H448V32zM184 336h24V272H184 160V224h24 48 24v24 88h8 24v48H264 184 160V336h24zm72-208v64H192V128h64z"],
    "wifi-slash": [640, 512, [], "f6ac", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L364.8 260.5c39.1 7.9 74.5 26.1 103.3 51.5l42.4-48C459.8 219.2 393 192 320 192c-13.5 0-26.8 .9-39.8 2.7l-95.6-74.2C226.7 104.7 272.3 96 320 96c103.2 0 196.8 40.7 265.8 106.9l44.3-46.2C549.7 79.5 440.4 32 320 32c-69.2 0-134.7 15.7-193.2 43.7L48.4 14.8zm45.2 155L41.7 128.9C30.7 137.7 20 147 9.8 156.7l44.3 46.2c12.4-11.9 25.6-23 39.5-33.1zM228 275.7L173 232.3c-15.5 9.2-30.1 19.8-43.5 31.7l42.4 48c16.7-14.8 35.6-27 56.2-36.3zM320 352c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64c0-7-1.1-13.7-3.2-20l-55.6-43.8c-1.7-.1-3.4-.2-5.2-.2z"],
    "toilet-paper-xmark": [512, 512, [], "e5b3", "M96 0H348.2C336.6 12.2 327 26.9 319.5 41.9C299.5 82 288 135.1 288 192s11.5 110 31.5 150.1c7.5 15 17.1 29.7 28.7 41.9H96C43 384 0 298 0 192S43 0 96 0zM320 192c0-83.6 26.7-154.7 64-181.1C394 3.8 404.8 0 416 0c53 0 96 86 96 192c0 35-4.7 67.8-12.8 96c-16.6 57.4-47.6 96-83.2 96c-11.2 0-22-3.8-32-10.9c-37.3-26.4-64-97.5-64-181.1zm64 0c0 35.3 14.3 64 32 64s32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64zM160 416H416c44.8 0 76.9-35.2 96-72.9V512H160V416zm40-153.4L222.6 240l-11.3-11.3L174.6 192l36.7-36.7L222.6 144 200 121.4l-11.3 11.3L152 169.4l-36.7-36.7L104 121.4 81.4 144l11.3 11.3L129.4 192 92.7 228.7 81.4 240 104 262.6l11.3-11.3L152 214.6l36.7 36.7L200 262.6z"],
    "hands-holding-dollar": [640, 512, ["hands-usd"], "f4c5", "M344 32v2.9c6.4 1.2 14.3 2.8 18.2 3.9L385.4 45 373 91.4l-23.2-6.2c-3.7-1-17-3.6-21.3-4.3c-11.6-1.8-20.8-.3-26.4 2.3c-5.5 2.5-5.9 4.8-5.9 5.1l0 0c-.3 1.5-.2 2.3-.2 2.7c.2 .2 .7 .9 2.2 1.9c5.5 3.7 14.4 6.6 28.8 10.9l1 .3c12 3.6 28.7 8.7 41.4 17.9c7.1 5.2 14 12.3 18.2 22.1c4.3 9.9 5.1 20.7 3.2 31.7c-3.6 20.6-17.3 34.5-34 41.7c-4.2 1.8-8.5 3.2-13 4.2V224v24H296l0-24v-3.2c-9.3-2.4-20.3-6.1-27.3-8.5l0 0 0 0c-1.7-.6-3.1-1.1-4.2-1.4l-22.8-7.6 15.2-45.5 22.8 7.6c2.1 .7 4.3 1.5 6.6 2.2c9.5 3.2 19.7 6.7 25.4 7.6c12.3 1.9 21.4 .6 26.6-1.6c4.4-1.9 5.3-3.8 5.6-5.8c.3-1.8 .3-2.9 .2-3.5c-.1-.6-.2-.8-.2-.9l0 0c0-.1-.4-.9-2.4-2.4c-5.2-3.8-14-6.8-28.1-11.1l-2.3-.7c-11.6-3.5-27.5-8.2-39.6-16.5c-7-4.8-14.1-11.5-18.7-21.1c-4.6-9.8-5.6-20.5-3.7-31.4c3.5-20 17.6-33.5 33.4-40.7c4.3-2 8.9-3.5 13.6-4.7V32 8h48V32zM296.1 91.2a.1 .1 0 1 0 .1-.1 .1 .1 0 1 0 -.1 .1zM80 64v40 8 32 80 66.7l84.1 84.1L205.8 347l-36.4-36.4L146.7 288l-9.4-9.4L114.7 256 160 210.7l22.6 22.6 9.4 9.4 22.6 22.6 64 64 9.4 9.4V352v64 32 32 32H256 160 146.7l-9.4-9.4-128-128L0 365.3V352 224 160 128 104 64H80zm480 0h80v40 24 32 64V352v13.3l-9.4 9.4-128 128-9.4 9.4H480 384 352V480 448 416 352 338.7l9.4-9.4 64-64L448 242.7l9.4-9.4L480 210.7 525.3 256l-22.6 22.6-9.4 9.4-22.6 22.6L434.2 347l41.7 27.8L560 290.7V224 144 112v-8V64z"],
    "cube": [512, 512, [], "f1b2", "M256 6l10.8 3.8 224 80L512 97.4V120 392v22.6l-21.2 7.6-224 80L256 506l-10.8-3.8-224-80L0 414.6V392 120 97.4l21.2-7.6 224-80L256 6zm32 420.6l160-57.1v-180L288 246.6v180zM256 74L93.5 132 256 190l162.5-58L256 74z"],
    "arrow-down-triangle-square": [576, 512, ["sort-shapes-down"], "f888", "M160 479.6l23.7-26 80-88 21.5-23.7-47.4-43-21.5 23.7L192 349.2V64 32H128V64 349.2l-24.3-26.8L82.2 298.8l-47.4 43 21.5 23.7 80 88 23.7 26zM416 32L304 224H528L416 32zm96 448V288H320V480H512z"],
    "bitcoin-sign": [320, 512, [], "e0b4", "M112 0H48V64H0v64 96 64 96 64H48v64h64V448h32v64h64l0-64c61.9 0 112-50.1 112-112c0-40.1-21.1-75.3-52.7-95.1C280.3 222.6 288 200.2 288 176c0-50.7-33.7-93.6-80-107.4V0H144V64H112V0zM64 128H176c26.5 0 48 21.5 48 48s-21.5 48-48 48H64V128zM176 288h32c26.5 0 48 21.5 48 48s-21.5 48-48 48H64V288H176z"],
    "shutters": [512, 512, [], "e449", "M32 32H0V96H32 480h32V32H480 32zM0 224H512l-24-96H24L0 224zM512 352l-24-96H24L0 352H512zM0 480H512l-24-96H24L0 480z"],
    "shield-dog": [512, 512, [], "e573", "M256 0l11.6 4.5L475.1 85l19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9c-32.7 75.2-91.1 150-189.4 192.6L256 512l-12.7-5.5C144.9 463.9 86.5 389.2 53.9 313.9C21.4 239.3 13.6 162.9 16.6 113l1.2-20.5L36.9 85 244.4 4.5 256 0zM160.9 286.2L144 320l128 64V320h48c44.2 0 80-35.8 80-80V192H320l-16-32H240v64c0 35.3-28.7 64-64 64c-5.2 0-10.3-.6-15.1-1.8zM144 160v64c0 17.7 14.3 32 32 32s32-14.3 32-32V192 160h-8H144zm112 48a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "solar-panel": [640, 512, [], "f5ba", "M96 0H70.2L64.7 25.2l-64 296L0 324.6V328v24 32H32 288v64H224 192v64h32H416h32V448H416 352V384H608h32V352 328v-3.4l-.7-3.3-64-296L569.8 0H544 96zm3.3 168L121.8 64h90.9L202.3 168H99.3zM89 216H197.5L187.1 320H66.5L89 216zm156.8 0H394.3l10.4 104H235.3l10.4-104zm196.8 0H551l22.5 104H452.9L442.5 216zm98.1-48H437.7L427.3 64h90.9l22.5 104zm-151.2 0h-139L260.9 64H379.1l10.4 104z"],
    "lock-open": [576, 512, [], "f3c1", "M352 144c0-44.2 35.8-80 80-80s80 35.8 80 80v48 32h64V192 144C576 64.5 511.5 0 432 0S288 64.5 288 144v48H0V512H448V192H352V144z"],
    "table-tree": [512, 512, [], "e293", "M512 32H0V480H512V32zM448 160V416H64V160H96v96 16 80 16h16H240h16V336H240 128V272h48 16V240H176 128V160H448zM224 224v64H416V224H224zm192 96H288v64H416V320z"],
    "house-chimney-heart": [576, 512, [], "e1b2", "M576 287.6H511.8l1 224.4H64.1V287.6H0V240L288.4 0 416 106.5V32h96V186.6L576 240v47.6zM235.2 208c-32.7 0-59.2 26.5-59.2 59.2c0 16.1 6.6 31.5 18.2 42.7l82.8 79.6L288 400.1l11.1-10.7 82.8-79.6c11.6-11.2 18.2-26.6 18.2-42.7c0-32.7-26.5-59.2-59.2-59.2h-2.4c-15.9 0-31.2 6.2-42.7 17.2l-7.7 7.4-7.7-7.4c-11.5-11-26.8-17.2-42.7-17.2h-2.4z"],
    "tally-3": [640, 512, [], "e296", "M160 32V64 448v32H96V448 64 32h64zm128 0V64 448v32H224V448 64 32h64zM416 64V448v32H352V448 64 32h64V64z"],
    "elevator": [512, 512, [], "e16d", "M64 80V96H224V80L144 0 64 80zm448 48H0V512H512V128zM160 224a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM80 448l24-96H216l24 96H80zm328-96l24 96H272l24-96H408zM304 272a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM368 96l80-80V0H288V16l80 80z"],
    "money-bill-transfer": [640, 512, [], "e528", "M512 112v64h24L640 88 536 0H512V64L384 64l-24 0 0 48 24 0 128 0zM256 400l-128 0 0-64H104L0 424l104 88h24l0-64 128 0 24 0 0-48-24 0zm64-248l0-88H32V355l51.3-43.4 8.9-7.6H104h24 32v32 24l96 0 64 0 0 88H608V157l-51.3 43.4-8.9 7.6H536 512 480V176 152l-96 0-64 0zM96 192V128h64c0 35.3-28.7 64-64 64zM480 384c0-35.3 28.7-64 64-64v64H480zM320 192a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "money-bill-trend-up": [512, 512, [], "e529", "M304 0h32H448h32V32 144v32H416V144 109.3L310.6 214.6l-21 21-22.5-19.3L176 138.1 84.8 216.3 43.2 167.7l112-96L176 53.9l20.8 17.9 89.5 76.7L370.7 64H336 304V0zM0 256H512V512H0V256zM48 416v48H96c0-26.5-21.5-48-48-48zM96 304H48v48c26.5 0 48-21.5 48-48zM464 416c-26.5 0-48 21.5-48 48h48V416zM416 304c0 26.5 21.5 48 48 48V304H416zm-96 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "house-flood-water-circle-arrow-right": [640, 512, [], "e50f", "M288 144A144 144 0 1 0 0 144a144 144 0 1 0 288 0zM152 65.4l11.3 11.3 56 56L230.6 144l-11.3 11.3-56 56L152 222.6 129.4 200l11.3-11.3L169.4 160H80 64V128H80h89.4L140.7 99.3 129.4 88 152 65.4zM320 144c0 55.2-25.4 104.5-65.2 136.8c3.4-1.2 6.7-2.6 9.9-4.1c12-5.5 21.7-12.5 35.5-22.5l0 0 0 0 0 0 1.1-.8L320 240l19.7 14.2 0 0c13.9 10 23.6 17 35.5 22.5c13.1 6 27.7 10.3 40.7 10.3s27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l0 0L512 240l19.7 14.2c10.8 7.8 19.1 13.8 28 18.6l-.3-80.8H608V144L400 0 302.5 67.5C313.7 90.6 320 116.6 320 144zM86 322.9c-15.4 7-34.7 13.1-54 13.1v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V336c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5 0 0c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5 0 0c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-2.7-1.2-5.2-2.5-7.7-3.8c-6 .6-12.1 .9-18.3 .9c-14.7 0-29-1.8-42.7-5.2c-4.9 2.9-9.9 5.6-15.3 8.1zM320 485.4c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V448c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7z"],
    "square-poll-horizontal": [448, 512, ["poll-h"], "f682", "M448 32L0 32 0 480l448 0 0-448zM256 192L96 192l0-64 160 0 0 64zm96 32l0 64L96 288l0-64 256 0zM192 384l-96 0 0-64 96 0 0 64z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512z"],
    "cart-circle-exclamation": [640, 512, [], "e3f2", "M24 0H0V48H24 76.1l60.3 316.5 3.7 19.5H160 320.7c-.5-5.3-.7-10.6-.7-16c0-10.9 1-21.6 2.9-32h-143l-9.1-48H339.2c29.1-57 88.4-96 156.8-96c10 0 19.7 .8 29.2 2.4L576 32H122l-2.4-12.5L115.9 0H96 24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm320 0a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64H480V416h32v32zm0-176v16 80 16H480V368 288 272h32z"],
    "sword": [512, 512, [128481], "f71c", "M400 16L166.6 249.4l96 96L496 112 512 0 400 16zM0 416l96 96 32-32-16-32 56-56 88 56 32-32L96 224 64 256l56 88L64 400 32 384 0 416z"],
    "backward-fast": [512, 512, [9198, "fast-backward"], "f049", "M64 96V64H0V96 416v32H64V416 280L288 448V280L512 448V64L288 232V64L64 232V96z"],
    "recycle": [512, 512, [9842, 9850, 9851], "f1b8", "M309.1 0l9.4 15 63.8 102.1L432.8 88l12 20.8L412.6 229 292.4 196.8l-12-20.8 46.5-26.8L273.7 64l-35.4 0-33.5 53.6-55.5-32L193.4 15l9.4-15 17.7 0 70.8 0 17.7 0zm99.2 279.5l55.5-32 43.3 69.3 10.2 16.3-9.6 16.7-32 55.4L460.2 432 451 448H432.5L320 448v56H296l-88-88 88-88h24v56l94 0 6.3-10.9 22.4-38.8-34.3-54.8zM64.7 221.1L16 193l12-20.8L148.2 140l32.2 120.2-12 20.8-48.3-27.9L69.3 334.4 98 384l62 0v64l-80.5 0L61 448l-9.2-16L4.3 349.7l-9.6-16.7L4.9 316.8l59.8-95.7z"],
    "user-astronaut": [448, 512, [], "f4fb", "M370.7 96C346 39.5 289.6 0 224 0S102 39.5 77.3 96H48V224H77.3c24.7 56.5 81.1 96 146.7 96s122-39.5 146.7-96H400V96H370.7zM336 128v32c0 53-43 96-96 96H208c-53 0-96-43-96-96V128l32-32H304l32 32zM192 160l-16-32-16 32-32 16 32 16 16 32 16-32 32-16-32-16zM97 304H48L0 512H128V416H320v96H448L400 304H351c-33.8 29.9-78.3 48-127 48s-93.2-18.1-127-48zm95 144H160v16 48h32V464 448zm80 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "interrobang": [320, 512, [8253], "e5ba", "M144 96c-35.3 0-64 28.7-64 64v16H16V160C16 89.3 73.3 32 144 32h32c70.7 0 128 57.3 128 128v9.3c0 39.3-18 76.4-48.9 100.6L192 319.6v.4 32H128V320 304 288.4 176 144h64v32 62.2l23.5-18.5C231 207.5 240 189 240 169.3V160c0-35.3-28.7-64-64-64H144zM120 400h80v80H120V400z"],
    "plane-slash": [640, 512, [], "e069", "M514.3 192c34.2 0 93.7 29 93.7 64c0 36-59.5 64-93.7 64H441.5L620.9 459.3l19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7 190 147.5L192 0h96L397.7 192l116.6 0zM40.6 128L362.5 381.6 288 512l-96 0 54.9-192H144L96 384H32L64 256 32 128h8.6z"],
    "circle-dashed": [512, 512, [], "e105", "M.5 240H64.7c3.4-41 19.6-78.3 44.7-108L64 86.6C27.5 128 4.1 181.3 .5 240zM132 109.4C161.7 84.3 199 68 240 64.7V.5C181.3 4.1 128 27.5 86.6 64L132 109.4zm140 338v64.2c58.6-3.6 112-27 153.4-63.5L380 402.6c-29.6 25.1-67 41.4-108 44.7zM402.6 380L448 425.4c36.5-41.4 59.9-94.7 63.5-153.4H447.3c-3.4 41-19.6 78.3-44.7 108zm-316 68c41.4 36.5 94.7 59.9 153.4 63.5V447.3c-41-3.4-78.3-19.6-108-44.7L86.6 448zM64 425.4L109.4 380C84.3 350.3 68 313 64.7 272H.5c3.6 58.6 27 112 63.5 153.4zM425.4 64C384 27.5 330.6 4.1 272 .5V64.7c41 3.4 78.3 19.6 108 44.7L425.4 64zM448 86.6L402.6 132c25.1 29.6 41.4 67 44.7 108h64.2c-3.6-58.7-27-112-63.5-153.4z"],
    "trademark": [640, 512, [8482], "f25c", "M0 96H32 96h64 64 32v64H224 160V384v32H96V384 160H32 0V96zm288 32V96h48l9.6 12.8L464 266.7 582.4 108.8 592 96h48v32V384v32H576V384 224L489.6 339.2 464 373.3l-25.6-34.1L352 224V384v32H288V384 128z"],
    "basketball": [512, 512, [127936, "basketball-ball"], "f434", "M86.6 64l85.2 85.2C194.5 121.7 208 86.4 208 48c0-14.7-2-28.9-5.7-42.4C158.6 15 119 35.5 86.6 64zM64 86.6C35.5 119 15 158.6 5.6 202.3C19.1 206 33.3 208 48 208c38.4 0 73.7-13.5 101.3-36.1L64 86.6zM256 0c-7.3 0-14.6 .3-21.8 .9C238 16 240 31.8 240 48c0 47.3-17.1 90.5-45.4 124L256 233.4 425.4 64C380.2 24.2 320.9 0 256 0zM48 240c-16.2 0-32-2-47.1-5.8C.3 241.4 0 248.7 0 256c0 64.9 24.2 124.2 64 169.4L233.4 256 172 194.6C138.5 222.9 95.3 240 48 240zm463.1 37.8c.6-7.2 .9-14.5 .9-21.8c0-64.9-24.2-124.2-64-169.4L278.6 256 340 317.4c33.4-28.3 76.7-45.4 124-45.4c16.2 0 32 2 47.1 5.8zm-4.7 31.9C492.9 306 478.7 304 464 304c-38.4 0-73.7 13.5-101.3 36.1L448 425.4c28.5-32.3 49.1-71.9 58.4-115.7zM340.1 362.7C317.5 390.3 304 425.6 304 464c0 14.7 2 28.9 5.7 42.4C353.4 497 393 476.5 425.4 448l-85.2-85.2zM317.4 340L256 278.6 86.6 448c45.1 39.8 104.4 64 169.4 64c7.3 0 14.6-.3 21.8-.9C274 496 272 480.2 272 464c0-47.3 17.1-90.5 45.4-124z"],
    "fork-knife": [576, 512, ["utensils-alt"], "f2e6", "M214.6 169.4L192 146.7l0 0L45.3 0S0 40 0 104c0 70.7 63.5 136.2 154.7 226.8L265.4 220.1l-50.7-50.7zM441.4 486.6L464 509.3 509.3 464l-22.6-22.6L355.9 310.6l-45.3 45.3L441.4 486.6zM488 24L472 8 348.6 78.5C321 94.3 304 123.6 304 155.3c0 19.4 6.4 38.1 18 53.4L89.4 441.4 66.7 464 112 509.3l22.6-22.6L367.2 254c15.3 11.6 34 18 53.4 18c31.8 0 61.1-17 76.8-44.6L568 104 552 88 448 192l-16-16L528 64 512 48 400 144l-16-16L488 24z"],
    "satellite-dish": [512, 512, [128225], "f7c0", "M192 0C368.7 0 512 143.3 512 320H448C448 178.6 333.4 64 192 64V0zM32.4 192.4L164.7 324.7l28.4-28.4c-.7-2.6-1.1-5.4-1.1-8.3c0-17.7 14.3-32 32-32s32 14.3 32 32s-14.3 32-32 32c-2.9 0-5.6-.4-8.3-1.1l-28.4 28.4L319.6 479.6C287.3 500.1 249.1 512 208 512C93.1 512 0 418.9 0 304c0-41.1 11.9-79.3 32.4-111.6zM416 320H352c0-88.4-71.6-160-160-160V96c123.7 0 224 100.3 224 224z"],
    "badge-check": [512, 512, [], "f336", "M256 0c36.8 0 68.8 20.7 84.9 51.1C373.8 41 411 49 437 75s34 63.3 23.9 96.1C491.3 187.2 512 219.2 512 256s-20.7 68.8-51.1 84.9C471 373.8 463 411 437 437s-63.3 34-96.1 23.9C324.8 491.3 292.8 512 256 512s-68.8-20.7-84.9-51.1C138.2 471 101 463 75 437s-34-63.3-23.9-96.1C20.7 324.8 0 292.8 0 256s20.7-68.8 51.1-84.9C41 138.2 49 101 75 75s63.3-34 96.1-23.9C187.2 20.7 219.2 0 256 0zM369 209l17-17L352 158.1l-17 17-111 111-47-47-17-17L126.1 256l17 17 64 64 17 17 17-17L369 209z"],
    "circle-up": [512, 512, [61467, "arrow-alt-circle-up"], "f35b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM384 256H304V384H208V256H128V224L256 96 384 224v32z"],
    "slider": [512, 512, [], "e252", "M352 160V352H320V160h32zM320 96H256v64V352v64h64 32 64V352 288h64 32V224H480 416V160 96H352 320zM0 288H32 224V224H32 0v64z"],
    "mobile-screen-button": [384, 512, ["mobile-alt"], "f3cd", "M16 0H368V512H16V0zM224 448a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM304 64H80V384H304V64z"],
    "clock-one-thirty": [512, 512, [], "e34f", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V263.3l60-90 13.3-20-39.9-26.6-13.3 20-64 96-4 6V256 392v24h48V392z"],
    "inbox-out": [512, 512, [128228, "inbox-arrow-up"], "f311", "M288 288v32H224V288 125.3l-41.4 41.4L160 189.3 114.7 144l22.6-22.6 96-96L256 2.7l22.6 22.6 96 96L397.3 144 352 189.3l-22.6-22.6L288 125.3V288zM0 320H144l32 64H336l32-64H512V512H0V320z"],
    "cloud-slash": [640, 512, [], "e137", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L635.2 480H640V352c0-59.6-40.8-109.8-96-124V192c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32c-46.8 0-89 20.1-118.2 52.2L48.4 14.8zM96 192v8.2C40.1 220 0 273.3 0 336V480H144 487.4L97.2 172.6c-.8 6.4-1.2 12.9-1.2 19.4z"],
    "volume-high": [640, 512, [128266, "volume-up"], "f028", "M592 256c0 78.5-37.7 148.2-96 192l28.8 38.4C594.7 433.9 640 350.3 640 256.1l0-.1 0-.1c0-94.2-45.3-177.8-115.2-230.3L496 64c58.3 43.8 96 113.5 96 192zM438.4 371.2l28.8 38.4c46.6-35 76.8-90.8 76.8-153.6s-30.2-118.6-76.8-153.6l-28.8 38.4c35 26.3 57.6 68.1 57.6 115.2s-22.6 88.9-57.6 115.2zM400 256c0 15.7-7.5 29.6-19.2 38.4l28.8 38.4C432.9 315.3 448 287.4 448 256s-15.1-59.3-38.4-76.8l-28.8 38.4c11.7 8.8 19.2 22.7 19.2 38.4zM0 160V352H128L272 480h48V32H272L128 160H0z"],
    "users-rays": [640, 512, [], "e593", "M40 6.1L6.1 40 23 57l56 56 17 17L129.9 96 113 79 57 23 40 6.1zm560 0L583 23 527 79l-17 17L544 129.9l17-17 56-56 17-17L600 6.1zM57 489l56-56 17-17L96 382.1 79 399 23 455l-17 17L40 505.9l17-17zm543 17L633.9 472l-17-17-56-56-17-17L510.1 416l17 17 56 56 17 17zM223.8 176a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM120 256L96 336h94.3l19.4-58.1 7.3-21.9H120zm329.7 80H544l-24-80H423.1l7.3 21.9L449.7 336zM432 384l-16-48-16-48H382.4 257.6 240l-16 48-16 48H432zm80-208a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM320 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "wallet": [512, 512, [], "f555", "M480 32H0V480H512V128H64V96H480V32zM416 272a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "octagon-check": [512, 512, [], "e426", "M0 160V352L160 512H352L512 352V160L352 0H160L0 160zm369 49L241 337l-17 17-17-17-64-64-17-17L160 222.1l17 17 47 47L335 175l17-17L385.9 192l-17 17z"],
    "flatbread-stuffed": [576, 512, [129369], "e40c", "M346.6 53.2L255.9 3.4 185.1 78.8 83.6 98.9 77.8 202.2 13 282.9 75 365.7l.5 25.5L133.8 333c-13.7-19.5-21.8-43.3-21.8-69c0-66.3 53.7-120 120-120c25.7 0 49.5 8.1 69 21.8L422.5 44.2l-75.9 9zM232 176c-48.6 0-88 39.4-88 88c0 16.8 4.7 32.5 12.9 45.9l121-121C264.5 180.7 248.8 176 232 176zM464.3 432.3c106.2-106.2 106.2-278.4 0-384.7L79.7 432.3c106.2 106.2 278.4 106.2 384.7 0zM256 432a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-48-48a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "clipboard-check": [384, 512, [], "f46c", "M192 0c-41.8 0-77.4 26.7-90.5 64H0V512H384V64H282.5C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM297 273L185 385l-17 17-17-17L87 321l-17-17L104 270.1l17 17 47 47 95-95 17-17L313.9 256l-17 17z"],
    "cart-circle-plus": [640, 512, [], "e3f3", "M24 0H0V48H24 76.1l60.3 316.5 3.7 19.5H160 320.7c-.5-5.3-.7-10.6-.7-16c0-10.9 1-21.6 2.9-32h-143l-9.1-48H339.2c29.1-57 88.4-96 156.8-96c10 0 19.7 .8 29.2 2.4L576 32H122l-2.4-12.5L115.9 0H96 24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM352 368a144 144 0 1 0 288 0 144 144 0 1 0 -288 0zm208 16H512v48 16H480V432 384H432l-16 0V352l16 0h48V304 288h32v16 48h48 16v32H560z"],
    "truck-clock": [640, 512, ["shipping-timed"], "f48c", "M416 0H0V416H64c0 53 43 96 96 96s96-43 96-96H384c0 53 43 96 96 96s96-43 96-96h32 32V352H608V288 256 224 210.7l-9.4-9.4-96-96L493.3 96H480 416V0zM544 240v16H416V160h48 2.7L544 237.3V240zM160 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm272 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM96 176a112 112 0 1 1 224 0A112 112 0 1 1 96 176zM224 96H192v16 64 16h16 32 16V160H240 224V112 96z"],
    "pool-8-ball": [512, 512, [], "e3c5", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm384-64a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zm-80-48c0 11.5-4 22-10.7 30.2C304.8 184.5 312 199.4 312 216c0 30.9-25.1 56-56 56s-56-25.1-56-56c0-16.6 7.2-31.5 18.7-41.8C212 166 208 155.5 208 144c0-26.5 21.5-48 48-48s48 21.5 48 48zm-48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm24 56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "file-audio": [384, 512, [], "f1c7", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zm-1.8 447.9l-15.5-28C268.1 403.5 288 372.1 288 336s-19.9-67.5-49.4-83.9l15.5-28C293.4 245.9 320 287.9 320 336s-26.6 90.1-65.8 111.9zm-31.1-56l-15.5-28c9.8-5.5 16.5-15.9 16.5-28s-6.6-22.5-16.5-28l15.5-28C242.7 291 256 311.9 256 336s-13.3 45-32.9 56zM64 376V296h56l40-40h16V416H160l-40-40H64z"],
    "turn-down-left": [512, 512, [], "e331", "M0 288L160 448l32 0 0-112 320 0 0-304-96 0 0 208-224 0 0-112-32 0L0 288z"],
    "lock-hashtag": [448, 512, [], "e423", "M144 144v48H304V144c0-44.2-35.8-80-80-80s-80 35.8-80 80zM80 192V144C80 64.5 144.5 0 224 0s144 64.5 144 144v48h80V512H0V192H80zm112 48H160v16 32H128 112v32h16 32v64H128 112v32h16 32v32 16h32V448 416h64v32 16h32V448 416h32 16V384H320 288V320h32 16V288H320 288V256 240H256v16 32H192V256 240zm0 144V320h64v64H192z"],
    "chart-radar": [512, 512, [], "e0e7", "M73.7 256L165.1 96H346.9l91.4 160L346.9 416H165.1L73.7 256zM128 32L0 256 128 480H384L512 256 384 32H128zM290.2 180.8c3.7-6.1 5.8-13.2 5.8-20.8c0-22.1-17.9-40-40-40s-40 17.9-40 40c0 3.9 .6 7.7 1.6 11.2L160 248c-22.1 0-40 17.9-40 40s17.9 40 40 40c10.2 0 19.6-3.9 26.7-10.2l97.2 19.4c6.4 13.5 20.2 22.7 36.1 22.7c22.1 0 40-17.9 40-40c0-18.5-12.6-34.1-29.6-38.6L290.2 180.8zM202 271.9l47.5-63.4 31.7 79.2L202 271.9z"],
    "staff": [512, 512, [], "f71b", "M306.3 0H336 464h48V48 208v36.2l-34.8 9.9-33.4 9.6L413.7 317l-52.6-29.7-96 27.4L105.9 473.9 72 507.9 4.1 440l33.9-33.9L96 348.1V288h60.1l49.9-49.9 8.8-8.8 12-3.4L416 171.8V96H365.7l-2.7 5.5-21.5 42.9-85.9-42.9 21.5-42.9 16-32L306.3 0z"],
    "burger": [512, 512, ["hamburger"], "f805", "M32 224V192s0-160 224-160s224 160 224 160v32H32zm112-96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm240 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM272 96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM16 352V256H496v96H16zM32 480V384H480v96H32z"],
    "utility-pole": [512, 512, [], "e2c3", "M288 0V32 64h96V56 32h48V56v8h32V56 32h48V56v8V96v24 8H480 428.8L288 221.9V288 480v32H224V480 288 221.9L83.2 128H32 0v-8V96 64 56 32H48V56v8H80V56 32h48V56v8h96V32 0h64zM140.8 128L224 183.4V128H140.8zM288 183.4L371.2 128H288v55.4z"],
    "transporter-6": [512, 512, [], "e2a7", "M64 32L96 48 64 64 48 96 32 64 0 48 32 32 48 0 64 32zM224 0h64 16V32H288 224 208V0h16zM112 256H400h16v32H400 112 96V256h16zM416 512H296 216 96V448H416v64zm48-160l16 32 32 16-32 16-16 32-16-32-32-16 32-16 16-32z"],
    "wrench": [512, 512, [128295], "f0ad", "M352 320c88.4 0 160-71.6 160-160c0-23.5-5.1-45.8-14.1-65.9L400 192H320V112l97.9-97.9C397.8 5.1 375.5 0 352 0C263.6 0 192 71.6 192 160c0 19.1 3.4 37.5 9.5 54.5L0 416l96 96L297.5 310.5c17 6.2 35.4 9.5 54.5 9.5zM137.9 408L104 441.9 70.1 408 104 374.1 137.9 408z"],
    "bugs": [576, 512, [], "e4d0", "M164.5 107.4l29.7-65.5 9.9-21.9L160.4 .2l-9.9 21.9L128 71.7 105.5 22.1 95.6 .2 51.9 20.1l9.9 21.9 29.7 65.5c-10.2 7.1-18.2 17-22.9 28.6H53.5l-2.1-18.7L48.7 93.5 1 98.8l2.7 23.9 4.5 40L10.5 184H32 64v23.3l-37.8 9.5-16.1 4L8.2 237.3l-6.4 56L-1 317.1l47.7 5.4 2.7-23.8L54 259.3l17.9-4.5C82.7 274.6 103.8 288 128 288s45.3-13.4 56.1-33.2l17.9 4.5 4.5 39.5 2.7 23.8 47.7-5.4-2.7-23.8-6.4-56L246 220.8l-16.1-4L192 207.3V184h32 21.3l2.5-21.1 4.8-40L255.5 99l-47.7-5.7L205 117.1 202.7 136H187.3c-4.7-11.6-12.7-21.5-22.9-28.6zM488 286.5l65.6-47 19.5-14-27.9-39-19.5 14-51.4 36.8 6.2-62.9 2.3-23.9-47.8-4.7-2.3 23.9L424.8 250c-12.3 1-24.2 5.6-34.1 13.3L376 254.8l6.8-20 7.7-22.7L345 196.7l-7.7 22.7-13.1 38.6-6.3 18.6 17 9.8 27.7 16L351 322.7 313.5 312 298 307.5l-10 12.7-34.9 44.5-14.8 18.9 37.8 29.6 14.8-18.9 25-31.8 18.2 5.2c-.5 22.6 11 44.7 32 56.8s45.9 11 65.2-.7l14.2 13.7L433.4 472l-8 22.6 45.3 15.9 8-22.6L495.8 439l5.1-14.5-11.1-10.7-28-27.1 11.6-20.1 27.7 16 17 9.8 13-14.8L558.2 347 574 329l-36.1-31.7-15.8 18-13.9 15.9-14.7-8.5c1.7-12.4-.2-25-5.5-36.2z"],
    "vector-polygon": [448, 512, [], "e2c7", "M0 32H128V64H320V32H448V160H384.3l-4.5 7.9L352 216.5v79l27.8 48.6 4.5 7.9H448V480H320V448H128v32H0V352H32V160H0V32zM320 368.5L292.3 320H224V192h68.3L320 143.5V128H128v32H96V352h32v32H320V368.5zM48 80v32H80V80H48zm320 0v32h32V80H368zM80 400H48v32H80V400zm288 0v32h32V400H368zM304 240H272v32h32V240z"],
    "diagram-nested": [448, 512, [], "e157", "M0 32H192V224H128V352H256V288H448V480H256V416H96 64V384 224H0V32z"],
    "rupee-sign": [448, 512, [8360, "rupee"], "f156", "M0 32H32h80c79.5 0 144 64.5 144 144c0 59.6-36.2 110.7-87.8 132.6l54.3 169.6 .6 1.8H155.8L104.6 320H64V480H0V288 64 32zM64 256h48c44.2 0 80-35.8 80-80s-35.8-80-80-80H64V256zm256.5 16.4c-.9 6 0 8.7 .4 9.8c.4 1.1 1.4 2.6 4.2 4.9c7.2 5.7 18.7 10 37.9 16.8l1.3 .5c16 5.6 38.7 13.6 55.7 28.1c9.5 8.1 17.9 18.6 23.1 32.3c5.1 13.7 6.1 28.5 3.8 44c-4.2 28.1-20.5 49.3-43.8 60.9c-22.1 11-48.1 12.5-73.2 8l-.2 0 0 0c-9.3-1.8-20.5-5.7-29.3-9c-6-2.3-12.6-4.9-17.7-6.9l0 0c-2.5-1-4.6-1.8-6.3-2.5l-29.8-11.6 23.2-59.7 29.8 11.6c2.6 1 5.2 2 7.9 3.1l0 0c4.8 1.9 9.8 3.9 15.4 6c8.8 3.3 15.3 5.4 18.7 6c15.7 2.8 26.7 .8 32.9-2.3c5-2.5 8-6 9.1-13c1-6.9 .2-10.5-.5-12.3c-.6-1.7-1.8-3.6-4.5-5.9c-6.9-5.8-18.2-10.4-36.9-17l-3-1.1c-15.5-5.4-37-13-53.3-25.9c-9.5-7.5-18.3-17.6-23.7-31c-5.5-13.4-6.6-28-4.4-43.2c8.4-57.1 67-78 116.9-68.9c6.9 1.3 27.3 5.8 35.4 8.4L440 212l-19 61.1-30.6-9.5c-4.7-1.4-22.3-5.5-27.9-6.5c-14.6-2.7-25.8-.4-32.6 3.2c-6.3 3.3-8.9 7.6-9.5 12z"],
    "file-image": [384, 512, [128443], "f1c5", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM96 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM320 448H192 128 64V416l64-88 32.5 44.7L224 288l96 128v32z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM168 184c0-30.9 25.1-56 56-56h56.9c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L280 264.4V288H232V264 250.5 236.6l12.1-6.9 44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H224c-4.4 0-8 3.6-8 8l0 6.5-48 0V184zm64 184V320h48v48H232z"],
    "image-user": [512, 512, [], "e1b8", "M512 32H0V480H512V32zM192 192a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm144 96l32 96H144l32-96H336z"],
    "buoy": [576, 512, [], "e5b5", "M416 0H160V64h25L133.8 320H64v70.9c3.8-2.6 7.8-5.5 12.3-8.7l1.1-.8L96 368l18.6 13.4 1.1 .8 0 0 0 0c13.9 10 23.6 17 35.5 22.5c13.1 6 27.7 10.3 40.7 10.3s27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l0 0 0 0 1.1-.8L288 368l19.7 14.2 0 0 0 0c13.9 10 23.6 17 35.5 22.5c13.1 6 27.7 10.3 40.7 10.3s27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l0 0L480 368l19.7 14.2 0 0c4.4 3.2 8.5 6.1 12.3 8.7V320H442.2L391 64h25V0zM325.8 64l9.8 49L288 168.5 240.4 113l9.8-49h75.5zm21.8 108.8l17 84.9-44.9-52.4 27.9-32.6zm-91.1 32.6l-44.9 52.4 17-84.9 27.9 32.6zM221.3 320L288 242.2 354.7 320H221.3zm51.1 173.1c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V448c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 441.9 19.3 448 0 448v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9z"],
    "plane-departure": [640, 512, [128747], "f5b0", "M381 114.9L160 32 64 80 234.6 189.7 136 240 64 208 0 240 96 352H256L535.6 212.2c46.5-23.3 82.5-63.3 100.8-112C645.9 75 627.2 48 600.2 48H542.8c-20.2 0-40.2 4.8-58.2 14L381 114.9zM0 448v64H32 608h32V448H608 32 0z"],
    "handshake-slash": [640, 512, [], "e060", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L509 372.4l6.8-7.4-35.4-32.4-134.2-123-23.4 18.2-26.1-20.3 77.4-60.2 12.6-9.8 19.6 25.3-12.6 9.8-20.9 16.2L512 316.8V128h-.7l-3.9-2.5L411.3 64H349.7L233.2 158.3l-26-20.2L298.8 64H224l-60.4 40.3L48.4 14.8zM96 171.6L40.6 128H0V384H96V171.6zM405.1 415.2L128 196.9V352h28.2l73.9 67.4 35.4 32.4 47.7-52.2 22.3 20.5 35.4 32.4 34.2-37.3zM32 336a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM640 128H544V384h96V128zM592 320a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "book-bookmark": [448, 512, [], "e0bb", "M0 96C0 43 43 0 96 0h96V224l80-64 80 64V0h32 32 32V384H416v64h32v64H416 384 96c-53 0-96-43-96-96V96zM64 416c0 17.7 14.3 32 32 32H352V384H96c-17.7 0-32 14.3-32 32z"],
    "border-center-h": [448, 512, [], "f89c", "M0 480l64 0 0-64L0 416l0 64zm96 0l64 0 0-64-64 0 0 64zM96 96l64 0 0-64L96 32l0 64zM288 416l0 64 64 0 0-64-64 0zm0-320l64 0 0-64-64 0 0 64zM192 416l0 64 64 0 0-64-64 0zm0-320l64 0 0-64-64 0 0 64zM384 416l0 64 64 0 0-64-64 0zm0-384l0 64 64 0 0-64-64 0zM0 96l64 0 0-64L0 32 0 96zM192 320l0 64 64 0 0-64-64 0zm192 64l64 0 0-64-64 0 0 64zM0 320l0 64 64 0 0-64L0 320zM384 192l64 0 0-64-64 0 0 64zM0 128l0 64 64 0 0-64L0 128zm192 64l64 0 0-64-64 0 0 64zM32 224L0 224l0 64 32 0 384 0 32 0 0-64-32 0L32 224z"],
    "can-food": [384, 512, [129387], "e3e6", "M272 304.1c11.4-2.4 22.2-5.3 32-8.6V426c-2.8 1.6-6.6 3.6-11.8 5.7C269.8 440.9 234.4 448 192 448s-77.8-7.1-100.2-16.3c-5.2-2.1-9-4.1-11.8-5.7V295.5c9.8 3.3 20.6 6.2 32 8.6V320v48h48 64 48V320 304.1zm-48 6.7V320H208 176 160v-9.2V256h64v54.8zM16 72V240 440c0 39.8 78.8 72 176 72s176-32.2 176-72V240 72c0-39.8-78.8-72-176-72S16 32.2 16 72zm288 0c0 13.3-50.1 24-112 24S80 85.3 80 72s50.1-24 112-24s112 10.7 112 24z"],
    "typewriter": [512, 512, [], "f8e7", "M64 0H96 368h13.3l9.4 9.4 48 48 9.4 9.4V80 192h64v96H480V512H32V288H0V192H64V32 0zM384 128H320V64H128V192h32l32 32H320l32-32h32V128zm48 192V288H400v32h32zm-96-32v32h32V288H336zm-32 0H272v32h32V288zm-64 0H208v32h32V288zm-64 0H144v32h32V288zm-64 0H80v32h32V288zm48 128H144v32h16H352h16V416H352 160zm-16-64H112v32h32V352zm32 32h32V352H176v32zm64-32v32h32V352H240zm64 32h32V352H304v32zm96-32H368v32h32V352z"],
    "arrow-right-from-arc": [512, 512, [], "e4b1", "M64 256C64 150 150 64 256 64h32V0H256C114.6 0 0 114.6 0 256S114.6 512 256 512h32V448H256C150 448 64 362 64 256zM374.6 121.4L352 98.7 306.7 144l22.6 22.6L386.7 224H192 160v64h32H386.7l-57.4 57.4L306.7 368 352 413.3l22.6-22.6 112-112L509.3 256l-22.6-22.6-112-112z"],
    "circle-k": [512, 512, [], "e113", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369.1 128l-1 1.1L270.3 238.3 362 376.7l4.8 7.3H309.2L237.1 275.2 208 307.7V360v24H160V360 298.5 152 128h48v24 83.8L222.1 220l82.5-92h64.5z"],
    "face-hand-over-mouth": [512, 512, [129762], "e378", "M512 256c0 113.1-73.3 209.1-175.1 242.9l52.3-52.3L411.9 424l-22.6-22.6-9.4-9.4 9.4-9.4L411.9 360l-22.6-22.6-9.4-9.4 16-16-22.6-22.6-22.6-22.6L328 244.1l-16 16-9.4-9.4L280 228.1l-22.6 22.6-51.7 51.7H184 144 112v32 82.4c0 21.9 5.5 42.5 15.3 60.5C51.2 433 0 350.5 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256zM208.4 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-33.7 72l-11.3 11.3-56 56 9.4 9.4 72-72L328 289.4 350.6 312l-11.3 11.3-72 72 9.4 9.4 56-56L344 337.4 366.6 360l-11.3 11.3-56 56 9.4 9.4 24-24L344 401.4 366.6 424l-11.3 11.3-48.8 48.8C288.7 502 264.4 512 239.2 512c-52.6 0-95.2-42.6-95.2-95.2V404 384 354.4v-20h40v20 15l84.7-84.7L280 273.4 302.6 296z"],
    "popcorn": [448, 512, [127871], "f819", "M32.2 160h87.6H328.2h87.6c.1-1.3 .2-2.7 .2-4c0-20.9-14.5-38.3-34-42.9c1.3-4.2 2-8.6 2-13.1c0-24.3-19.7-44-44-44c-1.9 0-3.7 .1-5.6 .3C329.3 37.7 312.3 24 292 24c-8.5 0-16.5 2.4-23.2 6.6C261.8 12.7 244.4 0 224 0s-37.8 12.7-44.8 30.6C172.5 26.4 164.5 24 156 24c-20.3 0-37.3 13.7-42.4 32.3c-1.8-.2-3.7-.3-5.6-.3c-24.3 0-44 19.7-44 44c0 4.6 .7 9 2 13.1c-19.5 4.5-34 22-34 42.9c0 1.3 .1 2.7 .2 4zm79.9 153.9L97.8 192H0L80 512H368l80-320H350.2L335.9 313.9 318.2 464H286l18.1-153.9L318 192H240V448v16H208V448 192H130l13.9 118.1L162 464H129.8L112.1 313.9z"],
    "house-water": [576, 512, ["house-flood"], "f74f", "M511.8 287.6H576V240L288.4 0 0 240v47.6H64.1V390.9c3.8-2.6 7.8-5.5 12.2-8.7l1.1-.8L96 368l18.6 13.4 1.1 .8 0 0 0 0c13.9 10 23.6 17 35.5 22.5c13.1 6 27.7 10.3 40.7 10.3s27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l0 0 0 0 0 0 1.1-.8L288 368l19.7 14.2 0 0 0 0c13.9 10 23.6 17 35.5 22.5c13.1 6 27.7 10.3 40.7 10.3s27.6-4.3 40.7-10.3c12-5.5 21.7-12.5 35.5-22.5l0 0L480 368l19.7 14.2 0 0 0 0c4.5 3.3 8.6 6.2 12.5 8.9l-.5-103.5zM224 192H352V320H224V192zm48.4 301.1c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V448c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 441.9 19.3 448 0 448v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9z"],
    "object-subtract": [512, 512, [], "e49e", "M512 512l-352 0 0-160-96 0L0 352l0-64L0 64 0 0 64 0 288 0l64 0 0 64 0 96 160 0 0 352zM288 288l0-224L64 64l0 224 224 0z"],
    "code-branch": [448, 512, [], "f126", "M56 56v48h48V56H56zM0 0H56h48 56V56v48 56H112v81.1c18.8-10.9 40.7-17.1 64-17.1h96c35.3 0 64-28.7 64-64H288V104 56 0h56 48 56V56v48 56H400c0 70.7-57.3 128-128 128H176c-35.3 0-64 28.7-64 64h48v56 48 56H104 56 0V456 408 352H48V160H0V104 56 0zM392 56H344v48h48V56zM104 408H56v48h48V408z"],
    "warehouse-full": [640, 512, ["warehouse-alt"], "f495", "M0 512V128L320 0 640 128V512H544V192H96V512H0zM512 384V512H352V384H512zM128 224H320V352H128V224zM320 384V512H128V384H320z"],
    "hat-cowboy": [640, 512, [], "f8c0", "M320 80L216 32 151.7 260.6c42.4 15.2 98.1 27.3 167.9 27.4h.8c69.8 0 125.5-12.2 167.9-27.4L424 32 320 80zM24 224L0 256s96 192 320 192s320-192 320-192l-24-32s-94.5 96-296 96s-296-96-296-96z"],
    "bridge": [576, 512, [], "e4c8", "M32 32H0V96H32 72v64H0V288c53 0 96 43 96 96v96h96V384c0-53 43-96 96-96s96 43 96 96v96h96V384c0-53 43-96 96-96V160H504V96h40 32V32H544 32zM456 96v64H376V96h80zM328 96v64H248V96h80zM200 96v64H120V96h80z"],
    "phone-flip": [512, 512, [128381, "phone-alt"], "f879", "M512 32L368 0 288 144l83.8 67c-36.1 68.4-92.3 124.6-160.8 160.8L144 288 0 368 32 512H64c247.4 0 448-200.6 448-448l0-32z"],
    "arrow-down-from-dotted-line": [448, 512, [], "e090", "M64 32V96H0V32H64zm96 0V96H96V32h64zm32 0h64V96H192V32zm160 0V96H288V32h64zm32 0h64V96H384V32zM246.6 454.6L224 477.3l-22.6-22.6-128-128L50.7 304 96 258.7l22.6 22.6L192 354.7V192 160h64v32V354.7l73.4-73.4L352 258.7 397.3 304l-22.6 22.6-128 128z"],
    "file-doc": [512, 512, [], "e5ed", "M0 0H224V160H384V304H112V512H0V0zM384 128H256V0L384 128zM176 352h32c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H176 160V496 368 352h16zm16 128h16c8.8 0 16-7.2 16-16V400c0-8.8-7.2-16-16-16H192v96zM456 352h16c22.1 0 40 17.9 40 40v8 16H480V400v-8c0-4.4-3.6-8-8-8H456c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8v-8V448h32v16 8c0 22.1-17.9 40-40 40H456c-22.1 0-40-17.9-40-40V392c0-22.1 17.9-40 40-40zM288 392c0-22.1 17.9-40 40-40h16c22.1 0 40 17.9 40 40v80c0 22.1-17.9 40-40 40H328c-22.1 0-40-17.9-40-40V392zm40-8c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h16c4.4 0 8-3.6 8-8V392c0-4.4-3.6-8-8-8H328z"],
    "square-quarters": [448, 512, [], "e44e", "M0 32H64 384h64V96 416v64H384 64 0V416 96 32zM64 96L224 256 384 96H64zm0 320H384L224 256 64 416z"],
    "truck-front": [512, 512, [], "e2b7", "M0 0H512V448H480v64H384V448H128v64H32V448H0V0zM136 128l-24 96H400l-24-96H136zm-8 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "cat": [576, 512, [128008], "f6be", "M337.1 192H320c-66.8 0-125.6 34.1-160 85.8V192c0-53-43-96-96-96H32v64H64c17.7 0 32 14.3 32 32V480v32h32H336h32V448H336 280L416 339.2V480v32h64V480 288 256v-4c-10.2 2.6-21 4-32 4c-47.4 0-88.7-25.7-110.9-64zm194.3-16.4c8-14 12.6-30.3 12.6-47.6V45.3 0L512 32 480 64v0H416v0L384 32 352 0V45.3 128v0c0 18.6 5.3 36 14.5 50.8c2.9 4.7 6.3 9.1 9.9 13.2h0c17.6 19.6 43.1 32 71.6 32c11.2 0 22-1.9 32-5.5v0c21.8-7.7 40-23.1 51.4-42.9zM400 128a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"],
    "trash-xmark": [448, 512, [], "e2b4", "M304 0l16 32H448V96H0V32H128L144 0H304zM32 128H416L392 512H56L32 128zM321.9 256L288 222.1l-17 17-47 47-47-47-17-17L126.1 256l17 17 47 47-47 47-17 17L160 417.9l17-17 47-47 47 47 17 17L321.9 384l-17-17-47-47 47-47 17-17z"],
    "circle-caret-left": [512, 512, ["caret-circle-left"], "f32e", "M512 256A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM272 384L144 256 272 128l32 0 0 256-32 0z"],
    "files": [448, 512, [], "e178", "M320 96v32h32 96V416H96V0H320V96zm128 0H402.7 384 352V64 45.3 0l32 32 32 32 32 32zM48 120V464H328h24v48H328 24 0V488 120 96H48v24z"],
    "anchor-circle-exclamation": [640, 512, [], "e4ab", "M320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm21.1 80C367 158.8 384 129.4 384 96c0-53-43-96-96-96s-96 43-96 96c0 33.4 17 62.8 42.9 80H224 192v64h32 32V448H128V352h64L96 256 0 352H64V480v32H96 288 394.8c-23.3-16.4-42.5-38.4-55.6-64H320V368.5l0-.5 0-.5V240h32 23.2c2.8-2.7 5.8-5.3 8.8-7.8V176H352 341.1zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-64H480V416h32v32zm0-176v16 80 16H480V368 288 272h32z"],
    "face-clouds": [640, 512, [], "e47d", "M128 0C104.3 0 83.6 12.9 72.6 32H64C28.7 32 0 60.7 0 96v64H224h32 32V128 96c0-35.3-28.7-64-64-64H183.4C172.4 12.9 151.7 0 128 0zM320 192H288 268.1c2.7 4.7 4.3 10.2 4.3 16c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-5.8 1.6-11.3 4.3-16H72.1c-5.3 20.5-8.1 41.9-8.1 64c0 107.4 66.2 199.4 160 237.4V464c0-54.7 34.3-101.3 82.5-119.7C317.4 293.8 362.3 256 416 256c29.1 0 55.6 11.1 75.5 29.2c8.9-3.4 18.5-5.2 28.5-5.2c20 0 38.3 7.3 52.3 19.5c2.4-14.1 3.7-28.7 3.7-43.5C576 114.6 461.4 0 320 0c-20.6 0-40.7 2.4-59.9 7C295.2 21.3 320 55.8 320 96v64 32zm16 177.3c-41.2 6.9-73.6 40.1-79.2 81.8c-.6 4.2-.9 8.5-.9 12.9v16 23.9V512h64H640V464c0-44.7-30.6-82.3-72-93V360c0-26.5-21.5-48-48-48c-13.9 0-26.4 5.9-35.1 15.3C470.9 303.8 445.3 288 416 288c-44.2 0-80 35.8-80 80c0 .4 0 .9 0 1.3zM400.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "user-crown": [448, 512, [], "f6a4", "M96 53.7V0l48 24 16 8L224 0l64 32 16-8L352 0V53.7 144c0 70.7-57.3 128-128 128s-128-57.3-128-128V53.7zM144 128v16c0 44.2 35.8 80 80 80s80-35.8 80-80V128H144zM384 304l64 208H0L64 304H384z"],
    "truck-field": [640, 512, [], "e58d", "M32 32H384V64h64 20.8l8.4 19 62.7 141H608v96h32v64H608 576c0 53-43 96-96 96s-96-43-96-96H256c0 53-43 96-96 96s-96-43-96-96H32 0V320H32V288H0V128H32V32zM384 224h85.9l-42.7-96H384v96zM112 384a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm416 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "route": [512, 512, [], "f4d7", "M416 256s96-96 96-160c0-53-43-96-96-96s-96 43-96 96c0 29.4 20.2 65.5 42.1 96H256 224v32V352v32h32H448v64H188.6c-6.2 9.6-12.6 18.8-19 27.2c-10.7 14.2-21.3 26.9-30 36.8H480h32V480 352 320H480 288V256H416zm0-192a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM149.9 448c21.9-30.5 42.1-66.6 42.1-96c0-53-43-96-96-96s-96 43-96 96c0 64 96 160 96 160s3.5-3.5 9.2-9.6c.4-.4 .7-.8 1.1-1.2c3.3-3.5 7.1-7.8 11.4-12.8c.2-.2 .4-.4 .6-.6c9.4-10.8 20.7-24.6 31.6-39.8zM96 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "cart-circle-check": [640, 512, [], "e3f1", "M24 0H0V48H24 76.1l60.3 316.5 3.7 19.5H160 320.7c-.5-5.3-.7-10.6-.7-16c0-10.9 1-21.6 2.9-32h-143l-9.1-48H339.2c29.1-57 88.4-96 156.8-96c10 0 19.7 .8 29.2 2.4L576 32H122l-2.4-12.5L115.9 0H96 24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-65.4-32l-11.3 11.3-72 72L480 430.6l-11.3-11.3-40-40L417.4 368 440 345.4l11.3 11.3L480 385.4l60.7-60.7L552 313.4 574.6 336z"],
    "clipboard-question": [384, 512, [], "e4e3", "M192 0c-41.8 0-77.4 26.7-90.5 64H0V512H384V64H282.5C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM104 248c0-30.9 25.1-56 56-56h56.9c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L216 328.4V336v24H168V336 314.5 300.6l12.1-6.9 44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H160c-4.4 0-8 3.6-8 8l0 6.5-48 0V248zm64 152h48v48H168V400z"],
    "panorama": [640, 512, [], "e209", "M32 32H0V64 448v32H32 48h5.5l5.2-1.9 0 0 0 0 0 0 0 0 .1 0 .7-.3c.7-.2 1.8-.6 3.4-1.1c3.1-1 7.7-2.5 13.9-4.2c12.3-3.5 30.5-8.3 53.7-13.2C176.8 449.7 242.6 440 320 440s143.2 9.7 189.5 19.3c23.1 4.8 41.4 9.6 53.7 13.2c6.2 1.8 10.8 3.2 13.9 4.2c1.5 .5 2.7 .9 3.4 1.1l.7 .3 .1 0 0 0 0 0 0 0 0 0 5.2 1.9H592h16 32V448 64 32H608 592h-5.5l-5.2 1.9 0 0 0 0 0 0 0 0-.1 0-.7 .3c-.7 .2-1.8 .6-3.4 1.1c-3.1 1-7.7 2.5-13.9 4.2c-12.3 3.5-30.5 8.3-53.7 13.2C463.2 62.3 397.4 72 320 72s-143.2-9.7-189.5-19.3c-23.1-4.8-41.4-9.6-53.7-13.2c-6.2-1.8-10.8-3.2-13.9-4.2c-1.5-.5-2.7-.9-3.4-1.1l-.7-.3-.1 0 0 0 0 0L53.5 32H48 32zM96 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm272-18.6l19.8 29.1L512.3 353l31.8 46.7-55.7-9.5C442.7 382.4 385.2 376 320 376c-19 0-37.3 .5-54.9 1.5l-.8 1.2-.9-1.1c-42.5 2.4-80.5 7.3-112.7 12.8L88.4 401l39.5-49.3L197.3 265 216 241.6 234.7 265l26.4 33.1 87-127.6L368 141.4z"],
    "comment-medical": [512, 512, [], "f7f5", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM224 208H160v64h64v64h64V272h64V208H288V144H224v64z"],
    "teeth-open": [576, 512, [], "f62f", "M576 32H0V256H576V32zM224 96c26.5 0 48 21.5 48 48v80H176V144c0-26.5 21.5-48 48-48zm80 48c0-26.5 21.5-48 48-48s48 21.5 48 48v80H304V144zM96 128c26.5 0 48 21.5 48 48v48H48V176c0-26.5 21.5-48 48-48zm336 48c0-26.5 21.5-48 48-48s48 21.5 48 48v48H432V176zM576 480V288H0V480H576zM96 416c-26.5 0-48-21.5-48-48V320h96v48c0 26.5-21.5 48-48 48zm80-48V320h96v48c0 26.5-21.5 48-48 48s-48-21.5-48-48zm176 48c-26.5 0-48-21.5-48-48V320h96v48c0 26.5-21.5 48-48 48zm80-48V320h96v48c0 26.5-21.5 48-48 48s-48-21.5-48-48z"],
    "user-tie-hair-long": [448, 512, [], "e460", "M304 144c0 44.2-35.8 80-80 80s-80-35.8-80-80V128c0-5.5 .6-10.8 1.6-16H208l32-32 16 16h41.3c4.3 9.8 6.7 20.6 6.7 32v16zM224 0C153.3 0 96 57.3 96 128v16 48L48 240v32H224 400V240l-48-48V144 128C352 57.3 294.7 0 224 0zM209.1 359.2L175.8 483.1 135.8 320H64L0 512H168h14.9 82.3H280 448L384 320H312.2L272.2 483.1 238.9 359.2 272 304H224 176l33.1 55.2z"],
    "file-circle-minus": [576, 512, [], "e4ed", "M0 0H224V160H384v38.6C310.1 219.5 256 287.4 256 368c0 59.5 29.6 112.1 74.8 144H0V0zM384 128H256V0L384 128zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 16V352H496 368 352v32h16H496h16z"],
    "head-side-medical": [512, 512, [], "f809", "M0 224.2C0 100.6 100.2 0 224 0h32C358.1 0 441.6 79.7 447.7 180.3L505 252l7 8.8V272v16 32H480 448v96 32H416 320v32 32H288 96 64V480 381.2c-41-41.9-64-98.3-64-157zM192 160H128v64h64v64h64V224h64V160H256V96H192v64z"],
    "tags": [512, 512, [], "f02c", "M495.2 189.3l7 7v9.9 99.5 9.9l-7 7L337 481 303 447 454.2 295.8V216.2L303 65 337 31 495.2 189.3zM0 256V32H224L416 224v64L224 480 0 256zM144 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "wine-glass": [320, 512, [127863], "f4e3", "M84.6 128l5.8-64H229.6l5.8 64H84.6zM32 0L14.5 192.7C7.7 267.3 58 332.9 128 348.5V448H48v64H160 272V448H192V348.5c70-15.6 120.3-81.2 113.5-155.8L288 0H32z"],
    "forward-fast": [512, 512, [9197, "fast-forward"], "f050", "M448 96V64h64V96 416v32H448V416 280L224 448V280L0 448V64L224 232V64L448 232V96z"],
    "face-meh-blank": [512, 512, [128566, "meh-blank"], "f5a4", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm208.4-48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "user-robot": [448, 512, [], "e04b", "M240 0V16 64H368V320H80V64H208V16 0h32zM16 128H48V256H16V128zm384 0h32V256H400V128zM160 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 80H208v32h32V240zM400 352l48 160H352V416H96v96H0L48 352H400zM176 464v48H144V464 448h32v16zm64 0v48H208V464 448h32v16zM176 240H144v32h32V240zm96 0v32h32V240H272zm32 224v48H272V464 448h32v16z"],
    "square-parking": [448, 512, [127359, "parking"], "f540", "M448 32H0V480H448V32zM160 128h80c53 0 96 43 96 96s-43 96-96 96H192v32 32H128V352 320 256 160 128h32zm80 128c17.7 0 32-14.3 32-32s-14.3-32-32-32H192v64h48z"],
    "card-diamond": [384, 512, [], "e3ea", "M384 0H0V512H384V0zM80 256L192 144 304 256 192 368 80 256z"],
    "face-zipper": [512, 512, [], "e3a5", "M512 256c0 40-9.2 77.8-25.5 111.5l-88.2-44.1-20.6-10.3-16.3 16.3L336 354.7V336 320H304v16 32 16h12.2l7.2 14.3 44.1 88.2C333.8 502.8 296 512 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256zM176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM144 336V320H112v16 32 16h32V368 336zm64 0V320H176v16 32 16h32V368 336zm64 0V320H240v16 32 16h32V368 336zm240 80v32l-64 64H416L352 384l32-32 128 64zm-63.5 16.5L457 424l-17-17-8.5 8.5-16 16L407 440l17 17 8.5-8.5 16-16z"],
    "face-raised-eyebrow": [512, 512, [], "e388", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm208.4-16a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM144 336v32h16H352h16V336H352 160 144zM328.8 141.8c10.7-10.7 28.5-8.9 36.9 3.7l4.9 7.4 8.9 13.3 26.6-17.8-8.9-13.3-4.9-7.4c-19.6-29.4-61.2-33.5-86.2-8.5l-29.5 29.5L265.4 160 288 182.6l11.3-11.3 29.5-29.5zM128 144H112v32h16 64 16V144H192 128z"],
    "house-signal": [576, 512, [], "e012", "M336 0L96 208v32.4c81.8 28.9 146.7 93.8 175.6 175.6H512V256h64V208L336 0zM288 192h96v96H288V192zM0 304c114.9 0 208 93.1 208 208h48C256 370.6 141.4 256 0 256v48zM32 512a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm80 0h48c0-88.4-71.6-160-160-160v48c61.9 0 112 50.1 112 112z"],
    "square-chevron-up": [448, 512, ["chevron-square-up"], "f32c", "M448 32H0V480H448V32zM241 167L345 271l17 17L328 321.9l-17-17-87-87-87 87-17 17L86.1 288l17-17L207 167l17-17 17 17z"],
    "nfc-symbol": [512, 512, [], "e531", "M163.1 40.2L145.8 24.7 125.7 36.3C50.3 79.9 0 163.2 0 256s50.3 176.1 125.7 219.7l32-55.4C101.9 388 64 325.7 64 256c0-61.4 29.5-117.2 74.8-151.7L298.6 247.8l23.8 21.4 42.7-47.6-23.8-21.4L163.1 40.2zM348.9 471.8l17.3 15.5 20.1-11.6C461.6 432.1 512 348.8 512 256s-50.3-176.1-125.7-219.7l-32 55.4C410.1 124 448 186.4 448 256c0 61.4-29.5 117.2-74.8 151.7L213.4 264.2l-23.8-21.4-42.7 47.6 23.8 21.4 178.3 160z"],
    "bars-progress": [512, 512, ["tasks-alt"], "f828", "M448 128v32H320V128H448zM64 64H0v64 32 64H64 448h64V160 128 64H448 64zM448 384H192V352H448v32zM64 288H0v64 32 64H64 448h64V384 352 288H448 64z"],
    "faucet-drip": [512, 512, [128688], "e006", "M256 0V44.8L384 32V96L256 83.2l-31.2-3.1L224 80h0 0l-.8 .1L192 83.2 64 96V32L192 44.8V0h64zM128 192l32-32h32V115.4l32-3.2 32 3.2V160h32l32 32h32c88.4 0 160 71.6 160 160v32H384V352c0-17.7-14.3-32-32-32H315.9c-20.2 29-53.9 48-91.9 48s-71.7-19-91.9-48H0V192H128zM448 416l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7c0 17.5-14.2 31.6-31.6 31.6h-.8c-17.5 0-31.6-14.2-31.6-31.6c0-5.5 1.4-10.9 4.2-15.7L448 416z"],
    "arrows-to-line": [448, 512, [], "e0a7", "M256 32V0H192V32 64H128V96l96 96 96-96V64H256V32zM192 448v32 32h64V480 448h64V416l-96-96-96 96v32h64zM32 224H0v64H32 416h32V224H416 32z"],
    "dolphin": [512, 512, [], "e168", "M176 0h30.5c46.1 0 89.7 10.2 128.9 28.6L464 0l16 16L427.4 94.8c52.4 55 84.6 129.4 84.6 211.3c0 94.2-79.2 169.5-173.3 164.3l-72.5-4L248 512H160l32-80-32-80h88l21.5 53.7 60-3C360 401.2 384 376 384 345.4c0-31.7-25.7-57.4-57.4-57.4H320v64H288l-80-64H192 176 32 0V256 240 221.9l15.5-9.3L42 196.7c-6.4-16.3-10-34.1-10-52.7C32 64.5 96.5 0 176 0zm0 168a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "arrow-up-right": [384, 512, [], "e09f", "M320 96h32v32V352v32H288V352 205.3L86.6 406.6 64 429.3 18.7 384l22.6-22.6L242.7 160H96 64V96H96 320z"],
    "circle-r": [512, 512, [], "e120", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 128h24H288c44.2 0 80 35.8 80 80c0 37.8-26.3 69.5-61.6 77.9L369.1 384h-57l-61.3-96H208v72 24H160V360 264 152 128zm48 112h56 24c17.7 0 32-14.3 32-32s-14.3-32-32-32H208v64z"],
    "cart-flatbed": [640, 512, ["dolly-flatbed"], "f474", "M32 0H0V64H32 64V416v32H96h66.7c-1.8 5-2.7 10.4-2.7 16c0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1-11-2.7-16H450.7c-1.8 5-2.7 10.4-2.7 16c0 26.5 21.5 48 48 48s48-21.5 48-48c0-5.6-1-11-2.7-16H608h32V384H608 128V32 0H96 32zM192 32V320H608V32H464V192l-64-48-64 48V32H192z"],
    "ban-smoking": [512, 512, [128685, "smoking-ban"], "f54d", "M99.5 144.8L178.7 224l96 96 92.5 92.5C335.9 434.9 297.5 448 256 448C150 448 64 362 64 256c0-41.5 13.1-79.9 35.5-111.2zM333.3 288l-32-32H384v32H333.3zm32 32H400h16V304 240 224H400 269.3L144.8 99.5C176.1 77.1 214.5 64 256 64c106 0 192 86 192 192c0 41.5-13.1 79.9-35.5 111.2L365.3 320zM256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM288 96H256v16c0 26.5 21.5 48 48 48h32c8.8 0 16 7.2 16 16v16h32V176c0-26.5-21.5-48-48-48H304c-8.8 0-16-7.2-16-16V96zM229.5 320l-96-96H112 96v16 64 16h16H229.5z"],
    "circle-sort-up": [512, 512, ["sort-circle-up"], "e032", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm144-64v32H368V192L256 96 144 192zm0 96v32l112 96 112-96V288H336 176 144zm112 85.9L193.2 320H318.8L256 373.9z"],
    "terminal": [576, 512, [], "f120", "M22.2 99.4L-.5 76.8 44.8 31.5 67.4 54.2 246.6 233.4 269.3 256l-22.6 22.6L67.4 457.8 44.8 480.5-.5 435.2l22.6-22.6L178.7 256 22.2 99.4zM256 416H544h32v64H544 256 224V416h32z"],
    "mobile-button": [384, 512, [], "f10b", "M368 0H16V512H368V0zM192 400a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "house-medical-flag": [640, 512, [], "e514", "M512 0V32H640V192H512V512H448V192 32 0h64zM256.4 32L416 165.2V512H64.1V287.6H0V240L256.4 32zM224 192v64H160v64h64v64h64V320h64V256H288V192H224z"],
    "basket-shopping": [576, 512, ["shopping-basket"], "f291", "M245.3 51.1l11.1-21.3L213.8 7.6 202.7 28.9 117.6 192H0v64H32L96 512H480l64-256h32V192H458.4L373.3 28.9 362.2 7.6 319.6 29.8l11.1 21.3L404.2 192H171.8L245.3 51.1zM192 304v96 16H160V400 304 288h32v16zm112-16v16 96 16H272V400 304 288h32zm112 16v96 16H384V400 304 288h32v16z"],
    "tape": [576, 512, [], "f4db", "M380.8 416c41.5-40.7 67.2-97.3 67.2-160C448 132.3 347.7 32 224 32S0 132.3 0 256S100.3 480 224 480H544h32V416H544 380.8zM224 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm64 96a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "chestnut": [448, 512, [127792], "e3f6", "M0 416l64 64H384l64-64V384H0v32zm448-64c0-134.3-101.7-213.8-168.4-265.8C251 63.8 228.8 46.4 224 32c-4.8 14.4-27 31.8-55.6 54.2C101.7 138.2 0 217.7 0 352H448z"],
    "bus-simple": [448, 512, ["bus-alt"], "f55e", "M224 0C348.8 0 448 48 448 48V96 448H416v64H320V448H128v64H32V448H0V96 48S99.2 0 224 0zM64 288H384V96H64V288zM80 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm288 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "eye": [576, 512, [128065], "f06e", "M288 32C129.6 32 30 181.3 0 256c30 74.7 129.6 224 288 224s258-149.3 288-224C546 181.3 446.4 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm48 0c0 53 43 96 96 96s96-43 96-96s-43-96-96-96c-6.4 0-12.7 .6-18.8 1.8L288 256l-94.2-18.8c-1.2 6.1-1.8 12.4-1.8 18.8z"],
    "face-sad-cry": [512, 512, [128557, "sad-cry"], "f5b3", "M352 493.4c-29.6 12-62.1 18.6-96 18.6s-66.4-6.6-96-18.6V288 272H128v16V477.8C51.5 433.5 0 350.8 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 94.8-51.5 177.5-128 221.8V288 272H352v16V493.4zM208 336v32c0 26.5 21.5 48 48 48s48-21.5 48-48V336c0-26.5-21.5-48-48-48s-48 21.5-48 48zm-91.2-98.4c21.6-28.8 64.8-28.8 86.4 0l25.6-19.2c-34.4-45.9-103.2-45.9-137.6 0l25.6 19.2zm278.4 0l25.6-19.2c-34.4-45.9-103.2-45.9-137.6 0l25.6 19.2c21.6-28.8 64.8-28.8 86.4 0z"],
    "heat": [448, 512, [], "e00c", "M208 32V64v80c0 34.6 11.2 68.3 32 96l19.2 25.6C288.3 304.4 304 351.5 304 400v48 32H240V448 400c0-34.6-11.2-68.3-32-96l-19.2-25.6C159.7 239.6 144 192.5 144 144V64 32h64zM64 96v32 32c0 34.6 11.2 68.3 32 96l19.2 25.6C144.3 320.4 160 367.5 160 416v32 32H96V448 416c0-34.6-11.2-68.3-32-96L44.8 294.4C15.7 255.6 0 208.5 0 160V128 96H64zm288 32v32c0 34.6 11.2 68.3 32 96l19.2 25.6C432.3 320.4 448 367.5 448 416v32 32H384V448 416c0-34.6-11.2-68.3-32-96l-19.2-25.6C303.7 255.6 288 208.5 288 160V128 96h64v32z"],
    "ticket-airline": [640, 512, [], "e29a", "M640 64H0V448H640V304c-26.5 0-48-21.5-48-48s21.5-48 48-48V64zM432 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-16 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-16 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM176 224l-32-96h56l56 96h46.9c16.1 0 31.5 6.4 42.8 17.7c7.9 7.9 7.9 20.7 0 28.5C334.4 281.6 319 288 302.9 288H256l-56 96H144l32-96H120L96 320H64l16-64L64 192H96l24 32h56z"],
    "boot-heeled": [512, 512, [], "e33f", "M128 0H32V64L64 256 32 384V512H160V464l144 48h16 24H480h8 24V464H488h-8V384L288 288V0H160V240v16H128V240 0z"],
    "arrows-minimize": [512, 512, ["compress-arrows"], "e0a5", "M48 2.7L70.6 25.4 160 114.7V80 48h64V80 192v32H192 80 48V160H80h34.7L25.4 70.6 2.7 48 48 2.7zM509.3 48L486.6 70.6 397.3 160H432h32v64H432 320 288V192 80 48h64V80v34.7l89.4-89.4L464 2.7 509.3 48zM48 288H80 192h32v32V432v32H160V432 397.3L70.6 486.6 48 509.3 2.7 464l22.6-22.6L114.7 352H80 48V288zm240 0h32H432h32v64H432 397.3l89.4 89.4L509.3 464 464 509.3l-22.6-22.6L352 397.3V432v32H288V432 320 288z"],
    "audio-description": [576, 512, [], "f29e", "M576 32H0V480H576V32zM328 160h56c53 0 96 43 96 96s-43 96-96 96H328 304V328 184 160h24zm24 144h32c26.5 0 48-21.5 48-48s-21.5-48-48-48H352v96zM173.9 287.8h36.3L192 245.2l-18.1 42.6zm-17 40L146.5 352H94.4l75.6-177.4 6.2-14.6h31.7l6.2 14.6L289.6 352H237.5l-10.3-24.2H156.8z"],
    "person-military-to-person": [512, 512, [], "e54c", "M200 0L56 14.1v32H200V0zM189.5 78.1H66.5C64.9 83.8 64 89.8 64 96c0 35.3 28.7 64 64 64s64-28.7 64-64c0-6.2-.9-12.2-2.5-17.9zM192 192H83.8L217.8 295 192 192zM32 320H197.8L58.7 213.1 32 320zM384 160a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm96 160L448 192H320L288 320H480zM272 432l96 80h16V456l104 0 24 0 0-48-24 0-104 0V352H368l-96 80zM128 352v56L24 408 0 408l0 48 24 0 104 0v56h16l96-80-96-80H128z"],
    "file-shield": [576, 512, [], "e4f0", "M0 0H224V160H384v48.3L256 257.8V296c0 76.6 34.3 164.8 106.1 216H0V0zM384 128H256V0L384 128zM527.3 312.4L432 275.5V460.4c56.5-26.3 90.2-87 95.3-148zM432 512c-96-32-144-130.2-144-216V279.8L432 224l144 55.8V296c0 85.8-48 184-144 216z"],
    "hexagon": [512, 512, [11043], "f312", "M128 32L0 256 128 480l256 0L512 256 384 32 128 32z"],
    "manhole": [512, 512, [], "e1d6", "M448 256A192 192 0 1 0 64 256a192 192 0 1 0 384 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM256 128c16.6 0 30.3-12.6 31.8-28.8C361 113.9 416 178.5 416 256s-55 142.1-128.2 156.8C286.3 396.6 272.6 384 256 384s-30.3 12.6-31.8 28.8C151 398.1 96 333.5 96 256s55-142.1 128.2-156.8c1.6 16.2 15.2 28.8 31.8 28.8zm-80 48v32h32V176H176zm0 64v32h32V240H176zm32 64H176v32h32V304zm64-128H240v32h32V176zm-32 64v32h32V240H240zm32 64H240v32h32V304zm64-128H304v32h32V176zm-32 64v32h32V240H304zm32 64H304v32h32V304z"],
    "user-slash": [640, 512, [], "f506", "M544 512H528L264 304H160L96 512H544l0 0zM353.4 251.6C407.9 236.9 448 187.1 448 128C448 57.3 390.7 0 320 0C249.9 0 192.9 56.4 192 126.3L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L353.4 251.6z"],
    "pen": [512, 512, [128394], "f304", "M0 512L32 352 292.7 91.3l128 128L160 480 0 512zM443.3 196.7l-128-128L384 0 512 128l-68.7 68.7z"],
    "tower-observation": [512, 512, [], "e586", "M64 96L256 0 448 96v32H416V256H379.1l32 192H480h32v64H480 384.5c-.4 0-.8 0-1.1 0H128.6c-.4 0-.8 0-1.1 0H32 0V448H32h68.9l32-192H96V128H64V96zM314.5 448L256 399.2 197.5 448h117zM193.1 284.3L256 336.8l62.9-52.5L314.2 256H197.8l-4.7 28.3zm-9.1 54.9l-11.2 67L218.5 368l-34.6-28.8zM293.5 368l45.8 38.1-11.2-67L293.5 368zM352 128H160v32H352V128z"],
    "floppy-disks": [512, 512, [], "e183", "M96 0h24H384h9.9l7 7L505 111l7 7V128 392v24H488 120 96V392 24 0zM384 64H160v96H384V64zM368 288a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM48 120V464H392h24v48H392 24 0V488 120 96H48v24z"],
    "toilet-paper-blank-under": [512, 512, ["toilet-paper-reverse-alt"], "e29f", "M348.2 0H96C43 0 0 86 0 192S43 384 96 384H348.2c-11.6-12.2-21.1-26.9-28.7-41.9C299.5 302 288 248.9 288 192s11.5-110 31.5-150.1c7.5-15 17.1-29.7 28.7-41.9zM384 10.9c-37.3 26.4-64 97.5-64 181.1s26.7 154.7 64 181.1c10 7.1 20.8 10.9 32 10.9c35.5 0 66.6-38.6 83.2-96c8.2-28.2 12.8-61 12.8-96C512 86 469 0 416 0c-11.2 0-22 3.8-32 10.9zM416 256c-17.7 0-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64zM160 512H512V343.1c-19.1 37.8-51.2 72.9-96 72.9H160v96z"],
    "file-code": [384, 512, [], "f1c9", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM153 289l-31 31 31 31 17 17L136 401.9l-17-17L71 337l-17-17 17-17 48-48 17-17L169.9 272l-17 17zM265 255l48 48 17 17-17 17-48 48-17 17L214.1 368l17-17 31-31-31-31-17-17L248 238.1l17 17z"],
    "signal": [640, 512, [128246, "signal-5", "signal-perfect"], "f012", "M608 0V32 480v32H544V480 32 0h64zM480 96v32V480v32H416V480 128 96h64zM352 224V480v32H288V480 224 192h64v32zM224 288v32V480v32H160V480 320 288h64zM96 416v64 32H32V480 416 384H96v32z"],
    "pump": [640, 512, [], "e442", "M128 0V64h32H320h32V0H320 160 128zM64 176H0v32V384v32H64V384 208 176zm96 48H96V384H320V96H160V224zM448 96l-96 64V448l96 64H640V96H448zm0 96h16 96 16v32H560 464 448V192zm0 96h16 96 16v32H560 464 448V288zm0 96h16 96 16v32H560 464 448V384z"],
    "bus": [576, 512, [128653], "f207", "M288 0C412.8 0 512 48 512 48V96v32h32V256H512l0 192H480v64H384V448H192v64H96V448H64V96h0V48s99.2-48 224-48zM64 256H32V128H64l0 128zM304 128V288H448V128H304zm-32 0H128V288H272V128zM144 400a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm288 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM384 96V64H368 208 192V96h16H368h16z"],
    "heart-circle-xmark": [576, 512, [], "e501", "M64 288L39.8 263.8C14.3 238.3 0 203.8 0 167.8C0 92.8 60.8 32 135.8 32c36 0 70.5 14.3 96 39.8L256 96l24.2-24.2c25.5-25.5 60-39.8 96-39.8C451.2 32 512 92.8 512 167.8c0 13.8-2.1 27.4-6.2 40.4C483.4 197.8 458.4 192 432 192c-97.2 0-176 78.8-176 176c0 32.2 8.6 62.3 23.7 88.3L256 480 64 288zm368-64a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3L502.6 320 480 297.4l-11.3 11.3L432 345.4l-36.7-36.7L384 297.4 361.4 320l11.3 11.3L409.4 368l-36.7 36.7L361.4 416 384 438.6l11.3-11.3L432 390.6l36.7 36.7L480 438.6 502.6 416l-11.3-11.3L454.6 368l36.7-36.7z"],
    "arrow-up-left-from-circle": [512, 512, [], "e09e", "M32 0H0V32 192v32H64V192 109.3L297.4 342.6 320 365.3 365.3 320l-22.6-22.6L109.3 64H192h32V0H192 32zM288 128c88.4 0 160 71.6 160 160s-71.6 160-160 160s-160-71.6-160-160H64c0 123.7 100.3 224 224 224s224-100.3 224-224S411.7 64 288 64v64z"],
    "house-chimney": [576, 512, [63499, "home-lg"], "e3af", "M576 287.6H511.8l1 224.4H472 456 352V352H224V512H120 104 64.1V474.8c-.1-.9-.1-1.8-.1-2.8V360c0-.9 0-1.9 .1-2.8V287.6H0V240L288.4 0 416 106.5V32h96V186.6L576 240v47.6z"],
    "window-maximize": [512, 512, [128470], "f2d0", "M512 32H0V480H512V32zM448 96v64H64V96H448z"],
    "dryer": [448, 512, [], "f861", "M0 0H448V512H0V0zM368 304A144 144 0 1 0 80 304a144 144 0 1 0 288 0zM88 112a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM208 88a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM336 304c0 61.9-50.1 112-112 112c-56.4 0-103.1-41.7-110.9-96H176h16V288H176 113.1c7.8-54.3 54.4-96 110.9-96c61.9 0 112 50.1 112 112z"],
    "face-frown": [512, 512, [9785, "frown"], "f119", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM159.3 388.7L154.5 404 124 394.5l4.7-15.3C145.2 326.1 196.3 288 256 288s110.8 38.1 127.3 91.3l4.7 15.3L357.5 404l-4.7-15.3C340.5 349.4 302.1 320 256 320s-84.5 29.4-96.7 68.7zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "chess-bishop-piece": [256, 512, ["chess-bishop-alt"], "f43b", "M80 32h96V80H155.3c6.7 6.4 14.3 14.5 21.7 24.4l-44.3 44.3L121.4 160 144 182.6l11.3-11.3 38.8-38.8c8.2 17.1 13.9 37 13.9 59.5c0 26.3-13.6 40.5-26.3 48H184h24v48H184h-5.7L192 384H64l13.7-96H72 48V240H72h2.3C61.6 232.5 48 218.3 48 192c0-52.8 31.4-91.7 52.7-112H80V32zM43.9 416H48 208h4.1l2.4 3.4 40 56 1.5 2.1V480v24 8h-8H8 0v-8V480v-2.6l1.5-2.1 40-56 2.4-3.4z"],
    "shirt-tank-top": [384, 512, [], "e3c9", "M112 32V0H48V32 64 80v48L0 256V512H384V256L336 128V80 64 32 0H272V32 80c0 44.2-35.8 80-80 80s-80-35.8-80-80V32z"],
    "diploma": [640, 512, ["scroll-ribbon"], "f5ea", "M208 144V113l0-.5c.3-18 14.9-32.5 33-32.5c9.5 0 18.6 4.1 24.8 11.3L312 144H240 208zm120 0l46.1-52.7C380.4 84.1 389.5 80 399 80h1c17.7 0 32 14.3 32 32l0 .5 0 .5v31H400 328zm-72 64V316.2L97.7 347.8 64 280.4V208H256zM384 316.2V208H576v72.4l-33.7 67.4L384 316.2zm0 65.3l169.7 33.9 24 4.8 10.9-21.9 48-96 3.4-6.8V288 176 144H608 480V113c0-44.7-36.3-81-81-81c-23.4 0-45.6 10.1-61 27.7L320 80.3 302 59.7C286.6 42.1 264.4 32 241 32c-44.7 0-81 36.3-81 81v31H32 0v32V288v7.6l3.4 6.8 48 96 10.9 21.9 24-4.8L256 381.4V480l64-40 64 40V381.4z"],
    "screencast": [576, 512, [], "e23e", "M512 96H64V199.1C43.4 194.5 22 192 0 192V96 32H64 512h64V96 416v64H512 288c0-22-2.5-43.4-7.1-64H512V96zM0 272V224c141.4 0 256 114.6 256 256H208c0-114.9-93.1-208-208-208zM32 416a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm80 64c0-61.9-50.1-112-112-112V320c88.4 0 160 71.6 160 160H112z"],
    "walker": [448, 512, [], "f831", "M118.7 0H144 384h32V32 392.6c19.1 11.1 32 31.7 32 55.4c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4V224H131.5L71.1 479.4l-7.4 31.1L1.5 495.8l7.4-31.1 104-440L118.7 0zm27.9 160H352V64H169.3l-22.7 96zM384 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "prescription": [448, 512, [], "f5b1", "M32 0H0V32 192v96 32H64V288 224h50.7l128 128-89.4 89.4L130.7 464 176 509.3l22.6-22.6L288 397.3l89.4 89.4L400 509.3 445.3 464l-22.6-22.6L333.3 352l89.4-89.4L445.3 240 400 194.7l-22.6 22.6L288 306.7l-85.8-85.8C251.4 209.1 288 164.8 288 112C288 50.1 237.9 0 176 0H32zM176 160H64V64H176c26.5 0 48 21.5 48 48s-21.5 48-48 48z"],
    "shop": [640, 512, ["store-alt"], "f54f", "M0 192H640V128L544 0H96L0 128v64zM64 384V512H384V384 224H320V384H128V224H64V384zM512 512h64V224H512V512z"],
    "floppy-disk": [448, 512, [128190, 128426, "save"], "f0c7", "M32 32H0V64 448v32H32 416h32V448 160 146.7l-9.4-9.4-96-96L333.3 32H320 32zM64 96H320V224H64V96zM224 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "vihara": [640, 512, [], "f6a7", "M320 0s96 80 176 80h16v48H488h-8v64l21.3 16c27.7 20.8 61.4 32 96 32H608v48H544v64l38.4 28.8C599 393.3 619.2 400 640 400v48H576v32 32H512V480 448H352v32 32H288V480 448H128v32 32H64V480 448H0V400c20.8 0 41-6.7 57.6-19.2L96 352V288H32V240H42.7c34.6 0 68.3-11.2 96-32L160 192V128h-8H128V80h16C224 80 320 0 320 0zM160 352H480V288H160v64zM416 128H344 320 296 224v64H416V128z"],
    "face-kiss-closed-eyes": [512, 512, [], "e37d", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm48.7-198.3c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448l-3.9-15 0 0 0 0 0 0 0 0 .2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1 0 0 0 0 0 0 0 0V361l0 0 0 0 0 0 0 0 .2-.1 .3-.2 .6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3-.5-.3-.2-.1 0 0 0 0 0 0 0 0 3.9-15c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4zm-85.5-76.1c-21.6-28.8-64.8-28.8-86.4 0l-25.6-19.2c34.4-45.9 103.2-45.9 137.6 0l-25.6 19.2zm73.6 0l-25.6-19.2c34.4-45.9 103.2-45.9 137.6 0l-25.6 19.2c-21.6-28.8-64.8-28.8-86.4 0z"],
    "scale-unbalanced": [640, 512, ["balance-scale-left"], "f515", "M388.9 39.3l113-37.7 20.2 60.7-125.9 42c-7 22-23.3 39.9-44.2 49V448H512h32v64H512 320 288V480 153.3c-5.1-2.2-9.9-5-14.4-8.2L138.1 190.4l-30.4 10.1L87.5 139.8l30.4-10.1L240.5 88.8c-.3-2.9-.5-5.8-.5-8.8c0-44.2 35.8-80 80-80c29.3 0 55 15.8 68.9 39.3zM112 224h32 14.5l6.7 12.9 88 168 2.7 5.2V416l0 32 0 9.9-7 7-40 40-7 7H192 64 54.1l-7-7L7 465l-7-7V448 416v-5.9l2.7-5.2 88-168L97.5 224H112zM51.1 416H204.9L129.5 272h-3L51.1 416zM481.5 96H496h32 14.5l6.7 12.9 88 168 2.7 5.2V288v32 9.9l-7 7-40 40-7 7H576 448h-9.9l-7-7-40-40-7-7V320 288v-5.9l2.7-5.2 88-168L481.5 96zm29 48L435.1 288H588.9L513.5 144h-3z"],
    "file-user": [384, 512, [], "f65c", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM128 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm144 96l32 96H80l32-96H272z"],
    "user-police-tie": [448, 512, [], "e334", "M80 99.2V128c16 10.7 67.2 32 144 32s128-21.3 144-32V99.2L400 80V48L224 0 48 48V80L80 99.2zM227 48.6l32 12.8 5 2v5.4c0 17.2-7 46.1-36.9 58.6l-3.1 1.3-3.1-1.3C191 114.9 184 86 184 68.8V63.4l5-2 32-12.8 3-1.2 3 1.2zM98.1 168.8C96.7 176.3 96 184.1 96 192c0 70.7 57.3 128 128 128s128-57.3 128-128c0-7.9-.7-15.7-2.1-23.2C310.8 183.8 268.4 192 224 192s-86.8-8.2-125.9-23.2zm97.7 296.1L128 352H48L0 512l192 0h64l192 0L400 352H320L252.2 464.9 240 416l32-64H176l32 64-12.2 48.9zm160.8-50.4l6.1 18.8 19.8 0 14.9 0L385.2 442l-16 11.6 6.2 18.8 4.6 14.1-12-8.8-16-11.7-16 11.7-12 8.8 4.6-14.1 6.2-18.8-16-11.6-12.1-8.7 14.9 0 19.8 0 6.1-18.8 4.6-14.2 4.6 14.2z"],
    "face-tongue-money": [512, 512, [], "e39d", "M0 256C0 364.6 67.7 457.5 163.1 494.6C151.1 476.8 144 455.2 144 432V418.3c-26-25.5-43.4-59.9-47.2-98.3H415.2c-3.8 38.4-21.2 72.7-47.2 98.3V432c0 23.2-7.1 44.8-19.1 62.6C444.3 457.5 512 364.6 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zM192.4 102.6v7.3c5.3 .9 10.4 2 15.1 3.2l15.5 3.9-7.7 31.1-15.5-3.9c-8.4-2.1-16.4-3.6-23.7-3.7c-5.5-.1-12 1.1-16.3 3.5c-2 1.1-3 2.1-3.3 2.6c-.2 .3-.5 .9-.5 2.4c0 .3 0 .3 .1 .4l0 0c.3 .4 1.2 1.3 3.5 2.5c4.9 2.7 11.9 4.6 21.4 7.3l.2 .1c8.4 2.4 19.3 5.4 28 10.6c9.6 5.6 18.9 15.2 19.3 30.6c.5 17.3-9.2 28.8-20.5 34.9c-5 2.7-10.5 4.5-15.8 5.6v8.6 16h-32v-16-9.2c-7.5-1.6-14.5-3.8-20.6-5.8c-1.6-.5-3.1-1-4.5-1.4L120 228.3l9.5-30.6 15.3 4.8c1.8 .6 3.6 1.1 5.3 1.7l0 0 0 0 0 0 0 0c10.4 3.3 18.4 5.8 26.8 6.1c6 .2 12.1-1 16.1-3.1c1.8-1 2.7-1.9 3.1-2.5c.3-.5 .8-1.4 .7-3.3l0-.1c0-.6 0-1.7-3.6-3.8c-4.6-2.7-11.3-4.8-20.7-7.4l-1.6-.5c-8-2.3-18.1-5.1-26.3-9.5c-9.2-5-19.4-13.8-20.4-29.1c-1.1-17.9 9.5-29.3 20.6-35.2c5-2.7 10.4-4.5 15.6-5.6v-7.5-16h32v16zm160-16v16 7.3c5.3 .9 10.4 2 15.1 3.2l15.5 3.9-7.7 31.1-15.5-3.9c-8.4-2.1-16.4-3.6-23.7-3.7c-5.5-.1-12 1.1-16.3 3.5c-2 1.1-3 2.1-3.3 2.6c-.2 .3-.5 .9-.5 2.4c0 .3 0 .3 .1 .4l0 0c.3 .4 1.2 1.3 3.5 2.5c4.9 2.7 11.9 4.6 21.4 7.3l.2 .1c8.4 2.4 19.3 5.4 28 10.6c9.6 5.6 18.9 15.2 19.4 30.6c.5 17.3-9.2 28.8-20.5 34.9c-5 2.7-10.5 4.5-15.8 5.6v8.6 16h-32v-16-9.2c-7.5-1.6-14.5-3.8-20.6-5.8l0 0 0 0c-1.6-.5-3.1-1-4.5-1.4L280 228.3l9.5-30.6 15.3 4.8c1.8 .6 3.6 1.1 5.3 1.7c10.4 3.3 18.4 5.8 26.8 6.1c6 .2 12.1-1 16.1-3.1c1.8-1 2.7-1.9 3.1-2.5c.3-.5 .8-1.4 .7-3.3l0-.1c0-.6 0-1.7-3.6-3.8c-4.6-2.7-11.3-4.8-20.7-7.4l-1.6-.5c-8-2.3-18.1-5.1-26.3-9.5c-9.2-5-19.4-13.8-20.4-29.1c-1.1-17.9 9.5-29.3 20.6-35.2c5-2.7 10.4-4.5 15.6-5.6v-7.5-16h32zM336 352H176v80c0 44.2 35.8 80 80 80s80-35.8 80-80V352zm-67.3 16v15.6c3.1 .5 6.2 1.2 9 1.9l11.6 2.9-5.8 23.3-11.6-2.9c-5.5-1.4-10.7-2.3-15.3-2.4c-3.5-.1-7.5 .7-10.1 2.1c-1.2 .6-1.6 1.2-1.7 1.3c0 0 0 .1 0 .1s0 .1 0 .3c.2 .2 .8 .6 1.7 1.1c3.1 1.7 7.5 2.9 13.9 4.7l.2 .1 0 0c5.5 1.6 12.9 3.6 18.8 7.1c6.6 3.9 13.2 10.6 13.5 21.4c.3 12.1-6.4 20.1-14.3 24.4c-3.1 1.7-6.4 2.9-9.7 3.6v16.6h-24v-17c-4.6-1-9-2.4-12.7-3.6c-1-.3-2-.7-3-.9l-11.5-3.6 7.1-22.9 11.5 3.6c1.2 .4 2.4 .8 3.5 1.1l0 0 0 0c6.9 2.2 12 3.8 17.3 3.9c3.8 .1 7.6-.6 9.9-1.9c1-.6 1.4-1 1.5-1.2c.1-.1 .3-.4 .2-1.4l0-.1c-.1-.1-.5-.6-1.7-1.3c-2.9-1.7-7.1-3-13.4-4.8l-1.1-.3 0 0c-5.3-1.5-12.1-3.4-17.7-6.4c-6.3-3.4-13.6-9.6-14.2-20.4c-.8-12.5 6.7-20.6 14.4-24.7c3.1-1.6 6.4-2.8 9.6-3.6V368h24z"],
    "tennis-ball": [512, 512, [127934], "f45e", "M.2 245.1C.1 248.7 0 252.3 0 256C0 397.4 114.6 512 256 512c3.7 0 7.3-.1 10.9-.2c-3.8-10.7-6.6-21.8-8.4-33.1c-4.4-27.2-2.9-55 4.4-81.6s20.2-51.2 37.9-72.4s39.7-38.2 64.5-50.1s52-18.2 79.5-18.7c22.8-.4 45.5 3.3 67 10.9c.2-3.6 .2-7.2 .2-10.9C512 114.6 397.4 0 256 0c-3.7 0-7.3 .1-10.9 .2c10.7 30.5 13.7 63.4 8.2 95.6c-7.1 42.4-28.3 81.2-60 110.1s-72.4 46.4-115.2 49.6c-26.6 2-53.1-1.7-77.9-10.4zM206.8 4.7C104.9 24.6 24.6 104.9 4.7 206.8C26.9 216 51.1 220 75.3 218.2c34.5-2.5 67.2-16.6 92.8-39.9s42.6-54.5 48.4-88.7c4.8-28.7 1.4-58.2-9.7-84.9zM445.4 293.4c-22.2 .4-44 5.5-64 15.1s-37.7 23.3-52 40.3s-24.6 36.9-30.5 58.3s-7.1 43.8-3.5 65.7c1.9 11.9 5.2 23.5 9.8 34.6c101.9-19.8 182.2-100.2 202.1-202.1c-19.6-8.1-40.6-12.1-61.9-11.8z"],
    "square-l": [448, 512, [], "e275", "M448 32H0V480H448V32zM176 152V336H296h24v48H296 152 128V360 152 128h48v24z"],
    "sort-up": [320, 512, ["sort-asc"], "f0de", "M0 176L160 32 320 176v48H0V176z"],
    "calendar-arrow-up": [448, 512, ["calendar-upload"], "e0d1", "M160 0V64H288V0h64V64h96v96H0V64H96V0h64zM0 192H448V512H0V192zM248 424V321.9l39 39 17 17L337.9 344l-17-17-80-80-17-17-17 17-80 80-17 17L144 377.9l17-17 39-39V424v24h48V424z"],
    "comment-dots": [512, 512, [128172, 62075, "commenting"], "f4ad", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM128 272a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "plant-wilt": [512, 512, [], "e5aa", "M288 120c0-30.9 25.1-56 56-56s56 25.1 56 56v13c-29.3 10-48 34.5-48 70.1c0 29.3 35.8 79.4 80 116.9c44.2-37.5 80-88 80-116.9c0-35.6-18.7-60.2-48-70.1V120C464 53.7 410.3 0 344 0S224 53.7 224 120v21.8C207.3 133 188.2 128 168 128c-66.3 0-120 53.7-120 120v13c-29.3 10-48 34.5-48 70.1C0 360.4 35.8 410.5 80 448c44.2-37.5 80-88 80-116.9c0-35.6-18.7-60.2-48-70.1V248c0-30.9 25.1-56 56-56s56 25.1 56 56v32V480v32h64V480 280 248 120z"],
    "scarf": [512, 512, [129507], "f7c1", "M184 0h-8.7l-4.7 7.3-72 112-2.5 4V128v80 6.6l4.7 4.7 176 176 112 112 22.6-22.6L310.6 384 336 358.6 436.7 459.3l22.6-22.6L358.6 336 384 310.6 484.7 411.3l22.6-22.6-112-112L384 265.4l-9.4-9.4L256 137.4 214.6 96H256h41.4l-18.7 18.7L397.3 233.4l14.1-14.1 4.7-4.7V208 128v-4.7l-2.5-4-72-112L336.7 0H328 184zM4.7 388.7l22.6 22.6 112-112-22.6-22.6-112 112zm48 48l22.6 22.6 112-112-22.6-22.6-112 112zm48 48l22.6 22.6 112-112-22.6-22.6-112 112z"],
    "album-circle-plus": [576, 512, [], "e48c", "M0 32H448V192.7c-5.3-.5-10.6-.7-16-.7c-20.1 0-39.5 3.4-57.5 9.6C352.3 140 293.3 96 224 96C135.6 96 64 167.6 64 256s71.6 160 160 160c12.9 0 25.4-1.5 37.4-4.4c6.5 25.5 18.5 48.7 34.8 68.4H0V32zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm208 0a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80V288H416v16 48H368 352v32h16 48v48 16h32V432 384h48 16V352H496 448V304z"],
    "user-nurse-hair-long": [448, 512, [], "e45e", "M96 48v80h.3c-.2 2.6-.3 5.3-.3 8v24 16 0 48L48 272v32H224 400V272l-48-48V176 160 136c0-2.7-.1-5.4-.3-8h.3V48L224 0 96 48zm48 128h64l32-32 16 16h48v16c0 44.2-35.8 80-80 80s-80-35.8-80-80zM208 40h32V64h24V96H240v24H208V96H184V64h24V40zm16 384l-82.8-88H64L0 512H448L384 336H306.8L224 424z"],
    "diamond": [512, 512, [9830], "f219", "M0 256L256 0 512 256 256 512 0 256z"],
    "square-left": [448, 512, [11013, "arrow-alt-square-left"], "f351", "M0 32L0 480l448 0 0-448L0 32zm224 96l0 80 128 0 0 96-128 0 0 80-32 0L64 256 192 128l32 0z"],
    "face-grin-squint": [512, 512, [128518, "grin-squint"], "f585", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm.3-180.2c59.1 0 114.1-10.6 160.2-29C400.3 376.7 334.7 432 256.3 432s-144-55.3-160.2-129.2c46.2 18.3 101.2 29 160.2 29zM112 144l118.9 64L112 272l45.7-64L112 144zm169.1 64L400 144l-45.7 64L400 272 281.1 208z"],
    "circle-ellipsis-vertical": [512, 512, [], "e10b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm32-320H224V128h64v64zm0 192H224V320h64v64zm0-160v64H224V224h64z"],
    "hand-holding-dollar": [576, 512, ["hand-holding-usd"], "f4c0", "M312 32V8H264V32v2.8c-4.7 1.2-9.3 2.7-13.6 4.7c-15.8 7.2-30 20.7-33.4 40.7c-1.9 10.9-.9 21.6 3.7 31.4c4.5 9.6 11.6 16.3 18.7 21.1c12.1 8.2 28 13 39.6 16.5l2.3 .7c14.1 4.3 22.8 7.3 28.1 11.1c2 1.5 2.4 2.3 2.4 2.4l0 0c0 .1 .1 .3 .2 .9c.1 .6 .1 1.7-.2 3.5c-.3 1.9-1.2 3.9-5.6 5.8c-5.2 2.2-14.3 3.5-26.6 1.6c-5.7-.9-15.9-4.4-25.4-7.6l0 0c-2.3-.8-4.5-1.5-6.6-2.2l-22.8-7.6-15.2 45.5 22.8 7.6c1.1 .4 2.6 .9 4.2 1.4l0 0 0 0c7 2.4 18 6.2 27.3 8.5V224l0 24h48V224v-2.2c4.5-1 8.9-2.4 13-4.2c16.7-7.2 30.5-21.1 34-41.7c1.9-11 1.1-21.8-3.2-31.7c-4.3-9.8-11.1-16.9-18.2-22.1c-12.7-9.2-29.4-14.3-41.4-17.9l-1-.3c-14.4-4.3-23.3-7.2-28.8-10.9c-1.5-1-2.1-1.7-2.2-1.9c-.1-.3-.1-1.1 .2-2.7l0 0c.1-.3 .5-2.6 5.9-5.1c5.6-2.5 14.7-4.1 26.4-2.3c4.3 .7 17.6 3.3 21.3 4.3L341 91.4 353.4 45l-23.2-6.2c-3.9-1-11.8-2.6-18.2-3.9V32zM264.1 91.2a.1 .1 0 1 0 .1-.1 .1 .1 0 1 0 -.1 .1zM140 327L68.8 384H0V512H32 224 384h12.4l10.2-7 128-88 33-22.7-45.3-65.9-33 22.7-94.5 65H256V384h32 64 32V320H352 288 224 160 148.8l-8.8 7z"],
    "grid-dividers": [512, 512, [], "e3ad", "M0 0H512V48H0V0zM160 96V224H32V96H160zm0 288V512H32V384H160zM192 96H320V224H192V96zM320 384V512H192V384H320zM352 96H480V224H352V96zM480 384V512H352V384H480zm32-96v48H0V288H512z"],
    "bacterium": [512, 512, [], "e05a", "M422.8 39.6l7.6-22.8L384.8 1.6l-7.6 22.8-2.6 7.8c-10.4-.6-21.1 .2-31.8 2.7c-12.1 2.8-23.7 5.9-34.9 9.4l-5.9-13.7L292.6 8.5 248.5 27.4l9.5 22.1 4.9 11.3c-22 9.4-42 20.1-60.2 31.8L196 82.7l-13.3-20L142.7 89.3l13.3 20 7.8 11.6c-18 15-33.7 30.8-47.3 47.1L103 157.3l-18.7-15-30 37.5 18.7 15 15 12c-2.1 3.2-4.1 6.5-6 9.7c-9.4 15.7-17 31-23.2 45.3l-9.9-3.9-22.3-8.9L8.8 293.4l22.3 8.9 11.6 4.6c-.3 1.1-.6 2.1-.9 3.1c-3.5 12.5-5.7 23.2-7.1 31.3c-.7 4.1-1.2 7.5-1.6 10.3c-.2 1.4-.3 2.6-.4 3.6l-.1 1.4-.1 .6 0 .3 0 .1c0 0 0 .1 39.2 3.7l0 0-39.2-3.6c-.5 5-.6 10-.4 14.9l-14.7 4.2-23.1 6.6L7.5 429.7l23.1-6.6 13.8-3.9C54.7 439.3 71 456 91.1 466.8l-1.9 5.6-7.6 22.8 45.5 15.2 7.6-22.8 2.6-7.8c24.5 1.5 47.7-5.1 67-17.5L215 473l17 17L265.9 456l-17-17-10.6-10.6c9.1-14.1 15.1-30.5 17-48.3l.1-.8c.3-1.7 1-5.1 2.3-9.8l.2-.8 12.6 5.4 22.1 9.5 18.9-44.1-22.1-9.5-11.3-4.8c9.9-14.9 24.9-31.6 48.6-46l2.1 7.5 6.6 23.1 46.2-13.2-6.6-23.1L371 259.2c6.9-2.2 14.3-4.3 22.2-6.1c12.9-3 24.7-8 35.2-14.8L439 249l17 17L489.9 232l-17-17-10.6-10.6c12.2-19 18.6-41.6 17.6-65.1l14.7-4.2 23.1-6.6L504.5 82.3l-23.1 6.6-13.7 3.9c-10.5-20.6-27-37-46.8-47.6l1.9-5.7zM99.2 363.9l0 0L144 368l-44.8-4.1zM112 320a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM240 184a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "hand-pointer": [448, 512, [], "f25a", "M128 0h80V176h80v32h80v32h80v80 48 16c0 70.7-57.3 128-128 128l-16 0H240l-.1 0h-5.2c-5 0-9.9-.3-14.7-1c-55.3-5.6-106.2-34-140-79L24.1 357.4l-24-32 64-48 24 32L128 362.7V0zM240 304V288H208v16 96 16h32V400 304zm64-16H272v16 96 16h32V400 304 288zm64 16V288H336v16 96 16h32V400 304z"],
    "drum-steelpan": [576, 512, [], "f56a", "M473 209.8c-22.2 9.4-49.7 17-81 22.2L353.9 176l57.4-84.3c23.4 4.9 44.2 11.2 61.7 18.6c47.1 19.9 55 39.9 55 49.8s-8 29.9-55 49.8zM340.7 238.1c-16.9 1.3-34.5 1.9-52.7 1.9s-35.8-.7-52.7-1.9L249.9 192h76.2l14.6 46.1zm-156.6-6.1c-31.4-5.2-58.8-12.8-81-22.2C56 189.9 48 169.9 48 160s8-29.9 55-49.8c17.5-7.4 38.3-13.7 61.7-18.6L222.1 176l-38 55.9zM225.5 82.8C245.3 81 266.2 80 288 80s42.7 1 62.5 2.8L326.1 160H249.9L225.5 82.8zM576 160C576 80 447.1 32 288 32S0 80 0 160V352c0 80 128.9 128 288 128s288-48 288-128V160z"],
    "hand-scissors": [512, 512, [], "f257", "M40 208L0 208l0 80 40 0 168 0 0 80 32 0 0 80 80 0 48 0 16 0c70.7 0 128-57.3 128-128l0-113.1c0-40.2-16-78.8-44.4-107.3C444.8 76.8 413.9 64 381.7 64L288 64l0 32.3 76.9 24.5 15.2 4.9-9.7 30.5-15.2-4.9L288 129.9l0 .1L108 73.4l-38.2-12-24 76.3 38.2 12L269.5 208 40 208z"],
    "hands-praying": [640, 512, ["praying-hands"], "f684", "M117 206.8L245 6.8l55 32.6L208 208.2V320h32V208h64V320 432L48 512H0V368l112-42V224v-9.4l5-7.9zm405.9 0l5 7.9V224 326l112 42V512H592L336 432V320 208h64V320h32V208.2L339.9 39.3 395 6.8l128 200z"],
    "face-pensive": [512, 512, [], "e384", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 384h96 16v32H304 208 192V384h16zM72.8 193.7l22.9-11.4c14.5-7.2 27.2-17.6 37.4-30.2l14.4-18 25 20-14.4 18c-13 16.3-29.4 29.5-48 38.8L87.2 222.3 72.8 193.7zm236 72.7c21.6 28.8 64.8 28.8 86.4 0l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2zm-105.6 0l25.6 19.2c-34.4 45.9-103.2 45.9-137.6 0l25.6-19.2c21.6 28.8 64.8 28.8 86.4 0zm213.1-84.1l22.9 11.4-14.3 28.6L402 210.9c-18.6-9.3-35-22.6-48.1-38.8l-14.4-18 25-20 14.4 18c10.1 12.7 22.9 23 37.4 30.2z"],
    "user-music": [640, 512, [], "f8eb", "M224 0a128 128 0 1 1 0 256A128 128 0 1 1 224 0zm64 463.8c0 19.1 7.8 35.6 19.1 48.2H0L64 304H368v80.9c-18 2.5-34.8 9.1-48.5 19.4c-17.6 13.2-31.5 34-31.5 59.5zM640 152v33.3 48 160c0 1.2-.1 2.4-.3 3.6c.2 1.5 .3 2.9 .3 4.4c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48c5.5 0 10.9 .5 16 1.5V266.6l-144 48V465.3c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48c5.5 0 10.9 .5 16 1.5V297.3v-48V232l16.4-5.5 192-64L640 152z"],
    "arrow-rotate-right": [512, 512, [8635, "arrow-right-rotate", "arrow-rotate-forward", "redo"], "f01e", "M464 224h32V192 64 32H432V64v51.2L414.4 97.6c-87.5-87.5-229.3-87.5-316.8 0s-87.5 229.3 0 316.8s229.3 87.5 316.8 0l-45.3-45.3c-62.5 62.5-163.8 62.5-226.3 0s-62.5-163.8 0-226.3s163.8-62.5 226.3 0L386.3 160H336 304v64h32H464z"],
    "messages-dollar": [640, 512, ["comments-alt-dollar"], "f652", "M416 0H0V320H96v64l106.7-64H416V0zM256 352v96H437.3L544 512V448h96V128H448V352H256zM228 64v6.3c6.6 1.2 16.7 3.2 21.1 4.4l19.3 5.1-10.3 38.7-19.3-5.1c-3.8-1-17.4-3.7-21.7-4.3c-12.2-1.9-22.2-.3-28.6 2.6c-6.3 2.9-7.9 6.2-8.2 8.1c-.6 3.4 0 4.7 .1 5c.3 .5 1 1.8 3.6 3.5c6.1 4.2 15.7 7.2 29.9 11.4l.8 .2 0 0 0 0c12.1 3.7 28.3 8.5 40.4 17.4c6.7 4.9 13 11.4 16.9 20.5c4 9.1 4.8 19.1 3 29.4c-3.3 19-15.9 32-31.6 38.7c-4.9 2.1-10.1 3.6-15.4 4.6V256v20H188V256v-6.4c-9.5-2.2-22-6.4-29.9-9.1l0 0c-1.7-.6-3.2-1.1-4.4-1.5l-19-6.3 12.6-38 19 6.3c2 .7 4.2 1.4 6.4 2.1l0 0c9.5 3.2 20.2 6.9 26.2 7.9c12.8 2 22.7 .7 28.8-1.9c5.5-2.3 7.4-5.3 8-8.8c.7-4 .1-5.9-.2-6.7c-.4-.9-1.3-2.2-3.7-4c-5.9-4.3-15.3-7.5-29.3-11.7l-2.2-.7c-11.7-3.5-27-8.1-38.6-16c-6.6-4.5-13.2-10.7-17.3-19.5c-4.2-9-5.2-18.8-3.4-29c3.2-18.3 16.2-30.9 31.1-37.7c5-2.3 10.4-4 16-5.1V64 44h40V64z"],
    "sensor-on": [640, 512, [], "e02b", "M0 32H448V480H0V32zM112 96H64v24V264v24h48V264 120 96zm96 0H160v24V264v24h48V264 120 96zm389.3 12l-48 32-20 13.3-26.6-39.9 20-13.3 48-32 20-13.3 26.6 39.9-20 13.3zM536 232h80 24v48H616 536 512V232h24zm13.3 140l48 32 20 13.3-26.6 39.9-20-13.3-48-32-20-13.3 26.6-39.9 20 13.3z"],
    "balloon": [384, 512, [], "e2e3", "M0 192C0 86 86 0 192 0S384 86 384 192c0 128-160 240-160 240l32 80H128l32-80S0 320 0 192zm96 0c0-53 43-96 96-96V64C121.3 64 64 121.3 64 192H96z"],
    "biohazard": [576, 512, [9763], "f780", "M167.2 3.2C138 33.4 120 74.6 120 120c0 26.1 6 50.8 16.6 72.9c-22.4 2.3-44.6 9-65.3 20.6c-33.7 18.8-58 47.3-71.3 79.7c57.1-48 153.9-53.7 204.4 30.8s-2.9 162.6-74.6 186.3c35.7 5.1 73.5-.9 107.2-19.7c20.6-11.5 37.7-26.6 50.9-44c13.2 17.4 30.3 32.6 50.9 44c33.7 18.8 71.5 24.8 107.2 19.7C374.5 486.6 321 408.6 371.6 324s147.4-78.8 204.4-30.8c-13.3-32.4-37.6-60.9-71.3-79.7c-20.7-11.5-43-18.3-65.3-20.6C450 170.8 456 146.1 456 120c0-45.4-18-86.6-47.2-116.8C433.9 77.9 393.6 176 288 176S142.1 77.9 167.2 3.2zM240 272a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM288 64c-32.2 0-62.6 7.3-89.8 20.3c2.1 5.9 4.8 11.6 7.9 16.9c8.3 13.9 20.5 26 37.3 33.8c14-4.6 29-7 44.6-7s30.6 2.5 44.6 7c16.8-7.7 29-19.8 37.3-33.8c3.2-5.3 5.8-11 7.9-16.9C350.6 71.3 320.2 64 288 64zM191.4 378.8c-20.5-18.6-35.6-42.9-42.8-70.5c-14.6-10.8-30.6-16.1-46.6-17.5c-7-.6-14.1-.4-21.1 .5c5.9 63.9 40.7 119.5 91.2 153.5c4.8-5.8 8.9-12.1 12.1-18.7c6.6-13.7 9.9-29.6 7.2-47.2zm303.7-87.5c-7-.9-14.1-1-21.1-.5c-16 1.3-32.1 6.7-46.6 17.5c-7.2 27.6-22.3 52-42.8 70.5c-2.7 17.6 .6 33.5 7.2 47.2c3.2 6.6 7.3 12.9 12.1 18.7c50.5-34 85.3-89.5 91.2-153.5z"],
    "chess-queen-piece": [256, 512, ["chess-queen-alt"], "f446", "M152 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM48 416H43.9l-2.4 3.4-40 56L0 477.4V480v24 8H8 248h8v-8V480v-2.6l-1.5-2.1-40-56-2.4-3.4H208 48zM66.5 192H48v48H72h5.1L59.8 384H196.2L178.9 240H184h24V192H189.5L240 92 219 78l-4.6 4.6c-6 6-14.5 10.3-22.3 7.1c-11-4.5-15-15.1-15-25.7H149s0 21-21 21s-21-21-21-21H79c0 10.6-4 21.2-15 25.7c-7.8 3.2-16.3-1.1-22.3-7.1L37 78 16 92 66.5 192z"],
    "location-crosshairs": [512, 512, ["location"], "f601", "M288 0V32 66.7C368.4 80.1 431.9 143.6 445.3 224H480h32v64H480 445.3C431.9 368.4 368.4 431.9 288 445.3V480v32H224V480 445.3C143.6 431.9 80.1 368.4 66.7 288H32 0V224H32 66.7C80.1 143.6 143.6 80.1 224 66.7V32 0h64zM128 256a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm128-80a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "mars-double": [640, 512, [9891], "f227", "M320 32H448V160l-32 32-41.4-41.4L321 204.2c19.5 28.4 31 62.7 31 99.8c0 97.2-78.8 176-176 176S0 401.2 0 304s78.8-176 176-176c37 0 71.4 11.4 99.8 31l53.6-53.6L288 64l32-32zM288 304A112 112 0 1 0 64 304a112 112 0 1 0 224 0zm16 164c18.9-14.8 35.2-32.8 48.1-53.1c5.2 .7 10.6 1.1 16 1.1c61.9 0 112-50.1 112-112c0-35.7-16.7-67.5-42.7-88L480 173.3V146.7l41.4-41.4L480 64l32-32H640V160l-32 32-41.4-41.4L513 204.2c19.5 28.4 31 62.7 31 99.8c0 97.2-78.8 176-176 176c-22.6 0-44.2-4.3-64-12z"],
    "house-person-leave": [640, 512, ["house-leave", "house-person-depart"], "e00f", "M375.7 117.6L240 0 0 208v48H64V416H317.5l44-44L384 315.7l3.9-9.7-9.7-3.2-60.7-20.2L287 272.5l10.1-30.4 30.6-91.7 4.5-13.4 12.9-5.7 30.6-13.6zM128 192h96v96H128V192zM528 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-75.7 30.6l-9.3 4.1-72 32-12.9 5.7-4.5 13.4-16 48-10.1 30.4 60.7 20.2 10.1-30.4 11.5-34.6 36.7-16.3-17 63.6c-5.6 21.1-.1 43.6 14.7 59.7l70.9 77.4 22 80.5 8.4 30.9 61.7-16.8-8.4-30.9-24-88-2-7.5-5.2-5.7-52.3-57 18.4-62.4 13.7 27.4 4.8 9.5 9.5 4.8 48 24 28.6-57.2-38.5-19.2-35.2-70.5-7-14-15.3-3.1-80-16-10-2zm-38.6 209l-25 62.4-43.4 43.4L322.7 464 368 509.3l22.6-22.6 48-48 4.6-4.6 2.4-6.1 15.7-39.3-40.7-44.4c-2.5-2.7-4.8-5.6-7-8.6z"],
    "ruler-triangle": [512, 512, [128208], "f61c", "M0 0V512H512V464l-60.7-60.7-24 24L416 438.6 393.4 416l11.3-11.3 24-24-57.4-57.4-24 24L336 358.6 313.4 336l11.3-11.3 24-24-57.4-57.4-24 24L256 278.6 233.4 256l11.3-11.3 24-24-57.4-57.4-24 24L176 198.6 153.4 176l11.3-11.3 24-24L131.3 83.3l-24 24L96 118.6 73.4 96 84.7 84.7l24-24L48 0H0zM128 256L256 384H128V256z"],
    "card-club": [384, 512, [], "e3e9", "M384 0H0V512H384V0zM256 192c0 5.6-.7 11.1-2.1 16.3c28.2 2.9 50.1 26.8 50.1 55.7c0 30.9-25.1 56-56 56c-15.7 0-29.8-6.4-40-16.8V336h16 16v32H224 208 176 160 144V336h16 16V303.2c-10.2 10.4-24.3 16.8-40 16.8c-30.9 0-56-25.1-56-56c0-28.9 21.9-52.7 50.1-55.7c-1.4-5.2-2.1-10.7-2.1-16.3c0-35.3 28.7-64 64-64s64 28.7 64 64z"],
    "child-dress": [320, 512, [], "e59c", "M96 64a64 64 0 1 1 128 0A64 64 0 1 1 96 64zm4.9 96h16 86.2 16l9.6 12.8 72.1 96L320 294.4l-51.2 38.4-19.2-25.6-15.3-20.4L272 400H232v80 32H168V480 400H152v80 32H88V480 400H48L85.7 286.8 70.4 307.2 51.2 332.8 0 294.4l19.2-25.6 72.1-96 9.6-12.8z"],
    "users-between-lines": [640, 512, [], "e591", "M0 0V48H24 616h24V0H616 24 0zM0 464v48H24 616h24V464H616 24 0zM211.2 160a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM64 256L32 352H167.4l28.2-75.2 7.8-20.8H64zm411.8 96H608l-32-96H439.8l7.8 20.8L475.8 352zm-10.2 64l-24-64-24-64H405.3 234.7h-9.1l-24 64-24 64h288zm97.6-256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM321.6 256a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "lungs-virus": [640, 512, [], "e067", "M352 32V64v80H288V64 32 0h64V32zm-96 96v60.1l-26.5-26.5-67.9 67.9 32.7 32.7c3.6 3.6 1.1 9.8-4.1 9.8H144v96h46.2c5.1 0 7.7 6.2 4.1 9.8l-32.7 32.7 68.9 68.9-119.9 30c-7.1 1.8-14.3 2.7-21.6 2.7c-49.1 0-89-39.8-89-89v-7c0-1.3 .1-2.7 .2-4c8.8-70.6 45.5-147.2 78-203.9c16.5-28.9 32.4-53.6 44.3-71.1c5.9-8.8 10.8-15.7 14.3-20.6c1.7-2.4 3.1-4.3 4.1-5.6l1.1-1.5 .3-.4 .1-.1 0 0 0 0s0 0 25.6 19.2l-25.6-19.2L152 96h16 56 32v32zM529.4 509.3l-119.9-30 68.9-68.9-32.7-32.7c-3.6-3.6-1.1-9.8 4.1-9.8H496V272H449.8c-5.1 0-7.7-6.2-4.1-9.8l32.7-32.7-67.9-67.9L384 188.1V128 96h32 56 16l9.6 12.8L472 128c25.6-19.2 25.6-19.2 25.6-19.2l0 0 0 0 .1 .1 .3 .4 1.1 1.5c1 1.3 2.3 3.2 4.1 5.6c3.5 4.8 8.4 11.8 14.3 20.6c11.8 17.5 27.8 42.2 44.3 71.1c32.4 56.7 69.1 133.3 78 203.9c.2 1.3 .2 2.6 .2 4v7c0 49.1-39.8 89-89 89c-7.3 0-14.5-.9-21.6-2.7zM410.5 206.9l11.3 11.3 11.3 11.3-11.3 11.3C398.5 264.1 415 304 448 304h16v16 16H448c-33 0-49.5 39.9-26.2 63.2l11.3 11.3-11.3 11.3-11.3 11.3-11.3-11.3C375.9 398.5 336 415 336 448v16H320 304V448c0-33-39.9-49.5-63.2-26.2l-11.3 11.3-11.3-11.3 0 0-11.3-11.3 11.3-11.3C241.5 375.9 225 336 192 336H176V320 304h16c33 0 49.5-39.9 26.2-63.2l-11.3-11.3 11.3-11.3 0 0 11.3-11.3 11.3 11.3C264.1 241.5 304 225 304 192V176h16 16v16c0 33 39.9 49.5 63.2 26.2l11.3-11.3zM296 320a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm72 32a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "spinner-third": [512, 512, [], "f3f4", "M477.7 384c21.8-37.7 34.3-81.4 34.3-128C512 114.6 397.4 0 256 0V64c106 0 192 86 192 192c0 35-9.4 67.8-25.7 96l55.4 32z"],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", "M576 254.5c-2.3-.5-4.6-.9-6.9-1.3c-13.2-2.4-25.4-4.1-33.1-5.1c1.1 7.6 2.8 19.9 5.3 33.1c4.3 23.1 10.8 48.9 19.5 57.7c.4 .4 .7 .7 1.1 1.1c17.9 16.8 46.4 16.1 64.2-1.8c18.2-18.3 18.6-47.6 .7-65.6c-7.9-7.9-29.7-13.9-50.8-18zM549 370.5c-3.8-2.6-7.5-5.7-10.9-9.1c-8.7-8.7-13.7-20.5-16.6-28.7c-3.4-9.3-6.2-19.8-8.4-29.6c-4.4-19.7-7.4-40.1-8.8-50.6l-5.9-42 42 5.8 .1 0c7.4 1 19.7 2.7 33.2 5.1C556.8 96.4 449.7 0 320 0S83.2 96.4 66.3 221.5c13.5-2.4 25.8-4.1 33.2-5.1l.1 0 42-5.8-5.9 42c-1.5 10.5-4.4 30.9-8.8 50.6c-2.2 9.8-5 20.3-8.4 29.6c-3 8.2-8 20-16.6 28.7c-3.4 3.4-7.1 6.5-10.9 9.1C133 454.4 219.8 512 320 512s187-57.6 229-141.5zM78 339.8s0 0 0 0c.4-.4 .8-.7 1.1-1.1c8.7-8.8 15.2-34.6 19.5-57.7c2.5-13.2 4.2-25.4 5.3-33.1c0 0 0 0 0 0s0 0 0 0c-21 2.9-77.1 10.7-90.8 24.5c-17.9 18-17.5 47.3 .7 65.6C31.7 356 60.1 356.7 78 339.8zm242.2-8.1c59.1 0 114.1-10.6 160.2-29C464.3 376.7 398.7 432 320.3 432s-144-55.3-160.2-129.2c46.2 18.3 101.2 29 160.2 29zM240 152c28 0 56 40 56 80c0 0-28-32-56-32s-56 32-56 32c0-40 28-80 56-80zm104 80c0-40 28-80 56-80s56 40 56 80c0 0-28-32-56-32s-56 32-56 32z"],
    "phone": [512, 512, [128222, 128379], "f095", "M0 32L144 0l80 144-83.8 67c36.1 68.4 92.3 124.6 160.8 160.8L368 288l144 80L480 512H448C200.6 512 0 311.4 0 64L0 32z"],
    "computer-mouse-scrollwheel": [384, 512, ["mouse-alt"], "f8cd", "M384 0H0V352c0 88.4 71.6 160 160 160h64c88.4 0 160-71.6 160-160V0zM224 128v32 32H160V160 128 96h64v32z"],
    "calendar-xmark": [512, 512, ["calendar-times"], "f273", "M192 0V64H320V0h64V64h96v96H32V64h96V0h64zM32 192H480V512H32V192zM337 305l17-17L320 254.1l-17 17-47 47-47-47-17-17L158.1 288l17 17 47 47-47 47-17 17L192 449.9l17-17 47-47 47 47 17 17L353.9 416l-17-17-47-47 47-47z"],
    "child-reaching": [384, 512, [], "e59d", "M192 0a64 64 0 1 1 0 128A64 64 0 1 1 192 0zM176 384v96 32H112V480 238.8l-8.6-10.3-80-96L2.9 107.9l49.2-41L72.6 91.5 143 176h1 96 2.3l68.9-84.3L331.5 67 381 107.5l-20.3 24.8-78.5 96L272.7 240H272V480v32H208V480 384H176z"],
    "table-layout": [512, 512, [], "e290", "M512 32H0V480H512V32zM448 96v64H64V96H448zM64 224h64V416H64V224zm384 0V416H192V224H448z"],
    "narwhal": [640, 512, [], "f6fe", "M640 336c0-49-20.2-93.2-52.7-125.2L640 0 511.7 166.8c-15.5-4.4-31.8-6.8-48.6-6.8c-50.9 0-100.7 17.5-140.2 49.6L128 368V256l64-32V96L96 144 0 96V224l64 32v96c0 88.4 71.6 160 160 160H464c97.2 0 176-78.8 176-176zM496 280a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "ramp-loading": [448, 512, [], "f4d4", "M32 0H64 384h32V32 440.4l-64-128V64H96V312.4l-64 128V32 0zM352 384l52.4 104.8L416 512H390.1 384 64 57.9 32l11.6-23.2L96 384l32-64H320l32 64z"],
    "calendar-circle-plus": [576, 512, [], "e470", "M160 0H96V64H0v96H448V64H352V0H288V64H160V0zm96 368c0-91.8 70.3-167.2 160-175.3V192H0V512H330.8C285.6 480.1 256 427.5 256 368zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208v48h48 16v32H496 448v48 16H416V432 384H368 352V352h16 48V304 288h32v16z"],
    "toothbrush": [576, 512, [129701], "f635", "M0 160c0-35.3 28.7-64 64-64H288c37.7 0 40-33.2 40-64c57.4 0 120 31.6 120 96c0 53-43 96-96 96H64 0V160zm80 96v24V416h32V280 256h48v24V416h32V280 256h48v24V416h32V280 256h48v24V416h32V280 256h48v24V416H544h32v64H544 32 0V416H32V280 256H80z"],
    "border-inner": [448, 512, [], "f84e", "M0 416l64 0 0 64L0 480l0-64zm96 0l64 0 0 64-64 0 0-64zM96 32l64 0 0 64L96 96l0-64zM352 480l-64 0 0-64 64 0 0 64zm0-448l0 64-64 0 0-64 64 0zm96 448l-64 0 0-64 64 0 0 64zM0 32l64 0 0 64L0 96 0 32zM384 384l0-64 64 0 0 64-64 0zm0-288l0-64 64 0 0 64-64 0zM0 320l64 0 0 64L0 384l0-64zM384 192l0-64 64 0 0 64-64 0zM0 128l64 0 0 64L0 192l0-64zm0 96l32 0 160 0 0-160 0-32 64 0 0 32 0 160 160 0 32 0 0 64-32 0-160 0 0 160 0 32-64 0 0-32 0-160L32 288 0 288l0-64z"],
    "paw-claws": [512, 512, [], "f702", "M373.1 58.4L320 0V71.2c-18.3 9.8-34.3 28.9-42.5 53.6c-14.3 42.9 .3 86.2 32.6 96.8s70.1-15.6 84.4-58.5c4-11.9 5.7-23.9 5.5-35.1h0c0-25.7-9.6-50.6-26.9-69.6zM64 196.8V128L12.2 199.2C4.3 210.1 0 223.3 0 236.8V240H0c-.1 13.3 3.7 27.8 11.6 41.4c18.9 32.4 54 47.3 78.5 33.3s29.1-51.7 10.2-84.1C91.1 214.7 77.9 203 64 196.8zm384 0c-13.9 6.1-27.1 17.8-36.4 33.7c-18.9 32.4-14.3 70.1 10.2 84.1s59.7-.9 78.5-33.3c7.9-13.6 11.7-28.1 11.6-41.4h0v-3.2c0-13.5-4.3-26.7-12.2-37.6L448 128v68.8zM192 0L138.9 58.4C121.6 77.4 112 102.3 112 128h0c-.2 11.3 1.5 23.2 5.5 35.1c14.3 42.9 52.1 69.1 84.4 58.5s46.9-53.9 32.6-96.8C226.3 100.2 210.3 81 192 71.2V0zm64 256c-64 0-192 80-192 256l192-48 192 48c0-176-128-256-192-256z"],
    "kiwi-fruit": [448, 512, [], "e30c", "M448 176c0 79.5-100.3 144-224 144S0 255.5 0 176S100.3 32 224 32s224 64.5 224 144zM224 64H208V80v24 16h16 16V104 80 64H224zM64 176v16H80h32 16V176 160H112 80 64v16zm256 0v16h16 32 16V176 160H368 336 320v16zm-96 56H208v16 24 16h16 16V272 248 232H224zM139.3 92.7L128 81.4 105.4 104l11.3 11.3 8 8L136 134.6 158.6 112l-11.3-11.3-8-8zm192 22.6L342.6 104 320 81.4 308.7 92.7l-8 8L289.4 112 312 134.6l11.3-11.3 8-8zm-184 136L158.6 240 136 217.4l-11.3 11.3-8 8L105.4 248 128 270.6l11.3-11.3 8-8zm176-22.6L312 217.4 289.4 240l11.3 11.3 8 8L320 270.6 342.6 248l-11.3-11.3-8-8zM280 176c0-13.3-25.1-24-56-24s-56 10.7-56 24s25.1 24 56 24s56-10.7 56-24zM224 480C102.4 480 3.4 383.1 .1 262.2c13.2 16.4 29.8 30.7 48.2 42.5C94.7 334.6 156.9 352 224 352s129.3-17.4 175.7-47.3c18.5-11.9 35-26.2 48.2-42.5C444.6 383.1 345.6 480 224 480z"],
    "traffic-light-slow": [320, 512, [], "f639", "M320 0H0V352c0 88.4 71.6 160 160 160s160-71.6 160-160V0zM136 368a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm72 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm0-128a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM136 112a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm72 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"],
    "rectangle-code": [512, 512, [], "e322", "M512 32H0V480H512V32zM209 209l-47 47 47 47 17 17L192 353.9l-17-17-64-64-17-17 17-17 64-64 17-17L225.9 192l-17 17zM337 175l64 64 17 17-17 17-64 64-17 17L286.1 320l17-17 47-47-47-47-17-17L320 158.1l17 17z"],
    "head-side-virus": [512, 512, [], "e064", "M0 224.3C0 100.4 100.4 0 224.3 0H256C358.1 0 441.6 79.7 447.7 180.3L505 252l7 8.8V272v16 32H480 448v96 32H416 320v32 32H288 96 64V480 381.2C23 339.3 0 283 0 224.3zM314.5 94.9l-11.3 11.3C279.9 129.5 240 113 240 80V64H224 208V80c0 33-39.9 49.5-63.2 26.2L133.5 94.9l-11.3 11.3 0 0-11.3 11.3 11.3 11.3C145.5 152.1 129 192 96 192H80v16 16H96c33 0 49.5 39.9 26.2 63.2l-11.3 11.3 11.3 11.3 0 0 11.3 11.3 11.3-11.3C168.1 286.5 208 303 208 336v16h16 16V336c0-33 39.9-49.5 63.2-26.2l11.3 11.3 11.3-11.3 11.3-11.3-11.3-11.3C302.5 263.9 319 224 352 224h16V208 192H352c-33 0-49.5-39.9-26.2-63.2l11.3-11.3-11.3-11.3L314.5 94.9zM200 160a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "keyboard-brightness": [640, 512, [], "e1c0", "M352 64V96v96 32H288V192 96 64h64zM112 130.7l22.6 22.6 64 64L221.3 240 176 285.3l-22.6-22.6-64-64L66.7 176 112 130.7zM573.3 176l-22.6 22.6-64 64L464 285.3 418.7 240l22.6-22.6 64-64L528 130.7 573.3 176zM0 352H32 96h32v64H96 32 0V352zm192 0h32H416h32v64H416 224 192V352zm320 64V352h32 64 32v64H608 544 512z"],
    "books-medical": [576, 512, [], "f7e8", "M419.4 398.3L384 268.3V142.8l93.7-25.1 67.2 247L419.4 398.3zM469.3 86.8L384 109.6V16.3L445.7 0l23.6 86.8zM427.8 429.2l125.5-33.6L576 478.9 450.3 512l-22.5-82.8zM64 0H192V96H64V0zm0 416H192v96H64V416zM224 0H352V96H224V0zm0 128H352V384H224V128zm0 288H352v96H224V416zM64 160h64v64h64v64H128v64H64V288H0V224H64V160z"],
    "lightbulb-slash": [640, 512, [], "f673", "M152.4 229.8c5.4 16.8 13.2 32.4 23 46.6c5 7.2 10.2 14.3 15.4 21.4l0 0 0 0c19.8 27.1 39.7 54.4 49.2 86.2H348.1L152.4 229.8zM240 416v96H400V424.9L388.7 416H240zM160.4 101.7l-112-87L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L436.2 315.9c4.3-6.1 8.7-12.1 13.1-18.1l0 0 0 0 0 0 0 0c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C496 78.8 417.2 0 320 0C249.3 0 188.4 41.7 160.4 101.7zm52.7 40.9C227.3 97.1 269.8 64 320 64V96c-40.2 0-73.4 29.6-79.1 68.2l-27.8-21.6z"],
    "house-blank": [576, 512, ["home-blank"], "e487", "M576 287.6H511.8l1 224.4H64.1V287.6H0V240L288.4 0 576 240v47.6z"],
    "square-5": [448, 512, [], "e25a", "M448 32H0V480H448V32zM176 128H280h24v48H280 197.9L194 218.9l56 6.7c39.9 4.8 70 38.7 70 78.9c0 43.9-35.6 79.5-79.5 79.5h-33c-29.8 0-57.1-16.4-71.2-42.6l-5.4-10 42.3-22.7 5.4 10c5.7 10.7 16.9 17.3 29 17.3h33c17.4 0 31.5-14.1 31.5-31.5c0-15.9-11.9-29.3-27.7-31.2l-79.1-9.5L142 261.1l2.1-23.2 8-88 2-21.8H176z"],
    "square-heart": [448, 512, [128159, "heart-square"], "f4c8", "M448 32H0V480H448V32zM103.2 287.1c-14.9-14.9-23.2-35-23.2-56v-3.6c0-41.8 33.9-75.6 75.6-75.6c23 0 44.7 10.4 59.1 28.4l9.3 11.6 9.3-11.6c14.4-17.9 36.1-28.4 59.1-28.4c41.8 0 75.6 33.9 75.6 75.6v3.6c0 21-8.3 41.1-23.2 56L320 311.9l-96 96-96-96-24.8-24.8z"],
    "puzzle": [512, 512, [], "e443", "M304 0H512V208H432v16c0 17.7-14.3 32-32 32s-32-14.3-32-32V208l-64 0V144h32c17.7 0 32-14.3 32-32s-14.3-32-32-32H304V0zM0 272V64H208v64h16c17.7 0 32 14.3 32 32s-14.3 32-32 32H208v80H144V240c0-17.7-14.3-32-32-32s-32 14.3-32 32v32H0zM0 512V304H208v64H176c-17.7 0-32 14.3-32 32s14.3 32 32 32h32v80H0zM240 304h64v32c0 17.7 14.3 32 32 32s32-14.3 32-32V304h80V512H240V304z"],
    "user-gear": [640, 512, ["user-cog"], "f4fe", "M224 0a128 128 0 1 1 0 256A128 128 0 1 1 224 0zM404 484.3V512H0L64 304H305.4l-15.5 26.9L326 351.7l-36.1 20.8 77 133.2L404 484.3zm32-277.9h88.1v42.4c7.9 3.4 15.4 7.7 22.3 12.8l35-20.2 45 77.8-35.2 20.3c.4 4 .7 8.1 .7 12.3s-.2 8.2-.7 12.3l35.2 20.3-45 77.8-35.1-20.2c-6.9 5.1-14.3 9.4-22.3 12.8V497H436V454.8c-8-3.4-15.6-7.7-22.5-12.9l-34.9 20.1-45-77.8 34.9-20.1c-.4-4.1-.7-8.2-.7-12.4s.2-8.3 .7-12.4l-34.9-20.2 44.9-77.8 34.9 20.2c6.9-5.1 14.5-9.4 22.5-12.9V206.4zm92.1 145.3a48.1 48.1 0 1 0 -96.1 0 48.1 48.1 0 1 0 96.1 0z"],
    "pipe-circle-check": [640, 512, [], "e436", "M64 96v32V384v32H0V384 128 96H64zm448 0v32 64.7c-5.3-.5-10.6-.7-16-.7c-16.6 0-32.7 2.3-48 6.6V128 96h64zM320 368c0 5.4 .2 10.7 .7 16H96V128H416v83.2c-57 29.1-96 88.4-96 156.8zm32 0a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm222.6-32L552 313.4l-11.3 11.3L480 385.4l-28.7-28.7L440 345.4 417.4 368l11.3 11.3 40 40L480 430.6l11.3-11.3 72-72L574.6 336z"],
    "arrow-up-1-9": [576, 512, ["sort-numeric-up"], "f163", "M352 32h32 48 32V64v96h16 32v64H480 432 384 352V160h32 16V96H384 352V32zm-192 .6l23.6 25.7 88 96L293.2 178 246 221.2l-21.6-23.6L192 162.3V448v32H128V448 162.3L95.6 197.6 74 221.2 26.8 178l21.6-23.6 88-96L160 32.6zM432 368a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-88-32c0-48.6 39.4-88 88-88s88 39.4 88 88c0 22.6-6.2 44.8-18 64.1L453.5 480H378.5l10.1-16.6 25.1-41.3C373.9 413.7 344 378.3 344 336z"],
    "octagon-exclamation": [512, 512, [], "e204", "M0 160V352L160 512H352L512 352V160L352 0H160L0 160zm280-32v24V264v24H232V264 152 128h48zM232 320h48v48H232V320z"],
    "dial-low": [576, 512, [], "e15d", "M320 0V64H256V0h64zM128 64v64H64V64h64zm384 0v64H448V64h64zm0 192h64v64H512V256zm0 192v64H448V448h64zM64 448h64v64H64V448zM0 256H64v64H0V256zM287.6 447.6c-80.2 0-146.6-59-158.2-136H287.6h24v-48h-24H129.4c11.6-77 78-136 158.2-136c88.4 0 160 71.6 160 160s-71.6 160-160 160z"],
    "door-closed": [576, 512, [128682], "f52a", "M96 0H480V448h64 32v64H544 480 96 32 0V448H32 96V0zM384 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "laptop-mobile": [640, 512, ["phone-laptop"], "f87a", "M96 0H64V32 288H0v48l48 48H352V288H128V64H448V96h64V32 0H480 96zM448 448V192H576V448H448zM384 128v64V448v64h64H576h64V448 192 128H576 448 384z"],
    "conveyor-belt-boxes": [640, 512, ["conveyor-belt-alt"], "f46f", "M64 0H320V256H64V0zM384 64H576V256H384V64zM0 416c0-53 43-96 96-96H544c53 0 96 43 96 96s-43 96-96 96H96c-53 0-96-43-96-96zm160 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm224-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "shield-virus": [512, 512, [], "e06c", "M256 0l11.6 4.5L475.1 85l19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9c-32.7 75.2-91.1 150-189.4 192.6L256 512l-12.7-5.5C144.9 463.9 86.5 389.2 53.9 313.9C21.4 239.3 13.6 162.9 16.6 113l1.2-20.5L36.9 85 244.4 4.5 256 0zm90.5 142.8l-11.3 11.3C311.9 177.5 272 161 272 128V112H256 240v16c0 33-39.9 49.5-63.2 26.2l-11.3-11.3-11.3 11.3 0 0-11.3 11.3 11.3 11.3C177.5 200.1 161 240 128 240H112v16 16h16c33 0 49.5 39.9 26.2 63.2l-11.3 11.3 11.3 11.3 0 0 11.3 11.3 11.3-11.3C200.1 334.5 240 351 240 384v16h16 16V384c0-33 39.9-49.5 63.2-26.2l11.3 11.3 11.3-11.3 11.3-11.3-11.3-11.3C334.5 311.9 351 272 384 272h16V256 240H384c-33 0-49.5-39.9-26.2-63.2l11.3-11.3-11.3-11.3-11.3-11.3zM232 208a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "starfighter-twin-ion-engine-advanced": [640, 512, ["starfighter-alt-advanced"], "e28e", "M576 148.5L488.5 53.7l47-43.4 96 104 8.5 9.2V136 360v11.2l-7 8.8L537 500l-50-40 89-111.2V294.4L468.4 315.9C444.7 374.6 387.2 416 320 416s-124.7-41.4-148.4-100.1L64 294.4v61.8l88.3 103-48.6 41.7-96-112-7.7-9V368 144 132.2l7.7-9 96-112 48.6 41.7L64 155.8v61.8l107.6-21.5C195.3 137.4 252.8 96 320 96s124.7 41.4 148.4 100.1L576 217.6V148.5zM304 350.7V318c-5.9-1.5-11.4-3.8-16.5-6.8l-23.1 23.1c11.6 8.2 25 14 39.6 16.4zm-62.3-39l23.1-23.1c-3-5.1-5.3-10.6-6.8-16.5H225.3c2.4 14.6 8.2 28.1 16.4 39.6zM225.3 240H258c1.5-5.9 3.8-11.4 6.8-16.5l-23.1-23.1c-8.2 11.6-14 25-16.4 39.6zm39-62.3l23.1 23.1c5.1-3 10.6-5.3 16.5-6.8V161.3c-14.6 2.4-28.1 8.2-39.6 16.4zM375.6 334.3l-23.1-23.1c-5.1 3-10.6 5.3-16.5 6.8v32.7c14.6-2.4 28.1-8.2 39.6-16.4zm22.6-22.6c8.2-11.6 14-25 16.4-39.6H382c-1.5 5.9-3.8 11.4-6.8 16.5l23.1 23.1zM382 240h32.7c-2.4-14.6-8.2-28.1-16.4-39.6l-23.1 23.1c3 5.1 5.3 10.6 6.8 16.5zm-6.4-62.3c-11.6-8.2-25-14-39.6-16.4V194c5.9 1.5 11.4 3.8 16.5 6.8l23.1-23.1zM342.8 278.5c5.7-5.8 9.2-13.7 9.2-22.5c0-17.7-14.3-32-32-32l0 0 0 0c-17.7 0-32 14.3-32 32c0 17.7 14.3 32 32 32c8.8 0 16.7-3.5 22.5-9.2l.3-.3z"],
    "dice-six": [448, 512, [9861], "f526", "M0 32H448V480H0V32zM160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "starfighter-twin-ion-engine": [576, 512, ["starfighter-alt"], "e038", "M64 32V64 211.2l75.6-15.1C163.3 137.4 220.8 96 288 96s124.7 41.4 148.4 100.1L512 211.2V64 32h64V64 224v64V448v32H512V448 300.8l-75.6 15.1C412.7 374.6 355.2 416 288 416s-124.7-41.4-148.4-100.1L64 300.8V448v32H0V448 288 224 64 32H64zM272 350.7V318c-5.9-1.5-11.4-3.8-16.5-6.8l-23.1 23.1c11.6 8.2 25 14 39.6 16.4zm-62.3-39l23.1-23.1c-3-5.1-5.3-10.6-6.8-16.5H193.3c2.4 14.6 8.2 28.1 16.4 39.6zM193.3 240H226c1.5-5.9 3.8-11.4 6.8-16.5l-23.1-23.1c-8.2 11.6-14 25-16.4 39.6zm39-62.3l23.1 23.1c5.1-3 10.6-5.3 16.5-6.8V161.3c-14.6 2.4-28.1 8.2-39.6 16.4zM343.6 334.3l-23.1-23.1c-5.1 3-10.6 5.3-16.5 6.8v32.7c14.6-2.4 28.1-8.2 39.6-16.4zm22.6-22.6c8.2-11.6 14-25 16.4-39.6H350c-1.5 5.9-3.8 11.4-6.8 16.5l23.1 23.1zM350 240h32.7c-2.4-14.6-8.2-28.1-16.4-39.6l-23.1 23.1c3 5.1 5.3 10.6 6.8 16.5zm-6.4-62.3c-11.6-8.2-25-14-39.6-16.4V194c5.9 1.5 11.4 3.8 16.5 6.8l23.1-23.1zM310.8 278.5c5.7-5.8 9.2-13.7 9.2-22.5c0-17.7-14.3-32-32-32s-32 14.3-32 32s14.3 32 32 32c8.8 0 16.7-3.5 22.5-9.2l.3-.3z"],
    "rocket-launch": [512, 512, [128640], "e027", "M384 305l0 127L224 512l0-142c0-21.8-8.6-42.6-24-58c-15.3-15.3-36.1-24-57.9-24L0 287.6 80 128l127 0C294.1-15.5 431.8-8.4 502.7 9.3C520.4 80.2 527.5 217.9 384 305zm40-177a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM166.5 470C117 519.5 .5 511.5 .5 511.5s-8-116.5 41.5-166c34.4-34.4 90.1-34.4 124.5 0s34.4 90.1 0 124.5zm-46.7-36.4c11.4-11.4 11.4-30 0-41.4s-30-11.4-41.4 0c-16.5 16.5-13.8 55.2-13.8 55.2s38.7 2.7 55.2-13.8z"],
    "mosquito-net": [640, 512, [], "e52c", "M256 242.3v23.1l-59.3 59.3-4.7 4.7V336l0 44.2-30.3 60.6-7.2 14.3 28.6 14.3 7.2-14.3 32-64 1.7-3.4V384l0-41.4 32-32v50l0 32h64v-32-50l32 32V297.4l-32-32V242.2l32 27.9V256h32V224h80 16 67c-11.7-9.9-26.3-16.5-42.4-18.5L344.7 181.6l49.6-41.3 8.4-7-3.5-10.4L385.4 81.6 414 30.2l7.8-14L393.8 .6l-7.8 14L354 72.2l-3.4 6.2 2.2 6.7 12.5 37.6L320 160.5V137.9v-32H296.2V71.7 63.5l-16.3 0v8.2 34.2l-23.8 0v32 22.6l-45.4-37.8 12.5-37.6 2.2-6.7L222 72.2 190 14.6l-7.8-14-28 15.5 7.8 14 28.6 51.4-13.8 41.3-3.5 10.4 8.4 7 49.6 41.3L71.4 205.5C30.6 210.6 0 245.2 0 286.3c0 72.6 87.8 109 139.2 57.6L256 242.3zM362.9 353.5c.4-.5 .9-1 1.3-1.5h-2.8l1.5 1.5zM528 256H496v16 16H448V272 256H416v16 16H400 384v32h16 16v48H400 384v32h16 16v48H400 384v32h16 16v16 16h32V496 480h48v16 16h32V496 480h48v16 16h32V496 480h16 16V448H624 608V400h16 16V368H624 608V320h16 16V288H624 608V272 256H576v16 16H528V272 256zm0 64h48v48H528V320zm0 80h48v48H528V400zm-80-80h48v48H448V320zm0 80h48v48H448V400z"],
    "vent-damper": [640, 512, [], "e465", "M64 64H576v96h64V352H576v96H64V352H0V160H64V64zm120 80H160v48h24H456h24V144H456 184zm0 88H160v48h24H456h24V232H456 184zm0 88H160v48h24H456h24V320H456 184z"],
    "bridge-water": [576, 512, [], "e4ce", "M0 64H576v96c-53 0-96 43-96 96v80l-19.7 14.2 0 0c-13.9 10-23.6 17-35.5 22.5C411.6 378.7 397 383 384 383V256c0-53-43-96-96-96s-96 43-96 96V383c-13 0-27.6-4.3-40.7-10.3c-12-5.5-21.7-12.5-35.5-22.5l0 0 0 0-1.1-.8L96 336l0 0V256c0-53-43-96-96-96V64zM272.4 461.1c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 470.1 31.9 480 0 480V416c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7z"],
    "ban-bug": [512, 512, ["debug"], "f7f9", "M256 448C150 448 64 362 64 256c0-41.5 13.1-79.9 35.5-111.2L367.2 412.5C335.9 434.9 297.5 448 256 448zm89-148.3l19.9 4 15.7 3.1 6.3-31.4-15.7-3.1-35.1-7V246.7l35.1-7 15.7-3.1-6.3-31.4-15.7 3.1L336 214.1V183.5l16.2-9.7 13.7-8.2L349.5 138l-13.7 8.2-18.4 11.1L288 128H224l-25.4 25.4L144.8 99.5C176.1 77.1 214.5 64 256 64c106 0 192 86 192 192c0 41.5-13.1 79.9-35.5 111.2L345 299.7zM256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM140.9 272.3l-15.7 3.1 6.3 31.4 15.7-3.1 28.9-5.8v30.6l-16.2 9.7L146 346.5 162.5 374l13.7-8.2 18.4-11.1L224 384h64l2.7-2.7L175 265.5l-34.1 6.8z"],
    "person-booth": [576, 512, [], "f756", "M256 0H192V32 192h64V32 0zM192 480v32h64V480 320H192V480zM576 0H512V32 480v32h64V480 32 0zM320 0H283.1l5.2 36.5 31.2 218.6L288.6 409.7 281 448h39 32 64 32 32V416 32 0H448 320zM112 80A48 48 0 1 0 16 80a48 48 0 1 0 96 0zM0 160v32 96 10.7l0 0V480v32H64V480 384l32 42.7V480v32h64V480 416 405.3l-6.4-8.5L112 341.3l0-72.1 9.4 9.4 9.4 9.4H144h80 32V224H224 157.3l-54.6-54.6L93.3 160H80 32 0z"],
    "text-width": [448, 512, [], "f035", "M32 32H0V64v64 32H64V128 96H192l0 128H160v64h32 64 32V224H256l0-128H384v32 32h64V128 64 32H416 224 32zM0 384l96 96h32V416H320v64h32l96-96-96-96H320v64H128V288H96L0 384z"],
    "garage-car": [640, 512, [], "e00a", "M0 512V128L320 0 640 128V512H544V192H96V512H0zM224 240H416h16.4l6 15.3 40 102.2 1.7 4.2v4.5V392v24 64 32H416V480 464H224v16 32H160V480 416 392 368v-4.5l1.6-4.2 40-104 5.9-15.4H224zm194.4 96l-18.8-48H240.5L222 336H418.4zM240 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm184-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "square-kanban": [448, 512, [], "e488", "M448 32L0 32 0 480l448 0 0-448zM288 384l0-256 64 0 0 256-64 0zM256 256l-64 0 0-128 64 0 0 128zM96 320l0-192 64 0 0 192-64 0z"],
    "hat-wizard": [512, 512, [], "f6e8", "M64 416L192 128 416 0 352 192l96 224H230.9L248 376l56-24-56-24-24-56-24 56-56 24 56 24 17.1 40H64zM256 192l16 32 16-32 32-16-32-16-16-32-16 32-32 16 32 16zM32 448H480h32v64H480 32 0V448H32z"],
    "pen-fancy": [512, 512, [128395, 10002], "f5ac", "M97.1 392.3c-.7-2.6-1.1-5.4-1.1-8.3c0-17.7 14.3-32 32-32s32 14.3 32 32s-14.3 32-32 32c-2.9 0-5.6-.4-8.3-1.1l-88 88L224 448l37.5-99.9-97.6-97.6L64 288 9.1 480.3l88-88zm178.3-75.5L512 96 416 0 195.2 236.6l80.2 80.2z"],
    "coffee-pot": [512, 512, [], "e002", "M32 32H0V64 192v32H64V192 96h53.3l27.8 83.3C96 214 64 271.3 64 336v8c0 80 72 136 72 136H440s72-56 72-136v-8c0-64.7-32-122-81.1-156.7L480 32H224 192 96 32zM194 224H382c34.9 19.4 59.8 54.6 65 96H129c5.2-41.4 30.1-76.6 65-96z"],
    "mouse-field": [512, 512, [], "e5a8", "M396.2 113.6c2.5-8.1 3.8-16.7 3.8-25.6c0-48.6-39.4-88-88-88s-88 39.4-88 88c0 29.8 14.8 56.1 37.4 72H256c-88.4 0-160 71.6-160 160v48H72c-39.8 0-72 32.2-72 72s32.2 72 72 72H456h24V464H456 72c-13.3 0-24-10.7-24-24s10.7-24 24-24H96 232h8 19H392h24V392 376 359.2l-15.8-5.7-49.9-18.2 23.8-63.5c2 .1 4 .2 6 .2H512V248.9c0-43-19.8-81.4-50.8-106.5C473 127.4 480 108.5 480 88c0-46.4-35.9-84.4-81.4-87.8C419.2 20.6 432 48.8 432 80c0 14.5-2.8 28.4-7.8 41.1c-8.9-3.4-18.3-6-28-7.5zM400 196a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zM312 48c22.1 0 40 17.9 40 40v40H312c-22.1 0-40-17.9-40-40s17.9-40 40-40z"],
    "person-digging": [576, 512, ["digging"], "f85e", "M256 112a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM41.2 201.8l-22.2-9.2L.6 236.9l22.2 9.2 347.9 145L352 416H288l-32 96H576V464L448 288l-47.6 63.5-91.9-38.3L253.6 179.8l-5.1-12.5-12.6-5-80-32-22-8.8L119 140 62.5 210.7l-21.2-8.8zm17.1 90.1L49 328 1.3 512H67.4l34.2-131.9 58.4 25V480v32h64V480 384 362.9l-19.4-8.3-112-48L58.4 291.9z"],
    "shower-down": [384, 512, ["shower-alt"], "e24d", "M224 0V32v3.2C297 50 352 114.6 352 192h32v64H352 32 0V192H32C32 114.6 87 50 160 35.2V32 0h64zm32 416l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7c0 17.5-14.2 31.6-31.6 31.6h-.8c-17.5 0-31.6-14.2-31.6-31.6c0-5.5 1.4-10.9 4.2-15.7L256 416zm36.2-79.3L320 288l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7c0 17.5-14.2 31.6-31.6 31.6h-.8c-17.5 0-31.6-14.2-31.6-31.6c0-5.5 1.4-10.9 4.2-15.7zM128 416l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7c0 17.5-14.2 31.6-31.6 31.6h-.8C110.2 512 96 497.8 96 480.4c0-5.5 1.4-10.9 4.2-15.7L128 416zm36.2-79.3L192 288l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7c0 17.5-14.2 31.6-31.6 31.6h-.8c-17.5 0-31.6-14.2-31.6-31.6c0-5.5 1.4-10.9 4.2-15.7zM64 288l27.8 48.7c2.7 4.8 4.2 10.2 4.2 15.7C96 369.8 81.8 384 64.4 384h-.8C46.2 384 32 369.8 32 352.4c0-5.5 1.4-10.9 4.2-15.7L64 288z"],
    "box-circle-check": [576, 512, [], "e0c4", "M208 32V160H0L64 32H208zm32 0H384l64 128H416 240V32zM0 480V192H416v.7c-89.7 8.1-160 83.5-160 175.3c0 42.5 15.1 81.6 40.2 112H0zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm222.6-32L488 313.4l-11.3 11.3L416 385.4l-28.7-28.7L376 345.4 353.4 368l11.3 11.3 40 40L416 430.6l11.3-11.3 72-72L510.6 336z"],
    "brightness": [512, 512, [], "e0c9", "M288 32V0H224V32 80v32h64V80 32zM118.6 73.4L96 50.7 50.7 96l22.6 22.6 32 32L128 173.3 173.3 128l-22.6-22.6-32-32zm320 45.3L461.3 96 416 50.7 393.4 73.4l-32 32L338.7 128 384 173.3l22.6-22.6 32-32zM32 224H0v64H32 80h32V224H80 32zm448 0H432 400v64h32 48 32V224H480zM150.6 406.6L173.3 384 128 338.7l-22.6 22.6-32 32L50.7 416 96 461.3l22.6-22.6 32-32zm256-45.3L384 338.7 338.7 384l22.6 22.6 32 32L416 461.3 461.3 416l-22.6-22.6-32-32zM288 480V432 400H224v32 48 32h64V480zM256 352a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"],
    "car-side-bolt": [640, 512, [], "e344", "M96 64L42.7 224H0V432H65.3c7.6 45.4 47.1 80 94.7 80s87.1-34.6 94.7-80H385.3c7.6 45.4 47.1 80 94.7 80s87.1-34.6 94.7-80H640V224H522.7L416 64H96zM480 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM114.7 400a48 48 0 1 1 90.5 32 48 48 0 1 1 -90.5-32zM208 240L336 112l-24 96h88L272 336l24-96H208z"],
    "ornament": [384, 512, [], "f7b8", "M224 96H160V64c0-17.7 14.3-32 32-32s32 14.3 32 32V96zm32 0V64c0-35.3-28.7-64-64-64s-64 28.7-64 64V96H96v57.7C66.9 170.5 42.5 194.9 25.7 224H358.3c-16.9-29.1-41.2-53.5-70.3-70.3V96H256zM0 320c0 22.4 3.8 44 10.9 64H373.1c7.1-20 10.9-41.6 10.9-64s-3.8-44-10.9-64H10.9C3.8 276 0 297.6 0 320zm25.7 96c33.2 57.4 95.2 96 166.3 96s133.1-38.6 166.3-96H25.7z"],
    "phone-arrow-down-left": [512, 512, ["phone-arrow-down", "phone-incoming"], "e223", "M144 0L0 32 0 64C0 311.4 200.6 512 448 512h32l32-144L368 288l-67 83.8C232.5 335.7 176.3 279.5 140.2 211L224 144 144 0zM489 57l17-17L472 6.1 455 23l-119 119V88 64H288V88 200v24h24H424h24V176H424 369.9L489 57z"],
    "cloud-word": [640, 512, [], "e138", "M0 480H144 512 640V352c0-59.6-40.8-109.8-96-124V192c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192v8.2C40.1 220 0 273.3 0 336V480zM512 352v32H496 304 288V352h16H496h16zm-272 0h16v32H240 144 128V352h16 96zM128 288h16H336h16v32H336 144 128V288zm272 0h96 16v32H496 400 384V288h16z"],
    "hand-fingers-crossed": [384, 512, [], "e1a3", "M101 35.6L87.5 6.6l-58 27.1L43 62.6l32 68.7 35.3-75.7L101 35.6zM165.6 240H192v-9.4L181 207l-15.4 33zM288 320H224v48 16H208 96 80V352H96h96V320 272H150.6 115.3 80 0v91c0 33.9 13.5 66.5 37.5 90.5l11.6 11.6c30 30 70.7 46.9 113.1 46.9H224c88.4 0 160-71.6 160-160H288V320zM212.8 63l13.5-29-58-27.1-13.5 29L59.6 240h70.6L212.8 63zM224 160V288h64V160H224zm96 32V320h64V192H320z"],
    "trash": [448, 512, [], "f1f8", "M144 0L128 32H0V96H448V32H320L304 0H144zM416 128H32L56 512H392l24-384z"],
    "gauge-simple": [512, 512, ["gauge-simple-med", "tachometer-average"], "f629", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-26.9-16.5-49.9-40-59.3V88 64H232V88 292.7c-23.5 9.5-40 32.5-40 59.3c0 35.3 28.7 64 64 64s64-28.7 64-64z"],
    "arrow-down-small-big": [576, 512, ["sort-size-down-alt"], "f88d", "M320 32H480V192H320V32zm0 224H544V480H320V256zM183.7 453.5l-23.7 26-23.7-26-80-88L34.8 341.8l47.4-43 21.5 23.7L128 349.2V80 48h64V80 349.2l24.3-26.8 21.5-23.7 47.4 43-21.5 23.7-80 88z"],
    "book-medical": [448, 512, [], "f7e6", "M0 96C0 43 43 0 96 0H384h32 32V384H416v64h32v64H416 384 96c-53 0-96-43-96-96V96zM64 416c0 17.7 14.3 32 32 32H352V384H96c-17.7 0-32 14.3-32 32zM208 96v64H144v64h64v64h64V224h64V160H272V96H208z"],
    "face-melting": [640, 512, [129760], "e483", "M571.4 304.8c-4.5 23.1 11.8 47.2 35.3 47.2l0 0H608l32 0v32 32H608l0 0H560c-8.8 0-16 7.2-16 16s7.1 16 16 16l0 0h16l32 0v32 32H576 320 32 0V480 448l32 0H44.9l0 0c36.8 0 58.4-50.7 42.8-84.1C72.5 331.1 64 294.5 64 256C64 114.6 178.6 0 320 0S576 114.6 576 256c0 16.7-1.6 33-4.6 48.8zM247.2 219.9a32 32 0 1 0 16.6-61.8 32 32 0 1 0 -16.6 61.8zM441 238.7a32 32 0 1 0 -61.8-16.6A32 32 0 1 0 441 238.7zM213.2 299.4l-7-14.4-28.8 14 7 14.4c14.8 30.5 45.1 67.5 98.3 81.7s97.9-2.6 126-21.7l13.3-9L404 338l-13.3 9c-22.7 15.4-57.9 28.5-99.8 17.2s-65.8-40.2-77.8-64.8z"],
    "poo": [512, 512, [128169], "f2fe", "M256 48c0 44.2-35.8 80-80 80H165.5 160c-35.3 0-64 28.7-64 64c0 19.1 8.4 36.3 21.7 48H104c-39.8 0-72 32.2-72 72c0 25.6 13.4 48.2 33.6 60.9C27.5 385.6 0 421.6 0 464v48H512V464c0-42.4-27.5-78.4-65.6-91.1C466.6 360.2 480 337.6 480 312c0-39.8-32.2-72-72-72H394.3c13.3-11.7 21.7-28.9 21.7-48c0-35.3-28.7-64-64-64h-5.5c3.5-10 5.5-20.8 5.5-32c0-53-43-96-96-96c-5.1 0-10.2 .4-15.1 1.2C250.4 14.3 256 30.5 256 48zM192 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM256 448c-64 0-96-64-96-64H352s-32 64-96 64z"],
    "pen-clip-slash": [640, 512, ["pen-alt-slash"], "e20f", "M409.1 294.9L447 257l33-33 1-1L305 47l-17-17L271 47l-79.2 79.2L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L409.1 294.9zm-179.1-139L288 97.9l31 31-54 54-34.9-27.1zm110 208.1L196.9 251.1 96 352 64 512l160-32L340.1 363.9zM576 128L448 0 375.6 72.4l128 128L576 128z"],
    "quote-right": [448, 512, [8221, "quote-right-alt"], "f10e", "M192 296c0 66.3-53.7 120-120 120H64 32l0-64H64h8c30.9 0 56-25.1 56-56v-8L0 288V96H192l0 96v96 8zm256 0c0 66.3-53.7 120-120 120h-8H288V352h32 8c30.9 0 56-25.1 56-56v-8l-128 0 0-192H448v96l0 96v8z"],
    "scroll-old": [576, 512, [], "f70f", "M48 32c26.5 0 48 21.5 48 48v80H48 0V80C0 53.5 21.5 32 48 32zm80 48c0-18-6-34.6-16-48H384c53 0 96 43 96 96l-32 32 32 32v16 16l-32 32 32 32v16 16H272 256v16 48c0 35.3-28.7 64-64 64s-64-28.7-64-64V272 256l32-32-32-32V176 80zM576 368c0 61.9-50.1 112-112 112H368 192c53 0 96-43 96-96V352h48 16l32 32 32-32h16H576v16z"],
    "guitars": [512, 512, [], "f8bf", "M104 0h48 24V24 80v5.7l-2.5 5.1L152 133.7V178c50.3 8.6 88 43.8 88 86c0 14-4.2 27.3-11.6 39.1c-8.2 13-7.5 32 2.9 43.4c5.9 6.5 10.9 13.7 14.8 21.3c-2.3 4.9-4.7 9.6-7 13.9c-8.8 16.3-15 35.6-15 56.5c0 11.6 1.9 22.8 5.4 33.3C205.9 496.1 169.3 512 128 512C57.3 512 0 465.4 0 408c0-23 9.2-44.3 24.8-61.5c10.3-11.4 11.1-30.4 2.9-43.4C20.2 291.3 16 278 16 264c0-42.1 37.7-77.3 88-86V133.7L82.5 90.7 80 85.7V80 24 0h24zm24 344a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM360 148.6L328 112 352 0h32c22.1 0 40 17.9 40 40v4.4c0 12.4-6.4 23.3-16 29.7V238.9c48-7.2 48-46.9 48-46.9h32v37.5c0 12.9-4.3 25.4-8.5 37.8c-1.4 4-2.7 7.9-3.9 11.8c-2.1 6.8-3.6 15.1-3.6 24.8c0 33.5 17 70.9 28.8 92.9c6.9 12.7 11.2 26.9 11.2 41.3c0 40.8-33 73.8-73.8 73.8H329.8C289 512 256 479 256 438.2c0-14.5 4.3-28.6 11.2-41.3C279 374.9 296 337.5 296 304c0-9.8-1.5-18-3.6-24.8c-1.2-3.9-2.5-7.9-3.9-11.8c-4.2-12.4-8.5-25-8.5-37.8V176h32s0 52.8 48 62.5V148.6zM336 304v32h16 64 16V304H416 352 336zm0 64v32h16 64 16V368H416 352 336z"],
    "phone-xmark": [640, 512, [], "e227", "M208 0L64 32l0 32c0 247.4 200.6 448 448 448h32l32-144L432 288l-67 83.8C296.5 335.7 240.3 279.5 204.2 211L288 144 208 0zm362 40L536 6.1 519 23l-47 47L425 23l-17-17L374.1 40l17 17 47 47-47 47-17 17L408 201.9l17-17 47-47 47 47 17 17L569.9 168l-17-17-47-47 47-47 17-17z"],
    "hose": [448, 512, [], "e419", "M288 104v24h48V104v-2.3l80-11.4V104h32V88 40 24H416V37.7L336 26.3V24 0H288V24v80zM64 176c0-44.2 35.8-80 80-80H256V32H144C64.5 32 0 96.5 0 176s64.5 144 144 144H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H144c-44.2 0-80-35.8-80-80zM32 352c-17.7 0-32 14.3-32 32s14.3 32 32 32H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H32zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H32z"],
    "clock-six": [512, 512, [], "e352", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392V360v24H232V360 120 96h48v24z"],
    "shirt": [640, 512, [128085, "t-shirt", "tshirt"], "f553", "M225.3 0H176L0 144 88 256l72-58.9V512H480V197.1L552 256l88-112L464 0H414.7c-7.6 45.4-47.1 80-94.7 80s-87.1-34.6-94.7-80z"],
    "billboard": [640, 512, [], "e5cd", "M448 32V0H384V32H256V0H192V32H96 32V96 352H0v64H32 96 288v64 32h64V480 416H544h64 32V352H608V96 32H544 448zM352 352H288 96V96h96v32H160v64h32 32 32 32V128H256V96H384v32H352v64h32 32 32 32V128H448V96h96V352H352z"],
    "square-r": [448, 512, [], "e27c", "M448 32H0V480H448V32zM128 128h24H256c44.2 0 80 35.8 80 80c0 37.8-26.3 69.5-61.6 77.9L337.1 384h-57l-61.3-96H176v72 24H128V360 264 152 128zm48 112h56 24c17.7 0 32-14.3 32-32s-14.3-32-32-32H176v64z"],
    "cubes": [576, 512, [], "f1b3", "M288 4.2l8.5 3.2L424.5 56 440 61.9V78.4 204.5l120.5 45.7 15.5 5.9v16.6V426.8v15.7l-14.3 6.3L433.7 505l-9.7 4.2-9.7-4.2L288 449.5 161.7 505l-9.7 4.2-9.7-4.2-128-56.3L0 442.4V426.8 272.6 256.1l15.5-5.9L136 204.5V78.4 61.9L151.5 56l128-48.5L288 4.2zm21.6 237.6L392 210.6V121l-82.4 31.6v89.2zM288 55.6L217.3 82.4 288 109.5l70.7-27.1L288 55.6zM173.6 447.3L256 411.1V323.2l-82.4 31.6v92.5zM152 249.8L70.8 280.6 152 311.7l81.2-31.1L152 249.8zM528 411.1V323.2l-82.4 31.6v92.5L528 411.1zM505.2 280.6L424 249.8l-81.2 30.8L424 311.7l81.2-31.1z"],
    "envelope-open-dollar": [512, 512, [], "f657", "M512 448v64H448 64 0V448 244.8l4.1 2.9L246.7 421l9.3 6.6 9.3-6.6L507.9 247.7l4.1-2.9V448zm0-256v13.5l-22.7 16.2L416 274.1V200 144 120 96H384 368 277.3 234.7 144 128 96v24 24 56 74.1L22.7 221.7 0 205.5V192l48-36V96 48H96h96L256 0l64 48h96 48V96v60l48 36zM276 144v6.3c6.6 1.2 16.7 3.2 21.1 4.4l19.3 5.1-10.3 38.7-19.3-5.1c-3.8-1-17.4-3.7-21.7-4.3c-12.2-1.9-22.2-.3-28.6 2.6c-6.3 2.9-7.9 6.2-8.2 8.1c-.6 3.4 0 4.7 .1 5c.3 .5 1 1.8 3.6 3.5c6.1 4.2 15.7 7.2 29.9 11.4l.8 .2 0 0 0 0c12.1 3.7 28.3 8.5 40.4 17.4c6.7 4.9 13 11.4 16.9 20.5c4 9.1 4.8 19.1 3 29.4c-3.3 19-15.9 32-31.6 38.7c-4.9 2.1-10.1 3.6-15.4 4.6V336v20H236V336v-6.4c-9.5-2.2-22-6.4-29.9-9.1l0 0c-1.7-.6-3.2-1.1-4.4-1.5l-19-6.3 12.6-38 19 6.3c2 .7 4.2 1.4 6.4 2.1c9.5 3.2 20.2 6.9 26.2 7.9c12.8 2 22.7 .7 28.8-1.9c5.5-2.3 7.4-5.3 8-8.8c.7-4 .1-5.9-.2-6.7c-.4-.9-1.3-2.2-3.7-4c-5.9-4.3-15.3-7.5-29.3-11.7l-2.2-.7c-11.7-3.5-27-8.1-38.6-16c-6.6-4.5-13.2-10.7-17.3-19.5c-4.2-9-5.2-18.8-3.4-29c3.2-18.3 16.2-30.9 31.1-37.7c5-2.3 10.4-4 16-5.1v-6V124h40v20z"],
    "divide": [448, 512, [10135, 247], "f529", "M176 48v96h96V48H176zm0 320v96h96V368H176zm224-80h32V224H400 48 16v64H48 400z"],
    "sun-cloud": [640, 512, [127780], "f763", "M256 73.1L150 0 126.7 126.7 0 150 73.1 256 0 362l126.7 23.3L150 512l106-73.1L362 512l11.8-64H288V380c-10.2 2.6-21 4-32 4c-70.7 0-128-57.3-128-128s57.3-128 128-128c61.3 0 112.6 43.1 125.1 100.7c20.5-22.5 50-36.7 82.9-36.7c6.1 0 12.2 .5 18 1.4L512 150 385.3 126.7 362 0 256 73.1zm32.2 273.4c2.2-39.3 28.1-72.3 63.7-85c.1-1.8 .2-3.7 .2-5.5c0-53-43-96-96-96s-96 43-96 96s43 96 96 96c11.3 0 22.1-1.9 32.2-5.5zM568 416h72V344c0-39.8-32.2-72-72-72c-10.1 0-19.7 2.1-28.4 5.8C528.8 246.5 499 224 464 224c-38.7 0-71 27.5-78.4 64c-.5 0-1.1 0-1.6 0c-35.3 0-64 28.7-64 64v64h64H568z"],
    "lamp-floor": [640, 512, [], "e015", "M128 224L192 0H448l64 224H128zm160 32h64V448h64 32v64H416 320 224 192V448h32 64V256z"],
    "square-7": [448, 512, [], "e25c", "M448 32H0V480H448V32zM296 128h24v29.4l-2.3 4.9L213.5 384h-53l3.9-8.2L258.2 176H152 128V128h24H296z"],
    "tenge-sign": [384, 512, [8376, "tenge"], "f7d7", "M0 32H384V96H0V32zM224 160H384v64H224V480H160V224H0V160H160h64z"],
    "headphones": [512, 512, [127911], "f025", "M256 80C152 80 65.8 156.3 50.4 256H128V480H0V384 288C0 146.6 114.6 32 256 32s256 114.6 256 256v96 96H384V256h77.6C446.2 156.3 360 80 256 80z"],
    "hands-holding": [640, 512, [], "f4c2", "M80 104v8 32 80 66.7l84.1 84.1L205.8 347l-36.4-36.4L146.7 288l-9.4-9.4L114.7 256 160 210.7l22.6 22.6 9.4 9.4 22.6 22.6 64 64 9.4 9.4V352v64 32 32 32H256 160 146.7l-9.4-9.4-128-128L0 365.3V352 224 160 128 104 64H80v40zm480 0V64h80v40 24 32 64V352v13.3l-9.4 9.4-128 128-9.4 9.4H480 384 352V480 448 416 352 338.7l9.4-9.4 64-64L448 242.7l9.4-9.4L480 210.7 525.3 256l-22.6 22.6-9.4 9.4-22.6 22.6L434.2 347l41.7 27.8L560 290.7V224 144 112v-8z"],
    "campfire": [512, 512, [], "f6ba", "M285.7 58.3C256.6 24.2 227.2 .1 227.2 .1s-115.2 94.2-115.2 174.5s64.5 145.5 144 145.5s144-65.1 144-145.5c0-66.9-86.4-145.5-86.4-145.5s-12.5 11.3-27.9 29.1zM301 248.2c-13.5 9.1-27.9 13.6-44.1 13.6c-40.5 0-72.9-26.4-72.9-70.9c0-21.8 13.5-40.9 40.5-74.5c3.6 4.5 55.8 71.8 55.8 71.8L312.7 150c2.7 3.6 4.5 7.3 6.3 10.9c16.2 30 9 68.2-18 87.3zM41.6 299.1l-30.5-9.6L-8.1 350.5l30.5 9.6L149.3 400 22.4 439.9l-30.5 9.6 19.2 61.1 30.5-9.6L256 433.5l214.4 67.4 30.5 9.6 19.2-61.1-30.5-9.6L362.7 400l126.9-39.9 30.5-9.6-19.2-61.1-30.5 9.6L256 366.5 41.6 299.1z"],
    "circle-ampersand": [512, 512, [], "e0f8", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM168 128h24 96 24v24 35.7c0 20.4-9.7 39.6-26.2 51.6l-18 13.2 28.6 29.9 27.7-40.1 13.7-19.7 39.5 27.3-13.7 19.7-33.3 48.1 60.9 63.6c.8 .8 1.5 1.7 2.2 2.6H327.4l-24.8-25.9-10.8 15.6L284.6 384H272 256 168 144V360 320.3c0-22.9 10.9-44.5 29.4-58.1l21.9-16.1-7.3-7.7c-12.8-13.4-20-31.2-20-49.8V152 128zm66.4 89.6l23.1-16.9c4.1-3 6.5-7.8 6.5-12.9V176H216v12.7c0 6.2 2.4 12.1 6.7 16.6l11.7 12.2zm-5.6 63.6l-27 19.8c-6.2 4.5-9.8 11.7-9.8 19.4V336h67.4l9.2-13.3-39.8-41.5z"],
    "snowflakes": [640, 512, [], "f7cf", "M256 32V0H192V32 62.1l-8.6-8.6-17-17L132.4 70.4l17 17L192 129.9v70.6l-61.2-35.3-15.6-58.2L109 83.9 62.7 96.3l6.2 23.2L72 131.3l-12.2-7-27.7-16L.1 163.7l27.7 16 12.2 7-11.8 3.2L5.1 196.1l12.4 46.4 23.2-6.2 58.2-15.6L160 256 98.8 291.3 40.7 275.7l-23.2-6.2L5.1 315.9l23.2 6.2L40 325.3l-12.2 7L.1 348.3l32 55.4 27.7-16 12.2-7-3.2 11.8-6.2 23.2L109 428.1l6.2-23.2 15.6-58.2L192 311.4v70.6l-42.6 42.6-17 17 33.9 33.9 17-17 8.6-8.6V480v32h64V480 449.9l8.6 8.6 17 17 33.9-33.9-17-17L256 382.1V311.4l61.2 35.3 15.6 58.2 6.2 23.2 46.4-12.4-6.2-23.2-3.2-11.8 12.2 7 27.7 16 32-55.4-27.7-16-12.2-7 11.8-3.2 23.2-6.2-12.4-46.4-23.2 6.2-58.2 15.6L288 256l61.2-35.3 58.2 15.6 23.2 6.2 12.4-46.4-23.2-6.2-11.8-3.2 12.2-7 27.7-16-32-55.4-27.7 16-12.2 7 3.2-11.8 6.2-23.2L338.9 83.9l-6.2 23.2-15.6 58.2L256 200.6V129.9l42.6-42.6 17-17L281.6 36.5l-17 17L256 62.1V32zM510.1 64L482.2 91.8l33.9 33.9L544 97.9l27.8 27.8 33.9-33.9L577.9 64l27.8-27.8L571.8 2.2 544 30.1 516.2 2.2 482.2 36.2 510.1 64zm37.1 129.3l-33.9 33.9 17 17L542.1 256l-11.8 11.8-17 17 33.9 33.9 17-17L576 289.9l11.8 11.8 17 17 33.9-33.9-17-17L609.9 256l11.8-11.8 17-17-33.9-33.9-17 17L576 222.1l-11.8-11.8-17-17z"],
    "hands-clapping": [544, 512, [], "e1a8", "M368 16V80 96H336V80 16 0h32V16zm-98.7 7.1l32 48 8.9 13.3-26.6 17.8-8.9-13.3-32-48-8.9-13.3L260.4 9.8l8.9 13.3zM184 102.1l17 17 151 151V184 160h24 16 24v24V345.6c0 57.1-30 110-78.9 139.4c-63.9 38.4-145.8 28.3-198.5-24.4L39 361l-17-17L56 310.1l17 17 64 64L159 369 55 265l-17-17L72 214.1l17 17L193 335 215 313 87 185l-17-17L104 134.1l17 17L249 279 271 257 167 153l-17-17L184 102.1zM465.1 484.9c-24.2 14.5-50.9 22.1-77.7 23.1c48.1-39.6 76.6-99 76.6-162.4l0-91.5 16 16V184 160h24 16 24v24V345.6c0 57.1-30 110-78.9 139.4zM443.6 9.8l26.6 17.8-8.9 13.3-32 48-8.9 13.3L393.8 84.4l8.9-13.3 32-48 8.9-13.3z"],
    "republican": [640, 512, [], "f75e", "M0 192C0 103.6 71.6 32 160 32H384c88.4 0 160 71.6 160 160v64H0V192zm127.8-64l-15.7 32-36.3 4.6 26.5 24.4L95.7 224l32.1-16.9L160 224l-6.7-34.9 26.5-24.4L143.6 160l-15.7-32zm159.7 32l-15.7-32-15.7 32-36.3 4.6 26.5 24.4L239.7 224l32.1-16.9L304 224l-6.7-34.9 26.5-24.4L287.6 160zm128.3-32l-15.7 32-36.3 4.6 26.5 24.4L383.7 224l32.1-16.9L448 224l-6.7-34.9 26.5-24.4L431.6 160l-15.7-32zM128 288H320h96 32 64 32v32 80c0 8.8 7.2 16 16 16s16-7.2 16-16V352 320h64v32 48c0 44.2-35.8 80-80 80s-80-35.8-80-80V352H448v32 96H320V384H128v96H0V384 288H128z"],
    "leaf-maple": [512, 512, [127809], "f6f6", "M368 64L480 32 448 144l64 32L384 272h80l-16 64 56 48-56 48 8 64L272 448l-32 48L183.6 394.4 90.2 487.7l-17 17L39.3 470.7l17-17L247.7 262.3l-22.3-22.3-11.3 11.3-84 84L16 272l48-32L16 56l64 8L128 8l48 56 64-16v80L336 0l32 64z"],
    "arrow-left": [448, 512, [8592], "f060", "M25.4 278.6L2.7 256l22.6-22.6 144-144L192 66.7 237.2 112l-22.6 22.6L125.2 224 416 224l32 0 0 64-32 0-290.7 0 89.4 89.4L237.2 400 192 445.3l-22.6-22.6-144-144z"],
    "person-circle-xmark": [576, 512, [], "e543", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM91.4 128h17.5H211.1h17.5l9.4 14.8 66.4 104c-15.5 16.3-28 35.7-36.3 57l-2.3 1.4-33.8-53V480v32H168V480 352H152V480v32H88V480 252.2l-33.8 53L.2 270.8 82 142.8 91.4 128zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3L502.6 320 480 297.4l-11.3 11.3L432 345.4l-36.7-36.7L384 297.4 361.4 320l11.3 11.3L409.4 368l-36.7 36.7L361.4 416 384 438.6l11.3-11.3L432 390.6l36.7 36.7L480 438.6 502.6 416l-11.3-11.3L454.6 368l36.7-36.7z"],
    "ruler": [512, 512, [128207], "f545", "M160 512L512 160 352 0 283.3 68.7l48 48L342.6 128 320 150.6l-11.3-11.3-48-48-41.4 41.4 48 48L278.6 192 256 214.6l-11.3-11.3-48-48-41.4 41.4 48 48L214.6 256 192 278.6l-11.3-11.3-48-48L91.3 260.7l48 48L150.6 320 128 342.6l-11.3-11.3-48-48L0 352 160 512z"],
    "cup-straw-swoosh": [384, 512, [], "e364", "M205 0l-4.4 18.5L174.9 128H32 0v64H32 352h32V128H352 224.2L243 48h37 24V0H280 224 205zM40 224L64 512H320l24-288H40zm194.4 78.9c18.8-10.1 42-17.2 72.7-20.6L303 331.2c-20.8 3.1-35.2 8.2-45.8 13.9c-17.2 9.3-26.9 21.2-39.9 37.2l-.7 .8c-13.3 16.4-29.5 35.9-58.7 50.4c-17.7 8.8-39.3 15.2-66.7 18.9l-4-47.9c22.1-3.2 37.7-8.3 49.4-14.1c19.3-9.5 30.1-22 42.8-37.6l1.9-2.3c12.3-15.2 27.4-33.8 53.1-47.7z"],
    "temperature-sun": [640, 512, ["temperature-hot"], "f76a", "M104 104L0 121.3 60.7 208 0 294.7 104 312l17.3 104L208 355.3 294.7 416l.8-5c-4.9-16.1-7.5-33.3-7.5-51c0-37.7 11.8-72.6 32-101.2V105.3l-8-1.3L294.7 0 208 60.7 121.3 0 104 104zM208 272a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm0-160a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM401.8 317.8L416 300.2V277.5 64h96V277.5v22.7l14.2 17.6C537.4 331.5 544 348.9 544 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-19.1 6.6-36.5 17.8-50.3zM576 0H512 416 352V64 277.5c-20 24.7-32 56.2-32 90.5c0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5V64 0zM464 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V112 96H448v16V322.8c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48z"],
    "align-left": [448, 512, [], "f036", "M288 32V96H0V32H288zm0 256v64H0V288H288zM0 160H448v64H0V160zM448 416v64H0V416H448z"],
    "dice-d6": [448, 512, [], "f6d1", "M432 112L224 240 16 112 224 0 432 112zM208 272V512L0 384V144L208 272zM448 144V384L240 512V272L448 144z"],
    "restroom": [640, 512, [], "f7bd", "M80 48a48 48 0 1 1 96 0A48 48 0 1 1 80 48zM53.4 128H76.9 179.1h23.5l7 22.5 44.9 144-54.5 17V480v32H136V480 352H120V480v32H56V480 311.5l-54.5-17 44.9-144 7-22.5zM344 0V24 488v24H296V488 24 0h48zM464 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm-26.6 80h23.5H563.1h23.5l7 22.5 44.9 144L598.3 307 624 384H584v96 32H520V480 384H504v96 32H440V480 384H400l25.7-77-40.2-12.5 44.9-144 7-22.5z"],
    "high-definition": [576, 512, ["rectangle-hd"], "e1ae", "M0 32H576V480H0V32zM304 160v24V328v24h24 56c53 0 96-43 96-96s-43-96-96-96H328 304zm80 48c26.5 0 48 21.5 48 48s-21.5 48-48 48H352V208h32zM160 184V160H112v24 72 72 24h48V328 280h64v48 24h48V328 256 184 160H224v24 48H160V184z"],
    "j": [320, 512, [106], "4a", "M320 32V64 320c0 88.4-71.6 160-160 160S0 408.4 0 320V288 256H64v32 32c0 53 43 96 96 96s96-43 96-96V64 32h64z"],
    "galaxy": [512, 512, [], "e008", "M336 0h32L355.4 7.8C303.8 39.5 270.6 93.4 264.9 153c16.5-5.8 34.8-9 55.1-9c2.9 0 5.8 .1 8.7 .2c.9-.1 1.9-.2 2.8-.2c1.9 0 3.7 .3 5.5 .7C435 153.3 512 235.7 512 336v32l-7.8-12.6c-31.7-51.5-85.7-84.8-145.2-90.5c5.8 16.5 9 34.8 9 55.1c0 2.9-.1 5.8-.2 8.7c.1 .9 .2 1.9 .2 2.8c0 1.9-.3 3.7-.7 5.5C358.7 435 276.3 512 176 512H144l12.6-7.8c51.5-31.7 84.8-85.7 90.5-145.2c-16.5 5.8-34.8 9-55.1 9c-2.9 0-5.8-.1-8.7-.2c-.9 .1-1.9 .2-2.8 .2c-1.9 0-3.7-.3-5.5-.7C77 358.7 0 276.3 0 176V144l7.8 12.6c31.7 51.5 85.7 84.8 145.2 90.5c-5.8-16.5-9-34.8-9-55.1c0-2.9 .1-5.8 .2-8.7c-.1-.9-.2-1.9-.2-2.8c0-1.9 .3-3.7 .7-5.5C153.3 77 235.7 0 336 0zM256 296l40-40-40-40-40 40 40 40z"],
    "users-viewfinder": [640, 512, [], "e595", "M0 0H24 136h24V48H136 48v88 24H0V136 24 0zM175.8 128a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm41.1 128l-7.3 21.9L190.3 336H96l24-80h96.9zM544 336H449.7l-19.4-58.1L423.1 256H520l24 80zm-128 0l16 48H208l16-48 16-48h17.6H382.4 400l16 48zm48-208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM256 192a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM616 0h24V24 136v24H592V136 48H504 480V0h24H616zM0 512V488 376 352H48v24 88h88 24v48H136 24 0zm616 0H504 480V464h24 88V376 352h48v24V488v24H616z"],
    "file-video": [384, 512, [], "f1c8", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM64 256H224V416H64V256zM320 400l-64-32V304l64-32V400z"],
    "cherries": [640, 512, [], "e0ec", "M288 40l12.5-20.5L269.1 .3l-4.9 36.5s0 0 0 0l0 0 0 0 0 0 0 .1-.1 .8c-.1 .7-.3 1.9-.6 3.5c-.6 3.1-1.5 7.9-2.9 13.9c-2.8 12.2-7.5 29.7-15.2 50.7c-13.9 38.3-37.3 87.6-76 136.4C152.3 233.5 126.6 224 96 224c0 0-96 0-96 112C0 480 144 512 192 512s192-16 192-176c0-112-96-112-96-112c-20.2 0-38.2 4.1-53.1 9.5c26.5-40.4 44.1-79.4 55.7-111.2c5.7-15.6 9.9-29.6 13.1-41.3c11.9 9.5 26.3 22.2 41 37.6c29.1 30.7 58.2 71.2 72.2 119.6c-12-5.3-27-10.3-44.1-12.7C397.3 247.7 416 282.9 416 336c0 71.9-26.1 120.9-62.1 152.9C390.4 506.3 427.7 512 448 512c48 0 192-16 192-176c0-112-96-112-96-112c-32.3 0-59.3 10.6-76.3 19.6c-14.3-67.2-52.9-120.9-88.3-158.2C359.3 64.4 339.8 48 325.3 36.9c-7.3-5.6-13.3-9.8-17.6-12.7c-2.2-1.5-3.9-2.6-5.1-3.4c-.6-.4-1.1-.7-1.4-.9l-.4-.3-.1-.1 0 0 0 0s0 0-12.5 20.5z"],
    "up-right-from-square": [512, 512, ["external-link-alt"], "f35d", "M512 176l-32 32-65.4-65.4-168 168L224 333.3 178.7 288l22.6-22.6 168-168L304 32 336 0H512V176zM0 32H32 160h32V96H160 64V448H416V352 320h64v32V480v32H448 32 0V480 64 32z"],
    "circle-sort": [512, 512, ["sort-circle"], "e030", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm144-64v32H368V192L256 96 144 192zM256 416l112-96V288H144v32l112 96z"],
    "table-cells": [512, 512, ["th"], "f00a", "M512 32H0V480H512V32zM152 96v64H64V96h88zm56 0h88v64H208V96zm240 0v64H360V96h88zM64 224h88v64H64V224zm232 0v64H208V224h88zm64 0h88v64H360V224zM152 352v64H64V352h88zm56 0h88v64H208V352zm240 0v64H360V352h88z"],
    "file-pdf": [512, 512, [], "f1c1", "M0 0H224V160H384V304H112V512H0V0zM384 128H256V0L384 128zM176 352h32c30.9 0 56 25.1 56 56s-25.1 56-56 56H192v32 16H160V496 448 368 352h16zm32 80c13.3 0 24-10.7 24-24s-10.7-24-24-24H192v48h16zm96-80h32c26.5 0 48 21.5 48 48v64c0 26.5-21.5 48-48 48H304 288V496 368 352h16zm32 128c8.8 0 16-7.2 16-16V400c0-8.8-7.2-16-16-16H320v96h16zm80-128h16 48 16v32H480 448v32h32 16v32H480 448v48 16H416V496 432 368 352z"],
    "siren": [448, 512, [], "e02d", "M80 96L48 352h57.9l22.2-178 1.8-14h32.2l-2.2 18L138.1 352H400L368 96H80zM448 384H0v96H448V384z"],
    "arrow-up-to-dotted-line": [448, 512, [], "e0a1", "M64 32H0V96H64V32zm96 0H96V96h64V32zm32 0V96h64V32H192zm160 0H288V96h64V32zm32 0V96h64V32H384zM246.6 169.4L224 146.7l-22.6 22.6-128 128L50.7 320 96 365.3l22.6-22.6L192 269.3V336 448v32h64V448 336 269.3l73.4 73.4L352 365.3 397.3 320l-22.6-22.6-128-128z"],
    "image-landscape": [576, 512, ["landscape"], "e1b5", "M576 64H0V448H576V64zM128 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm200-16l19.2 25.6L484 384H80.8l12.8-15.4 80-96L192 250.5l18.4 22.1 23.7 28.5 74.6-99.5L328 176z"],
    "tank-water": [448, 512, [], "e452", "M206.4 32H64 0V96 416v64H64 384h64V416 96 32H384 241.6L251 46.8 282.3 96H384V298c-8.3-3-16.2-6.8-23.4-10.8c-15.4-8.7-27-19.1-40-30.7l-.7-.6-.7 .6c-13 11.6-24.6 22-40 30.7c-15.8 9-35.5 16.8-55.1 16.9h-.5c-19.6-.1-39.3-7.9-55.1-16.9c-15.4-8.7-27-19.1-40-30.7l0 0-.7-.6-.7 .6c-13 11.6-24.6 22-40 30.7c-7.1 4-15 7.8-23.3 10.8V96H165.7L197 46.8 206.4 32zm-2.8 64l-26.9 42.3c-5.7 8.9-8.7 19.3-8.7 29.9c0 30.8 25.2 55.8 56 55.8s56-25 56-55.8c0-10.6-3-21-8.7-29.9L244.4 96 243 93.8 224 64 205 93.8 203.6 96z"],
    "curling-stone": [576, 512, [129356, "curling"], "f44a", "M192 32H160V64v96H96v64H64L0 288v48H576V288l-64-64H480V160H224V96H384h32V32H384 192zM0 368v48l64 64H512l64-64V368H0z"],
    "gamepad-modern": [640, 512, [127918, 63676, "gamepad-alt"], "e5a2", "M0 480H200l16-96H424l16 96H640L597.2 96 480 32H320 160L42.8 96 0 480zM432 232a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm24-56a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zm-240-8v32h32 24v48H248 216v32 24H168V280 248H136 112V200h24 32V168 144h48v24z"],
    "messages-question": [640, 512, [], "e1e7", "M416 0H0V320H96v64l106.7-64H416V0zM256 352v96H437.3L544 512V448h96V128H448V352H256zM134.7 108c0-25.8 20.9-46.7 46.7-46.7h47.4c29.1 0 52.6 23.6 52.6 52.6c0 18.8-10.1 36.3-26.4 45.6L228 175v6.3 20H188v-20V163.5 151.9l10-5.8L235 124.9c3.9-2.3 6.3-6.4 6.3-10.9c0-7-5.7-12.6-12.6-12.6H181.3c-3.7 0-6.7 3-6.7 6.7l0 5.5-40 0 0-5.5zM188 234.7h40v40H188v-40z"],
    "book-bible": [448, 512, ["bible"], "f647", "M96 0C43 0 0 43 0 96V416c0 53 43 96 96 96H384h32 32V448H416V384h32V0H416 384 96zm0 384H352v64H96c-17.7 0-32-14.3-32-32s14.3-32 32-32zM208 64h64v64h64v64H272V320H208V192H144V128h64V64z"],
    "o": [448, 512, [111], "4f", "M224 96a160 160 0 1 0 0 320 160 160 0 1 0 0-320zM448 256A224 224 0 1 1 0 256a224 224 0 1 1 448 0z"],
    "suitcase-medical": [512, 512, ["medkit"], "f0fa", "M128 0h24H360h24V24 96v32V480H128V128 96 24 0zM336 48H176V96H336V48zM96 96V480H0V96H96zM416 480V96h96V480H416zM224 192v64H160v64h64v64h64V320h64V256H288V192H224z"],
    "briefcase-arrow-right": [512, 512, [], "e2f2", "M128 0h24H360h24V24 96H512V480H0V96H128V24 0zM336 48H176V96H336V48zM297 191l-17-17L246.1 208l17 17 39 39H152 128v48h24H302.1l-39 39-17 17L280 401.9l17-17 80-80 17-17-17-17-80-80z"],
    "expand-wide": [512, 512, [], "f320", "M32 64H0V96v96 32H64V192 128h64 32V64H128 32zM64 320V288H0v32 96 32H32h96 32V384H128 64V320zM384 64H352v64h32 64v64 32h64V192 96 64H480 384zM512 320V288H448v32 64H384 352v64h32 96 32V416 320z"],
    "clock-eleven-thirty": [512, 512, [], "e348", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392V263.3l-60-90-13.3-20 39.9-26.6 13.3 20 64 96 4 6V256 392v24H232V392z"],
    "rv": [640, 512, [], "f7be", "M224 0H384V32H608V160H384V416H254.4c1 5.2 1.6 10.5 1.6 16c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-5.5 .6-10.8 1.6-16H96L0 320V32H224V0zm32 128H96v96H256V128zM208 432a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-80-48V400 320 288 216 192h24 88 8.6l6.6 5.4 88 72 8.8 7.2V288v32 96H574.4c1 5.2 1.6 10.5 1.6 16c0 44.2-35.8 80-80 80s-80-35.8-80-80V416zM578.1 288l-58.7-48H464v48H578.1z"],
    "user-secret": [448, 512, [128373], "f21b", "M121.1 87.5L160 0l64 32L288 0l38.9 87.5C380.5 96 416 111 416 128c0 14.3-25 27.1-64.6 35.9c.4 4 .6 8 .6 12.1c0 17-3.3 33.2-9.3 48H416L375.3 336H416l32 176H0L32 336H72.7L32 224h73.3c-6-14.8-9.3-31-9.3-48c0-4.1 .2-8.1 .6-12.1C57 155.1 32 142.3 32 128c0-17 35.5-32 89.1-40.5zM144 224h64l8-32h16l8 32h64l13.5-54.1C289.8 173.8 258 176 224 176s-65.8-2.2-93.5-6.1L144 224zm-16 64l48 192 32-128-16-32-64-32zM272 480l48-192-64 32-16 32 32 128z"],
    "otter": [640, 512, [129446], "f700", "M188.8 193.6L208 208h16 32V192 160 144c0-35.3-28.7-64-64-64H128c-35.3 0-64 28.7-64 64v56 8H96h16l19.2-14.4 7.9-5.9-7.5-5-3.6-2.4V176 152v-8h8 48 8v8 24 4.3l-3.6 2.4-7.5 5 7.9 5.9zM256 320v64H384V352 320l32-32 32-32V224 192h64v48 16 64h32V204.3c0-48.2-30.8-91-76.6-106.3l-8.5-2.8 8.2-30.9 19.9 4C576 86.1 640 164.2 640 254.9l0 1.1h0c0 123.7-100.3 224-224 224h-1.1H256h-.6C132 480 32 380 32 256.6V256H16V208 144H0V96H24h2.8C44.8 58.2 83.3 32 128 32h64c44.7 0 83.2 26.2 101.2 64H296h24v48H304v16h48 32v64H352 320v32h80l-48 48v16H320c-41.8 0-77.4-26.7-90.5-64H192l-32-24-32 24H96c0 35.3 28.7 64 64 64h64 32zM96 128a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm112 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "dreidel": [448, 512, [], "f792", "M422.6 102.6L445.3 80 400 34.7 377.4 57.4 288 146.7 214.6 73.4 192 50.7 169.4 73.4l-68.7 68.7L337.9 379.3l68.7-68.7L429.3 288l-22.6-22.6L333.3 192l89.4-89.4zM315.3 401.9L78.1 164.7 9.4 233.4 0 242.7V256 448v32H32 224h13.3l9.4-9.4 68.7-68.7z"],
    "person-dress": [320, 512, ["female"], "f182", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM91.4 128h17.5H211.1h17.5l9.4 14.8 81.7 128-53.9 34.4-42-65.8L272 384H232v96 32H168V480 384H152v96 32H88V480 384H48L96.2 239.4l-42 65.8L.2 270.8 82 142.8 91.4 128z"],
    "comment-dollar": [512, 512, [], "f651", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM276 144V124H236v20 6c-5.6 1.2-11 2.9-16 5.1c-15 6.8-27.9 19.4-31.1 37.7c-1.8 10.2-.8 20 3.4 29c4.2 8.8 10.7 15 17.3 19.5c11.6 7.9 26.9 12.5 38.6 16l2.2 .7c13.9 4.2 23.4 7.4 29.3 11.7c2.5 1.8 3.4 3.2 3.7 4c.3 .8 .9 2.6 .2 6.7c-.6 3.5-2.5 6.4-8 8.8c-6.1 2.6-16 3.9-28.8 1.9c-6-1-16.7-4.6-26.2-7.9l0 0c-2.2-.8-4.4-1.5-6.4-2.1l-19-6.3-12.6 38 19 6.3c1.2 .4 2.7 .9 4.4 1.5l0 0c7.9 2.7 20.3 7 29.9 9.1V336v20h40V336v-5.5c5.4-1 10.6-2.5 15.4-4.6c15.7-6.7 28.4-19.7 31.6-38.7c1.8-10.4 1-20.3-3-29.4c-3.9-9-10.2-15.6-16.9-20.5c-12.2-8.8-28.3-13.7-40.4-17.4l0 0 0 0-.8-.2c-14.2-4.3-23.8-7.3-29.9-11.4c-2.6-1.8-3.4-3-3.6-3.5c-.2-.3-.7-1.6-.1-5c.3-1.9 1.9-5.2 8.2-8.1c6.4-2.9 16.4-4.5 28.6-2.6c4.3 .7 17.9 3.3 21.7 4.3l19.3 5.1 10.3-38.7-19.3-5.1c-4.4-1.2-14.5-3.2-21.1-4.4V144z"],
    "business-time": [640, 512, ["briefcase-clock"], "f64a", "M128 0h24H360h24V24 96H512v96.7c-5.3-.5-10.6-.7-16-.7c-54.7 0-103.5 24.9-135.8 64H352 192 0V96H128V24 0zM320 368c0 42.5 15.1 81.6 40.2 112H0V288H192v64H320.7c-.5 5.3-.7 10.6-.7 16zM336 48H176V96H336V48zm16 320a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm160-80H480v16 64 16h16 48 16V352H544 512V304 288z"],
    "flower-tulip": [512, 512, [127799], "f801", "M176 80L96 32v96c0 70.7 57.3 128 128 128V394.8C192.1 349.5 139.5 320 80 320H0v16c0 97.2 78.8 176 176 176h48 32 32 48c97.2 0 176-78.8 176-176V320H432c-59.5 0-112.1 29.5-144 74.8V256c70.7 0 128-57.3 128-128V32L336 80 256 0 176 80z"],
    "people-pants-simple": [512, 512, [], "e21a", "M128 128A64 64 0 1 0 128 0a64 64 0 1 0 0 128zM232 352l-8-192H32L24 352H64V512H192V352h40zM384 128A64 64 0 1 0 384 0a64 64 0 1 0 0 128zM488 352l-8-192H288l-8 192h40V512H448V352h40z"],
    "cloud-drizzle": [512, 512, [], "f738", "M96 320H0V224c0-41.8 26.7-77.4 64-90.5V112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H416 96zm-8 56v48 24H40V424 376 352H88v24zm96 64v48 24H136V488 440 416h48v24zm192-24v24 48 24H328V488 440 416h48zm-96-40v48 24H232V424 376 352h48v24zm192-24v24 48 24H424V424 376 352h48z"],
    "table-cells-large": [512, 512, ["th-large"], "f009", "M448 96V224H288V96H448zm0 192V416H288V288H448zM224 224H64V96H224V224zM64 288H224V416H64V288zM64 32H0V96 416v64H64 448h64V416 96 32H448 64z"],
    "book-tanakh": [448, 512, ["tanakh"], "f827", "M352 0c53 0 96 43 96 96V416c0 53-43 96-96 96H64 32 0V448H32V384H0V0H32 64 352zm0 384H96v64H352c17.7 0 32-14.3 32-32s-14.3-32-32-32zM208 40L194.1 64l-27.7 48H111 83.3l13.9 24 27.7 48L97.1 232 83.3 256H111h55.4l27.7 48L208 328l13.9-24 27.7-48H305h27.7l-13.9-24-27.7-48 27.7-48 13.9-24H305 249.6L221.9 64 208 40zm13.9 72H194.1L208 88l13.9 24zm-41.6 24h55.4l27.7 48-27.7 48H180.3l-27.7-48 27.7-48zm-27.7 0l-13.9 24-13.9-24h27.7zm-13.9 72l13.9 24H124.9l13.9-24zm55.4 48h27.7L208 280l-13.9-24zm69.3-24l13.9-24 13.9 24H263.4zm13.9-72l-13.9-24h27.7l-13.9 24z"],
    "solar-system": [512, 512, [], "e02f", "M448 256c0 41.9-13.4 80.6-36.2 112.2C387.3 370.3 368 390.9 368 416c0 26.5 21.5 48 48 48s48-21.5 48-48c0-3.2-.3-6.4-.9-9.4C493.8 364.3 512 312.3 512 256C512 114.6 397.4 0 256 0c-42.3 0-82.1 10.2-117.2 28.4c18.6 11.8 32 31.1 36 53.6C199.4 70.4 227 64 256 64c106 0 192 86 192 192zM256 448C150 448 64 362 64 256c0-41.9 13.4-80.6 36.2-112.2C124.7 141.7 144 121.1 144 96c0-26.5-21.5-48-48-48S48 69.5 48 96c0 3.2 .3 6.4 .9 9.4C18.2 147.7 0 199.7 0 256C0 397.4 114.6 512 256 512c42.1 0 81.7-10.1 116.8-28.1c-18.5-11.9-31.8-31.3-35.6-53.8C312.5 441.6 285 448 256 448zM360 256c0 57.4-46.6 104-104 104s-104-46.6-104-104s46.6-104 104-104c20.6 0 39.8 6 56 16.4c.2 20.6 16 37.6 36.2 39.5c7.5 14.4 11.8 30.8 11.8 48.2zm32-88c0-22.1-17.9-40-40-40c-4 0-7.8 .6-11.5 1.7C316.4 113.5 287.3 104 256 104c-83.9 0-152 68.1-152 152s68.1 152 152 152s152-68.1 152-152c0-26.6-6.8-51.5-18.8-73.3c1.8-4.6 2.8-9.5 2.8-14.7zM256 320l64-64-64-64-64 64 64 64z"],
    "seal-question": [512, 512, [], "e243", "M256 0l75 75H437V181l75 75-75 75V437H331l-75 75-75-75H75V331L0 256l75-75V75H181L256 0zM168 184v6.5l48 0 0-6.5c0-4.4 3.6-8 8-8h56.9c8.4 0 15.1 6.8 15.1 15.1c0 5.4-2.9 10.4-7.6 13.1l-44.3 25.4L232 236.6v13.9V272v24h48V272v-7.6l32.3-18.5c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1H224c-30.9 0-56 25.1-56 56zm64 152v48h48V336H232z"],
    "phone-volume": [512, 512, ["volume-control-phone"], "f2a0", "M0 32L144 0l80 144-83.8 67c36.1 68.4 92.3 124.6 160.8 160.8L368 288l144 80L480 512H448C200.6 512 0 311.4 0 64L0 32zM464 256c0-114.9-93.1-208-208-208V0C397.4 0 512 114.6 512 256H464zM256 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm0-80V96c88.4 0 160 71.6 160 160H368c0-61.9-50.1-112-112-112z"],
    "disc-drive": [512, 512, [], "f8b5", "M32 32H480V416h32v64H480 32 0V416H32V32zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192 0A160 160 0 1 0 96 256a160 160 0 1 0 320 0z"],
    "hat-cowboy-side": [640, 512, [], "f8c1", "M160 96l-17.7 97.1c6.8-.7 13.6-1.1 20.5-1.1h10.7c39.4 0 77.8 12.1 110.1 34.7L562.4 421.8l35.1 24.6c24.4-6 42.5-28.1 42.5-54.4c0-75.8-94.7-126.6-134.6-144.7L464 32H400L160 96zM0 448H544L265.3 252.9c-26.9-18.8-58.9-28.9-91.8-28.9H162.9c-60.6 0-116 34.2-143.1 88.4L13.5 325C4.6 342.7 0 362.3 0 382.2V448z"],
    "table-rows": [512, 512, ["rows"], "e292", "M0 32H512V480H0V32zM128 96V224H448V96H128zM448 288H128V416H448V288z"],
    "location-exclamation": [384, 512, ["map-marker-exclamation"], "f608", "M192 512s192-208 192-320C384 86 298 0 192 0S0 86 0 192C0 304 192 512 192 512zM216 96v24V232v24H168V232 120 96h48zM168 336V288h48v48H168z"],
    "face-fearful": [512, 512, [], "e375", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-192c44.2 0 80 35.8 80 80v16H176V400c0-44.2 35.8-80 80-80zM96 224a64 64 0 1 1 128 0A64 64 0 1 1 96 224zm256-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM176 112c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8L95.2 150.6 73.4 127.2l11.7-10.9c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1h16v32H176zm173 .9c-4.3-.6-8.6-.9-13-.9H320V80h16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2l11.7 10.9-21.8 23.4-11.7-10.9c-15.5-14.5-34.8-24-56.1-26.8zM192.4 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "clipboard-user": [384, 512, [], "f7f3", "M192 0c-41.8 0-77.4 26.7-90.5 64H0V512H384V64H282.5C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM128 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm144 96l32 96H80l32-96H272z"],
    "bus-school": [512, 512, [], "f5dd", "M256 0C371.9 0 464 48 464 48V96v16h48V240H464l0 16h16V448H448v64H352V448H160v64H64V448H32V256H48V96h0V48s92.1-48 208-48zM48 240H0V112H48l0 128zM272 128V256H400V128H272zm-32 0H112V256H240V128zM112 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm288 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM352 96V64H336 176 160V96h16H336h16z"],
    "film-slash": [640, 512, [], "e179", "M29.4 .1l19 14.7L70.5 32H576V424.4l44.9 34.9 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1zM317.9 224H416V96H224v55.1L317.9 224zm88.3 192l81.2 64H64V146.4L162.5 224H112v64h64V234.7L243.7 288H224V416H406.2zM176 352H112v64h64V352zM528 224H464v64h64V224zM464 96v64h64V96H464z"],
    "square-arrow-down-right": [448, 512, [], "e262", "M0 480H448V32H0V480zM312 368H160 136V320h24 94.1L119 185l-17-17L136 134.1l17 17 135 135V184 160h48v24V344v24H312z"],
    "book-sparkles": [448, 512, ["book-spells"], "f6b8", "M96 0C43 0 0 43 0 96V416c0 53 43 96 96 96H384h32 32V448H416V384h32V0H416 384 96zm0 384H352v64H96c-17.7 0-32-14.3-32-32s14.3-32 32-32zM264 200l24-56 24 56 56 24-56 24-24 56-24-56-56-24 56-24zM176 64l16 32 32 16-32 16-16 32-16-32-32-16 32-16 16-32z"],
    "washing-machine": [448, 512, ["washer"], "f898", "M0 0H448V512H0V0zM368 304A144 144 0 1 0 80 304a144 144 0 1 0 288 0zM88 112a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM208 88a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm16 328c-61.9 0-112-50.1-112-112c0-16.5 3.6-32.2 10-46.3c7.4-1.1 14.8-1.7 22-1.7c32 0 56 16 80 32s48 32 80 32c10.9 0 21.4-.9 31.2-2.5C328.5 373 281.3 416 224 416z"],
    "child": [320, 512, [], "f1ae", "M96 64a64 64 0 1 1 128 0A64 64 0 1 1 96 64zm4.9 96h16 86.2 16l9.6 12.8 72.1 96L320 294.4l-51.2 38.4-19.2-25.6L240 294.4V480v32H176V480 384H144v96 32H80V480 294.4l-9.6 12.8L51.2 332.8 0 294.4l19.2-25.6 72.1-96 9.6-12.8z"],
    "lira-sign": [320, 512, [8356], "f195", "M112 159.2c0-34.9 28.3-63.2 63.2-63.2c7.4 0 14.7 1.3 21.6 3.8l72.2 26.3L299.1 137 321 76.9 290.9 65.9 218.7 39.7c-13.9-5.1-28.6-7.7-43.5-7.7C105 32 48 89 48 159.2V192H0v64H48v32H0v64H40.2L3.4 425.7 0 432.4V440v8 32H32 288h32V416H288 79.8l28.8-57.7 3.2-6.3H256V288H112V256H256V192H112V159.2z"],
    "user-visor": [448, 512, [], "e04c", "M342.7 176c-19 46.9-65 80-118.7 80s-99.7-33.1-118.7-80H80V48h44.1C147.5 18.7 183.6 0 224 0s76.5 18.7 99.9 48H368V176H342.7zM384 304l64 208H0L64 304H384zM328 440l24 24 8-8-40-88-40 88 8 8 40-24zM144 96H128v32h16H304h16V96H304 144z"],
    "file-plus-minus": [384, 512, [], "e177", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM208 208v48h48 16v32H256 208v48 16H176V336 288H128 112V256h16 48V208 192h32v16zM128 384H256h16v32H256 128 112V384h16z"],
    "chess-clock-flip": [640, 512, ["chess-clock-alt"], "f43e", "M384 32H544V80H488v48H640V480H0V128H96V96H256v32H440V80H384V32zM288 304A112 112 0 1 0 64 304a112 112 0 1 0 224 0zm-41.4-48l-11.3 11.3-48 48L176 326.6 153.4 304l11.3-11.3 48-48L224 233.4 246.6 256zM464 416a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm16-176v64 16H448V304 240 224h32v16z"],
    "satellite": [512, 512, [128752], "f7bf", "M384 416l33.9-33.9 60.1-60.1L512 288l-33.9-33.9L416 192l80-80L400 16 320 96 257.9 33.9 224 0 190.1 33.9 129.9 94.1 96 128l33.9 33.9L192 224l-17 17c-24.1-10.9-50.9-17-79-17c-34.5 0-66.9 9.1-94.9 25.1L120.7 368.7 96.3 393.1c-2.6-.7-5.4-1.1-8.3-1.1c-17.7 0-32 14.3-32 32s14.3 32 32 32s32-14.3 32-32c0-2.9-.4-5.6-1.1-8.3l24.4-24.4L262.9 510.9c16-28 25.1-60.4 25.1-94.9c0-28.2-6.1-54.9-17-79l17-17 62.1 62.1L384 416zM321.9 286.1l60.1-60.1L444.1 288 384 348.1l-62.1-62.1zm-96-96L163.9 128 224 67.9l62.1 62.1-60.1 60.1z"],
    "plane-lock": [640, 512, [], "e558", "M192 93.7C192 59.5 221 0 256 0c36 0 64 59.5 64 93.7l0 66.3 104.3 69.5C419 242.6 416 257 416 272v16H384l0 53.3L320 320v80l64 48v64L256 480 128 512V448l64-48V320L0 384V288L192 160V93.7zM528 240c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H416V320h32V272z"],
    "steering-wheel": [512, 512, [], "f622", "M224 358.9v86.5C143.6 431.9 80.1 368.4 66.7 288H168.9L224 358.9zm64 0L343.1 288H445.3C431.9 368.4 368.4 431.9 288 445.3V358.9zM352 224l-16-32H176l-16 32H66.7C81.9 133.2 160.9 64 256 64s174.1 69.2 189.3 160H352zM256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512z"],
    "tag": [448, 512, [127991], "f02b", "M0 32V256L224 480 448 256 224 32H0zm112 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "stretcher": [640, 512, [], "f825", "M70.8 63.5L189.1 192H640v96H168 146.9l-14.3-15.5L.2 128.5l70.6-65zM263.2 320h81.6L368 336.9 391.2 320h81.6l-64 46.5 37.3 27.1c9.8-6.1 21.4-9.7 33.9-9.7c35.3 0 64 28.7 64 64s-28.7 64-64 64s-64-28.7-64-64c0-5.3 .7-10.5 1.9-15.5L368 396.2l-49.9 36.3c1.2 5 1.9 10.2 1.9 15.5c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c12.4 0 24 3.5 33.9 9.7l37.3-27.1-64-46.5zM272 448a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm224 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "book-section": [448, 512, ["book-law"], "e0c1", "M0 96C0 43 43 0 96 0H384h32 32V384H416v64h32v64H416 384 96c-53 0-96-43-96-96V96zM64 416c0 17.7 14.3 32 32 32H352V384H96c-17.7 0-32 14.3-32 32zM235.9 243.2c37.9 9.8 46.1 15 43.6 27.7c-2.5 13.2-23.7 19.6-51.7 15.7c-10.2-1.4-22.4-5.4-33.1-8.9l-5.9-1.9-9.8 30.5 5.8 1.9 0 0c12 3.9 25.7 8.3 38.6 10.1c7 1 13.8 1.5 20.2 1.5c36.5 0 62.2-15.8 67.3-42.8c4.1-21.2-4-34.9-16.7-44.4c8.7-7.1 14.5-16.4 16.7-27.6c8.6-45.1-36.9-56.9-67-64.7l0 0-7.3-1.9c-36.5-9.7-38-16.5-36.2-25.8c2.5-13.2 23.8-19.7 51.6-15.7c6.6 .9 14.6 2.9 25.2 6.2l9.5-30.6c-12.2-3.8-21.9-6.2-30.2-7.3c-47.1-6.7-81.5 9.6-87.5 41.3c-4.1 21.3 4.4 35.1 16.7 44.5c-8.7 7.1-14.5 16.4-16.7 27.5c-8.5 44.6 37.4 56.8 59.5 62.7l7.5 2zm0-72c37.9 9.8 46.1 15 43.6 27.7c-2.2 11.3-16.5 14.9-25.2 16.1c-3.6-1-17.7-4.7-17.7-4.7c-36.5-9.7-38-16.5-36.3-25.8c2.2-11.3 16.5-14.9 25.2-16.1c.9 .2 10.3 2.7 10.3 2.7z"],
    "inboxes": [512, 512, [], "e1bb", "M74.3 0H96 416h21.7l8 20.1 64 160 2.3 5.7V192v96 32H480 32 0V288 192v-6.2l2.3-5.7 64-160L74.3 0zm43.3 64L79.3 160H144l32 64H336l32-64h64.7L394.3 64H117.7zM0 352H144l32 64H336l32-64H512V512H0V352z"],
    "coffee-bean": [448, 512, [], "e13e", "M398 71.7c1 .9 1.9 1.8 2.9 2.8c74.2 74.2 54.2 214.6-44.8 313.6C269 475.3 149.7 501.2 71.7 455.5l68.4-124.3L328.9 205.3l3.5-2.4 1.9-3.8L398 71.7zM45.9 436.1c-1.1-1.1-2.2-2.1-3.3-3.2c-74.2-74.2-54.2-214.6 44.8-313.6C174.6 32 294.1 6.1 372 52.2L307.6 181 119.1 306.7l-3.3 2.2-1.9 3.4L45.9 436.1z"],
    "circle-yen": [512, 512, [], "e5d0", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM137.5 144h61L256 217.2 313.5 144h61l-11.7 14.8L286.5 256H320h16v32H320 280v32h40 16v32H320 280v25 24H232V377 352H192 176V320h16 40V288H192 176V256h16 33.5l-76.4-97.2L137.5 144z"],
    "brackets-curly": [576, 512, [], "f7ea", "M64 32H96h96 32V96H192 128v96 13.3l-9.4 9.4L77.3 256l41.4 41.4 9.4 9.4V320v96h64 32v64H192 96 64V448 333.3L9.4 278.6 0 269.3V242.7l9.4-9.4L64 178.7V64 32zm448 0V64 178.7l54.6 54.6 9.4 9.4v26.5l-9.4 9.4L512 333.3V448v32H480 384 352V416h32 64V320 306.7l9.4-9.4L498.7 256l-41.4-41.4-9.4-9.4V192 96H384 352V32h32 96 32z"],
    "ellipsis-stroke-vertical": [192, 512, ["ellipsis-v-alt"], "f39c", "M112 80v32H80l0-32 32 0zM80 32L32 32l0 48 0 32 0 48H80h32l48 0V112 80 32l-48 0L80 32zm32 208l0 32H80V240h32zM80 192H32l0 48 0 32 0 48H80h32 48V272l0-32V192l-48 0H80zm0 208h32l0 32H80V400zM32 352l0 48 0 32 0 48H80h32 48V432 400 352H112 80 32z"],
    "comment": [512, 512, [128489, 61669], "f075", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 49.6 21.3 95.1 56.9 130.8L16 480l150.4-45.1c27.9 8.5 58.1 13.1 89.6 13.1z"],
    "square-1": [448, 512, [], "e256", "M0 32H448V480H0V32zM144 336v48h24 56 56 24V336H280 248V152 128H224h-8-6.2l-5.4 3L144 164.5v54.9l11.7-6.5L200 188.3V336H168 144z"],
    "cake-candles": [448, 512, [127874, "birthday-cake", "cake"], "f1fd", "M96 0L63.9 44.9C58.8 52.1 56 60.8 56 69.6V72c0 22.1 17.9 40 40 40s40-17.9 40-40V69.6c0-8.8-2.8-17.5-7.9-24.6L96 0zM224 0L191.9 44.9c-5.1 7.2-7.9 15.8-7.9 24.6V72c0 22.1 17.9 40 40 40s40-17.9 40-40V69.6c0-8.8-2.8-17.5-7.9-24.6L224 0zm95.9 44.9c-5.1 7.2-7.9 15.8-7.9 24.6V72c0 22.1 17.9 40 40 40s40-17.9 40-40V69.6c0-8.8-2.8-17.5-7.9-24.6L352 0 319.9 44.9zM128 176V144H64v32 48H0V350.8l29.2 15.3 60-28.6 7.1-3.4 7 3.5L160 366.1l56.8-28.4 7.2-3.6 7.2 3.6L288 366.1l56.8-28.4 7-3.5 7 3.4 60 28.6L448 350.8V224H384V176 144H320v32 48H256V176 144H192v32 48H128V176zM448 386.9l-21.3 11.2-7.1 3.7-7.2-3.4-60.2-28.6-57 28.5-7.2 3.6-7.2-3.6L224 369.9l-56.8 28.4-7.2 3.6-7.2-3.6-57-28.5L35.7 398.4l-7.2 3.4-7.1-3.7L0 386.9V512H448V386.9z"],
    "head-side": [512, 512, [], "f6e9", "M0 224.3C0 100.4 100.4 0 224.3 0H256C358.1 0 441.6 79.7 447.7 180.3L505 252l7 8.8V272v16 32H480 448v96 32H416 320v32 32H288 96 64V480 381.2C23 339.3 0 283 0 224.3zm352-.3a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "envelope": [512, 512, [128386, 9993, 61443], "f0e0", "M0 64H512v80L256 320 0 144V64zM0 448V182.8L237.9 346.4 256 358.8l18.1-12.5L512 182.8V448H0z"],
    "dolly-empty": [576, 512, [], "f473", "M32 0H0V64H32h72.9L197 340.2c-22.5 17.6-37 45-37 75.8c0 53 43 96 96 96c52.4 0 95.1-42 96-94.3l202.1-67.4 30.4-10.1-20.2-60.7-30.4 10.1L331.8 357c-17.2-22.1-43.9-36.5-74-37L158.4 21.9 151.1 0H128 32z"],
    "face-tissue": [512, 512, [], "e39c", "M256 512c141.4 0 256-114.6 256-256S397.4 0 256 0S0 114.6 0 256c0 15.9 1.5 31.5 4.2 46.7l205.9-38.1 45.8-8.5-8.5 45.8-9.4 51 18 12 39.1-26.1 8.9-5.9 8.9 5.9 40.3 26.8 23.7-11.8 14.3-7.2 14.3 28.6-14.3 7.2-32 16-8.3 4.2-7.7-5.2L304 371.2l-39.1 26.1-8.9 5.9-8.9-5.9L231.7 387 209.3 507.8c15.1 2.8 30.7 4.2 46.7 4.2zM230.9 192L112 256l45.7-64L112 128l118.9 64zM400 128l-45.7 64L400 256 281.1 192 400 128zM216 296L0 336l64 48L32 480l96-32 48 64 40-216z"],
    "angles-up": [448, 512, ["angle-double-up"], "f102", "M246.6 41.4L224 18.7 201.4 41.4l-160 160L18.7 224 64 269.3l22.6-22.6L224 109.3 361.4 246.6 384 269.3 429.3 224l-22.6-22.6-160-160zm0 192L224 210.7l-22.6 22.6-160 160L18.7 416 64 461.3l22.6-22.6L224 301.3 361.4 438.6 384 461.3 429.3 416l-22.6-22.6-160-160z"],
    "bin-recycle": [576, 512, [], "e5f7", "M0 32H576V96H0V32zm32 96H544L512 480H64L32 128zm256 88c2.2 0 4.3 1.1 5.5 2.9l33.8 48.3 40.8-25.5-35.2-50.3c-10.2-14.6-27-23.3-44.8-23.3s-34.6 8.7-44.8 23.3l-35.2 50.3 40.8 25.5 33.8-48.3c1.3-1.8 3.3-2.9 5.5-2.9zM180.4 281l-34.5 49.3c-6.4 9.1-9.8 20-9.8 31.2c0 30.1 24.4 54.4 54.4 54.4H264V368H190.4c-3.5 0-6.4-2.9-6.4-6.4c0-1.3 .4-2.6 1.2-3.7l36-51.4L180.4 281zM312 416h73.6c30.1 0 54.4-24.4 54.4-54.4c0-11.2-3.4-22.1-9.8-31.2L395.6 281l-40.8 25.5 36 51.4c.8 1.1 1.2 2.4 1.2 3.7c0 3.5-2.9 6.4-6.4 6.4H312v48z"],
    "paperclip": [448, 512, [128206], "f0c6", "M325.5 60c-16.6 0-32.5 6.6-44.2 18.3L91.6 268C71.4 288.2 60 315.7 60 344.2C60 403.8 108.2 452 167.8 452c28.6 0 56-11.4 76.2-31.6L404.2 260.2l39.6 39.6L283.6 460c-30.7 30.7-72.4 48-115.8 48C77.3 508 4 434.7 4 344.2c0-43.4 17.3-85.1 48-115.8L241.7 38.7C263.9 16.5 294.1 4 325.5 4C390.9 4 444 57.1 444 122.5c0 31.4-12.5 61.6-34.7 83.8L225.1 390.5c-13.7 13.7-32.4 21.5-51.8 21.5c-40.5 0-73.3-32.8-73.3-73.3c0-19.4 7.7-38.1 21.5-51.8L284.2 124.2l39.6 39.6L161.1 326.5c-3.2 3.2-5.1 7.6-5.1 12.2c0 9.5 7.7 17.3 17.3 17.3c4.6 0 9-1.8 12.2-5.1L369.7 166.7C381.4 155 388 139.1 388 122.5C388 88 360 60 325.5 60z"],
    "chart-line-down": [512, 512, [128201], "f64d", "M64 64V32H0V64 448v32H32 480h32V416H480 64V64zM304 98.7l-22.6 22.6L208 194.7l-57.4-57.4-45.3 45.3 80 80L208 285.3l22.6-22.6L304 189.3l57.4 57.4L320 288l32 32H480V192l-32-32-41.4 41.4-80-80L304 98.7z"],
    "arrow-right-to-city": [640, 512, [], "e4b3", "M288 0H480V192h40V120 96h48v24 72h72V512H480 384 288V0zm64 64v64h64V64H352zm64 96H352v64h64V160zm-64 96v64h64V256H352zm224 0H512v64h64V256zm-64 96v64h64V352H512zM150.6 153.4l80 80L253.3 256l-22.6 22.6-80 80L128 381.3 82.7 336l22.6-22.6L130.7 288H32 0V224H32h98.7l-25.4-25.4L82.7 176 128 130.7l22.6 22.6z"],
    "lock-a": [448, 512, [], "e422", "M144 144v48H304V144c0-44.2-35.8-80-80-80s-80 35.8-80 80zM80 192V144C80 64.5 144.5 0 224 0s144 64.5 144 144v48h80V512H0V192H80zM268.7 408l16.7 40H320L240 256H208L128 448h34.7l16.7-40h89.3zm-13.3-32H192.7L224 300.8 255.3 376z"],
    "ribbon": [448, 512, [127895], "f4d6", "M333.2 322.8l0 0-133.9-146 0 0L146 118.6c7.8-5.1 78-22.6 78-22.6s70.2 17.4 78 22.6L245.7 180l85.6 93.4L384 216V120L304 0H144L64 112v88l79.6 91.3 0 0 83.3 95.6 0 0 19.6 22.5L336 512l112-64L333.2 322.8zM205.2 410.6l-83.3-95.6L0 448l112 64 93.2-101.4z"],
    "lungs": [640, 512, [129729], "f604", "M352 32V0H288V32 64 190.4l-32 20.4V128 96H224 168 152l-9.6 12.8L168 128c-25.6-19.2-25.6-19.2-25.6-19.2l0 0 0 0-.1 .1-.3 .4-1.1 1.5c-1 1.3-2.3 3.2-4.1 5.6c-3.5 4.8-8.4 11.8-14.3 20.6c-11.8 17.5-27.8 42.2-44.3 71.1C45.8 264.9 9.1 341.4 .2 412c-.2 1.3-.2 2.6-.2 4v7c0 49.1 39.8 89 89 89c7.3 0 14.5-.9 21.6-2.7L231.8 479 256 473V448 324.6L151.4 391.2l-17.2-27 27-17.2L320 245.9 478.8 347l26.5 16.9L488 391.2 384 325V448v25l24.2 6.1 121.2 30.3c7.1 1.8 14.3 2.7 21.6 2.7c49.1 0 89-39.8 89-89v-7c0-1.3-.1-2.7-.2-4c-8.8-70.6-45.5-147.2-78-203.9c-16.5-28.9-32.4-53.6-44.3-71.1c-5.9-8.8-10.8-15.7-14.3-20.6c-1.7-2.4-3.1-4.3-4.1-5.6l-1.1-1.5-.3-.4-.1-.1 0 0 0 0s0 0-25.6 19.2l25.6-19.2L488 96H472 416 384v32 82.8l-32-20.4V64 32z"],
    "person-pinball": [640, 512, [], "e21d", "M32 48a48 48 0 1 1 96 0A48 48 0 1 1 32 48zM0 128H32 80 97.1l9.5 14.3L161.1 224H224h32v18.2l292.1-48.7L513.6 90.1 512 85.2V80 32 0h32 64 32V32 178.2 216v8 32V480v32H576V480 384H256v96 32H192V480 288H144 126.9l-9.5-14.3L96 241.7v65.1l54.6 54.6 9.4 9.4V384v96 32H96V480 397.3L41.4 342.6 18.7 320C6.7 308 0 291.7 0 274.7V160 128zM0 480L0 346.5l64 64V480v0l0 32L0 512l0-32zM280 336a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "arrow-up-9-1": [576, 512, ["sort-numeric-up-alt"], "f887", "M432 152a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-88-32c0-48.6 39.4-88 88-88s88 39.4 88 88c0 22.6-6.2 44.8-18 64.1L458.3 256H383.4l5.2-8.6 25.1-41.3C373.9 197.7 344 162.3 344 120zM160 32.6l23.6 25.7 88 96L293.2 178 246 221.2l-21.6-23.6L192 162.3V448v32H128V448 162.3L95.6 197.6 74 221.2 26.8 178l21.6-23.6 88-96L160 32.6zM352 288h32 48 32v32 96h16 32v64H480 432 384 352V416h32 16V352H384 352V288z"],
    "apple-core": [384, 512, [], "e08f", "M176 96V80c0-44.2 35.8-80 80-80h16 16V16 32c0 44.2-35.8 80-80 80H192 176V96zM14.2 155.3C31.2 138.4 53.1 128 80 128l112 32 112-32c26.9 0 48.8 10.4 65.8 27.3C320.6 186.5 288 241.4 288 304c0 60.4 30.5 113.8 76.9 145.5C335 488.6 295.5 512 256 512l-64-16-64 16c-39.5 0-79-23.4-108.9-62.5C65.5 417.8 96 364.4 96 304c0-62.6-32.6-117.5-81.8-148.7z"],
    "circle-y": [512, 512, [], "e12f", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM232 295.9L120.6 144h59.5L256 247.4 331.8 144h59.5L280 295.9V376v24H232V376 295.9z"],
    "h6": [640, 512, [], "e413", "M64 64V96 224H256V96 64h64V96 256 416v32H256V416 288H64V416v32H0V416 256 96 64H64zM496 384a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM352 304c0-38 12.1-75 34.6-105.6L485.1 64h79.4l-70.4 96c.6 0 1.3 0 1.9 0c79.5 0 144 64.5 144 144s-64.5 144-144 144s-144-64.5-144-144z"],
    "litecoin-sign": [384, 512, [], "e1d3", "M128 64V32H64V64 213.6L23.2 225.2-7.6 234 10 295.6l30.8-8.8L64 280.1V448v32H96 352h32V416H352 128V261.9l136.8-39.1 30.8-8.8L278 152.4l-30.8 8.8L128 195.3V64z"],
    "circle-small": [320, 512, [], "e122", "M0 256a160 160 0 1 1 320 0A160 160 0 1 1 0 256z"],
    "border-none": [448, 512, [], "f850", "M0 416l0 64 64 0 0-64L0 416zm96 64l64 0 0-64-64 0 0 64zM96 96l64 0 0-64L96 32l0 64zm0 128l0 64 64 0 0-64-64 0zM288 480l64 0 0-64-64 0 0 64zm0-448l0 64 64 0 0-64-64 0zm0 256l64 0 0-64-64 0 0 64zM192 416l0 64 64 0 0-64-64 0zm0-320l64 0 0-64-64 0 0 64zm0 128l0 64 64 0 0-64-64 0zM384 480l64 0 0-64-64 0 0 64zm0-384l64 0 0-64-64 0 0 64zM0 32L0 96l64 0 0-64L0 32zM384 288l64 0 0-64-64 0 0 64zM0 224l0 64 64 0 0-64L0 224zM192 384l64 0 0-64-64 0 0 64zm192-64l0 64 64 0 0-64-64 0zM0 384l64 0 0-64L0 320l0 64zM384 128l0 64 64 0 0-64-64 0zM0 192l64 0 0-64L0 128l0 64zm192-64l0 64 64 0 0-64-64 0z"],
    "arrow-turn-down-left": [512, 512, [], "e2e1", "M445.3 64V32h64V64 288v32h-32H122.5l73.4 73.4L218.5 416l-45.3 45.3-22.6-22.6-128-128L0 288l22.6-22.6 128-128 22.6-22.6L218.5 160l-22.6 22.6L122.5 256H445.3V64z"],
    "circle-nodes": [512, 512, [], "e4e2", "M418.4 157.9c35.3-8.3 61.6-40 61.6-77.9c0-44.2-35.8-80-80-80c-43.4 0-78.7 34.5-80 77.5L136.2 151.1C121.7 136.8 101.9 128 80 128c-44.2 0-80 35.8-80 80s35.8 80 80 80c12.2 0 23.8-2.7 34.1-7.6L259.7 407.8c-2.4 7.6-3.7 15.8-3.7 24.2c0 44.2 35.8 80 80 80s80-35.8 80-80c0-27.7-14-52.1-35.4-66.4l37.8-207.7zM156.3 232.2c2.2-6.9 3.5-14.2 3.7-21.7l183.8-73.5c3.6 3.5 7.4 6.7 11.6 9.5L317.6 354.1c-5.5 1.3-10.8 3.1-15.8 5.5L156.3 232.2z"],
    "parachute-box": [512, 512, [], "f4cd", "M383.5 192c.3-5.3 .5-10.6 .5-16c0-51-15.9-96-40.2-127.6C319.5 16.9 288.2 0 256 0s-63.5 16.9-87.8 48.4C143.9 80 128 125 128 176c0 5.4 .2 10.7 .5 16H240V320H184.5L68.2 192H96.5c-.3-5.3-.5-10.6-.5-16c0-64 22.2-121.2 57.1-159.3C50.3 53.5 8.3 142.1 0 192H24.9L160 340.6V512H352V340.6L487.1 192H512c-8.3-49.9-50.3-138.5-153.1-175.3C393.8 54.8 416 112.1 416 176c0 5.4-.2 10.7-.5 16h28.3L327.5 320H272V192H383.5z"],
    "message-medical": [512, 512, ["comment-alt-medical"], "f7f4", "M0 0H512V416H304L160 512V416H0V0zM224 112v64H160v64h64v64h64V240h64V176H288V112H224z"],
    "rugby-ball": [512, 512, [], "e3c6", "M226.2 105.9l-2.3 1.2-1.8 1.8L108.9 222.1l-1.8 1.8-1.2 2.3L16 406.1 16 336C16 159.3 159.3 16 336 16l70.1 0L226.2 105.9zm16.6 27.5L447.2 31.2l33.6 33.6L378.6 269.2 269.2 378.6 64.8 480.8 31.2 447.2 133.4 242.8 242.9 133.4zM105.9 496l179.8-89.9 2.3-1.2 1.8-1.8L403.1 289.9l1.8-1.8 1.2-2.3L496 105.9V176c0 176.7-143.3 320-320 320H105.9z"],
    "comment-music": [512, 512, [], "f8b0", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM352 128V104.9L330.4 113l-128 48L192 164.9V176v32 81.8c-5-1.2-10.4-1.8-16-1.8c-26.5 0-48 14.3-48 32s21.5 32 48 32s48-14.3 48-32V219.1l96-36v74.7c-5-1.2-10.4-1.8-16-1.8c-26.5 0-48 14.3-48 32s21.5 32 48 32s48-14.3 48-32V160 128z"],
    "indent": [448, 512, [], "f03c", "M0 32V96H448V32H0zM192 160v64H448V160H192zM448 288H192v64H448V288zM0 416v64H448V416H0zm0-48L144 256 0 144V368z"],
    "tree-deciduous": [512, 512, [127795, "tree-alt"], "f400", "M384 80H350.7C343.1 34.6 303.6 0 256 0s-87.1 34.6-94.7 80H128c-44.2 0-80 35.8-80 80v44.8C19.3 221.4 0 252.5 0 288v96H224v96 32h64V480 384H512V288c0-35.5-19.3-66.6-48-83.2V160c0-44.2-35.8-80-80-80z"],
    "puzzle-piece-simple": [640, 512, ["puzzle-piece-alt"], "e231", "M256 144c0-17.8 12.9-33.3 32-41.6V64H128V224H89.6c-8.3-19.1-23.8-32-41.6-32c-26.5 0-48 28.7-48 64s21.5 64 48 64c17.8 0 33.3-12.9 41.6-32H128V448H288V409.6c-19.1-8.3-32-23.8-32-41.6c0-26.5 28.7-48 64-48s64 21.5 64 48c0 17.8-12.9 33.3-32 41.6V448H512V288h38.4c8.3 19.1 23.8 32 41.6 32c26.5 0 48-28.7 48-64s-21.5-64-48-64c-17.8 0-33.3 12.9-41.6 32H512V64H352v38.4c19.1 8.3 32 23.8 32 41.6c0 26.5-28.7 48-64 48s-64-21.5-64-48z"],
    "truck-field-un": [640, 512, [], "e58e", "M384 32H32v96H0V288H32v32H0v64H32 64c0 53 43 96 96 96s96-43 96-96H384c0 53 43 96 96 96s96-43 96-96h32 32V320H608V224H539.9L477.2 83l-8.4-19H448 384V32zm0 96h43.2l42.7 96H384V128zM160 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm320 96a48 48 0 1 1 0-96 48 48 0 1 1 0 96zM128 144v64c0 8.8 7.2 16 16 16s16-7.2 16-16V144 128h32v16 64c0 26.5-21.5 48-48 48s-48-21.5-48-48V144 128h32v16zm112-16h8 9.9l4.4 8.8L288 188.2V144 128h32v16 96 16H304h-8-9.9l-4.4-8.8L256 195.8V240v16H224V240 144 128h16z"],
    "nfc-trash": [640, 512, [], "e1fd", "M0 32H448V160H434.3l-16 32H384V112 96H368 224 208v16 98.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V128H352v64 96 96H96V128h48 16V96H144 80 64v16V400v16H80 368h9.1l4.6 64H0V32zM454.1 192H464h96 9.9l4.4 8.8L585.9 224H624h16v32H624 576 448 400 384V224h16 38.1l11.6-23.2 4.4-8.8zM608 512H416L400 288H624L608 512z"],
    "hourglass": [384, 512, [9203, 62032, "hourglass-empty"], "f254", "M32 0H0V64H32v64 13.3l9.4 9.4L146.7 256 41.4 361.4 32 370.7V384v64H0v64H32 352h32V448H352V384 370.7l-9.4-9.4L237.3 256 342.6 150.6l9.4-9.4V128 64h32V0H352 32zM288 64v50.7l-96 96-96-96V64H288zM192 301.3l96 96V448H96V397.3l96-96z"],
    "mountain": [512, 512, [127956], "f6fc", "M0 416v64H64 448h64V416L294.5 89.7 256 32 217.5 89.7 0 416zM307.1 224H256l-48 64-24.2-32.3L256 147.4 307.1 224z"],
    "file-xmark": [384, 512, ["file-times"], "f317", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zm33.9 256l-17 17-47 47 47 47 17 17L256 417.9l-17-17-47-47-47 47-17 17L94.1 384l17-17 47-47-47-47-17-17L128 222.1l17 17 47 47 47-47 17-17L289.9 256z"],
    "house-heart": [576, 512, ["home-heart"], "f4c9", "M511.8 287.6H576V240L288.4 0 0 240v47.6H64.1V512H512.8l-1-224.4zM176 267.2c0-32.7 26.5-59.2 59.2-59.2h2.4c15.9 0 31.2 6.2 42.7 17.2l7.7 7.4 7.7-7.4c11.5-11 26.8-17.2 42.7-17.2h2.4c32.7 0 59.2 26.5 59.2 59.2c0 16.1-6.6 31.5-18.2 42.7l-82.8 79.6L288 400.1l-11.1-10.7-82.8-79.6c-11.6-11.2-18.2-26.6-18.2-42.7z"],
    "house-chimney-blank": [576, 512, [], "e3b0", "M511.8 287.6H576V240l-64-53.4V32H416v74.5L288.4 0 0 240v47.6H64.1V512H512.8l-1-224.4z"],
    "meter-bolt": [640, 512, [], "e1e9", "M256 512c80.8 0 152.9-37.5 199.9-96H384V344.3l127.9-97.1C507.2 109.9 394.4 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512zM192 160v32 32H128V192 160 128h64v32zm96 0v32 32H224V192 160 128h64v32zm96 0v32 32H320V192 160 128h64v32zM504 384L464 512 640 376V352H552l40-128L416 360v24h88z"],
    "user-doctor": [448, 512, ["user-md"], "f0f0", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM384 304l64 208H0L64 304h64v66.3c-23.1 6.9-40 28.3-40 53.7c0 30.9 25.1 56 56 56s56-25.1 56-56c0-25.4-16.9-46.8-40-53.7V304H288v58c-27.6 7.1-48 32.2-48 62v40 16h16 16 16V448H272V424c0-17.7 14.3-32 32-32s32 14.3 32 32v24H320v32h16 16 16V464 424c0-29.8-20.4-54.9-48-62V304h64zM144 400a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "slash-back": [320, 512, [], "5c", "M.1 0H71.2L319.9 512H248.8L.1 0z"],
    "circle-info": [512, 512, ["info-circle"], "f05a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM216 336h24V272H216 192V224h24 48 24v24 88h8 24v48H296 216 192V336h24zm72-144H224V128h64v64z"],
    "fishing-rod": [448, 512, [], "e3a8", "M284.6 0H288h64 24V24 136v24H328V136 48H291.4L88 106.1V288h40V512H0V288H40V88 69.9l17.4-5 224-64 3.2-.9zM256 344c0-76.8 64-136 96-152c32 16 96 75.2 96 152c0 32-16 80-64 112l32 40v16H288V496l32-40c-48-32-64-80-64-112zm128-32a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "hammer-crash": [640, 512, [], "e414", "M318.3 338.9l-25.1-12.5-16.9 72.7 112.1-54.6 77.4 97.8 27.2-121.7 124.7 .5L539.6 224l78.2-97.2-124.7 .5L465.8 5.6 400.4 88.4l5.9 3 28.6 14.3-14.3 28.6-88 176-14.3 28.6zM304 296l88-176L184 16H64L0 144 304 296zM109.2 234.4L.1 452.5l85.9 42.9L195 277.3l-85.9-42.9z"],
    "message-heart": [512, 512, [], "e5c9", "M0 0H512V416H304L160 512V416H0V0zM144 171.2c0 16.1 6.6 31.5 18.2 42.7l82.8 79.6L256 304.1l11.1-10.7 82.8-79.6c11.6-11.2 18.2-26.6 18.2-42.7c0-32.7-26.5-59.2-59.2-59.2h-2.4c-15.9 0-31.2 6.2-42.7 17.2l-7.7 7.4-7.7-7.4c-11.5-11-26.8-17.2-42.7-17.2h-2.4c-32.7 0-59.2 26.5-59.2 59.2z"],
    "cloud-meatball": [512, 512, [], "f73b", "M0 320H96h36.4l10.5-10.5 22.6-22.6 12.1-12.1 16.8 3.4 12.1 2.4 6.9-10.3 9.5-14.2H240h32 17.1l9.5 14.2 6.9 10.3 12.1-2.4 16.8-3.4 12.1 12.1 22.6 22.6L379.6 320H416h96V224c0-53-43-96-96-96V112c0-44.2-35.8-80-80-80c-24.3 0-46.1 10.9-60.8 28C256.5 24.3 219.1 0 176 0C114.1 0 64 50.1 64 112v21.5C26.7 146.6 0 182.2 0 224v96zM172.1 434.7l-6.6 33.1 22.6 22.6 33.1-6.6L240 512h32l18.7-28.1 33.1 6.6 22.6-22.6-6.6-33.1L368 416V384l-28.1-18.7 6.6-33.1-22.6-22.6-33.1 6.6L272 288H240l-18.7 28.1-33.1-6.6-22.6 22.6 6.6 33.1L144 384v32l28.1 18.7zM48 448a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm416 0a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "camera-polaroid": [576, 512, [], "f8aa", "M64 32H96 480h32V64 246.3l58.6 87.9 5.4 8.1V352v96 32H544 32 0V448 352v-9.7l5.4-8.1L64 246.3V64 32zM288 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM384 96v64h64V96H384zM112 384H96v32h16H464h16V384H464 112z"],
    "camera": [512, 512, [62258, "camera-alt"], "f030", "M160 32L138.7 96H0V480H512V96H373.3L352 32H160zm96 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "square-virus": [448, 512, [], "e578", "M448 32H0V480H448V32zM303.9 140.9l.1-.1 16.8-16.8 33.9 33.9-17 17-.2 .2c-20.5 20.7-5.8 55.9 23.4 55.9h0 24v48h-24 0c-29.2 0-43.8 35.2-23.4 55.9l.2 .2 17 17-33.9 33.9L304 369l-.1-.1c-20.6-20.6-55.9-6.1-56.1 23v.3 24h-24-24V392.3l0-.2c0-29.2-35.2-43.8-55.9-23.4l-.2 .2-17 17L110 369l-.1-.1-.1-.1L92.9 351.9l16.8-16.8 .1-.1c20.7-20.7 6-56.1-23.2-56.1h-24V255.1l0-.2 0-.2V230.9h24c29.3 0 43.9-35.4 23.2-56.1l-.1-.1L92.9 157.8 109.7 141l.1-.1 .1-.1 16.8-16.8 17 17 .2 .2c20.7 20.5 55.9 5.8 55.9-23.4l0-.2V93.7h24 24v24 .3c.2 29.1 35.4 43.6 56.1 23zM192 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm88 32a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "cart-arrow-up": [576, 512, [], "e3ee", "M0 0H24 96h19.9l3.7 19.5L122 32H576L496 288H360V177.9l23 23 17 17L433.9 184l-17-17-64-64-17-17-17 17-64 64-17 17L272 217.9l17-17 23-23V288H170.7l9.1 48H312h48H488h24v48H488 160 140.1l-3.7-19.5L76.1 48H24 0V0zM128 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "meteor": [512, 512, [9732], "f753", "M512 0L299.4 75.9 304 16 101.3 133.4C38.6 169.7 0 236.6 0 309C0 421.1 90.9 512 203 512c72.4 0 139.4-38.6 175.7-101.3L496 208l-59.9 4.6L512 0zM192 192a128 128 0 1 1 0 256 128 128 0 1 1 0-256zm0 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm16 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "car-on": [512, 512, [], "e4dd", "M280 24v80 24H232V104 24 0h48V24zM138.9 160H160 352h21.1l8.3 19.4L428 288h36v96 64 64H384V448H128v64H48V448 384 288H84l46.5-108.6 8.3-19.4zm192 64H181.1l-27.4 64H358.3l-27.4-64zM128 392a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm280-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM56 22.1L73 39l48 48 17 17L104 137.9 87 121 39 73l-17-17L56 22.1zM439 39l17-17L489.9 56 473 73l-48 48-17 17L374.1 104l17-17 48-48z"],
    "sleigh": [640, 512, [], "f7cc", "M32 32H0V96H32V256c0 53 43 96 96 96v32h64V352H384v32h64V352c53 0 96-43 96-96V160h32V96H544 512 480 448V224H401.4c-80.5 0-155.3-41.5-198-109.7C173 65.7 120.9 35.2 64 32.2V32H55 32zM640 384V352H576v32 32H64 32v64H64 608h32V448 384z"],
    "arrow-down-1-9": [576, 512, ["sort-numeric-asc", "sort-numeric-down"], "f162", "M160 479.4l23.6-25.7 88-96L293.2 334 246 290.8l-21.6 23.6L192 349.7V64 32H128V64 349.7L95.6 314.4 74 290.8 26.8 334l21.6 23.6 88 96L160 479.4zM414.3 309.3a32 32 0 1 1 35.3 53.4 32 32 0 1 1 -35.3-53.4zm-.6 112.8l-25.1 41.3L378.5 480h74.9L502 400.1c11.7-19.3 18-41.5 18-64.1c0-48.6-39.4-88-88-88s-88 39.4-88 88c0 42.3 29.9 77.7 69.8 86.1zM384 32H352V96h32 16v64H384 352v64h32 48 48 32V160H480 464V64 32H432 384z"],
    "buoy-mooring": [576, 512, [], "e5b6", "M256 0h64V64h32 26.2l5.1 25.7 60.8 303.8c-6.5 4.4-12.6 8-19.4 11.1C411.6 410.7 397 415 384 415s-27.6-4.3-40.7-10.3c-12-5.5-21.7-12.5-35.5-22.5l0 0L288 368l-18.6 13.4-1.1 .8 0 0 0 0c-13.9 10-23.6 17-35.5 22.5C219.6 410.7 205 415 192 415s-27.6-4.3-40.7-10.3c-6.8-3.1-12.9-6.7-19.4-11.1L192.6 89.7 197.8 64H224h32V0zM218.2 288H357.8l-32-160H250.2l-32 160zm54.2 205.1c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 502.1 31.9 512 0 512V448c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7z"],
    "square-4": [448, 512, [], "e259", "M0 32H448V480H0V32zM288 192H240v24 56H175.6l40-144H165.8L120.9 289.6 112.4 320H144h96v40 24h48V360 320h8 24V272H296h-8V216 192z"],
    "hand-holding-droplet": [576, 512, ["hand-holding-water"], "f4c1", "M288 0L211.2 102.4C198.7 119 192 139.2 192 160c0 53 43 96 96 96s96-43 96-96c0-20.8-6.7-41-19.2-57.6L288 0zM140 327L68.8 384H0V512H32 224 384h12.4l10.2-7 128-88 33-22.7-45.3-65.9-33 22.7-94.5 65H256V384h32 64 32V320H352 288 224 160 148.8l-8.8 7z"],
    "tricycle-adult": [640, 512, [], "e5c4", "M312 64H288v48h24 35.5l81.5 115.9L372 304H338.8L37.5 232.6l-23.4-5.5L3.1 273.8l23.4 5.5 5.3 1.3C12.3 298.2 0 323.7 0 352c0 53 43 96 96 96c18.2 0 35.3-5.1 49.8-13.9c-.6 .4-1.2 .7-1.8 1.1c14.1 8.2 30.5 12.8 48 12.8c53 0 96-43 96-96c0-3.7-.2-7.3-.6-10.8l43.1 10.2 2.7 .6H336h48 12l7.2-9.6 54.9-73.2 13.7 19.5C457 305.6 448 327.7 448 352c0 53 43 96 96 96s96-43 96-96s-43-96-96-96c-11.4 0-22.3 2-32.5 5.6L379.6 74.2 372.5 64H360 312zM222.1 325.7c6.1 7 9.9 16.2 9.9 26.3c0 22.1-17.9 40-40 40c-2.9 0-5.6-.3-8.3-.9c5.3-12 8.3-25.2 8.3-39.1c0-12.3-2.3-24.2-6.6-35l36.7 8.7zM96 312a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm448 0a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM92.6 113.7L78.3 85.1 21.1 113.7l14.3 28.6 32 64 6.5 13L88 223l96 24.8 31 8 16-62-31-8-81.9-21.1-25.5-51z"],
    "waveform": [640, 512, [], "f8f1", "M429 64h38.5l4.3 28.4L500.2 282l20.4-95 5.8-27h30.4l9.5 22.8L600 264h8 24v48H608 584 568l-6.2-14.8-10.5-25.1L519.5 421l-5.8 27H476.5l-4.3-28.4L446.8 249.5 407.7 483.9 403 512H364.3l-4.1-28.6L320 201.7 279.8 483.4 275.7 512H237l-4.7-28.1L193.2 249.5 167.7 419.6 163.5 448H126.3l-5.8-27L88.6 272.1 78.2 297.2 72 312H56 32 8V264H32h8l33.8-81.2L83.3 160h30.4l5.8 27 20.4 95L168.3 92.4 172.5 64H211l4.7 28.1 38.5 231L296.2 28.6 300.3 0h39.3l4.1 28.6 42.1 294.5 38.5-231L429 64z"],
    "water": [576, 512, [], "f773", "M288 133.4c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 150.1 31.9 160 0 160V96c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7L96 56.7l2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l0 0 2.1-1.5 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l0 0 2.1-1.5 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7zm0 288c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 438.1 31.9 448 0 448V384c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l2.1-1.5 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l2.1-1.5 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l2.1-1.5 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7zM272.4 285.1c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 294.1 31.9 304 0 304V240c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7z"],
    "star-sharp-half-stroke": [576, 512, ["star-sharp-half-alt"], "e28d", "M317.5 90.6l34.1 105H462h95.3l-77.1 56-89.3 64.9 34.1 105L454.4 512l-77.1-56-89.3-64.9L198.8 456l-77.1 56 29.4-90.6 34.1-105L96 251.6l-77.1-56h95.3H224.5l34.1-105L288.1 0l29.4 90.6zm34.1 161H310.9l-12.6-38.7-10.3-31.7-.1 .2V322l.1 0L321 345.8l26.9 19.6-10.3-31.7L325 295 358 271.1l26.9-19.6H351.6zm-159.6 0h-.8l.8 .6v-.6z"],
    "nfc-signal": [512, 512, [], "e1fb", "M0 32H448V231.1c-22.4 5.1-43.9 12.8-64 22.8V112 96H368 224 208v16 98.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V128H352V272.5c-41.6 27.9-75.6 66.3-98.1 111.5H96V128h48 16V96H144 80 64v16V400v16H80 240.4c-7.2 20.4-12.2 41.8-14.6 64H0V32zM512 304c-114.9 0-208 93.1-208 208H256c0-141.4 114.6-256 256-256v48zM480 448a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-80 64H352c0-88.4 71.6-160 160-160v48c-61.9 0-112 50.1-112 112z"],
    "plane-prop": [576, 512, [], "e22b", "M256 0h64l8 64h40V48 32h32V48 80c8.8 0 16 7.2 16 16s-7.2 16-16 16v32 16H368V144 128H336l8 64H482.3c34.2 0 93.7 29 93.7 64c0 36-59.5 64-93.7 64H344l-8 64h32V368 352h32v16 32c8.8 0 16 7.2 16 16s-7.2 16-16 16v32 16H368V464 448H328l-8 64H256l-8-64H192V384h48l-8.3-66.4-110-11L112 384H48L36 287.8c-1.3 .2-2.6 .2-4 .2c-17.7 0-32-14.3-32-32s14.3-32 32-32c1.3 0 2.7 .1 4 .2L48 128h64l9.7 77.4 110-11L240 128H192V64h56l8-64z"],
    "calendar-check": [448, 512, [], "f274", "M160 0V64H288V0h64V64h96v96H0V64H96V0h64zM0 192H448V512H0V192zM329 305l17-17L312 254.1l-17 17-95 95-47-47-17-17L102.1 336l17 17 64 64 17 17 17-17L329 305z"],
    "clock-desk": [448, 512, [], "e134", "M0 224a224 224 0 1 1 448 0A224 224 0 1 1 0 224zM248 96H200v24V224v9.9l7 7 48 48 17 17L305.9 272l-17-17-41-41V120 96zM224 480c96.4 0 180.3-53.3 224-132V512H0V348c43.7 78.7 127.6 132 224 132z"],
    "calendar-clock": [576, 512, ["calendar-time"], "e0d2", "M96 0V64H0v96H448V64H352V0H288V64H160V0H96zM448 192H432 0V512H330.8C285.6 480.1 256 427.5 256 368c0-97.2 78.8-176 176-176c5.4 0 10.7 .2 16 .7V192zM576 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM448 288v16 48h32 16v32H480 432 416V368 304 288h32z"],
    "braille": [640, 512, [], "f2a1", "M0 96a64 64 0 1 1 128 0A64 64 0 1 1 0 96zM224 272a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM80 416a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM0 416a64 64 0 1 1 128 0A64 64 0 1 1 0 416zm240 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM64 192a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM224 32a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM352 96a64 64 0 1 1 128 0A64 64 0 1 1 352 96zm240 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 0a64 64 0 1 1 128 0A64 64 0 1 1 512 96zm64 176a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm16 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM416 272a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0-80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm16 224a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "prescription-bottle-medical": [384, 512, ["prescription-bottle-alt"], "f486", "M0 0H384V96H0V0zM32 128H352V512H32V128zm128 96v64H96v64h64v64h64V352h64V288H224V224H160z"],
    "plate-utensils": [640, 512, [58713], "e43b", "M56 16H40L0 152c0 41.5 31.6 75.6 72 79.6V472v24h48V472 231.6c40.4-4 72-38.1 72-79.6L152 16H136V152H120L104 16H88L72 152H56V16zm584 0s-128 16-128 144V320h80V472v24h48V472 320 216 192 16zM336 32c-49.8 0-95.9 16.3-133.1 43.8L222.7 143l0 0c29-29 69-47 113.3-47c63.3 0 118.1 36.8 144 90.2V160c0-25.1 4.2-46.8 11.2-65.5C450.9 55.8 396.2 32 336 32zm0 384c-88.4 0-160-71.6-160-160c0-4.2 .2-8.3 .5-12.4c-7.5 5.3-15.7 9.7-24.5 13.1V383.8C192.5 441.9 259.8 480 336 480c89.4 0 166.5-52.3 202.4-128H512 480V325.8C454.1 379.2 399.3 416 336 416zM464 256a128 128 0 1 0 -256 0 128 128 0 1 0 256 0z"],
    "family-pants": [512, 512, [], "e302", "M128 128A64 64 0 1 0 128 0a64 64 0 1 0 0 128zm48 48c0-5.5 .6-10.8 1.6-16H32L24 352H64V512H176V448H144V416 256 224h32 16c-10-13.4-16-30-16-48zM336 448v64H448V352h40l-8-192H334.4c1 5.2 1.6 10.5 1.6 16c0 18-6 34.6-16 48h16 32v32V416v32H336zm48-320A64 64 0 1 0 384 0a64 64 0 1 0 0 128zM256 224a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm80 192V256H176V416h32v96h96V416h32z"],
    "hose-reel": [640, 512, [], "e41a", "M320 64c-106 0-192 86-192 192s86 192 192 192c40.8 0 78.6-12.7 109.7-34.4l36.6 52.5C424.8 495 374.3 512 320 512C178.6 512 64 397.4 64 256S178.6 0 320 0S576 114.6 576 256v96h8 24v48H584h-2.3l-11.4 80H584v32H568 520 504V480h13.7l-11.4-80H504 480V352h24 8V256c0-106-86-192-192-192zM224 256a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm96 160a160 160 0 1 1 0-320 160 160 0 1 1 0 320zM256 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"],
    "house-window": [576, 512, [], "e3b3", "M511.8 287.6H576V240L288.4 0 0 240v47.6H64.1V512H512.8l-1-224.4zM352 192V320H224V192H352z"],
    "landmark": [512, 512, [127963], "f66f", "M0 144v48H512V144L256 0 0 144zm128 80H64V416L0 464v48H512V464l-64-48V224H384V416H344V224H280V416H232V224H168V416H128V224z"],
    "truck": [640, 512, [128666, 9951], "f0d1", "M0 0H416V96h64 13.3l9.4 9.4 96 96 9.4 9.4V224v32 32 64h32v64H608 576c0 53-43 96-96 96s-96-43-96-96H256c0 53-43 96-96 96s-96-43-96-96H0V0zM544 237.3L466.7 160H464 416v96H544V240v-2.7zM208 416a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm272 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "crosshairs": [512, 512, [], "f05b", "M288 0V32 42.4c93.7 13.9 167.7 88 181.6 181.6H480h32v64H480 469.6c-13.9 93.7-88 167.7-181.6 181.6V480v32H224V480 469.6C130.3 455.7 56.3 381.7 42.4 288H32 0V224H32 42.4C56.3 130.3 130.3 56.3 224 42.4V32 0h64zM107.4 288c12.5 58.3 58.4 104.1 116.6 116.6V384 352h64v32 20.6c58.3-12.5 104.1-58.4 116.6-116.6H384 352V224h32 20.6C392.1 165.7 346.3 119.9 288 107.4V128v32H224V128 107.4C165.7 119.9 119.9 165.7 107.4 224H128h32v64H128 107.4zM256 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "cloud-rainbow": [576, 512, [], "f73e", "M336.5 192l-.5 0c-19.7 0-38.3 5.1-54.4 14.1c-5.5-6-11.5-11.4-18-16.4C322.3 77 440.1 0 576 0V64c-99.9 0-187.8 50.8-239.5 128zM424 234.7c-13.4-16.9-31.5-29.9-52.3-36.9C418.4 136 492.5 96 576 96v64c-61.9 0-116.9 29.3-152 74.7zm23.4 57.2c-1-9.1-3.1-17.9-6.1-26.2C469.7 221.4 519.4 192 576 192v64c-38.3 0-71.4 22.5-86.8 55c-12.5-8.7-26.6-15.3-41.8-19.1zM96 512H0V416c0-41.8 26.7-77.4 64-90.5V304c0-61.9 50.1-112 112-112c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H416 96z"],
    "person-cane": [448, 512, [], "e53c", "M272 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm-8 187.3l47.4 57.1 20.4 24.6 49.3-40.9-20.4-24.6-92.9-112L258.1 128h-15H140.9 122.8l-9.3 15.5-76.9 128L20.1 298.9l54.9 33 16.5-27.4L120 256.9V480v32h64V480 352h16V480v32h64V480 235.3zM352 376c0-4.4 3.6-8 8-8s8 3.6 8 8V488v24h48V488 376c0-30.9-25.1-56-56-56s-56 25.1-56 56v8 24h48V384v-8z"],
    "alien": [448, 512, [128125], "f8f5", "M224 0C100.3 0 0 100.3 0 224C0 400 224 512 224 512s224-112 224-288C448 100.3 347.7 0 224 0zm32 304c0-44.2 35.8-80 80-80h48v16c0 44.2-35.8 80-80 80H256V304zM112 224c44.2 0 80 35.8 80 80v16H144c-44.2 0-80-35.8-80-80V224h48z"],
    "tent": [576, 512, [], "e57d", "M32 160L0 512H288V288L416 512H576L544 176 288 0 32 160z"],
    "laptop-binary": [640, 512, [], "e5e7", "M64 32H96 544h32V64 352H512V96H128V352H64V64 32zM0 432V384H640v48l-48 48H48L0 432zM176 128h64 16v16 80 16H240 176 160V224 144 128h16zm16 80h32V160H192v48zm112-80h16 16v16 80 16H304V224 160H288V128h16zm80 0h16 64 16v16 80 16H464 400 384V224 144 128zm32 32v48h32V160H416zM192 272h16 16v16 64H192V304H176V272h16zm256 16v64H416V304H400V272h16 16 16v16zm-80 0v64H336V304H304v48H272V288 272h16 64 16v16z"],
    "vest-patches": [448, 512, [], "e086", "M151.2 69.7l55.9 167.7-13.5 40.5-1.6 4.9V288 512H0V256l64-96V128 24 0H88h40 7 13.3l6.9 11.1 .3 .4c.4 .6 1.2 1.5 2.3 2.8c2.3 2.6 6.1 6.3 11.5 10.1C179.9 31.8 197.4 40 224 40s44.1-8.2 54.7-15.6c5.4-3.8 9.2-7.5 11.5-10.1c1.1-1.3 1.9-2.3 2.3-2.8l.3-.4L299.6 0H313h7 40 24V24 128v32l64 96V512H224V288L296.8 69.7C279.3 79.8 255.3 88 224 88s-55.3-8.2-72.8-18.3zM96 456a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM72 247L55 264l8.5 8.5L79 288 63.5 303.5 55 312l17 17 8.5-8.5L96 305l15.5 15.5L120 329l17-17-8.5-8.5L113 288l15.5-15.5L137 264l-17-17-8.5 8.5L96 271 80.5 255.5 72 247zm232 33v8 48h48 8c13.3 0 24-10.7 24-24s-10.7-24-24-24h-8v-8c0-13.3-10.7-24-24-24s-24 10.7-24 24z"],
    "people-dress-simple": [512, 512, [], "e218", "M128 128A64 64 0 1 0 128 0a64 64 0 1 0 0 128zM256 384L192 160H64L0 384H64V512H192V384h64zm0 0h64V512H448V384h64L448 160H320L256 384zM384 128A64 64 0 1 0 384 0a64 64 0 1 0 0 128z"],
    "check-double": [448, 512, [], "f560", "M342.6 86.6L365.3 64 320 18.7 297.4 41.4 160 178.7l-57.4-57.4L80 98.7 34.7 144l22.6 22.6 80 80L160 269.3l22.6-22.6 160-160zm82.1 141.8l23.2-22-44-46.5-23.2 22L159 392 67.2 305.1 44 283.1 0 329.6l23.2 22L137 459.3l22 20.8 22-20.8L424.7 228.5z"],
    "arrow-down-a-z": [576, 512, ["sort-alpha-asc", "sort-alpha-down"], "f15d", "M183.6 453.6L160 479.4l-23.6-25.7-88-96L26.8 334 74 290.8l21.6 23.6L128 349.7V64 32h64V64 349.7l32.4-35.4L246 290.8 293.2 334l-21.6 23.6-88 96zM352 288H480h32v32 8 14.5l-10.9 9.6L428 416h52 32v64H480 352 320V448v-8V425.5l10.9-9.6L404 352H352 320V288h32zM395.5 32h41.1l8.6 18.7 88 192 6.1 13.3H468.8l-14.7-32H377.9l-14.7 32H292.8l6.1-13.3 88-192L395.5 32zm4.4 144h32.3L416 140.8 399.9 176z"],
    "bowling-ball-pin": [576, 512, [], "e0c3", "M416 64c0-35.3 28.7-64 64-64s64 28.7 64 64v1.1c0 7.4-1 14.8-2.9 22l-17.7 64.8c-.7 2.7-1.3 5.4-1.8 8.1H438.5c-.5-2.7-1.1-5.4-1.8-8.1L418.9 87.1c-2-7.2-2.9-14.6-2.9-22V64zm23.1 128h81.7c.8 6 2.2 11.9 4.1 17.6l49.4 148.3 3.1 9.4-2.7 9.5-32 112L536.1 512H512 448 423.9l-6.6-23.2L404 442.5c27.7-39.1 44-86.9 44-138.5c0-30.2-5.6-59.2-15.8-85.8l2.9-8.6c1.9-5.7 3.3-11.6 4.1-17.6zM0 304a208 208 0 1 1 416 0A208 208 0 1 1 0 304zM224 172a28 28 0 1 0 -56 0 28 28 0 1 0 56 0zM196 288a28 28 0 1 0 0-56 28 28 0 1 0 0 56zm-44-68a28 28 0 1 0 -56 0 28 28 0 1 0 56 0z"],
    "bell-school-slash": [640, 512, [], "f5d6", "M528 512h24v0H528 416 384 128V400c40.1 30.1 90 48 144 48c47 0 90.9-13.5 127.9-36.9L416 423.8V464h51.1L528 512zm43.3-91.2l49.6 38.5 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7 69.3 53.8C155.7 26.5 210.8 0 272 0C386.9 0 480 93.1 480 208c0 42.5-12.8 82-34.6 115l51.8 40.2c8.3-7 19.1-11.2 30.8-11.2c26.5 0 48 21.5 48 48c0 7.4-1.7 14.5-4.7 20.8zM343.5 243.9c5.4-10.8 8.5-23 8.5-35.9c0-44.2-35.8-80-80-80c-20.1 0-38.5 7.4-52.5 19.6l26.1 20.3c7.6-5 16.6-7.9 26.4-7.9c26.5 0 48 21.5 48 48c0 5.5-.9 10.7-2.6 15.6l26.1 20.3zM64 208c0-19.3 2.6-37.9 7.5-55.6L373 389.9C343.1 406.5 308.7 416 272 416C157.1 416 64 322.9 64 208z"],
    "plus-large": [512, 512, [], "e59e", "M288 32l0-32H224l0 32 0 192H32 0v64H32 224V480v32h64V480 288l192 0 32 0 0-64-32 0-192 0 0-192z"],
    "money-bill-wheat": [512, 512, [], "e52a", "M176 0c44.2 0 80 35.8 80 80V96H240c-44.2 0-80-35.8-80-80V0h16zM56 16h48 24V64H104 56 32V16H56zM24 88H136h24v48H136 24 0V88H24zm8 72H56h48 24v48H104 56 32V160zM272 0h16c44.2 0 80 35.8 80 80V96H352c-44.2 0-80-35.8-80-80V0zM400 0c44.2 0 80 35.8 80 80V96H464c-44.2 0-80-35.8-80-80V0h16zm80 128v16c0 44.2-35.8 80-80 80H384V208c0-44.2 35.8-80 80-80h16zm-128 0h16v16c0 44.2-35.8 80-80 80H272V208c0-44.2 35.8-80 80-80zm-96 0v16c0 44.2-35.8 80-80 80H160V208c0-44.2 35.8-80 80-80h16zM0 512V256H512V512H0zm48-96v48H96c0-26.5-21.5-48-48-48zM96 304H48v48c26.5 0 48-21.5 48-48zM464 416c-26.5 0-48 21.5-48 48h48V416zM416 304c0 26.5 21.5 48 48 48V304H416zm-96 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"],
    "camera-viewfinder": [512, 512, ["screenshot"], "e0da", "M0 0V24 136v24H48V136 48h88 24V0H136 24 0zM192 96l-12 32H96V384H416V128H332L320 96H192zm64 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM488 0H376 352V48h24 88v88 24h48V136 24 0H488zM0 512H24 136h24V464H136 48V376 352H0v24V488v24zm488 0h24V488 376 352H464v24 88H376 352v48h24H488z"],
    "message-music": [512, 512, ["comment-alt-music"], "f8af", "M0 0H512V416H304L160 512V416H0V0zM352 96V72.9L330.4 81l-128 48L192 132.9V144v32 81.8c-5-1.2-10.4-1.8-16-1.8c-26.5 0-48 14.3-48 32s21.5 32 48 32s48-14.3 48-32V187.1l96-36v74.7c-5-1.2-10.4-1.8-16-1.8c-26.5 0-48 14.3-48 32s21.5 32 48 32s48-14.3 48-32V128 96z"],
    "car-building": [640, 512, [], "f859", "M0 0H352V128H320 296.9 273.9l-7.3 21.9-7.3 21.9L252.5 192H192v64 32V448v32H0V0zM289.6 181.9l7.3-21.9H320h32H544h23.1l7.3 21.9L609.7 288H640l0 160v64H560V448H304v64H224V480 448h0V416 400 336 320 288h30.3l35.4-106.1zM352 224h-8.9l-10.7 32-10.7 32H352 542.3l-21.3-64H352zM64 96v64h64V96H64zm0 96v64h64V192H64zm64 96H64v64h64V288zM192 96v64h64V96H192zM304 392a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm280-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "border-bottom-right": [448, 512, ["border-style-alt"], "f854", "M448 64l0-32-64 0 0 32 0 352L32 416 0 416l0 64 32 0 384 0 32 0 0-32 0-384zM288 96l64 0 0-64-64 0 0 64zM96 96l64 0 0-64L96 32l0 64zm96-64l0 64 64 0 0-64-64 0zM0 96l64 0 0-64L0 32 0 96zM64 224L0 224l0 64 64 0 0-64zm0-32l0-64L0 128l0 64 64 0zm0 128L0 320l0 64 64 0 0-64z"],
    "octagon": [512, 512, [128721], "f306", "M0 352V160L160 0H352L512 160V352L352 512H160L0 352z"],
    "comment-arrow-up-right": [512, 512, [], "e145", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM200 160H176v48h24 54.1l-87 87-17 17L184 345.9l17-17 87-87V296v24h48V296 184 160H312 200z"],
    "octagon-divide": [512, 512, [], "e203", "M0 160V352L160 512H352L512 352V160L352 0H160L0 160zm288-32v64H224V128h64zM168 232H344h24v48H344 168 144V232h24zm56 88h64v64H224V320z"],
    "cookie": [512, 512, [127850], "f563", "M362.2 37L213.9 16 81.7 86.7 16 222.1 42 370.4 149.8 475l148.3 21 132.3-70.7L496 289.9 470 141.6 362.2 37zM176 368l-32-32 32-32 32 32-32 32zm0-192l32-32 32 32-32 32-32-32zM368 336l-32-32 32-32 32 32-32 32z"],
    "arrow-rotate-left": [512, 512, [8634, "arrow-left-rotate", "arrow-rotate-back", "arrow-rotate-backward", "undo"], "f0e2", "M48 224H16V192 64 32H80V64v51.2L97.6 97.6c87.5-87.5 229.3-87.5 316.8 0s87.5 229.3 0 316.8s-229.3 87.5-316.8 0l45.3-45.3c62.5 62.5 163.8 62.5 226.3 0s62.5-163.8 0-226.3s-163.8-62.5-226.3 0L125.7 160H176h32v64H176 48z"],
    "tv-music": [640, 512, [], "f8e6", "M576 64V352H64V64H576zM64 0H0V64 352v64H64 576h64V352 64 0H576 64zM96 448v64h32H512h32V448H512 128 96zM416 112V88.9L394.4 97l-128 48L256 148.9V160v48 49.8c-5-1.2-10.4-1.8-16-1.8c-26.5 0-48 14.3-48 32s21.5 32 48 32s48-14.3 48-32V219.1l96-36v42.7c-5-1.2-10.4-1.8-16-1.8c-26.5 0-48 14.3-48 32s21.5 32 48 32s48-14.3 48-32V160 112z"],
    "hard-drive": [512, 512, [128436, "hdd"], "f0a0", "M0 32H512V256H0V32zM512 288V480H0V288H512zM320 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "reel": [448, 512, [], "e238", "M0 0H32 416h32V64H416 384v48H64V64H32 0V0zM0 448H32 64V400H384v48h32 32v64H416 32 0V448zM64 176V144H384v32H64zm0 64V208H432h16v32H432 64zm0 64V272H384v32H64zm0 64V336H384v32H64z"],
    "face-grin-squint-tears": [512, 512, [129315, "grin-squint-tears"], "f586", "M441.1 98.9c-13.2 2.4-25.4 4.1-33.1 5.1c1-7.2 2.6-18.6 4.9-30.9c.1-.7 .3-1.4 .4-2.1c.8-4.4 1.7-8.9 2.7-13.3c.1-.4 .2-.9 .3-1.3c4.1-18.5 9.6-36.2 16.6-43.1c17.9-17.9 47.1-17.6 65.3 .7s18.6 47.6 .7 65.6c-6.9 6.9-24.5 12.4-43 16.4m0 0l-13.5 2.7c4.4-.8 9-1.7 13.5-2.7zm-79.5 3.6l-5.9 42 42-5.8 .1 0c10.5-1.4 30.8-4.3 50.5-8.6c4.1-.9 8.3-1.9 12.5-3c59.2 98.4 46.4 228-38.5 312.9c-84.9 84.9-214.7 97.7-313.2 38.3c1.1-4.1 2.1-8.2 3-12.2c4.4-19.7 7.4-40.1 8.8-50.6l5.9-42-42 5.8-.1 0c-10.5 1.4-30.8 4.3-50.5 8.6c-4.1 .9-8.3 1.9-12.5 3C-22.7 289.5-9.9 159.9 75 75C159.9-10 289.7-22.7 388.1 36.7c-1.1 4.1-2.1 8.2-3 12.2c-4.4 19.7-7.4 40.1-8.8 50.6zM70.9 413.1c13.2-2.4 25.5-4.1 33.1-5.1h0c-1.1 7.6-2.8 19.9-5.3 33.1c-.9 4.8-1.9 9.7-3 14.6l0 0c-4.1 18.5-9.6 36.2-16.6 43.1c-17.9 17.9-47.1 17.6-65.3-.7s-18.6-47.6-.7-65.6c6.9-6.9 24.5-12.4 43-16.4c4.9-1.1 9.9-2 14.7-2.9zM309.8 309.4C268 351.2 221.6 382.5 176 402.2c63.7 40.8 149.2 33.5 204.7-21.9s62.7-140.9 21.9-204.7c-19.7 45.6-51 92-92.8 133.8zM75 278.6l77.6 12.9 12.9 77.6 38.8-129.3L75 278.6zm164.9-74.3l129.3-38.8-77.6-12.9L278.6 75 239.8 204.3z"],
    "dumbbell": [640, 512, [], "f44b", "M192 32H96v96H32v96H0v64H32v96H96v96h96V320 288 224 192 32zm32 192v64H416V224H224zm224-32v32 64 32V480h96V384h64V288h32V224H608V128H544V32H448V192z"],
    "rectangle-list": [576, 512, ["list-alt"], "f022", "M0 32H576V480H0V32zM128 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32-128a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-248H200v48h24H448h24V136H448 224zm0 96H200v48h24H448h24V232H448 224zm0 96H200v48h24H448h24V328H448 224z"],
    "tarp-droplet": [576, 512, [], "e57c", "M288 160c-35.3 0-64-25.6-64-57.1S288 0 288 0s64 71.3 64 102.9s-28.7 57.1-64 57.1zM0 128H197.5c13.2 37.3 48.7 64 90.5 64s77.4-26.7 90.5-64H576V352H416l0 160L0 512V128zM576 384L448 512l0-128H576zM96 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "alarm-exclamation": [512, 512, [], "f843", "M14.9 146.4C5.5 131.6 0 114 0 95.2C0 42.6 42.6 0 95.2 0c25 0 47.8 9.6 64.8 25.4L14.9 146.4zM390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6l-19.2 19.2L80 509.3 34.7 464l22.6-22.6 19.2-19.2C48.6 384.8 32 338.3 32 288C32 164.3 132.3 64 256 64s224 100.3 224 224c0 50.3-16.6 96.8-44.6 134.2l19.2 19.2L477.3 464 432 509.3l-22.6-22.6-19.2-19.2zM352 25.4C369 9.6 391.8 0 416.8 0C469.4 0 512 42.6 512 95.2c0 18.8-5.5 36.3-14.9 51.1L352 25.4zM280 160H232v24V296v24h48V296 184 160zm0 248V360H232v48h48z"],
    "house-medical-circle-check": [640, 512, [], "e511", "M320 368.7c.2 59.2 29.7 111.6 74.8 143.3H64.1V287.6H0V240L288.4 0 520.5 193.7c-8-1.1-16.2-1.7-24.5-1.7c-54.7 0-103.5 24.9-135.8 64H320V192H256v64H192v64h64v64h64V368.7zm32-.7a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm222.6-32L552 313.4l-11.3 11.3L480 385.4l-28.7-28.7L440 345.4 417.4 368l11.3 11.3 40 40L480 430.6l11.3-11.3 72-72L574.6 336z"],
    "traffic-cone": [512, 512, [], "f636", "M173.7 128L224 0h64l50.3 128H173.7zm-25.1 64H363.4l37.7 96H110.9l37.7-96zM48 448l37.7-96H426.3L464 448h48v64H0V448H48z"],
    "grate": [448, 512, [], "e193", "M32 32H0V64 256 448v32H32h96 96 96 96 32V448 256 64 32H416 320 224 128 32zM64 224V96H96V224H64zm0 64H96V416H64V288zm96 128V288h32V416H160zm96 0V288h32V416H256zm96 0V288h32V416H352zm32-192H352V96h32V224zM288 96V224H256V96h32zm-96 0V224H160V96h32z"],
    "arrow-down-right": [384, 512, [], "e093", "M320 416h32V384 160 128H288v32V306.7L86.6 105.4 64 82.7 18.7 128l22.6 22.6L242.7 352H96 64v64H96 320z"],
    "person-skiing-nordic": [576, 512, ["skiing-nordic"], "f7ca", "M336 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM178.7 96H192h48 4.8l4.6 1.4 104 32 14.4 4.4 5.8 13.9L405.3 224H448h32v64H461.7L434.6 464H528V432 408h48v24 56 24H552 320.7c-.5 0-1 0-1.4 0H160.7c-.4 0-.9 0-1.4 0H24 0V464H24 67l55.6-264.1L98.7 176l22.6-22.6 48-48 9.4-9.4zM402.3 464l27.1-176H384 362.7l-8.2-19.7-21.5-51.7L302 299 369 340.9l20.4 12.8-6.6 23.2L357.8 464h44.4zm-270.1 0l58.7-125.7c5.9 6.6 12.8 12.5 20.6 17.3l32.4 20.3L202.8 464h88.5l23.3-81.6-86.2-53.9c-25.1-15.7-36.1-46.5-26.8-74.5l31.3-94H205.3l-38.6 38.6-14 14L99.7 464h32.4z"],
    "calendar-plus": [512, 512, [], "f271", "M128 0V64H32v96H480V64H384V0H320V64H192V0H128zM480 192H32V512H480V192zM280 248v24 56h56 24v48H336 280v56 24H232V432 376H176 152V328h24 56V272 248h48z"],
    "person-from-portal": [512, 512, ["portal-exit"], "e023", "M154.2 352c3.8-29.6 5.8-62.1 5.8-96c0-18-.6-35.5-1.7-52.4L176 221.3l22.6-22.6L237.3 160h27.7l-31.3 94c-9.3 28 1.7 58.8 26.8 74.5l86.2 53.9-9.4 32.8-16 56L309.6 512h66.6l6.6-23.2 16-56 16-56 6.6-23.2L401 340.9 334 299l29-77.4 24.3 48.6 8.8 17.7H416h48 32V224H464 435.8l-39.2-78.3-5.4-10.9-11.3-4.5-80-32L294.2 96H288 224 210.7l-9.4 9.4-48 48-.1 .1C141 63.1 112.8 0 80 0C35.8 0 0 114.6 0 256S35.8 512 80 512c25.3 0 47.8-37.5 62.5-96H208h20.8l8.4-19L253 361.6l-9.5-6c-17.5-10.9-30.5-26.8-37.9-44.9L187.2 352h-33zM416 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "plane-arrival": [640, 512, [128748], "f5af", "M32.3 196.1L32 64l72 16 24 64 96.8 26.9L176 0h80L375.7 212.9l104.6 29.1c16.7 4.6 32.2 12.6 45.7 23.4l34.1 27.3c23.8 19.1 17.9 56.8-10.6 67.6c-41.5 15.8-87 18-129.8 6.4L120.7 285.4 32.3 196.1zM32 448H608h32v64H608 32 0V448H32zm96-80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-16a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "cowbell-circle-plus": [576, 512, ["cowbell-more"], "f8b4", "M128 0h24H296h24V24 96h64l19.7 98.3C319.9 207.8 256 280.4 256 368c0 16.6 2.3 32.7 6.6 48H0L64 96h64V24 0zM285.5 465.6C277.9 492.4 253.2 512 224 512c-35.3 0-64-28.7-64-64H275.2c3.1 6.1 6.6 12 10.3 17.6zM272 48H176V96h96V48zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80V288H416v16 48H368 352v32h16 48v48 16h32V432 384h48 16V352H496 448V304z"],
    "circle-left": [512, 512, [61840, "arrow-alt-circle-left"], "f359", "M512 256A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM256 128l0 80 128 0 0 96-128 0 0 80-32 0L96 256 224 128l32 0z"],
    "distribute-spacing-vertical": [512, 512, [], "e366", "M0 32H512V80H0V32zM96 160H416V352H96V160zM512 432v48H0V432H512z"],
    "signal-bars-fair": [640, 512, ["signal-alt-2"], "f692", "M288 256H192V512h96V256zM128 384H32V512h96V384z"],
    "sportsball": [512, 512, [], "e44b", "M487.6 48.9l-.3-1.5L365.3 169.3c34.8 30.2 79 49.8 127.6 53.9c9.3-63 4.7-125.5-5.4-174.3zM465 24.4l-3.5-.6c-65.6-11-122.9-12.5-172.8-6c3.9 49.1 23.6 93.7 54 128.8L465 24.4zm-19 334c19.8-32.3 33-67.7 41.1-103.6c-55.1-5.3-105.1-28.1-144.4-62.8l-64 64L418.5 395.9c10.3-11.8 19.4-24.4 27.4-37.5zM320 169.4C285 129.7 262.1 79 257 23.3c-17 3.6-33 8.3-48.1 13.9c-37 13.7-67.8 33-93.1 56L256 233.4l64-64zM93.4 116.1C83.2 127.9 74.1 140.5 66 153.6c-19.8 32.3-33 67.7-41.1 103.6c55.1 5.3 105.1 28.1 144.4 62.8l64-64L93.4 116.1zM192 342.6c35 39.7 58 90.3 63 146.1c17-3.6 33-8.3 48.1-13.9c37-13.7 67.8-33 93.1-56L256 278.6l-64 64zm-45.3 .1c-34.8-30.2-79-49.8-127.6-53.9c-9.3 63-4.7 125.5 5.4 174.3l.3 1.5L146.7 342.7zm22.6 22.6L47 487.6l3.5 .6c65.6 11 123 12.5 172.8 6c-3.9-49.1-23.6-93.7-54-128.8z"],
    "game-console-handheld-crank": [640, 512, [], "e5b9", "M64 32H512V480H64V32zM448 96H128V256H448V96zM192 336V320H160v16 16H144 128v32h16 16v16 16h32V400 384h16 16V352H208 192V336zm144 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM544 144h24 48 24v24 32 24H616 592v72 24H568 544V272 256 200 168 144z"],
    "train-subway": [448, 512, ["subway"], "f239", "M448 0H0V448H66.7L25.4 489.4 2.8 512H93.3l64-64H290.7l64 64h90.5l-22.6-22.6L381.3 448H448V0zM208 96V256H64V96H208zm32 0H384V256H240V96zM96 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm224 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "chart-gantt": [512, 512, [], "e0e4", "M64 32V64 416H480h32v64H480 32 0V448 64 32H64zm64 64h32l96 0h32l0 64-32 0H160 128V96zm96 96H352h32v64H352 224 192V192h32zm160 96h64 32v64H448 384 352V288h32z"],
    "face-smile-upside-down": [512, 512, [], "e395", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM382.3 184.8l-28.6 14.3C344.9 181.7 312.4 144 256 144s-88.9 37.7-97.7 55.2l-28.6-14.3C142.3 159.7 184.4 112 256 112s113.7 47.7 126.3 72.8zM367.6 304a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-192 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"],
    "ball-pile": [640, 512, [], "f77e", "M320 160A80 80 0 1 0 320 0a80 80 0 1 0 0 160zM208 328a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM192 432A80 80 0 1 0 32 432a80 80 0 1 0 160 0zm128 80a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm288-80a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM432 328a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "badge-dollar": [512, 512, [], "f645", "M256 0c36.8 0 68.8 20.7 84.9 51.1C373.8 41 411 49 437 75s34 63.3 23.9 96.1C491.3 187.2 512 219.2 512 256s-20.7 68.8-51.1 84.9C471 373.8 463 411 437 437s-63.3 34-96.1 23.9C324.8 491.3 292.8 512 256 512s-68.8-20.7-84.9-51.1C138.2 471 101 463 75 437s-34-63.3-23.9-96.1C20.7 324.8 0 292.8 0 256s20.7-68.8 51.1-84.9C41 138.2 49 101 75 75s63.3-34 96.1-23.9C187.2 20.7 219.2 0 256 0zm20.9 149.3v-20h-40v20 8.5c-6.7 1.3-13.1 3.2-19.1 5.9c-16.1 7.3-29.9 20.8-33.3 40.2c-1.9 10.9-.9 21.4 3.6 30.9c4.4 9.3 11.3 15.9 18.5 20.8c12.6 8.5 29.3 13.6 42.4 17.5l2.3 .7c15.4 4.6 26.3 8.3 33.2 13.3c3 2.2 4.3 4 4.9 5.4c.6 1.3 1.2 3.9 .4 8.7c-.8 4.7-3.5 8.6-10.2 11.4c-7.3 3.1-18.7 4.5-33.2 2.3c-6.9-1.1-19-5.3-29.6-8.9l0 0 0 0 0 0c-2.4-.8-4.7-1.6-6.9-2.3l-19-6.3-12.6 38 19 6.3c1.4 .5 3.1 1 5 1.7l0 0 0 0 0 0c9.3 3.2 24 8.2 34.6 10.4v8.9 20h40v-20-8c6.5-1.1 12.7-2.8 18.5-5.3c16.9-7.2 30.3-21.1 33.8-41.4c1.9-11.2 1.1-21.8-3.1-31.4c-4.2-9.6-10.9-16.6-18.1-21.8c-13.2-9.6-30.8-14.9-44.4-19l-.8-.2c-15.6-4.7-26.7-8.2-33.8-13c-3.1-2.1-4.3-3.7-4.8-4.8c-.4-.9-1.1-2.8-.3-6.9c.5-3.1 2.9-7.2 10.4-10.6c7.6-3.4 19.1-5.2 33.1-3c4.9 .8 20 3.7 24.3 4.9l19.3 5.1 10.3-38.7L302 163.3c-5.3-1.4-18-3.9-25.1-5.2v-8.8z"],
    "money-bills-simple": [640, 512, ["money-bills-alt"], "e1f4", "M96 32V384H640V32H96zM288 208a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM48 120V96H0v24V456v24H24 520h24V432H520 48V120z"],
    "list-timeline": [512, 512, [], "e1d1", "M16 96a48 48 0 1 1 96 0A48 48 0 1 1 16 96zM64 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 160a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM208 48H448v96H208L144 96l64-48zM144 256l64-48H512v96H208l-64-48zm0 160l64-48H448v96H208l-64-48z"],
    "indian-rupee-sign": [320, 512, ["indian-rupee", "inr"], "e1bc", "M0 32H32 64 96h16H288h32V96H288 231.8c9.6 14.4 16.7 30.6 20.7 48H288h32v64H288 252.4c-13.7 60.5-65.6 106.6-129 111.6L257.2 405l27 17.2-34.5 53.9-27-17.2L14.8 326 0 316.6l0-17.5L0 288l0-32H32h80c32.8 0 61-19.7 73.3-48H32 0V144H32 185.3C173 115.7 144.8 96 112 96H96 64 32 0V32z"],
    "crop-simple": [512, 512, ["crop-alt"], "f565", "M128 32V0H64V32 64H32 0v64H32 64V416v32H96 320h32V384H320 128V128 64 32zM384 480v32h64V480 448h32 32V384H480 448l0-288V64H416L160 64v64l224 0 0 256v64 32z"],
    "money-bill-1": [576, 512, ["money-bill-alt"], "f3d1", "M576 64H0V448H576V64zM128 384H64V320c35.3 0 64 28.7 64 64zM64 192V128h64c0 35.3-28.7 64-64 64zM448 384c0-35.3 28.7-64 64-64v64H448zm64-192c-35.3 0-64-28.7-64-64h64v64zM176 256a112 112 0 1 1 224 0 112 112 0 1 1 -224 0zm76-68v40h16v48h-4H244v40h20 24 24 20V276H312h-4V208 188H288 272 252z"],
    "left-long": [512, 512, ["long-arrow-alt-left"], "f30a", "M0 256L160 96l32 0 0 96 320 0 0 128-320 0 0 96-32 0L0 256z"],
    "keyboard-down": [576, 512, [], "e1c2", "M576 0H0V288H576V0zM128 64v64H64V64h64zM64 160h64v64H64V160zm352 0v64H160V160H416zm32 0h64v64H448V160zM224 64v64H160V64h64zm32 0h64v64H256V64zm160 0v64H352V64h64zm32 0h64v64H448V64zM160 352v32L288 512 416 384V352H160z"],
    "circle-up-right": [512, 512, [], "e129", "M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zm96 320V160H192l-24 24 52 52-76 76 56 56 76-76 52 52 24-24z"],
    "cloud-bolt-moon": [576, 512, ["thunderstorm-moon"], "f76d", "M509.2 8.4c-37.3 13.1-64 48.7-64 90.6c0 53 42.8 96 95.6 96c12.4 0 24.3-2.4 35.1-6.7c-19.3 36.2-55.4 62-97.9 66.8c-5.6-37.5-29.7-68.8-62.6-84.5c-2-43.8-29.1-81-67.2-97.5C368.8 29.9 412.7 0 463.6 0c16.1 0 31.5 3 45.7 8.5zM447.9 351.9l-80 0H352V320H275.5l40-128h-51L64 344.3v7.6H0v-96c0-47.6 34.6-87 80-94.6l0-1.3c0-53 43-96 96-96c34.9 0 65.4 18.6 82.2 46.4c13-9.1 28.8-14.4 45.8-14.4c44.2 0 80 35.8 80 80c0 5.9-.6 11.7-1.9 17.2c37.4 6.7 65.8 39.4 65.8 78.7v80zM144 512l40-128H96V360L272 224 232 352h88v24L144 512z"],
    "dna": [448, 512, [129516], "f471", "M448 32c0 59.8-30.3 107.5-69.4 146.6c-28 28-62.5 53.5-97.3 77.4l-2.5 1.7c-11.9 8.1-23.8 16.1-35.5 23.9l0 0 0 0 0 0-1.6 1c-6 4-11.9 7.9-17.8 11.9c-20.9 14-40.8 27.7-59.3 41.5H283.3c-9.8-7.4-20.1-14.7-30.7-22.1l7-4.7 3-2c15.1-10.1 30.9-20.6 46.7-31.6c25 18.1 48.9 37.3 69.4 57.7C417.7 372.5 448 420.2 448 480v32H384V480H64v32H32 0V480c0-59.8 30.3-107.5 69.4-146.6c28-28 62.5-53.5 97.3-77.4c-34.8-23.9-69.3-49.3-97.3-77.4C30.3 139.5 0 91.8 0 32V0H64V32H384V0h32 32V32zM338.6 384H109.4c-10.1 10.6-18.6 21.3-25.5 32H364.1c-6.8-10.7-15.3-21.4-25.5-32zM109.4 128H338.6c10.1-10.7 18.6-21.3 25.5-32H83.9c6.8 10.7 15.3 21.3 25.5 32zm55.4 48c18.4 13.8 38.4 27.5 59.3 41.5c20.9-14 40.8-27.7 59.3-41.5H164.7z"],
    "virus-slash": [640, 512, [], "e075", "M476.4 347.1c-1.4-29.7 21.2-59.1 56-59.1H544h32V256 224H544 532.5c-49.9 0-74.9-60.3-39.6-95.6l8.2-8.2 22.6-22.6L501 75 478.4 52.4 455.8 75l-8.2 8.2 0 0C412.3 118.4 352 93.4 352 43.5V32 0H320 288V32 43.5c0 49.9-60.3 74.9-95.6 39.6L184.2 75 161.6 52.4 139 75l0 0 0 0-5.7 5.7L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L476.4 347.1zM264.2 182.3c7-4 15.2-6.3 23.8-6.3c26.5 0 48 21.5 48 48c0 4.4-.6 8.7-1.7 12.8l-70.1-54.4zM402 412.7L144.7 210c-9.5 8.5-22.2 14-37.2 14H96 64v32 32H96h11.5c49.9 0 74.9 60.3 39.6 95.6l-8.2 8.2-22.6 22.6L139 437l0 0 22.6 22.6L184.2 437l8.2-8.2 0 0c35.3-35.2 95.6-10.3 95.6 39.6V480v32h32 32V480 468.5c0-31.2 23.6-52.7 50-55.7z"],
    "bracket-round-right": [192, 512, [], "29", "M192 256C192 140.2 120.1 62.9 81.8 37.4L46.3 90.6C71.9 107.7 128 167 128 256s-56.1 148.3-81.8 165.4l35.5 53.3C120.1 449.1 192 371.8 192 256z"],
    "circle-sterling": [512, 512, [], "e5cf", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm5.5-352c-16.8 0-30.4 13.7-30.3 30.5l.2 33.5H272h16v32H272 231.7l.3 41.2 0 5.9-2.7 5.3-6 11.6H328h24v48H328 184 144.7l18-35L184 291.6l-.3-35.6H176 160V224h16 7.5l-.2-33.1c-.3-43.5 34.8-78.9 78.3-78.9c10 0 19.8 1.9 29.1 5.6l30.3 12.1 22.3 8.9-17.8 44.6-22.3-8.9-30.3-12.1c-3.6-1.4-7.4-2.2-11.3-2.2z"],
    "circle-5": [512, 512, [], "e0f2", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 128H312h24v48H312 229.9L226 218.9l56 6.7c39.9 4.8 70 38.7 70 78.9c0 43.9-35.6 79.5-79.5 79.5h-33c-29.8 0-57.1-16.4-71.2-42.6l-5.4-10 42.3-22.7 5.4 10c5.7 10.7 16.9 17.3 29 17.3h33c17.4 0 31.5-14.1 31.5-31.5c0-15.9-11.9-29.3-27.7-31.2l-79.1-9.5L174 261.1l2.1-23.2 8-88 2-21.8H208z"],
    "minus": [448, 512, [8211, 8722, 10134, "subtract"], "f068", "M432 288H400L48 288H16l0-64 32 0 352 0 32 0v64z"],
    "fire-flame": [384, 512, ["flame"], "f6df", "M203.1 9.7L192 0 180.9 9.7C104.2 76.8 45.7 162.2 10.9 258C3.7 277.8 0 299 0 320.2C0 425.4 86.8 512 192 512s192-86.6 192-191.8c0-21.1-3.7-42.3-10.9-62.2c-34.8-95.8-93.3-181.2-170-248.3zM208 144v15.9c0 12.9 5.2 25.2 14.3 34.2l47.1 46.4C291.5 262.2 304 292 304 323c0 60.2-48.8 109-109 109h-3c-61.9 0-112-50.6-112-112.4c0-25.5 12-49.6 32.4-64.9L128 243v55c0 24.3 19.8 44 44.1 44c24.2 0 43.9-19.6 43.9-43.8c0-11.6-4.6-22.8-12.8-31l-16.8-16.8c-11.7-11.7-18.3-27.7-18.3-44.3c0-19 8.6-37 23.5-48.9L208 144z"],
    "right-to-line": [448, 512, ["arrow-alt-to-right"], "f34c", "M192 96L352 256 192 416l-32 0 0-96L0 320 0 192l160 0 0-96 32 0zM384 416l0-320 0-32 64 0 0 32 0 320 0 32-64 0 0-32z"],
    "gif": [576, 512, [], "e190", "M0 32H576V480H0V32zM320 160H288v16V336v16h32V336 176 160zm32 0v16 80 80 16h32V336 272h64 16V240H448 384V192h80 16V160H464 368 352zM128 256c0-35.3 28.7-64 64-64c14.4 0 27.7 4.8 38.4 12.8l19.2-25.6c-16-12.1-36-19.2-57.6-19.2c-53 0-96 43-96 96s43 96 96 96c21.6 0 41.6-7.1 57.6-19.2L256 328v-8V264 248H240 184 168v32h16 40v31.4c-9.4 5.4-20.3 8.6-32 8.6c-35.3 0-64-28.7-64-64z"],
    "chess": [512, 512, [], "f439", "M144 0V16 32h16 16V64H160 144V96h72v24l-29.3 88H208v48H184h-5.8l17.5 128H60.4L77.8 256H72 48V208H69.3L40 120V96h72V64H96 80V32H96h16V16 0h32zM48 416H208h4.1l2.4 3.4 40 56 1.5 2.1V480v24 8h-8H8 0v-8V480v-2.6l1.5-2.1 40-56 2.4-3.4H48zM304 272V192h40v32h24V192h64v32h24V192h40v80l-36.8 40 3.3 72H337l2.2-72L304 272zm80 64h32V304c0-8.8-7.2-16-16-16s-16 7.2-16 16v32zm-48 80H464h4.1l2.4 3.4 40 56 1.5 2.1V480v24 8h-8H296h-8v-8V480v-2.6l1.5-2.1 40-56 2.4-3.4H336z"],
    "trash-slash": [640, 512, [], "e2b3", "M231.2 17.7C236.6 6.8 247.7 0 259.8 0H380.2c12.1 0 23.2 6.8 28.6 17.7L416 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H153l41.2 32H512L497.3 363.3l123.6 96 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L97.9 53.2C102.3 40.8 114.1 32 128 32h96l7.2-14.3zM149.2 467L132.5 200.4 488 480.5C481.2 499 463.5 512 442.9 512H197.1c-25.3 0-46.3-19.7-47.9-45z"],
    "arrow-left-long": [512, 512, ["long-arrow-left"], "f177", "M22.6 278.6L0 256l22.6-22.6 128-128 22.6-22.6L218.5 128l-22.6 22.6L122.5 224 480 224l32 0 0 64-32 0-357.5 0 73.4 73.4L218.5 384l-45.3 45.3-22.6-22.6-128-128z"],
    "plug-circle-check": [576, 512, [], "e55c", "M128 0H64V32v96h64V32 0zM320 0H256V32v96h64V32 0zM32 160H0v64H32v32c0 77.4 55 142 128 156.8V512h64V412.8c12.3-2.5 24.1-6.4 35.1-11.5c-2.1-10.8-3.1-21.9-3.1-33.3c0-80.6 54.1-148.5 128-169.4V160H352 32zM576 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-65.4-32l-11.3 11.3-72 72L416 430.6l-11.3-11.3-40-40L353.4 368 376 345.4l11.3 11.3L416 385.4l60.7-60.7L488 313.4 510.6 336z"],
    "font-case": [640, 512, [], "f866", "M153 32l-7.3 21.8L2.6 480H70.1l37.6-112H244.3l37.6 112h67.5L206.3 53.8 199 32H153zm69.8 272H129.2L176 164.6 222.8 304zM640 192V160H576v17.1c-18.8-10.9-40.7-17.1-64-17.1c-70.7 0-128 57.3-128 128v64c0 70.7 57.3 128 128 128c23.3 0 45.2-6.2 64-17.1V480h64V448 352.1l0-.1V288l0-.1V192zM512 224c35.3 0 64 28.6 64 63.9l0 .1v64l0 .1c0 35.3-28.7 63.9-64 63.9c-35.3 0-64-28.7-64-64V288c0-35.3 28.7-64 64-64z"],
    "street-view": [512, 512, [], "f21d", "M192 64a64 64 0 1 1 128 0A64 64 0 1 1 192 64zm32 96h64c35.3 0 64 28.7 64 64v80H318.2L304 432H208L193.8 304H160V224c0-35.3 28.7-64 64-64zM55.3 419.2c-3.6 2.4-3.6 7.2 0 9.6c8.8 5.7 23.1 11.8 43 17.3C137.7 457 193.5 464 256 464s118.3-7 157.7-17.9c19.9-5.5 34.2-11.6 43-17.3c3.6-2.4 3.6-7.2 0-9.6c-2.1-1.4-4.8-2.9-7.9-4.5c-15.3-7.7-38.8-14.9-69-20.5l8.6-47.2c32.4 5.9 60.9 14.2 82 24.8c10.5 5.3 20.3 11.7 27.8 19.6c7.6 8.1 14 19.1 14 32.6c0 21.4-15.5 36.1-29.1 45c-14.7 9.6-34.3 17.3-56.4 23.4C381.8 504.7 321.6 512 256 512s-125.8-7.3-170.4-19.6c-22.1-6.1-41.8-13.8-56.4-23.4C15.5 460.1 0 445.4 0 424c0-13.5 6.4-24.5 14-32.6c7.5-7.9 17.3-14.3 27.8-19.6c21-10.6 49.5-18.9 82-24.8l8.6 47.2c-30.2 5.5-53.7 12.8-69 20.5c-3.2 1.6-5.8 3.1-7.9 4.5z"],
    "arrow-down-left": [384, 512, [], "e091", "M64 416H32V384 160 128H96v32V306.7L297.4 105.4 320 82.7 365.3 128l-22.6 22.6L141.3 352H288h32v64H288 64z"],
    "franc-sign": [320, 512, [], "e18f", "M320 32H112 48V96v96 64 64H0v64H48v96h64V384H224V320H112V256H288V192H112V96H320V32z"],
    "flask-round-poison": [448, 512, ["flask-poison"], "f6e0", "M320 167.4C386.6 202.1 432 271.8 432 352c0 64.3-29.2 121.8-75.1 160H91.1C45.2 473.8 16 416.3 16 352c0-80.2 45.4-149.9 112-184.6V64H96V0h32 64 64 64 32V64H320V167.4zM336 312c0-48.6-50.1-88-112-88s-112 39.4-112 88c0 29.9 19 56.3 48 72.2V432H288V384.2c29-15.9 48-42.3 48-72.2zM184 288a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "volume-off": [320, 512, [], "f026", "M0 352V160H128L272 32h48V480H272L128 352H0z"],
    "book-circle-arrow-right": [640, 512, [], "e0bc", "M96 0C43 0 0 43 0 96V416c0 53 43 96 96 96H384h10.8c-23.3-16.4-42.5-38.4-55.6-64H96c-17.7 0-32-14.3-32-32s14.3-32 32-32H320.7c-.5-5.3-.7-10.6-.7-16c0-80.6 54.1-148.5 128-169.4V0H416 384 96zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM504 289.4l11.3 11.3 56 56L582.6 368l-11.3 11.3-56 56L504 446.6 481.4 424l11.3-11.3L521.4 384H432 416V352h16 89.4l-28.7-28.7L481.4 312 504 289.4z"],
    "chart-user": [640, 512, ["user-chart"], "f6a3", "M160 0h32H608h32V32 384v32H608 324.6l-19.2-64H576V64H224v49.1C205.2 102.2 183.3 96 160 96V32 0zM473 201l-72 72-17 17-17-17-64-64-17-17L320 158.1l17 17 47 47 55-55-39-39 16-16H528V224l-16 16-39-39zM64 224a96 96 0 1 1 192 0A96 96 0 1 1 64 224zM272 352l48 160H0L48 352H272z"],
    "hands-asl-interpreting": [640, 512, ["american-sign-language-interpreting", "asl-interpreting", "hands-american-sign-language-interpreting"], "f2a3", "M260.5 69.9l24.6-20.5L244.1 .3 219.5 20.8 133.6 92.3l15-30 14.3-28.6L105.7 5.1 91.4 33.7 13.5 189.4C4.6 207.2 0 226.8 0 246.7V256c0 70.7 57.3 128 128 128h72 8v-.3c46.2-3.5 83.8-37.1 93.6-81.2l-62.5-13.8c-4 17.9-20 31.3-39.1 31.3c-22.1 0-40-17.9-40-40s17.9-40 40-40c19.1 0 35.1 13.4 39.1 31.3l62.5-13.8c-8-36.3-34.9-65.5-69.9-76.7l64.8-17.7 30.9-8.4L310.5 93.1l-30.9 8.4-84.7 23.1 65.6-54.7zM378.8 442.3l-24.6 20.5 41 49.2 24.6-20.5 85.9-71.6-15 30-14.3 28.6 57.2 28.6 14.3-28.6 77.9-155.7c8.9-17.8 13.5-37.4 13.5-57.2v-9.3c0-70.7-57.3-128-128-128h-72-8v.3c-46.2 3.5-83.8 37.1-93.6 81.2l62.5 13.8c4-17.9 20-31.3 39.1-31.3c22.1 0 40 17.9 40 40s-17.9 40-40 40c-19.1 0-35.1-13.4-39.1-31.3l-62.5 13.8c8 36.3 34.9 65.5 69.9 76.7L342.9 349 312 357.4l16.8 61.7 30.9-8.4 84.7-23.1-65.6 54.7z"],
    "presentation-screen": [576, 512, ["presentation"], "f685", "M32 0H0V64H32V320v32H64 256v34.7l-54.6 54.6L178.7 464 224 509.3l22.6-22.6L288 445.3l41.4 41.4L352 509.3 397.3 464l-22.6-22.6L320 386.7V352H512h32V320 64h32V0H544 480 96 32zM96 64H480V288H320 256 96V64z"],
    "circle-bolt": [512, 512, [], "e0fe", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM232 272H144V248L320 112 280 240h88v24L192 400l40-128z"],
    "face-smile-halo": [512, 512, [], "e38f", "M512 80c0 44.2-114.6 80-256 80S0 124.2 0 80S114.6 0 256 0S512 35.8 512 80zm-64 0c0-17.7-86-32-192-32S64 62.3 64 80s86 32 192 32s192-14.3 192-32zM16 272c0-41.9 10.7-81.3 29.6-115.5C98.1 178.3 173 192 256 192s157.9-13.7 210.4-35.5C485.3 190.7 496 230.1 496 272c0 132.5-107.5 240-240 240S16 404.5 16 272zm148.1 85.5c-5.8-6.7-15.9-7.4-22.6-1.6s-7.4 15.9-1.6 22.6c22.2 25.7 61 53.5 116.1 53.5s93.8-27.9 116.1-53.5c5.8-6.7 5.1-16.8-1.6-22.6s-16.8-5.1-22.6 1.6C330 378.2 299.4 400 256 400s-74-21.8-91.9-42.5zm53.5-56.7l0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 260.4 120 278.1 120 296c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0 0 0zm160 0l0 0 0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 260.4 280 278.1 280 296c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8l0 0 0 0 0 0 .2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2 0 0z"],
    "cart-circle-arrow-down": [640, 512, [], "e3ef", "M24 0H0V48H24 76.1l60.3 316.5 3.7 19.5H160 320.7c-.5-5.3-.7-10.6-.7-16c0-10.9 1-21.6 2.9-32h-143l-9.1-48H339.2c29.1-57 88.4-96 156.8-96c10 0 19.7 .8 29.2 2.4L576 32H122l-2.4-12.5L115.9 0H96 24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm320 0a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm78.6-136l-11.3 11.3-56 56L496 454.6l-11.3-11.3-56-56L417.4 376 440 353.4l11.3 11.3L480 393.4V304 288h32v16 89.4l28.7-28.7L552 353.4 574.6 376z"],
    "house-person-return": [640, 512, ["house-person-arrive", "house-return"], "e011", "M380.6 121.8l-5.8 11.5-37.5 74.9-28.9 14.5-28.6 14.3 14.3 28.6 28.6 57.2 14.3 28.6 28.6-14.3 13.7-6.8-14.7 16.1-5.2 5.7-2 7.5L342 416H64V256H0V208L240 0 380.6 121.8zM128 192v96h96V192H128zM432 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm75.7 126.6l9.3 4.1 72 32 12.9 5.7 4.5 13.4 16 48 10.1 30.4-60.7 20.2-10.1-30.4-11.5-34.6-36.7-16.3 17 63.6c5.6 21.1 .1 43.6-14.7 59.7l-70.9 77.4-22 80.5-8.4 30.9-61.7-16.8 8.4-30.9 24-88 2-7.5 5.2-5.7 52.3-57-18.4-62.4-13.7 27.4-4.8 9.5-9.5 4.8-48 24-28.6-57.2 38.5-19.2 35.2-70.5 7-14 15.3-3.1 80-16 10-2zm38.6 209l25 62.4 43.4 43.4L637.3 464 592 509.3l-22.6-22.6-48-48-4.6-4.6-2.4-6.1-15.7-39.3 40.7-44.4c2.5-2.7 4.8-5.6 7-8.6z"],
    "message-xmark": [512, 512, ["comment-alt-times", "message-times"], "f4ab", "M0 0H512V416H304L160 512V416H0V0zM353.9 144L320 110.1l-17 17-47 47-47-47-17-17L158.1 144l17 17 47 47-47 47-17 17L192 305.9l17-17 47-47 47 47 17 17L353.9 272l-17-17-47-47 47-47 17-17z"],
    "file-certificate": [512, 512, ["file-award"], "f5f3", "M352 0H128V134.7l23.6-9.7 22.5-9.2L189 135.1l15.6 20.2 25.3 3.4 24.1 3.3 3.3 24.1 3.4 25.3L280.9 227l19.2 14.9L291 264.4 281.3 288l9.7 23.6 9.2 22.5L280.9 349l-20.2 15.6-3.4 25.3L254 414l-24.1 3.3-5.9 .8V512v0H512V160H352V0zm32 0V128H512L384 0zM92.3 154.6l-3.7 4.8L68.6 185.2l-32.2 4.4-6 .8-.8 6-4.4 32.2L-.5 248.5l-4.8 3.7 2.3 5.6L9.3 288-3 318.1l-2.3 5.6 4.8 3.7 25.7 19.9 4.4 32.2 .8 6 6 .8L64 390.2V512l64-40 64 40V390.2l27.6-3.8 6-.8 .8-6 4.4-32.2 25.7-19.9 4.8-3.7-2.3-5.6L246.7 288 259 257.9l2.3-5.6-4.8-3.7-25.7-19.9-4.4-32.2-.8-6-6-.8-32.2-4.4-19.9-25.7-3.7-4.8-5.6 2.3L128 169.3 97.9 157l-5.6-2.3zM64 288a64 64 0 1 1 128 0A64 64 0 1 1 64 288z"],
    "user-doctor-hair-long": [448, 512, [], "e459", "M304 144c0 44.2-35.8 80-80 80s-80-35.8-80-80V128c0-5.5 .6-10.8 1.6-16H208l32-32 16 16h41.3c4.3 9.8 6.7 20.6 6.7 32v16zM224 0C153.3 0 96 57.3 96 128v16 48L48 240v32H224 400V240l-48-48V144 128C352 57.3 294.7 0 224 0zM160 370.3c23.1 6.9 40 28.3 40 53.7c0 30.9-25.1 56-56 56s-56-25.1-56-56c0-25.4 16.9-46.8 40-53.7V320H48L0 512H448L400 320H320v42c27.6 7.1 48 32.2 48 62v40 16H352 336 320V448h16V424c0-17.7-14.3-32-32-32s-32 14.3-32 32v24h16v32H272 256 240V464 424c0-29.8 20.4-54.9 48-62V320H160v50.3zm8 53.7a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "camera-security": [448, 512, ["camera-home"], "f8fe", "M0 0H448V416H304l80 56v40H64V472l80-56H0V0zM128 208a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zm224 0A128 128 0 1 0 96 208a128 128 0 1 0 256 0z"],
    "gear": [512, 512, [9881, "cog"], "f013", "M200 0H312l17.2 78.4c15.8 6.5 30.6 15.1 44 25.4l76.5-24.4 56 97-59.4 54.1c1.1 8.3 1.7 16.8 1.7 25.4s-.6 17.1-1.7 25.4l59.4 54.1-56 97-76.5-24.4c-13.4 10.3-28.2 18.9-44 25.4L312 512H200l-17.2-78.4c-15.8-6.5-30.6-15.1-44-25.4L62.3 432.5l-56-97 59.4-54.1C64.6 273.1 64 264.6 64 256s.6-17.1 1.7-25.4L6.3 176.5l56-97 76.5 24.4c13.4-10.3 28.2-18.9 44-25.4L200 0zm56 336a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "droplet-slash": [640, 512, ["tint-slash"], "f5c7", "M209.9 140.2L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L505.5 369.7c4.2-15.8 6.5-32.5 6.5-49.7C512 214 320 0 320 0s-57.9 64.5-110.1 140.2zM456.1 455.4L159.8 221.9c-19 36.2-31.8 70.8-31.8 98.1c0 106 86 192 192 192c53.2 0 101.4-21.6 136.1-56.6zM224 336c0 44.2 35.8 80 80 80h16v32H304c-61.9 0-112-50.1-112-112V320h32v16z"],
    "book-heart": [448, 512, [], "f499", "M0 96C0 43 43 0 96 0H384h32 32V384H416v64h32v64H416 384 96c-53 0-96-43-96-96V96zM64 416c0 17.7 14.3 32 32 32H352V384H96c-17.7 0-32 14.3-32 32zm64-260.8c0 16.1 6.6 31.5 18.2 42.7l82.8 79.6L240 288.1l11.1-10.7 82.8-79.6c11.6-11.2 18.2-26.6 18.2-42.7c0-32.7-26.5-59.2-59.2-59.2h-2.4c-15.9 0-31.2 6.2-42.7 17.2l-7.7 7.4-7.7-7.4c-11.5-11-26.8-17.2-42.7-17.2h-2.4c-32.7 0-59.2 26.5-59.2 59.2z"],
    "mosque": [640, 512, [128332], "f678", "M0 512V160H160V288H128v32V512H0zM80 0s80 32 80 128H0C0 32 80 0 80 0zM216.6 288c-13.2-15.6-24.6-37-24.6-64c0-74 53.5-105.2 107.9-137C339.6 63.9 379.8 40.5 400 0c20.2 40.5 60.4 63.9 100.1 87C554.5 118.8 608 150 608 224c0 27-11.4 48.4-24.6 64H216.6zM288 512V440c0-13.3-10.7-24-24-24s-24 10.7-24 24v72H160V320H640V512H560V440c0-13.3-10.7-24-24-24s-24 10.7-24 24v72H448V454c0-19-8.4-37-23-49.2L400 384l-25 20.8C360.4 417 352 435 352 454v58H288z"],
    "duck": [512, 512, [129414], "f6d8", "M431.5 125.9C426.5 73.2 382 32 328 32c-57.4 0-104 46.6-104 104c0 36.8 19.1 69.2 48 87.7v4.9L64 288 32 256H0v32C0 394 86 480 192 480H312c70.7 0 128-57.3 128-128c0-36.6-15.4-69.6-40-93V224h16c53 0 96-43 96-96H448l-16.5-2.1zM320 136a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM308.6 295.1l31.9 1.9c-3.2 55.6-43.5 104.9-101.5 119.3c-52.4 13.1-105.3-5.8-136.4-44.5l25-20c23.2 28.9 63.3 43.6 103.7 33.5c44.7-11.2 74.9-48.9 77.3-90.1z"],
    "mosquito": [640, 512, [], "e52b", "M154.6 387.8L288 266l0 .2-67 87-5 6.5 0 8.2 0 53.5-40.4 37.9-17.5 16.4 32.9 35 17.5-16.4 48-45.1 7.6-7.1 0-10.4 0-55.7 24-31.2 0 62.9 0 32 64 0 0-32 0-62.9L376 376l0 55.7 0 10.4 7.6 7.1 48 45.1 17.5 16.4 32.9-35-17.5-16.4L424 421.4l0-53.5 0-8.2-5-6.5-67-87 0-.2L485.4 387.8C542.4 447.6 640 405.2 640 320.6c0-47.9-34-88.3-79.4-94.2l-153-23.9L449 161.1l13-13-9.1-15.9L429.5 91.4l36.3-40.1 16.1-17.8L446.3 1.3 430.2 19.1l-48 53L370.5 85l8.6 15.1 22.9 40L352 190.3l0-38.2 0-32-24 0 0-48.2 0-8-16 0 0 8 0 48.2-24 0 0 32 0 38.1-50.1-50.1 22.9-40L269.5 85 257.8 72.1l-48-53L193.7 1.3 158.1 33.5l16.1 17.8 36.3 40.1-23.3 40.8-9.1 15.9 13 13 41.3 41.4-153 23.9C34 232.3 0 272.7 0 320.6c0 84.6 97.6 127 154.6 67.1z"],
    "star-of-david": [512, 512, [10017], "f69a", "M16 400H72h91.3L232 512h48l68.7-112H440h56V352l-4.9-8-54-88 54-88 4.9-8V112H440 348.7L280 0H232L163.3 112H72 16v48l4.9 8 54 88-54 88L16 352v48zm91.8-90.5L128.9 344H86.6l21.1-34.5zM194.6 344l-54-88 54-88H317.4l54 88-54 88H194.6zM229 400h54l-27 44-27-44zm154.1-56l21.1-34.5L425.4 344H383.1zm21.1-141.5L383.1 168h42.3l-21.1 34.5zM283 112H229l27-44 27 44zM128.9 168l-21.1 34.5L86.6 168h42.3z"],
    "flag-swallowtail": [448, 512, ["flag-alt"], "f74c", "M64 32V0H0V32 480v32H64V480 352H448L352 192 448 32H64z"],
    "person-military-rifle": [512, 512, [], "e54b", "M160 16V64H352V0L160 16zm17.6 80c-1 5.2-1.6 10.5-1.6 16c0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16H177.6zM176 224h-6.1L352 484.1V369.7l53.6 90.6 20.3 34.4 68.9-40.7-20.3-34.4-81.6-138 52.4-90.8L416 173.9 479.4 64l-13.9-8L437.9 40 424 32 408 59.7l13.9 8L331.6 224H176zm-34.4 19.7l-104 176L17.2 454.1l68.9 40.7 20.3-34.4L160 369.7V512H332.5L143 241.3l-1.4 2.4zM296 272a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "car-garage": [640, 512, [], "f5e2", "M335 11.7l272 144 28.3 15-29.9 56.6-28.3-15L320 76.2 63 212.3l-28.3 15L4.7 170.7l28.3-15 272-144 15-7.9 15 7.9zM202.9 160H224 416h21.1l8.3 19.4L492 288h36v96 64 64H448V448H192v64H112V448 384 288h36l46.5-108.6 8.3-19.4zm192 64H245.1l-27.4 64H422.3l-27.4-64zM192 392a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm280-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "cart-shopping": [576, 512, [128722, "shopping-cart"], "f07a", "M24 0H0V48H24 76.1l60.3 316.5 3.7 19.5H160 488h24V336H488 179.9l-9.1-48H496L576 32H122l-2.4-12.5L115.9 0H96 24zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "book-font": [448, 512, [], "e0bf", "M0 96C0 43 43 0 96 0H384h32 32V384H416v64h32v64H416 384 96c-53 0-96-43-96-96V96zM64 416c0 17.7 14.3 32 32 32H352V384H96c-17.7 0-32 14.3-32 32zM250.1 64H229.9l-4.4 9.1-61.2 128-40.2 84-1.4 2.9h35.5l30.6-64H291.1l30.6 64h35.5l-1.4-2.9-40.2-84-61.2-128L250.1 64zm25.7 128H204.2L240 117.1 275.8 192z"],
    "shield-plus": [512, 512, [], "e24a", "M256 0l11.6 4.5L475.1 85l19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9c-32.7 75.2-91.1 150-189.4 192.6L256 512l-12.7-5.5C144.9 463.9 86.5 389.2 53.9 313.9C21.4 239.3 13.6 162.9 16.6 113l1.2-20.5L36.9 85 244.4 4.5 256 0zM232 368h48V344 280h64 24V232H344 280V168l0-24H232v24 64H168 144v48h24 64v64 24z"],
    "vials": [512, 512, [], "f493", "M0 32H32 88h48 56 32V96H192V400c0 44.2-35.8 80-80 80s-80-35.8-80-80V96H0V32zM136 96H88V256h48V96zM288 32h32 56 48 56 32V96H480V400c0 44.2-35.8 80-80 80s-80-35.8-80-80V96H288V32zM424 96H376V256h48V96z"],
    "eye-dropper-full": [512, 512, [], "e172", "M341.6 29.2L240.1 130.8l-9.4-9.4L208 98.7 162.7 144l22.6 22.6 160 160L368 349.3 413.3 304l-22.6-22.6-9.4-9.4L482.8 170.4c39-39 39-102.2 0-141.1s-102.2-39-141.1 0zM32 344v88L0 472l40 40 40-32h88L310.7 337.3l-136-136L32 344z"],
    "distribute-spacing-horizontal": [512, 512, [], "e365", "M32 0H80V512H32V0zM160 96H352V416H160V96zM480 0V512H432V0h48z"],
    "tablet-rugged": [448, 512, [], "f48f", "M352 64V448H96V64H352zM96 0H32V48L0 64v96l32 16v16L0 208v96l32 16v16L0 352v96l32 16v48H96 352h64V464l32-16V352l-32-16V320l32-16V208l-32-16V176l32-16V64L416 48V0H352 96z"],
    "temperature-snow": [576, 512, ["temperature-frigid"], "f768", "M369.8 317.8L384 300.2V277.5 64h96V277.5v22.7l14.2 17.6C505.4 331.5 512 348.9 512 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-19.1 6.6-36.5 17.8-50.3zM544 0H480 384 320V64 277.5c-20 24.7-32 56.2-32 90.5c0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5V64 0zM432 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V272 256H416v16 50.8c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48zM288 96.9l-22.6-6.1-4.1 15.5-12.9 48.2L200 182.4V126.6l35.3-35.3L246.6 80 224 57.4 212.7 68.7 200 81.4V56 32H152V56 81.4L139.3 68.7 128 57.4 105.4 80l11.3 11.3L152 126.6v55.8l-48.3-27.9L90.7 106.3 86.6 90.8 55.7 99.1l4.1 15.5 4.6 17.3-15-8.7-20.8-12-24 41.6 20.8 12 15 8.7-17.3 4.6L7.7 182.3 16 213.2 31.4 209l48.2-12.9L128 224 79.7 251.9 31.4 239 16 234.8 7.7 265.7l15.5 4.1 17.3 4.6-15 8.7-20.8 12 24 41.6 20.8-12 15-8.7-4.6 17.3-4.1 15.5 30.9 8.3 4.1-15.5 12.9-48.2L152 265.6v55.8l-35.3 35.3L105.4 368 128 390.6l11.3-11.3L152 366.6V392v24h48V392 366.6l12.7 12.7L224 390.6 246.6 368l-11.3-11.3L200 321.4V265.6l48.3 27.9 10.9 40.7c4.8-24.7 14.8-47.6 28.8-67.4V247.7l-15.7 4.2L224 224l48.3-27.9 15.7 4.2V131.6l-.5 .3 .5-1.8V96.9z"],
    "moped": [640, 512, [], "e3b9", "M328 32h24 64 17.1l5.6 16.1 15.6 44.8L512 64h32v96H512l-41.7-20.8L500 224.4c4-.3 8-.4 12-.4c43.7 0 83.3 17.5 112.1 45.8l-33.6 34.2C570.2 284.2 542.6 272 512 272c-52.7 0-97 36.5-108.9 85.6c-2 8.4-3.1 17.3-3.1 26.4H368 352 256c0 53-43 96-96 96s-96-43-96-96H0V320c0-70.7 57.3-128 128-128H256V320H365.3c16.8-38.5 48.4-69.2 87.6-84.7L398.9 80H352 328V32zM256 96v64H96V96H256zM160 432c26.5 0 48-21.5 48-48H112c0 26.5 21.5 48 48 48zm352 0a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm0-144a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "face-smile-plus": [640, 512, ["smile-plus"], "f5b9", "M568 0H520V24 72H472 448v48h24 48v48 24h48V168 120h48 24V72H616 568V24 0zM224 512a224 224 0 1 0 0-448 224 224 0 1 0 0 448zM144.4 208a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 384c33.4 0 63.5-14.6 84-37.9l24 21.2C305.6 397.1 267 416 224 416s-81.6-18.9-108-48.7l24-21.2c20.5 23.3 50.6 37.9 84 37.9z"],
    "radio-tuner": [512, 512, ["radio-alt"], "f8d8", "M485.7 55.3L509 49.6 497.6 3 474.3 8.7l-456 112L0 125.2V128v16V304v24V512H512V128H189.8l296-72.7zM320 384a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM80 336H208h16v32H208 80 64V336H80zm16 64h96 16v32H192 96 80V400H96zM64 192H96 416h32v64H416 96 64V192z"],
    "face-swear": [640, 512, [], "e399", "M320 0C178.6 0 64 114.6 64 256H576C576 114.6 461.4 0 320 0zM240.4 224c-17.7 0-32-14.3-32-32c0-8.8 3.6-16.8 9.3-22.6l-30.7-10.2-15.2-5.1 10.1-30.4 15.2 5.1 96 32 15.2 5.1-10.1 30.4-15.2-5.1-10.9-3.6c.2 1.5 .3 2.9 .3 4.4c0 17.7-14.3 32-32 32zm192-32c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-1.6 .1-3.2 .3-4.7l-11.7 3.9-15.2 5.1-10.1-30.4 15.2-5.1 96-32 15.2-5.1 10.1 30.4-15.2 5.1-30.2 10.1c5.9 5.8 9.5 13.9 9.5 22.8zM0 512H640V288H0V512zM400 384H384v32h16 16v32H400 384v16 16H352V464 448H320v16 16H288V464 448H272 256V416h16 16V384H272 256V352h16 16V336 320h32v16 16h32V336 320h32v16 16h16 16v32H400zm-80 0v32h32V384H320zm262.6-41.7l-10.4 12.1-96 112-10.4 12.1-24.3-20.8 10.4-12.1 96-112 10.4-12.1 24.3 20.8zM448 352a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM224 320v16 64 16H192V400 336 320h32zM192 448h32v32H192V448zM96.4 335.5V320h32v15.3c5.3 .9 10.4 2 15.1 3.2l15.5 3.9-7.7 31.1-15.5-3.9c-8.4-2.1-16.4-3.6-23.7-3.7c-5.5-.1-12 1.1-16.3 3.5c-2 1.1-3 2.1-3.3 2.6c-.2 .3-.5 .9-.5 2.4c0 .3 0 .3 .1 .4l0 0c.3 .4 1.2 1.3 3.5 2.5c4.9 2.7 11.9 4.6 21.4 7.3l.2 .1c8.4 2.4 19.3 5.4 28 10.6c9.6 5.6 18.9 15.2 19.3 30.6c.5 17.3-9.2 28.8-20.5 34.9c-5 2.7-10.5 4.5-15.8 5.6V480h-32V465.7c-7.5-1.6-14.5-3.8-20.6-5.8l0 0 0 0c-1.6-.5-3.1-1-4.5-1.4L56 453.7l9.5-30.6 15.3 4.8c1.8 .6 3.6 1.1 5.3 1.7l0 0c10.4 3.3 18.4 5.8 26.8 6.1c6 .2 12.1-1 16.1-3.1c1.8-1 2.7-1.9 3.1-2.5c.3-.5 .8-1.4 .7-3.3l0-.1c0-.6 0-1.7-3.6-3.8c-4.6-2.7-11.3-4.8-20.7-7.4l-1.6-.5 0 0c-8-2.3-18.1-5.1-26.3-9.5c-9.2-5-19.4-13.8-20.4-29.1C59 358.5 69.7 347 80.8 341.1c5-2.7 10.4-4.5 15.6-5.6z"],
    "water-arrow-down": [576, 512, ["water-lower"], "f774", "M256 222.2V224h2l8.4 7.7L288 251.2l21.5-19.6L318 224h2v-1.8l77.5-70.5 23.7-21.5-43-47.4-23.7 21.5L320 135.7 320 32V0H256V32 135.7l-34.5-31.3L197.8 82.8l-43.1 47.4 23.7 21.5L256 222.2zm32 263.2c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V448c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7L96 408.7l-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 441.9 19.3 448 0 448v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7zM272.4 365.1c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V320c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 313.9 19.3 320 0 320v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9z"],
    "scanner-touchscreen": [512, 512, [], "f48a", "M192 0V64H128V0h64zM352 0V64H288V0h64zM224 0h32V64H224V0zM416 0V288H384V0h32zm32 0h64V288H448V0zM0 96H352V512H0V96zm64 64V448H288V160H64z"],
    "circle-7": [512, 512, [], "e0f4", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm72-384h24v29.4l-2.3 4.9L245.5 384h-53l3.9-8.2L290.2 176H184 160V128h24H328z"],
    "plug-circle-plus": [576, 512, [], "e55f", "M128 0H64V32v96h64V32 0zM320 0H256V32v96h64V32 0zM32 160H0v64H32v32c0 77.4 55 142 128 156.8V512h64V412.8c12.3-2.5 24.1-6.4 35.1-11.5c-2.1-10.8-3.1-21.9-3.1-33.3c0-80.6 54.1-148.5 128-169.4V160H352 32zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208v48h48 16v32H496 448v48 16H416V432 384H368 352V352h16 48V304 288h32v16z"],
    "person-ski-jumping": [512, 512, ["ski-jump"], "f7c7", "M352 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM128 96h32H320h13.3l9.4 9.4 13.8 13.8 25.9 25.9-29.2 22.2L230.1 260.8l-6.4 7.5c-2.4 2.8-4.4 6.1-5.7 9.6L179.8 380 464 233.4V192 168h48v24 56 14.6l-13 6.7L50.5 500.7l-21.3 11L7.1 469l21.3-11 66.6-34.4 63-168.3c3.9-10.5 9.7-20.3 17-28.8L232.1 160H160 128V96z"],
    "place-of-worship": [640, 512, [], "f67f", "M224 96v89.6L160 224V512h96V416c0-35.3 28.7-64 64-64s64 28.7 64 64v96h96V224l-64-38.4V96L320 0 224 96zM0 344V512H128V273.6L0 344zM640 512V344L512 273.6V512H640z"],
    "water-arrow-up": [576, 512, ["water-rise"], "f775", "M320 123.5l34.5 31.3 23.7 21.5 43-47.4-23.7-21.5-88-80L288 8 266.5 27.5l-88 80L154.8 129l43.1 47.4 23.7-21.5L256 123.5l0 84.5v32h64V208l0-84.5zM288 485.4c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.6 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V448c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7l-2.1-1.5-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7L96 408.7l-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 441.9 19.3 448 0 448v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.6 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.6 11.1-5.3 15.6-7.7zM272.4 365.1c5.8-2.6 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9c5.8-2.6 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9V320c-19.3 0-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7c-15.4 7-34.7 13.1-54 13.1s-38.6-6.1-54-13.1c-14.9-6.8-26.9-15.4-40-24.7c-.7-.5-1.4-1-2.1-1.5c-.7 .5-1.4 1-2.1 1.5c-13.1 9.3-25.1 17.9-40 24.7C38.6 313.9 19.3 320 0 320v64c31.9 0 60.6-9.9 80.4-18.9c5.8-2.6 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9s60.6-9.9 80.4-18.9z"],
    "waveform-lines": [640, 512, ["waveform-path"], "f8f2", "M352 32V0H288V32 480v32h64V480 32zM544 96V64H480V96 416v32h64V416 96zM256 128V96H192v32V384v32h64V384 128zm192 32V128H384v32V352v32h64V352 160zM160 224V192H96v32 64 32h64V288 224zM0 224v64H64V224H0zm576 0v64h64V224H576z"],
    "split": [512, 512, [], "e254", "M416 32l96 96-96 96H384V160H333.3l-96 96 96 96H384V288h32l96 96-96 96H384V416H320 306.7l-9.4-9.4L178.7 288H32 0V224H32 178.7L297.4 105.4l9.4-9.4H320h64V32h32z"],
    "film-canister": [576, 512, ["film-cannister"], "f8b7", "M256 0H96V32H32 0V96H32V448H0v64H32 320h32V448H320V96h32V32H320 256V0zm96 128V416H512V320h64V128H352zm88 40v48H392V168h48zm48 0h48v48H488V168zM440 328v48H392V328h48z"],
    "folder-xmark": [512, 512, ["folder-times"], "f65f", "M512 480H0V32H224l48 64H512V480zM353.9 224L320 190.1l-17 17-47 47-47-47-17-17L158.1 224l17 17 47 47-47 47-17 17L192 385.9l17-17 47-47 47 47 17 17L353.9 352l-17-17-47-47 47-47 17-17z"],
    "toilet-paper-blank": [640, 512, ["toilet-paper-alt"], "f71f", "M444.2 0C397.2 49.6 384 126.5 384 192c0 109.9-8 217.7-50.7 320H8l18.4-44.2C60.1 382.6 64 281.9 64 192C64 86 107 0 160 0H444.2zM608 192c0 106-43 192-96 192s-96-86-96-192S459 0 512 0s96 86 96 192zm-64 0c0-35.3-14.3-64-32-64s-32 28.7-32 64s14.3 64 32 64s32-28.7 32-64z"],
    "tablet-screen": [448, 512, ["tablet-android-alt"], "f3fc", "M0 0H448V512H0V0zM160 432v32h16 96 16V432H272 176 160zM384 64H64V384H384V64z"],
    "hexagon-vertical-nft-slanted": [448, 512, [], "e506", "M0 128V384L224 512 448 384V128L224 0 0 128zM192 92l31.8-18.2L272 101.4v36.9l-48-27.5V240h32 16v32H256 224V432v6.3L192 420V256 92zM320 383.4V165.8L296 152V115.1l47.9 27.4 0 0L384 165.4v36.8L352 184V365.1l-32 18.3zM160 384v17.7L127.2 383 96 266.1V360v5.1L64 346.9V165.1l33.1-18.9L128 261.9V128.6l32-18.3V112 381.9 384z"],
    "folder-music": [512, 512, [], "e18d", "M512 96V480H0V32H224l48 64H512zM352 192V168.9L330.4 177l-128 48L192 228.9V240v32 81.8c-5-1.2-10.4-1.8-16-1.8c-26.5 0-48 14.3-48 32s21.5 32 48 32s48-14.3 48-32V283.1l96-36v74.7c-5-1.2-10.4-1.8-16-1.8c-26.5 0-48 14.3-48 32s21.5 32 48 32s48-14.3 48-32V224 192z"],
    "display-medical": [576, 512, ["desktop-medical"], "e166", "M0 0H576V416H336l10.7 32H416h32v64H416 160 128V448h32 69.3L240 416H0V0zM64 64V352H512V64H64zm192 48h64v64h64v64H320v64H256V240H192V176h64V112z"],
    "share-all": [576, 512, [], "f367", "M469.6 184.4L352 76.6V32h32L576 208 384 384H352V339.4L469.6 231.6 495.4 208l-25.7-23.6zM352 120l72.3 66.3L448 208l-23.7 21.7L352 296l-96 88H224V288H208c-61.9 0-112 50.1-112 112c0 48 32 80 32 80s-128-48-128-176c0-97.2 78.8-176 176-176h48V32h32l96 88z"],
    "peapod": [512, 512, [], "e31c", "M512 0H416C186.2 0 0 186.2 0 416v96H96c229.8 0 416-186.2 416-416V0zM256 200a56 56 0 1 1 0 112 56 56 0 1 1 0-112zM88 368a56 56 0 1 1 112 0A56 56 0 1 1 88 368zM368 88a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "chess-clock": [640, 512, [], "f43d", "M256 32H96V80h56v48H0V480H640V128H544V96H384v32H200V80h56V32zM576 304a112 112 0 1 1 -224 0 112 112 0 1 1 224 0zm-41.4-48L512 233.4l-11.3 11.3-48 48L441.4 304 464 326.6l11.3-11.3 48-48L534.6 256zM176 192a112 112 0 1 1 0 224 112 112 0 1 1 0-224zm-16 48v64 16h32V304 240 224H160v16z"],
    "axe": [640, 512, [129683], "f6b2", "M64 512L313.4 262.6l-64-64L0 448l64 64zM400 48L352 0 224 128 384 288v96 32h32c123.7 0 224-100.3 224-224V160H608 512l-48-48 48-48L448 0 400 48zm48 300.8V316c45-11.6 80.4-47 92-92h32.8C560.1 286.7 510.7 336.1 448 348.8z"],
    "square-d": [448, 512, [], "e268", "M448 32H0V480H448V32zM152 128h72c70.7 0 128 57.3 128 128s-57.3 128-128 128H152 128V360 152 128h24zm24 208h48c44.2 0 80-35.8 80-80s-35.8-80-80-80H176V336z"],
    "grip-vertical": [320, 512, [], "f58e", "M0 352l128 0 0 128L0 480 0 352zm192 0l128 0 0 128-128 0 0-128zM0 320L0 192l128 0 0 128L0 320zM192 192l128 0 0 128-128 0 0-128zM0 160L0 32l128 0 0 128L0 160zM192 32l128 0 0 128-128 0 0-128z"],
    "mobile-signal-out": [512, 512, [], "e1f0", "M64 64H224V0H64 0V64 448v64H64 288h64V448 288H288V448H64V64zm80 320H128v32h16 64 16V384H208 144zM256 48c114.9 0 208 93.1 208 208h48C512 114.6 397.4 0 256 0V48zm32 208a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm80 0h48c0-88.4-71.6-160-160-160v48c61.9 0 112 50.1 112 112z"],
    "arrow-turn-up": [384, 512, ["level-up"], "f148", "M32 448L0 448l0 64 32 0 160 0 32 0 0-32 0-357.5 73.4 73.4L320 218.5l45.3-45.3-22.6-22.6-128-128L192 0 169.4 22.6l-128 128L18.7 173.3 64 218.5l22.6-22.6L160 122.5 160 448 32 448z"],
    "u": [384, 512, [117], "55", "M64 32V64 288c0 70.7 57.3 128 128 128s128-57.3 128-128V64 32h64V64 288c0 106-86 192-192 192S0 394 0 288V64 32H64z"],
    "arrow-up-from-dotted-line": [448, 512, [], "e09b", "M246.6 57.4L224 34.7 201.4 57.4l-128 128L50.7 208 96 253.3l22.6-22.6L192 157.3V320v32h64V320 157.3l73.4 73.4L352 253.3 397.3 208l-22.6-22.6-128-128zM64 416H0v64H64V416zm96 0H96v64h64V416zm32 64h64V416H192v64zm160-64H288v64h64V416zm32 0v64h64V416H384z"],
    "square-root-variable": [576, 512, ["square-root-alt"], "f698", "M296 32h24H544h32V96H544 344L238.7 457 232 480H189.6l-9.3-15.9L77.6 288H32 0V224H32 96h18.4l9.3 15.9 74.5 127.7L289.3 55 296 32zM528 226.7L573.3 272l-22.6 22.6L525.3 320l25.4 25.4L573.3 368 528 413.3l-22.6-22.6L480 365.3l-25.4 25.4L432 413.3 386.7 368l22.6-22.6L434.7 320l-25.4-25.4L386.7 272 432 226.7l22.6 22.6L480 274.7l25.4-25.4L528 226.7z"],
    "light-switch-on": [384, 512, [], "e019", "M384 0H0V512H384V0zM96 96H288V416H96V96zm96-64a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 416a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64-320H128V256H256V128z"],
    "arrow-down-arrow-up": [576, 512, ["sort-alt"], "f883", "M438.6 57.4l96 96L557.3 176 512 221.3l-22.6-22.6L448 157.3V448v32H384V448 157.3l-41.4 41.4L320 221.3 274.7 176l22.6-22.6 96-96L416 34.7l22.6 22.6zm-256 397.3L160 477.3l-22.6-22.6-96-96L18.7 336 64 290.7l22.6 22.6L128 354.7V64 32h64V64 354.7l41.4-41.4L256 290.7 301.3 336l-22.6 22.6-96 96z"],
    "raindrops": [448, 512, [], "f75c", "M105.5 122.8c-6.2 10.4-9.5 22.3-9.5 34.4V160c0 35.3 28.7 64 64 64s64-28.7 64-64v-2.8c0-12.1-3.3-24-9.5-34.4L160 32l-54.5 90.8zm-96 192C3.3 325.2 0 337.1 0 349.2V352c0 35.3 28.7 64 64 64s64-28.7 64-64v-2.8c0-12.1-3.3-24-9.5-34.4L64 224 9.5 314.8zM320 128L211.7 293.5c-12.8 19.6-19.7 42.6-19.7 66C192 426 246 480 312.5 480h15C394 480 448 426 448 359.5c0-23.4-6.8-46.4-19.7-66L320 128z"],
    "dash": [512, 512, ["minus-large"], "e404", "M0 224H32 480h32v64H480 32 0V224z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zM232 120V256v12.8l10.7 7.1 96 64 20 13.3 26.6-39.9-20-13.3L280 243.2V120 96H232v24z"],
    "input-numeric": [640, 512, [], "e1bd", "M576 128V384H64V128H576zM64 64H0v64V384v64H64 576h64V384 128 64H576 64zm40 96v48h24 8v96H120 96v48h24 80 24V304H200 184V184 160H160 128 104zm221.4 51.8c5.9 6.7 5.7 16.7-.3 23.3L256 309.9V352h16 88 24V304H360 326.8l33.6-36.4c22.7-24.6 23.2-62.3 1.2-87.4c-26.2-30-73-29.7-98.9 .5l-16.9 19.7 36.4 31.2 16.9-19.7c6.9-8.1 19.3-8.1 26.3-.1z"],
    "truck-tow": [640, 512, [], "e2b8", "M64 16V0h96L384 252V128 96h32 96 13.3l9.4 9.4 96 96 9.4 9.4V224v32 32V416H576c0 53-43 96-96 96s-96-43-96-96H256c0 53-43 96-96 96s-96-43-96-96H0V256H192L96 64V176c0 26.5-21.5 48-48 48s-48-21.5-48-48V160 144H32v16 16c0 8.8 7.2 16 16 16s16-7.2 16-16V32 16zM576 256V237.3L498.7 160H448v96H576zM208 416a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm272 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "backward-step": [320, 512, ["step-backward"], "f048", "M64 96V64H0V96 416v32H64V416 256L320 448V64L64 256V96z"],
    "pallet": [640, 512, [], "f482", "M32 320H0v64H32 64v64H32 0v64H32 64 96h32H288h32 32H512h32 32 32 32V448H608 576V384h32 32V320H608 576 544 512 352 320 288 128 96 64 32zm96 64H288v64H128V384zm224 0H512v64H352V384z"],
    "car-bolt": [512, 512, [], "e341", "M120 32H97.3L89.8 53.4 41.3 192H0V400v80H96V400H416v80h96V400 192H470.7L422.2 53.4 414.7 32H392 120zM64 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM160 224L288 96l-24 96h88L224 320l24-96H160z"],
    "arrows-maximize": [512, 512, ["expand-arrows"], "f31d", "M320 32H288V96h32 50.7L256 210.7 141.3 96H192h32V32H192 64 32V64 192v32H96V192 141.3L210.7 256 96 370.7V320 288H32v32V448v32H64 192h32V416H192 141.3L256 301.3 370.7 416H320 288v64h32H448h32V448 320 288H416v32 50.7L301.3 256 416 141.3V192v32h64V192 64 32H448 320z"],
    "faucet": [512, 512, [], "e005", "M192 64v44.8L64 96v64l128-12.8 31.2-3.1 .8-.1h0 0l.8 .1 31.2 3.1L384 160V96L256 108.8V64H192zM160 224l-32 32H0V384H132.1c20.2 29 53.9 48 91.9 48s71.7-19 91.9-48H352c17.7 0 32 14.3 32 32v32H512V416c0-88.4-71.6-160-160-160H320l-32-32H256V179.4l-32-3.2-32 3.2V224H160z"],
    "cloud-sleet": [512, 512, [], "f741", "M96 320H0V224c0-41.8 26.7-77.4 64-90.5V112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H416 96zm24 32L48 512H0L72 352h48zm256 0L304 512H256l72-160h48zm-160 0v24 16h16 24v48H232 216v16 24H168V456 440H152 128V392h24 16V376 352h48zm256 0v24 16h16 24v48H488 472v16 24H424V456 440H408 384V392h24 16V376 352h48z"],
    "lamp-street": [512, 512, [], "e1c5", "M64 176c0-61.9 50.1-112 112-112c57.4 0 104.7 43.2 111.2 98.8C196.8 178.3 128 257.1 128 352H512c0-95.3-69.4-174.4-160.5-189.4C344.6 71.6 268.7 0 176 0C78.8 0 0 78.8 0 176V512H64V176zM320 448c35.3 0 64-28.7 64-64H256c0 35.3 28.7 64 64 64z"],
    "list-radio": [512, 512, [], "e1d0", "M64 160A64 64 0 1 0 64 32a64 64 0 1 0 0 128zM192 64H160v64h32H480h32V64H480 192zm0 160H160v64h32H480h32V224H480 192zm0 160H160v64h32H480h32V384H480 192zM40 416a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88 0A64 64 0 1 0 0 416a64 64 0 1 0 128 0zM64 232a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 88a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"],
    "pen-nib-slash": [640, 512, [], "e4a1", "M212.8 142.4L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L446.7 324 480 224l.7-.7-128-128L352 96 212.8 142.4zM64 448l20.7 20.7 144-144c-3-6.3-4.7-13.3-4.7-20.7c0-9.4 2.7-18.2 7.4-25.7l-87.8-69.2L64 448zm345.1-29.7L306.4 337.4c-8.7 9-20.9 14.6-34.4 14.6c-7.4 0-14.4-1.7-20.7-4.7l-144 144L128 512l281.1-93.7zM375.3 72.7l128 128L576 128 448 0 375.3 72.7z"],
    "baseball-bat-ball": [512, 512, [], "f432", "M408.9 7.1l-5.7-5.7-5.7 5.7L233.5 171.2c-10.5 10.5-19.8 22.1-27.7 34.6L132.7 321.6c-7.3 11.5-15.8 22.2-25.5 31.9L69.9 390.7l51.3 51.3 37.3-37.3c9.6-9.6 20.3-18.2 31.9-25.5l115.8-73.1c12.5-7.9 24.1-17.2 34.6-27.7L504.9 114.5l5.7-5.7-5.7-5.7-96-96zM512 432a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM33.9 384L0 417.9l17 17 60.2 60.2 17 17L128 478.1l-17-17L50.9 401l-17-17z"],
    "square-up-left": [448, 512, [], "e282", "M448 32H0V480H448V32zM128 320V160H288l24 24-52 52 76 76-56 56-76-76-52 52-24-24z"],
    "overline": [448, 512, [], "f876", "M32 32H0V96H32 416h32V32H416 32zm192 96a176 176 0 1 0 0 352 176 176 0 1 0 0-352zM336 304a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z"],
    "s": [320, 512, [115], "53", "M99.1 105.4C79 114 68.2 127.2 65.2 144.8c-2.4 14.1-.7 23.2 2 29.4c2.8 6.3 7.9 12.4 16.7 18.6c19.2 13.4 48.3 22.1 84.9 32.5c1 .3 1.9 .6 2.9 .8c32.7 9.3 72 20.6 100.9 40.7c15.7 10.9 29.9 25.5 38.6 45.1c8.8 19.8 10.8 42 6.6 66.3c-7.3 42.5-35.3 71.7-71.8 87.3c-35.4 15.2-79.1 17.9-123.7 10.9l-.2 0 0 0c-24-3.9-62.7-17.1-87.6-25.6c-4.8-1.7-9.2-3.1-12.8-4.3L-8.5 436.3l20.2-60.7 30.4 10.1c4.9 1.6 10.2 3.4 15.9 5.4c25.4 8.6 56.4 19.2 74.4 22.1c36.8 5.7 67.5 2.5 88.5-6.5c20.1-8.6 30.8-21.8 33.9-39.4c2.4-14.1 .7-23.2-2-29.4c-2.8-6.3-7.9-12.4-16.7-18.6c-19.2-13.4-48.3-22.1-84.9-32.5c-1-.3-1.9-.6-2.9-.8c-32.7-9.3-72-20.6-100.9-40.7c-15.7-10.9-29.9-25.5-38.6-45.1c-8.8-19.8-10.8-42-6.6-66.3l31.5 5.5L2.1 133.9C9.4 91.4 37.4 62.2 73.9 46.6c35.4-15.2 79.1-17.9 123.7-10.9c13 2 52.4 9.6 66.6 13.4l30.9 8.2-16.5 61.8-30.9-8.2c-11.2-3-48.1-10.2-60.1-12l4.9-31.5-4.9 31.5c-36.9-5.8-67.5-2.5-88.6 6.5z"],
    "timeline": [640, 512, [], "e29c", "M152 72v48H104V72h48zM104 16H48V72v48 56H96v48H32 0v64H32 288v48H240v56 48 56h56 48 56V440 392 336H352V288H608h32V224H608 544V176h48V120 72 16H536 488 432V72v48 56h48v48H160V176h48V120 72 16H152 104zM488 72h48v48H488V72zM344 392v48H296V392h48z"],
    "keyboard": [576, 512, [9000], "f11c", "M576 64H0V448H576V64zM128 128v64H64V128h64zM64 224h64v64H64V224zm64 96v64H64V320h64zm32-192h64v64H160V128zm64 96v64H160V224h64zm-64 96H416v64H160V320zM320 128v64H256V128h64zm-64 96h64v64H256V224zm160-96v64H352V128h64zm-64 96h64v64H352V224zm160-96v64H448V128h64zm-64 96h64v64H448V224zm64 96v64H448V320h64z"],
    "arrows-from-dotted-line": [448, 512, [], "e0a3", "M128 96L224 0l96 96v32H256v32 32H192V160 128H128V96zM256 352v16 16h64v32l-96 96-96-96V384h64V368 352 320h64v32zM64 224v64H0V224H64zm32 0h64v64H96V224zm160 0v64H192V224h64zm32 0h64v64H288V224zm96 0h64v64H384V224z"],
    "usb-drive": [640, 512, [], "f8e9", "M448 96H0V416H448V96zm192 32H480V384H640V128zm-56 56v48H536V184h48zm-48 96h48v48H536V280z"],
    "ballot": [448, 512, [], "f732", "M448 0H0V512H448V0zM64 96h64v64H64V96zm0 128h64v64H64V224zm64 128v64H64V352h64zm64 16h16H368h16v32H368 208 192V368zm16-256H368h16v32H368 208 192V112h16zM192 240h16H368h16v32H368 208 192V240z"],
    "caret-down": [320, 512, [], "f0d7", "M320 240L160 384 0 240l0-48 320 0 0 48z"],
    "location-dot-slash": [640, 512, ["map-marker-alt-slash"], "f605", "M457.5 332.4C488.3 282.6 512 231.4 512 192C512 86 426 0 320 0C248.8 0 186.6 38.8 153.5 96.4L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L457.5 332.4zM257.7 177.3c6.6-28.3 32-49.3 62.3-49.3c35.3 0 64 28.7 64 64c0 24.6-13.9 46-34.3 56.7l-92-71.4zM402.1 412.8l-274-215.8C133.5 310 320 512 320 512s39.1-42.4 82.1-99.2z"],
    "cards": [640, 512, [], "e3ed", "M210.9 512l254-146.7L254 0 0 146.7 210.9 512zm12.9-345.2l76.1 20.4c26 7 41.4 33.7 34.4 59.7s-33.7 41.4-59.7 34.4l-10-2.7 17.7 30.7 12.1-7 12.1-7 13.9 24.1-12.1 7-12.1 7-24.1 13.9-12.1 7-12.1 7-13.9-24.1 12.1-7 12.1-7-17.8-30.7-2.7 10c-7 26-33.7 41.4-59.7 34.4s-41.4-33.7-34.4-59.7l20.4-76.1 12.6-47.1 47.1 12.6zM320 512H640V64H327.9L492.7 349.4l16 27.7-27.7 16L320 486v26zM476.4 135.7c13.5-11.7 34.2-9.5 46.7 3.2l5 5.2 4.7-5.2c12.5-12.7 33-15 46.9-3.2c15.5 13.5 16.2 37.5 2.2 51.9l-54 55.8-54.1-55.8c-14-14.5-13.2-38.5 2.5-51.9z"],
    "house-chimney-medical": [576, 512, ["clinic-medical"], "f7f2", "M576 287.6H511.8l1 224.4H64.1V287.6H0V240L288.4 0 416 106.5V32h96V186.6L576 240v47.6zM320 192H256v64H192v64h64v64h64V320h64V256H320V192z"],
    "boxing-glove": [448, 512, [129354, "glove-boxing"], "f438", "M0 0H384V128H288 272v16 16H117.3L89.6 139.2l-12.8-9.6L57.6 155.2l12.8 9.6 32 24 4.3 3.2H112 272v80 16h16 48 16V256H336 304V192 160h80 48 16V288l-96 96V512H32V384L0 352V0zM152.9 354.7l-13.3-8.9-17.8 26.6 13.3 8.9 28 18.7-28 18.7-13.3 8.9 17.8 26.6 13.3-8.9L192 419.2l39.1 26.1 13.3 8.9 17.8-26.6-13.3-8.9-28-18.7 28-18.7 13.3-8.9-17.8-26.6-13.3 8.9L192 380.8l-39.1-26.1z"],
    "temperature-three-quarters": [320, 512, ["temperature-3", "thermometer-3", "thermometer-three-quarters"], "f2c8", "M112 300.2L97.8 317.8C86.6 331.5 80 348.9 80 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-19.1-6.6-36.5-17.8-50.3L208 300.2V277.5 64H112V277.5v22.7zM208 0h64V64 277.5c20 24.7 32 56.2 32 90.5c0 79.5-64.5 144-144 144S16 447.6 16 368c0-34.3 12-65.8 32-90.5V64 0h64 96zm0 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V144 128h32v16V322.8c18.6 6.6 32 24.4 32 45.3z"],
    "bell-school": [512, 512, [], "f5d5", "M208 128a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 288A208 208 0 1 0 208 0a208 208 0 1 0 0 416zm48-208a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM208 448c-54 0-103.9-17.9-144-48V512H320h32H464h24V488 441.6c14.3-8.3 24-23.8 24-41.6c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 17.8 9.7 33.3 24 41.6V464H352V400c-40.1 30.1-90 48-144 48z"],
    "mobile-screen": [384, 512, ["mobile-android-alt"], "f3cf", "M16 0H368V512H16V0zM144 432v32h16 64 16V432H224 160 144zM304 64H80V384H304V64z"],
    "plane-up": [512, 512, [], "e22d", "M192 93.7C192 59.5 221 0 256 0c36 0 64 59.5 64 93.7l0 66.3L512 288v96L320 320v80l64 48v64L256 480 128 512V448l64-48V320L0 384V288L192 160V93.7z"],
    "folder-heart": [512, 512, [], "e189", "M512 96V480H0V32H224l48 64H512zM144 251.2c0 16.1 6.6 31.5 18.2 42.7l82.8 79.6L256 384.1l11.1-10.7 82.8-79.6c11.6-11.2 18.2-26.6 18.2-42.7c0-32.7-26.5-59.2-59.2-59.2h-2.4c-15.9 0-31.2 6.2-42.7 17.2l-7.7 7.4-7.7-7.4c-11.5-11-26.8-17.2-42.7-17.2h-2.4c-32.7 0-59.2 26.5-59.2 59.2z"],
    "circle-location-arrow": [512, 512, ["location-circle"], "f602", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM233.4 278.6L86.3 244.7 369.1 142.9 267.3 425.7 233.4 278.6z"],
    "face-head-bandage": [576, 512, [], "e37a", "M288 0C213.6 0 146.6 31.8 99.8 82.4c-12.5 2.5-25 5.2-37.3 8.2l-12.4 3c-2.3 3.3-4.5 6.7-6.6 10.1l-.8 1.2C26.9 130.6 15 158.9 7.8 189l-.4 1.8c-3.8 16.4-6.2 33.3-7 50.6l0 0c-.1 1.3-.1 2.6-.2 3.8l0 .5c-.1 3.1-.2 6.2-.2 9.3l0 .9 0 .5 0 .7c.1 31 5.1 60.9 14.4 88.9l.7 2.1c6.3 18.7 14.5 36.5 24.2 53.2l20.2-29.9C101.7 454.9 188.2 512 288 512c141.4 0 256-114.6 256-256c0-8.2-.4-16.4-1.1-24.4l32.8 9.9c-.9-17.2-3.2-34.1-7-50.4l-.5-2.1c-5.2-21.6-12.8-42.3-22.5-61.8l0 0c-4.1-8.1-8.5-16-13.3-23.7c-2-3.1-4-6.2-6-9.3c-4.1-6-8.4-11.8-12.9-17.5l-.6-.7c-21.2-26.5-47-49.1-76.2-66.8l-1.5-.9c-2.8-1.6-5.5-3.2-8.4-4.8L416.2 4.9c-16.2 2-32.2 4.6-48.1 7.9C342.9 4.5 316 0 288 0zm12.6 64.1c38.3-13 78.3-22.3 119.5-27.4c13.7 8.3 26.6 17.9 38.5 28.5c6.1 5.5 11.9 11.2 17.5 17.2C419.3 71.1 360.6 64.9 300.6 64.1zm15.6 96.4s0 0 0 0c-9.4-.3-18.8-.5-28.2-.5c-17.1 0-34.1 .5-51 1.5c0 0 0 0 0 0c-47.8 2.8-94.6 9.4-140 19.7c0 0 0 0 0 0c-19.6 4.4-39 9.5-58.1 15.3c0-.2 .1-.4 .1-.6c.4-1.8 .9-3.6 1.4-5.4c2.8-10.5 6.2-20.8 10.2-30.7c5.4-13.3 11.8-26 19.3-38C139.9 104.9 212.9 96 288 96s148.1 8.9 218 25.8c7.4 12 13.9 24.8 19.3 38c4.8 11.8 8.7 24.1 11.7 36.7c-11.9-3.6-23.9-6.9-36-10c-59.4-15.1-121.2-24-184.8-26zM176.4 240c13.5-10.8 27.6-20.9 42.1-30.4c12.7 4.2 21.9 16.2 21.9 30.4c0 17.7-14.3 32-32 32s-32-14.3-32-32zm-126-13.6c41-12.2 83.3-21.3 126.6-27.1c-40.6 29.4-77 64.4-108 103.7c-8.5 10.7-16.5 21.7-24.2 33.1c-4.4-13.3-7.7-27.1-9.9-41.3C33 282.1 32 269.2 32 256c0-3 .1-6.1 .2-9.1c5.9-7 12-13.8 18.2-20.5zM373.2 397.5C356.4 382.2 330.8 368 296 368c-13.1 0-24.8 2-35.2 5.3l-15.3 4.8-9.6-30.5 15.3-4.8c13.4-4.2 28.4-6.8 44.8-6.8c44.2 0 77.2 18.3 98.8 37.9l11.8 10.8-21.5 23.7-11.8-10.8zM368.4 208a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "sushi-roll": [448, 512, ["maki-roll", "makizushi"], "e48b", "M448 368V144C448 82.1 347.7 32 224 32S0 82.1 0 144V368s48 112 224 112s224-112 224-112zM209.4 80.3l8.4 18.3-75.3 26.5-3.9 1.4-3 2.8L85.2 175.9C71.7 166.5 64 155.6 64 144c0-33.4 63.9-60.8 145.4-63.7zm-49.8 81.2l74.9-26.4 8.9 19.4 3.4 7.5 7.7 2.9 73.7 27.6c-28 9.6-64.5 15.5-104.3 15.5c-37.6 0-72.2-5.2-99.5-13.9l35.2-32.6zm94.1-80.4C327.9 86.7 384 112.7 384 144c0 8-3.7 15.7-10.4 22.8l-97.2-36.4L253.8 81.1z"],
    "car-bump": [640, 512, [], "f5e0", "M65.1 75.8l21.1-5.7L318.1 8l21.1-5.7L352.2 20 430.6 127l40.7-10.9L521 301.5l20.7 77.3-92.7 24.8-20.7-77.3L150 400.9l20.7 77.3L78 503 57.3 425.8 7.6 240.3l40.7-10.9L62.7 97.6l2.4-21.8zm248.4-.3L124 126.3l-9.3 85.3 249.6-66.9L313.5 75.5zm-180 263.6a32 32 0 1 0 -16.6-61.8 32 32 0 1 0 16.6 61.8zM434.3 225.4a32 32 0 1 0 -61.8 16.6 32 32 0 1 0 61.8-16.6zM510.9 416c56.4 0 103.1 41.7 110.9 96H400c7.8-54.3 54.4-96 110.9-96z"],
    "piggy-bank": [576, 512, [], "f4d3", "M400 96l0 .7c-5.3-.4-10.6-.7-16-.7H256c-16.5 0-32.5 2.1-47.8 6c-.1-2-.2-4-.2-6c0-53 43-96 96-96s96 43 96 96zm-16 32c3.5 0 7 .1 10.4 .3c4.2 .3 8.4 .7 12.6 1.3C424.6 109.1 450.8 96 480 96h32l-18.8 75.1c15.8 14.8 28.7 32.8 37.5 52.9H576V384H512c-9.1 12.1-19.9 22.9-32 32v96H384V448H256v64H160V416c-34.9-26.2-58.7-66.3-63.2-112H68c-37.6 0-68-30.4-68-68s30.4-68 68-68H80v48H68c-11 0-20 9-20 20s9 20 20 20H99.2c12.1-59.8 57.7-107.5 116.3-122.8c12.9-3.4 26.5-5.2 40.5-5.2H384zm64 136a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "racquet": [512, 512, [], "f45a", "M349 64c-36 0-76.4 15.8-108.8 48.2S192 184.9 192 221c0 28.2 9.6 53.2 27.7 71.3c40.4 40.4 120.7 38.9 180.1-20.5C432.2 239.4 448 199.1 448 163c0-28.2-9.6-53.2-27.7-71.3S377.1 64 349 64zm-154 2.9C238.5 23.4 294.8 0 349 0c42.8 0 84.9 14.8 116.6 46.5S512 120.2 512 163c0 54.2-23.4 110.5-66.9 154c-68.2 68.2-172.3 88.9-245.7 40.8l-48.8 48.8L160 416 64 512 0 448l96-96 9.4 9.4 48.8-48.8C136.4 285.2 128 253.3 128 221c0-54.2 23.4-110.5 66.9-154z"],
    "car-mirrors": [576, 512, [], "e343", "M152 32H129.3l-7.5 21.4L84.5 160H0v64H32V400v80h96V400H448v80h96V400 224h32V160H491.5L454.2 53.4 446.7 32H424 152zM434.9 192H141.1l33.6-96H401.3l33.6 96zM96 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "industry-windows": [576, 512, [127981, "industry-alt"], "f3b3", "M32 32H160V224l192-96v96l192-96v96V480H32V384 224 32zM328 312H248v80h80V312zm-128 0H120v80h80V312zm256 0H376v80h80V312z"],
    "bolt-auto": [576, 512, [], "e0b6", "M304 0L0 288l162.2 23.2L112 512 416 224 253.8 200.8 304 0zM506.4 512H576L480 288H416L320 512h69.6l13.7-32h89.3l13.7 32zM448 375.8L465.2 416H430.8L448 375.8z"],
    "battery-half": [576, 512, ["battery-3"], "f242", "M480 160V352H64V160H480zM64 96H0v64V352v64H64 480h64V352 320h32V192H544V160 96H480 64zm224 96H96V320H288V192z"],
    "flux-capacitor": [448, 512, [], "f8ba", "M0 32H448V480H0V32zM148.7 237.3l-49-49L71.4 160 128 103.4l28.3 28.3 49 49c1.8-6.6 2.7-13.6 2.7-20.7c0-44.2-35.8-80-80-80s-80 35.8-80 80s35.8 80 80 80c7.2 0 14.1-.9 20.7-2.7zM184 282.7c-23.9 13.8-40 39.7-40 69.3c0 44.2 35.8 80 80 80s80-35.8 80-80c0-29.6-16.1-55.5-40-69.3V352v40H184V352 282.7zm115.3-45.4c6.6 1.8 13.6 2.7 20.7 2.7c44.2 0 80-35.8 80-80s-35.8-80-80-80s-80 35.8-80 80c0 7.2 .9 14.1 2.7 20.7l49-49L320 103.4 376.6 160l-28.3 28.3-49 49zm-160-88.6L128 137.4 105.4 160l11.3 11.3L208 262.6V352v16h32V352 262.6l91.3-91.3L342.6 160 320 137.4l-11.3 11.3L224 233.4l-84.7-84.7z"],
    "mountain-city": [640, 512, [], "e52e", "M288 0V144.4L357.7 256H416v64H397.7L507.1 495l10.6 17H640V192H568V120 96H520v24 72H480V0H288zm64 64h64v64H352V64zm64 96v64H352V160h64zm160 96v64H512V256h64zm-64 96h64v64H512V352zM480 512l-30-48L268.3 173.3 240 128l-28.3 45.3L30 464 0 512H56.6 423.4 480zM240 218.6L303.4 320H240l-48 64-30.2-40.3L240 218.6z"],
    "coins": [512, 512, [], "f51e", "M512 80c0 18-14.3 34.6-38.4 48c-29.1 16.1-72.5 27.5-122.3 30.9c-3.7-1.8-7.4-3.5-11.3-5C300.6 137.4 248.2 128 192 128c-8.3 0-16.4 .2-24.5 .6l-1.1-.6C142.3 114.6 128 98 128 80c0-44.2 86-80 192-80S512 35.8 512 80zM160.7 161.1c10.2-.7 20.7-1.1 31.3-1.1c62.2 0 117.4 12.3 152.5 31.4C369.3 204.9 384 221.7 384 240c0 4-.7 7.9-2.1 11.7c-4.6 13.2-17 25.3-35 35.5c0 0 0 0 0 0c-.1 .1-.3 .1-.4 .2l0 0 0 0c-.3 .2-.6 .3-.9 .5c-35 19.4-90.8 32-153.6 32c-59.6 0-112.9-11.3-148.2-29.1c-1.9-.9-3.7-1.9-5.5-2.9C14.3 274.6 0 258 0 240c0-34.8 53.4-64.5 128-75.4c10.5-1.5 21.4-2.7 32.7-3.5zM416 240c0-21.9-10.6-39.9-24.1-53.4c28.3-4.4 54.2-11.4 76.2-20.5c16.3-6.8 31.5-15.2 43.9-25.5V176c0 19.3-16.5 37.1-43.8 50.9c-14.6 7.4-32.4 13.7-52.4 18.5c.1-1.8 .2-3.5 .2-5.3zm-32 96c0 18-14.3 34.6-38.4 48c-1.8 1-3.6 1.9-5.5 2.9C304.9 404.7 251.6 416 192 416c-62.8 0-118.6-12.6-153.6-32C14.3 370.6 0 354 0 336V300.6c12.5 10.3 27.6 18.7 43.9 25.5C83.4 342.6 135.8 352 192 352s108.6-9.4 148.1-25.9c7.8-3.2 15.3-6.9 22.4-10.9c6.1-3.4 11.8-7.2 17.2-11.2c1.5-1.1 2.9-2.3 4.3-3.4V304v5.7V336zm32 0V304 278.1c19-4.2 36.5-9.5 52.1-16c16.3-6.8 31.5-15.2 43.9-25.5V272c0 10.5-5 21-14.9 30.9c-16.3 16.3-45 29.7-81.3 38.4c.1-1.7 .2-3.5 .2-5.3zM192 448c56.2 0 108.6-9.4 148.1-25.9c16.3-6.8 31.5-15.2 43.9-25.5V432c0 44.2-86 80-192 80S0 476.2 0 432V396.6c12.5 10.3 27.6 18.7 43.9 25.5C83.4 438.6 135.8 448 192 448z"],
    "honey-pot": [448, 512, [127855], "e418", "M128 32H64 32V96H64C25.1 125.2 0 171.7 0 224C0 400 128 480 128 480H320s128-80 128-256c0-52.3-25.1-98.8-64-128h32V32H384 176V136v24H128V136 32zM96.9 352C78.7 320.3 64 278.1 64 224H384c0 54.1-14.7 96.3-32.9 128H96.9z"],
    "olive": [448, 512, [], "e316", "M160 480C71.6 480 0 408.4 0 320C0 128 181.9 32 280 32c56 0 112 56 112 56s56 56 56 112c0 98.1-96 280-288 280zM287.1 192.9c30.3 30.3 87.8 21.9 87.8 21.9s8.4-57.5-21.9-87.8s-87.8-21.9-87.8-21.9s-8.4 57.5 21.9 87.8z"],
    "khanda": [512, 512, [9772], "f66d", "M192 48L256 0l64 48s-6.6 10.6-14.5 27.5C342.5 93.8 368 131.9 368 176s-25.5 82.2-62.5 100.5C313.4 293.4 320 304 320 304l-48 36v22.6l34.5-23.7 .1-.1C363.8 299.5 416 256 416 180.6c0-47.6-14.7-106.7-32-132.6c0 0 128 54.5 128 176c0 96-112 192-112 192l-83.4-45.3L284.2 393l46.1 31.7c1.8-.4 3.7-.7 5.7-.7c13.3 0 24 10.7 24 24s-10.7 24-24 24c-12.2 0-22.3-9.1-23.8-21L272 423.4v28.9c9.6 5.5 16 15.9 16 27.7c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-11.8 6.4-22.2 16-27.7V423.4L199.8 451c-1.5 11.8-11.6 21-23.8 21c-13.3 0-24-10.7-24-24s10.7-24 24-24c2 0 3.9 .2 5.7 .7L227.8 393l-32.4-22.3L112 416s-112-96-112-192C0 102.5 128 48 128 48c-17.3 25.9-32 85.1-32 132.6c0 75.4 52.2 118.9 109.4 158.2l.1 .1L240 362.6V340l-48-36s6.6-10.6 14.5-27.5C169.5 258.2 144 220.1 144 176s25.5-82.2 62.5-100.5C198.6 58.6 192 48 192 48zm0 128c0 23.5 12.7 44.1 31.6 55.2c4.9-17.3 8.4-36.2 8.4-55.2s-3.5-37.9-8.4-55.2C204.7 131.9 192 152.5 192 176zm88 0c0 18.9 3.5 37.9 8.4 55.2C307.3 220.1 320 199.5 320 176s-12.7-44.1-31.6-55.2c-4.9 17.3-8.4 36.2-8.4 55.2z"],
    "filter-list": [512, 512, [], "e17c", "M112 256V384l128 96V256L352 128V64H0v64L112 256zM352 384H320v64h32H480h32V384H480 352zM320 224v64h32H480h32V224H480 352 320zM416 64H384v64h32 64 32V64H480 416z"],
    "outlet": [448, 512, [], "e01c", "M448 32H0V480H448V32zM64 256c0-88 64-128 64-128H320s64 40 64 128s-64 128-64 128H128s-64-40-64-128zm112-64H144v16 48 16h32V256 208 192zm128 0H272v16 48 16h32V256 208 192zm-80 96c-13.3 0-24 10.7-24 24v24h48V312c0-13.3-10.7-24-24-24z"],
    "sliders": [512, 512, ["sliders-h"], "f1de", "M0 384l0 64 32 0 32 0 0 48 48 0 64 0 48 0 0-48 256 0 32 0 0-64-32 0-256 0 0-48-48 0-64 0-48 0 0 48-32 0L0 384zM0 224l0 64 32 0 256 0 0 48 48 0 64 0 48 0 0-48 32 0 32 0 0-64-32 0-32 0 0-48-48 0-64 0-48 0 0 48L32 224 0 224zM32 64L0 64l0 64 32 0 64 0 0 48 48 0 64 0 48 0 0-48 224 0 32 0 0-64-32 0L256 64l0-48-48 0-64 0L96 16l0 48L32 64zm80 384l0-64 64 0 0 64-64 0zM336 224l64 0 0 64-64 0 0-64zM144 128l0-64 64 0 0 64-64 0z"],
    "cauldron": [448, 512, [], "f6bf", "M160 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm112 64a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM35.1 224C16.5 257 0 297.1 0 334.4c0 37.4 11.9 69.4 32 95.5V512H80V473c40.4 25.5 91.8 39 144 39s103.6-13.5 144-39v39h48V429.9c20.1-26.1 32-58.1 32-95.5c0-37.3-16.5-77.4-35.1-110.4H448V160H368 224 80 0v64H35.1z"],
    "people": [640, 512, [], "e216", "M160 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H91.4L82 142.8 .2 270.8l53.9 34.4 33.8-53V480v32h64V480 352h16V480v32h64V480 252.2l33.8 53 53.9-34.4L238 142.8 228.6 128H211.1 108.9zM480 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H411.4l-9.4 14.8-81.7 128 53.9 34.4 42-65.8L368 384h40v96 32h64V480 384h16v96 32h64V480 384h40L543.8 239.4l42 65.8 53.9-34.4L558 142.8 548.6 128H531.1 428.9z"],
    "folder-tree": [576, 512, [], "f802", "M64 32V0H0V32v96V416v32H32 256V384H64V160H256V96H64V32zM288 224H576V32H432L400 0H288V224zm0 288H576V320H432l-32-32H288V512z"],
    "network-wired": [640, 512, [], "f6ff", "M384 64v64H352 288 256V64H384zM352 192h32 64V128 64 0H384 256 192V64v64 64h64 32v32H192 128 32 0v64H32h96v32H96 32v64 64 64H96 224h64V448 384 320H224 192V288h96 64 96v32H416 352v64 64 64h64H544h64V448 384 320H544 512V288h96 32V224H608 512 448 352V192zM512 384h32v64H416V384h32 64zm-320 0h32v64H96V384h32 64z"],
    "croissant": [512, 512, [129360], "f7f6", "M6.3 227.9l231.9 98.9L60.7 464.8C22.6 416 0 354.7 0 288c0-20.6 2.2-40.7 6.3-60.1zm320.4 10.3L227.9 6.3C247.3 2.2 267.4 0 288 0c66.7 0 128 22.6 176.8 60.7L326.7 238.2zM468.6 108C487 130 501.8 155.3 512 182.7L480 224l-90-15 78.6-101zM209 390l15 90-41.3 32c-27.4-10.2-52.7-25-74.7-43.4L209 390zM0 190.4C30.2 100.9 100.9 30.3 190.4 0L306.4 272 272 306.4 0 190.4z"],
    "map-pin": [320, 512, [128205], "f276", "M16 144a144 144 0 1 1 288 0A144 144 0 1 1 16 144zM160 80V48c-53 0-96 43-96 96H96c0-35.3 28.7-64 64-64zM128 480V317.1c10.4 1.9 21.1 2.9 32 2.9s21.6-1 32-2.9V480v32H128V480z"],
    "hamsa": [512, 512, [], "f665", "M0 288H96V32h80V224h40V0h80V224h40V32h80V288h96v48L416.6 441c-41.1 45.2-99.4 71-160.6 71s-119.4-25.8-160.6-71L0 336V288zm256 0c-48 0-96 64-96 64s48 64 96 64s96-64 96-64s-48-64-96-64zm0 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "cent-sign": [384, 512, [], "e3f5", "M256 0V32 66.7c49.6 8.3 92.7 35.6 121.6 74.1l-51.2 38.4C303 148.1 265.9 128 224 128c-70.7 0-128 57.3-128 128s57.3 128 128 128c41.9 0 79-20.1 102.4-51.2l51.2 38.4c-28.9 38.5-72 65.8-121.6 74.1V480v32H192V480 445.3C101.2 430.1 32 351.1 32 256s69.2-174.1 160-189.3V32 0h64z"],
    "swords-laser": [640, 512, [], "e03d", "M352 279.6V173.7L160 0 128 32 352 279.6zM621.7 450.3L640 432l-98.3-98.3L523.3 352l98.3 98.3zm-11.3 11.3L512 363.3 491.3 384l98.3 98.3 20.7-20.7zm-32 32L480 395.3l-18.3 18.3L560 512l18.3-18.3zm-128-91.3l24-24 32-32 24-24L384 176V336l66.3 66.3zM247 210.8l-27.4 24.8L208 224l-33.4 33.4-8.2-8.2c-12.5-12.3-32.6-12.2-45 .2c-12.5 12.5-12.5 32.8 0 45.3l8 8L0 432l80 80L224 368V350.3l74.9-82.8L247 210.8zm143.5-44.5L512 32 480 0 343.6 123.4l46.9 42.9zM152 344a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "flask": [448, 512, [], "f0c3", "M288 0H160 128 96V64h32V214.9L4.7 415.2 0 422.9V432v48 32H32 416h32V480 432v-9.1l-4.7-7.7L320 214.9V64h32V0H320 288zM192 224V64h64V224v9.1l4.7 7.7L309.5 320h-171l48.8-79.2 4.7-7.7V224z"],
    "person-pregnant": [384, 512, [], "e31e", "M192 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM120 384H96V296.9l-4.6 7.6L74.9 331.9l-54.9-33 16.5-27.4 76.9-128 9.3-15.5h18.1H176h16 32 32l18.3 97.7c44.3 8.6 77.7 47.5 77.7 94.3v64H304 264v96 32H200V480 384h-8-8v96 32H120V480 384z"],
    "square-u": [448, 512, [], "e281", "M448 32H0V480H448V32zM160 168V288c0 35.3 28.7 64 64 64s64-28.7 64-64V168 144h48v24V288c0 61.9-50.1 112-112 112s-112-50.1-112-112V168 144h48v24z"],
    "wand-sparkles": [512, 512, [], "f72b", "M0 432l80 80L368 192h48V138.7L512 32 480 0 195.6 256H128v60.8L0 432zm432 16l24-56 56-24-56-24-24-56-24 56-56 24 56 24 24 56zM56 168l24 56 24-56 56-24-56-24L80 64 56 120 0 144l56 24zM208 96l16-32 32-16L224 32 208 0 192 32 160 48l32 16 16 32z"],
    "router": [576, 512, [], "f8da", "M352 48c58.8 0 112.5 21.8 153.4 57.9l31.7-36C487.8 26.4 422.9 0 352 0S216.2 26.4 166.9 69.9l31.7 36C239.5 69.8 293.2 48 352 48zm24 200V224H328v24 72H0V512H576V320H376V248zM128 384v64H64V384h64zm32 0h64v64H160V384zM276.5 186.7C297.1 170 323.4 160 352 160s54.9 10 75.5 26.7l30.2-37.3C428.8 126 392 112 352 112s-76.8 14-105.7 37.4l30.2 37.3z"],
    "ellipsis-vertical": [128, 512, ["ellipsis-v"], "f142", "M16 48h96v96H16V48zm0 160h96v96H16V208zm96 160v96H16V368h96z"],
    "sword-laser-alt": [512, 512, [], "e03c", "M480 0L232.4 224H338.3L512 32 480 0zM80 512l98.3-98.3L160 395.3 61.7 493.7 80 512zm68.7-128L128 363.3 29.7 461.7l20.7 20.7L148.7 384zM0 432l18.3 18.3L116.7 352 98.3 333.7 0 432zm133.7-85.7l32 32 24 24L336 256H176l-66.3 66.3 24 24z"],
    "ticket": [576, 512, [127903], "f145", "M576 64H0V208c26.5 0 48 21.5 48 48s-21.5 48-48 48V448H576V304c-26.5 0-48-21.5-48-48s21.5-48 48-48V64zM128 160V352H448V160H128zM96 128h32H448h32v32V352v32H448 128 96V352 160 128z"],
    "power-off": [512, 512, [9211], "f011", "M288 32V0H224V32 256v32h64V256 32zM80 256c0-54.4 24.7-103.1 63.5-135.4L102.6 71.4C49.7 115.4 16 181.8 16 256c0 132.5 107.5 240 240 240s240-107.5 240-240c0-74.2-33.8-140.6-86.6-184.6l-40.9 49.2c38.9 32.3 63.5 81 63.5 135.4c0 97.2-78.8 176-176 176s-176-78.8-176-176z"],
    "coin": [512, 512, [129689], "f85c", "M256 352C114.6 352 0 287.5 0 208S114.6 64 256 64s256 64.5 256 144s-114.6 144-256 144zM86.6 248.2c12 11.4 27.7 20.1 44.4 26.8c33.6 13.4 77.8 21 125 21s91.4-7.6 125-21c16.7-6.7 32.4-15.4 44.4-26.8C437.5 236.7 448 220.5 448 200s-10.5-36.7-22.6-48.2c-12-11.4-27.7-20.1-44.4-26.8c-33.6-13.4-77.8-21-125-21s-91.4 7.6-125 21c-16.7 6.7-32.4 15.4-44.4 26.8C74.5 163.3 64 179.5 64 200s10.5 36.7 22.6 48.2zM96 200c0-35.3 71.6-64 160-64s160 28.7 160 64s-71.6 64-160 64s-160-28.7-160-64zM0 290.1c13.2 15.6 29.7 29.3 48 40.9l0 63.7C17.8 373.6 0 347.9 0 320l0-29.9zM80 413l0-64.7c28.4 13.2 60.9 23 96 29l0 64.3c-36.2-6-68.9-15.9-96-28.7zm128 32.8l0-64.1c15.7 1.6 31.7 2.4 48 2.4s32.3-.8 48-2.4l0 64.1c-15.5 1.5-31.6 2.2-48 2.2s-32.5-.8-48-2.2zm128-4.1l0-64.3c35.1-6 67.6-15.9 96-29l0 64.7c-27.1 12.8-59.8 22.7-96 28.7zm128-47l0-63.7c18.3-11.5 34.8-25.2 48-40.9l0 29.9c0 27.9-17.8 53.6-48 74.6z"],
    "laptop-slash": [640, 512, [], "e1c7", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7-4.6-3.6L640 432V384H523.9L153 96H512V352h64V64 32H544 96 70.5L48.4 14.8zM128 352V197L64 146.6V352h64zM487.2 480L365.3 384H0v48l48 48H487.2z"],
    "right-long": [512, 512, ["long-arrow-alt-right"], "f30b", "M512 256L352 416l-32 0 0-96L0 320 0 192l320 0 0-96 32 0L512 256z"],
    "circle-b": [512, 512, [], "e0fd", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 128h24 92c42 0 76 34 76 76c0 16.2-5.1 31.3-13.8 43.7C356.3 261.6 368 283.4 368 308c0 42-34 76-76 76H184 160V360 280 256 232 152 128zm144 76c0-15.5-12.5-28-28-28H208v56h68c15.5 0 28-12.5 28-28zM208 336h84c15.5 0 28-12.5 28-28s-12.5-28-28-28H276 208v56z"],
    "person-dress-simple": [256, 512, [], "e21c", "M64 64a64 64 0 1 1 128 0A64 64 0 1 1 64 64zm128 96l64 224H192V512H64V384H0L64 160H192z"],
    "pipe-collar": [512, 512, [], "e437", "M512 256c0 46.4-12.3 89.8-33.9 127.4l33.2 32.1L512 512l-96.6-.7-32.1-33.2C345.8 499.7 302.4 512 256 512c-46.5 0-90.2-12.4-127.8-34.1L95.9 511.3H0V415.4l33.6-32.5C12.2 345.5 0 302.2 0 256c0-46.4 12.3-89.9 33.9-127.4L0 95.9V0H95.9l32.8 33.9C166.1 12.3 209.6 0 256 0c46.2 0 89.5 12.2 126.9 33.6L415.4 0h95.9V95.9l-33.4 32.3C499.6 165.8 512 209.5 512 256zM64 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM256 416a160 160 0 1 0 0-320 160 160 0 1 0 0 320zM80 448a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM448 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 368a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"],
    "lights-holiday": [640, 512, [], "f7b2", "M16 64C.1 91.8 .1 91.8 .1 91.8l0 0 .1 0 .1 .1 .4 .2c.3 .2 .8 .4 1.3 .7c1.1 .6 2.6 1.4 4.6 2.4c3.9 2 9.5 4.7 16.8 8c14.6 6.5 35.8 14.9 63.1 23.3C141.2 143.4 220.4 160 320 160c40.5 0 77.6-2.7 111-7.1c2.6-.3 5.1-.7 7.6-1c20.2-2.8 39.1-6.3 56.5-10.1c21.8-4.7 41.2-9.9 58.3-15.2c27.3-8.4 48.5-16.9 63.1-23.3c7.3-3.2 12.9-6 16.8-8c2-1 3.5-1.8 4.6-2.4c.5-.3 1-.5 1.3-.7l.4-.2 .1-.1 .1 0 0 0c0 0 0 0-15.9-27.8s-15.9-27.8-15.9-27.8l0 0-.6 .4c-.6 .3-1.7 .9-3.2 1.7c-3 1.5-7.6 3.8-13.8 6.5c-12.4 5.5-31.2 13.1-55.9 20.7C485.2 80.6 412.4 96 320 96s-165.2-15.4-214.6-30.6C80.7 57.8 61.9 50.3 49.5 44.8c-6.2-2.8-10.8-5-13.8-6.5c-1.5-.8-2.5-1.3-3.2-1.7l-.6-.4-.1 0 0 0 0 0 0 0c0 0 0 0-15.9 27.8zm98.8 160.5c-30.8 1.9-59 21.7-70.2 52.5C22.7 337.1 76 424.6 76 424.6s97.1-32.8 119-92.9c11.2-30.8 2.3-64.1-20-85.3l22.8-62.7c-23-3.2-44.4-7.2-63.9-11.5l-19 52.3zM320 192c-10.9 0-21.6-.2-32-.6v71.2c-28.3 12.3-48 40.5-48 73.3c0 64 80 128 80 128s80-64 80-128c0-32.8-19.7-61-48-73.3V191.4c-10.4 .4-21.1 .6-32 .6zm186.1-19.9c-19.6 4.4-40.9 8.3-63.9 11.5l22.8 62.7c-22.3 21.3-31.2 54.5-20 85.3c21.9 60.1 119 92.9 119 92.9s53.3-87.5 31.4-147.6c-11.2-30.8-39.4-50.6-70.2-52.5l-19-52.3z"],
    "citrus": [512, 512, [], "e2f4", "M288 112v16h16 80c53 0 96-43 96-96V16 0H464 384c-53 0-96 43-96 96v16zM256 96c0-23.1 6.1-44.7 16.8-63.4c-5.5-.4-11.1-.6-16.8-.6C123.5 32 16 139.5 16 272s107.5 240 240 240s240-107.5 240-240c0-49.5-15-95.5-40.7-133.7C435 152 410.4 160 384 160H304 288 256V128 112 96z"],
    "flag-usa": [448, 512, [], "f74d", "M64 0V32 48l69-17.2c38.1-9.5 78.3-5.1 113.5 12.5c46.3 23.2 100.8 23.2 147.1 0L448 16v86.2l-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-20.3-9-41.8-14.7-63.6-16.9v32.2c17.4 2.1 34.4 6.7 50.6 13.9l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4L448 136.3v62l-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-40.2-17.9-85-22.5-128.1-13.3L64 203.1v32.7l70.2-15.1c36.4-7.8 74.3-3.9 108.4 11.3l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4L448 232.3v62l-44.7 16.2c-42.8 15.6-90 13.9-131.6-4.6l-16.1-7.2c-40.2-17.9-85-22.5-128.1-13.3L64 299.1v32.7l70.2-15.1c36.4-7.8 74.3-3.9 108.4 11.3l16.1 7.2c49.2 21.9 105 23.8 155.6 5.4L448 328.3V384l-55.5 20.8c-46.2 17.3-97.6 14.6-141.7-7.4c-37.9-19-81.3-23.7-122.5-13.4L64 400v80 32H0V480 416 345.5 312.8 249.5 216.8 153.5 120.8 64 32 0H64zm48 96A16 16 0 1 0 80 96a16 16 0 1 0 32 0zm32 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-32 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm32 0a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "laptop-file": [640, 512, [], "e51d", "M96 0H64V32 288H0v48l48 48H320V288H128V64H448V96h64V32 0H480 96zM512 128H352V512H640V256H512V128zm32 96h96l-96-96v96z"],
    "tty": [512, 512, ["teletype"], "f1e4", "M51.2 264L0 174C29.9 132 122.9 48 256 48s226.1 84 256 126l-51.2 90-128-42V144c-49.6-18.1-104-18.1-153.6 0v78l-128 42zM32 320H96v64H32V320zm0 96H96v64H32V416zm160-96v64H128V320h64zm32 0h64v64H224V320zm160 0v64H320V320h64zm32 0h64v64H416V320zm64 96v64H416V416h64zm-352 0H384v64H128V416z"],
    "chart-tree-map": [512, 512, [], "e0ea", "M0 32H224V240H0V32zM0 272H224V480H0V272zM512 32V160H256V32H512zM256 192H512V320H256V192zM512 352V480H256V352H512z"],
    "diagram-next": [512, 512, [], "e476", "M512 32V224H280v64l40 0 32 0v32l-32 32-64 64-64-64-32-32V288l32 0 40 0V224H0V32H512zM64 288l64 0v32 13.3l9.4 9.4 9.4 9.4H64v64H210.7l22.6 22.6L256 461.3l22.6-22.6L301.3 416H448V352H365.3l9.4-9.4 9.4-9.4V320 288h64 64v64 64 64H448L64 480H0V416 352 288H64z"],
    "person-rifle": [576, 512, [], "e54e", "M320 192h16V512H144V337.7L90.4 428.3 70.1 462.8 1.2 422.1l20.3-34.4 104-176L137.2 192H160 320zM160 80a80 80 0 1 1 160 0A80 80 0 1 1 160 80zM464 0V128h16V269.3l16-5.3V192h48V304l-64 21.3V352h64v48H484l28 112H416V400H368V192h32V128h16V32H400V0h16 32 16z"],
    "clock-five-thirty": [512, 512, [], "e34a", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V335.3l20 30 13.3 20 39.9-26.6-13.3-20-64-96L232 256V392v24h48V392z"],
    "pipe-valve": [512, 512, [], "e439", "M288 64c0-17.7-14.3-32-32-32s-32 14.3-32 32V76.8L96 64v64l160-16 160 16V64L288 76.8V64zm0 84.2l-32-4-32 4V192H96V448H416V192H288V148.2zM64 160H0v32V448v32H64V448 192 160zm448 32V160H448v32V448v32h64V448 192z"],
    "arrow-up-from-arc": [512, 512, [], "e4b4", "M256 448C150 448 64 362 64 256l0-32L0 224l0 32C0 397.4 114.6 512 256 512s256-114.6 256-256l0-32-64 0 0 32c0 106-86 192-192 192zM121.4 137.4L98.7 160 144 205.3l22.6-22.6L224 125.3 224 320l0 32 64 0 0-32 0-194.7 57.4 57.4L368 205.3 413.3 160l-22.6-22.6-112-112L256 2.7 233.4 25.4l-112 112z"],
    "face-spiral-eyes": [512, 512, [], "e485", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm39.1-98.7L256 387.2l-39.1 26.1-8.9 5.9-8.9-5.9-40.3-26.8-23.7 11.8-14.3 7.2-14.3-28.6 14.3-7.2 32-16 8.3-4.2 7.7 5.2L208 380.8l39.1-26.1 8.9-5.9 8.9 5.9L304 380.8l39.1-26.1 7.7-5.2 8.3 4.2 32 16 14.3 7.2-14.3 28.6-14.3-7.2-23.7-11.8-40.3 26.8-8.9 5.9-8.9-5.9zM154.4 124c-46.9 1.9-82.2 45-78.1 84.3l0 .3 0 .3c2 40.2 40.8 70.7 76.2 66.7l.3 0 .3 0c36.3-2 62.1-35.7 58.4-64.5l0-.3 0-.3c-2.1-29.8-31.3-51-56-47.5l-.3 0-.3 0c-25.7 2.2-42 26.2-38.9 44.5l.1 .4 0 .4c2.1 19.5 21.5 31.3 35.5 28.6l.3-.1 .3 0c15.2-2.1 22-16.3 19.9-24l-.1-.4-.1-.4c-.9-4.3-3.4-7.4-6.5-9.2c-.9-.5-1.8-.9-2.6-1.2c1.7 1.9 2.8 4.2 3 6.9c1 11.1-8.8 15.8-14.1 16.4c-6.6 .8-13.4-2.2-17.6-8.5c-5-6.8-4.4-15.6-1.8-21.8c2.9-7 8.9-13.2 17.8-16c9.2-3.3 19.4-1.3 27.5 3.3c8.3 4.9 15.5 13.4 17.9 24.8c5.8 22.8-11.9 49.5-39.5 53.6c-27.7 5.3-59.8-16.2-63.6-49.2c-5.4-33 21.9-68.7 60.3-72.1c38.2-5.2 79.6 25.8 82.9 69.3c5.4 43.3-31.5 88.2-80.6 91.2c-48.8 5.3-99.6-35.2-102.5-89.1c-5.5-53.8 41.1-108.1 101-110.5l1 24zm281.3 83.7l0-.3 0-.3c-2-40.2-40.8-70.7-76.2-66.7l-.3 0-.3 0c-36.3 2-62.1 35.7-58.4 64.5l0 .3 0 .3c2.1 29.8 31.3 51 56 47.5l.3 0 .3 0c25.7-2.2 42-26.2 38.9-44.5l-.1-.4 0-.4c-2.1-19.5-21.5-31.3-35.5-28.6l-.3 .1-.3 0c-15.2 2.1-21.9 16.3-19.9 24l.1 .4 .1 .4c.9 4.3 3.4 7.4 6.5 9.2c.9 .5 1.8 .9 2.6 1.2c-1.7-1.9-2.8-4.2-3-6.9c-1-11.1 8.8-15.8 14.1-16.4c6.6-.8 13.4 2.2 17.6 8.5c5 6.8 4.4 15.6 1.8 21.8c-2.9 7-8.9 13.2-17.8 16c-9.2 3.3-19.4 1.3-27.5-3.3c-8.3-4.9-15.5-13.4-17.9-24.8c-5.8-22.8 11.9-49.5 39.5-53.6c27.7-5.3 59.8 16.2 63.6 49.2c5.4 33-21.9 68.7-60.3 72.1c-38.2 5.2-79.6-25.8-82.9-69.3c-5.4-43.3 31.5-88.2 80.6-91.2c48.8-5.3 99.6 35.2 102.5 89.1c5.5 53.8-41.1 108.1-101 110.5l-1-24c46.9-1.9 82.2-45 78.1-84.3z"],
    "compress-wide": [512, 512, [], "f326", "M160 96V64H96V96v64H32 0v64H32h96 32V192 96zM32 288H0v64H32 96v64 32h64V416 320 288H128 32zM416 96V64H352V96v96 32h32 96 32V160H480 416V96zM384 288H352v32 96 32h64V416 352h64 32V288H480 384z"],
    "circle-phone-hangup": [512, 512, ["phone-circle-down"], "e11d", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM378.7 320L304 299.2l5.6-49.1c-34.9-10.5-72.3-10.5-107.2 0l5.6 49.1L133.3 320 96 262.8l10.7-10.4c82.5-80.5 216.2-80.5 298.7 0L416 262.8 378.7 320z"],
    "gear-complex-code": [512, 512, [], "e5eb", "M302.7 0h-96l-7 55.7c-16.8 4.7-32.7 11.5-47.5 20L107.6 41 39.7 108.9l35 45c-8.3 14.7-14.8 30.4-19.4 47L-1.3 208 0 304l55.3 7c4.5 16.6 11.1 32.4 19.4 47.1l-35 45L107.6 471l44.6-34.7c14.8 8.5 30.7 15.3 47.5 20l7 55.7h96l6.9-55c17.2-4.6 33.6-11.3 48.7-19.9L401.8 471l67.9-67.9L436.2 360c8.9-15.3 15.8-31.8 20.6-49.3l54-6.7V208l-54-6.7c-4.7-17.4-11.7-34-20.6-49.3l33.5-43.1L401.8 41 358.3 74.9c-15.2-8.6-31.5-15.3-48.7-19.9L302.7 0zM287.8 162.6l-32 192-2.6 15.8-31.6-5.3 2.6-15.8 32-192 2.6-15.8 31.6 5.3-2.6 15.8zM187.3 227.3L158.6 256l28.7 28.7L198.6 296 176 318.6l-11.3-11.3-40-40L113.4 256l11.3-11.3 40-40L176 193.4 198.6 216l-11.3 11.3zm160-22.6l40 40L398.6 256l-11.3 11.3-40 40L336 318.6 313.4 296l11.3-11.3L353.4 256l-28.7-28.7L313.4 216 336 193.4l11.3 11.3z"],
    "house-medical-circle-exclamation": [640, 512, [], "e512", "M320 368.7c.2 59.2 29.7 111.6 74.8 143.3H64.1V287.6H0V240L288.4 0 520.5 193.7c-8-1.1-16.2-1.7-24.5-1.7c-54.7 0-103.5 24.9-135.8 64H320V192H256v64H192v64h64v64h64V368.7zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224V416H480v32h32zm0-176H480v16 80 16h32V368 288 272z"],
    "badminton": [576, 512, [], "e33a", "M240.2 112.2C272.6 79.8 312.9 64 349 64c28.2 0 53.2 9.6 71.3 27.7S448 134.9 448 163c0 36-15.8 76.4-48.2 108.8c-59.4 59.4-139.7 60.9-180.1 20.5C201.6 274.1 192 249.1 192 221c0-36 15.8-76.4 48.2-108.8zM349 0c-54.2 0-110.5 23.4-154 66.9s-67 99.8-66.9 154c0 32.4 8.4 64.2 26.2 91.6l-48.8 48.8L96 352 0 448l64 64 96-96-9.4-9.4 48.8-48.8c73.3 48.1 177.5 27.4 245.7-40.8c43.6-43.6 67-99.8 66.9-154c0-42.8-14.8-84.9-46.5-116.6S391.8 0 349 0zM514.5 352c-26.5 0-48 21.5-48 48v32h96V400c0-26.5-21.5-48-48-48zM463 448l-11.2 38.9-4.4 15.4 30.7 8.9 4.4-15.4L496 449.2V496v16h32V496 449.2l13.5 46.7 4.4 15.4 30.7-8.9-4.4-15.4L561 448H463z"],
    "closed-captioning": [576, 512, [], "f20a", "M0 32H576V480H0V32zM200 208c17 0 32 8.9 40.6 22.3l40.5-25.7c-17-26.8-46.9-44.6-81.1-44.6c-53 0-96 43-96 96s43 96 96 96c34.2 0 64.1-17.8 81.1-44.6l-40.5-25.7C232 295.1 217 304 200 304c-26.5 0-48-21.5-48-48s21.5-48 48-48zm144 48c0-26.5 21.5-48 48-48c17 0 32 8.9 40.6 22.3l40.5-25.7c-17-26.8-47-44.6-81.1-44.6c-53 0-96 43-96 96s43 96 96 96c34.2 0 64.1-17.8 81.1-44.6l-40.5-25.7C424 295.1 409 304 392 304c-26.5 0-48-21.5-48-48z"],
    "person-hiking": [384, 512, ["hiking"], "f6ec", "M192 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm-23.5 69.1l31.3 7.8 48 12 12 3 6.9 10.3L305.1 208H336V184 160h48v24 24h0v64h0V488v24H336V488 272H288 270.9l-9.5-14.2-18.1-27.1L224.2 307l54.4 54.4 9.4 9.4V384v96 32H224V480 397.3l-69.7-69.7-1.1-.3 .2-.7-3.3-3.3c-15.8-15.8-22.2-38.6-16.9-60.3l27.8-114.5 7.6-31.3zM117.3 334c3 4.2 6.4 8.2 10.1 11.9l41.9 41.9L136.7 512H70.5l46.8-178zM144 96L96 288 0 272 48 96h96z"],
    "right-from-line": [448, 512, ["arrow-alt-from-left"], "f347", "M288 96L448 256 288 416l-32 0 0-96L96 320l0-128 160 0 0-96 32 0zM64 96l0 320 0 32L0 448l0-32L0 96 0 64l64 0 0 32z"],
    "venus-double": [640, 512, [9890], "f226", "M192 288a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM368 176c0 86.3-62.1 158.1-144 173.1V384h32 32v64H256 224v32 32H160V480 448H128 96V384h32 32V349.1C78.1 334.1 16 262.3 16 176C16 78.8 94.8 0 192 0s176 78.8 176 176zM344 318c14.6-15.6 26.8-33.4 36-53c18.8 14.4 42.4 23 68 23c61.9 0 112-50.1 112-112s-50.1-112-112-112c-25.6 0-49.1 8.6-68 23c-9.3-19.5-21.5-37.4-36-53C373.1 12.6 409.1 0 448 0c97.2 0 176 78.8 176 176c0 86.3-62.1 158.1-144 173.1V384h32 32v64H512 480v32 32H416V480 448H384 352V384h32 32V349.1c-26.6-4.9-51.1-15.7-72-31.1z"],
    "images": [576, 512, [], "f302", "M576 32H96V384H576V32zM395.6 139.8l96 136L496 282v7.6 8 24H472 352 328 280 256 200 176v-24-8-9.1l6.1-6.8 64-72L264 181.5l17.9 20.2L299.1 221l57.3-81.2L376 112l19.6 27.8zM192 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM48 120V96H0v24V456v24H24 456h24V432H456 48V120z"],
    "calculator": [384, 512, [128425], "f1ec", "M384 0H0V512H384V0zM320 64v96H64V64H320zM64 192h64v64H64V192zm64 96v64H64V288h64zM64 384H224v64H64V384zM224 192v64H160V192h64zm-64 96h64v64H160V288zm160-96v64H256V192h64zm-64 96h64v64H256V288zm64 96v64H256V384h64z"],
    "shuttlecock": [512, 512, [], "f45b", "M320 0V48H304 263L250.6 87.1l-31.3 99.2L176 208l-40 80 27 27 71.9-71.9L281.1 96.8 286.4 80H304 408h24v24V208v17.6l-16.8 5.3L268.8 277.1 197 349l27 27 80-40 21.6-43.3 99.2-31.3L464 249V208 192h48v96L240 416l-36.7 36.7-144-144L96 272 224 0h96zM36.7 331.3l144 144-6.9 6.9c-19.1 19.1-45 29.8-72 29.8C45.6 512 0 466.4 0 410.2c0-27 10.7-52.9 29.8-72l6.9-6.9z"],
    "user-hair": [448, 512, [], "e45a", "M304 144c0 44.2-35.8 80-80 80s-80-35.8-80-80V128c0-5.5 .6-10.8 1.6-16H208l32-32 16 16h41.3c4.3 9.8 6.7 20.6 6.7 32v16zM224 0C153.3 0 96 57.3 96 128v16c0 70.7 57.3 128 128 128s128-57.3 128-128V128C352 57.3 294.7 0 224 0zM448 512L384 320H64L0 512H448z"],
    "eye-evil": [640, 512, [], "f6db", "M258.1 111.4L320 0l61.9 111.4c11 2.7 21.7 6.2 31.8 10.3L550 82.7l-59 94.5c7.1 8.9 13 18.4 17.7 28.3L640 256 508.7 306.5c-4.6 10-10.6 19.4-17.7 28.3l59 94.5-136.3-39c-10.1 4.1-20.7 7.5-31.8 10.3L320 512 258.1 400.6c-11-2.7-21.7-6.2-31.8-10.2L90 429.3l59-94.5c-7.1-8.9-13-18.4-17.7-28.3L0 256l131.3-50.5c4.6-10 10.6-19.4 17.7-28.3L90 82.7l136.3 39c10.1-4.1 20.7-7.5 31.8-10.3zM320 352c53 0 96-43 96-96c0-19.7-6-38.1-16.2-53.3c-16.9 9.7-35.7 16.5-55.8 19.5c4.6 9.3 7.9 20.7 7.9 33.8c0 40.4-32 64-32 64s-32-23.6-32-64c0-13.1 3.4-24.5 7.9-33.8c-20.1-3-38.9-9.8-55.8-19.5C230 217.9 224 236.3 224 256c0 53 43 96 96 96z"],
    "people-pulling": [576, 512, [], "e535", "M128 48A48 48 0 1 0 32 48a48 48 0 1 0 96 0zm10.8 304l29.8 134.1 3.9 23.2 .5 2.7h64.9l-2.2-13.3-4-24c-.1-.6-.2-1.1-.3-1.7L174.3 216.8l115.6 56.7 33.8 16.6 10.9-36 11.8-38.8L369 205.2l13.6-6-17 63.6c-5.6 21.1-.1 43.6 14.7 59.7l70.9 77.4 22 80.5 8.4 30.9 61.7-16.8-8.4-30.9-24-88-2-7.5-5.2-5.7-52.3-57 18.4-62.4 13.7 27.4 4.8 9.5 9.5 4.8 48 24 28.6-57.2-38.5-19.2-35.2-70.5-7-14-15.3-3.1-80-16-10-2-9.3 4.1-6.8 3-29.2 13-36 16-12.9 5.7-.5 .2-4.1 13.6-5.7 17-138.7-68-6.7-3.3h-7.4H32 0v32V320v32H58.2L84.4 509.3l.5 2.7h64.9l-2.2-13.3L123.1 352h15.7zM464 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM349.7 335.6l-25 62.4-43.4 43.4L258.7 464 304 509.3l22.6-22.6 48-48 4.6-4.6 2.4-6.1 15.7-39.3-40.7-44.4c-2.5-2.7-4.8-5.6-7-8.6z"],
    "n": [384, 512, [110], "4e", "M0 32H47l9.6 11.5L320 359.6V64 32h64V64 448v32H337l-9.6-11.5L64 152.4V448v32H0V448 64 32z"],
    "garage": [640, 512, [], "e009", "M0 128V512H96V192H544V512h96V128L320 0 0 128zm512 96H128v96H512V224zM128 512H512V352H128V512zm128-96h16 96 16v32H368 272 256V416z"],
    "cable-car": [512, 512, [128673, 57551, "tram"], "f7da", "M288 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-64-8a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm261 47.5l23.5-5L498.4 51.5l-23.5 5-224 48-224 48-23.5 5 10.1 46.9 23.5-5 195-41.8V224H32V512H480V224H280V147.4l205-43.9zM80 288h96v96H80V288zm224 0v96H208V288h96zm32 0h96v96H336V288z"],
    "shovel-snow": [512, 512, [], "f7c3", "M400 0L366.1 33.9l-6.9 6.9c-14.9 14.9-23.2 35-23.2 56c0 13.1 3.2 25.5 8.8 36.4L255 223l-63-63L0 304 208 512 352 320l-63-63 89.8-89.8c10.9 5.7 23.3 8.8 36.4 8.8c21 0 41.1-8.3 56-23.2l6.9-6.9L512 112 478.1 78.1 433.9 33.9 400 0zm0 67.9L444.1 112l-6.9 6.9c-5.8 5.9-13.8 9.1-22.1 9.1C398 128 384 114 384 96.8c0-8.3 3.3-16.2 9.1-22.1l6.9-6.9zM203.3 267.3l-72 72L120 350.6 97.4 328l11.3-11.3 72-72L192 233.4 214.6 256l-11.3 11.3zm64 64l-72 72L184 414.6 161.4 392l11.3-11.3 72-72L256 297.4 278.6 320l-11.3 11.3z"],
    "cloud-rain": [512, 512, [127783, 9926], "f73d", "M96 320H0V224c0-41.8 26.7-77.4 64-90.5V112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H416 96zm0 48l40.9 68.1c4.7 7.8 7.1 16.7 7.1 25.8V464c0 26.5-21.5 48-48 48s-48-21.5-48-48v-2.1c0-9.1 2.5-18 7.1-25.8L96 368zm160 0l40.9 68.1c4.7 7.8 7.1 16.7 7.1 25.8V464c0 26.5-21.5 48-48 48s-48-21.5-48-48v-2.1c0-9.1 2.5-18 7.1-25.8L256 368zm119.1 68.1L416 368l40.9 68.1c4.7 7.8 7.1 16.7 7.1 25.8V464c0 26.5-21.5 48-48 48s-48-21.5-48-48v-2.1c0-9.1 2.5-18 7.1-25.8z"],
    "face-lying": [512, 512, [], "e37e", "M494 350.5c-4.5 1-9.2 1.5-14 1.5H352 336V320h16H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H288 272V224h16H480c11.2 0 21.7 2.9 30.9 7.9C498.8 101.8 389.3 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c108 0 200.4-66.9 238-161.5zM144.4 176a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM188.8 393.6l-9.6 12.8-25.6-19.2 9.6-12.8C180.7 351.1 208.6 336 240 336c13.6 0 26.6 2.8 38.4 8l14.7 6.4-12.8 29.3-14.7-6.4c-7.8-3.4-16.5-5.3-25.6-5.3c-20.9 0-39.5 10-51.2 25.6z"],
    "sprinkler": [512, 512, [], "e035", "M24 0a24 24 0 1 1 0 48A24 24 0 1 1 24 0zM0 128a24 24 0 1 1 48 0A24 24 0 1 1 0 128zM0 232a24 24 0 1 1 48 0A24 24 0 1 1 0 232zM64 72a24 24 0 1 1 48 0A24 24 0 1 1 64 72zm24 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40-32a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm360 80a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm24-80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM488 0a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM448 72a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm-24 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-40-32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM288 64V96 256H416v40l-96 88V512H192V384L96 296V256H224V96 64h64z"],
    "building-circle-xmark": [640, 512, [], "e4d4", "M384 0H0V512H144V384h96V512H384v-8.2c-39.1-32.3-64-81.1-64-135.8s24.9-103.5 64-135.8V0zM64 224h64v64H64V224zm160 0v64H160V224h64zm32 0h64v64H256V224zM128 96v64H64V96h64zm32 0h64v64H160V96zm160 0v64H256V96h64zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7L518.6 368l36.7 36.7L566.6 416 544 438.6l-11.3-11.3L496 390.6l-36.7 36.7L448 438.6 425.4 416l11.3-11.3L473.4 368l-36.7-36.7L425.4 320 448 297.4l11.3 11.3L496 345.4l36.7-36.7L544 297.4 566.6 320l-11.3 11.3z"],
    "person-sledding": [512, 512, ["sledding"], "f7cb", "M352 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM13.8 215.6l21.3 11.1L172.4 298c-12.8-20.3-10.5-49.8 13.8-66L246.3 192H160 128V128h32H320h13.3l9.4 9.4 12.8 12.8 3.2 3.2L381.3 176l-22.6 22.6L301.3 256H352h32v32 96 23.9l56.2 29.2 37.1-18.5 21.5-10.7 21.5 42.9-21.5 10.7-48 24-10.9 5.5-10.9-5.6-416-216L-8.4 258.2l22.1-42.6zM320 374.6V320H214.7L320 374.6z"],
    "game-console-handheld": [384, 512, [], "f8bb", "M0 0H384V512H0V0zM96 64V224H288V64H96zM232 384a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM96 288v32H64v32H96v32h32V352h32V320H128V288H96z"],
    "ship": [576, 512, [128674], "f21a", "M192 0H384V64h64 32V96 240l96 32L441.4 395.3c-5.5 3.6-10.9 6.6-16.7 9.3C411.6 410.7 397 415 384 415s-27.6-4.3-40.7-10.3c-12-5.5-21.7-12.5-35.5-22.5l0 0 0 0L288 368l-18.6 13.4-1.1 .8 0 0c-13.9 10-23.6 17-35.5 22.5C219.6 410.7 205 415 192 415s-27.6-4.3-40.7-10.3c-5.9-2.7-11.2-5.7-16.7-9.3L0 272l96-32V96 64h32 64V0zM160 218.7L288 176l128 42.7V128H160v90.7zM272.4 493.1c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 502.1 31.9 512 0 512V448c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7z"],
    "clock-six-thirty": [512, 512, [], "e353", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120V256 232H232v24V392v24h48V392z"],
    "battery-slash": [640, 512, [], "f377", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L565.2 416H576V352 320h32V192H576V160 96H512 153L48.4 14.8zM235.4 160H512V352H482.7L235.4 160zm89.5 192H96V171.6L32 121.2V160 352v64H96 406.2l-81.2-64z"],
    "tugrik-sign": [384, 512, [], "e2ba", "M32 32H0V96H32 160V199L56.2 225l-31 7.8 15.5 62.1 31-7.8L160 265v30L56.2 321l-31 7.8 15.5 62.1 31-7.8L160 361v87 32h64V448 345L327.8 319l31-7.8-15.5-62.1-31 7.8L224 279V249L327.8 223l31-7.8-15.5-62.1-31 7.8L224 183V96H352h32V32H352 192 32z"],
    "arrows-down-to-line": [576, 512, [], "e4b8", "M544 416L32 416 0 416l0 64 32 0 512 0 32 0 0-64-32 0zM528 226.7l-22.6 22.6L480 274.7 480 64l0-32-64 0 0 32 0 210.7-25.4-25.4L368 226.7 322.7 272l22.6 22.6 80 80L448 397.3l22.6-22.6 80-80L573.3 272 528 226.7zm-320 0l-22.6 22.6L160 274.7 160 64l0-32L96 32l0 32 0 210.7L70.6 249.4 48 226.7 2.7 272l22.6 22.6 80 80L128 397.3l22.6-22.6 80-80L253.3 272 208 226.7z"],
    "download": [512, 512, [], "f019", "M288 32V0H224V32 274.7l-73.4-73.4L128 178.7 82.7 224l22.6 22.6 128 128L256 397.3l22.6-22.6 128-128L429.3 224 384 178.7l-22.6 22.6L288 274.7V32zM0 512H512V352H346.5l-45.3 45.3L256 442.5l-45.3-45.3L165.5 352H0V512zM432 408a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "shelves": [640, 512, ["inventory"], "f480", "M64 0V32 160H576V32 0h64V32 160v32 32V416v32 32 32H576V480H64v32H0V480 448 416 224 192 160 32 0H64zm0 416H576V224H64V416zM352 0H480V128H352V0zM224 256V384H96V256H224zm160 0V384H256V256H384z"],
    "cloud-snow": [512, 512, [127784], "f742", "M96 320H0V224c0-41.8 26.7-77.4 64-90.5V112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H416 96zm-8 32v24 16h16 24v48H104 88v16 24H40V456 440H24 0V392H24 40V376 352H88zm192 32v24 16h16 24v48H296 280v16 24H232V488 472H216 192V424h24 16V408 384h48zm192-8v16h16 24v48H488 472v16 24H424V456 440H408 384V392h24 16V376 352h48v24z"],
    "face-grin": [512, 512, [128512, "grin"], "f580", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm.3-180.2c59.1 0 114.1-10.6 160.2-29C400.3 376.7 334.7 432 256.3 432s-144-55.3-160.2-129.2c46.2 18.3 101.2 29 160.2 29zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "delete-left": [576, 512, [9003, "backspace"], "f55a", "M576 64V448H176L0 256 176 64H576zM254.1 192l17 17 47 47-47 47-17 17L288 353.9l17-17 47-47 47 47 17 17L449.9 320l-17-17-47-47 47-47 17-17L416 158.1l-17 17-47 47-47-47-17-17L254.1 192z"],
    "oven": [448, 512, [], "e01d", "M0 0V160H448V0H0zM56 80a24 24 0 1 1 48 0A24 24 0 1 1 56 80zM176 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm72 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM368 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm16 200V448H64V256H384zM64 192H0v64V448v64H64 384h64V448 256 192H384 64zm272 96H112 96v32h16H336h16V288H336z"],
    "cloud-binary": [640, 512, [], "e601", "M0 480H144 512 640V352c0-59.6-40.8-109.8-96-124V192c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192v8.2C40.1 220 0 273.3 0 336V480zM288 160h16 16 16v16 80 16H304V256 192H288V160zm-112 0h64 16v16 80 16H240 176 160V256 176 160h16zm16 80h32V192H192v48zm192-80h16 64 16v16 80 16H464 400 384V256 176 160zm32 32v48h32V192H416zM192 304h16 16v16 80 16H192V400 336H176V304h16zm80 0h16 64 16v16 80 16H352 288 272V400 320 304zm32 32v48h32V336H304zm112-32h16 16v16 80 16H416V400 336H400V304h16z"],
    "eye-dropper": [512, 512, ["eye-dropper-empty", "eyedropper"], "f1fb", "M341.6 29.2L240.1 130.8l-9.4-9.4L208 98.7 162.7 144l22.6 22.6 160 160L368 349.3 413.3 304l-22.6-22.6-9.4-9.4L482.8 170.4c39-39 39-102.2 0-141.1s-102.2-39-141.1 0zM32 344v88l-9.9 12.3L4 467l-4 5 40 40 5-4 22.7-18.1L80 480h88L310.7 337.3 265.5 292l-124 124H96V370.5l124-124-45.3-45.3L32 344z"],
    "comment-captions": [512, 512, [], "e146", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM120 208H96v48h24H264h24V208H264 120zm224 0H320v48h24 48 24V208H392 344zM120 288H96v48h24 48 24V288H168 120zm128 0H224v48h24H392h24V288H392 248z"],
    "comments-question": [640, 512, [], "e14e", "M208 352c114.9 0 208-78.8 208-176S322.9 0 208 0S0 78.8 0 176c0 37.5 13.9 72.3 37.6 100.9L0 352l108.1-21.6C137.7 344.2 171.8 352 208 352zm23.5 31C255.8 457.4 336.4 512 432 512c36.2 0 70.3-7.8 99.9-21.6L640 512l-37.6-75.1C626.1 408.3 640 373.5 640 336c0-92.8-84.9-168.9-192.6-175.5c.4 5.1 .6 10.3 .6 15.5c0 112.3-99.1 196.9-216.5 207zM134.7 124c0-25.8 20.9-46.7 46.7-46.7h47.4c29.1 0 52.6 23.6 52.6 52.6c0 18.8-10.1 36.3-26.4 45.6L228 191v6.3 20H188v-20V179.5 167.9l10-5.8L235 140.9c3.9-2.3 6.3-6.4 6.3-10.9c0-7-5.7-12.6-12.6-12.6H181.3c-3.7 0-6.7 3-6.7 6.7l0 5.5-40 0 0-5.5zM188 250.7h40v40H188v-40z"],
    "scribble": [512, 512, [], "e23f", "M170 23.3C186.5 8.3 208 0 230.3 0h1.1C280.3 0 320 39.7 320 88.6c0 23.5-9.3 46-25.9 62.6L103.2 342.1c-4.6 4.6-7.2 10.9-7.2 17.4C96 373 107 384 120.6 384c6.5 0 12.8-2.6 17.4-7.2L360.8 153.9c16.6-16.6 39.1-25.9 62.6-25.9c48.9 0 88.6 39.7 88.6 88.6c0 23.5-9.3 46-25.9 62.6l-88.2 88.2c-8.9 8.9-13.8 20.9-13.8 33.4c0 26.1 21.1 47.2 47.2 47.2h4.4c4.8 0 9.5-.8 14.1-2.3l12.2-4.1 30.4-10.1 20.2 60.7-30.4 10.1-12.2 4.1c-11.1 3.7-22.6 5.6-34.3 5.6h-4.4C369.8 512 320 462.2 320 400.8c0-29.5 11.7-57.8 32.6-78.6l88.2-88.2c4.6-4.6 7.2-10.9 7.2-17.4c0-13.6-11-24.6-24.6-24.6c-6.5 0-12.8 2.6-17.4 7.2L183.2 422.1c-16.6 16.6-39.1 25.9-62.6 25.9C71.7 448 32 408.3 32 359.4c0-23.5 9.3-46 25.9-62.6L248.8 105.9c4.6-4.6 7.2-10.9 7.2-17.4C256 75 245 64 231.4 64h-1.1c-6.4 0-12.6 2.4-17.3 6.7L53.5 215.7 10.5 168.3 170 23.3z"],
    "rotate-exclamation": [512, 512, [], "e23c", "M105.1 202.6c7.7-21.8 20.2-42.3 37.8-59.8c62.5-62.5 163.8-62.5 226.3 0l40 40L352 240l160 0V80l-57.6 57.6-40-40c-87.5-87.5-229.3-87.5-316.8 0C73.2 122 55.6 150.7 44.8 181.4l60.4 21.3zm37.8 166.5l-40-40L160 272H0V432l57.6-57.6 40 40c87.5 87.5 229.3 87.5 316.8 0c24.4-24.4 42.1-53.1 52.9-83.7l-60.4-21.3c-7.7 21.8-20.2 42.3-37.8 59.8c-62.5 62.5-163.8 62.5-226.3 0zM280 128H232v24V264v24h48V264 152 128zM232 320v48h48V320H232z"],
    "file-circle-check": [576, 512, [], "e5a0", "M0 0H224V160H384v38.6C310.1 219.5 256 287.4 256 368c0 59.5 29.6 112.1 74.8 144H0V0zM384 128H256V0L384 128zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm222.6-32L488 313.4l-11.3 11.3L416 385.4l-28.7-28.7L376 345.4 353.4 368l11.3 11.3 40 40L416 430.6l11.3-11.3 72-72L510.6 336z"],
    "glass": [384, 512, [129371], "f804", "M34.9 0H-.1L3 34.8l39.6 448L45.1 512H74.4 311.8h29.3l2.6-29.2 39.6-448L386.3 0h-35H34.9zM75.5 128L69.8 64H316.4l-5.7 64H75.5z"],
    "loader": [512, 512, [], "e1d4", "M288 32V0H224V32 96v32h64V96 32zm0 384V384H224v32 64 32h64V480 416zM0 224v64H32 96h32V224H96 32 0zm416 0H384v64h32 64 32V224H480 416zM97.6 52.4L52.4 97.6 75 120.2l45.3 45.3 22.6 22.6 45.3-45.3-22.6-22.6L120.2 75 97.6 52.4zM391.8 346.5l-22.6-22.6-45.3 45.3 22.6 22.6L391.8 437l22.6 22.6 45.3-45.3L437 391.8l-45.3-45.3zM52.4 414.4l45.3 45.3L120.2 437l45.3-45.3 22.6-22.6-45.3-45.3-22.6 22.6L75 391.8 52.4 414.4zM346.5 120.2l-22.6 22.6 45.3 45.3 22.6-22.6L437 120.2l22.6-22.6L414.4 52.3 391.8 75l-45.3 45.3z"],
    "forward": [512, 512, [9193], "f04e", "M512 256L256 448V64L512 256zM0 448V64L224 232v48L0 448z"],
    "user-pilot": [448, 512, [], "e2c0", "M80 99.2V128c16 10.7 67.2 32 144 32s128-21.3 144-32V99.2L400 80V48L224 0 48 48V80L80 99.2zm88.8-40.7l14.3 7.2L224 86.1l40.8-20.4 14.3-7.2 14.3 28.6-14.3 7.2-48 24-7.2 3.6-7.2-3.6-48-24-14.3-7.2 14.3-28.6zM98.1 168.8C96.7 176.3 96 184.1 96 192c0 70.7 57.3 128 128 128s128-57.3 128-128c0-7.9-.7-15.7-2.1-23.2C310.8 183.8 268.4 192 224 192s-86.8-8.2-125.9-23.2zM224 416l-85.3-64H48L0 512H448L400 352H309.3L224 416zm112 0h32 16v32H368 336 320V416h16z"],
    "mobile": [384, 512, [128241, "mobile-android", "mobile-phone"], "f3ce", "M368 0H16V512H368V0zM160 432h64 16v32H224 160 144V432h16z"],
    "code-pull-request-closed": [512, 512, [], "e3f9", "M305.4 62.6L354.7 112l-49.4 49.4 45.3 45.3L400 157.3l49.4 49.4 45.3-45.3L445.3 112l49.4-49.4L449.4 17.4 400 66.7 350.6 17.4 305.4 62.6zM136 88v48H88V88h48zM88 32H32V88v48 56H80V352H32v56 48 56H88h48 56V456 408 352H144V192h48V136 88 32H136 88zM432 288V256H368v32 64H320v56 48 56h56 48 56V456 408 352H432V288zm-8 168H376V408h48v48zM88 408h48v48H88V408z"],
    "face-meh": [512, 512, [128528, "meh"], "f11a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM160 336H352h16v32H352 160 144V336h16z"],
    "align-center": [448, 512, [], "f037", "M352 32H96V96H352V32zm96 128H0v64H448V160zM0 416v64H448V416H0zM352 288H96v64H352V288z"],
    "book-skull": [448, 512, ["book-dead"], "f6b7", "M0 96C0 43 43 0 96 0H384h32 32V384H416v64h32v64H416 384 96c-53 0-96-43-96-96V96zM64 416c0 17.7 14.3 32 32 32H352V384H96c-17.7 0-32 14.3-32 32zM320 112c0-35.3-35.8-64-80-64s-80 28.7-80 64c0 20.9 12.6 39.5 32 51.2V192h96V163.2c19.4-11.7 32-30.3 32-51.2zM208 96a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM134.3 209.3L119.6 203 107 232.4l14.7 6.3L199.4 272l-77.7 33.3L107 311.6 119.6 341l14.7-6.3L240 289.4l105.7 45.3 14.7 6.3L373 311.6l-14.7-6.3L280.6 272l77.7-33.3 14.7-6.3L360.4 203l-14.7 6.3L240 254.6 134.3 209.3z"],
    "id-card": [576, 512, [62147, "drivers-license"], "f2c2", "M0 32V96H576V32H0zm0 96V480H576V128H0zM64 416l32-64H256l32 64H64zM176 192a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm176 0h16H496h16v32H496 368 352V192zm0 64h16H496h16v32H496 368 352V256zm0 64h16H496h16v32H496 368 352V320z"],
    "face-dotted": [512, 512, [129765], "e47f", "M163 88C131.5 105.5 105.5 131.5 88 163L28.2 139C52.7 91.5 91.5 52.7 139 28.2L163 88zM304.5 70.2C289 66.1 272.7 64 256 64s-33 2.1-48.5 6.2L183.6 10.4C206.6 3.6 230.9 0 256 0s49.4 3.6 72.4 10.4L304.5 70.2zM424 163C406.5 131.5 380.5 105.5 349 88L373 28.2C420.5 52.7 459.3 91.5 483.8 139L424 163zm17.8 141.5c4-15.5 6.2-31.7 6.2-48.5s-2.1-33-6.2-48.5l59.8-23.9c6.8 23 10.4 47.3 10.4 72.4s-3.6 49.4-10.4 72.4l-59.8-23.9zM349 424c31.5-17.5 57.5-43.5 74.9-74.9L483.8 373c-24.4 47.5-63.3 86.4-110.8 110.8L349 424zM207.5 441.8c15.5 4 31.7 6.2 48.5 6.2s33-2.1 48.5-6.2l23.9 59.8c-23 6.8-47.3 10.4-72.4 10.4s-49.4-3.6-72.4-10.4l23.9-59.8zM88 349c17.5 31.5 43.5 57.5 74.9 74.9L139 483.8C91.5 459.3 52.7 420.5 28.2 373L88 349zM70.2 304.5L10.4 328.4C3.6 305.4 0 281.1 0 256s3.6-49.4 10.4-72.4l59.8 23.9C66.1 223 64 239.3 64 256s2.1 33 6.2 48.5zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM184 328H328h24v48H328 184 160V328h24z"],
    "face-worried": [512, 512, [], "e3a3", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm-.4-112c-38.7 0-74.5 11.4-103.6 30.6c4.7-53 49.3-94.6 103.6-94.6s98.8 41.6 103.6 94.6C330.1 411.4 294.3 400 255.6 400zM144.4 272a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 160c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8l-11.7 10.9L89.4 175.2l11.7-10.9c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1h16v32H192zm141 .9c-4.3-.6-8.6-.9-13-.9H304V128h16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2l11.7 10.9-21.8 23.4-11.7-10.9c-15.5-14.5-34.8-24-56.1-26.8z"],
    "outdent": [448, 512, ["dedent"], "f03b", "M0 32H448V96H0V32zM192 160H448v64H192V160zM448 288v64H192V288H448zM0 416H448v64H0V416zm128-48L-16 256 128 144V368z"],
    "heart-circle-exclamation": [576, 512, [], "e4fe", "M64 288L39.8 263.8C14.3 238.3 0 203.8 0 167.8C0 92.8 60.8 32 135.8 32c36 0 70.5 14.3 96 39.8L256 96l24.2-24.2c25.5-25.5 60-39.8 96-39.8C451.2 32 512 92.8 512 167.8c0 13.8-2.1 27.4-6.2 40.4C483.4 197.8 458.4 192 432 192c-97.2 0-176 78.8-176 176c0 32.2 8.6 62.3 23.7 88.3L256 480 64 288zm368-64a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224V416H416v32h32zm0-176H416v16 80 16h32V368 288 272z"],
    "house": [576, 512, [127968, 63498, 63500, "home", "home-alt", "home-lg-alt"], "f015", "M511.8 287.6H576V240L288.4 0 0 240v47.6H64.1V512H224V352H352V512H512.8l-1-224.4z"],
    "vector-circle": [512, 512, [], "e2c6", "M192 0H320V41.3C392.2 62.8 449.2 119.8 470.7 192H512V320H470.7C449.2 392.2 392.2 449.2 320 470.7V512H192V470.7C119.8 449.2 62.8 392.2 41.3 320H0V192H41.3C62.8 119.8 119.8 62.8 192 41.3V0zM402.7 192c-16.1-36.9-45.8-66.6-82.7-82.7V128H192V109.3c-36.9 16.1-66.6 45.8-82.7 82.7H128V320H109.3c16.1 36.9 45.8 66.6 82.7 82.7V384H320v18.7c36.9-16.1 66.6-45.8 82.7-82.7H384V192h18.7zM240 48V80h32V48H240zm32 384H240v32h32V432zM432 240v32h32V240H432zM80 240H48v32H80V240z"],
    "car-circle-bolt": [640, 512, [], "e342", "M120 32H97.3L89.8 53.4 41.3 192H0V400v80H96V400H322.9c-1.9-10.4-2.9-21.1-2.9-32c0-97.2 78.8-176 176-176c5.4 0 10.7 .2 16 .7V192H496 470.7L422.2 53.4 414.7 32H392 120zM402.9 192H109.1l33.6-96H369.3l33.6 96zM64 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm24-224l-10.7 64H576L472 448l10.7-64H416l104-96z"],
    "calendar-week": [448, 512, [], "f784", "M160 0V64H288V0h64V64h96v96H0V64H96V0h64zM0 192H448V512H0V192zm384 64H64v96H384V256z"],
    "flying-disc": [640, 512, [], "e3a9", "M119.7 456.3c-25.2-25.2-29.6-66.7-16.5-114.9c3.2 9.5 8.4 18.5 16.2 26.3c15.6 15.6 36 20.7 55 20.5c18.9-.1 38.8-5.3 58.2-13.3c39-16.1 82-46 121.2-85.1s69-82.2 85.1-121.2c8-19.4 13.2-39.4 13.3-58.2c.1-19-5-39.5-20.5-55c-7.8-7.8-16.8-13-26.3-16.2c48.2-13 89.8-8.6 114.9 16.6c55.3 55.3 10.5 189.8-100.2 300.5S175 511.6 119.7 456.3zM331.1 267.1C257.4 340.9 172.7 375.8 141.9 345s4.1-115.4 77.9-189.2S378.3 47.2 409 77.9s-4.1 115.4-77.9 189.2z"],
    "laptop-medical": [640, 512, [], "f812", "M64 32H96 544h32V64 352H512V96H128V352H64V64 32zM0 432V384H640v48l-48 48H48L0 432zM288 144h64v64h64v64H352v64H288V272H224V208h64V144z"],
    "square-down-right": [448, 512, [], "e26c", "M0 480H448V32H0V480zM320 192V352H160l-24-24 52-52-76-76 56-56 76 76 52-52 24 24z"],
    "b": [320, 512, [98], "42", "M32 32H0V64 224v32 32V448v32H32 192c70.7 0 128-57.3 128-128c0-46.5-24.8-87.3-62-109.7c18.7-22.3 30-51 30-82.3c0-70.7-57.3-128-128-128H32zM160 224H64V96h96c35.3 0 64 28.7 64 64s-28.7 64-64 64zM64 288h96 32c35.3 0 64 28.7 64 64s-28.7 64-64 64H64V288z"],
    "seat-airline": [448, 512, [], "e244", "M64 32V0H0V32 160v6.6l2.6 6 96 224 8.3 19.4H128h88v48H120 96v48h24H360h24V464H360 264V416H376h22.2l7.8-20.8 24-64L446.2 288H400 121.7L108 256H320h32V192H320 80.5L64 153.4V32z"],
    "moon-over-sun": [512, 512, ["eclipse-alt"], "f74a", "M256 73.1L150 0 126.7 126.7 0 150 73.1 256 0 362l126.7 23.3L150 512l106-73.1L362 512l23.3-126.7L512 362 438.9 256 512 150 385.3 126.7 362 0 256 73.1zM112 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm213 65.7c-50.5 0-91.4-40.5-91.4-90.5c0-36.9 22.3-68.6 54.2-82.7c-10.1-3-20.8-4.6-31.8-4.6c-61.9 0-112 50.1-112 112s50.1 112 112 112c38.7 0 72.8-19.6 92.9-49.4c-7.6 2-15.6 3.1-23.9 3.1z"],
    "pipe": [64, 512, [], "7c", "M64 0V32 480v32H0V480 32 0H64z"],
    "file-medical": [384, 512, [], "f477", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM160 224h64v64h64v64H224v64H160V352H96V288h64V224z"],
    "potato": [512, 512, [129364], "e440", "M43.1 260.9L96 208l48-80 80-48 36.9-36.9C288.5 15.5 325.9 0 364.9 0C446.2 0 512 65.8 512 147.1c0 39-15.5 76.4-43.1 104L464 256 384 400 272 448l-20.9 20.9c-27.6 27.6-65 43.1-104 43.1C65.8 512 0 446.2 0 364.9c0-39 15.5-76.4 43.1-104zM408 168H360v48h48V168zM216 200H168v48h48V200zM136 392v48h48V392H136z"],
    "dice-one": [448, 512, [9856], "f525", "M448 32H0V480H448V32zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-a": [512, 512, [], "e0f7", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM234.3 125.8l6.5-13.8h30.5l6.5 13.8L391.4 368h-53l-22.5-48H196.2l-22.5 48h-53L234.3 125.8zM256 192.5L218.7 272h74.6L256 192.5z"],
    "helmet-battle": [576, 512, [], "f6eb", "M64 256V0L0 224v32H64zm32-32c0 80-32 192-32 192l192 96V256l-96-32V192H416v32l-96 32V512l192-96s-32-112-32-192C480 80 288 0 288 0S96 80 96 224zM512 0V256h64V224L512 0z"],
    "butter": [640, 512, [129480], "e3e4", "M64 64H448V288H64V64zM32 320H608h32v64H608v64H32V384H0V320H32zM576 64V288H480V64h96z"],
    "blanket-fire": [640, 512, [], "e3da", "M0 32H32 416h32V64v55c-31.6 25.6-61.5 52.3-88.2 83.1c-21.8 25.1-43.6 54.2-57.4 85.9H64v64 64H298.9c8.4 23.8 21.4 45.5 37.9 64H32 0V448 352 256 224 64 32zM288 352.2c0 10.9 .9 21.5 2.6 31.8H128 96V320h32H291.7c-2.4 10.5-3.7 21.2-3.7 32.2zm225-128c17.2-19.5 31-32 31-32s96 86.4 96 160c0 88.4-71.6 160-160 160s-160-71.6-160-160s128-192 128-192s32.6 26.4 65 64zM530 433c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78c18 0 34-5 49-15z"],
    "kiwi-bird": [576, 512, [], "f535", "M208 415.3c-5.3 .4-10.6 .7-16 .7c-16.6 0-32.7-2.1-48-6v46 24H96V456 390.3C38.6 357.1 0 295.1 0 224C0 118 86 32 192 32c56.9 0 108 24.7 143.1 64H448c70.7 0 128 57.3 128 128V352 480L464 352H335.1c-21.3 23.8-48.4 42.2-79.1 53.1V456v24H208V456 415.3zM448 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "castle": [640, 512, [], "e0de", "M128 0h64V64h48V0h64V64h32V0h64V64h48V0h64V112 224h64V160h64v64 64V512H384V384c0-35.3-28.7-64-64-64s-64 28.7-64 64V512H0V288 224 160H64v64h64V112 0z"],
    "golf-club": [512, 512, [], "f451", "M224 512L0 512V472H48 64V440H48 0V408H48 64V376H48 0V304l264 88 0 .5L451.4 17.7l57.2 28.6-224 448L275.8 512H256 224z"],
    "arrow-right-arrow-left": [448, 512, [8644, "exchange"], "f0ec", "M25.4 406.6l80 80L128 509.3 173.3 464l-22.6-22.6L125.3 416 416 416l32 0 0-64-32 0-290.7 0 25.4-25.4L173.3 304 128 258.7l-22.6 22.6-80 80L2.7 384l22.6 22.6zm397.3-256L445.3 128l-22.6-22.6-80-80L320 2.7 274.7 48l22.6 22.6L322.7 96 32 96 0 96l0 64 32 0 290.7 0-25.4 25.4L274.7 208 320 253.3l22.6-22.6 80-80z"],
    "rotate-right": [512, 512, ["redo-alt", "rotate-forward"], "f2f9", "M369.1 142.9L312 200l24 24H496V64L472 40 414.4 97.6l0 0c-87.5-87.5-229.3-87.5-316.8 0s-87.5 229.3 0 316.8s229.3 87.5 316.8 0l-45.3-45.3c-62.5 62.5-163.8 62.5-226.3 0s-62.5-163.8 0-226.3s163.8-62.5 226.3 0l0 0z"],
    "utensils": [448, 512, [127860, 61685, "cutlery"], "f2e7", "M64 160V0H32L0 160c0 47.6 34.6 87.1 80 94.7V480v32h64V480 254.7c45.4-7.6 80-47.1 80-94.7L192 0H160V160H144L128 0H96L80 160H64zM448 0C416 0 288 32 288 176V352h96V480v32h64V480 352 240 208 0z"],
    "arrow-up-wide-short": [576, 512, ["sort-amount-up"], "f161", "M320 480h32 32V416H352 320 288v64h32zm0-128h96 32V288H416 320 288v64h32zm0-128H480h32V160H480 320 288v64h32zm0-128H544h32V32H544 320 288V96h32zM151.7 58.5L128 32.4l-23.7 26-80 88L2.8 170.2l47.4 43.1 21.5-23.7L96 162.8V448v32h64V448 162.8l24.3 26.8 21.5 23.7 47.4-43.1-21.5-23.7-80-88z"],
    "chart-pie-simple-circle-dollar": [640, 512, [], "e605", "M496 192c4.6 0 9.3 .2 13.8 .5C494.5 83.7 401 0 288 0c-5.4 0-10.7 .2-16 .6V240H375.2c31.5-29.8 74-48 120.8-48zM320 368c0-28.8 6.9-56 19.2-80H224V32.5C98.9 40.8 0 144.8 0 272C0 404.6 107.5 512 240 512c43.8 0 84.8-11.7 120.1-32.2C335 449.4 320 410.5 320 368zm320 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM472.8 335.4c-.4 .7-.9 1.6-.8 3.6l0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2v10.8 16H480v-16V438.1c-8.6-1.7-16.7-4.3-23.7-6.6l0 0 0 0c-1.7-.6-3.4-1.1-5-1.6L436 425.2l9.5-30.6 15.3 4.8c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3V288 272h32v16 9.4c6.3 .9 12.3 2.3 17.9 3.7l15.5 3.9-7.7 31.1-15.5-3.9c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4z"],
    "balloons": [640, 512, [], "e2e4", "M320 160C320 71.6 248.4 0 160 0S0 71.6 0 160C0 272 128 368 128 368L96 448H224l-32-80s128-96 128-208zM160 96c-35.3 0-64 28.7-64 64H64c0-53 43-96 96-96V96zM448 432l-32 80H544l-32-80s128-96 128-208c0-88.4-71.6-160-160-160c-53.7 0-101.2 26.4-130.2 67c1.4 9.5 2.2 19.2 2.2 29c0 37-11.4 71.6-27.3 101.9C347.7 356.8 448 432 448 432zM416 224H384c0-53 43-96 96-96v32c-35.3 0-64 28.7-64 64z"],
    "mill-sign": [384, 512, [], "e1ed", "M160 250.5L81.9 469.2l60.3 21.5 17.9-50V448h64V416 261.5l35.7-100c3.9-1 8.1-1.6 12.3-1.6c26.5 0 48 21.5 48 48V416v32h64V416 208c0-58.2-44.3-106-101.1-111.5l19.2-53.8L241.9 21.2 208 116.1c-5.7 4-11.1 8.5-16 13.5C171.7 108.9 143.3 96 112 96c-17.2 0-33.5 3.9-48 10.8V96H0V208 416v32H64V416 208c0-26.5 21.5-48 48-48s48 21.5 48 48v42.5z"],
    "bowl-rice": [512, 512, [], "e2eb", "M200 32h16 24V80H216 200 176V32h24zm-24 72h24 16 24v48H216 200 176V104zM56 176H72 96v48H72 56 32V176H56zm192 0h16 24v48H264 248 224V176h24zm-96 0h16 24v48H168 152 128V176h24zM80 104h24 16 24v48H120 104 80V104zm264 72h16 24v48H360 344 320V176h24zm-72-72h24 16 24v48H312 296 272V104zm168 72h16 24v48H456 440 416V176h24zm-72-72h24 16 24v48H408 392 368V104zM272 32h24 16 24V80H312 296 272V32zM0 256H512v24c0 67-39.2 124.9-96 151.8V480H96V431.8C39.2 404.9 0 347 0 280V256z"],
    "timeline-arrow": [640, 512, [], "e29d", "M152 72v48H104V72h48zM104 16H48V72v48 56H96v48H32 0v64H32 192v48H144v56 48 56h56 48 56V440 392 336H256V288H514.7l-33.4 33.4L458.7 344 504 389.3l22.6-22.6 88-88L637.3 256l-22.6-22.6-88-88L504 122.7 458.7 168l22.6 22.6L514.7 224H384V176h48V120 72 16H376 328 272V72v48 56h48v48H160V176h48V120 72 16H152 104zM328 72h48v48H328V72zM248 392v48H200V392h48z"],
    "skull": [512, 512, [128128], "f54c", "M416 398.9c58.5-41.1 96-104.1 96-174.9C512 100.3 397.4 0 256 0S0 100.3 0 224c0 70.7 37.5 133.8 96 174.9V512h96V464 448h32v16 48h64V464 448h32v16 48h96V398.9zM96 256a64 64 0 1 1 128 0A64 64 0 1 1 96 256zm256-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "game-board-simple": [448, 512, ["game-board-alt"], "f868", "M0 32H448V480H0V32zM224 96V256H384V96H224zm0 160H64V416H224V256z"],
    "circle-video": [512, 512, ["video-circle"], "e12b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM128 160H320V352H128V160zM416 336l-64-48V224l64-48V336z"],
    "chart-scatter-bubble": [512, 512, [], "e0e9", "M64 32V64 416H480h32v64H480 32 0V448 64 32H64zm64 272a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm224-80a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM192 176a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM384 64a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "house-turret": [640, 512, [], "e1b4", "M0 0H96V96h32V0h96V96h32V0h96V96v32 6.3L235.5 231.4 224 241v15V512H64V288L0 224V128 96 0zM256 256l96-80 96-80L640 256V512H288 256V480 256zM176 128c-22.1 0-40 17.9-40 40v40h80V168c0-22.1-17.9-40-40-40zM496 272H400v96h96V272z"],
    "banana": [576, 512, [], "e2e5", "M353.2 10.4C411.4 63.1 448 139.3 448 224c0 12.3-.8 24.4-2.3 36.3L329.8 284.7 279 254.6c16.1-33.5 25-71 25-110.6c0-31.4-5.6-61.3-15.9-89l65.1-44.6zm-29 308.2l115.1-24.2 27.7-5.8 12.7-2.7L489 295l80 80 17 17L552 425.9l-17-17-70.8-70.8-43.9 9.2C374.1 444.7 274.9 512 160 512L0 512V400H48c72.9 0 138.7-30.5 185.4-79.4l-22.1-13.1-80.2 41.8-21.3 11.1L87.6 317.8l21.3-11.1 92-48 11.8-6.2 11.5 6.8 39.1 23.2 60.9 36.1z"],
    "hand-holding-skull": [576, 512, [], "e1a4", "M432 128C432 57.3 367.5 0 288 0S144 57.3 144 128c0 47.4 29 88.9 72.2 111L208 288H368l-8.2-49C403 216.9 432 175.4 432 128zM240 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM140 327L68.8 384H0V512H32 224 384h12.4l10.2-7 128-88 33-22.7-45.3-65.9-33 22.7-94.5 65H256V384h32 64 32V320H352 288 224 160 148.8l-8.8 7z"],
    "people-dress": [640, 512, [], "e217", "M160 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H91.4L82 142.8 .2 270.8l53.9 34.4 42-65.8L48 384H88v96 32h64V480 384h16v96 32h64V480 384h40L223.8 239.4l42 65.8 53.9-34.4L238 142.8 228.6 128H211.1 108.9zM480 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H411.4L402 142.8l-81.7 128 53.9 34.4 42-65.8L368 384h40v96 32h64V480 384h16v96 32h64V480 384h40L543.8 239.4l42 65.8 53.9-34.4L558 142.8 548.6 128H531.1 428.9z"],
    "loveseat": [512, 512, ["couch-small"], "f4cc", "M64 32V192H96h32v32 96H384V224 192h32 32V32H64zm0 192H0V480H96V448H416v32h96V224H448 416v32 64 32H384 128 96V320 256 224H64z"],
    "tower-broadcast": [576, 512, ["broadcast-tower"], "f519", "M64 128c0 35.6 8.3 69.3 23.1 99.2L29.7 255.5C10.7 217.1 0 173.8 0 128S10.7 38.9 29.7 .5L87.1 28.8C72.3 58.7 64 92.4 64 128zm38.5 49.7C90 130.8 95.9 83.3 115.8 43l57.4 28.3c-13.3 26.9-17.2 58.5-8.9 89.8c2.2 8.3 5.2 16.2 8.8 23.6L115.8 213c-5.5-11.1-9.9-22.9-13.3-35.3zM460.2 43c5.5 11.1 9.9 22.9 13.3 35.3c12.6 46.9 6.6 94.4-13.3 134.7l-57.4-28.3c13.3-26.9 17.2-58.5 8.9-89.8c-2.2-8.3-5.2-16.2-8.8-23.6L460.2 43zM512 128c0-35.6-8.3-69.3-23.1-99.2L546.3 .5C565.3 38.9 576 82.2 576 128s-10.7 89.1-29.7 127.5l-57.4-28.3C503.7 197.3 512 163.6 512 128zm-160 0c0 23.7-12.9 44.4-32 55.4V480v32H256V480 183.4c-19.1-11.1-32-31.7-32-55.4c0-35.3 28.7-64 64-64s64 28.7 64 64z"],
    "truck-pickup": [640, 512, [128763], "f63c", "M256 32H224V64 192H32v96H0v64H32 65.1c-.7 5.2-1.1 10.6-1.1 16c0 61.9 50.1 112 112 112s112-50.1 112-112c0-5.4-.4-10.8-1.1-16h66.3c-.7 5.2-1.1 10.6-1.1 16c0 61.9 50.1 112 112 112s112-50.1 112-112c0-5.4-.4-10.8-1.1-16H608h32V288H608V192H527.4L409 44l-9.6-12H384 256zM445.4 192H288V96h80.6l76.8 96zM224 368a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm288 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"],
    "block-quote": [448, 512, [], "e0b5", "M448 64H0v64H448V64zm0 160H128v64H448V224zM128 384v64H448V384H128zM64 224H0V448H64V224z"],
    "up-long": [320, 512, ["long-arrow-alt-up"], "f30c", "M160 0L320 160v32H224l0 320H96l0-320H0V160L160 0z"],
    "stop": [384, 512, [9209], "f04d", "M0 64H384V448H0V64z"],
    "code-merge": [448, 512, [], "f387", "M104 56v48H56V56h48zM56 0H0V56v48 56H48V352H0v56 48 56H56h48 56V456 408 352H112V272c26.7 20.1 60 32 96 32h80v48h56 48 56V296 248 192H392 344 288v48H208c-47.6 0-87.1-34.6-94.7-80H160V104 56 0H104 56zm48 408v48H56V408h48zM344 248h48v48H344V248z"],
    "money-check-dollar-pen": [640, 512, ["money-check-edit-alt"], "f873", "M576 64H0V448H326.6l4.4-30.6L564.4 184l0 0L576 172.4V64zM352 288v32H256V288h96zm-96-96H448v32H256V192zm-92-32v6.3c6.6 1.2 16.7 3.2 21.1 4.4l19.3 5.1-10.3 38.7-19.3-5.1c-3.8-1-17.4-3.7-21.7-4.3c-12.2-1.9-22.2-.3-28.6 2.6c-6.3 2.9-7.9 6.2-8.2 8.1c-.6 3.4 0 4.7 .1 5c.3 .5 1 1.8 3.6 3.5c6.1 4.2 15.7 7.2 29.9 11.4l.8 .2 0 0 0 0 0 0c12.1 3.7 28.3 8.5 40.4 17.4c6.7 4.9 13 11.4 16.9 20.5c4 9.1 4.8 19.1 3 29.4c-3.3 19-15.9 32-31.6 38.7c-4.9 2.1-10.1 3.6-15.4 4.6V352v20H124V352v-6.4c-9.5-2.2-22-6.4-29.9-9.1l0 0c-1.7-.6-3.2-1.1-4.4-1.5l-19-6.3 12.6-38 19 6.3c2 .7 4.2 1.4 6.4 2.1c9.5 3.2 20.2 6.9 26.2 7.9c12.8 2 22.7 .7 28.8-1.9c5.5-2.3 7.4-5.3 8-8.8c.7-4 .1-5.9-.2-6.7c-.4-.9-1.3-2.2-3.7-4c-5.9-4.3-15.3-7.5-29.3-11.7l-2.2-.7c-11.7-3.5-27-8.1-38.6-16c-6.6-4.5-13.2-10.7-17.3-19.5c-4.2-9-5.2-18.8-3.4-29c3.2-18.3 16.2-30.9 31.1-37.7c5-2.3 10.4-4 16-5.1v-6V140h40v20zm405 63.8l-41.3 41.3 71 71L640 294.8l-71-71zm-63.9 63.9L363.9 429 352 511.9 434.9 500 576.1 358.7l-71-71z"],
    "up-from-line": [384, 512, ["arrow-alt-from-bottom"], "f346", "M32 192L192 32 352 192v32H256V384H128V224H32V192zm0 224H352h32v64H352 32 0V416H32z"],
    "upload": [512, 512, [], "f093", "M288 352v32H224V352 125.3l-65.4 65.4L136 213.3 90.7 168l22.6-22.6 120-120L256 2.7l22.6 22.6 120 120L421.3 168 376 213.3l-22.6-22.6L288 125.3V352zm32 64V352H512V512H0V352H192v64H320zm112 40a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "hurricane": [384, 512, [], "f751", "M0 208C0 98.5 84.6 8.8 192 .6V96c107.4 8.2 192 97.9 192 207.4s-84.6 199.2-192 207.4V415.4C84.6 407.2 0 317.5 0 208zm288 48A96 96 0 1 0 96 256a96 96 0 1 0 192 0zm-96-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "grid-round-2-plus": [512, 512, [], "e5dc", "M128 224a96 96 0 1 1 0-192 96 96 0 1 1 0 192zm0 256a96 96 0 1 1 0-192 96 96 0 1 1 0 192zM480 128a96 96 0 1 1 -192 0 96 96 0 1 1 192 0zM384 272c13.3 0 24 10.7 24 24v64h64c13.3 0 24 10.7 24 24s-10.7 24-24 24H408v64c0 13.3-10.7 24-24 24s-24-10.7-24-24V408H296c-13.3 0-24-10.7-24-24s10.7-24 24-24h64V296c0-13.3 10.7-24 24-24z"],
    "people-pants": [640, 512, [], "e219", "M160 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H91.4L82 142.8 .2 270.8l53.9 34.4 33.8-53V480v32h64V480 352h16V480v32h64V480 252.2l33.8 53 53.9-34.4L238 142.8 228.6 128H211.1 108.9zM480 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H411.4L402 142.8l-81.7 128 53.9 34.4 33.8-53V480v32h64V480 352h16V480v32h64V480 252.2l33.8 53 53.9-34.4L558 142.8 548.6 128H531.1 428.9z"],
    "mound": [576, 512, [], "e52d", "M142.6 178.3C173.3 127.2 228.4 96 288 96s114.7 31.2 145.4 82.3L576 416H0L142.6 178.3z"],
    "windsock": [512, 512, [], "f777", "M64 32V0H0V32 480v32H64V480 320h64v48l80-16.7V64.7L128 48V96H64V32zm64 112V272H64V144h64zM272 78V338l96-20V98L272 78zM512 288V128l-80-16.7V304.7L512 288z"],
    "circle-half": [512, 512, [], "e110", "M256 0C114.6 0 0 114.6 0 256S114.6 512 256 512V0z"],
    "brake-warning": [640, 512, [], "e0c7", "M96 256a224 224 0 1 1 448 0A224 224 0 1 1 96 256zM344 152V128H296v24V264v24h48V264 152zM296 320v48h48V320H296zM91.1 109C63.8 151.4 48 201.8 48 256s15.8 104.6 43.1 147l13 20.2-40.4 26L50.7 429C18.6 379.1 0 319.7 0 256S18.6 132.9 50.7 83l13-20.2 40.4 26L91.1 109zM589.3 83C621.4 132.9 640 192.3 640 256s-18.6 123.1-50.7 173l-13 20.2-40.4-26 13-20.2c27.3-42.4 43.1-92.8 43.1-147s-15.8-104.6-43.1-147l-13-20.2 40.4-26 13 20.2z"],
    "toilet-portable": [320, 512, [], "e583", "M0 0V64H320V0H0zM24 96H0v24V488v24H48V488v-8H272v8 24h48V488 120 96H296 24zM256 240v64 16H224V304 240 224h32v16z"],
    "compact-disc": [512, 512, [128191, 128192, 128440], "f51f", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm-96-32a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm-64 0c0-88.4 71.6-160 160-160V64C150 64 64 150 64 256H96z"],
    "file-arrow-down": [384, 512, ["file-download"], "f56d", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM216 232V334.1l31-31 17-17L297.9 320l-17 17-72 72-17 17-17-17-72-72-17-17L120 286.1l17 17 31 31V232 208h48v24z"],
    "saxophone-fire": [640, 512, ["sax-hot"], "f8db", "M105.6 .1s-89.6 72.5-89.6 134.4c0 14.7 2.8 28.7 7.9 41.5H79.5c-4.8-8-7.5-17.8-7.5-29c0-16.8 10.5-31.5 31.5-57.4c2.8 3.5 43.4 55.3 43.4 55.3l25.2-29.4c2.1 2.8 3.5 5.6 4.9 8.4c9.1 16.7 8.7 36.7-.2 52.1h55.2c5.1-12.8 7.9-26.8 7.9-41.5c0-51.5-67.2-112-67.2-112s-9.7 8.7-21.7 22.4C128.4 18.6 105.6 .1 105.6 .1zm65.8 338L218.9 256H232h24V208H232 24 0v48H16.9L4.4 309.4C1.5 321.8 0 334.4 0 347.1v3.1C0 439.6 72.4 512 161.8 512c49.4 0 96.1-22.6 126.8-61.4L544 128h96V96L592 64H512l-63 63-8-8-17-17L390.1 136l17 17 8 8L401 175l-8-8-17-17L342.1 184l17 17 8 8L353 223l-8-8-17-17L294.1 232l17 17 8 8L206.6 369.4c-4.2 4.2-10 6.6-16 6.6c-12.5 0-22.6-10.1-22.6-22.6v-2.6c0-4.4 1.2-8.8 3.4-12.6zM144 280a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM88 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "camera-web-slash": [640, 512, ["webcam-slash"], "f833", "M496.1 362.4l124.8 96.9 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7 93.9 72.9C183.2 34.4 247.6 0 320 0C443.7 0 544 100.3 544 224c0 52.2-17.9 100.3-47.9 138.4zM192.8 126.9l25.3 19.6C241.5 115.8 278.4 96 320 96c70.7 0 128 57.3 128 128c0 30.1-10.4 57.7-27.7 79.5l25.3 19.6C467.1 295.9 480 261.5 480 224c0-88.4-71.6-160-160-160c-51.9 0-98 24.7-127.2 62.9zM256 176l25.3 19.6C290 183.7 304.1 176 320 176V144c-26.2 0-49.4 12.6-64 32zM512 499.4V512H128V472l75.5-56.6C139 376 96 305 96 224c0-16.6 1.8-32.7 5.2-48.3L160 222.1c0 .6 0 1.3 0 1.9c0 88.4 71.6 160 160 160c13.6 0 26.8-1.7 39.4-4.9L512 499.4zM324.8 351.9c-1.6 .1-3.2 .1-4.8 .1c-62.1 0-113.8-44.2-125.5-102.8L324.8 351.9z"],
    "folder-medical": [512, 512, [], "e18c", "M512 480H0V32H224l48 64H512V480zM224 192v64H160v64h64v64h64V320h64V256H288V192H224z"],
    "folder-gear": [512, 512, ["folder-cog"], "e187", "M512 96V480H0V32H224l48 64H512zM288 160H224v37.5c-11.2 4-21.5 10-30.4 17.6l-32.5-18.7-32 55.4 32.5 18.7c-1.1 5.7-1.6 11.6-1.6 17.6s.5 11.9 1.6 17.5l-32.5 18.7 32 55.4L193.6 361c8.9 7.6 19.2 13.6 30.4 17.6V416h64V378.5c11.2-4 21.5-10 30.4-17.6l32.5 18.7 32-55.4-32.5-18.7c1-5.7 1.6-11.6 1.6-17.5s-.6-11.9-1.6-17.6l32.5-18.7-32-55.4L318.4 215c-8.9-7.6-19.1-13.6-30.4-17.6V160zM216 288a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"],
    "hand-wave": [512, 512, [], "e1a7", "M352 80c0-26.5-21.5-48-48-48h-8H280V0h16 8c44.2 0 80 35.8 80 80v8 16H352V88 80zM185.4 70.6L162.7 48 208 2.7l22.6 22.6 192 192c3.3 3.3 6.4 6.7 9.4 10.2l0-99.5V96l32 0 16 0 32 0v32V312.3c0 60.2-27.9 116.9-75.5 153.7C385.7 505.3 321 515.7 263 498.7c-28.4-7.1-55.3-21.8-77.6-44.1l-4.9-4.9L73.4 342.6 50.7 320l-9.4-9.4L18.7 288 64 242.7l22.6 22.6 9.4 9.4 22.6 22.6 56 56 18.7-18.7-136-136L34.7 176 80 130.7l22.6 22.6 136 136 18.7-18.7-152-152L82.7 96 128 50.7l22.6 22.6 152 152 18.7-18.7-136-136zM32 344v16 8c0 26.5 21.5 48 48 48h8 16v32H88 80c-44.2 0-80-35.8-80-80v-8V344H32z"],
    "arrow-up-arrow-down": [576, 512, ["sort-up-down"], "e099", "M438.6 454.6l96-96L557.3 336 512 290.7l-22.6 22.6L448 354.7V64 32H384V64 354.7l-41.4-41.4L320 290.7 274.7 336l22.6 22.6 96 96L416 477.3l22.6-22.6zM182.6 57.4L160 34.7 137.4 57.4l-96 96L18.7 176 64 221.3l22.6-22.6L128 157.3V448v32h64V448 157.3l41.4 41.4L256 221.3 301.3 176l-22.6-22.6-96-96z"],
    "caravan": [640, 512, [], "f8ff", "M0 32H416c88.4 0 160 71.6 160 160V352h32 32v64H608l-32 0H288c0 53-43 96-96 96s-96-43-96-96H0V32zM320 352H448V256H416 400V224h16 32V128H320V352zM256 128H64V256H256V128zM192 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "shield-cat": [512, 512, [], "e572", "M256 0l11.6 4.5L475.1 85l19.2 7.4 1.2 20.5c2.9 50-4.9 126.3-37.3 200.9c-32.7 75.2-91.1 150-189.4 192.6L256 512l-12.7-5.5C144.9 463.9 86.5 389.2 53.9 313.9C21.4 239.3 13.6 162.9 16.6 113l1.2-20.5L36.9 85 244.4 4.5 256 0zM224 208l-64-64V272c0 53 43 96 96 96s96-43 96-96V144l-64 64H224zm-8 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "message-slash": [640, 512, ["comment-alt-slash"], "f4a9", "M576 0H64V26.9L48.4 14.8 29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L565.2 416H576V0zM64 416H224v96l144-96h38.2L64 146.4V416z"],
    "bolt": [448, 512, [9889, "zap"], "f0e7", "M16 288L320 0 260.7 197.6 432 224 128 512l59.3-197.6L16 288z"],
    "trash-can-check": [448, 512, [], "e2a9", "M304 0l16 32H448V96H0V32H128L144 0H304zM32 128H416V512H32V128zM337 265l17-17L320 214.1l-17 17-111 111-47-47-17-17L94.1 312l17 17 64 64 17 17 17-17L337 265z"],
    "glass-water": [384, 512, [], "e4f4", "M34.9 0H-.1L3 34.8l39.6 448L45.1 512H74.4 311.8h29.3l2.6-29.2 39.6-448L386.3 0h-35H34.9zM78.2 159.1L69.8 64H316.4l-8.3 94-21.3 10.6c-19.4 9.7-42.2 9.7-61.6 0c-20.9-10.4-45.5-10.4-66.4 0c-19.4 9.7-42.2 9.7-61.6 0l-19-9.5z"],
    "oil-well": [576, 512, [], "e532", "M528.3 61.3c-11.4-42.7-55.3-68-98-56.6L384 17.1l32.8 122.4L308.5 167.5l-6.3-18.1L294.7 128H249.3l-7.5 21.4-13.6 39L96 222.6V184 160H48v24V448H32 0v64H32 544h32V448H544 406.7L340 257.5l-62.2 16.1L305.3 352H238.7L265 277l-74.6 19.3L137.3 448H96V288.8l337.4-87.5 33.5 124.9 46.4-12.4c42.7-11.4 68-55.3 56.6-98L528.3 61.3zM205.1 448l11.2-32H327.7l11.2 32H205.1zM272.3 64l-.3-.9-.3 .9h.6z"],
    "person-simple": [256, 512, [], "e220", "M64 64a64 64 0 1 1 128 0A64 64 0 1 1 64 64zm160 96l8 192H192V512H64V352H24l8-192H224z"],
    "vault": [576, 512, [], "e2c5", "M576 0H0V480H80l16 32h64l16-32H400l16 32h64l16-32h80V0zM224 320a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-240a160 160 0 1 1 0 320 160 160 0 1 1 0-320zM480 221.3V352H448V221.3c-18.6-6.6-32-24.4-32-45.3c0-26.5 21.5-48 48-48s48 21.5 48 48c0 20.9-13.4 38.7-32 45.3z"],
    "mars": [448, 512, [9794], "f222", "M448 32H320L288 64l41.4 41.4L275.8 159c-28.4-19.5-62.7-31-99.8-31C78.8 128 0 206.8 0 304s78.8 176 176 176s176-78.8 176-176c0-37-11.4-71.4-31-99.8l53.6-53.6L416 192l32-32V32zM176 192a112 112 0 1 1 0 224 112 112 0 1 1 0-224z"],
    "toilet": [448, 512, [128701], "f7d8", "M24 0H0V48H24h8V196.9c-1.9 1.4-3.8 2.9-5.6 4.4C10.9 214.5 0 232.9 0 256c0 46.9 14.3 84.1 37 112.5c15.1 18.9 33.3 33.1 51.9 43.9L64 512H384l-24.9-99.6c18.6-10.8 36.8-25 51.9-43.9c22.7-28.4 37-65.5 37-112.5c0-23.1-10.9-41.5-26.4-54.6c-1.8-1.5-3.7-3-5.6-4.4V48h8 24V0H424 24zM384 256l0 .3c0 1-.3 2.6-3.8 5.6c-4.8 4.1-14 9-29.3 13.4C320.5 284 276.1 288 224 288s-96.5-4-126.9-12.8c-15.3-4.4-24.5-9.3-29.3-13.4c-3.5-3-3.8-4.6-3.8-5.6l0-.3 0-.1c0-1 0-2.5 3.8-5.8c4.8-4.1 14-9 29.3-13.4C127.5 228 171.9 224 224 224s96.5 4 126.9 12.8c15.3 4.4 24.5 9.3 29.3 13.4c3.8 3.2 3.8 4.8 3.8 5.8l0 .1zM112 64h32 16V96H144 112 96V64h16z"],
    "plane-circle-xmark": [640, 512, [], "e557", "M192 93.7C192 59.5 221 0 256 0c36 0 64 59.5 64 93.7l0 66.3 85.5 57C354.3 247.8 320 303.9 320 368c0 54.7 24.9 103.5 64 135.8V512L256 480 128 512V448l64-48V320L0 384V288L192 160V93.7zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3L566.6 320 544 297.4l-11.3 11.3L496 345.4l-36.7-36.7L448 297.4 425.4 320l11.3 11.3L473.4 368l-36.7 36.7L425.4 416 448 438.6l11.3-11.3L496 390.6l36.7 36.7L544 438.6 566.6 416l-11.3-11.3L518.6 368l36.7-36.7z"],
    "yen-sign": [320, 512, [165, "cny", "jpy", "rmb", "yen"], "f157", "M.7 32L106 224H48 16v64H48h80v32H48 16v64H48h80v64 32h64V448 384h80 32V320H272 192V288h80 32V224H272 214L319.3 32h-73L160 189.4 73.7 32H.7z"],
    "gear-code": [512, 512, [], "e5e8", "M200 0H312l17.2 78.4c15.8 6.5 30.6 15.1 44 25.4l76.5-24.4 56 97-59.4 54.1c1.1 8.3 1.7 16.8 1.7 25.4s-.6 17.1-1.7 25.4l59.4 54.1-56 97-76.5-24.4c-13.4 10.3-28.2 18.9-44 25.4L312 512H200l-17.2-78.4c-15.8-6.5-30.6-15.1-44-25.4L62.3 432.5l-56-97 59.4-54.1C64.6 273.1 64 264.6 64 256s.6-17.1 1.7-25.4L6.3 176.5l56-97 76.5 24.4c13.4-10.3 28.2-18.9 44-25.4L200 0zm87.8 162.6l2.6-15.8-31.6-5.3-2.6 15.8-32 192-2.6 15.8 31.6 5.3 2.6-15.8 32-192zM187.3 227.3L198.6 216 176 193.4l-11.3 11.3-40 40L113.4 256l11.3 11.3 40 40L176 318.6 198.6 296l-11.3-11.3L158.6 256l28.7-28.7zm160-22.6L336 193.4 313.4 216l11.3 11.3L353.4 256l-28.7 28.7L313.4 296 336 318.6l11.3-11.3 40-40L398.6 256l-11.3-11.3-40-40z"],
    "notes": [512, 512, [], "e202", "M480 32H96V416H352V320 288h32 96V32zM384 352v45.7V416l96-96H461.7 416 384v32zM296 464H48l0-312V128L0 128v24V488v24H24 296h24V464H296z"],
    "ruble-sign": [384, 512, [8381, "rouble", "rub", "ruble"], "f158", "M96 32H64V64 256H0v64H64v32H0v64H64v64h64V416H320V352H128V320H240c79.5 0 144-64.5 144-144s-64.5-144-144-144H96zM240 256H128V96H240c44.2 0 80 35.8 80 80s-35.8 80-80 80z"],
    "trash-undo": [448, 512, ["trash-arrow-turn-left"], "f895", "M304 0l16 32H448V96H0V32H128L144 0H304zM32 128H416L392 512H56L32 128zM209 241l17-17L192 190.1l-17 17-64 64-17 17 17 17 64 64 17 17L225.9 352l-17-17-23-23H240c22.1 0 40 17.9 40 40v40 24h48V392 352c0-48.6-39.4-88-88-88H185.9l23-23z"],
    "champagne-glass": [320, 512, ["glass-champagne"], "f79e", "M111.1 128h97.7l-8.7-64H119.9l-8.7 64zm173.4 81.3c8.8 64.5-32.8 122.9-92.5 138.6V448h48 32v64H240 160 80 48V448H80h48V347.9C68.2 332.3 26.7 273.8 35.5 209.3L64 0H256l28.5 209.3z"],
    "objects-align-center-horizontal": [512, 512, [], "e3bc", "M280 0H232V64H32V224H232v64H96V448H232v64h48V448H416V288H280V224H480V64H280V0z"],
    "sun": [512, 512, [9728], "f185", "M256 73.1L150 0 126.7 126.7 0 150 73.1 256 0 362l126.7 23.3L150 512l106-73.1L362 512l23.3-126.7L512 362 438.9 256 512 150 385.3 126.7 362 0 256 73.1zM352 256a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm-224 0a128 128 0 1 1 256 0 128 128 0 1 1 -256 0z"],
    "trash-can-slash": [640, 512, ["trash-alt-slash"], "e2ad", "M231.2 17.7C236.6 6.8 247.7 0 259.8 0H380.2c12.1 0 23.2 6.8 28.6 17.7L416 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H153l41.2 32H512V374.7l108.9 84.6 19 14.7-29.4 37.9-19-14.7L19 52.7 0 38 29.4 .1l19 14.7L97.9 53.2C102.3 40.8 114.1 32 128 32h96l7.2-14.3zM432 312.6V208c0-8.8-7.2-16-16-16s-16 7.2-16 16v79.8l32 24.8zm-96-74.5V208c0-8.8-7.2-16-16-16s-16 7.2-16 16v5.2l32 24.8zM128 448V196.9l80 63V432c0 8.8 7.2 16 16 16s16-7.2 16-16V285.1l64 50.4V432c0 8.8 7.2 16 16 16s16-7.2 16-16V360.7l64 50.4V432c0 8.8 7.2 16 16 16c7.5 0 13.7-5.1 15.5-12l66.3 52.2C486.1 502.7 468.1 512 448 512H192c-35.3 0-64-28.7-64-64z"],
    "screen-users": [640, 512, ["users-class"], "f63d", "M32 0H64 576h32V32 248.4c-17-15.2-39.4-24.4-64-24.4V64H96V224c-24.6 0-47 9.2-64 24.4V32 0zm0 320a64 64 0 1 1 128 0A64 64 0 1 1 32 320zm224 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm288-64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM416 512H224l32-96H384l32 96zM32 416H160l32 96H0l32-96zm608 96H448l32-96H608l32 96z"],
    "guitar": [512, 512, [], "f7a6", "M376 64l-8.9 35.7-82.5 82.5c-45.1-29.4-99.3-30.2-131 1.6c-11 11-18 24.6-21.4 39.6c-3.7 16.6-19.1 30.7-36.1 31.6c-25.6 1.3-49.3 10.7-67.3 28.6C-16 328.4-7.6 409.4 47.5 464.5s136.1 63.5 180.9 18.7c17.9-17.9 27.4-41.7 28.6-67.3c.9-17 15-32.3 31.6-36.1c15-3.4 28.6-10.5 39.6-21.4c31.8-31.8 31-85.9 1.6-131l82.5-82.5L448 136l64-72L448 0 376 64zM208 256a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "square-arrow-left": [448, 512, ["arrow-square-left"], "f33a", "M0 32L0 480l448 0 0-448L0 32zM87 239L199 127l17-17L249.9 144l-17 17-71 71L344 232l24 0 0 48-24 0-182.1 0 71 71 17 17L216 401.9l-17-17L87 273l-17-17 17-17z"],
    "square-8": [448, 512, [], "e25d", "M0 32H448V480H0V32zm232 96H216c-39.8 0-72 32.2-72 72c0 15.7 5 30.1 13.5 42c-18 14.7-29.5 37-29.5 62c0 44.2 35.8 80 80 80h32c44.2 0 80-35.8 80-80c0-25-11.5-47.4-29.5-62c8.5-11.8 13.5-26.3 13.5-42c0-39.8-32.2-72-72-72zm-16 96c-13.2 0-24-10.8-24-24s10.7-24 24-24h16c13.3 0 24 10.7 24 24s-10.7 24-24 24c0 0 0 0 0 0H216s0 0 0 0zm0 48c0 0 0 0 0 0h16c0 0 0 0 0 0h8c17.7 0 32 14.3 32 32s-14.3 32-32 32H208c-17.7 0-32-14.3-32-32s14.3-32 32-32h8z"],
    "face-smile-hearts": [640, 512, [], "e390", "M519.2 95.2L491.6 67.6c-1.8-1.8-3.4-3.7-4.8-5.8c-4.4-6.5-6.8-14.2-6.8-22.2C480 17.7 497.7 0 519.6 0c10.5 0 20.6 4.2 28 11.6L560 24l12.4-12.4C579.8 4.2 589.9 0 600.4 0C622.3 0 640 17.7 640 39.6c0 10.5-4.2 20.6-11.6 28L560 136 519.2 95.2zm44.5 82.3c8 24.7 12.3 51.1 12.3 78.5c0 34.8-6.9 68-19.5 98.2c-11-6.6-23.8-10.2-36.9-10.2c-39.5 0-71.6 32.1-71.6 71.6c0 18.4 7.1 36.1 19.8 49.4c-41.8 29.6-92.8 47-147.8 47c-61.2 0-117.4-21.5-161.4-57.3L171 442.2c13.4-13.4 21-31.6 21-50.6c0-39.5-32.1-71.6-71.6-71.6c-14.5 0-28.6 4.4-40.4 12.5c-1.8-1.2-3.6-2.3-5.4-3.4C67.7 306 64 281.4 64 256C64 114.6 178.6 0 320 0c46.7 0 90.5 12.5 128.2 34.4c-.1 1.7-.2 3.5-.2 5.2c0 19 7.5 37.2 21 50.6l68.4 68.4L560 181.3l3.7-3.7zM89.2 366.8l3.2-3.2c7.4-7.4 17.5-11.6 28-11.6c21.9 0 39.6 17.7 39.6 39.6c0 10.5-4.2 20.6-11.6 28L135 433 80 488 11.6 419.6C4.2 412.2 0 402.1 0 391.6C0 369.7 17.7 352 39.6 352c10.5 0 20.6 4.2 28 11.6L80 376l9.2-9.2zm403.7 78l-1.2-1.2c-7.4-7.4-11.6-17.5-11.6-28c0-21.9 17.7-39.6 39.6-39.6c8.2 0 16.1 2.5 22.7 7.1c1.9 1.3 3.7 2.8 5.3 4.5L560 400l12.4-12.4c7.4-7.4 17.5-11.6 28-11.6c21.9 0 39.6 17.7 39.6 39.6c0 10.5-4.2 20.6-11.6 28L560 512l-67.2-67.2zM320 400c71.6 0 113.7-47.7 126.3-72.8l-28.6-14.3C408.9 330.3 376.4 368 320 368s-88.9-37.7-97.7-55.2l-28.6 14.3C206.3 352.3 248.4 400 320 400zM196.8 237.6c21.6-28.8 64.8-28.8 86.4 0l25.6-19.2c-34.4-45.9-103.2-45.9-137.6 0l25.6 19.2zm246.4 0l25.6-19.2c-34.4-45.9-103.2-45.9-137.6 0l25.6 19.2c21.6-28.8 64.8-28.8 86.4 0z"],
    "brackets-square": [448, 512, ["brackets"], "f7e9", "M416 32h32V64 448v32H416 320 288V416h32 64V96H320 288V32h32 96zM32 32h96 32V96H128 64V416h64 32v64H128 32 0V448 64 32H32z"],
    "laptop-arrow-down": [640, 512, [], "e1c6", "M96 32H64V64 352h64V96H256V32H96zM512 96V352h64V64 32H544 384V96H512zM0 384v48l48 48H592l48-48V384H0zM344 56V32H296V56 238.1l-39-39-17-17L206.1 216l17 17 80 80 17 17 17-17 80-80 17-17L400 182.1l-17 17-39 39V56z"],
    "hockey-stick-puck": [640, 512, [], "e3ae", "M96 352V480v32l32 0 32 0 64 0h19.8l8.8-17.7 224-448L419.4 17.7 252.2 352H96zM0 352V512H64V352H0zm640 64H384v96H640V416z"],
    "house-tree": [640, 512, [], "e1b3", "M640 464v48H416V256 241l-11.5-9.6L277 125.1 416 0 576 144v48H512l96 112v48H544l96 112zM0 256L192 96 384 256V512H0V256zm240 16H144v96h96V272z"],
    "signal-fair": [640, 512, ["signal-2"], "f68d", "M224 320V288H160v32V480v32h64V480 320zM96 416V384H32v32 64 32H96V480 416z"],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-80c-83 0-151.2-63.1-159.2-144H415.2c-8 80.9-76.2 144-159.2 144zM144.4 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm148.4 29.6l-25.6-19.2c34.4-45.9 103.2-45.9 137.6 0l-25.6 19.2c-21.6-28.8-64.8-28.8-86.4 0z"],
    "circle-dollar": [512, 512, ["dollar-circle", "usd-circle"], "f2e8", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm20.2-362.6c18.3 2.6 36.2 7 54.1 11.5l-10.5 41.9c-16.3-4.1-32.5-8.1-49.1-10.6c-16.4-2.4-30.1-.5-39.3 3.5c-11 4.7-18 16.2-6.3 23.7c8.5 5.4 21.5 9.2 39.4 14.3l.8 .2c15.6 4.4 35.5 10.1 50.4 20.3c19.4 13.3 28.5 34.9 24.2 58.1c-4.1 22.4-19.7 37.1-38.4 44.7c-7.8 3.2-16.3 5.2-25.2 6.2V400H233V361.1c-11.7-2.6-26.7-7.4-36.6-10.6l0 0c-6.6-2.1-13.1-4.2-19.7-6.2c-2.3-.7-4.5-1.4-6.8-2.1l12.9-41.2c2.2 .7 4.4 1.4 6.6 2.1c7.3 2.3 14.6 4.6 21.9 6.9l0 0c12.1 3.9 26.4 8.4 34.5 9.7c17 2.5 30.6 1 39.5-2.6c12-4.8 17.7-19.1 5.9-27.1c-10.1-6.9-22.6-10.3-34.5-13.5c-2.3-.6-4.5-1.2-6.8-1.9c-15.1-4.3-34-9.6-48.2-18.7c-19.5-12.5-29.4-33.3-25.2-56.4c3.9-21.5 19.9-35.8 37.8-43.5c5.8-2.5 12.1-4.4 18.6-5.7V112h43.2v37.4z"],
    "horse-head": [640, 512, [], "f7ab", "M64 512V319.2c0-109.5 69.7-207 173.4-242.3L416 16l32 48L400 96l104 64 72 192-64 64H432l-58.6-70.4c-11.6 4.1-24.1 6.4-37.1 6.4H336l0 0c-6.3 0-12.5-.5-18.6-1.5c-3.6-.6-7.2-1.4-10.7-2.3l0 0c-28.9-7.8-53.1-26.8-67.8-52.2l-8-13.8-27.7 16 8 13.8c24 41.5 68.3 70 119.3 71.9L416 512H64zM392 224a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "arrows-repeat": [512, 512, ["repeat-alt"], "f364", "M0 224v32H64V224 160H338.7l-25.4 25.4L290.7 208 336 253.3l22.6-22.6 80-80L461.3 128l-22.6-22.6-80-80L336 2.7 290.7 48l22.6 22.6L338.7 96H32 0v32 96zm512 64V256H448v32 64H173.3l25.4-25.4L221.3 304 176 258.7l-22.6 22.6-80 80L50.7 384l22.6 22.6 80 80L176 509.3 221.3 464l-22.6-22.6L173.3 416H480h32V384 288z"],
    "bore-hole": [512, 512, [], "e4c3", "M288 0H224V32 296.6c-19.1 11.1-32 31.7-32 55.4c0 35.3 28.7 64 64 64s64-28.7 64-64c0-23.7-12.9-44.4-32-55.4V32 0zM160 128H0V512H512V128H352V352c0 53-43 96-96 96s-96-43-96-96V128z"],
    "industry": [576, 512, [], "f275", "M160 32H32V224 384v96H544V224 128L352 224V128L160 224V32z"],
    "image-polaroid": [448, 512, [], "f8c4", "M0 32H448V480H0V32zM64 96V352H384V96H64zm64 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM352 320H208 160 96V288l56-64 30.2 34.5L256 160l96 128v32z"],
    "wave-triangle": [640, 512, [], "f89a", "M175.6 10.1l26 34.7 262 349.3 102.5-141 18.8-25.9 51.8 37.6-18.8 25.9-128 176-25.5 35-26-34.7-262-349.3L73.9 258.8 55.1 284.7 3.3 247.1l18.8-25.9 128-176 25.5-35z"],
    "person-running-fast": [512, 512, [], "e5ff", "M368 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM224 96H210.7l-9.4 9.4-48 48-8 8 45.3 45.3 8-8L237.3 160h27.7l-31.3 94c-9.3 28 1.7 58.8 26.8 74.5l86.2 53.9-9.4 32.8-16 56L309.6 512h66.6l6.6-23.2 16-56 16-56 6.6-23.2L401 340.9 334 299l29-77.4 24.3 48.6 8.8 17.7H416h48 32V224H464 435.8l-39.2-78.3-5.4-10.9-11.3-4.5-80-32L294.2 96H288 224zM205.5 310.7L187.2 352H128 96v64h32 80 20.8l8.4-19L253 361.6l-9.5-6c-17.5-10.9-30.5-26.8-37.9-44.9zM16 95.8H0v32H16 128h16v-32H128 16zm-16 64v32H16 80 96v-32H80 16 0zm16 64H0v32H16 144h16v-32H144 16z"],
    "circle-down": [512, 512, [61466, "arrow-alt-circle-down"], "f358", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM384 256H304V128H208V256H128v32L256 416 384 288V256z"],
    "grill": [448, 512, [], "e5a3", "M0 32H448V96c0 89.8-52.9 167.3-129.2 203l55.2 128.9 4 9.3 9.5 22.1-44.1 18.9-9.5-22.1-4-9.3L316.7 416H160c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c3.4 0 6.8 .3 10.1 .8L129.2 299C52.9 263.3 0 185.8 0 96V32zM151.8 368H296.2l-22.9-53.4c-15.9 3.6-32.3 5.4-49.3 5.4s-33.4-1.9-49.3-5.4L151.8 368zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"],
    "arrows-turn-to-dots": [512, 512, [], "e4c1", "M265.4 25.4L288 2.7 333.3 48 310.6 70.6 285.3 96 480 96h32v32 96 32l-64 0V224 160l-162.7 0 25.4 25.4L333.3 208 288 253.3l-22.6-22.6-80-80L162.7 128l22.6-22.6 80-80zm-18.7 256l80 80L349.3 384l-22.6 22.6-80 80L224 509.3 178.7 464l22.6-22.6L226.7 416 64 416v64 32H0V480 384 352H32l194.7 0-25.4-25.4L178.7 304 224 258.7l22.6 22.6zM384 384a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM64 192A64 64 0 1 1 64 64a64 64 0 1 1 0 128z"],
    "chart-mixed": [512, 512, ["analytics"], "f643", "M340 217L500 89 460 39 319.4 151.5 211.2 70.4 191.4 55.5 172 71 12 199l40 50L192.6 136.5l108.2 81.1 19.8 14.9L340 217zm-180 7V480h64V224H160zM32 320V480H96V320H32zm320-32H288V480h64V288zm64-64V480h64V224H416z"],
    "florin-sign": [384, 512, [], "e184", "M314.7 32c-38.8 0-73.7 23.3-88.6 59.1L170.7 224H32v64H144L98.9 396.3c-5 11.9-16.6 19.7-29.5 19.7H0v64H69.3c38.8 0 73.7-23.3 88.6-59.1L213.3 288H352V224H240l45.1-108.3c5-11.9 16.6-19.7 29.5-19.7H384V32H314.7z"],
    "arrow-down-short-wide": [576, 512, ["sort-amount-desc", "sort-amount-down-alt"], "f884", "M320 32h32 32V96H352 320 288V32h32zm0 128h96 32v64H416 320 288V160h32zm0 128H480h32v64H480 320 288V288h32zm0 128H544h32v64H544 320 288V416h32zM151.7 469.5l-23.7 26-23.7-26-80-88L2.8 357.8l47.4-43 21.5 23.7L96 365.2V80 48h64V80 365.2l24.3-26.8 21.5-23.7 47.4 43-21.5 23.7-80 88z"],
    "less-than": [384, 512, [62774], "3c", "M384 64.5l-5 2.2L19 226.8 0 235.2v41.6l19 8.4 360 160 5 2.2v-70L110.8 256 384 134.6v-70z"],
    "display-code": [576, 512, ["desktop-code"], "e165", "M0 0H576V416H336l10.7 32H416h32v64H416 160 128V448h32 69.3L240 416H0V0zM64 64V352H512V64H64zM249 177l-31 31 31 31 17 17L232 289.9l-17-17-48-48-17-17 17-17 48-48 17-17L265.9 160l-17 17zM361 143l48 48 17 17-17 17-48 48-17 17L310.1 256l17-17 31-31-31-31-17-17L344 126.1l17 17z"],
    "face-drooling": [512, 512, [], "e372", "M384 477.8c76.5-44.3 128-127 128-221.8C512 114.6 397.4 0 256 0S0 114.6 0 256S114.6 512 256 512c33.9 0 66.4-6.6 96-18.6V370.9c-9.7 6.4-20.3 12.2-32 16.9V448v16H288V448 397.1c-10.1 1.9-20.8 2.9-32 2.9c-67 0-113.8-36.7-140.5-70l-10-12.5 25-20 10 12.5c22.8 28.5 61.3 58 115.5 58s92.7-29.5 115.5-58l10-12.5 25 20-10 12.5c-3.8 4.7-7.9 9.5-12.5 14.2V477.8zM200 176c-39.2 0-58.3 25.6-64.8 45.1l-30.4-10.1c9.5-28.5 38.4-66.9 95.2-66.9v32zm176.8 45.1C370.3 201.6 351.2 176 312 176V144c56.8 0 85.7 38.4 95.2 66.9l-30.4 10.1z"],
    "oil-temperature": [576, 512, ["oil-temp"], "f614", "M256 0h32 64 32V64H352 320V96h32 32v64H352 320v70.7c28.3 12.3 48 40.5 48 73.3c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-32.8 19.7-61 48-73.3V128 32 0zM400 304l0-1.3c13.7-2.2 26.9-6.8 38-11.8c14.9-6.8 26.9-15.4 40-24.7l0 0 2.1-1.5 2.1 1.5 0 0c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9c-1.4 0-2.7 0-4-.1c12.6-18.1 20-40.2 20-63.9zM288 416c3.3 0 6.5-.1 9.7-.4c10.3 7.2 20.4 13.9 32.3 19.3c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l0 0 2.1-1.5 2.1 1.5 0 0c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 502.1 31.9 512 0 512V448c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l2.1-1.5 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c11.9-5.4 22-12 32.3-19.3c3.2 .3 6.4 .4 9.7 .4zm-96-48c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 358.1 31.9 368 0 368V304c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7l2.1-1.5 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c11.1 5 24.2 9.7 38 11.8l0 1.3c0 23.8 7.4 45.8 20 63.9c-1.3 0-2.7 .1-4 .1z"],
    "square-question": [448, 512, ["question-square"], "f2fd", "M448 32H0V480H448V32zM136 184c0-30.9 25.1-56 56-56h56.9c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L248 264.4V288H200V264 250.5 236.6l12.1-6.9 44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H192c-4.4 0-8 3.6-8 8l0 6.5-48 0V184zm64 136h48v48H200V320z"],
    "air-conditioner": [576, 512, [], "f8f4", "M576 0H0V224H576V0zM80 128H496h16v32H496 80 64V128H80zM256 256H192V416c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-11.8 6.4-22.2 16-27.7l-32-55.4C83.4 349.4 64 380.4 64 416c0 53 43 96 96 96s96-43 96-96V256zm64 128c0 53 43 96 96 96s96-43 96-96c0-35.6-19.4-66.6-48-83.1l-32 55.4c9.6 5.6 16 15.9 16 27.7c0 17.7-14.3 32-32 32s-32-14.3-32-32V256H320V384z"],
    "angle-down": [448, 512, [8964], "f107", "M224 365.3l22.6-22.6 160-160L429.3 160 384 114.7l-22.6 22.6L224 274.7 86.6 137.4 64 114.7 18.7 160l22.6 22.6 160 160L224 365.3z"],
    "mountains": [640, 512, [9968], "f6fd", "M256 32L0 416v64H320 512 640V416L480 160 412.9 267.4 256 32z"],
    "omega": [448, 512, [], "f67a", "M224 96C135.6 96 64 167.6 64 256c0 59.2 32.1 110.9 80 138.6l16 9.2v18.5V448v32H128 32 0V416H32 67.2C25.8 375.4 0 318.7 0 256C0 132.3 100.3 32 224 32s224 100.3 224 224c0 62.7-25.8 119.4-67.2 160H416h32v64H416 320 288V448 422.3 403.9l16-9.2c47.9-27.7 80-79.4 80-138.6c0-88.4-71.6-160-160-160z"],
    "car-tunnel": [512, 512, [], "e4de", "M256 0C114.6 0 0 114.6 0 256V512H96V448 320h28.4l30.2-80.4 5.8-15.6H177 336h16.8l5.7 15.8L387.7 320H416V448l0 64h96V256C512 114.6 397.4 0 256 0zm96 512V448H160v64H352zM319.2 272H193.6l-18 48h161l-17.5-48zM168 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm200-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "person-dolly-empty": [512, 512, [], "f4d1", "M80 96A48 48 0 1 0 80 0a48 48 0 1 0 0 96zM0 480l0 32 64 0 0-32v0V410.5l-64-64L0 480zM32 128H0v32V274.7c0 17 6.7 33.3 18.7 45.3l22.6 22.6 56.7 56.7 6.3 37.9 4 24 4 24 0 0 4 24 .5 2.7h64.9l-2.2-13.3-4-24 0 0-4-24-4-24-8-48-1.7-10.1-7.3-7.3L96 306.7V241.7l21.4 32.1 9.5 14.3H144h79.3l27.1 108.3c-16 11.6-26.3 30.5-26.3 51.7c0 35.3 28.7 64 64 64c32.3 0 59.1-24 63.4-55.1l134.4-33.6 23.3-5.8-11.6-46.6-23.3 5.8L339.7 410.3c-10-13.7-25.3-23.3-42.8-25.7L247.3 186.2l-5.8-23.3-46.6 11.6 5.8 23.3 6.5 26.2H161.1l-54.5-81.7L97.1 128H80 32zM272 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "pan-food": [640, 512, [129368], "e42b", "M320 512A256 256 0 1 0 320 0a256 256 0 1 0 0 512zm0-448c39.8 0 72 32.2 72 72v8H248v-8c0-39.8 32.2-72 72-72zM244.3 200l-14.1 14.1-32 32L184 260.3 155.7 232l14.1-14.1 32-32L216 171.7 244.3 200zM296 224a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM416 360a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM238.6 296l-8 8 16 16H280c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56V342.6l-16-16-8 8L177.4 312l11.3-11.3 8-8 8-8L216 273.4 238.6 296zM464 176l11 11c13.4 13.4 21 31.6 21 50.6v4.8c0 18.7-8.5 36.4-23.1 48.1C462 299.2 448.4 304 434.4 304l-4.1 0c-19.4 0-38-7.7-51.8-21.4L368 272l96-96zM48 160H0v24V328v24H48V328 184 160zm592 24V160H592v24V328v24h48V328 184z"],
    "head-side-cough": [640, 512, [], "e061", "M0 224.3C0 100.4 100.4 0 224.3 0H256C358.1 0 441.6 79.7 447.7 180.3L505 252l7 8.8V272v16 32H480 448v32L320 368v40l128 8v64H320v32H288 256 96 64V480 381.2C23 339.3 0 283 0 224.3zm352-.3a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM464 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm152-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM592 480a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM552 312a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40-24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM552 408a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"],
    "grip-lines": [448, 512, [], "f7a4", "M0 288l0 64 448 0 0-64L0 288zM0 160l0 64 448 0 0-64L0 160z"],
    "thumbs-down": [512, 512, [128078, 61576], "f165", "M240 444.3V480h96V444.3c0-38.1-9-75.1-25.8-108.3H464h48V240H496V160H472V88H448V32H400 280 265.5l-12.1 8.1-72 48L160 102.3V128v64 96 23.1l18 14.4 7.9 6.4c34.2 27.3 54 68.7 54 112.4zM128 384V96H0V384H128z"],
    "user-lock": [640, 512, [], "f502", "M224 0a128 128 0 1 1 0 256A128 128 0 1 1 224 0zM384 304l0 208H0L64 304H384zm144-64c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H416V320h32V272z"],
    "arrow-right-long": [512, 512, ["long-arrow-right"], "f178", "M489.4 233.4L512 256l-22.6 22.6-128 128-22.6 22.6L293.5 384l22.6-22.6L389.5 288 32 288 0 288l0-64 32 0 357.5 0-73.4-73.4L293.5 128l45.3-45.3 22.6 22.6 128 128z"],
    "tickets-airline": [640, 512, [], "e29b", "M96 32V384H640V256c-26.5 0-48-21.5-48-48s21.5-48 48-48V32H96zM528 96a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-16 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm16 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM256 96h48l58.7 88H424c13.3 0 24 10.7 24 24s-10.7 24-24 24H362.7L304 320H256l33.5-88H242.3L224 264H192l16-56-16-56h32l18.3 32h47.2L256 96zM48 120V96H0v24V456v24H24 520h24V432H520 48V120z"],
    "anchor-circle-xmark": [640, 512, [], "e4ac", "M320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm21.1 80C367 158.8 384 129.4 384 96c0-53-43-96-96-96s-96 43-96 96c0 33.4 17 62.8 42.9 80H224 192v64h32 32V448H128V352h64L96 256 0 352H64V480v32H96 288 394.8c-23.3-16.4-42.5-38.4-55.6-64H320V368.5l0-.5 0-.5V240h32 23.2c2.8-2.7 5.8-5.3 8.8-7.8V176H352 341.1zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7L518.6 368l36.7 36.7L566.6 416 544 438.6l-11.3-11.3L496 390.6l-36.7 36.7L448 438.6 425.4 416l11.3-11.3L473.4 368l-36.7-36.7L425.4 320 448 297.4l11.3 11.3L496 345.4l36.7-36.7L544 297.4 566.6 320l-11.3 11.3z"],
    "ellipsis": [448, 512, ["ellipsis-h"], "f141", "M16 304l0-96 96 0 0 96-96 0zm160 0l0-96 96 0 0 96-96 0zm160-96l96 0 0 96-96 0 0-96z"],
    "nfc-slash": [640, 512, [], "e1fc", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L544 399.6V32H96V51.8l-47.6-37zM160 101.4V96h16 64 16v32H240 194.2L160 101.4zM301.8 211.6c.7-.3 1.4-.6 2.2-.8V112 96h16H464h16v16V349.9L448 325V128H336v82.7c18.6 6.6 32 24.4 32 45.3c0 2.2-.2 4.4-.4 6.6l-65.7-51zM487.4 480l-81.2-64H176 160V400 222.1L96 171.6V480H487.4zM192 384H365.5L192 247.3V384z"],
    "chess-pawn": [320, 512, [9823], "f443", "M215.5 224c29.2-18.4 48.5-50.9 48.5-88c0-57.4-46.6-104-104-104S56 78.6 56 136c0 37.1 19.4 69.6 48.5 88H96 64v64H92.4L80 400H240L227.6 288H256V224H224h-8.5zM16 512H304V480l-48-48H64L16 480v32z"],
    "kit-medical": [576, 512, ["first-aid"], "f479", "M0 32V480H96V32H0zm128 0V480H448V32H128zM576 480V32H480V480h96zM256 160h64v64h64v64H320v64H256V288H192V224h64V160z"],
    "grid-2-plus": [512, 512, [], "e197", "M224 32V224H32V32H224zm0 256V480H32V288H224zM288 32H480V224H288V32zM408 272v24 64h64 24v48H472 408v64 24H360V472 408H296 272V360h24 64V296 272h48z"],
    "bells": [640, 512, [], "f77f", "M293.1 41.2c-71.1 42-104.5 130-75.2 210.4l35.3 97.1-11.3 44.4L0 305l12.9-35.6 67.2-48 36.4-100c25.7-70.5 103.6-106.8 174-81.2c.9 .3 1.7 .6 2.5 1zM97.5 374.6l117.9 42.9c-11.3 18.3-31.5 30.4-54.5 30.4c-35.4 0-64.1-28.7-64.1-64c0-3.2 .2-6.3 .7-9.3zm181.3 94.5l-13.7-37.6L286.7 347 248 240.6c-27-74.2 11.2-156.2 85.4-183.2s156.3 11.3 183.3 85.5l38.7 106.4 70.9 50.9L640 337.7 278.8 469.1zm150-16.3L545 410.6c.1 1.8 .2 3.6 .2 5.4c0 35.4-28.7 64-64.1 64c-21.6 0-40.8-10.7-52.4-27.1z"],
    "person-through-window": [640, 512, [], "e5a9", "M288 64v77.9L143.5 228.6 128 237.9V256l0 128v0H64V64l224 0zm64 0l224 0V384H508.3l-3.7-4.5-80-96L415 272H400l-78.6 0-35.3-54.4 50.3-30.2 15.5-9.3V160l0-96zm73 320H379.2l42.7 64H576h64V384 64 0H576 64 0V64 384v64H64 308.2l24.9 37.3 17.8 26.6 53.3-35.5-17.8-26.6L310.5 336l74.6 0 40 48zm-159.5 0H192v0l0-109.9 .2-.1 73.3 110zM192 128a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "toolbox": [512, 512, [129520], "f552", "M152 32H128V56v72H80L0 208v96H128V288 256h64v32 16H320V288 256h64v32 16H512V208l-80-80H384V56 32H360 152zm184 96H176V80H336v48zM0 480H512V336H384v16 32H320V352 336H192v16 32H128V352 336H0V480z"],
    "envelope-dot": [576, 512, ["envelope-badge"], "e16f", "M496 0a80 80 0 1 1 0 160A80 80 0 1 1 496 0zM0 64H385.1c-.7 5.2-1.1 10.6-1.1 16c0 47 29 87.3 70 103.9L256 320 0 144V64zM274.1 346.4L498.7 192c4.5-.1 8.9-.5 13.3-1.1V448H0V182.8L237.9 346.4 256 358.8l18.1-12.5z"],
    "hands-holding-circle": [640, 512, [], "e4fb", "M320 0a128 128 0 1 1 0 256A128 128 0 1 1 320 0zM80 64v40 8 32 80 66.7l84.1 84.1L205.8 347l-36.4-36.4L146.7 288l-9.4-9.4L114.7 256 160 210.7l22.6 22.6 9.4 9.4 22.6 22.6 64 64 9.4 9.4V352v64 32 32 32H256 160 146.7l-9.4-9.4-128-128L0 365.3V352 224 160 128 104 64H80zm480 0h80v40 24 32 64V352v13.3l-9.4 9.4-128 128-9.4 9.4H480 384 352V480 448 416 352 338.7l9.4-9.4 64-64L448 242.7l9.4-9.4L480 210.7 525.3 256l-22.6 22.6-9.4 9.4-22.6 22.6L434.2 347l41.7 27.8L560 290.7V224 144 112v-8V64z"],
    "bug": [512, 512, [], "f188", "M256 0c-53 0-96 43-96 96v32H352V96c0-53-43-96-96-96zM86.6 105.4L64 82.7 18.7 128l22.6 22.6L96 205.3V256H32 0v64H32 96c0 24.2 5.4 47.2 15 67.7L57.4 441.4 34.7 464 80 509.3l22.6-22.6 47.1-47.1c24.5 21.8 55.8 36.2 90.3 39.6V240 224h32v16V479.2c34.5-3.4 65.8-17.8 90.3-39.6l47.1 47.1L432 509.3 477.3 464l-22.6-22.6L401 387.7c9.6-20.6 15-43.5 15-67.7h64 32V256H480 416V205.3l54.6-54.6L493.3 128 448 82.7l-22.6 22.6L370.7 160H141.3L86.6 105.4z"],
    "bowl-chopsticks": [512, 512, [], "e2e9", "M0 96v32L512 48V0L0 96zm0 48v32H512V128L0 144zm512 80H0l3.6 61.2C8.5 368.1 58 438.2 128 472.9V512H384V472.9c70-34.6 119.5-104.8 124.4-187.7L512 224z"],
    "credit-card": [576, 512, [128179, 62083, "credit-card-alt"], "f09d", "M576 32H0v96H576V32zm0 192H0V480H576V224zM192 352v32H96V352h96zm32 0H384v32H224V352z"],
    "circle-s": [512, 512, [], "e121", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM207.6 196.2c-1.1 6.4-.2 9.7 .6 11.6c1 2 2.9 4.6 7.4 7.7c10.1 6.8 25.7 11.5 46.8 17.4l2 .6c18.4 5.2 41.4 11.7 58.6 23.2c9.5 6.4 18.5 15.1 24.1 27.2c5.7 12.3 7 25.9 4.4 40.3c-4.7 26.3-23 43.3-45 52c-21.3 8.4-47 9.6-72.6 5.7l-.1 0 0 0c-16.3-2.6-43.7-10.7-57.3-15.1l-22.9-7.3 14.7-45.7 22.9 7.3c13.9 4.5 37.8 11.4 50 13.4c20.2 3 36.8 1.4 47.7-2.9c10.3-4.1 14.2-9.6 15.4-15.8c1.1-6.4 .2-9.7-.6-11.6c-1-2-2.9-4.6-7.4-7.7c-10.1-6.8-25.7-11.5-46.8-17.4l-2-.6c-18.4-5.2-41.4-11.7-58.6-23.2c-9.5-6.4-18.5-15.1-24.1-27.2c-5.7-12.3-7-25.9-4.4-40.3c4.7-26.3 23-43.3 45-52c21.3-8.4 47-9.6 72.6-5.7c8.1 1.2 24.4 4.8 32 6.7l23.3 6-11.9 46.5-23.2-6c-6.7-1.7-21.3-4.9-27.3-5.7c-20.3-3.1-36.8-1.4-47.8 2.9c-10.3 4.1-14.2 9.6-15.4 15.8z"],
    "box-ballot": [576, 512, [128499], "f735", "M128 0H448V224H128V0zM0 352H576V512H0V352zM0 160H96v96H480V160h96V320H0V160z"],
    "car": [512, 512, [128664, "automobile"], "f1b9", "M120 32H97.3L89.8 53.4 41.3 192H0V400v80H96V400H416v80h96V400 192H470.7L422.2 53.4 414.7 32H392 120zM402.9 192H109.1l33.6-96H369.3l33.6 96zM64 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm352-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "hand-holding-hand": [576, 512, [], "e4f7", "M436 217l71.2-57H576V32H544 352 192 179.6l-10.2 7-128 88-33 22.7 45.3 65.9 33-22.7 94.5-65H320v32H288 224 192v64h32 64 64 64 11.2l8.8-7zM140 295L68.8 352H0V480H32 224 384h12.4l10.2-7 128-88 33-22.7-45.3-65.9-33 22.7-94.5 65H256V352h32 64 32V288H352 288 224 160 148.8l-8.8 7z"],
    "user-tie-hair": [448, 512, [], "e45f", "M304 144V128c0-11.4-2.4-22.2-6.7-32H256L240 80l-32 32H145.6c-1 5.2-1.6 10.5-1.6 16v16c0 44.2 35.8 80 80 80s80-35.8 80-80zM224 0c70.7 0 128 57.3 128 128v16c0 70.7-57.3 128-128 128s-128-57.3-128-128V128C96 57.3 153.3 0 224 0zM209.1 359.2L176 304h48 48l-33.1 55.2 33.4 123.9L312.2 320H384l64 192H280 265.1 182.9 168 0L64 320h71.8l39.9 163.1 33.4-123.9z"],
    "podium-star": [448, 512, [], "f758", "M192 0h96c26.5 0 48 21.5 48 48s-21.5 48-48 48H192V72H168c-22.1 0-40 17.9-40 40v32H424h24v48H424 24 0V144H24 80V112c0-48.6 39.4-88 88-88h24V0zM80 512L48 224H400L368 512H80zM253.3 335.6L224 272l-29.3 63.6-69.6 8.2 51.4 47.6-13.7 68.7L224 425.9l61.1 34.2-13.7-68.7 51.4-47.6-69.6-8.2z"],
    "user-hair-mullet": [448, 512, ["business-front", "party-back", "trian-balbot"], "e45c", "M304 128v16c0 44.2-35.8 80-80 80s-80-35.8-80-80V128c0-5.5 .6-10.8 1.6-16H176h12l7.2-9.6L224 64l28.8 38.4L260 112h12 30.4c1 5.2 1.6 10.5 1.6 16zm47-16h9V64H336h-1.1C312.7 25.7 271.4 0 224 0s-88.7 25.7-110.9 64H112 88v48h9c-.7 5.2-1 10.6-1 16v16c0 21.7 5.4 42.1 14.9 59.9L96 256l32 16 24-16 8 32h32l16.9-16.9c5 .6 10 .9 15.1 .9s10.2-.3 15.1-.9L256 288h32l8-32 24 16 32-16-14.9-52.1c9.5-17.9 14.9-38.3 14.9-59.9V128c0-5.4-.3-10.8-1-16zm97 400L384 320H64L0 512H448z"],
    "microphone-stand": [512, 512, [127908], "f8cb", "M479.2 191.2c43.7-43.7 43.7-114.7 0-158.4s-114.7-43.7-158.4 0l-4.7 4.7L474.5 195.9l4.7-4.7zm-27.3 27.3L293.5 60.1l-4.7 4.7c-24.4 24.4-35.2 57.2-32.4 89L358.2 255.6c31.8 2.8 64.6-8 89-32.4l4.7-4.7zM339.7 282.3L229.7 172.3 0 448l64 64L224 378.7V480v32h64V480 325.3l51.7-43z"],
    "book-open-reader": [512, 512, ["book-reader"], "f5da", "M160 96a96 96 0 1 1 192 0A96 96 0 1 1 160 96zm80 152V512l-70.7-29.4c-16.8-7-34.5-11.6-52.6-13.6L0 456V192H57.5c56.7 0 112.3 15 161.2 43.6L240 248zm32 264V248c52.1-36.4 114.1-56 177.7-56H512V456L387.2 468.5c-23.2 2.3-45.9 8.9-66.8 19.3L272 512z"],
    "family-dress": [512, 512, [], "e301", "M128 128A64 64 0 1 0 128 0a64 64 0 1 0 0 128zm48 48c0-5.5 .6-10.8 1.6-16H64L0 384H64V512H176V448H144V416 256 224h32 16c-10-13.4-16-30-16-48zm272-16H334.4c1 5.2 1.6 10.5 1.6 16c0 18-6 34.6-16 48h16 32v32V416v32H336v64H448V384h64L448 160zm-64-32A64 64 0 1 0 384 0a64 64 0 1 0 0 128zM256 224a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm80 192V256H176V416h32v96h96V416h32z"],
    "circle-x": [512, 512, [], "e12e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM381.1 128L285.9 256l95.2 128H321.3L256 296.2 190.7 384H130.9l95.2-128L130.9 128h59.8L256 215.8 321.3 128h59.8z"],
    "cabin": [512, 512, [], "e46d", "M0 176v48H384h96 32V176l-32-22V32H384V88L256 0 0 176zm192 80H32v64H192V256zM32 352v64H192V352H32zm0 96v64H192V448H32zM320 256v64H480V256H320zM480 448H320v64H480V448zM320 352v64H480V352H320zM256 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "mountain-sun": [640, 512, [], "e52f", "M560 0a80 80 0 1 1 0 160A80 80 0 1 1 560 0zM0 448L256 64 412.9 299.4 480 192 640 448v64H512 320 0V448z"],
    "chart-simple-horizontal": [448, 512, [], "e474", "M448 320l0-128L0 192 0 320l448 0zM256 480l0-128L0 352 0 480l256 0zM384 32L0 32 0 160l384 0 0-128z"],
    "bluetooth": [384, 512, [], "f293", "M160 0l51.2 38.4 128 96L373.3 160l-34.1 25.6L245.3 256l93.9 70.4L373.3 352l-34.1 25.6-128 96L160 512V448 320L83.2 377.6 57.6 396.8 19.2 345.6l25.6-19.2L138.7 256 44.8 185.6 19.2 166.4l38.4-51.2 25.6 19.2L160 192V64 0zm64 320v64l42.7-32L224 320zm0-128l42.7-32L224 128v64z"],
    "arrows-left-right-to-line": [640, 512, [], "e4ba", "M64 96V64H0V96 416v32H64V416L64 96zm576 0V64H576V96 416v32h64V416 96zM246.6 182.6L269.3 160 224 114.7l-22.6 22.6-96 96L82.7 256l22.6 22.6 96 96L224 397.3 269.3 352l-22.6-22.6L205.3 288l229.5 0-41.4 41.4L370.7 352 416 397.3l22.6-22.6 96-96L557.3 256l-22.6-22.6-96-96L416 114.7 370.7 160l22.6 22.6L434.7 224l-229.5 0 41.4-41.4z"],
    "hand-back-point-left": [512, 512, [], "e19f", "M0 208l0-80 224 0 13.3 0 2.7 0 80 0 16 0 0-32-16 0-56 0 40-48 68 0c38 0 74 16.9 98.3 46.1l4.5 5.4c24 28.8 37.1 65 37.1 102.4L512 320c0 70.7-57.3 128-128 128l-16 0-48 0-80 0 0-80-32 0 0-80-32 0 0-80L0 208z"],
    "message-dots": [512, 512, ["comment-alt-dots", "messaging"], "f4a3", "M0 0H512V416H304L160 512V416H0V0zM128 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "file-heart": [384, 512, [], "e176", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM80 299.2c0-32.7 26.5-59.2 59.2-59.2h2.4c15.9 0 31.2 6.2 42.7 17.2l7.7 7.4 7.7-7.4c11.5-11 26.8-17.2 42.7-17.2h2.4c32.7 0 59.2 26.5 59.2 59.2c0 16.1-6.6 31.5-18.2 42.7l-82.8 79.6L192 432.1l-11.1-10.7L98.2 341.8C86.6 330.7 80 315.3 80 299.2z"],
    "beer-mug": [512, 512, ["beer-foam"], "e0b3", "M208 160c-32.5 0-60.5-19.4-73-47.2C123.8 131.5 103.4 144 80 144c-35.3 0-64-28.7-64-64s28.7-64 64-64c23.4 0 43.8 12.5 55 31.2C147.5 19.4 175.5 0 208 0s60.5 19.4 73 47.2C292.2 28.5 312.6 16 336 16c35.3 0 64 28.7 64 64s-28.7 64-64 64c-23.4 0-43.8-12.5-55-31.2c-12.5 27.8-40.5 47.2-73 47.2zM32 512V163.2C46.1 171.3 62.5 176 80 176c18.8 0 36.2-5.4 51-14.7c20.1 19 47.1 30.7 77 30.7s56.9-11.7 77-30.7c14.8 9.3 32.3 14.7 51 14.7c19.6 0 37.9-5.9 53.1-16H480h32v32V368v20.8l-19 8.4L384 445.7V512H32zM384 375.6l64-28.4V224H384V375.6zM160 240V224H128v16V400v16h32V400 240zm64 0V224H192v16V400v16h32V400 240zm64 0V224H256v16V400v16h32V400 240z"],
    "dice-d20": [512, 512, [], "f6cf", "M17.9 416.8L240 512V446L17.9 416.8zM272 512l222.1-95.2L272 446v66zM496 328.4V143.5L411.7 194 496 328.4zM484.2 113.2L291.1 1.8 394.7 166.9l89.5-53.7zM220.9 1.8L27.8 113.2l89.5 53.7L220.9 1.8zM16 143.5V328.4L100.3 194 16 143.5zM256 6.1L149.4 176H362.6L256 6.1zm0 377.6L356.4 208H155.6L256 383.8zM388.2 216.8L276 413.2l217.5-28.6L388.2 216.8zm-264.5 0L18.5 384.6 236 413.2 123.8 216.8z"],
    "drone": [512, 512, [], "f85f", "M223 127.2L171.6 88.7C162.3 64.9 139.1 48 112 48c-35.3 0-64 28.7-64 64c0 27.1 16.9 50.3 40.7 59.6L127.2 223c-5 .7-10.1 1-15.2 1C50.1 224 0 173.9 0 112S50.1 0 112 0s112 50.1 112 112c0 5.2-.3 10.2-1 15.2zm-49.6 2.8l39.8 29.9 .1 .1h85.3l.1-.1 39.8-29.9L384 96l32 32-34.1 45.4-29.9 39.8-.1 .1v85.3l.1 .1 29.9 39.8L416 384l-32 32-45.4-34.1-39.8-29.9-.1-.1H213.3l-.1 .1-39.8 29.9L128 416 96 384l34.1-45.4 29.9-39.8 .1-.1V213.3l-.1-.1-29.9-39.8L96 128l32-32 45.4 34.1zM224 400c0 61.9-50.1 112-112 112S0 461.9 0 400s50.1-112 112-112c5.2 0 10.2 .3 15.2 1L88.7 340.4C64.9 349.7 48 372.9 48 400c0 35.3 28.7 64 64 64c27.1 0 50.3-16.9 59.6-40.7L223 384.8c.7 5 1 10.1 1 15.2zm65-272.8c-.7-5-1-10.1-1-15.2C288 50.1 338.1 0 400 0s112 50.1 112 112s-50.1 112-112 112c-5.2 0-10.2-.3-15.2-1l38.5-51.3c23.8-9.3 40.7-32.5 40.7-59.6c0-35.3-28.7-64-64-64c-27.1 0-50.3 16.9-59.6 40.7L289 127.2zM288 400c0-5.2 .3-10.2 1-15.2l51.3 38.5c9.3 23.8 32.5 40.7 59.6 40.7c35.3 0 64-28.7 64-64c0-27.1-16.9-50.3-40.7-59.6L384.8 289c5-.7 10.1-1 15.2-1c61.9 0 112 50.1 112 112s-50.1 112-112 112s-112-50.1-112-112z"],
    "truck-droplet": [640, 512, [], "e58c", "M416 0H0V416H64c0 53 43 96 96 96s96-43 96-96H384c0 53 43 96 96 96s96-43 96-96h32 32V352H608V288 256 224 210.7l-9.4-9.4-96-96L493.3 96H480 416V0zM544 240v16H416V160h48 2.7L544 237.3V240zM160 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm272 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM208 272c-39.8 0-72-29.6-72-66s72-126 72-126s72 89.5 72 126s-32.2 66-72 66z"],
    "file-circle-xmark": [576, 512, [], "e5a1", "M0 0H224V160H384v38.6C310.1 219.5 256 287.4 256 368c0 59.5 29.6 112.1 74.8 144H0V0zM384 128H256V0L384 128zm48 96a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3L502.6 320 480 297.4l-11.3 11.3L432 345.4l-36.7-36.7L384 297.4 361.4 320l11.3 11.3L409.4 368l-36.7 36.7L361.4 416 384 438.6l11.3-11.3L432 390.6l36.7 36.7L480 438.6 502.6 416l-11.3-11.3L454.6 368l36.7-36.7z"],
    "temperature-arrow-up": [576, 512, ["temperature-up"], "e040", "M113.8 317.8L128 300.1V277.5 64h96V277.5v22.7l14.2 17.6C249.4 331.5 256 348.9 256 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-19.1 6.6-36.5 17.8-50.3zM288 0H224 128 64V64 277.5C44 302.2 32 333.7 32 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-34.3-12-65.8-32-90.5V64 0zM176 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V112 96H160v16V322.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48zM480 160h64V128L448 32l-96 96v32h64l0 288 0 32h64V448l0-288z"],
    "medal": [512, 512, [127941], "f5a2", "M0 0H144l86.4 129.6c-42.2 5.2-80.5 23-111 49.6L0 0zM512 0L392.6 179.1c-30.5-26.6-68.8-44.4-111-49.6L368 0H512zM80 336a176 176 0 1 1 352 0A176 176 0 1 1 80 336zm176-96l-29.7 57.2L160 306.3l48 44.5-11.3 62.8L256 384l59.3 29.7L304 350.8l48-44.5-66.3-9.2L256 240z"],
    "bed": [640, 512, [128716], "f236", "M64 32V64 320H288V160 128h32H544c53 0 96 43 96 96V448v32H576V448 416H352 320 64v32 32H0V448 64 32H64zm112 96a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"],
    "book-copy": [576, 512, [], "e0be", "M160 96L96 96C43 96 0 139 0 192V416c0 53 43 96 96 96H320h32 32V448H352 320 288 96c-17.7 0-32-14.3-32-32s14.3-32 32-32h81.1c-10.9-18.8-17.1-40.7-17.1-64V96zM320 416h32H512h32 32V384 352H544V288h32V32 0H544 512 288c-53 0-96 43-96 96V320c0 24.6 9.2 47 24.4 64c17.6 19.6 43.1 32 71.6 32h32zm-64-96c0-17.7 14.3-32 32-32h96 96v64H384 288c-17.7 0-32-14.3-32-32z"],
    "square-h": [448, 512, ["h-square"], "f0fd", "M448 32H0V480H448V32zM336 152V256 360v24H288V360 280H160l0 80v24H112V360 280l0-48V152 128h48v24 80H288V152 128h48v24z"],
    "square-c": [448, 512, [], "e266", "M448 32H0V480H448V32zM144 256c0 44.2 35.8 80 80 80c28.7 0 53.8-15.1 68-37.8l40.8 25.4C310.2 359.8 269.9 384 224 384c-70.7 0-128-57.3-128-128s57.3-128 128-128c45.9 0 86.2 24.2 108.7 60.5L292 213.8c-14.2-22.8-39.3-37.8-68-37.8c-44.2 0-80 35.8-80 80z"],
    "clock-two": [512, 512, [], "e35a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392v91.2L338.7 172l20-13.3 26.6 39.9-20 13.3-96 64L232 300.8V256 120 96h48v24z"],
    "square-ellipsis-vertical": [448, 512, [], "e26f", "M448 32H0V480H448V32zM256 192H192V128h64v64zm0 32v64H192V224h64zm0 160H192V320h64v64z"],
    "calendar-users": [640, 512, [], "e5e2", "M256 0V64H384V0h64V64h96v96H96V64h96V0h64zM128 192H512v1.1c-54.3 7.8-96 54.4-96 110.9c0 31.3 12.9 59.7 33.6 80H424L379.2 512H260.8L216 384H190.4c20.7-20.3 33.6-48.7 33.6-80c0-56.4-41.7-103.1-96-110.9V192zm-16 32a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM224 512H0l32-96H192l32 96zM448 304a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM608 416l32 96H416l32-96H608z"],
    "podcast": [448, 512, [], "f2ce", "M316 374c50.4-31 84-86.6 84-150c0-97.2-78.8-176-176-176S48 126.8 48 224c0 63.5 33.6 119.1 84 150l8.3 57.8C58 398.6 0 318.1 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224c0 94.1-58 174.6-140.2 207.8L316 374zm3.3-42.1L313 324l-23.7-29.6C308.2 276.9 320 251.8 320 224c0-53-43-96-96-96s-96 43-96 96c0 27.8 11.8 52.9 30.7 70.4L135 324l-6.3 7.9C98.8 305.5 80 267 80 224c0-79.5 64.5-144 144-144s144 64.5 144 144c0 43-18.8 81.5-48.7 107.9zM160 344l32-40h64l32 40L264 512H184L160 344zm64-176a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"],
    "bee": [576, 512, [], "e0b2", "M216 1.4l11.3 11.3 26.8 26.8C264.4 34.7 275.9 32 288 32s23.6 2.7 33.9 7.5l26.8-26.8L360 1.4 382.6 24 371.3 35.3 347.8 58.8C360.4 73 368 91.6 368 112c0 3-.2 6-.5 8.9C390.3 105 419 96 448 96c65 0 128 44.9 128 112c0 61.9-53.6 104.9-112.9 111.2c.6-5.1 .9-10.2 .9-15.2c0-16.8-2.4-33.1-6.8-48.5c35.2-3.6 54.8-27.9 54.8-47.5c0-21.3-22.9-48-64-48c-34.8 0-56.6 19.2-62.4 38.1c28.6 26.3 46.4 64 46.4 105.9c0 96-144 208-144 208s-144-112-144-208c0-41.9 17.9-79.6 46.4-105.9C184.6 179.2 162.8 160 128 160c-41.1 0-64 26.7-64 48c0 19.6 19.5 43.9 54.8 47.5c-4.4 15.4-6.8 31.7-6.8 48.5c0 5 .3 10.1 .9 15.2C53.6 312.9 0 269.9 0 208C0 140.9 63 96 128 96c29 0 57.7 9 80.5 24.9c-.3-2.9-.5-5.9-.5-8.9c0-20.4 7.6-39 20.2-53.2L204.7 35.3 193.4 24 216 1.4zM248.9 384c4.7 5.8 9.6 11.6 14.7 17.2c8.3 9.2 16.6 17.7 24.4 25.4c7.8-7.6 16.2-16.2 24.4-25.4c5.1-5.6 10-11.4 14.7-17.2H248.9zM368 304H208c0 7.1 2.4 17.8 9.2 32H358.8c6.8-14.2 9.2-24.9 9.2-32zm-16-48c-14.6-19.4-37.8-32-64-32s-49.4 12.6-64 32H352z"],
    "temperature-full": [320, 512, ["temperature-4", "thermometer-4", "thermometer-full"], "f2c7", "M112 300.2L97.8 317.8C86.6 331.5 80 348.9 80 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-19.1-6.6-36.5-17.8-50.3L208 300.2V277.5 64H112V277.5v22.7zM208 0h64V64 277.5c20 24.7 32 56.2 32 90.5c0 79.5-64.5 144-144 144S16 447.6 16 368c0-34.3 12-65.8 32-90.5V64 0h64 96zm0 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3V112 96h32v16V322.8c18.6 6.6 32 24.4 32 45.3z"],
    "bell": [448, 512, [128276, 61602], "f0f3", "M256 0H192V51.2C119 66 64 130.6 64 208v88L0 368v48H448V368l-64-72V208c0-77.4-55-142-128-156.8V0zm32 448H224 160c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7s18.7-28.3 18.7-45.3z"],
    "candy-bar": [640, 512, [127851, "chocolate-bar"], "e3e8", "M0 320H128V224H0v96zM0 448H128V352H0v96zm288 0V352H160v96H288zm0-224H160v96H288V224zm0-160H160V192H288V64zm352 0H320V448H640V64zM33.1 192H128l0 0V160h0V97.1C113.6 111.3 93.8 120 72 120c-6.2 0-12.2-.7-18-2c1.3 5.8 2 11.8 2 18c0 21.8-8.7 41.6-22.9 56z"],
    "xmark-large": [448, 512, [], "e59b", "M70.6 57.4L48 34.7 2.7 80l22.6 22.6L178.7 256 25.4 409.4 2.7 432 48 477.3l22.6-22.6L224 301.3 377.4 454.6 400 477.3 445.3 432l-22.6-22.6L269.3 256 422.6 102.6 445.3 80 400 34.7 377.4 57.4 224 210.7 70.6 57.4z"],
    "pinata": [512, 512, [], "e3c3", "M112 318.1V253.3l41.8 17.4 6.8 2.8 6.5-3.3L259.8 224H288 512v93.2l-23.3 9.3-25.6-12.8-6.4-3.2-6.7 2.7-33.3 13.3-25.6-12.8-6.4-3.2-6.7 2.7-33.3 13.3-25.6-12.8-6.4-3.2-6.7 2.7-33.3 13.3-25.6-12.8-6.4-3.2-6.7 2.7-33.3 13.3-25.6-12.8-6.4-3.2-6.7 2.7-33.3 13.3L112 318.1zm0 35.8l8.8 4.4 6.4 3.2 6.7-2.7 33.3-13.3 25.6 12.8 6.4 3.2 6.7-2.7 33.3-13.3 25.6 12.8 6.4 3.2 6.7-2.7 33.3-13.3 25.6 12.8 6.4 3.2 6.7-2.7 33.3-13.3 25.6 12.8 6.4 3.2 6.7-2.7 33.3-13.3 25.6 12.8 6.4 3.2 6.7-2.7 18.1-7.2v50.5l-24 12-24.8-12.4-7.2-3.6-7.2 3.6-23.7 11.8-16.3-10.8-4-2.7H400 224h-4.8l-4 2.7-16.3 10.8-23.7-11.8-7.2-3.6-7.2 3.6L136 414.1l-24-12V353.9zm47.4-115.5L0 172V64H176V0h64V198.1l-80.6 40.3zM112 437.9l16.8 8.4 7.2 3.6 7.2-3.6L168 433.9l24.8 12.4 8.3 4.2 7.7-5.2L224 435.2V512H112V437.9zm288-2.7l15.1 10.1 7.7 5.2 8.3-4.2L456 433.9l24.8 12.4 7.2 3.6 7.2-3.6 16.8-8.4V512H400V435.2zM200 144a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "arrows-from-line": [448, 512, [], "e0a4", "M128 96L224 0l96 96v32H256v32 32H192V160 128H128V96zM256 360v24h64v32l-96 96-96-96V384h64V360 328h64v32zM32 224H416h32v64H416 32 0V224H32z"],
    "superscript": [512, 512, [], "f12b", "M384 0h32 32 32V32 160h32v64l-32 0H416l-32 0V160h32V64H384V0zM0 64H32 64 80.7l9.6 13.6L176 200.2 261.8 77.6 271.3 64H288h32 32v64H320 304.7L215.1 256l89.6 128H320h32v64H320 288 271.3l-9.6-13.6L176 311.8 90.2 434.4 80.7 448H64 32 0V384H32 47.3l89.6-128L47.3 128H32 0V64z"],
    "bowl-spoon": [512, 512, [129379], "e3e0", "M0 96C0 43 50.1 0 112 0H224V64H480h32v64H480 224v64H112C50.1 192 0 149 0 96zM0 224H512l-3.6 61.2C503.5 368.1 454 438.2 384 472.9V512H128V472.9C58 438.2 8.5 368.1 3.6 285.2L0 224z"],
    "hexagon-check": [512, 512, [], "e416", "M0 256L128 32H384L512 256 384 480H128L0 256zm369-47l17-17L352 158.1l-17 17-111 111-47-47-17-17L126.1 256l17 17 64 64 17 17 17-17L369 209z"],
    "plug-circle-xmark": [576, 512, [], "e560", "M128 0H64V32v96h64V32 0zM320 0H256V32v96h64V32 0zM32 160H0v64H32v32c0 77.4 55 142 128 156.8V512h64V412.8c12.3-2.5 24.1-6.4 35.1-11.5c-2.1-10.8-3.1-21.9-3.1-33.3c0-80.6 54.1-148.5 128-169.4V160H352 32zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7L454.6 368l36.7 36.7L502.6 416 480 438.6l-11.3-11.3L432 390.6l-36.7 36.7L384 438.6 361.4 416l11.3-11.3L409.4 368l-36.7-36.7L361.4 320 384 297.4l11.3 11.3L432 345.4l36.7-36.7L480 297.4 502.6 320l-11.3 11.3z"],
    "star-of-life": [512, 512, [], "f621", "M208 0h96V172.9L453.7 86.4l48 83.1L352 256l149.7 86.4-48 83.1L304 339.1V512H208V339.1L58.3 425.6l-48-83.1L160 256 10.3 169.6l48-83.1L208 172.9V0z"],
    "phone-slash": [640, 512, [], "f3dd", "M63.8 32l144-32 80 144-83.8 67c13 24.6 28.5 47.5 46.3 68.6L591.5 14.8l19-14.7L639.9 38l-19 14.7L48.4 497.2l-19 14.7L0 474l19-14.7L164.2 346.5C101.5 269.5 63.9 171.1 63.9 64l0-32zm301 339.8l67-83.8 144 80-32 144h-32c-104.9 0-201.3-36-277.6-96.4l88.4-69.7c13.4 9.5 27.5 18.1 42.2 25.9z"],
    "traffic-light-stop": [320, 512, [], "f63a", "M320 0H0V352c0 88.4 71.6 160 160 160s160-71.6 160-160V0zM136 368a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm72 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zM160 216a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm0 72a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm0-128a48 48 0 1 1 0-96 48 48 0 1 1 0 96z"],
    "paint-roller": [512, 512, [], "f5aa", "M0 0H416V64v64 64H0V0zM256 320h32V512H160V320h32V256 224h32H448V160 128 64h32 32V96 256v32H480 256v32z"],
    "accent-grave": [192, 512, [], "60", "M144 0l32 224H112L32 0H144z"],
    "handshake-angle": [640, 512, ["hands-helping"], "f4c4", "M640 144L496 0 432 64H224V96v32V288h80V176 160l0 0 16 0h96l96 0h32v32 48l96-96zM192 128H96V272L0 368 144 512l64-64H432V384h48V304h32V192l-96 0H336V304v16H320 208 192V304 128z"],
    "circle-0": [512, 512, [], "e0ed", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-384c53 0 96 43 96 96v64c0 53-43 96-96 96s-96-43-96-96V224c0-53 43-96 96-96zm-48 96v64c0 26.5 21.5 48 48 48s48-21.5 48-48V224c0-26.5-21.5-48-48-48s-48 21.5-48 48z"],
    "dial-med-low": [576, 512, [], "e160", "M320 0V64H256V0h64zM128 64v64H64V64h64zm384 0v64H448V64h64zm0 192h64v64H512V256zm0 192v64H448V448h64zM64 448h64v64H64V448zM0 256H64v64H0V256zM174.6 400.5c-56.7-56.7-62-145.4-15.7-208L270.8 304.3l17 17 33.9-33.9-17-17L192.8 158.5c62.6-46.2 151.3-41 208 15.7c62.5 62.5 62.5 163.8 0 226.3s-163.8 62.5-226.3 0z"],
    "location-dot": [384, 512, ["map-marker-alt"], "f3c5", "M192 512s192-208 192-320C384 86 298 0 192 0S0 86 0 192C0 304 192 512 192 512zm0-384a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "crab": [512, 512, [129408], "e3ff", "M128 0C57.3 0 0 57.3 0 128l0 64v15.4l13.9 6.4 85 39.2c-3.7 6-6.9 12.4-9.6 19H51.8L23.2 257.7 8.8 250.5-5.5 279.2l14.3 7.2 32 16 3.4 1.7H48 81c-.7 5.2-1 10.6-1 16v9.8l-21.1 7L55.4 338l-2.7 2.7-32 32L9.4 384 32 406.6l11.3-11.3L72.6 366l28-9.3 30.7 30.7L90.9 400.8 87.4 402l-2.7 2.7-32 32L41.4 448 64 470.6l11.3-11.3L104.6 430l52-17.3 15.7 15.7-36.6 21.9-7.8 4.7V464v32 16h32V496 473.1L201.8 448H310.2L352 473.1V496v16h32V496 464v-9.1l-7.8-4.7-36.6-21.9 15.7-15.7 52 17.3 29.3 29.3L448 470.6 470.6 448l-11.3-11.3-32-32-2.7-2.7-3.6-1.2-40.4-13.5 30.7-30.7 28 9.3 29.3 29.3L480 406.6 502.6 384l-11.3-11.3-32-32-2.7-2.7-3.6-1.2-21.1-7V320c0-5.4-.3-10.8-1-16h33 3.8l3.4-1.7 32-16 14.3-7.2-14.3-28.6-14.3 7.2L460.2 272H422.7c-2.7-6.6-5.9-13-9.6-19l85-39.2 13.9-6.4V192 128C512 57.3 454.7 0 384 0H320l64 64H320c0 35.3 28.7 64 64 64h80v48.6L378.7 216c-16.9-12.2-37-20.3-58.7-23V144 128H288v16 48H224V144 128H192v16 49c-21.7 2.7-41.7 10.9-58.7 23L48 176.6V128h80c35.3 0 64-28.7 64-64H128L192 0H128z"],
    "box-open-full": [640, 512, ["box-full"], "f49c", "M320 128c0-35.3-28.7-64-64-64s-64 28.7-64 64c0 5.1 .6 10 1.7 14.7l-65.5-8.2c-.1-2.2-.2-4.3-.2-6.5C128 57.3 185.3 0 256 0s128 57.3 128 128c0 1.2 0 2.4 0 3.5L444.6 3.5l86.8 41.1-44.1 93L320 158.5l-7.2-.9c4.6-8.8 7.2-18.9 7.2-29.6zM576 338.3V446.7l-256 64-256-64V338.3l151.2 43.2 23.6 6.7 12.6-21L320 252.9l68.6 114.3 12.6 21 23.6-6.7L576 338.3zM64 158.7l256 32 256-32 64 128-224 64-96-160-96 160L0 286.7l64-128z"],
    "file": [384, 512, [128196, 128459, 61462], "f15b", "M0 0H224V160H384V512H0V0zM384 128H256V0L384 128z"],
    "greater-than": [384, 512, [62769], "3e", "M0 64.5l5 2.2 360 160 19 8.4v41.6l-19 8.4L5 445.2l-5 2.2v-70L273.2 256 0 134.6v-70z"],
    "quotes": [576, 512, [], "e234", "M88 0C39.4 0 0 39.4 0 88v8 72 72H144V96H64V88c0-13.3 10.7-24 24-24h8 32V0H96 88zM264 0c-48.6 0-88 39.4-88 88v8 72 72H320V96H240V88c0-13.3 10.7-24 24-24h8 32V0H272h-8zM488 512c48.6 0 88-39.4 88-88v-8V344 272H432V416h80v8c0 13.3-10.7 24-24 24h-8H448v64h32 8zm-176 0c48.6 0 88-39.4 88-88v-8V344 272H256V416h80v8c0 13.3-10.7 24-24 24h-8H272v64h32 8z"],
    "pretzel": [512, 512, [129384], "e441", "M138.6 32C62.1 32 0 94.1 0 170.6C0 253.3 40.9 326.5 103.7 371L82.5 401l-23 32.7 65.4 46L148 447l28.7-40.8c21.8 6.4 44.9 9.8 68.7 9.8H256h10.6c23.9 0 46.9-3.4 68.7-9.8L364 447l23 32.7 65.4-46-23-32.7-21.1-30C471.1 326.5 512 253.3 512 170.6C512 94.1 449.9 32 373.4 32H364c-42.6 0-81 18-108 46.8C229 50 190.6 32 148 32h-9.4zM216 180v7.4c0 15.5-4.8 30.7-13.7 43.4l-52.5 74.7C107.5 275.6 80 226.3 80 170.6c0-32.4 26.2-58.6 58.6-58.6H148c37.6 0 68 30.4 68 68zm40 113.5L285.2 335c-6.1 .7-12.3 1-18.6 1H256 245.4c-6.3 0-12.5-.3-18.6-1L256 293.5zm53.7-62.6C300.8 218.2 296 203 296 187.4V180c0-37.6 30.4-68 68-68h9.4c32.4 0 58.6 26.2 58.6 58.6c0 55.7-27.5 105-69.7 134.9l-52.5-74.7z"],
    "person-swimming": [576, 512, [127946, "swimmer"], "f5c4", "M312.4 180.9l134.2 115c-7.5 5.1-14.2 9.2-21.9 12.7C411.6 314.7 397 319 384 319s-27.6-4.3-40.7-10.3c-12-5.5-21.7-12.5-35.5-22.5L288 272l-18.6 13.4-1.1 .8c-13.9 10-23.6 17-35.5 22.5C219.6 314.7 205 319 192 319c-10.2 0-21.3-2.7-32-6.7V256 242.7l9.4-9.4 128-128 9.4-9.4H320 448h32v64H448 333.3l-20.9 20.9zM160 160A64 64 0 1 1 32 160a64 64 0 1 1 128 0zM272.4 397.1c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7C60.6 406.1 31.9 416 0 416V352c19.3 0 38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 17.9 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1s38.6-6.1 54-13.1c14.9-6.8 26.9-15.4 40-24.7c.7-.5 1.4-1 2.1-1.5c.7 .5 1.4 1 2.1 1.5c13.1 9.3 25.1 18 40 24.7c15.4 7 34.7 13.1 54 13.1v64c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9s-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7z"],
    "arrow-down": [384, 512, [8595], "f063", "M214.6 454.6L192 477.3l-22.6-22.6-144-144L2.7 288 48 242.8l22.6 22.6L160 354.8 160 64l0-32 64 0 0 32 0 290.7 89.4-89.4L336 242.8 381.3 288l-22.6 22.6-144 144z"],
    "user-robot-xmarks": [448, 512, [], "e4a7", "M240 0V16 64H368V320H80V64H208V16 0h32zM16 128H48V256H16V128zm384 0h32V256H400V128zM240 240H208v32h32V240zM400 352l48 160H352V416H96v96H0L48 352H400zM176 464v48H144V464 448h32v16zm96-224v32h32V240H272zm-96 0H144v32h32V240zm64 208v16 48H208V464 448h32zm64 16v48H272V464 448h32v16zM128 111l-17 17 8.5 8.5L143 160l-23.5 23.5L111 192l17 17 8.5-8.5L160 177l23.5 23.5L192 209l17-17-8.5-8.5L177 160l23.5-23.5L209 128l-17-17-8.5 8.5L160 143l-23.5-23.5L128 111zm136.5 8.5L256 111l-17 17 8.5 8.5L271 160l-23.5 23.5L239 192l17 17 8.5-8.5L288 177l23.5 23.5L320 209l17-17-8.5-8.5L305 160l23.5-23.5L337 128l-17-17-8.5 8.5L288 143l-23.5-23.5z"],
    "message-quote": [512, 512, ["comment-alt-quote"], "e1e4", "M0 0H512V416H304L160 512V416H0V0zM240 112H128V224h64v32H168 144v48h24 48 24V280 224 176 152 112zm144 0H272V224h64v32H312 288v48h24 48 24V280 224 176 152 112z"],
    "candy-corn": [640, 512, [], "f6bd", "M320 128V32s32-32 160-32S640 32 640 32v96l-1 2.2c-7-1.8-15.7-3.9-25.9-5.9c-30.9-6.2-76-12.3-133.1-12.3s-102.2 6.1-133.1 12.3c-10.2 2-18.8 4.1-25.9 5.9l-1-2.2zm286.9 27.7c7.2 1.4 13.5 2.9 19 4.2L512 416H448L334.2 159.9c5.5-1.3 11.8-2.8 19-4.2c29.1-5.8 72-11.7 126.9-11.7s97.8 5.9 126.9 11.7zM446.9 256L480 330.4 513.1 256H446.9zM66.7 400.9L0 334.2s0-44.4 88.9-133.3S222.2 112 222.2 112l66.7 66.7 .9 2.2c-6.2 3.6-13.6 8.2-22.1 13.9c-25.8 17.2-61.3 44.2-101 83.9s-66.7 75.2-83.9 101c-5.7 8.5-10.2 15.9-13.9 22.1l-2.2-.9zm218.4-180c6-4 11.4-7.4 16.1-10.2L400 467.6 355.6 512 98.7 413.2c2.9-4.7 6.3-10.1 10.2-16.1c16.1-24.2 41.9-58.1 80-96.2s72-63.8 96.2-80zM243.7 401.6l74.6 28.7-28.7-74.6-45.9 45.9z"],
    "folder-magnifying-glass": [512, 512, ["folder-search"], "e18b", "M512 480H0V32H224l48 64H512V480zM336 272c0-53-43-96-96-96s-96 43-96 96s43 96 96 96c17.8 0 34.4-4.8 48.7-13.2L327 393.1l17 17 33.9-33.9-17-17-38.3-38.3c8.5-14.3 13.3-31 13.3-48.9zm-96-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "notebook": [512, 512, [], "e201", "M64 0V104H56 24 0v48H24 56h8v80H56 24 0v48H24 56h8v80H56 24 0v48H24 56h8V512H192V0H64zM480 0H224V512H480V0z"],
    "droplet": [384, 512, [128167, "tint"], "f043", "M192 512c106 0 192-86 192-192S192 0 192 0S0 214 0 320S86 512 192 512zM96 336c0 44.2 35.8 80 80 80h16v32H176c-61.9 0-112-50.1-112-112V320H96v16z"],
    "bullseye-pointer": [512, 512, [], "f649", "M256 448c106 0 192-86 192-192s-86-192-192-192S64 150 64 256c0 3.9 .1 7.8 .4 11.7L1.8 286.1C.6 276.2 0 266.2 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256s-114.6 256-256 256c-10.2 0-20.2-.6-30.1-1.8l18.4-62.6c3.9 .2 7.8 .4 11.7 .4zm2.3-48l19.7-67c33.5-9.6 58-40.4 58-76.9c0-44.2-35.8-80-80-80c-36.5 0-67.4 24.5-76.9 58L112 253.7C113.2 175.2 177.2 112 256 112c79.5 0 144 64.5 144 144c0 78.8-63.2 142.8-141.7 144zM0 320l272-80L192 512l-48-96-1.4-1.4-96 96L1.4 465.4l96-96L96 368 0 320z"],
    "eraser": [576, 512, [], "f12d", "M293.5 416H288v0H186.5l-80-80L229.3 213.3 362.7 346.7 293.5 416zm90.5 0L514.7 285.3 560 240l-45.3-45.3L381.3 61.3 336 16 290.7 61.3 61.3 290.7 16 336l45.3 45.3L160 480H320l0 0H512h32V416H512 384z"],
    "hexagon-image": [512, 512, [], "e504", "M128 32L0 256 128 480H384L512 256 384 32H128zm30.3 247.8l17.3-19 17.8 18.6L232.2 320l71.6-86.2 18.5-22.2 18.5 22.2 72.6 87.4L353.5 424.9h-195l-51.4-89 51.2-56.1zM192 120a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"],
    "earth-americas": [512, 512, [127758, "earth", "earth-america", "globe-americas"], "f57d", "M55.7 199.7L96 240h48l48 48v64l32 32v64h64V400l64-64V256H224l-32-32V192h80V160l-32-32V112l32-32V48.6c-5.3-.4-10.6-.6-16-.6C160.6 48 80.3 112.2 55.7 199.7zM464 256c0-36.9-9.6-71.5-26.4-101.6L400 192v80h63.4c.4-5.3 .6-10.6 .6-16zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "crate-apple": [512, 512, ["apple-crate"], "f6b1", "M160 54.9C160 24.6 184.6 0 214.9 0H224V9.1C224 39.4 199.4 64 169.1 64H160V54.9zm192 0C352 24.6 376.6 0 406.9 0H416V9.1C416 39.4 391.4 64 361.1 64H352V54.9zM96 80c27.4 0 64 18.3 64 18.3s36.6-18.3 64-18.3c43.6 0 64 47.8 64 91.4c0 7-.4 13.9-1.2 20.6H33.2c-.8-6.7-1.2-13.5-1.2-20.6C32 127.8 52.4 80 96 80zm384 91.4c0 7-.4 13.9-1.2 20.6H319c.7-6.7 1-13.6 1-20.6c0-26.1-6-55.1-20.3-78.6c-2.7-4.4-5.7-8.7-9-12.7C317.7 81.2 352 98.3 352 98.3s36.6-18.3 64-18.3c43.6 0 64 47.8 64 91.4zM0 224H512V352H0V224zM0 384H512V512H0V384zm80-96a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM64 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM464 288a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM448 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "person-burst": [640, 512, [], "e53b", "M176 0L133.8 88.5 38.4 66.3l42.9 88.1L4.4 215.2 100 236.6l-.4 98L176 273.2l76.4 61.4-.4-98L312.8 223l15-23.5-57.1-45.1 42.9-88.1L218.2 88.5 176 0zM480 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H411.4L402 142.8l-81.7 128 53.9 34.4 33.8-53V480v32h64V480 352h16V480v32h64V480 252.2l33.8 53 53.9-34.4L558 142.8 548.6 128H531.1 428.9z"],
    "game-board": [448, 512, [], "f867", "M0 32H448V480H0V32zM144 96v80h80V96H144zm0 160V176H64v80h80zm80 0H144v80H64v80h80V336h80v80h80V336h80V256H304V176h80V96H304v80H224v80zm0 0h80v80H224V256z"],
    "hat-chef": [512, 512, [], "f86b", "M153.5 51.3C176.9 20.2 214.1 0 256 0s79.1 20.2 102.5 51.3C374.6 39.2 394.7 32 416.4 32C469 32 512 74.6 512 127.2c0 11.1-1.9 22.1-5.7 32.5L448 320H373.8l26-149.3 2.7-15.8L371 149.5l-2.7 15.8L341.3 320H272V160 144H240v16V320H170.7L143.8 165.3 141 149.5 109.5 155l2.7 15.8 26 149.3H64L5.7 159.8C1.9 149.3 0 138.3 0 127.2C0 74.6 43 32 95.6 32c21.7 0 41.7 7.2 57.9 19.3zM448 352V512H64V352H448z"],
    "hand-back-point-right": [512, 512, [], "e1a1", "M512 208l0-80-224 0-13.3 0-2.7 0-80 0-16 0 0-32 16 0 56 0L208 48l-68 0c-38 0-74 16.9-98.3 46.1l-4.5 5.4C13.1 128.3 0 164.5 0 201.9L0 320c0 70.7 57.3 128 128 128l16 0 48 0 80 0 0-80 32 0 0-80 32 0 0-80 176 0z"],
    "dove": [512, 512, [128330], "f4ba", "M210.3 138.7c-18-11-34.6-24.4-48.4-40.9c22.8-50.1 59.9-82 75-95c1.2-1.1 2.3-2 3.2-2.8c-3.6 55.7 17.7 103.1 48 140.7v29.6c-24-5.8-51.9-15.8-77.7-31.6zM320 174.5V144c0-44.2 35.8-80 80-80H512l-32 56V288c0 88.4-71.6 160-160 160H236.8L160 512 80 496 0 432l153.8-51.3C117.2 360.4 32 296.6 32 176C32 111.5 69.6 65.1 87.9 42.4c3.5-4.4 6.3-7.8 8.1-10.4c25.6 128 160 170.7 224 176V175.9l0 0v-1.4l0 0zM400 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "snowflake-droplets": [640, 512, [], "e5c1", "M352 32V0H288V32 62.1l-8.6-8.6-17-17L228.5 70.4l17 17L288 129.9v70.6l-61.2-35.3-15.6-58.2L205 83.9 158.7 96.3l6.2 23.2 3.2 11.8-12.2-7-27.7-16-32 55.4 27.7 16 12.2 7-11.8 3.2-23.2 6.2 12.4 46.4 23.2-6.2 58.2-15.6L256 256l-61.2 35.3-58.2-15.6-23.2-6.2-11.3 42.3 2.6 5.1 19.5 5.2 11.8 3.2-12.2 7-8.6 5 29.3 57 11.3-6.5 12.2-7-3.2 11.8-6.2 23.2L205 428.1l6.2-23.2 15.6-58.2L288 311.4v70.6l-42.6 42.6-17 17 33.9 33.9 17-17 8.6-8.6V480v32h64V480 449.9l8.6 8.6 17 17 33.9-33.9-17-17L352 382.1V311.4l61.2 35.3 15.6 58.2 6.2 23.2 46.4-12.4-6.2-23.2L472 380.7l12.2 7 11.3 6.5 29.3-57-8.6-5-12.2-7 11.8-3.2 19.5-5.2 2.6-5.1-11.3-42.3-23.2 6.2-58.2 15.6L384 256l61.2-35.3 58.2 15.6 23.2 6.2 12.4-46.4-23.2-6.2L504 186.7l12.2-7 27.7-16-32-55.4-27.7 16-12.2 7 3.2-11.8 6.2-23.2L435 83.9l-6.2 23.2-15.6 58.2L352 200.6V129.9l42.6-42.6 17-17L377.6 36.5l-17 17L352 62.1V32zM520.3 417.4c-5.5 9.6-8.3 20.4-8.3 31.4c0 34.9 28.3 63.2 63.2 63.2h1.6c34.9 0 63.2-28.3 63.2-63.2c0-11-2.9-21.8-8.3-31.4L576 320l-55.7 97.4zM64 320L8.3 417.4C2.9 427 0 437.8 0 448.8C0 483.7 28.3 512 63.2 512h1.6c34.9 0 63.2-28.3 63.2-63.2c0-11-2.9-21.8-8.3-31.4L64 320z"],
    "battery-empty": [576, 512, ["battery-0"], "f244", "M64 160V352H480V160H64zM0 96H64 480h64v64 32h32V320H544v32 64H480 64 0V352 160 96z"],
    "grid-4": [448, 512, [], "e198", "M0 32H89.6v89.6H0V32zM0 151.5H89.6v89.6H0V151.5zM89.6 270.9v89.6H0V270.9H89.6zM0 390.4H89.6V480H0V390.4zM119.5 32h89.6v89.6H119.5V32zm0 119.5h89.6v89.6H119.5V151.5zm89.6 119.5v89.6H119.5V270.9h89.6zM119.5 390.4h89.6V480H119.5V390.4zM328.5 32v89.6H238.9V32h89.6zm0 119.5v89.6H238.9V151.5h89.6zM238.9 270.9h89.6v89.6H238.9V270.9zm89.6 119.5V480H238.9V390.4h89.6zM358.4 32H448v89.6H358.4V32zm0 119.5H448v89.6H358.4V151.5zM448 270.9v89.6H358.4V270.9H448zM358.4 390.4H448V480H358.4V390.4z"],
    "socks": [512, 512, [129510], "f696", "M288 0V64H128V0H288zm0 96V256l-76.8 57.6C179 337.8 160 375.7 160 416c0 21.9 5.5 42.6 15.2 60.6l-21.6 16.2C137 505.3 116.8 512 96 512c-53 0-96-43-96-96c0-30.2 14.2-58.7 38.4-76.8L128 272V96H288zm32 0H512V368L345.6 492.8C329 505.3 308.8 512 288 512c-53 0-96-43-96-96c0-30.2 14.2-58.7 38.4-76.8L320 272V96zM512 64H320V0H512V64z"],
    "face-sunglasses": [512, 512, [], "e398", "M256 512c141.4 0 256-114.6 256-256c0-31.8-5.8-62.2-16.4-90.3l.4-1.3V160 128 96H464h-8.1C408.9 37.5 336.8 0 256 0S103.1 37.5 56.1 96H48 16v32 32 4.5l.4 1.3C5.8 193.8 0 224.2 0 256C0 397.4 114.6 512 256 512zM208 272H80L48 160V128H240v16h32V128H464v32L432 272H304l-27.4-96H235.4L208 272zm-78.3 71.2l28.6-14.3c8.7 17.5 41.3 55.2 97.7 55.2s88.9-37.7 97.7-55.2l28.6 14.3C369.7 368.3 327.6 416 256 416s-113.7-47.7-126.3-72.8z"],
    "inbox": [512, 512, [], "f01c", "M96 32H71L65 56.2 1 312.2l-1 3.8V320 448v32H32 480h32V448 320v-3.9l-1-3.8-64-256L441 32H416 96zM73 288L121 96H391l48 192H368l-32 64H176l-32-64H73z"],
    "square-0": [448, 512, [], "e255", "M448 32H0V480H448V32zM224 128c53 0 96 43 96 96v64c0 53-43 96-96 96s-96-43-96-96V224c0-53 43-96 96-96zm-48 96v64c0 26.5 21.5 48 48 48s48-21.5 48-48V224c0-26.5-21.5-48-48-48s-48 21.5-48 48z"],
    "section": [256, 512, [], "e447", "M86 70.6C73.7 76.2 67.1 84.4 64.9 96c-.9 9.2 .6 14.8 2.3 18.5c1.9 4 5.3 8.1 11.4 12.4c13.7 9.8 34.1 16.4 61.5 25l1.4 .5 0 0c24.1 7.6 54.9 17.3 77.7 35c12.4 9.6 23.5 22.2 30.2 39c6.7 16.8 8.1 35.3 4.8 55.1c-4.1 24.9-16.1 44.3-32.7 58.2c11.2 8.8 21.2 20.2 27.6 35.2c7 16.5 8.4 34.6 5 53.9c-6 35-29.2 58.9-58.5 71.4c-28.3 12.1-62.7 14.1-97.2 8.7l-.2 0 0 0c-18.8-3.1-48.7-13.3-67.3-19.6c-3.5-1.2-6.7-2.3-9.2-3.1L-8.5 476.2l20.2-60.7 30.4 10.1c3.8 1.3 8 2.7 12.3 4.2l0 0c19 6.5 41.4 14.1 54.1 16.2c26.6 4.1 48 1.6 62-4.4c13-5.6 18.9-13.4 20.7-23.5c1.6-9.5 .4-14.9-.9-18.1c-1.4-3.3-4.1-6.9-9.5-10.9c-12.5-9.2-32.2-15.6-59.4-23.8l-3.7-1.1c-23.5-7-53-15.8-75.4-31c-12.5-8.5-24.4-19.9-32.3-35.5c-8-15.9-10.7-33.7-8.4-53c.1-.6 .1-1.1 .2-1.7c4.8-27.7 20.4-48.8 41.7-62.5c-.7-.5-1.3-.9-2-1.4c-12.6-9-24.3-20.9-32-36.9C1.8 126-.8 107.8 1.4 88.1c.1-.5 .1-1.1 .2-1.6c5.8-35.5 28.2-60.7 58-74.1C88.3-.6 123-2.7 157.7 3c9.9 1.6 39.8 7.7 50.9 10.8l30.8 8.7L222.1 84.1l-30.8-8.7c-8-2.2-35.3-7.9-44.1-9.3c-26.4-4.4-47.5-1.7-61.2 4.5zm73.2 155.9l-24.6-2c-23.1-1.9-41 1.5-52.5 7.4c-10.3 5.2-15.5 12.1-17.3 21.2c-.8 8.1 .5 12.7 2.1 15.7c1.7 3.3 4.9 7.1 11 11.3c13.8 9.3 34.3 15.6 61.7 23.8l1.4 .4c.7 .2 1.5 .4 2.2 .7l15.5-3.9c20.8-5.2 30.1-15.9 32.4-30c1.7-10.6 .5-16.9-1.1-20.9c-1.6-4-4.5-8-10-12.2c-5.5-4.3-12.5-8-20.9-11.6z"],
    "square-this-way-up": [448, 512, ["box-up"], "f49f", "M448 32H0V480H448V32zM160 320H96V192H56V168l72-72 72 72v24H160V320zM64 384H384v32H64V384zM248 192V168l72-72 72 72v24H352V320H288V192H248z"],
    "gauge-high": [512, 512, [62461, "tachometer-alt", "tachometer-alt-fast"], "f625", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64c0-17.4-6.9-33.1-18.1-44.6L366 161.7l9.7-22-43.9-19.3-9.7 22L257.9 288c-.6 0-1.3 0-1.9 0c-35.3 0-64 28.7-64 64s28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "square-ampersand": [448, 512, [], "e260", "M448 32H0V480H448V32zM136 128h24 96 24v24 35.7c0 20.4-9.7 39.6-26.2 51.6l-18 13.2 28.6 29.9 27.7-40.1 13.7-19.7 39.5 27.3-13.7 19.7-33.3 48.1 60.9 63.6c.8 .8 1.5 1.7 2.2 2.6H295.4l-24.8-25.9-10.8 15.6L252.6 384H240 224 136 112V360 320.3c0-22.9 10.9-44.5 29.4-58.1l21.9-16.1-7.3-7.7c-12.8-13.4-20-31.2-20-49.8V152 128zm66.4 89.6l23.1-16.9c4.1-3 6.5-7.8 6.5-12.9V176H184v12.7c0 6.2 2.4 12.1 6.7 16.6l11.7 12.2zm-5.6 63.6l-27 19.8c-6.2 4.5-9.8 11.7-9.8 19.4V336h67.4l9.2-13.3-39.8-41.5z"],
    "envelope-open-text": [512, 512, [], "f658", "M512 448v64H448 64 0V448 244.8l4.1 2.9L246.7 421l9.3 6.6 9.3-6.6L507.9 247.7l4.1-2.9V448zm0-256v13.5l-22.7 16.2L416 274.1V200 144 120 96H384 368 277.3 234.7 144 128 96v24 24 56 74.1L22.7 221.7 0 205.5V192l48-36V96 48H96h96L256 0l64 48h96 48V96v60l48 36zM176 160H336h16v32H336 176 160V160h16zm0 64H336h16v32H336 176 160V224h16z"],
    "lamp-desk": [512, 512, [], "e014", "M257.9 0C221.5 0 192 29.5 192 65.9c0 17.5 6.9 34.3 19.3 46.6l3.8 3.8L104.7 234.1 92.7 246.8 97 263.8 143 448H32 0v64H32 183.3c.5 0 .9 0 1.4 0H352h32V448H352 209L163.3 265.2 256 166.3V272l48 48 80-80 48-48 80-80L464 64H349.3L304.6 19.3C292.2 6.9 275.4 0 257.9 0zM480 240c0-14-6-26.5-15.5-35.3l-67.8 67.8C405.5 282 418 288 432 288c26.5 0 48-21.5 48-48z"],
    "hospital": [640, 512, [127973, 62589, "hospital-alt", "hospital-wide"], "f0f8", "M192 0H448V512H368V384H272V512H192V0zM160 96V512H0V320H80 96V288H80 0V224H80 96V192H80 0V96H160zm320 0H640v96H560 544v32h16 80v64H560 544v32h16 80V512H480V96zM344 64H296v40H256v48h40v40h48V152h40V104H344V64z"],
    "poll-people": [640, 512, [], "f759", "M128 48A48 48 0 1 0 32 48a48 48 0 1 0 96 0zM576 96v32H480V96h96zM288 32H224V96v32 64h64H576h64V128 96 32H576 288zM576 384v32H352V384H576zM288 320H224v64 32 64h64H576h64V416 384 320H576 288zM160 224l-32-96H32L0 224H160zM128 336a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm32 176l-32-96H32L0 512H160z"],
    "whiskey-glass-ice": [512, 512, ["glass-whiskey-rocks"], "f7a1", "M438.2 96L412.1 278.8l18.5 18.5L453.3 320l-22.6 22.6-88 88L320 453.3l-22.6-22.6L234.7 368h-32H128 96V336 251.5L73.8 96H438.2zM64 480H448L502.9 96 512 32H447.4 64.6 0L9.1 96 64 480zM256 250.7V208H128V336h74.7l-16-16 22.6-22.6L256 250.7zM232 320l88 88 88-88-88-88-88 88z"],
    "wine-bottle": [512, 512, [], "f72f", "M453 23.8L430.4 1.1 385.1 46.4l11.9 11.9-9.4 9.4-61.8 61.8c-47.3-23.6-106.2-15.7-145.7 23.7L0 333.5 178.5 512 358.7 331.8c39.4-39.4 47.3-98.4 23.7-145.7l61.8-61.8 9.4-9.4 11.9 11.9 45.3-45.3L488.2 59 453 23.8zM112 312L232 192l88 88L200 400l-88-88z"],
    "chess-rook": [448, 512, [9820], "f447", "M32 208V32h96V96h48V32h96V96h48V32h96V208l-64 48 16 144H80L96 256 32 208zm160 16v64h64V224c0-17.7-14.3-32-32-32s-32 14.3-32 32zM16 512V480l48-48H384l48 48v32H16z"],
    "user-bounty-hunter": [448, 512, [], "e2bf", "M323 120C309.4 78 270 48 224 48s-85.4 30-99 72H323zm5.5 36.4L248 171.5v95.9l9.9-1.7c8.4-48.3 43-79.4 71.5-95.4l-.9-13.8zm-209 0l-.9 13.8c28.5 16 63.1 47.1 71.5 95.4l9.9 1.7V171.5l-80.5-15.1zM96 70C123.1 27.7 170.5 0 224 0c80.1 0 146.5 62.2 151.7 142.2l8.3 128.2 1.4 21.4-21.2 3.7-136 24c-2.8 .5-5.6 .5-8.3 0l-136-24-21.2-3.7L64 271.2V256 16 0H80 96h16V32H96V70zM48 352H400l48 160H0L48 352zM160 464H288l-64-48-64 48z"],
    "bars-staggered": [512, 512, ["reorder", "stream"], "f550", "M0 64H448v64H0V64zM64 224H512v64H64V224zM448 384v64H0V384H448z"],
    "diagram-sankey": [576, 512, [], "e158", "M304 32h16H544h32V96H544 336L249.6 211.2 240 224H224 32 0V160H32 208L294.4 44.8 304 32zM141.9 320H32 0V256H32 544h32v64H544 216.5l57.6 96H544h32v64H544 256 237.9l-9.3-15.5L141.9 320z"],
    "cloud-hail-mixed": [512, 512, [], "f73a", "M96 320H0V224c0-41.8 26.7-77.4 64-90.5V112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H416 96zm8 32L75.2 416h-56L48 352h56zm120 0L152 512H96l72-160h56zm56 0h56l-28.8 64h-56L280 352zm176 0L384 512H328l72-160h56zM32 448a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm224 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "circle-up-left": [512, 512, [], "e128", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 320V160H320l24 24-52 52 76 76-56 56-76-76-52 52-24-24z"],
    "dharmachakra": [512, 512, [9784], "f655", "M236.5 162l-4.9-64.1c-25.9 4-49.8 14.2-70 29l41.9 48.8c9.9-6.5 21.1-11.2 33.1-13.7zM288 0l-2.6 33.9c39.9 5.2 76.4 20.9 106.9 44.3l22.1-25.8 45.3 45.3-25.8 22.1c23.3 30.4 39 67 44.3 106.9L512 224v64l-33.9-2.6c-5.2 39.9-20.9 76.4-44.3 106.9l25.8 22.1-45.3 45.3-22.1-25.8c-30.4 23.3-67 39-106.9 44.3L288 512H224l2.6-33.9c-39.9-5.2-76.4-20.9-106.9-44.3L97.6 459.6 52.4 414.4l25.8-22.1c-23.3-30.4-39.1-67-44.3-106.9L0 288V224l33.9 2.6c5.2-39.9 20.9-76.4 44.3-106.9L52.4 97.6 97.6 52.4l22.1 25.8c30.4-23.3 67-39.1 106.9-44.3L224 0h64zM275.5 162c12 2.5 23.2 7.2 33.1 13.7l41.9-48.8c-20.2-14.8-44.1-25-70-29L275.5 162zm60.7 41.4c6.5 9.9 11.2 21.1 13.7 33.1l64.1-4.9c-4-25.9-14.2-49.8-29-70l-48.8 41.9zM350 275.5c-2.5 12-7.2 23.2-13.7 33.1l48.8 41.9c14.8-20.2 25-44.1 29-70L350 275.5zm-41.4 60.7c-9.9 6.5-21.1 11.2-33.1 13.7l4.9 64.1c25.9-4 49.8-14.2 70-29l-41.9-48.8zM236.5 350c-12-2.5-23.2-7.2-33.1-13.7l-41.9 48.8c20.2 14.8 44.1 25 70 29l4.9-64.1zm-60.7-41.4c-6.5-9.9-11.2-21.1-13.7-33.1l-64.1 4.9c4 25.9 14.2 49.8 29 70l48.8-41.9zM162 236.5c2.5-12 7.2-23.2 13.7-33.1l-48.8-41.9c-14.8 20.2-25 44.1-29 70l64.1 4.9zM256 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "objects-align-left": [512, 512, [], "e3be", "M0 512H48L48 0 0 0 0 512zM128 64V224l384 0V64L128 64zm0 224V448H384V288H128z"],
    "oil-can-drip": [640, 512, [], "e205", "M352 128H288v32h96l64 32 160-32 32 32L432 416H384 96V346.7L0 304V208 160H48 96h48 80V128H160V64H352v64zM48 208v64.8l48 21.3V208H48zM592 448c-26.5 0-48-21.5-48-48c0-32 48-96 48-96s48 64 48 96s-21.5 48-48 48z"],
    "face-smiling-hands": [640, 512, [], "e396", "M320 512c-32.1 0-62.8-5.9-91.1-16.7c17-21.6 27.1-48.9 27.1-78.5V386c18.1 8.4 39.4 14 64 14s45.9-5.6 64-14v30.8c0 29.6 10.1 56.9 27.1 78.5c-28.3 10.8-59 16.7-91.1 16.7zM320 0C460.1 0 573.9 112.5 576 252.1l-1.3-1.3L552 228.1l-22.6 22.6-51.7 51.7H456 416 384v32 15.2c-16.8 10.6-38.1 18.4-64 18.4s-47.2-7.7-64-18.4V334.4v-32H224 184 162.3l-51.7-51.7L88 228.1 65.4 250.7 64 252.1C66.1 112.5 179.9 0 320 0zM240 152c-28 0-56 40-56 80c0 0 28-32 56-32s56 32 56 32c0-40-28-80-56-80zm104 80s28-32 56-32s56 32 56 32c0-40-28-80-56-80s-56 40-56 80zM76.7 307.3L65.4 296 88 273.4l11.3 11.3L184 369.4v-15-20h40v20V384v20 12.8c0 52.6-42.6 95.2-95.2 95.2c-25.2 0-49.5-10-67.3-27.9L12.7 435.3 1.4 424 24 401.4l11.3 11.3 24 24 9.4-9.4-56-56L1.4 360 24 337.4l11.3 11.3 56 56 9.4-9.4-72-72L17.4 312 40 289.4l11.3 11.3 72 72 9.4-9.4-56-56zm486.6 0l-56 56 9.4 9.4 72-72L600 289.4 622.6 312l-11.3 11.3-72 72 9.4 9.4 56-56L616 337.4 638.6 360l-11.3 11.3-56 56 9.4 9.4 24-24L616 401.4 638.6 424l-11.3 11.3-48.8 48.8C560.7 502 536.4 512 511.2 512c-52.6 0-95.2-42.6-95.2-95.2V404 384 354.4v-20h40v20 15l84.7-84.7L552 273.4 574.6 296l-11.3 11.3z"],
    "broccoli": [512, 512, [129382], "e3e2", "M0 352H96 416h96V256c0-45.5-31.6-83.6-74.1-93.5c6.4-10 10.1-21.8 10.1-34.5c0-35.3-28.7-64-64-64c-12.7 0-24.6 3.7-34.5 10.1C339.6 31.6 301.5 0 256 0s-83.6 31.6-93.5 74.1C152.6 67.7 140.7 64 128 64c-35.3 0-64 28.7-64 64c0 12.7 3.7 24.6 10.1 34.5C31.6 172.4 0 210.5 0 256v96zM200 512H312c18.4-55.3 44.9-100.1 63.9-128H280l-24 48-24-48H136.1c19.1 27.9 45.5 72.7 63.9 128z"],
    "route-interstate": [512, 512, [], "f61b", "M273 12.9L256 2.3 239 12.9c-29.7 18.6-53.7 28.5-78.3 32.6c-24.8 4.1-52.6 2.8-90.5-4.8L37.5 34.1 32.4 67.1C16.2 172.4 15 260.3 46.8 333.1c32.6 74.4 96.8 127.1 196.9 168.5l12.9 5.4 12.7-5.9c97.3-44.9 161.1-97.3 194.1-170.4c32.5-71.9 32.3-158 16.1-263.6l-5.1-33.1-32.8 6.6c-37.9 7.6-65.7 8.9-90.5 4.8c-24.6-4.1-48.6-14-78.3-32.6zM85.2 192H426.3c-.3 44.7-7 81.2-21.1 112.3c-22.9 50.7-67.7 92.7-149.9 132.6c-83.2-36.6-127.5-78.3-149.9-129.5c-14-31.9-20.4-69.6-20.2-115.4z"],
    "ear-muffs": [640, 512, [], "f795", "M96 0h32H512h32V32 208c-13.4-10-30-16-48-16c-5.5 0-10.8 .6-16 1.6V64H160V193.6c-5.2-1-10.5-1.6-16-1.6c-18 0-34.6 6-48 16V32 0zm83.8 304c7.6 8.5 12.2 19.7 12.2 32s-4.6 23.5-12.2 32c7.6 8.5 12.2 19.7 12.2 32s-4.6 23.5-12.2 32c7.6 8.5 12.2 19.7 12.2 32c0 26.5-21.5 48-48 48c-22.1 0-40.8-15-46.3-35.4C92.2 478.8 86.2 480 80 480c-26.5 0-48-21.5-48-48c0-6.2 1.2-12.2 3.4-17.7C15 408.8 0 390.1 0 368s15-40.8 35.4-46.3C33.2 316.2 32 310.2 32 304c0-26.5 21.5-48 48-48c6.2 0 12.2 1.2 17.7 3.4C103.2 239 121.9 224 144 224c26.5 0 48 21.5 48 48c0 12.3-4.6 23.5-12.2 32zm280.4 0c-7.6-8.5-12.2-19.7-12.2-32c0-26.5 21.5-48 48-48c22.1 0 40.8 15 46.3 35.4c5.5-2.2 11.4-3.4 17.7-3.4c26.5 0 48 21.5 48 48c0 6.2-1.2 12.2-3.4 17.7C625 327.2 640 345.9 640 368s-15 40.8-35.4 46.3c2.2 5.5 3.4 11.4 3.4 17.7c0 26.5-21.5 48-48 48c-6.2 0-12.2-1.2-17.7-3.4C536.8 497 518.1 512 496 512c-26.5 0-48-21.5-48-48c0-12.3 4.6-23.5 12.2-32c-7.6-8.5-12.2-19.7-12.2-32s4.6-23.5 12.2-32c-7.6-8.5-12.2-19.7-12.2-32s4.6-23.5 12.2-32z"],
    "hotdog": [512, 512, [127789], "f80f", "M207.2 463.2l256-256L512 256 256 512l-48.8-48.8zM0 256L256 0l48.8 48.8-256 256L0 256zM488.6 23.4c31.2 31.2 31.2 81.9 0 113.1l-352 352c-31.2 31.2-81.9 31.2-113.1 0s-31.2-81.9 0-113.1l352-352c31.2-31.2 81.9-31.2 113.1 0zm-35.4 88.5L439.9 82.8l-14.6 6.6-88 40-5.5 2.5-2.5 5.5-37.5 82.5-82.5 37.5-5.5 2.5-2.5 5.5-37.5 82.5L81.4 385.4l-14.6 6.6 13.2 29.1 14.6-6.6 88-40 5.5-2.5 2.5-5.5 37.5-82.5 82.5-37.5 5.5-2.5 2.5-5.5 37.5-82.5 82.5-37.5 14.6-6.6z"],
    "transporter-empty": [512, 512, [], "e046", "M96 448H416v64H96V448z"],
    "person-walking-with-cane": [512, 512, ["blind"], "f29d", "M176 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-48 32H108.2l-8.8 17.7-64 128L21.1 302.3l57.2 28.6 14.3-28.6L128 231.6v43.2c0 17 6.7 33.3 18.7 45.3L224 397.3V480v32h64V480 384 370.7l-9.4-9.4L224 306.7V288 213.3l70.4 93.9 19.2 25.6 51.2-38.4-19.2-25.6-96-128L240 128H224 128zm-7 248.2l-12 48-6 24-6 24-6 24L87 512h66l.1-.2 6-24 6-24 6-24 10-40.2-52.8-52.8L121 376.2zM446.5 498.8l9.1 13.2 26.3-18.2-9.1-13.2L360.2 317.9l-25.6 19.2 112 161.7z"],
    "angle-90": [448, 512, [], "e08d", "M64 64V32H0V64 448v32H32 416h32V416H416 64V64zM96 97.6v48.3c36.9 4.3 71.6 16 102.4 33.6l27.4-39.6C187 117.1 143 102.2 96 97.6zm129.3 99.4c29.4 21.6 54.2 49.1 72.9 80.5l41.7-23.8c-22.2-37.7-52-70.5-87.2-96.2l-27.3 39.5zM334.1 384h48.3c-3.6-36.1-13.2-70.4-27.7-102L312.8 306c10.8 24.3 18.1 50.6 21.3 78z"],
    "rectangle-terminal": [512, 512, [], "e236", "M0 32H512V480H0V32zM94.1 176l17 17 63 63-63 63-17 17L128 369.9l17-17 80-80 17-17-17-17-80-80-17-17L94.1 176zM248 336H224v48h24H392h24V336H392 248z"],
    "kite": [640, 512, [129665], "f6f4", "M344 0H318.6l-5.8 24.8-80 344-1.4 5.8L142.1 464H120V356.7l-24-10-24 10V488v24H96h56 9.9l7-7 96.4-96.4 5.8-1.4 344-80 24.8-5.8V296 32 0H608 344zM24 128H0v48H24 72V286L0 256v96l72-30 24-10 24 10 72 30V256l-72 30V152 128H96 24zM427.3 84.7L480 137.4l52.7-52.7L544 73.4 566.6 96l-11.3 11.3L502.6 160l52.7 52.7L566.6 224 544 246.6l-11.3-11.3L480 182.6 363.3 299.3 352 310.6 329.4 288l11.3-11.3L457.4 160l-52.7-52.7L393.4 96 416 73.4l11.3 11.3z"],
    "drum": [512, 512, [129345], "f569", "M521.2 62.9L501.2 76.1l-67.9 44.5C481.8 138.5 512 166.9 512 208v32V368c0 31.3-27.4 58.8-72 78.7V328v-9.3c-14.3 6.4-30.5 12-48 16.7v128c-33 8.9-71.1 14.5-112 16.1v-128c-7.9 .3-15.9 .5-24 .5s-16.1-.2-24-.5v128c-40.9-1.6-79-7.2-112-16.1v-128c-17.5-4.7-33.7-10.3-48-16.7V328 446.7C27.4 426.8 0 399.3 0 368V240 208C0 128 114.6 96 256 96c41 0 79.8 2.7 114.2 8.5L474.8 35.9l20.1-13.2 26.3 40.2zm-278.4 125l64.6-42.3C291.1 144.5 274 144 256 144c-68.2 0-125.4 7.9-163.6 22.7C53.6 181.8 48 197.4 48 208c0 .8 2.7 17.2 46 35.9c38.9 16.8 96 28.1 162 28.1s123.1-11.3 162-28.1c43.3-18.7 46-35.1 46-35.9c0-10.6-5.6-26.2-44.4-41.3c-11.5-4.5-24.7-8.3-39.4-11.5L269.2 228.1l-20.1 13.2-26.3-40.2 20.1-13.2z"],
    "scrubber": [512, 512, [], "f2f8", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-320a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"],
    "ice-cream": [448, 512, [127848], "f810", "M367.1 160c.6-5.3 .9-10.6 .9-16C368 64.5 303.5 0 224 0S80 64.5 80 144c0 5.4 .3 10.7 .9 16H80c-26.5 0-48 21.5-48 48v48H133.5h181H416V208c0-26.5-21.5-48-48-48h-.9zM96 288L224 512 352 288H96z"],
    "heart-circle-bolt": [576, 512, [], "e4fc", "M64 288L39.8 263.8C14.3 238.3 0 203.8 0 167.8C0 92.8 60.8 32 135.8 32c36 0 70.5 14.3 96 39.8L256 96l24.2-24.2c25.5-25.5 60-39.8 96-39.8C451.2 32 512 92.8 512 167.8c0 13.8-2.1 27.4-6.2 40.4C483.4 197.8 458.4 192 432 192c-97.2 0-176 78.8-176 176c0 32.2 8.6 62.3 23.7 88.3L256 480 64 288zm368-64a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm24 64L352 384h66.7L408 448l104-96H445.3L456 288z"],
    "fish-bones": [576, 512, [], "e304", "M32 96L0 128 64 256 0 384l32 32 64-64V304 280h40v72 24h48V352 280h48v72 24h48V352 280h48v72 24h48V352 280h40V400h32L576 256 448 112H416V232H376V160 136H328v24 72H280V160 136H232v24 72H184V160 136H136v24 72H96V208 160L32 96z"],
    "deer-rudolph": [576, 512, [], "f78f", "M256 16V0H224V16 40c0 30.9 25.1 56 56 56h16 24l-64 16v32h56l-9.6 32H224 128 113.9h-7.9C51.7 176 6.6 217.8 2.4 272L.1 302.2l-1.8 23.9 47.9 3.7 1.8-23.3c2.4 3.3 5.2 6.5 8.1 9.5L72.1 332 46.1 358.1 24.7 379.4 34.7 408 71.5 512H173.3L135.3 404.6l26.6-26.6L176 363.9V344v-3.4L240 368h48V512h96V368 304l26.7-80H416h96V175.2c2.6 .5 5.3 .8 8 .8c22.1 0 40-17.9 40-40s-17.9-40-40-40c-19.6 0-35.9 14.1-39.3 32.7L443.4 91.4c-.6-.6-1.1-1.1-1.7-1.6C459.7 80.4 472 61.7 472 40V16 0H440V16 40c0 13.3-10.7 24-24 24H377.3 346.6c3.5-7.3 5.4-15.4 5.4-24V16 0H320V16 40c0 13.3-10.7 24-24 24H280c-13.3 0-24-10.7-24-24V16zM384 144a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"],
    "fax": [512, 512, [128224, 128439], "f1ac", "M128 0V32 160h64V64H386.7L416 93.3V160h64V80 66.7l-9.4-9.4-48-48L413.3 0H400 160 128zM0 128V512H96V128H0zm512 64H128V512H512V192zM288 256v64H224V256h64zM224 384h64v64H224V384zM416 256v64H352V256h64zM352 384h64v64H352V384z"],
    "paragraph": [448, 512, [182], "f1dd", "M192 32h64H416h32V96H416 384l0 352v32H320V448l0-352H288V448v32H224V448 352H192c-88.4 0-160-71.6-160-160s71.6-160 160-160z"],
    "head-side-heart": [512, 512, [], "e1aa", "M0 224.2C0 100.6 100.2 0 224 0h32C358.1 0 441.6 79.7 447.7 180.3L505 252l7 8.8V272v16 32H480 448v96 32H416 320v32 32H288 96 64V480 381.2c-41-41.9-64-98.3-64-157zm112-37c0 16.1 6.6 31.5 18.2 42.7l82.8 79.6L224 320.1l11.1-10.7 82.8-79.6c11.6-11.2 18.2-26.6 18.2-42.7c0-32.7-26.5-59.2-59.2-59.2h-2.4c-15.9 0-31.2 6.2-42.7 17.2l-7.7 7.4-7.7-7.4c-11.5-11-26.8-17.2-42.7-17.2h-2.4c-32.7 0-59.2 26.5-59.2 59.2z"],
    "square-e": [448, 512, [], "e26d", "M448 32H0V480H448V32zM152 128H296h24v48H296 176v56h88 24v48H264 176v56H296h24v48H296 152 128V360 256 152 128h24z"],
    "meter-fire": [640, 512, [], "e1eb", "M256 512c33.4 0 65.3-6.4 94.6-18C312.1 458.9 288 408.3 288 352.2c0-47.2 24.9-91 53.7-128.2H320V192 160 128h64v32 16c20.1-20.3 41.7-39 64-57c15 12.2 29.8 24.5 43.9 37.5C453.1 64.5 362.1 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512zM192 160v32 32H128V192 160 128h64v32zm96 0v32 32H224V192 160 128h64v32zm225 64.1c-32.3-37.5-65-64-65-64s-128 103.6-128 192s71.6 160 160 160s160-71.6 160-160c0-73.6-96-160-96-160s-13.9 12.5-31 32zM530 433c-15 10-31 15-49 15c-45 0-81-29-81-78c0-24 15-45 45-82c4 5 62 79 62 79l36-42c3 4 5 8 7 12c18 33 10 75-20 96z"],
    "cloud-hail": [512, 512, [], "f739", "M96 320H0V224c0-41.8 26.7-77.4 64-90.5V112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H416 96zm0 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM32 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm160-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"],
    "check-to-slot": [576, 512, ["vote-yea"], "f772", "M96 32H480V384H96V32zM425.9 144L392 110.1l-17 17-111 111-47-47-17-17L166.1 208l17 17 64 64 17 17 17-17L409 161l17-17zM0 288H64V416H512V288h64V480H0V288z"],
    "money-from-bracket": [640, 512, [], "e312", "M32 0H608h32V32 160v32H576V160 64H64v96 32H0V160 32 0H32zM512 96l0 416-384 0 0-416 384 0zM256 448c0-35.3-28.7-64-64-64v64h64zm192-64c-35.3 0-64 28.7-64 64h64l0-64zM320 352c53 0 96-35.8 96-80s-43-80-96-80s-96 35.8-96 80s43 80 96 80z"],
    "star-half": [576, 512, [61731], "f089", "M288 .1L201.5 164 18.9 195.6 148.1 328.5 121.7 512 288 430.2V.1zM454.4 512l0 0 0 0h0z"],
    "car-bus": [640, 512, [], "f85a", "M384 38.4S299 0 192 0S0 38.4 0 38.4V96H0V416H48v64h80V416h64l0-160h39.2l10.7-32H208V96H320v32h64V64l0-25.6zM320 160H296.9l-7.3 21.9-14 42.1-21.3 64H224l0 160h0v64h80V448H560v64h80V448l0-160H609.7L574.4 181.9 567.1 160H544 384 320zm64 64H520.9l21.3 64H384 321.7l21.3-64H384zM176 96V224H64V96H176zM56 304a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm248 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm232 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "speaker": [384, 512, [], "f8df", "M0 0H384V512H0V0zM304 336A112 112 0 1 0 80 336a112 112 0 1 0 224 0zM192 272a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0-112a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "timer": [512, 512, [], "e29e", "M256 0H224V32 96v32h64V96 66.7C378.8 81.9 448 160.9 448 256c0 106-86 192-192 192S64 362 64 256c0-53.7 22-102.3 57.6-137.1l22.9-22.4L99.7 50.7 76.8 73.1C29.5 119.6 0 184.4 0 256C0 397.4 114.6 512 256 512s256-114.6 256-256S397.4 0 256 0zM193 159l-17-17L142.1 176l17 17 80 80 17 17L289.9 256l-17-17-80-80z"],
    "boxes-stacked": [576, 512, [62625, "boxes", "boxes-alt"], "f468", "M248 0H160V224H416V0H328V96H248V0zM104 256H0V512H288V256H184v96H104V256zM576 512V256H472v96H392V256H320V512H576z"],
    "grill-hot": [448, 512, [], "e5a5", "M144 0H96V24v2.6C96 48 106.7 68 124.5 79.8l12.4 8.3c4.5 3 7.1 8 7.1 13.3V104v24h48V104v-2.6C192 80 181.3 60 163.5 48.2l-12.4-8.3c-4.5-3-7.1-8-7.1-13.3V24 0zM256 0H208V24v2.6C208 48 218.7 68 236.5 79.8l12.4 8.3c4.5 3 7.1 8 7.1 13.3V104v24h48V104v-2.6C304 80 293.3 60 275.5 48.2l-12.4-8.3c-4.5-3-7.1-8-7.1-13.3V24 0zm74.1 357.3C400.3 319.5 448 245.3 448 160H0c0 85.3 47.7 159.5 117.9 197.3l-11.8 27.5c-3.3-.5-6.7-.8-10.1-.8c-35.3 0-64 28.7-64 64s28.7 64 64 64c26.9 0 49.9-16.5 59.3-40H327l2.9 6.8 4 9.3 9.5 22.1 44.1-18.9-9.5-22.1-4-9.3-44-102.6zM306.5 424H155.3c-2-5-4.7-9.7-7.8-14l14.8-34.6c19.6 5.6 40.3 8.6 61.6 8.6s42.1-3 61.6-8.6L306.5 424zM72 448a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "ballot-check": [448, 512, [], "f733", "M448 0H0V512H448V0zM64 96h64v64H64V96zm64 256v64H64V352h64zm80 16H368h16v32H368 208 192V368h16zM192 112h16H368h16v32H368 208 192V112zm16 128H368h16v32H368 208 192V240h16zm-41.4-16l-11.3 11.3-48 48L96 294.6 84.7 283.3l-24-24L49.4 248 72 225.4l11.3 11.3L96 249.4l36.7-36.7L144 201.4 166.6 224z"],
    "link": [640, 512, [128279, "chain"], "f0c1", "M580.2 267.3c56.2-56.2 56.2-147.4 0-203.6S432.8 7.4 376.6 63.7L365.3 75l45.3 45.3 11.3-11.3c31.2-31.2 81.9-31.2 113.1 0s31.2 81.9 0 113.1L421.8 335.2c-31.2 31.2-81.9 31.2-113.1 0c-25.6-25.6-30.3-64.3-13.8-94.6c1.8-3.4 3.9-6.7 6.3-9.8l-51.2-38.4c-4.3 5.7-8.1 11.6-11.4 17.8c-29.5 54.6-21.3 124.2 24.9 170.3c56.2 56.2 147.4 56.2 203.6 0L580.2 267.3zM59.8 244.7c-56.2 56.2-56.2 147.4 0 203.6s147.4 56.2 203.6 0L274.7 437l-45.3-45.3-11.3 11.3c-31.2 31.2-81.9 31.2-113.1 0s-31.2-81.9 0-113.1L218.2 176.8c31.2-31.2 81.9-31.2 113.1 0c25.6 25.6 30.3 64.3 13.8 94.6c-1.8 3.4-3.9 6.7-6.3 9.8l51.2 38.4c4.3-5.7 8.1-11.6 11.4-17.8c29.5-54.6 21.3-124.2-24.9-170.3c-56.2-56.2-147.4-56.2-203.6 0L59.8 244.7z"],
    "ear-listen": [512, 512, ["assistive-listening-systems"], "f2a2", "M455.5 48.3C483.5 78.6 512 126 512 192H448c0-46-19.5-78.6-39.5-100.3c-10.1-10.9-20.2-18.9-27.7-24.2c-3.7-2.6-6.8-4.5-8.7-5.6c-1-.6-1.7-1-2.1-1.2l-.3-.2 .1 0 0 0 0 0c0 0 0 0 14.3-28.6S398.3 3.4 398.3 3.4l0 0 .1 0 .2 .1 .4 .2c.3 .2 .7 .4 1.2 .7c1 .5 2.3 1.3 4 2.2c3.3 1.9 7.7 4.7 13 8.3c10.5 7.3 24.4 18.3 38.3 33.3zM160 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM32 448a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm54.6-86.6l64 64L173.3 448 128 493.3l-22.6-22.6-64-64L18.7 384 64 338.7l22.6 22.6zM240 128c-61.9 0-112 50.1-112 112H64c0-97.2 78.8-176 176-176s176 78.8 176 176c0 54.7-25 103.5-64 135.8V400c0 61.9-50.1 112-112 112H208V448h32c26.5 0 48-21.5 48-48V359.8 342.7l14.2-9.5C332.3 313 352 278.8 352 240c0-61.9-50.1-112-112-112zM208 240H160c0-44.2 35.8-80 80-80s80 35.8 80 80H272c0-17.7-14.3-32-32-32s-32 14.3-32 32z"],
    "file-minus": [384, 512, [], "f318", "M224 0H0V512H384V160H224V0zm32 0V128H384L256 0zM120 304H264h24v48H264 120 96V304h24z"],
    "tree-city": [640, 512, [], "e587", "M288 0H480V192h40V120 96h48v24 72h72V512H480 384 288V0zm64 64v64h64V64H352zm64 96H352v64h64V160zm-64 96v64h64V256H352zm224 0H512v64h64V256zm-64 96v64h64V352H512zM224 160c0 6-1 11-2 16c20 14 34 38 34 64v80H176 160V480v32H128 96V480 320H80 0V240c0-26 13-50 33-64c-1-5-1-10-1-16c0-53 42-96 96-96c53 0 96 43 96 96z"],
    "play": [384, 512, [9654], "f04b", "M384 256L0 32V480L384 256z"],
    "font": [448, 512, [], "f031", "M194 52.8L201.8 32h44.4L254 52.8 390.2 416H416h32v64H416 320 288V416h32 1.8l-18-48H144.2l-18 48H128h32v64H128 32 0V416H32 57.8L194 52.8zM168.2 304H279.8L224 155.1 168.2 304z"],
    "cup-togo": [448, 512, ["coffee-togo"], "f6c5", "M64 0H384l32 64h32v64H416 32 0V64H32L64 0zM80 512L48 160H400L368 512H80zM327 256H121l14.5 160H312.5L327 256z"],
    "square-down-left": [448, 512, [], "e26b", "M448 480H0V32H448V480zM128 192V352H288l24-24-52-52 76-76-56-56-76 76-52-52-24 24z"],
    "burger-lettuce": [512, 512, [], "e3e3", "M32 192v32H480V192s0-160-224-160S32 192 32 192zm96-80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm240 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM256 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM480 384H32v96H480V384zM178.9 257.9L168 254l-10.9 4-76.9 28L27.2 266 4.8 326l64 24 11.1 4.2 11.1-4 77.1-28 77.1 28 10.9 4 10.9-4 77.1-28 77.1 28 11.1 4 11.1-4.2 64-24L484.8 266l-52.9 19.9-76.9-28L344 254l-10.9 4L256 286l-77.1-28z"],
    "rupiah-sign": [512, 512, [], "e23d", "M0 32H32h80c79.5 0 144 64.5 144 144c0 59.6-36.2 110.7-87.8 132.6l54.3 169.6 .6 1.8H155.8L104.6 320H64V480H0V288 64 32zM64 256h48c44.2 0 80-35.8 80-80s-35.8-80-80-80H64V256zm224-96h32 80c61.9 0 112 50.1 112 112s-50.1 112-112 112H352V512H288V352 192 160zm64 160h48c26.5 0 48-21.5 48-48s-21.5-48-48-48H352v96z"],
    "magnifying-glass": [512, 512, [128269, "search"], "f002", "M416 208c0 45.9-14.9 88.3-40 122.7L486.6 441.4 509.3 464 464 509.3l-22.6-22.6L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"],
    "table-tennis-paddle-ball": [640, 512, [127955, "ping-pong-paddle-ball", "table-tennis"], "f45d", "M480 288c-50.1 0-93.6 28.8-114.6 70.8L132.9 126.3l60.7-60.7c87.5-87.5 229.3-87.5 316.8 0c67.1 67.1 82.7 166.3 46.8 248.3C535.8 297.6 509 288 480 288zM110.3 148.9L354.1 392.7c-1.4 7.5-2.1 15.3-2.1 23.3c0 23.3 6.2 45.2 17.1 64H304l-75.4-75.4L128 512 64 448 171.4 347.4 96 272l0-108.8 14.3-14.3zM480 320a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"],
    "person-dots-from-line": [576, 512, ["diagnoses"], "f470", "M288 176A88 88 0 1 0 288 0a88 88 0 1 0 0 176zm-64 32H213.6l-9.5 4.3-76.7 34.8C124 270.3 104.1 288 80 288c-9.5 0-18.4-2.8-25.8-7.5l-10 4.6L.4 304.9l39.7 87.4 43.7-19.9L176 330.5V432H400V330.5l92.1 41.9 43.7 19.9 39.7-87.4L531.9 285l-31.1-14.1c-8.8 10.5-22 17.1-36.7 17.1c-26.5 0-48-21.5-48-48c0-2.5 .2-5 .6-7.4l-44.7-20.3-9.5-4.3H352 224zM24 464H0v48H24 552h24V464H552 24zM224 280a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM96 240a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm368 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"],
    "chevrons-down": [512, 512, ["chevron-double-down"], "f322", "M278.6 278.6L256 301.3l-22.6-22.6-192-192L18.7 64 64 18.7 86.6 41.4 256 210.7 425.4 41.4 448 18.7 493.3 64 470.6 86.6l-192 192zm0 192L256 493.3l-22.6-22.6-192-192L18.7 256 64 210.7l22.6 22.6L256 402.7 425.4 233.4 448 210.7 493.3 256l-22.6 22.6-192 192z"],
    "trash-can-arrow-up": [448, 512, ["trash-restore-alt"], "f82a", "M304 0l16 32H448V96H0V32H128L144 0H304zM32 128H416V512H32V128zm209 71l-17-17-17 17-80 80-17 17L144 329.9l17-17 39-39V408v24h48V408 273.9l39 39 17 17L337.9 296l-17-17-80-80z"],
    "signal-good": [640, 512, ["signal-3"], "f68e", "M352 192v32V480v32H288V480 224 192h64zM224 288v32V480v32H160V480 320 288h64zM96 416v64 32H32V480 416 384H96v32z"],
    "location-question": [384, 512, ["map-marker-question"], "f60b", "M192 512s192-208 192-320C384 86 298 0 192 0S0 86 0 192C0 304 192 512 192 512zM104 152c0-30.9 25.1-56 56-56h56.9c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L216 232.4V240v24H168V240 218.5 204.6l12.1-6.9 44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H160c-4.4 0-8 3.6-8 8l0 6.5-48 0V152zm64 152h48v48H168V304z"],
    "floppy-disk-circle-xmark": [576, 512, ["floppy-disk-times", "save-circle-xmark", "save-times"], "e181", "M32 32H0V64 448v32H32 296.2c-17.6-21.4-30.3-46.9-36.3-75c-10.2 6.9-22.6 11-35.9 11c-35.3 0-64-28.7-64-64s28.7-64 64-64c16.8 0 32.1 6.5 43.6 17.1C292.9 239 357 192 432 192c5.4 0 10.7 .2 16 .7V160 146.7l-9.4-9.4-96-96L333.3 32H320 32zM64 96H320V224H64V96zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7L454.6 368l36.7 36.7L502.6 416 480 438.6l-11.3-11.3L432 390.6l-36.7 36.7L384 438.6 361.4 416l11.3-11.3L409.4 368l-36.7-36.7L361.4 320 384 297.4l11.3 11.3L432 345.4l36.7-36.7L480 297.4 502.6 320l-11.3 11.3z"],
    "naira-sign": [448, 512, [], "e1f6", "M96 32H64V64 256H32 0v64H32 64V448v32h64V448 320h98.9l92.8 145.2 9.4 14.8h17.5H352h32V448 320h32 32V256H416 384V64 32H320V64 256H262L128.3 46.8 118.9 32H101.3 96zM302.9 320H320v26.8L302.9 320zM186 256H128V165.2L186 256z"],
    "peach": [512, 512, [], "e20b", "M344 80c-31.5 0-61.4 7.3-88 20.4C229.4 87.3 199.5 80 168 80c-10 0-19.9 .7-29.6 2.2C122.1 64.9 112 41.6 112 16V0h16 32c53 0 96 43 96 96c0-53 43-96 96-96h32 16V16c0 25.6-10.1 48.9-26.4 66.2C363.9 80.7 354 80 344 80zM168 112c31.9 0 61.7 8.9 87.1 24.3l.9 .5c48 29.6 80 82.6 80 143.1h32c0-64.8-30.8-122.4-78.6-158.9c17.1-5.9 35.5-9.1 54.6-9.1c92.8 0 168 75.2 168 168c0 152-256 232-256 232s-256-80-256-232c0-92.8 75.2-168 168-168z"],
    "taxi-bus": [640, 512, [], "e298", "M192 0C299 0 384 38.4 384 38.4L384 64V96H320 208V224h33.9l-10.7 32H192l0 160H128v64H48V416H0V96H0V38.4S85 0 192 0zM384 224H343.1l-21.3 64H384 542.3l-21.3-64H384zM224 288h30.3l21.3-64 14-42.1 7.3-21.9H320h48V128H496v32h48 23.1l7.3 21.9L609.7 288H640l0 160v64H560V448H304v64H224V448h0l0-160zM64 96V224H176V96H64zM80 328a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm248 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm256 0a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"],
    "bracket-curly": [256, 512, ["bracket-curly-left"], "7b", "M96 32H64V64 178.7L9.4 233.4 0 242.7v26.5l9.4 9.4L64 333.3V448v32H96h96 32V416H192 128V320 306.7l-9.4-9.4L77.3 256l41.4-41.4 9.4-9.4V192 96h64 32V32H192 96z"],
    "lobster": [512, 512, [129438], "e421", "M80 2V96l42.9-57.2c3.3 7.7 5.1 16.2 5.1 25.2v64c0 14.9-5.1 28.6-13.6 39.4L151.3 192h46.5c2.7-7.3 6.2-14 10.2-20.2V53.6l-34.6-5.8-15.8-2.6 5.3-31.6 15.8 2.6 48 8L240 26.4V40v98c5.9-4.4 11.4-7.7 16-10c4.6 2.3 10.1 5.6 16 10V40 26.4l13.4-2.2 48-8 15.8-2.6 5.3 31.6-15.8 2.6L304 53.6V171.8c4 6.2 7.5 13 10.2 20.2h46.5l36.9-24.6C389.1 156.6 384 142.9 384 128V64c0-8.9 1.8-17.4 5.1-25.2L432 96V2c5.1-1.3 10.5-2 16-2c35.3 0 64 28.7 64 64v64c0 35.3-28.7 64-64 64l-.7 0-66 44-6 4H368 320v16h60.2l44.6-22.3 14.3-7.2 14.3 28.6-14.3 7.2-48 24-3.4 1.7H384 320v16h77.4l45.5-15.2 15.2-5.1 10.1 30.4-15.2 5.1-48 16-2.5 .8H400 320v16h32 3.8l3.4 1.7 32 16 14.3 7.2-14.3 28.6-14.3-7.2L348.2 384H320l-21.6 64.8c30.4 5 53.6 31.4 53.6 63.2H160c0-31.8 23.2-58.2 53.6-63.2L192 384H163.8l-28.6 14.3-14.3 7.2-14.3-28.6 14.3-7.2 32-16 3.4-1.7H160h32V336H112h-2.6l-2.5-.8-48-16-15.2-5.1 10.1-30.4 15.2 5.1L114.6 304H192V288H128h-3.8l-3.4-1.7-48-24-14.3-7.2 14.3-28.6 14.3 7.2L131.8 256H192V240H144h-7.3l-6-4-66-44-.7 0c-35.3 0-64-28.7-64-64V64C0 28.7 28.7 0 64 0c5.5 0 10.9 .7 16 2z"],
    "cart-flatbed-empty": [640, 512, ["dolly-flatbed-empty"], "f476", "M0 0H32 96h32V32 384H608h32v64H608 541.3c1.8 5 2.7 10.4 2.7 16c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16H253.3c1.8 5 2.7 10.4 2.7 16c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16H96 64V416 64H32 0V0z"],
    "colon": [192, 512, [], "3a", "M160 64H32V192H160V64zm0 256H32V448H160V320z"],
    "cart-arrow-down": [576, 512, [], "f218", "M312 32H122l-2.4-12.5L115.9 0H96 24 0V48H24 76.1l60.3 316.5 3.7 19.5H160 488h24V336H488 179.9l-9.1-48H496L576 32H360v99.1l24.2-21.2 18.1-15.8 31.6 36.1-18.1 15.8-64 56L336 215.9l-15.8-13.8-64-56-18.1-15.8 31.6-36.1 18.1 15.8L312 131.1V32zM224 464a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm240 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"],
    "wand": [512, 512, [], "f72a", "M80 512L0 432 128 316.8V256h67.6L480 0l32 32L416 138.7V192H368L80 512z"],
    "walkie-talkie": [384, 512, [], "f8ef", "M112 24V0H64V24 96H0V320l32 32V512H352V352l32-32V96H320V64H256V96H224V64H160V96H112V24zm0 136H272h16v32H272 112 96V160h16zm0 64H272h16v32H272 112 96V224h16zm0 64H272h16v32H272 112 96V288h16z"],
    "file-pen": [576, 512, [128221, "file-edit"], "f31c", "M0 0H224V160H384V300.4l-117 117L253.4 512H0V0zM384 128H256V0L384 128zm121 95.8l71 71-41.3 41.3-71-71L505 223.8zm-63.9 63.9l71 71L370.9 500 288 511.9 299.9 429 441.1 287.8z"],
    "receipt": [384, 512, [129534], "f543", "M0 0V512l64-48 64 48 64-48 64 48 64-48 64 48V0L320 48 256 0 192 48 128 0 64 48 0 0zM96 144H288h16v32H288 96 80V144H96zM80 336H96 288h16v32H288 96 80V336zm16-96H288h16v32H288 96 80V240H96z"],
    "table-picnic": [512, 512, [], "e32d", "M64 64H96 416h32v64H416 367.3l38.4 96H480h32v64H480 431.3 362.3 149.7 80.7 32 0V224H32h74.3l38.4-96H96 64V64zm3.9 256h68.9l-11.2 27.9-32 80-8 20.1H16.7l17.6-43.9 32-80 1.6-4.1zm307.2 0h68.9l33.6 84.1L495.3 448H426.3l-8-20.1L375.1 320zM213.7 128l-38.4 96H336.7l-38.4-96H213.7z"],
    "square-pen": [448, 512, ["pen-square", "pencil-square"], "f14b", "M448 32H0V480H448V32zM112 288L220.7 179.3l80 80L192 368 96 384l16-96zm256-96l-44.7 44.7-80-80L288 112l80 80z"],
    "circle-microphone-lines": [512, 512, ["microphone-circle-alt"], "e117", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM208 96V256c0 26.5 21.5 48 48 48s48-21.5 48-48V240H272 256V208h16 32V176H272 256V144h16 32V96H208zM160 240V224H128v16 16c0 65.3 48.9 119.1 112 127v17 16h32V400 383c63.1-7.9 112-61.7 112-127V240 224H352v16 16c0 53-43 96-96 96s-96-43-96-96V240z"],
    "display-slash": [640, 512, ["desktop-slash"], "e2fa", "M608 0H32V2.1l-2.6-2L0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L565.2 416H608V0zM482.7 352L111.8 64H544V352H482.7zM32 416H272l-10.7 32H192 160v64h32H448h32V474.3L446.6 448H378.7L368 416h38l-81.2-64H96V171.8L32 121.4V416z"],
    "suitcase-rolling": [384, 512, [], "f5c1", "M120 0H96V24 128H0V480H64v32h64V480H256v32h64V480h64V128H288V24 0H264 120zM240 128H144V48h96v80zM112 224H272h16v32H272 112 96V224h16zm0 128H272h16v32H272 112 96V352h16z"],
    "person-circle-exclamation": [576, 512, [], "e53f", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM91.4 128h17.5H211.1h17.5l9.4 14.8 66.4 104c-15.5 16.3-28 35.7-36.3 57l-2.3 1.4-33.8-53V480v32H168V480 352H152V480v32H88V480 252.2l-33.8 53L.2 270.8 82 142.8 91.4 128zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 224V416H416v32h32zm0-176H416v16 80 16h32V368 288 272z"],
    "transporter-2": [512, 512, [], "e044", "M64 32L48 0 32 32 0 48 32 64 48 96 64 64 96 48 64 32zM256 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-51.1 32H189.6l-9.6 12-67.3 84H399.4L332 140l-9.6-12H307.1 204.9zM416 512V448H96v64H216h80H416zM96 255.5c0 .3 0 .7 0 1V288h16H400h16V256H400 112 96v-.5zM464 320l-16 32-32 16 32 16 16 32 16-32 32-16-32-16-16-32zm-288 0H160v32h16H336h16V320H336 176zm0 64H160v32h16H336h16V384H336 176z"],
    "hands-holding-diamond": [640, 512, ["hand-receiving"], "f47c", "M320 256L448 128 320 0 192 128 320 256zM80 64H0v40 24 32 64V352v13.3l9.4 9.4 128 128 9.4 9.4H160h96 32V480 448 416 352 338.7l-9.4-9.4-64-64L192 242.7l-9.4-9.4L160 210.7 114.7 256l22.6 22.6 9.4 9.4 22.6 22.6L205.8 347l-41.7 27.8L80 290.7V224 144 112v-8V64zm480 0v40 8 32 80 66.7l-84.1 84.1L434.2 347l36.4-36.4L493.3 288l9.4-9.4L525.3 256 480 210.7l-22.6 22.6-9.4 9.4-22.6 22.6-64 64-9.4 9.4V352v64 32 32 32h32 96 13.3l9.4-9.4 128-128 9.4-9.4V352 224 160 128 104 64H560z"],
    "money-bill-simple-wave": [576, 512, [], "e1f2", "M0 60.3V451.7c96 48.9 192 24.5 288 0s192-48.9 288 0V60.3c-96-48.9-192-24.5-288 0s-192 48.9-288 0zM288 352c-44.2 0-80-43-80-96s35.8-96 80-96s80 43 80 96s-35.8 96-80 96z"],
    "chevron-down": [512, 512, [], "f078", "M256 429.3l22.6-22.6 192-192L493.3 192 448 146.7l-22.6 22.6L256 338.7 86.6 169.4 64 146.7 18.7 192l22.6 22.6 192 192L256 429.3z"],
    "battery-full": [576, 512, [128267, "battery", "battery-5"], "f240", "M480 160V352H64V160H480zM64 96H0v64V352v64H64 480h64V352 320h32V192H544V160 96H480 64zm384 96H96V320H448V192z"],
    "bell-plus": [448, 512, [], "f849", "M256 0H192V51.2C119 66 64 130.6 64 208v88L0 368v48H448V368l-64-72V208c0-77.4-55-142-128-156.8V0zm32 448H224 160c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7s18.7-28.3 18.7-45.3zM248 152v24 40h40 24v48H288 248v40 24H200V304 264H160 136V216h24 40V176 152h48z"],
    "book-arrow-right": [640, 512, [], "e0b9", "M96 0C43 0 0 43 0 96V416c0 53 43 96 96 96H384h32 32V448H416V384h32V232h94.1l-39 39-17 17L520 321.9l17-17 80-80 17-17-17-17-80-80-17-17L486.1 128l17 17 39 39H448V0H416 384 96zM448 184v48H248 224V184h24H448zM96 384H352v64H96c-17.7 0-32-14.3-32-32s14.3-32 32-32z"],
    "hospitals": [576, 512, [], "f80e", "M576 0H256V64h64V512H576V384H464 448V352h16H576V288H464 448V256h16H576V0zM408 80h48v40h40v48H456v40H408V168H368V120h40V80zM0 96V384H144h16v32H144 0v96H288V96H0zm120 80h48v40h40v48H168v40H120V264H80V216h40V176z"],
    "club": [512, 512, [9827], "f327", "M380 160.1c2.6-10.2 4-21 4-32.1C384 57.3 326.7 0 256 0S128 57.3 128 128c0 11.1 1.4 21.8 4 32.1c-1.3 0-2.7-.1-4-.1C57.3 160 0 217.3 0 288s57.3 128 128 128c38.2 0 72.5-16.8 96-43.3V448H192 160v64h32 32 64 32 32V448H320 288V372.7c23.5 26.6 57.8 43.3 96 43.3c70.7 0 128-57.3 128-128s-57.3-128-128-128c-1.4 0-2.7 0-4 .1z"],
    "skull-crossbones": [448, 512, [128369, 9760], "f714", "M368 128c0 44.4-25.4 83.5-64 106.4V288H144V234.4c-38.6-23-64-62.1-64-106.4C80 57.3 144.5 0 224 0s144 57.3 144 128zM168 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm144-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM16.7 245.4l29 13.6L224 343l178.4-84 29-13.6 27.3 57.9-29 13.6L299.1 378.4l130.5 61.4 29 13.6-27.3 57.9-29-13.6L224 413.8l-178.4 84-29 13.6-27.3-57.9 29-13.6 130.5-61.4L18.4 317l-29-13.6 27.3-57.9z"],
    "droplet-degree": [512, 512, ["dewpoint"], "f748", "M192 512c106 0 192-86 192-192S192 0 192 0S0 214 0 320S86 512 192 512zM400 112a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"],
    "code-compare": [512, 512, [], "e13a", "M288 320l-96 96 96 96h32V448h16c70.7 0 128-57.3 128-128V160h48V104 56 0H456 408 352V56v48 56h48V320c0 35.3-28.7 64-64 64H320V320H288zM408 56h48v48H408V56zM224 0H192V64H176C105.3 64 48 121.3 48 192V352H0v56 48 56H56h48 56V456 408 352H112V192c0-35.3 28.7-64 64-64h16v64h32l96-96L224 0zM56 408h48v48H56V408z"],
    "list-ul": [512, 512, ["list-dots"], "f0ca", "M64 144a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM192 64H160v64h32H480h32V64H480 192zm0 160H160v64h32H480h32V224H480 192zm0 160H160v64h32H480h32V384H480 192zM64 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm48-208a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"],
    "hand-holding-magic": [576, 512, [], "f6e5", "M192 80c0-8.8 7.2-16 16-16H320c35.3 0 64 28.7 64 64s-28.7 64-64 64H256 224v32 32 32h64V256h32c70.7 0 128-57.3 128-128S390.7 0 320 0H208c-44.2 0-80 35.8-80 80s35.8 80 80 80h80 32V96H288 208c-8.8 0-16-7.2-16-16zM140 327L68.8 384H0V512H32 224 384h12.4l10.2-7 128-88 33-22.7-45.3-65.9-33 22.7-94.5 65H256V384h32 64 32V320H352 288 224 160 148.8l-8.8 7z"],
    "watermelon-slice": [512, 512, [], "e337", "M391.4 391.4C294.6 488.2 137.9 487.9 41 391L7 425c115.6 115.6 302.6 116 418.3 .3S540.5 122.6 425 7L391 41c96.9 96.9 97.1 253.6 .3 350.4zM63.3 368.7c84.4 84.4 221.1 84.4 305.5 0c84.2-84.2 84.4-220.7 .3-305.1L353.5 48 48 353.5l15.3 15.3zM320 137.4l11.3 11.3 16 16L358.6 176 336 198.6l-11.3-11.3-16-16L297.4 160 320 137.4zm-80 80l11.3 11.3 16 16L278.6 256 256 278.6l-11.3-11.3-16-16L217.4 240 240 217.4zm88 8l11.3 11.3 16 16L366.6 264 344 286.6l-11.3-11.3-16-16L305.4 248 328 225.4zm-168 72l11.3 11.3 16 16L198.6 336 176 358.6l-11.3-11.3-16-16L137.4 320 160 297.4zm88 8l11.3 11.3 16 16L286.6 344 264 366.6l-11.3-11.3-16-16L225.4 328 248 305.4z"],
    "circle-ellipsis": [512, 512, [], "e10a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 224v64H128V224h64zm192 0v64H320V224h64zm-160 0h64v64H224V224z"],
    "school-lock": [640, 512, [], "e56f", "M384 288l0 64H320c-35.3 0-64 28.7-64 64v96H0V96H160L320 0 480 96H640V272c0-61.9-50.1-112-112-112s-112 50.1-112 112v16H384zM80 192v96h64V192H80zm0 128v96h64V320H80zm240-56a88 88 0 1 0 0-176 88 88 0 1 0 0 176zm16-120v16h16 16v32H352 320 304V176 144 128h32v16zm192 96c-17.7 0-32 14.3-32 32v48h64V272c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80v48h32V512H416V320h32V272z"],
    "tower-cell": [576, 512, [], "e585", "M87.6 27.8L32 0 17.4 29.2C6.1 60 0 93.3 0 128s6.1 68 17.4 98.8L32 256l55.6-27.8C72.5 198 64 164 64 128s8.5-70 23.6-100.2zm42.9 21.5C118.7 73 112 99.7 112 128s6.7 55 18.5 78.7l42.9-21.5C164.9 168 160 148.6 160 128s4.9-40 13.5-57.3L130.5 49.3zm272 21.5C411.1 88 416 107.4 416 128s-4.9 40-13.5 57.3l42.9 21.5C457.3 183 464 156.3 464 128s-6.7-55-18.5-78.7L402.5 70.7zm85.9 157.5L544 256l14.6-29.2C569.9 196 576 162.7 576 128s-6.1-68-17.4-98.8L544 0 488.4 27.8C503.5 58 512 92 512 128s-8.5 70-23.6 100.2zM239.1 169.3L80 512h70.6l29.7-64H395.7l29.7 64H496L336.9 169.3c9.4-11.1 15.1-25.6 15.1-41.3c0-35.3-28.7-64-64-64s-64 28.7-64 64c0 15.7 5.7 30.2 15.1 41.3zM366 384H210l14.9-32H351.2L366 384zM288 216l33.4 72H254.6L288 216z"],
    "sd-cards": [448, 512, [], "e240", "M416 0H224 210.7l-9.4 9.4-96 96L96 114.7V128 384v32h32H416h32V384 32 0H416zM304 64V88v48 24H256V136 88 64h48zm80 0V88v48 24H336V136 88 64h48zM48 120V96H0v24V488v24H24 360h24V464H360 48V120z"],
    "jug-bottle": [640, 512, [], "e5fb", "M224 0H96V48H64V96H256V48H224V0zM128 128C57.3 128 0 185.3 0 256V512H384V128H128zm192 96V384H256V224h64zM576 64H448v64H576V64zM448.3 160L416 175.1V512H608l32-32V416l-24-24 24-24V304l-24-24 24-24V190.1L575.7 160H448.3z"],
    "down-long": [320, 512, ["long-arrow-alt-down"], "f309", "M160 512L0 352l0-32 96 0L96 0 224 0l0 320 96 0 0 32L160 512z"],
    "envelopes": [576, 512, [], "e170", "M336 299.7l-9.3-6.6L96 128.2V384H576V128.2L345.3 293l-9.3 6.6zm233.3-206l6.7-4.8V32H96V88.9l6.7 4.8L336 260.3 569.3 93.7zM48 120V96H0v24V456v24H24 456h24V432H456 48V120z"],
    "phone-office": [576, 512, [], "f67d", "M224 0H96V32 384v32h32 64 32V384 32 0zM64 32H0V512H576V32H256V416v32H224 96 64V416 32zM320 96H512v96H320V96zm64 160v64H320V256h64zm64 0h64v64H448V256zm64 128v64H448V384h64zm-192 0h64v64H320V384z"],
    "ranking-star": [640, 512, [], "e561", "M351.8 62.3L320 0 288.2 62.3l-69 11 49.4 49.5L257.7 192 320 160.3 382.3 192l-10.9-69.1 49.4-49.5-69-11zM416 256H224V512H416V256zM192 320H0V512H192V320zm256 64V512H640V384H448z"],
    "chess-king": [448, 512, [9818], "f43f", "M256 0V32 48h16 32v64H272 256v48H448v48L368 400H80L0 208V160H192V112H176 144V48h32 16V32 0h64zM32 512V480l48-48H368l48 48v32H32z"],
    "nfc-pen": [576, 512, [], "e1fa", "M0 32H448V236.4l-64 64V112 96H368 224 208v16 98.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3V128H352V332.4L300.4 384H96V128h48 16V96H144 80 64v16V400v16H80 268.4l-1.4 1.4L258 480H0V32zM505 223.8l71 71-41.3 41.3-71-71L505 223.8zm-63.9 63.9l71 71L370.9 500 288 511.9 299.9 429 441.1 287.8z"],
    "person-harassing": [576, 512, [], "e549", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM59.4 304.5L88 256.9V480v32h64V480 352h16V480v32h64V480 235.6l60.1 72.8 49.3-40.8-105.7-128L226.1 128H211.1 108.9 90.8l-9.3 15.5L4.6 271.5l54.9 33zM480 240a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm18.7 48l-9.4 9.4-16 16-9.4 9.4V336v66.7l-41.4-41.4L372.9 367l-48 76.8-17 27.1 54.3 33.9 17-27.1 26.7-42.7 57.6 57.6c12.4 12.4 29.1 19.3 46.6 19.3c36.4 0 65.9-29.5 65.9-65.9V320 288H544 512 498.7zM288 32V64h16 56 16V32H360 304 288zm-.8 65.7l-14.3-7.2-14.3 28.6 14.3 7.2 48 24 14.3 7.2 14.3-28.6-14.3-7.2-48-24z"],
    "hat-winter": [512, 512, [], "f7a8", "M256 0l23.3 23.8 33.3-.4-.4 33.3L336 80l-23.8 23.3 .4 33.3-33.3-.4L256 160l-23.3-23.8-33.3 .4 .4-33.3L176 80l23.8-23.3-.4-33.3 33.3 .4L256 0zM0 448H32 480h32v64H480 32 0V448zM60.8 292.5C80.3 243.2 113 191.7 167.1 164.2L167 169l32.8-.4 19.6-.2 13.7 14L256 205.8l22.9-23.4 13.7-14 19.6 .2L345 169l-.1-4.8c54.1 27.5 86.8 79 106.3 128.3l-18.7 9.4-48.6-27.8-7.9-4.5-7.9 4.5-48.6 27.8-56.3-28.2-7.2-3.6-7.2 3.6-56.3 28.2-48.6-27.8-7.9-4.5-7.9 4.5L79.5 301.9l-18.7-9.4zM50.1 322.9l22.7 11.4 7.7 3.8 7.4-4.2L136 306.4l48.1 27.5 7.4 4.2 7.7-3.8L256 305.9l56.8 28.4 7.7 3.8 7.4-4.2L376 306.4l48.1 27.5 7.4 4.2 7.7-3.8 22.7-11.4C477.5 374 480 416 480 416H32s2.5-42 18.1-93.1z"],
    "brazilian-real-sign": [512, 512, [], "e46c", "M432 32V0H368V32 54.2C321.5 70 288 114 288 165.9c0 48.2 29.3 91.5 74.1 109.4l52 20.8c20.5 8.2 33.9 28 33.9 50v3.4c0 27.9-22.6 50.5-50.5 50.5c-12.9 0-25.6-3.8-36.3-11l-23.4-15.6-35.5 53.3 23.4 15.6c13 8.6 27.3 14.8 42.3 18.3V480v32h64V480 458.7c46.4-14.6 80-58 80-109.2v-3.4c0-48.2-29.3-91.5-74.1-109.4l-52-20.8c-20.5-8.2-33.9-28-33.9-50c0-29.7 24.1-53.9 53.9-53.9h1.7c11.1 0 22 2.6 32 7.5l10.2 5.1 28.6-57.2-10.1-5.1c-11.5-5.7-23.6-9.8-36.2-12.1V32zM0 32V64 288 480H64V320h40.6l51.2 160H223l-.6-1.8L168.2 308.6c51.6-21.9 87.8-73 87.8-132.6c0-79.5-64.5-144-144-144H32 0zM64 256V96h48c44.2 0 80 35.8 80 80s-35.8 80-80 80H64z"],
    "landmark-dome": [512, 512, ["landmark-alt"], "f752", "M288 0H224V34.7C143.6 48.1 80.1 111.6 66.7 192H64 32v64H64 448h32V192H448h-2.7C431.9 111.6 368.4 48.1 288 34.7V0zM0 464v48H512V464l-64-48V288H384V416H344V288H280V416H232V288H168V416H128V288H64V416L0 464z"],
    "bone-break": [640, 512, [], "f5d8", "M344 32V8H296V32v72 24h48V104 32zM201 71l-17-17L150.1 88l17 17 48 48 17 17L265.9 136l-17-17L201 71zM473 105l17-17L456 54.1 439 71l-48 48-17 17L408 169.9l17-17 48-48zM157 250.2c-9.5-33.6-40.4-58.2-77-58.2c-44.2 0-80 35.8-80 80c0 38.6 27.3 70.8 63.7 78.3L66.8 366C45.8 380.4 32 404.6 32 432c0 44.2 35.8 80 80 80s80-35.8 80-80c0-7.6-1-14.9-3-21.8L320 384l131 26.2c-2 6.9-3 14.2-3 21.8c0 44.2 35.8 80 80 80s80-35.8 80-80c0-27.4-13.8-51.6-34.8-66l3.1-15.7c36.3-7.5 63.7-39.7 63.7-78.3c0-44.2-35.8-80-80-80c-36.6 0-67.5 24.6-77 58.2L352 224 320 384 288 224 157 250.2z"],
    "arrow-up": [384, 512, [8593], "f062", "M214.6 57.4L192 34.7 169.4 57.4l-144 144L2.7 224 48 269.2l22.6-22.6L160 157.2V448v32h64V448 157.2l89.4 89.4L336 269.2 381.3 224l-22.6-22.6-144-144z"],
    "down-from-dotted-line": [448, 512, [], "e407", "M64 320L224 480 384 320V288H288V128H160V288H64v32zM64 96V32H0V96H64zm96 0V32H96V96h64zm32-64V96h64V32H192zM352 96V32H288V96h64zm32 0h64V32H384V96z"],
    "tv": [640, 512, [63717, "television", "tv-alt"], "f26c", "M64 64V352H576V64H64zM0 0H64 576h64V64 352v64H576 64 0V352 64 0zM128 448H512h32v64H512 128 96V448h32z"],
    "border-left": [448, 512, [], "f84f", "M0 480L0 32l64 0 0 448L0 480zm96 0l0-64 64 0 0 64-64 0zM96 32l64 0 0 64L96 96l0-64zm0 256l0-64 64 0 0 64-64 0zM288 416l64 0 0 64-64 0 0-64zm0-320l0-64 64 0 0 64-64 0zm0 128l64 0 0 64-64 0 0-64zM192 480l0-64 64 0 0 64-64 0zm0-448l64 0 0 64-64 0 0-64zm0 256l0-64 64 0 0 64-64 0zM384 416l64 0 0 64-64 0 0-64zm0-320l0-64 64 0 0 64-64 0zm0 128l64 0 0 64-64 0 0-64zM192 384l0-64 64 0 0 64-64 0zm192-64l64 0 0 64-64 0 0-64zm0-128l0-64 64 0 0 64-64 0zM192 128l64 0 0 64-64 0 0-64z"],
    "circle-divide": [512, 512, [], "e106", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm32-320H224V128h64v64zM168 232H344h24v48H344 168 144V232h24zm56 152V320h64v64H224z"],
    "shrimp": [512, 512, [129424], "e448", "M16 32H0V48v96 16H16 65c3.7 88.9 77 160 167 160h56V128H264 88.8 32V64H464h16V32H464 16zM320 320h18.3c9.9 0 19.1 3.2 26.6 8.5l133.5-92.4C471.8 172.6 409.1 128 336 128H320V320zm62.8 35.1c.8 3.4 1.2 7 1.2 10.6c0 4.6-.7 9-1.9 13.1L472.6 415c24.6-30.3 39.4-68.9 39.4-111c0-12.3-1.3-24.3-3.7-35.9L382.8 355.1zm-21.2 50c-3 1.8-6.2 3.2-9.6 4.3v69.9c36.4-3.3 69.5-17.6 96.1-39.6l-86.5-34.6zM320 407.8l-64.1-22.4L224 374.2V408v48 24h24 72V407.8zM168 192a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "list-check": [512, 512, ["tasks"], "f0ae", "M169.9 54.2L153.8 72.1l-72 80L64.9 170.9 47 153 7 113l-17-17L24 62.1 41 79l22.1 22.1 55.1-61.2 16.1-17.8 35.7 32.1zm0 160l-16.1 17.8-72 80L64.9 330.9 47 313 7 273l-17-17L24 222.1l17 17 22.1 22.1 55.1-61.2 16.1-17.8 35.7 32.1zM224 64h32H480h32v64H480 256 224V64zm0 160h32H480h32v64H480 256 224V224zM160 384h32H480h32v64H480 192 160V384zM48 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"],
    "diagram-subtask": [512, 512, [], "e479", "M0 32H512V224H160V352h64V288h64H448h64v64 64 64H448 288 224V416H128 96V384 224H0V32zM448 352H288v64H448V352z"],
    "jug-detergent": [384, 512, [], "e519", "M96 0H224V48h32V96H64V48H96V0zM0 256c0-70.7 57.3-128 128-128H384V512H0V256zm256-32V384h64V224H256z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M391.9 391.6L368 320H144l-23.9 71.6C154.9 426.5 202.9 448 256 448s101.1-21.5 135.9-56.4zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256 16a72 72 0 1 0 0-144 72 72 0 1 0 0 144z"],
    "square-y": [448, 512, [], "e287", "M448 32H0V480H448V32zM200 295.9L88.6 144h59.5L224 247.4 299.8 144h59.5L248 295.9V376v24H200V376 295.9z"],
    "user-doctor-hair": [448, 512, [], "e458", "M304 144V128c0-11.4-2.4-22.2-6.7-32H256L240 80l-32 32H145.6c-1 5.2-1.6 10.5-1.6 16v16c0 44.2 35.8 80 80 80s80-35.8 80-80zM224 0c70.7 0 128 57.3 128 128v16c0 70.7-57.3 128-128 128s-128-57.3-128-128V128C96 57.3 153.3 0 224 0zM160 370.3V320H288v42c-27.6 7.1-48 32.2-48 62v40 16h16 16 16V448H272V424c0-17.7 14.3-32 32-32s32 14.3 32 32v24H320v32h16 16 16V464 424c0-29.8-20.4-54.9-48-62V320h80l48 192H0L48 320h80v50.3c-23.1 6.9-40 28.3-40 53.7c0 30.9 25.1 56 56 56s56-25.1 56-56c0-25.4-16.9-46.8-40-53.7zM120 424a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"],
    "planet-ringed": [512, 512, [129680], "e020", "M319.7 319.7C512 127.4 503.9 8.1 503.9 8.1s-58.4-4-159.4 59.6C317.6 55.1 287.6 48 256 48C141.1 48 48 141.1 48 256c0 31.6 7.1 61.6 19.7 88.5C4.1 445.5 8.1 503.9 8.1 503.9s119.3 8.1 311.6-184.2zM256 464c114.9 0 208-93.1 208-208c0-17.5-2.2-34.4-6.2-50.6c-27.7 40.6-65 86.5-115.5 137s-96.3 87.8-137 115.5c16.2 4.1 33.2 6.2 50.6 6.2z"],
    "mushroom": [512, 512, [127812], "e425", "M16 272C16 139.5 123.5 32 256 32s240 107.5 240 240v24 24H472 40 16V296 272zM413.3 161.9c-4.2-1.2-8.7-1.9-13.3-1.9c-26.5 0-48 21.5-48 48s21.5 48 48 48c19 0 35.4-11 43.2-27c-5.6-24.5-15.9-47.2-29.9-67.1zM146.2 114.5c8.4 35.3 40 61.5 77.8 61.5c44.2 0 80-35.8 80-80c0-3.4-.2-6.8-.6-10.1C288.2 82 272.3 80 256 80c-40.9 0-78.7 12.8-109.8 34.5zM160 480l32-128H320l32 128H160zm0-256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"],
    "user-shield": [640, 512, [], "f505", "M224 0a128 128 0 1 1 0 256A128 128 0 1 1 224 0zm96.1 304c2.3 74.7 36.7 158.5 106 208H0L64 304H320.1zm271.2 8.4L496 275.5V460.4c56.5-26.3 90.2-87 95.3-148zM496 512c-96-32-144-130.2-144-216V279.8L496 224l144 55.8V296c0 85.8-48 184-144 216z"],
    "megaphone": [576, 512, [128227], "f675", "M576 32V480H512V32h64zM64 190.3L480 64V448L348.9 408.2C338.2 449.5 300.7 480 256 480c-53 0-96-43-96-96c0-11 1.9-21.7 5.3-31.5L64 321.7V352H0V320 192 160H64v30.3zm238.9 204l-91.6-27.8c-2.1 5.4-3.3 11.4-3.3 17.6c0 26.5 21.5 48 48 48c23 0 42.2-16.2 46.9-37.8z"],
    "wreath-laurel": [640, 512, [], "e5d2", "M144 112C144 50.1 194.1 0 256 0h32V32c0 60.2-47.5 109.3-107 111.9c-23.9 32.2-37 71.5-37 112.1c0 97.2 78.8 176 176 176h72 5.7l5.1 2.5 64 32-21.5 42.9L386.3 480H320h0H253.7l-58.9 29.5-21.5-42.9 33.9-17c-5.1-3-10.1-6.1-14.9-9.5c-59.6 28.2-131.9 6.3-165.4-51.8l-16-27.7 13.9-8c13.8-8 28.4-13.1 43.3-15.5C27.5 315.6 0 273 0 224V192H16c15.9 0 31.1 2.9 45.2 8.2c-24.3-38.8-26.8-89.5-2.3-131.9l16-27.7 13.9 8C115 63.7 133.8 86.8 144 113v-1zm315 31.9C399.5 141.3 352 92.2 352 32V0h32c61.9 0 112 50.1 112 112v1c10.2-26.2 29-49.2 55.3-64.4l13.9-8 16 27.7c24.5 42.4 21.9 93.1-2.3 131.9c14.1-5.3 29.3-8.2 45.2-8.2h16v32c0 49-27.5 91.6-68 113.1c14.8 2.4 29.5 7.5 43.3 15.5l13.9 8-16 27.7c-22.4 38.8-62.1 61.4-103.7 63.8L481 437.9l-18.4-9.2-30.4-15.2-17.9-9C463.4 373.3 496 318.5 496 256c0-40.6-13.1-79.9-37-112.1z"],
    "circle-exclamation-check": [640, 512, [], "e10d", "M506.5 203L480 229.5l-18.7-18.7L416 165.5 325.5 256l45.3 45.3 64 64 33.7 33.7C422.4 467.1 344.5 512 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0C379.2 0 482.1 87 506.5 203zM280 152V128H232v24V264v24h48V264 152zM232 320v48h48V320H232zM617 209L489 337l-17 17-17-17-64-64-17-17L408 222.1l17 17 47 47L583 175l17-17L633.9 192l-17 17z"],
    "wind": [512, 512, [], "f72e", "M288 0V64h32 32c17.7 0 32 14.3 32 32s-14.3 32-32 32H32 0v64H32 352c53 0 96-43 96-96s-43-96-96-96H320 288zm64 416h32 32c53 0 96-43 96-96s-43-96-96-96H32 0v64H32 416c17.7 0 32 14.3 32 32s-14.3 32-32 32H384 352v64zM128 512h32c53 0 96-43 96-96s-43-96-96-96H32 0v64H32 160c17.7 0 32 14.3 32 32s-14.3 32-32 32H128 96v64h32z"],
    "box-dollar": [448, 512, ["box-usd"], "f4a0", "M208 32V160H0L64 32H208zm32 0H384l64 128H240V32zM0 192H448V480H0V192zm244 48V220H204v20 6c-5.6 1.2-11 2.9-16 5.1c-15 6.8-27.9 19.4-31.1 37.7c-1.8 10.2-.8 20 3.4 29c4.2 8.8 10.7 15 17.3 19.5c11.6 7.9 26.9 12.5 38.6 16l2.2 .7c13.9 4.2 23.4 7.4 29.3 11.7c2.5 1.8 3.4 3.2 3.7 4.1c.3 .8 .9 2.6 .2 6.7c-.6 3.5-2.5 6.4-8 8.8c-6.1 2.6-16 3.9-28.8 1.9c-6-1-16.7-4.6-26.2-7.9c-2.2-.8-4.4-1.5-6.4-2.2l-19-6.3-12.6 38 19 6.3c1.2 .4 2.7 .9 4.4 1.5l0 0c7.9 2.7 20.3 7 29.9 9.1V432v20h40V432v-5.5c5.4-1 10.6-2.5 15.4-4.6c15.7-6.7 28.4-19.7 31.6-38.7c1.8-10.4 1-20.3-3-29.4c-3.9-9-10.2-15.6-16.9-20.5c-12.2-8.8-28.3-13.7-40.4-17.4l0 0 0 0-.8-.2c-14.2-4.3-23.8-7.3-29.9-11.4c-2.6-1.8-3.4-3-3.6-3.5c-.2-.3-.7-1.6-.1-5c.3-1.9 1.9-5.2 8.2-8.1c6.4-2.9 16.4-4.5 28.6-2.6c4.3 .7 17.9 3.3 21.7 4.3l19.3 5.1 10.3-38.7-19.3-5.1c-4.4-1.2-14.5-3.2-21.1-4.4V240z"],
    "car-burst": [640, 512, ["car-crash"], "f5e1", "M218.2 88.5L176 0 133.8 88.5 38.4 66.3l42.9 88.1L4.4 215.2 100 236.6l-.4 98 58.4-47 4.2-15.5 24.8-92.7 8.3-30.9 30.9 8.3 14.4 3.9 60-76.3 10.8-13.7 2.1-4.4L218.2 88.5zM280.3 162l-27.5 35 0 0L218 187.6l0 0-8.3 30.9-16.6 61.8-1.4 5.4-15.1 56.4L160 404l77.3 20.7 16.6-61.8 247.3 66.3L484.6 491l77.3 20.7 16.6-61.8L595 388l24.8-92.7L585 286 568.1 169l-3-20.9-20.4-5.5L359.3 93l-20.4-5.5-13 16.6L280.3 162zM507.8 199l9.9 68.9L320 215l43.1-54.7L507.8 199zm-227 63.4a24 24 0 1 1 -12.4 46.4 24 24 0 1 1 12.4-46.4zm217.9 83.2A24 24 0 1 1 545 358.1a24 24 0 1 1 -46.4-12.4z"],
    "y": [384, 512, [121], "59", "M1.1 32L160 296.9V448v32h64V448 296.9L382.9 32H308.3L192 225.8 75.7 32H1.1z"],
    "user-headset": [448, 512, [], "f82d", "M224 32C135.6 32 64 103.6 64 192v32H32V192C32 86 118 0 224 0S416 86 416 192V304v16H400 272 224 176V256h96v32H384V192c0-88.4-71.6-160-160-160zM0 512L48 352h96 32 48 48H400l48 160H0zM144 291.9c-29.3-23.5-48-59.5-48-99.9c0-70.7 57.3-128 128-128s128 57.3 128 128c0 23.3-6.2 45.2-17.1 64H304V224H272 176 144v32 35.9z"],
    "arrows-retweet": [640, 512, ["retweet-alt"], "f361", "M150.6 73.4L128 50.7 105.4 73.4l-80 80L2.7 176 48 221.3l22.6-22.6L96 173.3V384v32h32H304h32V352H304 160V173.3l25.4 25.4L208 221.3 253.3 176l-22.6-22.6-80-80zM336 96H304v64h32H480V338.7l-25.4-25.4L432 290.7 386.7 336l22.6 22.6 80 80L512 461.3l22.6-22.6 80-80L637.3 336 592 290.7l-22.6 22.6L544 338.7V128 96H512 336z"],
    "person-snowboarding": [512, 512, [127938, "snowboarding"], "f7ce", "M432 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM227.4 110.3l-40-80L244.6 1.7l33 66 64.7 12.9 7.4 1.5 6 4.6 144 112 25.3 19.6-39.3 50.5-25.3-19.6-72.1-56.1-71.5 31.8 55.8 46.5L387.6 284l-4.4 19.2-24 104-5.8 25 83 31.8H472h24v48H472 432h-4.4l-4.1-1.6-376-144-4.8-1.8L39 361 7 329l-17-17L24 278.1l17 17 28.4 28.4 29.9 11.4L87.5 299.8l30.4-10.1L192 264.9l0-53.2c0-24.2 13.7-46.4 35.4-57.2l45.2-22.6-22.8-4.6-15.3-3.1-7-14zM139 350.1l154.1 59 3.8-16.3L316.4 308 256 257.7l0 30.3v23.1l-21.9 7.3L139 350.1z"],
    "square-chevron-right": [448, 512, ["chevron-square-right"], "f32b", "M448 480l0-448L0 32 0 480l448 0zM313 273L209 377l-17 17L158.1 360l17-17 87-87-87-87-17-17L192 118.1l17 17L313 239l17 17-17 17z"],
    "lacrosse-stick-ball": [576, 512, [], "e3b6", "M336 64v0c.1 0 .2 0 .3 0c19.9 0 48.1 13.6 73.1 38.6s38.6 53.2 38.6 73.1c0 .1 0 .2 0 .3h0c0 33.1-21.9 62.1-53.7 71.2l-35.1 10L353 259l-5 4-54 43.2c-11.1 8.9-25 13.8-39.2 13.8c-34.7 0-62.8-28.1-62.8-62.8c0-14.3 4.9-28.1 13.8-39.2L249 164l4-5 1.8-6.2 10-35.1C273.9 85.9 302.9 64 336 64zm0-64V0C274.4 0 220.2 40.9 203.3 100.1L195 129l-39.2 49c-18 22.5-27.8 50.4-27.8 79.2c0 23.4 6.3 45.3 17.4 64.1l-120 120L2.7 464 48 509.3l22.6-22.6 120-120c18.8 11.1 40.7 17.4 64.1 17.4c28.8 0 56.7-9.8 79.2-27.8L383 317l28.9-8.3C471.1 291.8 512 237.6 512 176h0c0-.1 0-.2 0-.3c0-43.8-26.4-87.4-57.3-118.4S380.1 0 336.3 0c-.1 0-.2 0-.3 0zM496 512a80 80 0 1 0 0-160 80 80 0 1 0 0 160z"],
    "truck-fast": [640, 512, ["shipping-fast"], "f48b", "M416 0H64V96H0v32H64 288v32H64 32v32H64 256v32H64 0v32H64 224v32H64V416c0 53 43 96 96 96s96-43 96-96H384c0 53 43 96 96 96s96-43 96-96h32 32V352H608V288 256 224 210.7l-9.4-9.4-96-96L493.3 96H480 416V0zM544 237.3V256H416V160h50.7L544 237.3zM160 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm272 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"],
    "user-magnifying-glass": [640, 512, [], "e5c5", "M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zM448 512l-9.9-32.3C354.3 474.6 288 405 288 320c0-5.4 .3-10.7 .8-16H64L0 512H448zm0-271.9a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 208c26.7 0 51.5-8.2 72-22.1l63.1 62.7 17 16.9 33.8-34-17-16.9-63-62.6c13.9-20.5 22.1-45.3 22.1-71.9c0-70.7-57.3-128-128-128s-128 57.3-128 128s57.3 128 128 128z"],
    "star-sharp": [576, 512, [], "e28b", "M288.1 0l63.5 195.6H557.2L390.9 316.4 454.4 512 288.1 391.1 121.7 512l63.5-195.6L18.9 195.6H224.5L288.1 0z"],
    "comment-heart": [512, 512, [], "e5c8", "M512 240c0 114.9-114.6 208-256 208c-31.5 0-61.7-4.6-89.6-13.1L16 480 56.9 370.8C21.3 335.1 0 289.6 0 240C0 125.1 114.6 32 256 32s256 93.1 256 208zM144 203.2c0 16.1 6.6 31.5 18.2 42.7l82.8 79.6L256 336.1l11.1-10.7 82.8-79.6c11.6-11.2 18.2-26.6 18.2-42.7c0-32.7-26.5-59.2-59.2-59.2h-2.4c-15.9 0-31.2 6.2-42.7 17.2l-7.7 7.4-7.7-7.4c-11.5-11-26.8-17.2-42.7-17.2h-2.4c-32.7 0-59.2 26.5-59.2 59.2z"],
    "circle-1": [512, 512, [], "e0ee", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm176 80v48h24 56 56 24V336H312 280V152 128H256h-8-6.2l-5.4 3L176 164.5v54.9l11.7-6.5L232 188.3V336H200 176z"],
    "circle-star": [512, 512, ["star-circle"], "e123", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm47-320.7l105.1 15.3-76.1 74.2 18 104.7L256 336l-94 49.4 18-104.7-76.1-74.2L209 191.3 256 96l47 95.3z"],
    "fish": [576, 512, [128031], "f578", "M336 80c-89.4 0-153.8 54.9-193.2 103.4L32 128 0 160l48 96L0 352l32 32 110.8-55.4C182.2 377.1 246.6 432 336 432c160 0 240-176 240-176s-80-176-240-176zm80 144a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"],
    "cloud-fog": [640, 512, [127787, "fog"], "f74e", "M160 320H64V224c0-41.8 26.7-77.4 64-90.5V112C128 50.1 178.1 0 240 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80v16c53 0 96 43 96 96v96H480 160zM0 368H24 552h24v48H552 24 0V368zm64 96H88 200h24v48H200 88 64V464zm208 0h24H616h24v48H616 296 272V464z"],
    "waffle": [512, 512, [129479], "e466", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM176 80H144V96v48H96 80v32H96h48v64H64 48v32H64h80v64H96 80v32H96h48v48 16h32V416 368h64v80 16h32V448 368h64v48 16h32V416 368h48 16V336H416 368V272h80 16V240H448 368V176h48 16V144H416 368V96 80H336V96v48H272V64 48H240V64v80H176V96 80zm0 256V272h64v64H176zm96 0V272h64v64H272zm64-160v64H272V176h64zm-96 0v64H176V176h64z"],
    "music-note": [384, 512, ["music-alt"], "f8cf", "M384 44.8V3.8l-39.8 9.9-128 32L192 51.8v25 64V359.7c-14.5-4.9-30.8-7.7-48-7.7c-61.9 0-112 35.8-112 80s50.1 80 112 80s112-35.8 112-80V165.8l103.8-25.9 24.2-6.1v-25-64z"],
    "hexagon-exclamation": [512, 512, [], "e417", "M0 256L128 32H384L512 256 384 480H128L0 256zM280 128H232v24V264v24h48V264 152 128zM232 320v48h48V320H232z"],
    "cart-shopping-fast": [640, 512, [], "e0dc", "M64 0H88h72 19.9l3.7 19.5L186 32H640L560 288H234.7l9.1 48H552h24v48H552 224 204.1l-3.7-19.5L140.1 48H88 64V0zM192 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM0 144V96H112v48H0zm0 80V176H128v48H0zm0 80V256H144v48H0z"],
    "object-union": [512, 512, [], "e49f", "M352 0H0V352H160V512H512V160H352V0z"],
    "user-graduate": [448, 512, [], "f501", "M448 48L224 0 0 48V80l16 3.4V168L0 256H64L48 168V90.3l48 10.3V160c0 70.7 57.3 128 128 128s128-57.3 128-128V100.6L448 80V48zM126.1 320H64L0 512H448L384 320H321.9L224 424 126.1 320z"],
    "starfighter": [640, 512, [], "e037", "M352 0l32 256V480H256V256L288 0h64zM288 256v64h64V256c0-17.7-14.3-32-32-32s-32 14.3-32 32zM72 72V96v24H96v48H72V352h56V288h96v64 64 32 32 32H160V480 467.2L72 432v16 24H24V448 168H0V120H24V96 72H72zm544 0V96v24h24v48H616V448v24H568V448 432l-88 35.2V480v32H416V480 448 416 352 288h96v64h56V168H544V120h24V96 72h48z"],
    "circle-half-stroke": [512, 512, [9680, "adjust"], "f042", "M448 256c0-106-86-192-192-192V448c106 0 192-86 192-192zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"],
    "arrow-right-long-to-line": [640, 512, [], "e3d5", "M640 96V64H576V96 416v32h64V416 96zM512 256l-22.6-22.6-128-128L338.7 82.7 293.5 128l22.6 22.6L389.5 224 32 224H0v64l32 0 357.5 0-73.4 73.4L293.5 384l45.3 45.3 22.6-22.6 128-128L512 256z"],
    "square-arrow-down": [448, 512, ["arrow-square-down"], "f339", "M448 480H0V32H448V480zM241 393L353 281l17-17L336 230.1l-17 17-71 71V136 112H200v24V318.1l-71-71-17-17L78.1 264l17 17L207 393l17 17 17-17z"],
    "diamond-half-stroke": [512, 512, [], "e5b8", "M0 256l45.3 45.3L210.7 466.7 256 512l45.3-45.3L466.7 301.3 512 256l-45.3-45.3L301.3 45.3 256 0 210.7 45.3 45.3 210.7 0 256zM256 421.5V90.5L421.5 256 256 421.5z"],
    "clapperboard": [512, 512, [], "e131", "M361.9 32l-1 1-127 127h92.1l1-1 127-127H361.9zM512 160V41.9L393.9 160H512zM294.1 32H201.9l-1 1L73.9 160h92.1l1-1 127-127zM0 32V160H6.1l1-1 127-127H0zM512 192H0V480H512V192z"],
    "square-chevron-left": [448, 512, ["chevron-square-left"], "f32a", "M0 32L0 480l448 0 0-448L0 32zM135 239L239 135l17-17L289.9 152l-17 17-87 87 87 87 17 17L256 393.9l-17-17L135 273l-17-17 17-17z"],
    "phone-intercom": [512, 512, [], "e434", "M128 32V480H0V32H128zm32 0H512V480H160V32zM320 368a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm48-48H352v32h16 64 16V320H432 368zm0 64H352v32h16 64 16V384H432 368zM224 96V256H448V96H224z"],
    "link-horizontal": [640, 512, ["chain-horizontal"], "e1cb", "M144 64C64.5 64 0 128.5 0 208s64.5 144 144 144h16V288H144c-44.2 0-80-35.8-80-80s35.8-80 80-80H304c44.2 0 80 35.8 80 80c0 36.2-24.1 66.8-57.1 76.7c-3.7 1.1-7.5 1.9-11.4 2.5l9.1 63.4c7-1 13.9-2.5 20.6-4.5C404.6 328.3 448 273.3 448 208c0-79.5-64.5-144-144-144H144zM496 448c79.5 0 144-64.5 144-144s-64.5-144-144-144H480v64h16c44.2 0 80 35.8 80 80s-35.8 80-80 80l-160 0c-44.2 0-80-35.8-80-80c0-36.2 24.1-66.8 57.1-76.7c3.7-1.1 7.5-1.9 11.4-2.5l-9.1-63.4c-7 1-13.9 2.5-20.6 4.5C235.4 183.7 192 238.7 192 304c0 79.5 64.5 144 144 144l160 0z"],
    "mango": [512, 512, [], "e30f", "M184.2 152.2C221.7 114.7 270.9 96 320 96V24 0h32 16 8 64c39.8 0 72 32.2 72 72V96H488 448c-33.4 0-62.8-17-80-42.9v49c32.2 8.3 62.6 25 87.8 50.2C493.3 189.7 512 238.9 512 288c0 76.6-57.5 224-224 224c-144 0-244.1-43.3-244.1-43.3L0 448l-1.8-64 26.5-18.5c34.3-25.7 52.1-59.4 71.1-95.4c20.6-38.9 42.6-80.6 88.4-117.9zM400 288c0 61.9-50.1 112-112 112v32c79.5 0 144-64.5 144-144H400z"],
    "music-note-slash": [640, 512, ["music-alt-slash"], "f8d0", "M48.4 14.8L29.4 .1 0 38 19 52.7 591.5 497.2l19 14.7L639.9 474l-19-14.7L384 275.4V165.8l103.8-25.9 24.2-6.1v-25-64V3.8l-39.8 9.9-128 32L320 51.8v25 64 84.9L48.4 14.8zM384 411.2L317.8 359c-14-4.5-29.5-7-45.8-7c-61.9 0-112 35.8-112 80s50.1 80 112 80s112-35.8 112-80V411.2z"],
    "circle-radiation": [512, 512, [9762, "radiation-alt"], "f7ba", "M256 64a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 448A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM200 256c0-20.7 11.3-38.8 28-48.5l-52-90.1C128.2 145.1 96 196.8 96 256l104 0zm28 48.5l-52 90.1c23.5 13.6 50.9 21.4 80 21.4s56.5-7.8 80-21.4l-52-90.1c-8.2 4.8-17.8 7.5-28 7.5s-19.8-2.7-28-7.5zM312 256l104 0c0-59.2-32.2-110.9-80-138.6l-52 90.1c16.7 9.7 28 27.8 28 48.5zm-56 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"],
    "face-tongue-sweat": [576, 512, [], "e39e", "M544 256c0 112.9-73.1 208.7-174.5 242.8C378.7 484 384 466.6 384 448V416.7c10.2-7.2 16-15.7 16-24.7c0-26.5-50.1-48-112-48s-112 21.5-112 48c0 9 5.8 17.5 16 24.7V448c0 18.6 5.3 36 14.5 50.8c-41.4-13.9-78.1-38.1-107-69.5C116.9 414.5 128 392.6 128 368c0-17.3-5.6-34.2-16-48L73.6 268.8 48 234.7 32 256C32 114.6 146.6 0 288 0S544 114.6 544 256zM96 368c0 14.5-6.5 27.6-16.7 36.4C70.9 411.6 60 416 48 416c-26.5 0-48-21.5-48-48c0-10.4 3.4-20.5 9.6-28.8l26.8-35.7L48 288l20 26.7 18.4 24.5c6.2 8.3 9.6 18.4 9.6 28.8zm239.6-96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm-128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm31-144L216 137.4l-11.3 11.3-7.4 7.4c-18.9 18.9-43.2 31.4-69.5 35.7l-2.5 .4-15.8 2.6 5.3 31.6 15.8-2.6 2.5-.4c32.9-5.5 63.3-21.1 86.8-44.7l7.4-7.4L238.6 160zm110.1 11.3l7.4 7.4c23.6 23.6 53.9 39.2 86.8 44.7l2.5 .4 15.8 2.6 5.3-31.6-15.8-2.6-2.5-.4c-26.3-4.4-50.6-16.9-69.5-35.7l-7.4-7.4L360 137.4 337.4 160l11.3 11.3zM352 384v64c0 35.3-28.7 64-64 64s-64-28.7-64-64V384h48v24h32V384h48z"],
    "globe-stand": [448, 512, [], "f5f6", "M23 359l-17 17L40 409.9l17-17 10.5-10.5c34.3 27.7 74.9 43.8 116.5 48.3V464H64v48H352V464H232V430.7c49.1-5.3 96.8-26.7 134.4-64.3c81.7-81.7 87.1-211 16.1-298.9L393 57l17-17L376 6.1 359 23 332.5 49.6l-17 17 17 17c68.7 68.7 68.7 180.2 0 248.9s-180.2 68.7-248.9 0l-17-17-17 17L23 359zm185-7a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"],
    "baseball": [512, 512, [129358, 9918, "baseball-ball"], "f433", "M77.4 221.6C67.8 223.2 58 224 48 224c-15.6 0-30.8-2-45.2-5.9C19.2 107.1 107.1 19.2 218.1 2.8C222 17.2 224 32.4 224 48c0 10-.8 19.8-2.4 29.4l31.6 5.3C255 71.4 256 59.8 256 48c0-16.5-1.9-32.6-5.6-47.9c1.8 0 3.7-.1 5.6-.1C397.4 0 512 114.6 512 256c0 1.9 0 3.7-.1 5.6c-15.4-3.6-31.4-5.6-47.9-5.6c-11.8 0-23.4 1-34.6 2.9l5.3 31.6c9.5-1.6 19.3-2.4 29.4-2.4c15.6 0 30.8 2 45.2 5.9C492.8 404.9 404.9 492.8 293.9 509.2C290 494.8 288 479.6 288 464c0-10 .8-19.8 2.4-29.4l-31.6-5.3C257 440.6 256 452.2 256 464c0 16.5 1.9 32.6 5.6 47.9c-1.8 0-3.7 .1-5.6 .1C114.6 512 0 397.4 0 256c0-1.9 0-3.7 .1-5.6C15.4 254.1 31.5 256 48 256c11.8 0 23.4-1 34.6-2.9l-5.3-31.6zM214 106.7c-17.3 48.9-55.6 87.9-104.1 106.1l11.3 30c57.3-21.5 102.6-67.6 123-125.4L214 106.7zM402.1 299.2l-11.3-30c-57.3 21.5-102.6 67.6-123 125.4L298 405.3c17.3-48.9 55.6-87.9 104.1-106.1z"],
    "circle-p": [512, 512, [], "e11a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128h92c50.8 0 92 41.2 92 92s-41.2 92-92 92H208v48 24H160V360 288 152 128h24zm92 136c24.3 0 44-19.7 44-44s-19.7-44-44-44H208v88h68z"],
    "award-simple": [384, 512, [], "e0ab", "M192 0l44.2 26.9L288 25.7l24.8 45.4L358.3 96l-1.2 51.8L384 192l-26.9 44.2 1.2 51.8-45.4 24.8L288 358.3l-51.8-1.2L192 384l-44.2-26.9L96 358.3 71.2 312.8 25.7 288l1.2-51.8L0 192l26.9-44.2L25.7 96 71.2 71.2 96 25.7l51.8 1.2L192 0zm80 192a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM64 512L92.6 388l42.8-1 39.9 24.3L192 421.5l16.6-10.1L248.5 387l42.8 1L320 512 192 480 64 512z"],
    "jet-fighter-up": [512, 512, [], "e518", "M0 392l0 24 48 0 0-24 0-8 144 0 0 32-64 64 0 32 112 0 0-48 0-16 32 0 0 16 0 48 112 0 0-32-64-64 0-32 144 0 0 8 0 24 48 0 0-24 0-112 0-24-48 0 0 24 0 16L320 216l0-88L272 0 240 0 192 128l0 88L48 296l0-16 0-24L0 256l0 24L0 392z"],
    "diagram-project": [576, 512, ["project-diagram"], "f542", "M0 32H192V96H384V32H576V224H384V160H192v21.3L272 288H416V480H224V330.7L144 224H0V32z"],
    "pedestal": [448, 512, [], "e20d", "M416 0H32V416H416V0zM120 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM304 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM32 448H0v64H32 416h32V448H416 32z"],
    "chart-pyramid": [512, 512, [], "e0e6", "M91.4 320H420.6L347.4 192H164.6L91.4 320zM73.1 352L0 480H512L438.9 352H73.1zM256 32L182.9 160H329.1L256 32z"],
    "sidebar": [512, 512, [], "e24e", "M0 32H512V480H0V32zM224 96V416H448V96H224zm-64 0H64v48h96V96zM64 192v48h96V192H64zm96 96H64v48h96V288z"],
    "snowman-head": [448, 512, ["frosty-head"], "f79b", "M64 0H384V160H224 64V0zM330.2 192H416h32v64H416 390.3c16.3 28.2 25.7 61 25.7 96c0 66.8-34.1 125.6-85.8 160H117.8C66.1 477.6 32 418.8 32 352c0-35 9.3-67.8 25.7-96H32 0V192H32h85.8H330.2zM152 336a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm168-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM224 448l27.8-48.7c2.7-4.8 4.2-10.2 4.2-15.7c0-17.5-14.2-31.6-31.6-31.6h-.8c-17.5 0-31.6 14.2-31.6 31.6c0 5.5 1.4 10.9 4.2 15.7L224 448z"],
    "copy": [512, 512, [], "f0c5", "M416 0l96 96V384H224V0H416zM64 128H192v64H64V448H256V416h64v32 64H256 64 0V448 192 128H64z"],
    "burger-glass": [640, 512, [], "e0ce", "M76.7 160L69.2 64H314.8l-7.5 96H76.7zM40 512H256V282.6c3-9.1 6.7-17.5 11.6-25.9c6.6-11.3 17-25.9 32.7-40.4c17.2-15.9 40.1-31 70.1-41.6L379 64l5-64H319.8 64.2 0L5 64 40 512zM640 287.8s-32-96-176-96s-176 96-176 96v32H640v-32zm-256-48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-256 112v64H640v-64H288zm0 96v64H640v-64H288z"],
    "volume-xmark": [576, 512, ["volume-mute", "volume-times"], "f6a9", "M0 160V352H128L272 480h48V32H272L128 160H0zm441 23l-17-17L390.1 200l17 17 39 39-39 39-17 17L424 345.9l17-17 39-39 39 39 17 17L569.9 312l-17-17-39-39 39-39 17-17L536 166.1l-17 17-39 39-39-39z"],
    "hand-sparkles": [640, 512, [], "e05d", "M352 32V0H288V32 256H256V64 32H192V64 336c0 1.5 0 3.1 .1 4.6l-43.6-41.5-29-27.6L64.3 329.4l29 27.6 95.5 91c43.1 41.1 100.4 64 160 64H368c44.4 0 84.9-16.4 115.9-43.5L448 453.1V410.9l63.6-27.3L544 308.1V128 96H480v32V256H448V64 32H384V64 256H352V32zM288 352l16-32 16 32 32 16-32 16-16 32-16-32-32-16 32-16zM56 120L0 144l56 24 24 56 24-56 56-24-56-24L80 64 56 120zM560 352l-24 56-56 24 56 24 24 56 24-56 56-24-56-24-24-56z"],
    "bars-filter": [448, 512, [], "e0ad", "M0 64H448v64H0V64zM64 224H384v64H64V224zM288 384v64H160V384H288z"],
    "paintbrush-pencil": [576, 512, [], "e206", "M297.8 153.8L224 80 144 0 32 112 176 256c6.2 0 12.4 .4 18.4 1.2L297.8 153.8zM320 400l80 80 144 32L512 368l-89.8-89.8L318.8 381.6c.8 6 1.2 12.2 1.2 18.4zM535.6 119.6L575.2 80 496 .8 456.4 40.4 227.7 269.1l79.2 79.2L535.6 119.6zM205 291.8c-9.3-2.5-19-3.8-29-3.8c-61.9 0-112 50.1-112 112v48H0v64H176c61.9 0 112-50.1 112-112c0-10-1.3-19.8-3.8-29l.1-.1-79.2-79.2-.1 .1z"],
    "party-bell": [512, 512, [], "e31a", "M65.6 382.4c-87.5-87.5-87.5-229.3 0-316.8s229.3-87.5 316.8 0L65.6 382.4zM480 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM352 448a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 480a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM376 150.1l17 17 8.3 8.3c16.7 16.7 38.6 27.2 62.1 29.8l27.4 3-5.3 47.7-27.4-3c-34.3-3.8-66.3-19.2-90.7-43.6L359 201l-17-17L376 150.1zM201 359l8.3 8.2c24.4 24.4 39.8 56.4 43.6 90.7l3 27.4-47.7 5.3-3-27.4c-2.6-23.5-13.1-45.4-29.8-62.1L167 393l-17-17L184 342.1l17 17zM469.7 503.5l-8.5-10c-12.5-14.8-19.1-33.7-18.6-53c.5-16.6-12.4-30.6-29-31.6l-30-1.8c-42.5-2.5-75.3-38.3-74.2-80.8c.2-7.6-2.4-15-7.3-20.7l-8.5-10-15.5-18.3 36.6-31 15.5 18.3 8.5 10c12.5 14.8 19.1 33.7 18.6 53c-.5 16.6 12.4 30.6 29 31.6l30 1.8c42.5 2.5 75.3 38.3 74.2 80.8c-.2 7.6 2.4 15 7.3 20.7l8.5 10-36.6 31z"],
    "user-vneck-hair": [448, 512, [], "e462", "M304 144c0 44.2-35.8 80-80 80s-80-35.8-80-80V128c0-5.5 .6-10.8 1.6-16H208l32-32 16 16h41.3c4.3 9.8 6.7 20.6 6.7 32v16zM224 0C153.3 0 96 57.3 96 128v16c0 70.7 57.3 128 128 128s128-57.3 128-128V128C352 57.3 294.7 0 224 0zm0 424L150.6 320H64L0 512H448L384 320H297.4L224 424z"],
    "jack-o-lantern": [576, 512, [127875], "f30e", "M288 96c-18.1 0-35.5 2.7-51.9 7.8L288 0l64 32v76c-19.8-7.7-41.4-12-64-12zm146 77.7c-10.9-16.1-24.3-30.3-39.8-42c9.6-2.4 19.6-3.7 29.8-3.7c83.9 0 152 86 152 192s-68.1 192-152 192c-24.4 0-47.5-7.3-68-20.2c-20.5 12.9-43.6 20.2-68 20.2s-47.5-7.3-68-20.2c-20.5 12.9-43.6 20.2-68 20.2C68.1 512 0 426 0 320S68.1 128 152 128c10.2 0 20.1 1.3 29.8 3.7c-15.4 11.7-28.9 25.9-39.8 42c41.4-28.8 91.7-45.7 146-45.7s104.6 16.9 146 45.7zM208 208l-48 80h96l-