<?php
namespace boru\boruai\Models\Tool;

use boru\dot\Dot;

/**
 * Lightweight context / container object for tools.
 *
 * This can be attached at runtime (per Response / per ToolHandler)
 * and accessed inside tool implementations via $tool->context().
 */
class ToolContext
{
    /**
     * Arbitrary context data.
     *
     * @var array
     */
    protected $data = [];

    /**
     * @param array $data Initial context data
     */
    public function __construct(array $data = [])
    {
        $this->data = $data;
    }

    /**
     * Set a value in the context.
     *
     * @param string $key a dot-notated key to set
     * @param mixed  $value
     * @return $this
     */
    public function set($key, $value)
    {
        Dot::set($this->data,$key,$value);
        return $this;
    }

    /**
     * Get a value from the context.
     *
     * @param string $key a dot-notated key to retrieve
     * @param mixed  $default
     * @return mixed
     */
    public function get($key=null,$default=null) {
        if($key === null) {
            return $this->data;
        }
        return Dot::get($this->data,$key,$default);
    }

    /**
     * Return all context data as an array.
     *
     * @return array
     */
    public function all()
    {
        return $this->data;
    }
}
