<?php

use PHPUnit\Framework\TestCase;
use boru\boruai\BoruAI;

class DebugFlagsTest extends TestCase
{
    protected function tearDown(): void
    {
        // Reset flags between tests to avoid leakage
        BoruAI::debug(false);
        BoruAI::debugHttp(false);
        BoruAI::debugTools(false);
    }

    public function testDebugDefaultsToFalse()
    {
        $this->assertFalse(BoruAI::debug(), 'debug() should default to false');
        $this->assertFalse(BoruAI::debugHttp(), 'debugHttp() should default to false');
        $this->assertFalse(BoruAI::debugTools(), 'debugTools() should default to false');
    }

    public function testDebugCanBeEnabledAndDisabled()
    {
        $this->assertFalse(BoruAI::debug());

        BoruAI::debug(true);
        $this->assertTrue(BoruAI::debug());

        BoruAI::debug(false);
        $this->assertFalse(BoruAI::debug());
    }

    public function testDebugHttpCanBeEnabledAndDisabled()
    {
        $this->assertFalse(BoruAI::debugHttp());

        BoruAI::debugHttp(true);
        $this->assertTrue(BoruAI::debugHttp());

        BoruAI::debugHttp(false);
        $this->assertFalse(BoruAI::debugHttp());
    }

    public function testDebugToolsCanBeEnabledAndDisabled()
    {
        $this->assertFalse(BoruAI::debugTools());

        BoruAI::debugTools(true);
        $this->assertTrue(BoruAI::debugTools());

        BoruAI::debugTools(false);
        $this->assertFalse(BoruAI::debugTools());
    }
}
