<?php

// Locate Composer autoloader

use boru\boruai\BoruAI;


function __find_boruai_and_autoload() {
    // Locate Composer autoloader
    $autoloadPaths = [
        __DIR__ . '/../vendor/autoload.php',
        __DIR__ . '/../../vendor/autoload.php',
    ];

    $found = false;
    $foundPath = null;
    foreach ($autoloadPaths as $path) {
        if (file_exists($path)) {
            $realPath = realpath($path);
            if ($realPath === false) {
                continue;
            }
            $dirPath = dirname($realPath, 2); //root from vendor/autoload.php
            if(!file_exists($dirPath."/config.json")) {
                exit("BoruAI config.json not found in expected location: ".$dirPath."/config.json\n");
            }
            $foundPath = $dirPath;
            $found = true;
            break;
        }
    }
    if(!$found) {
        exit("Composer autoloader not found. Please run 'composer install' or check your setup.\n");
    }
    return $foundPath;
}

$rootPath = __find_boruai_and_autoload();
require_once $rootPath . '/vendor/autoload.php';
BoruAI::init($rootPath."/config.json");