<?php

// Locate Composer autoloader
$autoloadPaths = [
    __DIR__ . '/../vendor/autoload.php',
    __DIR__ . '/../../vendor/autoload.php',
];

$found = false;
foreach ($autoloadPaths as $path) {
    if (file_exists($path)) {
        require_once $path;
        $found = true;
        break;
    }
}

if (!$found) {
    fwrite(STDERR, "Composer autoload.php not found. Run `composer install`.\n");
    exit(1);
}

// Pure unit context – do NOT auto-call BoruAI::init() here
// so tests can control/init/reset static state explicitly if needed.
// You can set lightweight env flags for tests only, e.g.:
//
// putenv('BORUAI_TESTING=1');
// define('BORUAI_TESTING', true);
