<?php
require __DIR__ . '/../vendor/autoload.php';

use boru\boruai\BoruAI;
use boru\boruaiweb\Providers\Auth\VtigerSessionAuthenticator;
use boru\boruaiweb\WebUI;
use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Providers\BoruAI\BoruAiProviderFactory;

//ini_set("display_errors", "1");
//error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);

BoruAI::init(__DIR__."/../config.json");

$config = WebConfig::createDefault()
    ->set('boruaiweb.boruai.chat.default_model', 'gpt-4.1')
    ->set("boruaiweb.boruai.chat.force_user_reference", false)
    ->set('boruaiweb.boruai.tools.enabled', array('WebSearchTool'))
    ->set('boruaiweb.boruai.references.create_if_missing', true)
    ->set('boruaiweb.auth.vtiger.allow_public_fallback', true)
    ->set('boruaiweb.auth.vtiger.public_user_id', 1)
    ->set('boruaiweb.auth.vtiger.public_user_name', 'Public');
    // optional: customize session keys if your vtiger uses different ones
    // ->set('boruaiweb.auth.vtiger.session_user_id_key', 'authenticated_user_id')
    // ->set('boruaiweb.auth.vtiger.session_user_name_key', 'authenticated_user_name')
    
$config->withAuth(new VtigerSessionAuthenticator($config));

BoruAiProviderFactory::wire($config);
/*$config->withTools(new BoruAiToolCatalog(
    array('WebSearchTool'),   // enabled
    array()                   // forced
));*/

$ui = new WebUI($config);

// Uncomment once to copy packaged templates/assets into your override dirs.
//$ui->publishDefaults();

$ui->render();
