<?php
// Variables provided by DashboardPageController:
// $pathPrefix, $reference, $references, $instructionsHtml
?>
<!doctype html>
<html lang="en" class="dark">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
          integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

    <link href="<?php echo $pathPrefix; ?>assets/css/fa/css/fontawesome.min.css" rel="stylesheet" />
    <link href="<?php echo $pathPrefix; ?>assets/css/fa/css/sharp-solid.min.css" rel="stylesheet" />
    <link href="<?php echo $pathPrefix; ?>assets/css/app.css" rel="stylesheet" />

    <title>Chat Widget</title>
</head>

<body class="body-chat-widget">
    <div style="display:none;" id="chatInstructions"><?php echo $instructionsHtml; ?></div>

    <input type="hidden" id="sessionReference" value="<?php echo htmlspecialchars($reference, ENT_QUOTES, 'UTF-8'); ?>" />
    <input type="hidden" id="pathPrefix" value="<?php echo htmlspecialchars($pathPrefix, ENT_QUOTES, 'UTF-8'); ?>" />

    <div class="container-fluid chat-overall-container">
        <div class="chat-container w-100">
            <div class="d-flex align-items-center justify-content-between chat-header">
                <div>
                    <div class="btn-group me-4">
                        <button id="newReference" class="btn btn-sm btn-success me-1" title="New">
                            <i class="fa-sharp fa-solid fa-square-plus"></i>
                        </button>
                        <button id="editReference" class="btn btn-sm btn-secondary me-1" title="Rename">
                            <i class="fa-sharp fa-solid fa-pen-to-square"></i>
                        </button>
                        <button id="deleteRef" class="btn btn-sm btn-danger me-2 deleteReference" title="Delete"
                                data-ref-id="<?php echo htmlspecialchars($reference, ENT_QUOTES, 'UTF-8'); ?>">
                            <i class="fa-sharp fa-solid fa-trash-xmark"></i>
                        </button>

                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-light dropdown-toggle" data-bs-toggle="dropdown"
                                    aria-expanded="false">Chats..</button>
                            <ul class="dropdown-menu dropdown-menu-end" id="refList">
                                <?php foreach ((array)$references as $ref): ?>
                                    <li>
                                        <a class="dropdown-item refItem" href="#"
                                           data-ref-id="<?php echo htmlspecialchars($ref, ENT_QUOTES, 'UTF-8'); ?>">
                                            <?php echo htmlspecialchars($ref, ENT_QUOTES, 'UTF-8'); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>

                    <span id="session-ref" class="fw-semibold"><?php echo htmlspecialchars($reference, ENT_QUOTES, 'UTF-8'); ?></span>
                </div>
            </div>

            <div id="chatBox" style="flex-grow: 1; overflow-y: auto; padding: 10px; border: 1px solid #ddd; border-radius: 5px;">
                <!-- Chat messages will appear here -->
            </div>

            <div class="input-group mt-3">
                <textarea id="userMessage" rows="1" class="form-control" placeholder="Type your message here…"></textarea>
                <button id="sendMessage" class="btn btn-primary">Send</button>
            </div>

            <div id="previewArea"></div>
        </div>
    </div>

    <div class="modal fade" id="referenceModal" tabindex="-1" aria-labelledby="referenceModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="referenceModalLabel">Rename Session Reference</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="renameForm">
                        <div class="mb-3">
                            <label for="referenceName" class="form-label">New Reference Name</label>
                            <input type="text" class="form-control" id="referenceName" placeholder="Enter new reference name" required>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="saveReference">Save</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
            integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/highlightjs/cdn-release@11.11.1/build/styles/github-dark.min.css">
    <script src="https://cdn.jsdelivr.net/gh/highlightjs/cdn-release@latest/build/highlight.min.js"></script>
    <script>hljs.configure({ ignoreUnescapedHTML: true });</script>

    <script src="https://cdn.jsdelivr.net/npm/dompurify@3.0.9/dist/purify.min.js"></script>

    <script src="<?php echo $pathPrefix; ?>assets/js/ChatService.js"></script>
    <script src="<?php echo $pathPrefix; ?>assets/js/ChatUI.js"></script>
    <script src="<?php echo $pathPrefix; ?>assets/js/ChatInputUI.js"></script>
    <script src="<?php echo $pathPrefix; ?>assets/js/ReferenceUI.js"></script>

    <script>
        $(() => {
            const basePath = $('#pathPrefix').val();
            const service = new ChatService(basePath);
            const chatUI = new ChatUI(service);
            chatUI.init();
            const inputUI = new ChatInputUI(service, chatUI);
            inputUI.init();
            const referenceUI = new ReferenceUI();
            referenceUI.init();
        });
    </script>
</body>
</html>
