<?php
namespace boru\boruaiweb\Actions;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\Response;

class ChatActionController
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config) { $this->config = $config; }

    public function handle(Request $req)
    {
        // SSE headers
        $headers = array(
            'Content-Type' => 'text/event-stream',
            'Cache-Control' => 'no-cache',
            'X-Accel-Buffering' => 'no',
            'Access-Control-Allow-Origin' => '*',
        );

        $auth = $this->config->auth;
        $chat = $this->config->chat;

        if (!$auth || !$chat) {
            return new Response(500, $headers, "data: ".json_encode(array('error' => 'Chat/auth services not configured'))."\n\n");
        }

        $user = $auth->currentUser();
        if (!$user) {
            return new Response(401, $headers, "data: ".json_encode(array('error' => 'Not authenticated'))."\n\n");
        }

        $reference = (string)$req->param('reference', 'default');
        $message = (string)$req->param('message', '');

        if ($message === '') {
            return new Response(400, $headers, "data: ".json_encode(array('error' => 'No message provided'))."\n\n");
        }

        $options = array(
            'templateId' => $req->param('templateId', null),
            'instructions' => $req->param('instructions', null),
            'tools' => $req->param('tools', null),
            'perUserReference' => $this->config->perUserReference ? true : false,
        );

        // Streaming body is emitted by Emitter directly; we implement this as a "callback streaming response".
        // For now: we return a Response with a special callable body.
        return Response::stream($headers, function() use ($chat, $user, $reference, $message, $options) {
            $emit = function(array $event) {
                echo "data: ".json_encode($event, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE)."\n\n";
                if (function_exists('flush')) { flush(); }
            };
            $chat->streamChat($user, $reference, $message, $options, $emit);
        });
    }
}
