<?php
namespace boru\boruaiweb\Actions;

use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\JsonResponse;
use boru\boruaiweb\Legacy\LegacyWebUI;

class LegacyActionController implements ActionControllerInterface {
    private $legacyUi;
    private $className;

    /**
     * @param LegacyWebUI $legacyUi
     * @param string $className Fully qualified legacy action class name.
     */
    public function __construct(LegacyWebUI $legacyUi, $className) {
        $this->legacyUi = $legacyUi;
        $this->className = $className;
    }

    public function handle(Request $request) {
        $class = $this->className;
        if (!class_exists($class)) {
            return new JsonResponse(array('success'=>false,'error'=>'Action class not found','data'=>array('class'=>$class)), 500);
        }
        // Ensure legacy Ajax doesn't echo/exit
        if (!defined('BORUAIWEB_NO_EMIT')) define('BORUAIWEB_NO_EMIT', true);

        $instance = new $class($this->legacyUi);
        if (!method_exists($instance, 'handle')) {
            return new JsonResponse(array('success'=>false,'error'=>'Action does not implement handle()','data'=>array('class'=>$class)), 500);
        }
        $payload = $instance->handle();
        // legacy may return null if it echoed; normalize
        if ($payload === null) $payload = array('success'=>false,'error'=>'No response returned','data'=>array());
        return new JsonResponse($payload);
    }
}
