<?php
namespace boru\boruaiweb\Actions;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\JsonResponse;

class TemplateActionController
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config) { $this->config = $config; }

    public function handle(Request $req)
    {
        if (!$this->config->auth || !$this->config->templates) {
            return JsonResponse::error(array(), 'Template/auth services not configured', 500);
        }

        $user = $this->config->auth->currentUser();
        if (!$user) {
            return JsonResponse::error(array(), 'Not authenticated', 401);
        }

        $mode = (string)$req->param('mode', '');
        if ($mode === '') {
            return JsonResponse::error(array(), 'No mode provided', 400);
        }

        if ($mode === 'save') {
            $id = $req->param('template', null);
            if (!$id) return JsonResponse::error(array(), 'No template id provided', 400);

            $tpl = $this->config->templates->find($id);
            if (!$tpl) return JsonResponse::error(array(), 'Template not found', 404);

            // allow saving fields coming from UI (content/name/etc)
            $incoming = $req->all();
            foreach ($incoming as $k => $v) {
                if ($k === 'action' || $k === 'mode') continue;
                $tpl[$k] = $v;
            }

            $saved = $this->config->templates->save($tpl);
            return JsonResponse::success(array('message' => 'Template saved', 'template' => $saved));
        }

        return JsonResponse::error(array(), 'Invalid mode', 400);
    }
}
