<?php
namespace boru\boruaiweb\Assets;

class AssetManager
{
    /** @var string */
    private $urlPrefix;

    /**
     * @param string $urlPrefix e.g. "/assets/boruaiweb" or "/"
     */
    public function __construct($urlPrefix)
    {
        $urlPrefix = (string)$urlPrefix;
        if ($urlPrefix === '') $urlPrefix = '/';
        $this->urlPrefix = rtrim($urlPrefix, '/') . '/';
    }

    /**
     * @param string $path e.g. "assets/js/app.js" or "js/app.js"
     * @return string
     */
    public function url($path)
    {
        $path = ltrim((string)$path, '/');
        return $this->urlPrefix . $path;
    }

    /**
     * Compatibility helper: the old template used a "pathPrefix" and then appended "assets/...".
     * Here we return a prefix that ends with "/" so existing includes can remain stable.
     *
     * @return string
     */
    public function prefix()
    {
        return $this->urlPrefix;
    }
}
