<?php
namespace boru\boruaiweb\Http;

class Response
{
    /** @var int */
    private $status;
    /** @var array */
    private $headers;
    /** @var string|callable */
    private $body;
    /** @var bool */
    private $isStream = false;

    /**
     * @param int $status
     * @param array $headers
     * @param string $body
     */
    public function __construct($status = 200, array $headers = array(), $body = '')
    {
        if(is_array($body)) {
            $body = json_encode($body, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
            $headers['Content-Type'] = 'application/json';
        }
        $this->status  = (int)$status;
        $this->headers = $headers;
        $this->body    = (string)$body;
        $this->isStream = false;
    }

    /**
     * Create a streaming response. Body producer should echo output.
     *
     * @param array $headers
     * @param callable $producer function(): void
     * @param int $status
     * @return Response
     */
    public static function stream(array $headers, $producer, $status = 200)
    {
        $r = new self($status, $headers, '');
        $r->body = $producer;
        $r->isStream = true;
        return $r;
    }

    /** @return int */
    public function status() { return $this->status; }

    /** @return array */
    public function headers() { return $this->headers; }

    /**
     * @param string $name
     * @param string $value
     * @return Response
     */
    public function withHeader($name, $value)
    {
        $this->headers[$name] = $value;
        return $this;
    }

    /** @return bool */
    public function isStream() { return $this->isStream; }

    /**
     * @return string|callable
     */
    public function body() { return $this->body; }
}
