<?php
namespace boru\boruaiweb\Pages;

use boru\boruaiweb\WebConfig;
use boru\boruaiweb\Http\Request;
use boru\boruaiweb\Http\HtmlResponse;
use boru\boruaiweb\Assets\AssetManager;
use boru\boruaiweb\Rendering\PhpTemplateRenderer;

class DashboardPageController
{
    /** @var WebConfig */
    private $config;

    public function __construct(WebConfig $config)
    {
        $this->config = $config;
    }

    public function handle(Request $req)
    {
        // Optional auth: if configured, require it.
        if ($this->config->auth) {
            $user = $this->config->auth->currentUser();
            if (!$user) {
                return new HtmlResponse(401, array('Content-Type' => 'text/plain; charset=UTF-8'), 'Not authenticated');
            }
        } else {
            $user = null;
        }

        $asset = new AssetManager($this->config->assetUrlPrefix);

        // Templates: user override first, then packaged defaults
        $packageTemplateDir = $this->packageTemplateDir();
        $renderer = new PhpTemplateRenderer($this->config->userTemplateDir, $packageTemplateDir);

        // Reference + references list
        $reference = (string)$req->param('reference', 'default');
        $references = array();

        if ($this->config->references && $user) {
            $references = (array)$this->config->references->listForUser($user, 10);
            // if no explicit reference, pick first existing if present
            if (($req->param('reference', null) === null) && !empty($references)) {
                $reference = (string)$references[0];
            }
        }

        // Instructions: allow app to pass via config, or set blank for now
        // (You can later add an InstructionsProviderInterface if you want)
        $instructionsHtml = '';

        $vm = array(
            'asset' => $asset,
            // keeps existing "pathPrefix" pattern working with minimal edits
            'pathPrefix' => $asset->prefix(),

            'user' => $user,
            'reference' => $reference,
            'references' => $references,
            'instructionsHtml' => $instructionsHtml,
        );

        $html = $renderer->render('webui.php', $vm);
        return HtmlResponse::ok($html);
    }

    private function packageTemplateDir()
    {
        // src/Pages -> src -> package root -> resources/templates
        $root = dirname(__DIR__); // .../src
        $pkgRoot = dirname($root); // package root
        return $pkgRoot . DIRECTORY_SEPARATOR . 'resources' . DIRECTORY_SEPARATOR . 'templates';
    }
}
