<?php
namespace boru\boruaiweb\Providers\Auth;

use boru\boruaiweb\Contracts\AuthProviderInterface;
use boru\boruaiweb\Domain\UserIdentity;

/**
 * PublicAccessAuthenticator
 *
 * Always returns a valid user identity (no login required).
 * Useful for internal tools, demos, or deployments behind a reverse-proxy auth layer.
 */
class PublicAccessAuthenticator implements AuthProviderInterface
{
    /** @var int|string */
    private $userId;
    /** @var string */
    private $userName;

    /**
     * @param int|string $userId
     * @param string $userName
     */
    public function __construct($userId = 1, $userName = 'Public')
    {
        $this->userId = $userId;
        $this->userName = (string)$userName;
    }

    /**
     * @return UserIdentity
     */
    public function currentUser()
    {
        return new UserIdentity($this->userId, $this->userName);
    }
}
